<?php 
class Approvals extends CI_Controller
{
    function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->library('pdf');
		$this->load->library('mass_pay');

		//require_once APPPATH . 'third_party/mass/samples/PPBootStrap.php';

	}

	function index()
	{
		$this->advertiser_approvals();
	}

	/*
	 * 
	 * name: advertiser approvals
	 * @param : null
	 * @return :list of advertiser need to be approve.
	 */	

	public function advertiser_approvals()
	{
		
		$data['breadcrumb'] = '';
		//$data['adv_app']=$this->rest->get('api/v1/approval/fetch_user','','php');
		$data['content'] = $this->load->view('approvals/advertiser_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
   
   
    /*
	 * 
	 * name: publisher
	 * @param : null
	 * @return : list of publisher need to be approve.
	 */	

	public function publisher_approvals()
	{
		$data['breadcrumb'] = '';
		//$data['adv_app']=$this->rest->get('api/v1/approval/fetch_user','','php');
		$data['content'] = $this->load->view('approvals/publisher_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	 /*
	 * 
	 * name: creatives
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function creative_approvals()
	{
		$data['breadcrumb'] = '';
		$data['campaign_list']=$this->rest->get('api/v1/countrywise_bidding/fetch_biddingcountrylist',array('api_key'=>get_session('api_key')),'php');	
		$data['lang_list']=$this->rest->get('api/v1/countrywise_bidding/fetch_languagelist',array('api_key'=>get_session('api_key')),'php');	
		
		$data['content'] = $this->load->view('approvals/creative_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function mobile_application_approvals()
	{
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('approvals/mobile_application_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_mobile_application()
	{
	    $fetch_mobile_application		= $this->rest->get('api/v1/approval/fetch_mobile_application',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($fetch_mobile_application);
	}
	
	/*
	 * 
	 * name: fetch_creative
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function fetch_creative()
	{
	    //$agencyid=get_session('agencyid');
		$fetch_creative		= $this->rest->get('api/v1/approval/fetch_creative',array('api_key'=>get_session('api_key')),'json');//print_r($this->rest->debug());exit;
		echo convert_to_datatable_format($fetch_creative);
	}
	
	/*
	 * 
	 * name: preview_creative
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function preview_creative($banner_id=FALSE)
	{  
		$data['banner_id']		=	$banner_id;
		
		$data['creative_list']=$this->rest->get('api/v1/approval/preview_creative',array('banner_id'=>$banner_id,'api_key'=>get_session('api_key')),'php'); 
		echo $this->load->view('approvals/modal_approvals/content/preview_creative',$data);
	}
	
	/*
	 * 
	 * name: advertiser_payment_approvals
	 * @param : null
	 * @return : list of creatives need to be approve.
	 */	

	public function advertiser_payment_approvals()
	{
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('approvals/payment_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
   /*
	* 
    * name: publisher_payment_approvals
	* @param : null
	* @return : list of creatives need to be approve.
	*/	
	public function publisher_payment_approvals()
	{
		$data['breadcrumb'] = '';		
		$data['content'] = $this->load->view('approvals/publisher_payment_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name: directcampaign_approvals
	 * @param : null
	 * @return : list of directcampaign need to be approve.
	 */	

	public function directcampaign_approvals()
	{	
		
		$data['breadcrumb'] = '';
		$data['key'] = '1';
		
		$data['content'] = $this->load->view('approvals/directcampaign_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function directcampaign_payment_approvals()
	{
		$data['breadcrumb'] = '';		
		$data['key'] = '0';		
		$data['content'] = $this->load->view('approvals/directcampaign_payapprovals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_dcampaign_list()
	{
		//$agencyid=get_session('agencyid');
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_dcampaign_list',array('api_key'=>get_session('api_key')),'json');
		#echo $this->rest->debug();exit;
		echo convert_to_datatable_format($payment_list);
	}

	/*
	 * 
	 * name: fetch_payment_list
	 * @param : null
	 * @return : list of payments need to be approve.
	 */	

	public function fetch_payment_list()
	{
		//$agencyid=get_session('agencyid');
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_payment_list',array('api_key'=>get_session('api_key')),'json');
		#echo $this->rest->debug();exit;
		echo convert_to_datatable_format($payment_list);
	}
	
	/*
	 * 
	 * name: payment_details_viewmore
	 * @param : null
	 * @return : show the modalbox with payment details.
	 */	 
	 public function payment_details_viewmore($id=FALSE)
	 {		
		$payment_detail=$this->rest->get('api/v1/approval/payment_viewmore',array('id'=>$id,'api_key'=>get_session('api_key')),'php'); 
		$data['payment_list']=$payment_detail[0];
		echo $this->load->view('approvals/modal_approvals/content/payment_detail_viewmore',$data); 
	 }
	 
	 
	/*
	* 
	* name: fetch_publisher_payment_list
	* @param : null
	* @return : list of payments need to be approve.
    */	
	public function fetch_publisher_payment_list()
	{
		//$agencyid=get_session('agencyid');
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_pub_payment_list',array('api_key'=>get_session('api_key')),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($payment_list);
	}
	
	
	/*
	* 
	* name: publisher_invoice_details
	* @param : null
	* @return : list of selected invoice id details.
    */	
	public function publisher_invoice_details($id=FALSE)
	{ 
		$network			=	$this->rest->get('api/v1/payments/fetch_network_details',array('api_key'=>get_session('api_key')),'php'); 
		$data['network']	=	$network[0];
		$data['invoice_details']=$this->rest->get('api/v1/approval/publisher_invoice_viewmore',array('id'=>$id,'api_key'=>get_session('api_key')),'php'); 
		//$data['invoice_list']=$invoice_detail[0];
		echo $this->load->view('approvals/modal_approvals/content/publisher_invoice_details',$data); 
	}
	
	/*
	* 
	* name: fetch_approval_advertiser
	* @param : null
	* @return : list the  advertiser need to be approve.
	*/	
	 public function fetch_approval_advertiser()
	 {  
	    $account_type = 'ADVERTISER';
		$app_adv	  = $this->rest->get('api/v1/approval/fetch_user',array("account_type"=>$account_type,"api_key"=>get_session('api_key')),'json');
	
		echo convert_to_datatable_format($app_adv);
		//$this->rest->debug(); exit;
	 }
	 

	 /*
	 * 
	 * name: fetch_approval_publisher
	 * @param : null
	 * @return : list the  publisher need to be approve.
	 */	
	 public function fetch_approval_publisher()
	 {  
	    $account_type   = 'TRAFFICKER';
		$app_pub		= $this->rest->get('api/v1/approval/fetch_user',array("account_type"=>$account_type,"api_key"=>get_session('api_key')),'json');
		echo convert_to_datatable_format($app_pub);
	 }
	 
	/*
	* 
	* name: campaign_approvals
	* @param : null
	* @return : list of campaign need to be approve.
	*/	

	public function campaign_approvals()
	{		
		$data['breadcrumb'] = '';
		$data['key'] = '1';
		
		$data['content'] = $this->load->view('approvals/campaign_approvals',$data,TRUE);
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	public function fetch_campaign_approval()	
	{
		$campaigns		= $this->rest->get('api/v1/campaign/fetch_approve_campaigns',array('api_key'=>get_session('api_key'), 'is_approve'=> '1'),'json');
	
		echo convert_to_datatable_format($campaigns);		
	}
	/*public function fetch_masspay_apprv_list()	
	{
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_pub_payment_approval',array('pay_gate'=>'2','api_key'=>get_session('api_key')),'json');
	
		echo convert_to_datatable_format($payment_list);		
	}*/
	
	public function make_paypal_mass_paymemt($pay_gate=false)	
	{
		
		
		//require_once APPPATH . 'third_party/mass/lib/PayPal/PayPalAPI/MassPayRequestType.php';
		$paypal_id = $this->input->post('pay_id');
		
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_mass_pub_payment_approval',array('pay_gate'=>$pay_gate,'paypal_id'=>$paypal_id,'api_key'=>get_session('api_key')),'json');
		$data['payment_list'] = $payment_list;
		$myArray = json_decode($payment_list, true);
	
		
		
		//$massPayRequest = new MassPayRequestType();
		//$massPayRequest->MassPayItem = array();
			
		for($i=0; $i<count($myArray); $i++)
		{
		//$masspayItem = new MassPayRequestItemType();
		$masspayItem= $this->mass_pay->masspayItem('USD', $myArray[$i]['amount'],$myArray[$i]['paypal_id']);
		
		//$masspayItem->Amount = new BasicAmountType('USD', $myArray[$i]['amount']);
		/*if($myArray[$i]['paypal_id'] == $myArray[$i]['paypal_id']) {
		
		$masspayItem->ReceiverEmail = $myArray[$i]['paypal_id'];
		} */
	$massPayRequest =	 $this->mass_pay->massPayRequest($masspayItem);
		
	//	$massPayRequest->MassPayItem[] = $masspayItem;
	
		}
		//$massPayReq = new MassPayReq();
		//$massPayReq->MassPayRequest = $massPayRequest;
	$massPayReq =	$this->mass_pay->MassPayReq($massPayRequest);
		
		//$paypalService = new PayPalAPIInterfaceServiceService();
		if($massPayReq)
		{
		$massPayResponse = $this->mass_pay->paypalService($massPayReq);
		}
		else
		{
		$massPayResponse ='';
		}
	
		if(isset($massPayResponse)) {
			if($massPayResponse->Ack == "Success")
			{
				
			$paypal_appr=array();
			for($i=0; $i<count($myArray); $i++)
			{
			if(!empty($paypal_appr))
			{
				$paypal_appr[] .= $myArray[$i]['paypal_id'];
				
			}
			else
			{
				$paypal_appr[] =$myArray[$i]['paypal_id'];
			}
			
			}
			
			$payment_approval	= $this->rest->get('api/v1/approval/masspay_pub_payment_approval',array('pay_id'=>$paypal_appr,'api_key'=>get_session('api_key')),'json');
		
			echo json_encode($massPayResponse->Ack);
		
			}
			else
			{
			echo json_encode($massPayResponse);
			}
		
		
		}
		
		
	}
	
	/*
   * 
   * name: download_mass_payment
   * @param : invoice_id
   * @return : downloads the invoice in pdf version
   */
   
	public function download_mass_payment($pay_gate=false,$export=false)
	{
		
		$payment_list	  = $this->rest->get('api/v1/approval/fetch_pub_payment_approval',array('pay_gate'=>$pay_gate,'api_key'=>get_session('api_key')),'json');
		$myArray = json_decode($payment_list, true);//print_r($payment_list);
		if($export =='PDF')
		{
		
			if($payment_list)
			{
				//$data['payment_list'] = $payment_list;
				$data['payment_data'] = $myArray;
				$data['payment_gateway'] = $pay_gate;
				//$pub_account_id = $invoice_information[0]['account_id'];
				//$publisher			=	$this->rest->get('api/v1/payments/fetch_publisher_details',array('id'=>$pub_account_id,'api_key'=>get_session('api_key')),'php'); 
				//$data['payment_list']	=	$payment_list[0];					
				$pdf_name = $this->config->item('prod_name').'_mass_payment_'.date('d.m.Y');
				//echo $this->load_view('admin/approvals/download_mass_payment',$data);
				$this->pdf->load_view('admin/approvals/download_mass_payment',$data);
				$this->pdf->render();
				$this->pdf->stream("$pdf_name.pdf");	
			}else{
				return FALSE;
			}
		}
		
		else if($export =='CSV')
		{
			if($pay_gate == '2'){
				$filename='paypal_mass_payment.csv';
				header('Content-type: text/csv');
				header('Content-Disposition: attachment; filename='.$filename);

				$csv = "";
				
				for($i=0;$i<count($myArray);$i++){
					
					$csv.= $myArray[$i]['paypal_id'].','.$myArray[$i]['amount'].',USD,'.$myArray[$i]['invoice_code'].','.$myArray[$i]['name']."\n";
				}
			}
			else if($pay_gate == '3'){
				$filename='webmoney_mass_payment.csv';
				header('Content-type: text/csv');
				header('Content-Disposition: attachment; filename='.$filename);

				$csv = "";
				
				for($i=0;$i<count($myArray);$i++){
					$k=$i+1;
					$csv.= $myArray[$i]['bank_account_no'].';'.$myArray[$i]['amount'].';'.$myArray[$i]['invoice_code'].';'.$k."\n";
				}
			}
			print_r($csv);
		}
		else if($export =='DAT')
		{
			if($pay_gate == '2'){
				$filename='paypal_mass_payment.dat';
				header('Content-type: text/dat');
				header('Content-Disposition: attachment; filename='.$filename);

				$csv = "";
				
				for($i=0;$i<count($myArray);$i++){
					
					$csv.= $myArray[$i]['paypal_id'].','.$myArray[$i]['amount'].',USD,'.$myArray[$i]['invoice_code'].','.$myArray[$i]['name']."\n";
				}
			}
			
			print_r($csv);
		}
		else if($export =='TEXT')
		{
            $data_arrays = array ();
			$delimiter = "\t";
			if($pay_gate == '2'){
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=paypal_mass_payment.txt");
			
				//$myArray = json_decode($payment_list, true); 
				$offerArray = array();
				for($i=0;$i<count($myArray);$i++){
				
					$data_arrays[] = array($myArray[$i]['paypal_id'],$myArray[$i]['amount'],"USD",$myArray[$i]['invoice_code'],$myArray[$i]['name']);
				}
				
				foreach ($data_arrays as $subArrayKey => $subArray) {
					//Separate each datapoint in the row with the delimiter
					$dataRowString = implode($delimiter, $subArray);
					print $dataRowString . "\r\n";
				}
			}
			else if($pay_gate == '3'){
				header('Content-type: text/tab-separated-values');
				header("Content-Disposition: attachment;filename=webmoney_mass_payment.txt");
			
				//$myArray = json_decode($payment_list, true); 
				$offerArray = array();
				for($i=0;$i<count($myArray);$i++){
				
					$data_arrays[] = array($myArray[$i]['bank_account_no'],$myArray[$i]['amount'],$myArray[$i]['invoice_code']);
				}
				
				foreach ($data_arrays as $subArrayKey => $subArray) {
					//Separate each datapoint in the row with the delimiter
					$dataRowString = implode($delimiter, $subArray);
					print $dataRowString . "\r\n";
				}
			}

		}
		else if($export =='XML')
		{
			if($pay_gate == '3'){
				
				header('Content-Type: text/xml');
				header("Content-Disposition: attachment;filename=webmoney_mass_payment.xml");
	

				$xml = new SimpleXMLElement('<payments/>');
				
				
				$xml->addAttribute("xmlns", "http://tempuri.org/ds.xsd");
				for($i=0;$i<count($myArray);$i++){
					$game = $xml->addChild("payment");
					 $game->addChild('Destination',$myArray[$i]['bank_account_no']);
					$game->addChild('Amount', $myArray[$i]['amount']);
					$game->addChild('Description', $myArray[$i]['invoice_code']);
					$game->addChild('Id', $myArray[$i]['invoice_code']);
					
				}

				print($xml->asXML());
			}
		}
	
	}
}
