<?php 
class Antifraud_click_stats extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->anti_fraud();		
	}
	
	/*
	 * 
	 * name		:anti-fraud clicking
	 * @param   :Null
	 * @return  :List antifraud_information for Admin
	 * 		
	 */	
	public function anti_fraud()
	{		
		$data['page_title'] = "Anti fraud clicking";	
		$data['breadcrumb'] = '';
        $api_key				=	get_session('api_key');
		
        $data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_PUBLISHER']['CHART']['DEFAULT_INTERVAL']);
						
		$data['content'] = $this->load->view('analytics/anti_fraud',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	/*
	 * 
	 * name		:fetch_anti_fraud_stats_list
	 * @param   :Null
	 * @return  :List antifraud_valid click information for Admin
	 * 		
	 */	
	public function fetch_anti_fraud_stats_list()
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
				
		$input = array(
						'api_key'		=>	$api_key,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		//$input['display_type'] 	= 'TABLE';
			
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='' && $interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['stat_type']		=	($type!=false)?$type:'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_list',$input,'json');
			//print_r($input);exit;
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_list',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
		/*$antifraud_stats	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_list',array('api_key'=>get_session('api_key')),'json');				
		echo convert_to_datatable_format($antifraud_stats);*/
	}
	
	
		/*
	 * 
	 * name		:fetch_anti_fraud_stats_list
	 * @param   :Null
	 * @return  :List antifraud_valid impression information for Admin
	 * 		
	 */	
	public function fetch_anti_fraud_imp_stats_list()
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
				
		$input = array(
						'api_key'		=>	$api_key,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		//$input['display_type'] 	= 'TABLE';
			
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='' && $interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['stat_type']		=	($type!=false)?$type:'PLATFORM';
			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_imp_list',$input,'json');
			//print_r($input);exit;
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_imp_list',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
		/*$antifraud_stats	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_list',array('api_key'=>get_session('api_key')),'json');				
		echo convert_to_datatable_format($antifraud_stats);*/
	}

	
	
	/*
	 * 
	 * name		:fetch_anti_valid_list
	 * @param   :Null
	 * @return  :List antifraud_valid imp information for Admin
	 * 		
	 */	
	public function fetch_anti_valid_imp_list()
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
				
		$input = array(
						'api_key'		=>	$api_key,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		//$input['display_type'] 	= 'TABLE';
			
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='' && $interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_valid_imp_stats_list',$input,'json');
			//print_r($input);exit;
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_valid_imp_stats_list',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
		
		/*$antifraud_valid_list	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_valid_stats_list',array('api_key'=>get_session('api_key')),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($antifraud_valid_list);*/
	}
	
		/*
	 * 
	 * name		:fetch_anti_valid_list
	 * @param   :Null
	 * @return  :List antifraud_valid click information for Admin
	 * 		
	 */	
	public function fetch_anti_valid_list()
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
				
		$input = array(
						'api_key'		=>	$api_key,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		//$input['display_type'] 	= 'TABLE';
			
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='' && $interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{			
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_valid_stats_list',$input,'json');
			//print_r($input);exit;
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_valid_stats_list',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
		
		/*$antifraud_valid_list	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_valid_stats_list',array('api_key'=>get_session('api_key')),'json');
		//$this->rest->debug();
		echo convert_to_datatable_format($antifraud_valid_list);*/
	}

	/*
	 * 
	 * name		:fetch_anti_penality_list
	 * @param   :Null
	 * @return  :List antifraud_penality information for Admin
	 * 		
	 */	
	public function fetch_anti_penality_list()
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
						
		$input = array(
						'api_key'		=>	$api_key,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		//$input['display_type'] 	= 'TABLE';
			
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='' && $interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_penality_list',$input,'json');
			//print_r($input);exit;
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_penality_list',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
		/*$antifraud_penality	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_penality_list',array('api_key'=>get_session('api_key')),'json');
		
		echo convert_to_datatable_format($antifraud_penality);*/
	}	
	
	
		/*
	 * 
	 * name		:fetch_anti_penality_list
	 * @param   :Null
	 * @return  :List antifraud_penality imp information for Admin
	 * 		
	 */	
	public function fetch_anti_penality_imp_list()
	{
		$interval	= 	clean_data($this->input->post('interval'));
		$environment= 	clean_data($this->input->post('device'));
		$from_date	= 	clean_data($this->input->post('from_date'));
		$to_date	= 	clean_data($this->input->post('to_date'));
		
		$metrics	= 	clean_data($this->input->post('metrics'));
		
		$pub_id		= 	clean_data($this->input->post('publisher'));
		$sit_id		= 	clean_data($this->input->post('site'));
		$adb_id		= 	clean_data($this->input->post('adblock'));
		$country	= 	clean_data($this->input->post('country'));
		$adsize		= 	clean_data($this->input->post('adsize'));
		
		$dimens		= 	clean_data($this->input->post('dimensions'));

		$api_key 	= 	get_session('api_key');
						
		$input = array(
						'api_key'		=>	$api_key,
						'interval'		=>	$interval,
						'environment'	=>	$environment					
					  );
		
		//$input['display_type'] 	= 'TABLE';
			
		if($pub_id != 'all'){
			$input['pub_account_id'] = ($pub_id)?((is_array($pub_id))?$pub_id:explode(',',$pub_id)):'';
		}
		
		if($sit_id != 'all'){
			$input['site_id'] = ($sit_id)?((is_array($sit_id))?$sit_id:explode(',',$sit_id)):'';
		}
		
		if($adb_id != 'all'){
			$input['adblock_id'] = ($adb_id)?((is_array($adb_id))?$adb_id:explode(',',$adb_id)):'';
		}
				
		if($country != 'all'){
			$input['country'] = ($country)?((is_array($country))?$country:explode(',',$country)):'';
		}
		
		if($adsize != 'all'){
			$input['adsize'] = ($adsize)?((is_array($adsize))?$adsize:explode(',',$adsize)):'';
		}
				
		if($from_date != FALSE){
			$input['date_from'] = $from_date;
		}	
		
		if($to_date != FALSE){
			$input['date_to'] = $to_date;
		}
		
		$input['metrics'] 	= 	($metrics)?((is_array($metrics))?$metrics:explode(',',$metrics)):'';	
		$input['dimensions']= 	($dimens)?((is_array($dimens))?$dimens:explode(',',$dimens)):'';
		
		if($interval!='' && $interval!='CUMULATIVE')
		{
			if(!empty($input['dimensions']))
			{
			 	array_unshift($input['dimensions'],$interval);
			}
			else
			{
				$input['dimensions']	=	array($interval);
			}			
		}		
		
		if(!empty($input['dimensions']) && is_array($input['dimensions']))
		{			
			$input['columns']	=	array_merge($input['metrics'],$input['dimensions']);   
		}
		else
		{
			$input['columns']	=	$input['metrics'];
		}
		
		if($format!='php')
		{
			$input['search_term']	=	$_REQUEST['sSearch'];
			
			if(isset($_REQUEST['iDisplayStart'])){
				$input['start'] = $_REQUEST['iDisplayStart'];
			}
			
			if(isset($_REQUEST['iDisplayLength'])){
				$input['end'] = ($_REQUEST['iDisplayLength']!='-1')?$_REQUEST['iDisplayLength']:'';
			}
			
			$input['datatable_obj'] = $_REQUEST;		
		
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_penality_imp_list',$input,'json');
			//print_r($input);exit;
			//$this->rest->debug();
		
			echo $data;
		}
		else
		{
			$input['stat_type']		=	'EXPORT';
			$input['search_term']	=	'';
			
			$input['datatable_obj']['sSearch'] = '';
			$input['datatable_obj']['sEcho'] = '';
			$input['result_type'] 	= 'DATA';
			
			$data			= $this->rest->post('api/v1/antifraud_click_stats/fetch_anti_penality_imp_list',$input,'json');	
			//$this->rest->debug();
			
			return json_decode($data);
		}
		/*$antifraud_penality	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_penality_list',array('api_key'=>get_session('api_key')),'json');
		
		echo convert_to_datatable_format($antifraud_penality);*/
	}	
	
	public function fetch_anti_fraud_stats_filter($from_date=FALSE,$to_date=FALSE)
	{
		$antifraud_stats	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_filter',array('api_key'=>get_session('api_key'),'f_date'=>$from_date,'t_date'=>$to_date),'json');
		
		echo convert_to_datatable_format($antifraud_stats);
	}
	
	public function fetch_anti_penality_filter($from_date=FALSE,$to_date=FALSE)
	{
		$antifraud_stats	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_penality_stats_filter',array('api_key'=>get_session('api_key'),'f_date'=>$from_date,'t_date'=>$to_date),'json');
		
		echo convert_to_datatable_format($antifraud_stats);
	}
	
	public function fetch_anti_valid_filter($from_date=FALSE,$to_date=FALSE)
	{
		
		$antifraud_valid_list	  = $this->rest->get('api/v1/antifraud_click_stats/fetch_anti_fraud_stats_filter',array('api_key'=>get_session('api_key'),'f_date'=>$from_date,'t_date'=>$to_date),'json');
		
		echo convert_to_datatable_format($antifraud_valid_list);
	}
	public function impression()
	{		
		$data['page_title'] = "Anti fraud Impression";	
		$data['breadcrumb'] = '';
        $api_key				=	get_session('api_key');
		
        $data['pub_data'] 		=	$this->rest->get('api/v1/report/fetch_publisher',array('api_key'=>$api_key),'php');
		$data['sites']			=	$this->rest->get('api/v1/report/fetch_sites',array('api_key'=>$api_key),'php');
		$data['adblock']		= 	$this->rest->get('api/v1/report/fetch_adblocks',array('api_key'=>$api_key),'php');
		
		$data['country']		=	$this->rest->get('api/v1/utilities/countrylist',array('api_key'=>$api_key),'php');
		
		$data['size']			= 	$this->rest->get('api/v1/utilities/sizelist',array("api_key"=>$api_key),'php');
		
		$set 				= 	$this->config->item('report_config');
		$data['search_date']= 	get_search_date($set['ADMIN']['REPORT_PUBLISHER']['CHART']['DEFAULT_INTERVAL']);
						
		$data['content'] = $this->load->view('analytics/anti_fraud_impression',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
}
