<?php 
class Adblock_domains extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->load->helper('download');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
	}
	
	function index()
	{
		$this->manage_domains();		
	}
	
	/*
	 * 
	 * name		:Manage_Domains
	 * @param   :Null
	 * @return  :List All Domains for Admin
	 * 		
	 */	
	public function manage_domains()
	{
		$data['page_title'] = "Adblock Domains";	
		$data['breadcrumb'] = '';		
		$data['country_list']		= $this->rest->get('api/v1/adblock_domains/adblock_domain_list',array('api_key'=>get_session('api_key')),'php');	
		$data['content'] = $this->load->view('adblock_domains/domain_list',$data,TRUE);		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	
	
	function adblock_domains_download_file()
	{ 
		$data = file_get_contents("./csv/upload/sample_file.csv"); // Read the file's contents			
		$name = 'samplefile.csv';
		force_download($name, $data);  
	}
	
	function adblock_domains_download_file_txt()
	{ 
		$data = file_get_contents("./csv/upload/sample_file.txt"); // Read the file's contents			
		$name = 'samplefile.txt';
		force_download($name, $data);    
	}
	/*
	 * 
	 * name		:fetch_geo_list
	 * @param   :Null
	 * @return  :List list of geo settings
	 * 		
	 */
	public function adblock_domain_list() 
	{
		$domain_sett		= $this->rest->get('api/v1/adblock_domains/fetch',array('api_key'=>get_session('api_key')),'json');
		echo convert_to_datatable_format($domain_sett);
	}
	
		
	/*
	 * 
	 * name		: edit_domain
	 * @param   : Null
	 * @return  : List all the domain for admin
	 */	
	 	
	public function edit_domain($domain_id=FALSE)
	{	
		$sett_list					= $this->rest->get('api/v1/adblock_domains/fetch_data',array('api_key'=>get_session('api_key'),'domain_id'=>$domain_id),'php');
		$data['domain_val']			= $sett_list[0];		
		echo $this->load->view('adblock_domains/modal_domains/content/edit_domain',$data);
	}
	
}
