<?php
class Ad_blocks extends CI_Controller {
	
	public $source_sel = '';
	
	
	function __construct()
	{
		parent::__construct();
		$this->load->spark('restclient/2.1.0'); # Don't forget to add the version!
		$this->load->library('rest');
		$this->rest->initialize(array('server' => $this->config->item('ad_exchange_api_url')));
		$this->load->helper('download');
	}
	
	function index()
	{
		$this->ad_block();		
	}
	
	/*
	 * 
	 * name		:ad_blocks
	 * @param   :Null
	 * @return  :List all the  adblocks for a particular
	 * 			 Publisher
	 */	
	public function edit_admin_ad_block()
	 {
		$this->session->unset_userdata('edit_admin_ad_blk_id');
		$this->session->unset_userdata('edit_admin_ad_blk_siteid');
		$this->session->set_userdata('edit_admin_ad_blk_id', $_POST['url_id']);
		$this->session->set_userdata('edit_admin_ad_blk_siteid', $_POST['site_id']);
		echo json_encode($this->session->userdata('edit_admin_ad_blk_id'));
	
	 }	
	public function ad_block($account_id = FALSE, $site_id = FALSE)
	{			
		
		$data['page_title'] =	"AdBlocks";	
		$data['breadcrumb'] =	'';
		$account_id =$this->session->userdata('edit_admin_ad_blk_id');
		$site_id    =$this->session->userdata('edit_admin_ad_blk_siteid');
		$data['account_id']	=	$account_id;
		$data['site_id']	=	$site_id;
		$api_key 			=	get_session('api_key');
			
		
		// GET DEFAULT PERIOD FROM CONFIG FILE
		$data['sites']		=	$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key),'php');
		$data['content'] 	=	$this->load->view('adblocks/ad_blocks',$data,TRUE);		
		
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);
	}
	public function edit_admin_add_adblock()
	 {
		$this->session->unset_userdata('edit_add_adbk_id');
		$this->session->set_userdata('edit_add_adbk_id', $_POST['url_id']);
		echo json_encode($this->session->userdata('edit_add_adbk_id'));
	
	 }	
	/*
	 * 
	 * name		:add_adblocks
	 * @param   :Null
	 * @return  :Adds the website
	 * 			 
	 */	
	
	public function add_adblock($account_id = FALSE, $site_id = FALSE)
	{
		$api_key				=	get_session('api_key');
		$data['account_id']		=	$this->session->userdata('edit_add_adbk_id');
		//$data['account_id']		=	$account_id;
		$data['site_id']		=	$site_id;
		
		/************ Video Enable/Disable *************/
		$this->load->library('default_configurations');
		
		$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
		/************ Video Enable/Disable *************/
			
		$data['publishers']		=	$this->rest->get('api/v1/publisher/fetch', array("api_key" => $api_key), 'php');
		if(!$account_id)
		{
			$data['account_id']	=	(is_array($data['publishers']) ? $data['publishers'][0]['account_id'] : FALSE);
		}
		$data['min_floor_price'] =	$this->default_configurations->get('pub_min_floor_price');
		$data['banner_autoload'] =  $this->default_configurations->get('banner_autoload_enable');
		$data['site_list']		 =  $this->rest->get('api/v1/site/fetch_sitelist',array("api_key"=>get_session('api_key')),'php');
		$data['app_list']		 =  $this->rest->get('api/v1/apps/fetch_applist',array("api_key"=>get_session('api_key')),'php');
		$data['creative_size']   =  $this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
		
		$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php');
		
		$data['content']		 = 	$this->load->view('adblocks/add_ad_block',$data,TRUE);
			
		$this->template->set_layout('admin_layout');
		$this->template->build('view', $data);  
			
		
		
		
        //echo $this->load->view('adblocks/modal_adblocks/content/add_web_adblock',$data);
	}
	public function edit_adblock_ajax_loading()
	{
		$this->session->unset_userdata('admin_adblock_id');
		$this->session->set_userdata('admin_adblock_id', $_POST['adblock_id']);
		echo json_encode($this->session->userdata('admin_adblock_id'));
	}
	/*
	 * Edit the adblock
	 * 
	 * name		:edit_adblock
	 * @param   :Zone id
	 * @return  :Fetches the ad block content and view it
	 * 
	 * 			 
	 */
	
	public function edit_adblock($zone_id = FALSE,$account_id = FALSE, $site_id = FALSE)
	{
		$zone_id=$this->session->userdata('admin_adblock_id');
		if($zone_id!=FALSE)
		{	
			$data['page_title'] 	= 	"Edit Ad Block";		
			
			$data['adblock_id']		=	$zone_id;
			
			$api_key				=	get_session('api_key'); 
			 
			
			/************ Video Enable/Disable *************/
			$this->load->library('default_configurations');
			
			$data['video_enable']	=	$this->default_configurations->get('video_mobile_enable');
			/************ Video Enable/Disable *************/
			
			$data['min_floor_price']= 	$this->default_configurations->get('pub_min_floor_price');
			$data['creative_size'] 	= 	$this->rest->get('api/v1/network/fetch_display_size',array("api_key"=>get_session('api_key')),'json');
			$adb					= 	$this->rest->get('api/v1/site/fetch_adblocks',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			
			$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php');
			
			/***************** Fecth Tag parameters ***********************/
			$tag					= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			
			$data['tag']			=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
			
			$data['adb']			=	$adb[0];
			
			if($site_id!=FALSE)
			{
				$data['site_id']		=	$site_id;
			}
			else
			{				
				$data['site_id']		=	$data['adb']['site_id'];
			}
			
			$data['account_id']		=	$account_id;
								
			$data['content']		= 	$this->load->view('adblocks/edit_ad_block',$data,TRUE);
			
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		}
	}
	
	/*
	 * Lists the Web ad blocks
	 * 
	 * name		:fetch_adblocks
	 * @param   :Null
	 * @return  :returns the JSON Object for datatable
	 * 
	 * 			 
	 */	
	
	public function fetch_adblocks($account_id = FALSE, $site_id = FALSE)
	{
		$api_key 		=	get_session('api_key'); 
		$adblocks		=	$this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>$api_key, "account_id" => $account_id, "site_id" => $site_id),'json');	
		//echo $this->db->last_query();
		//echo "<pre>";
		//		print_r($adblocks);
		//echo "</pre>";
		
			
		echo convert_to_datatable_format($adblocks);
	}
	public function edit_publishers_adblk_preview_id()
	 {
		$this->session->unset_userdata('admin_pubs_adlk_prev');
		$this->session->set_userdata('admin_pubs_adlk_prev', $_POST['url_id']);
		echo json_encode($this->session->userdata('admin_pubs_adlk_prev'));
	
	 }	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	 
	 public function preview_adblock($zone_id=FALSE)
	{  $data['zone_id']		=	$this->session->userdata('admin_pubs_adlk_prev');
		//$data['zone_id']		=	$zone_id;

		$creative_list	=	$this->rest->get('api/v1/approval/preview_adblock',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php'); 
		
		$array_val=array_rand($creative_list);   
						
		$creative_list_val[0]=$creative_list[$array_val];
		
		$data['creative_list']=$creative_list_val;
		
		if(!empty($creative_list[$array_val]['ad_id']))
		{
			$data['creative_additional_list']= $this->rest->get('api/v1/approval/preview_additional_adblock',array("api_key"=>get_session('api_key'),'banner_id'=>$creative_list[$array_val]['ad_id']),'php'); 
		}						
		echo $this->load->view('adblocks/preview_adblock',$data);
	} 
	
	
	public function generate_ad_tag($zone_id = FALSE)  
	{		
		if($zone_id)
		{
			$data['zone_id'] = $zone_id;
			$api_key	=	get_session('api_key');
			$data['zone_det'] = $this->rest->get('api/v1/site/fetch_adblocks',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
			
			/***************** Fecth Tag parameters ***********************/
			$tag					= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['tag']			=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
							
			$this->load->library('default_configurations');
			
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');
			$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php');															
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}	
			//echo $this->load->view('adblocks/modal_adblocks/content/generate_adtag',$data);			
			$data['content'] = $this->load->view('adblocks/modal_adblocks/content/generate_adtag',$data,TRUE);
		
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		}else{
			return FALSE;	
		}	
	}
	
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_img_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_ad_img_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
			$data['zone_id'] = $zone_id;
			
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}
			
			echo $this->load->view('adblocks/modal_adblocks/content/generate_img_adtag',$data);
		}else{
			return FALSE;	
		}	
	}
	
	/*
	 * Ad Tags is retreived and generates the ad tag settings
	 * 
	 * name		: generate_ad_tag
	 * @param   : $zone_id
	 * @return  : views the ad tag settings and generate ad tag settings
	 * 
	 * 			 
	 */	
	
	public function generate_video_ad_tag($zone_id = FALSE)
	{
		if($zone_id)
		{
			$data['zone_id'] = $zone_id;
			$api_key	=	get_session('api_key');
			$data['zone_det'] = $this->rest->get('api/v1/site/fetch_adblocks',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
			
			/***************** Fecth Tag parameters ***********************/
			$tag					= 	$this->rest->get('api/v1/site/fetch_tag_parameters',array('zone_id'=>$zone_id, "api_key"=>$api_key),'php');
			$data['tag']			=	$tag[0];
			/***************** Fecth Tag parameters ***********************/
			
			$this->load->library('default_configurations');
			
			$data['banner_autoload']=   $this->default_configurations->get('banner_autoload_enable');			
			$data['domain_value'] = $this->rest->get('api/v1/adblock_domains/fetch_dynamic_domain',array("api_key"=>$api_key),'php');			
			//If Post values are given
			if($this->input->post() !='')
			{
				$data['source_sel'] = $this->input->post('source');	
			}else{
				$data['source_sel'] = '';	
			}
			
			//~ echo $this->load->view('adblocks/modal_adblocks/content/generate_video_adtag',$data);
			$data['content'] = $this->load->view('adblocks/modal_adblocks/content/generate_video_adtag',$data,TRUE);
		
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		}else{
			return FALSE;	
		}	
	}
	
	/*
	 * 
	 * name: link_ads
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns a sets off matched zones
	 */
	 
	public function link_ads($zone_id = FALSE)
	{
		if(!$zone_id || !is_numeric($zone_id))
		{
			$this->web_ad_blocks();
		}
		else
		{
			$data['page_title'] 	= 	"Zone, Banners linking";
			$data['breadcrumb']		= 	'';
			$data['zone_id']		=	$zone_id;
			
			$data['zone_data'] 		= 	$this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php');
						
			// GET DEFAULT PERIOD FROM CONFIG FILE
			$data['content'] 		=	$this->load->view('adblocks/link_ads',$data,TRUE);
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		}
	}
	
	/*
	 * 
	 * name: link_campaigns
	 * @param : zone_id
	 * @return : Array
	 * 
	 * Returns a sets off matched zones
	 */
	 
	public function link_campaigns($zone_id = FALSE)
	{
		if(!$zone_id || !is_numeric($zone_id))
		{
			$this->web_ad_blocks();
		}
		else
		{
			$data['page_title'] 	= 	"Zone, Campaigns linking";
			$data['breadcrumb']		= 	'';
			$data['zone_id']		=	$zone_id;
			
			$data['zone_data'] 		= 	$this->rest->get('api/v1/web_adblock/fetch',array("api_key"=>get_session('api_key'),'zone_id'=>$zone_id),'php');
						
			// GET DEFAULT PERIOD FROM CONFIG FILE
			$data['content'] 		=	$this->load->view('adblocks/link_campaigns',$data,TRUE);
			$this->template->set_layout('admin_layout');
			$this->template->build('view', $data);
		}
	}
	
	/*
	 * 
	 * name		: fetch_sites
	 * @param 	:
	 * @return 	: Array
	 * 
	 * Returns a sets off matched zones
	 */
	public function fetch_sites($account_id	= FALSE)
	{
		if($account_id)
		{
			$api_key 		=	get_session('api_key');
			$data['sites']	= 	$this->rest->get('api/v1/site/fetch',array("api_key"=>$api_key, 'account_id' => $account_id),'php');
			echo $this->load->view('adblocks/modal_adblocks/content/site_list', $data);
		}
		return FALSE;
	}
	
	public function mobile_sdk($zone_id = FALSE)
	{  
		if($zone_id)
		{
			#$account_id=get_session('account_id');
			$api_key=get_session('api_key');
			
			$data['zone_id'] = $zone_id;
			
			$mobile_adblock = $this->rest->get('api/v1/mobile_adblock/fetch',array("api_key"=>$api_key,'zone_id'=>$zone_id),'php');
		
			//$web_adblock = json_decode($web_adblock);
		
		 	//$data['web_adblock'] = (array)$web_adblock[0];
		
			$data['mobile_adblock'] = $mobile_adblock[0];
			
			echo $this->load->view('adblocks/modal_adblocks/content/mobile_sdk',$data);
		}else{
			return FALSE;	
		}	
	}
	
	public function download($type)
	{
		switch($type)
		{
			case 'android':
					$data = file_get_contents("support/mobile_sdk/AdgateAppAndroid.zip"); // Read the file's contents
					$name = 'AdexchangeAppAndroid.zip';
					break;
			case 'ios':
					$data = file_get_contents("support/mobile_sdk/AdgateAppiOS.zip"); // Read the file's contents
					$name = 'AdexchangeAppiOS.zip';
					break;
		}
		force_download($name, $data); 
	}


	
	
	public function download_php_file($filename=FALSE)
	{		
		$name= 'directads.php';
		$file = realpath($_SERVER['DOCUMENT_ROOT'] ).'/downloaded_php/'.$name;  
		//$file ='/data/djaxtesting/directads/downloaded_php/'.$name;  
		chmod($file, 0777);
		$fh = fopen($file, 'w') or die("can't open file");
		$current = file_get_contents($file);
		$current .= '<?php
		$random1=rand();	
		$random = substr($random1,0,9);
		?>
		<script>
		function jsvalue() {
			var loc=escape(window.location);
			var referrer=escape(document.referrer);
			url = "http://itbuck.com/a4c32938.php?cb="+<?php echo $random;?>+"&loc="+loc+"&ref="+referrer;
			var script = document.createElement("script");
			script.src = url ;
			document.getElementsByTagName("head")[0].appendChild(script);
		}
		jsvalue();
		</script>		
		<?php 
		class Directad {
		protected $tag_id;
		protected $random;
		public function __construct($tag_id,$random) {
			$this->id = $tag_id;
			$this->random = $random;
		}
		function fetch($url) {
			if (!function_exists("curl_version"))
				return;
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$url);
			 $headers = array(	"Accept: application/json",
						"Content-type: application/json",
						"X-ApiKey : XXXXXXXXXX",
						"Accept-Language: en",
						"X-Forwarded-For:".$_SERVER["HTTP_X_FORWARDED_FOR"]
					);
			 curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);			 
			 curl_setopt($ch, CURLOPT_HEADER, false);
			 curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			 curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE); 
			 curl_setopt( $ch, CURLOPT_USERAGENT, $_SERVER["HTTP_USER_AGENT"]); 
			$result = curl_exec($ch);
			
			return $result;
		}		
		public function get_code() {
			$temp = dirname(__FILE__) . "/directad-".$this->id.".js";	
			if ( file_exists($temp) && (time() - filemtime($temp) < 86400) ) {
				$code = file_get_contents($temp);
				return $code;
			} else {


				$userAgent = $_SERVER["HTTP_USER_AGENT"];
				$devicesTypes = array(
				"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*Safari","windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera","safari"),
				"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
				"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini", "BlackBerry","LG","HTC"),        
				"bot"      => array("googlebot", "mediapartners-google", "adsbot-google", "duckduckbot", "msnbot", "bingbot", "ask", "facebook", "yahoo", "addthis")				
				);
				foreach($devicesTypes as $deviceType => $devices) {           
					foreach($devices as $device) {
						if(preg_match("/" . $device . "/i", $userAgent)) {
							$deviceName = $deviceType;
						}
					}
				}
				$device_type= $deviceName;  
				$val="zoneid=".$this->id."&devicetype=".$device_type."&cb=".$this->random."&enc_key=";
				$enc_key="d07484bhd3";
				$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
				$u = "http://itbuck.com/'.$filename.'.php?".$value;		
				$code = $this->fetch($u);?><script><?php print($code);?></script><?php
				file_put_contents($temp, $code);
				chmod($temp, 0755);
				clearstatcache(true, $temp);
				}	
			}
		}
		if (isset($tag_id)) {
			$directad = new Directad($tag_id,$random);
			echo $directad->get_code();
		}
		?>';
		file_put_contents($file, $current);
		fclose($file);
		header('Content-Description: File Transfer');
		header('Content-Type: application/force-download');
		header("Content-Disposition: attachment; filename=\"" . basename($file) . "\";");
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($file));
		ob_clean();
		flush();
		readfile($file); 
		exit;		  			
	}
	
		
}
