<?php

class user_authentication

{
    
	public  $account_id	  = '';

	public  $client_id    = '';

	public  $account_type = '';

	public  $agency_id    = '';

	public  $affiliate_id = '';

	public  $network_account_id='';

	public  $manager_user_id ='';

	public  $manager_role_id ='';
	
	public  $manager_adv_pub_id ='';

	public  $network_id='';

	public  $user_id='';

	public  $default_advertiser_client_id='';

	public  $default_advertiser_account_id='';

	public  $error        = '';

	public  $is_default	  =	'';

	/***********************************

	 * Method : is_valid_apikey

	 * @params : api_key

	 * description : returns the each default configuration value for each item

	 ************************************/

	public function is_valid_apikey($key)

	{ 
		
        //CONFIG FILES
		$this->CI =& get_instance();
   	 	$this->CI->load->config('rest');

	    //Call to another function to fetch all details
		$details=$this->fetch_api_key_details($key);
		
		
		
       
		//Get domains from rest config file
		$default_domains=$this->CI->config->item('allowedOrigins');
		
		//Get requested domain host name
	    if(isset($_SERVER['HTTP_REFERER'])){ 
	   
			$request_address=(parse_url($_SERVER['HTTP_REFERER']));
		
			$request_host_name=$request_address['host'];
		}
		else{
			$request_host_name=$_SERVER['SERVER_NAME'];
		}
		
		if(in_array($request_host_name, explode(',',$default_domains)))
		{
			if($this->CI->input->is_ajax_request() && count($this->CI->session->all_userdata()) <= 5)
			{
				$err_data	=	array(
								   'response' 	=> 	'Invalid',	
								   'msg' 		=>  'Session Expired'
								  // 'redirect'	=>	site_url('/user_login/advertiser')
								   //'redirect'  => '/user_login/advertiser',	
								);
		
				$this->error=	$err_data;
			}
			elseif($key!='')
			{
				if($details)
			
				{ 
					//Common
					
					$this->browser=$this->getBrowser();
					
					$this->os=$this->getOS();
													
					$this->user_agent=$_SERVER['HTTP_USER_AGENT'];
					
					$this->account_id=$details['account_id'];

					$this->agency_id =$details['agencyid'];

					$this->account_type=$details['account_type'];
	
					$this->network_account_id=$details['network_account_id'];

					//Admin or Manager

					if(($details['account_type']=='ADMIN')||($details['account_type']=='MANAGER'))

					{

						$this->default_advertiser_client_id=$details['default_advertiser_client_id'];

						$this->default_advertiser_account_id=$details['default_advertiser_account_id'];

						if(isset($details['network_id'])){

							$this->network_id=$details['network_id'];

						}

					}

					//Manager

					if(($details['account_type']=='MANAGER'))
					{
						$this->manager_user_id		=	$details['manager_user_id'];

						$this->manager_role_id		=	$details['manager_role_id'];
						
						$this->manager_adv_pub_id	=	$details['adv_pub_assoc'];

						$this->network_id			=	$details['network_account_id'];

					}
					else
					{
						$this->user_id=$details['user_id'];
					}

					//Advertiser 

					if($details['account_type']=='ADVERTISER'){

						$this->client_id	=	$details['client_id'];
						$this->is_default	=	$details['is_default'];
					}

					//Publisher

					if($details['account_type']=='TRAFFICKER'){

						$this->affiliate_id=$details['affiliate_id'];

					}

				}
				else
				{
					$err_data=array(
			
							   'response' 	=> 	'error',
			
							   'msg' 		=>  'API key is not a valid'
			
							  );
			
					$this->error=$err_data;
				}

			}
			else	
			{
	
				$err_data=array(
	
					   'response' 	=> 	'error',
	
					   'msg' 		=>  'Please provide valid API key'
	
					  );
	
				$this->error=$err_data;
	
			}

		}	
		//If the request domain dont have permission
		else
     	{

			$err_data=array(

				   'response' 	=> 	'error',

				   'msg' 		=>  'You cant access from this domain'

			      );

			$this->error=$err_data;

		}
	}

	/***********************************

	 * Method : fetch_api_details

	 * @params : api_key

	 * description : return account_id,account_type etc

	 ************************************/

	private function fetch_api_key_details($key)
    {

	    $CI =& get_instance();

		$inst=$CI->db;

		$inst->select('das.account_type as account_type');

		$inst->where('dua.api_key',$key);

		$inst->from('djax_user_apikey as dua');

		$inst->join('rv_users as dou','dou.user_id=dua.user_id');

		$inst->join('djax_networks as dn','dn.default_user_id=dua.user_id');

		$inst->join('rv_accounts as das','das.account_id=dn.account_id');

		$query = $inst->get();

	    $result=$query->result_array();

		if($result){

		  $account_type=$result[0]['account_type'];

		 }

	    

		//CHECK THEIR A/c TYPE AND ASSING VALUES

	  	if(isset($account_type) && $account_type=='ADMIN')

	    {

		    $where=array ('dnm.default_manager'=>1,

		                  'dua.api_key' =>$key,

						  'dc.dj_is_default'=> 1

		  			      );

		    $inst->select( 'dnm.agency_id as agencyid,

						   oxu.default_account_id as account_id,

						   oxu.user_id as user_id,

						   dnet.network_id as network_id,

						   dc.clientid as default_advertiser_client_id,

						   dc.account_id as default_advertiser_account_id,

						   oxa.account_type as account_type,

						   dnm.network_account_id as network_account_id'

						  );

			$inst->join('djax_network_managers as dnm','dnm.manager_account_id=oxu.default_account_id');

			$inst->join('rv_accounts as oxa','oxa.account_id=dnm.network_account_id');

			$inst->join('rv_clients as dc','dc.agencyid=dnm.agency_id');

			$inst->join('djax_networks as dnet','dnet.default_user_id=oxu.user_id');

			$inst->join('djax_user_apikey as dua','dua.user_id=oxu.user_id');

			$inst->where($where);

			$query 	= $inst->get('rv_users as oxu');

			$result= $query->result_array();

			return $result[0];

		}

		else

		{

		    $inst->select('das.account_type as account_type');

			$inst->where('dua.api_key',$key);

			$inst->from('djax_user_apikey as dua');

			$inst->join('rv_users as dou','dou.user_id=dua.user_id');

			$inst->join('rv_accounts as das','das.account_id=dou.default_account_id');

			$query = $inst->get();

			$result=$query->result_array();

			if($result){

			 $type=$result[0]['account_type'];

			 }

		    if(!empty($type))

			{

				switch($type)

				{

				   case 'ADVERTISER':

					 

					 $where=array(

					               'oxcl.dj_is_deleted'=>0,

								   'dua.api_key' =>$key

								  );

					 $inst->select(

								'oxa.account_id as account_id,

								oxu.user_id as user_id,

								oxa.account_type as account_type,

								oxcl.agencyid as agencyid,

								oxcl.clientid as client_id,
								
								oxcl.dj_is_default as is_default,
								
								dnm.network_account_id as network_account_id'

							);

						$inst->join('rv_accounts as oxa','oxa.account_id=oxu.default_account_id');

						$inst->join('rv_clients as oxcl','oxcl.account_id=oxa.account_id');

						$inst->join('rv_agency as oxag','oxag.agencyid=oxcl.agencyid');

						$inst->join('djax_user_apikey as dua','dua.user_id=oxu.user_id');

						$inst->join('djax_network_managers as dnm','dnm.manager_account_id=oxag.account_id');

						$inst->where($where);

			            $query = $inst->get('rv_users as oxu');

						$result= $query->result_array();

						return $result[0];

						break;

						

				   case 'TRAFFICKER':

							  

							$where=array( 'oxaff.dj_is_deleted'	=>	0,

							                'dua.api_key' =>$key

							              );

							 $inst->select('

							   oxa.account_id as account_id,

							   oxa.account_type as account_type,

							   oxu.user_id as user_id,

							   oxaff.agencyid as agencyid,

							   oxaff.affiliateid  as affiliate_id,

							   dnm.network_account_id as network_account_id'

							  );

							 $inst->join('rv_accounts as oxa','oxa.account_id=oxu.default_account_id');

							 $inst->join('rv_affiliates as oxaff','oxaff.account_id=oxa.account_id');

							 $inst->join('rv_agency as oxag','oxag.agencyid=oxaff.agencyid');

							 $inst->join('djax_user_apikey as dua','dua.user_id=oxu.user_id');

							 $inst->join('djax_network_managers as dnm','dnm.manager_account_id=oxag.account_id');

							 $inst->where($where);

							 $query = $inst->get('rv_users as oxu'); 

							 $result= $query->result_array();

							 return $result[0];

							 break;

							 

				   case 'MANAGER':							 

							 $where=array( 'dnm.is_deleted'	=>	0,

							                'dua.api_key' =>$key,

											'dc.dj_is_default'=> 1

							              );

							 $inst->select('oxag.agencyid as agencyid ,

							   oxa.account_id as account_id,

							   oxa.account_type as account_type,

							   dnm.network_account_id as network_account_id,

							   dc.clientid as default_advertiser_client_id,

							   dc.account_id as default_advertiser_account_id,

							   oxu.user_id as manager_user_id,

							   dura.role_id as manager_role_id,
							   
							   dura.adv_pub_assoc as adv_pub_assoc'

							   );

		        			$inst->join('rv_accounts as oxa','oxa.account_id=oxu.default_account_id');

							$inst->join('djax_network_managers as dnm','dnm.manager_account_id=oxa.account_id');

							$inst->join('rv_agency as oxag','oxag.account_id=dnm.manager_account_id');

							$inst->join('djax_user_apikey as dua','dua.user_id=oxu.user_id');

							$inst->join('rv_clients as dc','dc.agencyid=oxag.agencyid');

							$inst->join('djax_user_role_assoc as dura','dura.user_id=oxu.user_id');
							
							$inst->join('djax_roles as dr','dr.role_id=dura.role_id','left');
							
							$inst->where($where);

							$query 	= 	$inst->get('rv_users as oxu');

						    $result= $query->result_array();

							return $result[0];

							break;

				  }	

		      }

			else

			{

			   return FALSE;

			}
	    }   

     }
 
 
 

	public function getOS() {   

    $user_agent     =   $_SERVER['HTTP_USER_AGENT'];

    $os_platform    =   "Unknown OS Platform";

    $os_array       =   array('/windows nt 6.2/i'     =>  'Windows 8','/windows nt 6.1/i'     =>  'Windows 7','/windows nt 6.0/i'     =>  'Windows Vista','/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64','/windows nt 5.1/i'     =>  'Windows XP','/windows xp/i'         =>  'Windows XP','/windows nt 5.0/i'     =>  'Windows 2000','/windows me/i'         =>  'Windows ME','/win98/i'              =>  'Windows 98','/win95/i'              =>  'Windows 95','/win16/i'              =>  'Windows 3.11','/macintosh|mac os x/i' =>  'Mac OS X','/mac_powerpc/i'        =>  'Mac OS 9','/linux/i'              =>  'Linux','/ubuntu/i'             =>  'Ubuntu','/iphone/i'             =>  'iPhone','/ipod/i'               =>  'iPod','/ipad/i'               =>  'iPad','/android/i'            =>  'Android','/blackberry/i'         =>  'BlackBerry','/webos/i'              =>  'Mobile'
                        );

    foreach ($os_array as $regex => $value) { 

        if (preg_match($regex, $user_agent)) {
            $os_platform    =   $value;
        }

    }   

    return $os_platform;
    
    }

	public function getBrowser() {

    $user_agent     =   $_SERVER['HTTP_USER_AGENT'];

    $browser        =   "Unknown Browser";

    $browser_array  =   array(
                            '/msie/i'       =>  'Internet Explorer',
                            '/firefox/i'    =>  'Firefox',
                            '/safari/i'     =>  'Safari',
                            '/chrome/i'     =>  'Chrome',
                            '/opera/i'      =>  'Opera',
                            '/netscape/i'   =>  'Netscape',
                            '/maxthon/i'    =>  'Maxthon',
                            '/konqueror/i'  =>  'Konqueror',
                            '/mobile/i'     =>  'Handheld Browser'
                        );

    foreach ($browser_array as $regex => $value) { 

        if (preg_match($regex, $user_agent)) {
            $browser    =   $value;
        }

    }

    return $browser;

	}

 }
