<?php
class Redis_library
{	
    
    public function __construct()
    {
       $this->ci = &get_instance();  

        // Load the apredis library config
       $this->config = $this->ci->load->config('apredis'); 
	   
       $this->redis = new Redis(); 
		
	   $this->redis->connect($this->config['config']['host'],$this->config['config']['port'],$this->config['config']['timeout']); 
    }  
	
				
	public function logcount($account_id,$log_data,$count=1)
	{		
		$dateTime=date('Y-m-d H:i:s',time()-3600);   
		$current_date_time=date('Y-m-d H:i:s');
		$add="::";
		$aData=array('account_id'=>$account_id.$add,'useragent'=>$log_data['useragent'].$add,'browser'=>$log_data['browser'].$add,'os'=>$log_data['os'].$add,'ip'=>$log_data['ip'].$add,'date'=>$current_date_time.$add,'module'=>$log_data['module'].$add,'process'=>$log_data['process'].$add,'manager_id'=>$log_data['manager_id'].$add,'advertiser_id'=>$log_data['advertiser_id'].$add,'campaign_id'=>$log_data['campaign_id'].$add,'banner_id'=>$log_data['banner_id'].$add,'publisher_id'=>$log_data['publisher_id'].$add,'site_id'=>$log_data['site_id'].$add,'app_id'=>$log_data['app_id'].$add,'adblock_id'=>$log_data['adblock_id'].$add,'bidding_id'=>$log_data['bidding_id'].$add,'zone_limit_id'=>$log_data['zone_limit_id'].$add,'tracker_id'=>$log_data['tracker_id'].$add,'traffic_id'=>$log_data['traffic_id']);
		$date_time	= str_replace(" ","__",$dateTime);
		$key   = 'activitylog_'.$account_id.'_'.$date_time;    	
		$field = join("\t",$aData); 
		$this->redis->hincrby($key,$field,$count); 	        	
	}	
	
	public function getcount($account_id)
    {
		$keys=$this->redis->keys('*'); 
		foreach($keys as $get_key)
		{
			//$this->redis->del($get_key);          
		}
				
		foreach($keys as $get_key)
		{	
			$new_key=explode("activitylog",$get_key);
			if(count($new_key)>1)
			{
				$res 		= $this->redis->hgetall($get_key);
				$result[] = $res; 	  		
			}					
		}		
		return $result; 	
	}

	public function deletekey($key_val)
	{  
		$key_value	= str_replace("__"," ",$key_val);
		$new_key 	= explode("_",$key_value);
		$account_id = $new_key[0]; 
		$date_time  = $new_key[1];  
		$datetime   = date("Y-m-d H:i:s", strtotime('-1 hour', strtotime($date_time)));
		$final_datetime	= str_replace(" ","__",$datetime);
		$key   		= 'activitylog_'.$account_id.'_'.$final_datetime;  
		$this->redis->del($key);              
	}
	
}
