<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MY_Image_lib extends CI_Image_lib {

   	public function __construct()
    {
        parent::__construct();

     }

	/*
	 * name:move_creative_to_tmp_location
	 * @param
	 * @return:Image details
	 * 
	 * This method is used to upload a creative to tmp location
	 */	

    public function move_creative_to_tmp_location($creative=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'jpeg|jpg|png|swf|gif';
		$config['max_size']			= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$creative['tmp_name'];
		$config['source_name']   	= 	$creative['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('creative'))
		{
			//echo $ci_obj->upload->display_errors();
			return FALSE;
			//$data = array('upload_data' => $ci_obj->upload->display_errors());
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	
	public function move_resume_to_tmp_location($resume=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
						
        $config['upload_path'] 		= 	$ci_obj->config->item('resume_tmp_upload_path');
        $config['allowed_types'] 	= 	'pdf|doc|docx';
		//$config['max_size']			= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$resume['tmp_name'];
		$config['source_name']   	= 	$resume['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('resume'))  
		{	
			return FALSE;
		}
		else
		{  
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	
	/*
	 * name:move_video_creative_to_tmp_location
	 * @param
	 * @return:Video details
	 * 
	 * This method is used to upload a creative to tmp location
	 */	

    public function move_video_creative_to_tmp_location($creative=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		$file_element_name 			= 	'creative';
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'*';
		$config['max_size']			= 	$ci_obj->config->item('video_creative_max_size');
		$config['encrypt_name']   	= 	TRUE;
		
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if(!$ci_obj->upload->do_upload($file_element_name))
		{
			$error = array('upload_data' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	/*
	 * name:move_swf_creative_to_tmp_location
	 * @param
	 * @return:SWF details
	 * 
	 * This method is used to upload a creative to tmp location
	 */	

    public function move_swf_creative_to_tmp_location($creative=FALSE)
	{
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'swf';
		$config['max_size']			= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$creative['tmp_name'];
		$config['source_name']   	= 	$creative['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;
		
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('creative'))
		{
			$error = array('upload_data' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	/*
	 * name:move_attach_image_to_tmp_location
	 * @param
	 * @return:Image details
	 * 
	 * This method is used to upload a attachment to tmp location
	 */	

    public function move_attach_image_to_tmp_location($attachment=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('message_tmp_upload_path');
        $config['allowed_types'] 	= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$attachment['tmp_name'];
		$config['source_name']   	= 	$attachment['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('attachment'))
		{
			//$error 	= 	array('error' => $ci_obj->upload->display_errors());
			//return $error;
			return FALSE;
		}
		else
		{
			$data 	= 	array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}
	
	/*
	 * name:move_attach_file_to_tmp_location
	 * @param
	 * @return:File details
	 * 
	 * This method is used to upload a attachment to tmp location
	 */	

    public function move_attach_file_to_tmp_location($attach=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('message_tmp_upload_path');
        $config['allowed_types'] 	= 	'*';
        $config['non_allowed_types']= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$ci_obj->config->item('message_max_file_size');
		$config['source_image']   	= 	$attach['tmp_name'];
		$config['source_name']   	= 	$attach['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('attachment'))
		{
			$error 	= 	array('error' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data 	= 	array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}

	/*
	 * name:move_creative_to_original_location
	 * @param:$creative_name 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to move a creative from temporary
	 * location to it's original location
	 */	

    public function move_creative_to_original_location($creative_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($creative_name)
		{
			/*Folder creation */
			$date=date("Y-m-d");
			if (!file_exists($ci_obj->config->item('creative_upload_path').$date))
			{
				mkdir($ci_obj->config->item('creative_upload_path').$date, 0777, true);
				$creative_upload_path = $ci_obj->config->item('creative_upload_path').$date."/";
				$old = umask(0);
				chmod($creative_upload_path, 0777);				
			}
			else
			{
				
				$creative_upload_path = $ci_obj->config->item('creative_upload_path').$date."/";
			}
			
			$tmp_file_path	= 	$ci_obj->config->item('creative_tmp_upload_path').$creative_name;
			$moved_to		=	$creative_upload_path.$creative_name;
			//$moved_to		=	$ci_obj->config->item('creative_upload_path').$creative_name;
			if(copy($tmp_file_path,$moved_to))
			{
				$olds = umask(0);
				$val=chmod($moved_to, 0777);
				//Delete in temporary location
				$this->delete_creative_in_tmp_location($creative_name);
				return TRUE;
			}
			else
				return FALSE;
		}
	
	}
	
	/*
	 * name:move_creative_to_original_location
	 * @param:$creative_name 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to move a creative from temporary
	 * location to it's original location
	 */	

    public function move_attach_to_original_location($attach_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($attach_name)
		{
			$tmp_file_path	= 	$ci_obj->config->item('message_tmp_upload_path').$attach_name;
			$moved_to		=	$ci_obj->config->item('message_upload_path').$attach_name;
			if(copy($tmp_file_path,$moved_to))
			{
				//Delete in temporary location
				$olds = umask(0);
				$val=chmod($moved_to, 0777);
				$this->delete_attach_in_tmp_location($attach_name);
				return TRUE;
			}
			else
				return FALSE;
		}
	
	}
	
	/*
	 * name:delete_creative_in_original_location
	 * @param:$creative_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from original
	 *
	 */	

    public function delete_creative_in_original_location($creative_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($creative_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('creative_upload_path').$creative_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;
			
		}
	
	}
	/*
	 * name:delete_creative_in_original_location_date
	 * @param:$creative_name,$old_image_path
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from original by date wise folder
	 *
	 */	

    public function delete_creative_in_original_location_date($creative_name=FALSE,$old_image_path = FALSE)
	{
		$ci_obj = & get_instance();
		if($creative_name)
		{
			//$tmp_file_path	=	$ci_obj->config->item('creative_upload_path').$creative_name;
			
			$tmp_file_path	=	$old_image_path.$creative_name;
			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;
			
		}
	
	}
	/*
	 * name:delete_creative_in_tmp_location
	 * @param:$creative_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from temporary
	 *
	 */	

    public function delete_creative_in_tmp_location($creative_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($creative_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('creative_tmp_upload_path').$creative_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;
			
		}
	
	}
	
	/*
	 * name:delete_attach_in_tmp_location
	 * @param:$attach_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from temporary
	 *
	 */	

    public function delete_attach_in_tmp_location($attach_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($attach_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('message_tmp_upload_path').$attach_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;			
		}	
	}
	
	/*
	 * name:delete_attach_in_original_location
	 * @param:$attach_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from original
	 *
	 */	

    public function delete_attach_in_original_location($attach_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($attach_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('message_upload_path').$attach_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;			
		}	
	}
	
	
	/*
	 * name:update_profile_image
	 * @param:$profile_image 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to resize the Profile Image
	 * location to it's original location
	 */	
	public function update_profile_image($profile_image=FALSE)
	{
		$ci_obj = & get_instance();
		//Define defaults
		
        $config['upload_path'] 		= 	$ci_obj->config->item('profile_image_upload_path');
        $config['allowed_types'] 	= 	'jpeg|jpg|png|gif';
		$config['max_size']			= 	$ci_obj->config->item('profile_max_size');
		$config['source_image']   	= 	$profile_image['source_name'];
		$config['source_name']   	= 	$profile_image['source_name'];
		$config['width']          	= 	27;
		$config['height']         	= 	27; 
		$config['encrypt_name']   	= 	TRUE;
		$config['maintain_ratio'] 	= 	FALSE;	

		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if ( ! $ci_obj->upload->do_upload('profile_image'))
		{
			return FALSE;
			/*$data = array('upload_data' => $ci_obj->upload->display_errors());
			return $data;*/
		}
		else
		{
			$profile_image_data = array('upload_data' => $ci_obj->upload->data());
			
			$file_name	=	$profile_image_data['upload_data']['file_name'];
			
		
			$config['new_image'] = $ci_obj->config->item('profile_image_upload_path_resize').$file_name;		
				
			$this->initialize($config);
			if(! $this->resize())
			{
				$error 	= 	array('error' => $this->display_errors());
				return $error; 	    
			}
			else
			{						
				$data 	= 	array('upload_data' => $ci_obj->upload->data());
				return $data;
			}	
		}
		
	}

	
		/*
	 * name:delete_profile_image
	 * @param:$delete_profile_Image
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a profile image from thumb & original folder
	 *
	 */	

    public function delete_profile_image($delete_profile_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($delete_profile_name)
		{
			$original_file_path	=	$ci_obj->config->item('profile_image_upload_path').$delete_profile_name;
			$thumb_file_path	=	$ci_obj->config->item('profile_image_upload_path_resize').$delete_profile_name;
			
			if(file_exists($original_file_path) || file_exists($thumb_file_path) )
			{
				if(unlink($original_file_path) && unlink($thumb_file_path) )
					return TRUE;
				else
					return FALSE;
			}
			
			else
				return FALSE;
			
		}
	
	}


	//BELOW METHODS NEED TO BE OPTIMIZED

    public function image_resize($details=FALSE)
	{
		$config['image_library']  = 	'gd2';
		$config['source_image']   = 	$details['source_name'];
		$config['source_name']   	= 	$details['source_name'];
		$config['allowed_types']  = 	'gif|png|jpg|jpeg|swf';
		$config['max_size']       = 	'10000';
		$config['new_image']      = 	'./uploads/resize/'.$details['file_name'];
		$config['upload_path'] 	= 	'./uploads/resize/';
		$config['encrypt_name']   = 	FALSE;
		$config['overwrite']		= 	TRUE;
        $config['maintain_ratio'] = 	FALSE;
		$config['width']          = 	$details['width'];
		$config['height']         = 	$details['height'];
		$ci_obj 	= 	& get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);
		if ( ! $ci_obj->upload->do_upload())
		{
			$error = array('error' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{  //for resize the image
			$this->initialize($config);   
			if(! $this->resize())
			{
				$error 	= 	array('error' => $this->display_errors());
				return $error; 	    
			}
			else
			{
				$ci_obj = 	& get_instance();
				$ci_obj->load->library('encrypt');
				
				$file_name 				= 	$details['file'];
				
				$encrypt_name			=	$ci_obj->encrypt->encode($file_name); //encrypted file name
				$dot=".";
				$image['file_name']		=	$encrypt_name.$dot.$details['extension']; // join with extension
				$decrypt_name			=	$ci_obj->encrypt->decode($encrypt_name);
				$image['decryp_name']	=	$decrypt_name.$dot.$details['extension']; //decrypted file name
				$data 					= 	array('upload_data' => $image,'error'=>'sucess');
				return $data;
			}					  
		}
	}
		  
	 /****************************************
	 @ getting file extension
	 @method:get_extension
	 @params:imagedetails(need only image temp_name)
	 @return:image_type
	 ****************************************/
	 
	 public function upload_files($details=FALSE)
	 {
	     $temp_name           	= 	$details['source_name'];
		 $val                 	= 	getimagesize($temp_name);
		 $mime                	= 	explode("/",$val['mime']);
		 $path				  	= 	(pathinfo("./uploads/resize/".$details['file_name'])); //print_r($path);exit;
		 $details['extension']	= 	$path['extension']; 
		 $details['file']     	= 	$path['filename']; //filename without extension
		 if($val['mime']!='')
		 {  
			$uploaded_image	=	$this->config_image_resize($details);
			return $uploaded_image;
		 }
		 else
		 {
			$uploaded_file	=	$this->config_files();
			return $uploaded_file;
		 }
	 }
	 
	 
	 /****************************************
	 @Uploading only videos and files
	 @method:config_files
	 @params:no need to pass
	 @return:pass uploaded data or error
	 ****************************************/
	public function config_files()
	{
	   	$config['upload_path'] 	 	= 	'./uploads/resize';
		$config['allowed_types'] 	= 	'flv|csv|pdf|xls|doc|docx|txt';
		$config['max_size']	     	= 	'10000';
		$config['max_width']     	= 	'1024';
		$config['max_height']   	= 	'768';
		$ci_obj = & get_instance();
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);
		if ( ! $ci_obj->upload->do_upload())
		{
			$error 	= 	array('error' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data 	= 	array('upload_data' => $ci_obj->upload->data(),'error'=>'sucess');
            return $data;
		}
	}
		/*
	 * name:move_file_to_original_location
	 * @param:$file_name 
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to move a creative from temporary
	 * location to it's original location
	 */	

    public function move_file_to_original_location($file_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($file_name)
		{
			$tmp_file_path	= 	$ci_obj->config->item('file_tmp_upload_path').$file_name;
			$moved_to		=	$ci_obj->config->item('file_upload_path').$file_name;
			if(copy($tmp_file_path,$moved_to))
			{
				//print_r("copied"); die("kk");
				//Delete in temporary location
				$this->delete_file_in_tmp_location($file_name);
				return TRUE;
			}
			else
				return FALSE;
		}
	
	}
	/*
	 * name:delete_file_in_tmp_location
	 * @param:$file_name
	 * @return:TRUE (or) FALSE
	 * 
	 * This method is used to remove a creative from temporary
	 *
	 */	

    public function delete_file_in_tmp_location($file_name=FALSE)
	{
		$ci_obj = & get_instance();
		if($file_name)
		{
			$tmp_file_path	=	$ci_obj->config->item('file_tmp_upload_path').$file_name;

			if(file_exists($tmp_file_path))
			{
				if(unlink($tmp_file_path))
					return TRUE;
				else
					return FALSE;
			}
			else
				return FALSE;
			
		}
	
	}
	
	/*
	 * name:move_xml_creative_to_tmp_location
	 * @param
	 * @return:Video details
	 * 
	 * This method is used to upload a creative to tmp location
	 */	

    public function move_xml_creative_to_tmp_location($creative=FALSE)
	{	
		$ci_obj = & get_instance();
		//Define defaults
		$file_element_name 			= 	'creative';
        $config['upload_path'] 		= 	$ci_obj->config->item('creative_tmp_upload_path');
        $config['allowed_types'] 	= 	'*';
		//$config['max_size']		= 	$ci_obj->config->item('creative_max_size');
		$config['source_image']   	= 	$creative['tmp_name'];
		$config['source_name']   	= 	$creative['tmp_name'];
		$config['encrypt_name']   	= 	TRUE;
		
		$ci_obj->load->library('upload');
		$ci_obj->upload->initialize($config);

		if(!$ci_obj->upload->do_upload($file_element_name))
		{
			$error = array('upload_data' => $ci_obj->upload->display_errors());
			return $error;
		}
		else
		{
			$data = array('upload_data' => $ci_obj->upload->data());
			return $data;
		}
	}	
	
	
}

/* End of file Image_lib.php */
/* Location: ./application/libraries/MY_Image_lib.php */
