<?php
class Default_configurations
{

	public $min_impressions_day_banner		=	'';
	public $antifraud_clicknum				= 	''; 
	public $antifraud_reset_time			= 	'';
	public $antifraud_threshold			    = 	'';
	public $new_user_approval_type			= 	'';
	public $terawurfl_path					= 	'';
	public $geo_targeting_enabled			= 	'';
	public $adv_min_bid_rate_cpm			= 	'';
	public $adv_min_bid_rate_cpc			= 	'';
	public $adv_min_bid_rate_cpa			= 	'';
	public $max_banner_storage_image		= 	'';
	public $max_banner_storage_video		= 	'';
	public $adv_invoice_period				= 	'';
	public $pub_min_floor_price				= 	'';
	public $pub_min_share					= 	'';
	public $pub_min_amount_invoice			= 	'';
	public $pub_invoice_period				= 	'';  
	public $jw_player_license_key			= 	'';  
	public $creative_approval_type			= 	'';  
	public $default_click_ratio				= 	'';  
	public $default_conversion_ratio		= 	'';
	public $default_theme_color				= 	'';
	public $default_manager_share			= 	'';
	public $floor_price_enable				= 	'';
	public $banner_autoload_enable          =   '';  
	public $adgate_memcache         		=   ''; 
	public $revive_memcache         		=   ''; 
		
	
	public function __construct()
	{
		//parent::__construct();
		$CI =& get_instance();
		$query = $CI->db->get('djax_app_configurations');
		if($query->num_rows() >0)
		{
			$result = $query->row_array();
			foreach($result as $name=>$value)
			{
				//Restric config and network id
				if(!in_array($name,array('config_id','network_account_id')))
				{
					$this->$name = $value;	
				}
			}
		}else{
			return FALSE;
		}	
	}
	
	/***********************************
	 * Method : get_default_configuration
	 * @params : item
	 * description : returns the each default configuration value for each item
	 ************************************/
	public function get($config_item=FALSE)
	{
		$new_var = $this->$config_item;

		if(isset($new_var))
		{
			return $new_var;		
		}else{
			return FALSE;	
		}	
	}
	
	public function activity_log_setting($field_name,$value)
	{		
		$CI =& get_instance();
		$query = $CI->db->get('djax_activity_log_settings');		
				
		if($query->num_rows() >0)
		{
			$result = $query->row_array();	
			
			$common = explode(',', $result[$field_name]);				
						
			if(in_array($value,$common))
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
					
			
		}
		else
		{
			return FALSE;
		}	
	}
	public function ip_info($ip = NULL, $purpose = "location", $deep_detect = TRUE) {
		$output = NULL;
		if (filter_var($ip, FILTER_VALIDATE_IP) === FALSE) {
			$ip = $_SERVER["REMOTE_ADDR"];
			if ($deep_detect) {
				if (filter_var(@$_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP))
					$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
				if (filter_var(@$_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP))
					$ip = $_SERVER['HTTP_CLIENT_IP'];
			}
		}
		$purpose    = str_replace(array("name", "\n", "\t", " ", "-", "_"), NULL, strtolower(trim($purpose)));
		$support    = array("country", "countrycode", "state", "region", "city", "location", "address");
		$continents = array(
			"AF" => "Africa",
			"AN" => "Antarctica",
			"AS" => "Asia",
			"EU" => "Europe",
			"OC" => "Australia (Oceania)",
			"NA" => "North America",
			"SA" => "South America"
		);
			if (filter_var($ip, FILTER_VALIDATE_IP) && in_array($purpose, $support)) {
				$ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip));
				if (@strlen(trim($ipdat->geoplugin_countryCode)) == 2) {
					switch ($purpose) {
						case "location":
							$output = array(
								"city"           => @$ipdat->geoplugin_city,
								"state"          => @$ipdat->geoplugin_regionName,
								"country"        => @$ipdat->geoplugin_countryName,
								"country_code"   => @$ipdat->geoplugin_countryCode,
								"continent"      => @$continents[strtoupper($ipdat->geoplugin_continentCode)],
								"continent_code" => @$ipdat->geoplugin_continentCode
							);
							break;
						case "address":
							$address = array($ipdat->geoplugin_countryName);
							if (@strlen($ipdat->geoplugin_regionName) >= 1)
								$address[] = $ipdat->geoplugin_regionName;
							if (@strlen($ipdat->geoplugin_city) >= 1)
								$address[] = $ipdat->geoplugin_city;
							$output = implode(", ", array_reverse($address));
							break;
						case "city":
							$output = @$ipdat->geoplugin_city;
							break;
						case "state":
							$output = @$ipdat->geoplugin_regionName;
							break;
						case "region":
							$output = @$ipdat->geoplugin_regionName;
							break;
						case "country":
							$output = @$ipdat->geoplugin_countryName;
							break;
						case "countrycode":
							$output = @$ipdat->geoplugin_countryCode;
							break;
					}
				}
		}
		return $output;
	}
	
		
}
