<?php
/*
| -------------------------------------------------------------------------
| Hooks Classes
| -------------------------------------------------------------------------
| This file lets you define "hooks classes - Set_adnetwork_timezone" to set the dynamic timezone according to the package
| files.  Please see the user guide for info:
|
|	http://codeigniter.com/user_guide/general/hooks.html
|
*/

class Layout
{
	public $items_array;
	
	 /**
     * Sets the Default Sidebar according to the role
     * @param string $items
     * @return set of menu items
     */
	
	function Set_default_sidebar()
	{
		$CI = &get_instance();
		$CI->load->helper('sidebar_widget');
		$CI->load->library('template');
		$CI->config->load('sidebar_settings');
		
		$module_name = $CI->router->fetch_module();		
		
		if($module_name !== "api.v_1"){	
		
				$config_datas = $CI->config->item(strtoupper($module_name));
				
			if(!empty($config_datas))
				{
				$matched =0; //Matching Flag	
				foreach($config_datas as $key=>$role_data)
				{
					if($key===$CI->router->fetch_class())
					{
						$data['sidebar_widgets'] = sidebar_widgets($config_datas[$key]);
						$matched = 1;	
					}	
				}
				
				if($matched===0)
				{
					$data['sidebar_widgets'] = sidebar_widgets($config_datas['default_sidebar']);	
				}
				
				
				
				$CI->template->build('view',$data);
			}
		}	
		
	}
	
	
	function dynamic_menu()
	{
		$CI = &get_instance();
		$CI->config->load('menu_configurations');
		$CI->load->library('template_widget');
		$CI->load->helper('utilities');	
		
		$menu = $CI->config->item('menu');
		
		$module_name = $CI->router->fetch_module();
		
		if($module_name !== "api.v_1"){	
		
			if(isset($menu[strtoupper($module_name)]))
			{
				if(strtoupper($module_name) ==='ADMIN' && get_session('account_type') =='MANAGER' )
				{
					$menu[strtoupper($module_name)] = $this->has_manager_permissions($menu[strtoupper($module_name)]);
					$data['menu'] = $CI->template_widget->MakeMenu($menu[strtoupper($module_name)]);	
					
				}else{
					$menu[strtoupper($module_name)] = $this->has_subaccount_permissions($menu[strtoupper($module_name)]);
					$data['menu'] = $CI->template_widget->MakeMenu($menu[strtoupper($module_name)]);
				}
				$CI->template->build('view',$data);
			}
		}
		
	}
	
	/**
     * has_manager_permissions
     * Compare the manager user with respect to the role
     * 
     * @return  bool
     */
      private function has_manager_permissions($menu,$filter_page=FALSE)
      {
		  $CI = &get_instance();
		  
		  $config_page = $CI->config->item('page_control');
		  
          		
		 $role_id = get_session('manager_role_id');
		 
		 // $current_page = $this->current_uri(); 
        if($role_id!=''){
		  $query = $CI->db->query(	"SELECT 
										roles.role_id,roles.role_name,GROUP_CONCAT(permission_value) as permission_value 
									FROM 
										`djax_roles` as roles 
									JOIN 
										djax_role_permission_assoc as role_per ON role_per.role_id=roles.role_id 
									WHERE 
										roles.role_id={$role_id} AND roles.`status`=1 GROUP BY roles.role_id");
		  
		  if($query->num_rows() >0)
		  {
			  	//$this->ci->config->set_item($current_page,'1003');
			  	
			  	$result = $query->result_array();
			  	
			  	//$CI->config->set_item('menu_items','');
			  	
			  	//print_r($menu);
			  	
			  	//Helper Function
			  	array_walk($menu, 'walk_array');//array($this, 'walk_array'));
			  	
			  	$menu_items = $CI->config->item('menu_items');
			   
				if(!empty($menu_items))
			  	{
					$new_menu = array();
					foreach($menu_items as $key=>$value)
					{
						
						if($value==='admin/managers')
						{
							unset($menu['Network users'][$key]);
							$menu['Network users']['Manager Users'] = 'admin/managers/users';
							$value = 'admin/managers/users';
						}			
						
						if($role_id==4 && get_session('adv_pub_assoc')!='')
						{
							unset($menu['Approvals']['User approvals']['Advertiser']);
						}
						
						if($role_id==5 && get_session('adv_pub_assoc')!='')
						{
							unset($menu['Approvals']['User approvals']['Publisher']);
						}
						
						if(is_array($value))
						{
							foreach($value as $arr_value)
							{
								//ADD FWD SLASH IN MENUS
								$new_value=substr($arr_value,-1);
								if($new_value!='/')
								{
								  $new_value=$arr_value.''.'/';
								}
								else
								{
								  $new_value=$arr_value;
								}
								if(isset($config_page[$new_value]['permission_value']))
								{	
									if(!in_array($config_page[$new_value]['permission_value'],explode(',',$result[0]['permission_value'])))
									{
										recursiveRemoval($menu,$arr_value);
									}
								}
							}
						}else{
						
							//ADD FWD SLASH IN MENUS
							$new_value=substr($value,-1);
							if($new_value!='/')
							{
							  $new_value=$value.''.'/';
							}
							else
							{
							  $new_value=$value;
							}
							if(isset($config_page[$new_value]['permission_value']))
							{						
								if(!in_array($config_page[$new_value]['permission_value'],explode(',',$result[0]['permission_value'])))
								{						
									recursiveRemoval($menu,$value);
								}
							}
						}
					}	
					 
					//exit;
				}
				
				//print_r($menu);exit;
				
				//Helper to remove the empty string array key
				$menu = array_filter(array_non_empty_items(array_filter(array_non_empty_items($menu))));
				
				//$menu = array_diff($menu,$new_menu);
				return $menu;
				
			}
			else{
				return $menu;
			}
			 
		}	 return $menu;
	}
	
	/**
     * has_manager_permissions
     * Compare the manager user with respect to the role
     * 
     * @return  bool
     */
      private function has_subaccount_permissions($menu,$filter_page=FALSE)
      {
		  $CI = &get_instance();
		  
		  $config_page = $CI->config->item('page_control');
		  
          		
		 $sub_role_id = get_session('subaccount_role_id');
		 $account_id = get_session('account_id');
		$user_id = get_session('user_id');
		$parent_account_id = get_session('parent_account_id');
		
		
		 // $current_page = $this->current_uri(); 
        if($sub_role_id!='' )
       {
		   
		  $query = $CI->db->query(	"SELECT 
										roles.role_id,roles.role_name,GROUP_CONCAT(permission_value) as permission_value 
									FROM 
										`djax_sub_account_roles` as roles 
									JOIN 
										djax_sub_account_role_permission_assoc as role_per ON role_per.role_id=roles.role_id 
									JOIN
										rv_users as oxu ON oxu.user_id=role_per.user_id
									WHERE 
										roles.role_id={$sub_role_id} AND oxu.default_account_id={$account_id} AND roles.`status`=1 GROUP BY roles.role_id");								
		
		
		  if($query->num_rows() > 0)
		  {
			  
			  
			  	//$this->ci->config->set_item($current_page,'1003');
			  	
			  	$result = $query->result_array();
			  	
			  	//$CI->config->set_item('menu_items','');
			  	//print_r($result[0]['permission_value']);exit;
			  	$permission_value=$result[0]['permission_value'];
			  	//Helper Function
			  	array_walk($menu, 'walk_array');//array($this, 'walk_array'));
			  	
			  	$menu_items = $CI->config->item('menu_items');
			  	
			  		
			   
				if(!empty($menu_items))
			  	{
					$new_menu = array();
					foreach($menu_items as $key=>$value)
					{
						
						if($sub_role_id==9 || $sub_role_id==10 || $sub_role_id==11 || $sub_role_id==12 || $sub_role_id==13)
						{
							//unset($menu['Sub Accounts']);
							unset($menu['Referral'] );
							if($sub_role_id!=9){
								unset($menu['Payments']['Request Payment']);
								unset($menu['Payments']['Payment history']);
							}
							if($sub_role_id==11){
								unset($menu['Apps']);
							}
							if($sub_role_id==13){
								unset($menu['Sites']);
							}
							unset($menu['Campaign Market']['Admarket']);
							unset($menu['Campaign Market']['Adblocks ']);
						}
						//print_r($menu);exit;
						if($sub_role_id==7 || $sub_role_id==8 || $sub_role_id==9 || $sub_role_id==10 || $sub_role_id==11|| $sub_role_id==12|| $sub_role_id==13)
						{
						if(strpos($permission_value, '98') === false ){
							unset($menu['Reports']['Overview report']);
						}
						if(strpos($permission_value, '99') === false){
							unset($menu['Reports']['Geographic report']);
						}
						if(strpos($permission_value, '100') === false){
							unset($menu['Reports']['Sites report']);
						}
						if(strpos($permission_value, '101') === false){
							unset($menu['Reports']['App report']);
						}
						if(strpos($permission_value, '102') === false){
							unset($menu['Reports']['Ad blocks report']);
						}
						if(strpos($permission_value, '103') === false){
							unset($menu['Reports']['Request Report']);
						}
						if(strpos($permission_value, '104') === false){
							unset($menu['Reports']['Group report']);
						}
					}
					
						//print_r($menu);exit;
						if( $sub_role_id==5 || $sub_role_id==6 || $sub_role_id==3)
						{
							
							unset($menu['Reports']['Overview report']);
							unset($menu['Reports']['Geographic report']);
							unset($menu['Reports']['Campaign report']);
							unset($menu['Reports']['Creative report'] );
							unset($menu['Reports']['Video creative report']);
							unset($menu['Reports']['Url Report'] );
							unset($menu['Reports']['Request Report']); 	
							unset($menu['Reports']['Group report']);
								
			
							
						}
						
							if($sub_role_id==4 || $sub_role_id==5 || $sub_role_id==6)
						{
							unset($menu['Payments']['Payment history']); 			
							unset($menu['Payments']['Deposit history']); 
							
						}
						
						
						if( $sub_role_id==3 ||  $sub_role_id==4 || $sub_role_id==5 || $sub_role_id==6)
						{
														
							unset($menu['Network']['Countrywise Bidding']);	
							unset($menu['Network']['Traffic Sources']);		
							unset($menu['Network']['Zone Limitation']);	
							unset($menu['Network']['Pixel Tracker']);		
							unset($menu['Network']['Network Kit']);  		
											
														
						}
										
						if($sub_role_id)
						{
							unset($menu['Network']['Sub Accounts']);
						}
						
						if(strpos($permission_value, '19') === false ){
														
							unset($menu['Creatives']['Add a web creative']);
							unset($menu['Creatives']['Add a mobile creative']);							
							
						}
						if($sub_role_id==1 || $sub_role_id==2 || $sub_role_id==3 || $sub_role_id==4 || $sub_role_id==5|| $sub_role_id==6){
						if(strpos($permission_value, '29') === false ){
							unset($menu['Reports']['Overview report']);
						}
						if(strpos($permission_value, '30') === false ){
							unset($menu['Reports']['Geographic report']);
						}
						if(strpos($permission_value, '31') === false ){
							unset($menu['Reports']['Campaign report']);
						}
						if(strpos($permission_value, '32') === false ){
							unset($menu['Reports']['Creative report']);
						}
						if(strpos($permission_value, '33') === false ){
							unset($menu['Reports']['Video creative report']);
						}
						if(strpos($permission_value, '34') === false ){
							unset($menu['Reports']['Url Report']);
						}
						if(strpos($permission_value, '35') === false ){
							unset($menu['Reports']['Request Report']);
						}
						if(strpos($permission_value, '36') === false ){
							unset($menu['Reports']['Group report']);
						}
						
					}
						//print_r($menu);exit;
						if(is_array($value))
						{
							foreach($value as $arr_value)
							{
								//ADD FWD SLASH IN MENUS
								$new_value=substr($arr_value,-1);
								if($new_value!='/')
								{
								  $new_value=$arr_value.''.'/';
								}
								else
								{
								  $new_value=$arr_value;
								}
								if(isset($config_page[$new_value]['permission_value']))
								{	
									if(!in_array($config_page[$new_value]['permission_value'],explode(',',$result[0]['permission_value'])))
									{
										recursiveRemoval($menu,$arr_value);
									}
								}
							}
						}else{
						
							//ADD FWD SLASH IN MENUS
							$new_value=substr($value,-1);
							if($new_value!='/')
							{
							  $new_value=$value.''.'/';
							}
							else
							{
							  $new_value=$value;
							}
							if(isset($config_page[$new_value]['permission_value']))
							{						
								if(!in_array($config_page[$new_value]['permission_value'],explode(',',$result[0]['permission_value'])))
								{						
									recursiveRemoval($menu,$value);
								}
							}
						}
					}	
					 
					//exit;
				}
				
				//print_r($menu);exit;
				
				//Helper to remove the empty string array key
				$menu = array_filter(array_non_empty_items(array_filter(array_non_empty_items($menu))));
				
				//$menu = array_diff($menu,$new_menu);
				return $menu;
				
			}
			else{
				return $menu;
			}
			 
		}	 return $menu;
	}
	/* Assigns the permissions value for the module by dynamically defining variables */
	
	function assign_permissions_value()
	{
		$CI = &get_instance();
		$CI->load->database();
		
		$query = $CI->db->query("SELECT per_var,permission_value FROM djax_manager_module_permissions WHERE status=1");
		
		if($query->num_rows() >0)
		{
			foreach($query->result_array() as $per)
			{
				define(strtoupper($per['per_var']),$per['permission_value']);	
			}
		}
			
		
	}
	/* Assigns the permissions value for the module by dynamically defining variables */
	
	function assign_subaccount_permissions_value()
	{
		$CI = &get_instance();
		$CI->load->database();
		
		$query = $CI->db->query("SELECT per_var,permission_value FROM djax_user_module_permissions WHERE status=1");
		
		if($query->num_rows() >0)
		{
			foreach($query->result_array() as $per)
			{
				define(strtoupper($per['per_var']),$per['permission_value']);	
			}
		}
			
		
	}
	
	/* Browsers Back Button reload the page using hooks */
	function browser_back_btn()
	{
		$CI = &get_instance();
		$CI->load->helper('utilities');
		
		if($CI->router->fetch_module() =='user_login' && $CI->router->fetch_method() !='logout')
		{
			$account_type = get_session('account_type');
		
			switch($account_type)
			{
				case 'TRAFFICKER':
					redirect('publisher/dashboard');	
					break;
				case 'ADVERTISER':
					redirect('advertiser/dashboard');	
					break;
				case 'ADMIN':
					redirect('admin/dashboard');
					break;
				case 'MANAGER':
					redirect('admin/dashboard');
					break;
			}	
			
		} 
	}
	
	
}
/* End of file hooks.classes.php */
/* Location: ./application/hooks/hooks.classes.php */
