<?php

/*

| -------------------------------------------------------------------------

| Hooks Classes

| -------------------------------------------------------------------------

| This file lets you define "hooks classes - Profiler Enabler" to extend CI without hacking the core

| files.  Please see the user guide for info:

|

|	http://codeigniter.com/user_guide/general/hooks.html

|

*/

class Generate_invoice

{

	function generate_invoice_pub()

	{
		
		$CI =& get_instance();

		$CI->load->library('session');

		$CI->load->library('default_configurations');

		$CI->load->library('memcached_library');
		
		$CI->load->model('api.v_1/do_invoices','do_invoices');

		$invoice_rows 	= 	$CI->do_invoices->retreive_count_invoices();

		$start_date 	= 	$CI->do_invoices->retreive_last_invoice_generation();		

		$period_days 	= 	$CI->default_configurations->get('pub_invoice_period');
		
		$auto_invoice 	= 	$CI->default_configurations->get('auto_invoice_enable');
		
		$end_date 		= 	date('Y-m-d',strtotime('-1 days'));
		
		if($auto_invoice=='enable')
		{
			if($start_date <= date('Y-m-d',strtotime('-'.$period_days.' days')))
			{
				$CI->do_invoices->generate_invoices($start_date,$end_date,$period_days);

				return TRUE;	

			}else{

				return FALSE;

			} 
		}
	}

	

	function generate_invoice_spl_adv()

	{

		$CI =& get_instance();

		$CI->load->library('session');

		

		//$CI->load->model('mod_invoices');

		

		$invoice_rows = $CI->mod_spl_adv_invoices->retreive_count_invoices();

		$start_date = $CI->mod_spl_adv_invoices->retreive_last_invoice_generation();

		$period_days = $CI->default_configurations->get('adexchange_invoice_period');

		$end_date = date('Y-m-d',strtotime('-1 days'));

		

		//Checks first time generation of invoices

		if($invoice_rows ==0 && $start_date >= date('Y-m-d',strtotime('-'.$period_days.' days')))

		{

			$CI->mod_spl_adv_invoices->generate_invoices($start_date,$end_date,$period_days);

			return TRUE;	

		}else if($start_date >= date('Y-m-d',strtotime('-'.$period_days.' days')))

		{

			$CI->mod_spl_adv_invoices->generate_invoices($start_date,$end_date,$period_days);

			return TRUE;	

		}else{

			return FALSE;

		}

	}

	

}

/* End of file hooks.classes.php */

/* Location: ./application/hooks/hooks.classes.php */

