<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	

if ( ! function_exists('transform_errors_to_array'))

{

	function transform_errors_to_array($data = FALSE)

	{

		$errors = explode('</p>', $data);

		foreach ($errors as $index => $error) {

			$error = str_replace('<p>', '', $error);

			$error = trim($error);

			// ... more cleaning up if necessary

			$errors[$index] = $error;

		}

		return $errors;

	}

}

	

	
	function clean_data($data)
	{
		$CI = &get_instance();
		
		if($CI->db)
		{
			if(is_array($data))
			{
				return $CI->db->escape_str($data);
			}
			else
			{
				return trim($CI->db->escape_str($data));
			}			
		}
		else
		{
			if(is_array($data))
			{
				return addslashes($data);
			}
			else
			{
				return trim(addslashes($data));
			}			
		}
	}

	

	// --------------------------------------------------------------------



	/**

	 * Set Session Name with custom name

	 *

	 * This is a helper function to set the session name	

	 *  

	 * @access	public

	 * @param	string {role or type}

	 * @param	array {field names & values)

	 * @return	string {session created}

	 * Roles :- adv - Advertiser, pub- Trafficker, opmgr - Operational Manager, fmgr - Financial Manager, admgr- Admin Manager,adm - Network Admin

	 */

	if ( ! function_exists('set_session'))

	{

		function set_session($role,$values)

		{

			$CI = &get_instance();

			$CI->load->library('encrypt');

			

			if(!empty($role))

			{
				
					foreach($values as $field=>$value)

					{

						$session_name = $CI->config->item('prod_name').'_'.$field;

						$encrypted_value = $CI->encrypt->encode($value);

						

						$CI->session->set_userdata($session_name,$encrypted_value);

					}

					

					$CI->session->set_userdata($CI->config->item('prod_name').'_cur_login_time',$CI->encrypt->encode(date('Y-m-d H:m:s')));

			}

		}

	}	

	

	// --------------------------------------------------------------------



	/**

	 * GEt Session value

	 *

	 * This is a helper function to retrieve the corresponding session value	

	 *  

	 * @access	public

	 * @param	string {session name}

	 * @return	string {session value}

	*/

	

	if ( ! function_exists('get_session'))

	{	

		function get_session($session_name)

		{

			$CI = &get_instance();

			$CI->load->library('encrypt');

			
			if(!empty($session_name))

			{

				$config_name = $CI->config->item('prod_name');

				return $decrypted_value = $CI->encrypt->decode($CI->session->userdata($config_name.'_'.$session_name));

			}

			

		}

	}

	

	if ( ! function_exists('view_session'))

	{	

		function view_session()

		{

			$CI = &get_instance();

			

			$user_data = $CI->session->userdata;

		

			foreach($user_data as $key => $val){

				

				$tmp = explode($CI->config->item('prod_name')."_",$key);

				

				if(count($tmp) == 2){

					echo "<DIV>".$tmp[1]." => ".get_session($tmp[1])."</DIV>";

					

				}

			}

			

		}

	}

	

	

	if ( ! function_exists('get_session_all'))

	{	

		function get_session_all()

		{

			$arr = array();

			

			$CI = &get_instance();

			

			$user_data = $CI->session->userdata;

		

			foreach($user_data as $key => $val){

				

				$tmp = explode($CI->config->item('prod_name')."_",$key);

				

				if(count($tmp) == 2){

					$arr[$tmp[1]] = get_session($tmp[1]);

				}

			}

			

			return $arr;

			

		}

	}

	

	// --------------------------------------------------------------------



	/**

	 * html_anchor_tag_replacer

	 *

	 * This is a helper function to prepare the html content to save database

	 * It will replace with src with a default value

	 *  

	 * @access	public

	 * @param	string {session name}

	 * @return	string {session value}

	*/

	

	if ( ! function_exists('html_anchor_tag_replacer'))

	{	

		function html_anchor_tag_replacer($html_template)

		{

		

			if($html_template)

			{

				$subject = $html_template;

				

				if (preg_match("/href=\"/i", $subject))

				{

					$new_html_cache = str_replace('href="', 'href="{clickurl}', $subject);

					// Check TARGET attrbutes in <a> Tags

					if (preg_match("/target=\"/i", $new_html_cache))

					{

						$new_html_cache = str_replace('target="', 'target="{target}', $new_html_cache);

					}

					else if(preg_match("/target='/i", $new_html_cache))

					{

						$new_html_cache = str_replace("target='", "target='{target}", $new_html_cache);

					}

					else

					{

						$new_html_cache = str_replace('<a', '<a target="{target}" ', $new_html_cache);

					

					} 

				}

				else if(preg_match("/href='/i", $subject))

				{

					$new_html_cache = str_replace("href='", "href='{clickurl}", $subject);

					

					// Check TARGET attrbutes in <a> Tags

				

					if (preg_match("/target=\"/i", $new_html_cache)) {

						$new_html_cache = str_replace('target="', 'href="{target}', $new_html_cache);

					}

					else if(preg_match("/target='/i", $subject)){

						$new_html_cache = str_replace("target='", "href='{target}", $new_html_cache);

					}

					else

					{

						$new_html_cache = str_replace('<a', '<a target="{target}" ', $new_html_cache);

					

					}  

				}

				else

				{

					$new_html_cache = '<a href="{clickurl}" target="{target}">'.$html_template.'</a>';

				}



				return $new_html_cache;

			}

			else

				return false;

			

		}

	}

	

	// --------------------------------------------------------------------



	/**

	 * Json Response for the data table format

	 *

	 * This is a helper function which is used to format the json

	 * response to the data table format.

	 *  

	 * @access	public

	 * @param	string {$json_response}

	 * @param	string {$name}

	 * @return	string {formatted json response}

	*/

	if ( ! function_exists('convert_to_datatable_format'))

	{	

		function convert_to_datatable_format($json_response,$name = 'aaData')

		{

			if($json_response ==='null')

			{

				$result_data = '{ "'.$name.'":[]}';	

			}else{

				$result_data = '{ "'.$name.'":'.$json_response.'}';		

			}

			return $result_data;

		}	

	}

	

	if ( ! function_exists('convert_to_datatable_format_with_server_pagination'))

	{	

		function convert_to_datatable_format_with_server_pagination($data,$page,$total)

		{

			$name = 'aaData';

			

			if($data['table_data'] ==='null')

			{

				$result_data = '{ "iTotalRecords":"0","iTotalDisplayRecords":"0","'.$name.'":[]}';	

			}else{

				$result_data = '{ "sEcho":'.$page.',"iTotalRecords":"'.$total.'","iTotalDisplayRecords":"'.$total.'", "'.$name.'":'.$data['table_data'].',"chart_data":"'.$data['chart_data'].'"}';		

			}

			return $result_data;

		}	

	}

	

	

	// --------------------------------------------------------------------



	/**

	 * Delivery value for openx usage

	 *

	 * This is a helper function which is used to update the

	 * delivery field value which is there in openx.

	 *  

	 * @access	public

	 * @param	string {$zone_type}

	 * @return	string {delivery number}

	*/

	if ( ! function_exists('delivery_value'))

	{	

		function delivery_value($delivery_value)

		{

			switch($delivery_value)

			{

				case WEB_AD_BLOCK_BANNER:

						$delivery = 0;

						break;

				case WEB_AD_BLOCK_DHTML:

						$delivery = 1;

						break;

				case WEB_AD_BLOCK_TEXT:

						$delivery = 3;

						break;

				case WEB_AD_BLOCK_EMAIL_NL:

						$delivery = 4;

						break;

				case VIDEO_AD_BLOCK_OVERLAY:

						$delivery = 7;

						break;

				case VIDEO_AD_BLOCK_INLINE:

						$delivery = 6;

						break;

				case MOBILE_AD_BLOCK_TEXT:

						$delivery = 3;

						break;

				default:

						$delivery = 0;

						break;				

			}

			

			return $delivery;

		}	

	}

	

	// --------------------------------------------------------------------



	/**

	 * checks the condition for adblock and returns the checked value

	 *

	 * This is a helper function which is used to update the

	 * delivery field value which is there in openx.

	 *  

	 * @access	public

	 * @param	string {$type}

	 * @param	string {$delivery}

	 * @return	string {checked or empty status}

	*/

	

	/*checks the Type for radio button*/

	

	if ( ! function_exists('check_adblock_type'))

	{

		function check_adblock_type($type,$delivery)

		{			
			if($delivery ===$type)

			{
				return 'checked="checked"';

			}else{
				return '';	

			}	

		}

	}

	

		// --------------------------------------------------------------------



	/**

	 * checks the condition for adblock and returns the checked value

	 *

	 * This is a helper function which is used to update the

	 * delivery field value which is there in openx.

	 *  

	 * @access	public

	 * @param	string {$type}

	 * @param	string {$delivery}

	 * @return	string {checked or empty status}

	*/

	

	/*checks the Type for radio button*/

	

	if ( ! function_exists('check_permission_layout'))

	{

		function check_permission_layout($Permission,$manager_role_id=FALSE)

		{

		   $CI = &get_instance();

		   $CI->load->database();

		  

		  if($manager_role_id)

		  {

		  

		   $role_id 	 = $manager_role_id;

		   $account_type = 'MANAGER';

	   }else{

		   $role_id 	 = get_session('manager_role_id');

		   $account_type = get_session('account_type');

		  }

		   

		   if($account_type=='MANAGER' && $role_id!='')

			{

			 $query = $CI->db->query("SELECT GROUP_CONCAT(permission_value) as permission_value FROM `djax_roles` as roles JOIN djax_role_permission_assoc as role_per ON role_per.role_id=roles.role_id WHERE roles.role_id={$role_id} AND roles.`status`=1 GROUP BY roles.role_id");

			 if($query->num_rows>0)

			   {

			      $result=$query->result_array();

				  if(in_array($Permission,explode(',',$result[0]['permission_value'])))

				  {

					 // echo 'True conditions';

					 // exit;

				    return TRUE;

				  }

				  else

				  {

					// echo 'false conditions'; 

					// exit;

					  

				    return FALSE;

				  }

			   }

			}

			else{

				//echo 'No role id';

				//exit;

				

			   return TRUE;

			 }

		}

	 }

	
	if ( ! function_exists('check_subaccount_permission_layout'))

	{

		function check_subaccount_permission_layout($Permission,$sub_role_id=FALSE)

		{

		   $CI = &get_instance();

		   $CI->load->database();

		  

		  if($sub_role_id)

		  {
			$sub_role_id 	 = $sub_role_id;

			$account_type = 'TRAFFICKER';

			}else{

		   $sub_role_id 	 = get_session('subaccount_role_id');

		   $account_type = get_session('account_type');

		  }
		   $account_id = get_session('account_id');
			 $parent_account_id = get_session('parent_account_id');
		  

		   if(($account_type=='TRAFFICKER' || $account_type=='ADVERTISER') && $sub_role_id!='')

			{

			 $query = $CI->db->query("SELECT GROUP_CONCAT(permission_value) as permission_value FROM `djax_sub_account_roles` as roles JOIN djax_sub_account_role_permission_assoc as role_per ON role_per.role_id=roles.role_id JOIN rv_users as oxu ON oxu.user_id=role_per.user_id WHERE roles.role_id={$sub_role_id} AND oxu.default_account_id={$account_id}  AND roles.`status`=1 GROUP BY roles.role_id");

			 if($query->num_rows>0)

			   {

			      $result=$query->result_array();

				  if(in_array($Permission,explode(',',$result[0]['permission_value'])))

				  {

				    return TRUE;

				  }

				  else

				  {
					return FALSE;

				  }

			   }

			}

			else{

				return TRUE;

			 }

		}

	 }
	

// --------------------------------------------------------------------



	/**

	 * checks the condition for adblock and returns the checked value

	 *

	 * This is a helper function which is used to update the

	 * delivery field value which is there in openx.

	 *  

	 * @access	public

	 * @param	string {$type}

	 * @param	string {$delivery}

	 * @return	string {checked or empty status}

	*/

	

	/*checks the Type for radio button*/

	

	if ( ! function_exists('check_role_permission'))

	{

		function check_role_permission($type,$perm_value)

		{  

			if($type!='')

			{   

			   $checked = in_array($type,$perm_value)?"checked":"";

				return $checked;

				

			}else{

				return '';	

			}	

		}

	}

	

	

	

	/*

	 * Email  send 

	 * param @ type

	 *   */

	 function send_mail_preview($type=FALSE,$mail_content=FALSE,$sub=FALSE)
	 {
		 
			$CI = &get_instance();

			$CI->load->library('email');

			$CI->load->config('email_configurations');		

			$email_content 		= $CI->config->item('email_content');
			
			if($sub!=FALSE)
			{
				$subject = $sub;
			}
			else
			{
				$subject			= $email_content[$type]['SUBJECT'];		
			}

			$data['content']	= $CI->load->view($email_content[$type]['CONTENT'],$mail_content,TRUE);
			
			$message			= $CI->load->view('email/email_tpl', $data, TRUE);
			print_r($message);exit;
					 
	 }

	 if ( ! function_exists('send_mail'))

	{	

		function send_mail($type=FALSE,$from=FALSE,$to=FALSE,$mail_content=FALSE,$attachment=FALSE,$bcc=FALSE,$sub=FALSE)

		{

			$CI = &get_instance();

			$CI->load->library('email');

			$CI->load->config('email_configurations');		

			$email_content 		= $CI->config->item('email_content');
			
			if($sub!=FALSE)
			{
				$subject = $sub;
			}
			else
			{
				$subject			= $email_content[$type]['SUBJECT'];		
			}

			$data['content']	= $CI->load->view($email_content[$type]['CONTENT'],$mail_content,TRUE);
			
			$message			= $CI->load->view('email/email_tpl', $data, TRUE);
			
			$config['protocol'] = 'sendmail';

			$config['wordwrap'] = TRUE;		

			$config['mailtype'] = 'html';

			$config['charset']	= 'UTF-8'; 

			$CI->email->initialize($config);			

			$CI->email->from($from);

			$CI->email->to($to);
			
			if($attachment) $CI->email->attach($attachment); 

			if($bcc!="")

			{

				$CI->email->bcc($bcc);

			}
			
			$CI->email->subject($subject);        

			$CI->email->message($message);

			$CI->email->send();

		}

	}

	

		if (!function_exists('array_column')) {

    function array_column($input, $column_key, $index_key = null)

    {

        if ($index_key !== null) {

            // Collect the keys

            $keys = array();

            $i = 0; // Counter for numerical keys when key does not exist

            

            foreach ($input as $row) {

                if (array_key_exists($index_key, $row)) {

                    // Update counter for numerical keys

                    if (is_numeric($row[$index_key]) || is_bool($row[$index_key])) {

                        $i = max($i, (int) $row[$index_key] + 1);

                    }

                    

                    // Get the key from a single column of the array

                    $keys[] = $row[$index_key];

                } else {

                    // The key does not exist, use numerical indexing

                    $keys[] = $i++;

                }

            }

        }

        

        if ($column_key !== null) {

            // Collect the values

            $values = array();

            $i = 0; // Counter for removing keys

            

            foreach ($input as $row) {

                if (array_key_exists($column_key, $row)) {

                    // Get the values from a single column of the input array

                    $values[] = $row[$column_key];

                    $i++;

                } elseif (isset($keys)) {

                    // Values does not exist, also drop the key for it

                    array_splice($keys, $i, 1);

                }

            }

        } else {

            // Get the full arrays

            $values = array_values($input);

        }

        

        if ($index_key !== null) {

            return array_combine($keys, $values);

        }

        

        return $values;

    }

}	

	

	if (!function_exists('get_search_date')) {

	

	function get_search_date($search_field,$start_date=FALSE,$end_date=FALSE){

	

		$search_arr = FALSE;

	

		switch($search_field){

		

					case "TODAY":

							$search_arr['from_date']			=	date("Y-m-d");

							$search_arr['to_date']				=	date("Y-m-d");

							break;	

					case "YESTERDAY":

							$search_arr['from_date']			=	date('Y-m-d', strtotime('Yesterday'));

							$search_arr['to_date']				=	date('Y-m-d', strtotime('Yesterday'));

							break;

					case "THIS_WEEK":							

							$start_date		=	date('Y-m-d', strtotime('this week Monday'));

							$start_date1	=	date('Y-m-d', strtotime('last Monday'));

							$end_date		=	date('Y-m-d');

							

							$startDate		=	mktime(0,0,0,$start_date[1],$start_date[2],$start_date[0]);

							$endDate		=	mktime(0,0,0,$end_date[1],$end_date[2],$end_date[0]);

							

							$diff			=	$endDate-$startDate;

							

							$fullDays = floor($diff/(60*60*24));

							

							if($fullDays >0)

							{

								$search_arr['from_date']			=	$start_date;

								$search_arr['to_date']				=	$end_date;

							}

							else

							{

								$search_arr['from_date']			=	$start_date1;

								$search_arr['to_date']				=	$end_date;

							}

							break;

					case "LAST_7_DAYS":

							$search_arr['from_date']			=	date("Y/m/d",strtotime('Today - 6 Day'));

							$search_arr['to_date']				=	date("Y/m/d");

							break;
							
					case "LAST_8_DAYS":

							$search_arr['from_date']			=	date("Y/m/d",strtotime('Today - 7 Day'));

							$search_arr['to_date']				=	date("Y/m/d");

							break;


					case "LAST_30_DAYS":

							$search_arr['from_date']			=	date("Y/m/d",strtotime('Today - 29 Day'));

							$search_arr['to_date']				=	date("Y/m/d");

							break;	

					case "LAST_90_DAYS":

							$search_arr['from_date']			=	date("Y/m/d",strtotime('Today - 89 Day'));

							$search_arr['to_date']				=	date("Y/m/d");

							break;				

					case "THIS_MONTH":

							$search_arr['from_date']			=	date('Y/m/d', mktime(0, 0, 0, date('m'), 1, date('Y')));

							$search_arr['to_date']				=	date("Y/m/d");

							break;

					case "LAST_MONTH":

							$search_arr['from_date']			=	date('Y/m/d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));

							$search_arr['to_date']				=	date('Y/m/d', mktime(0, 0, 0, date('m'), 0, date('Y')));

							break;

					case "SPECIFIC":

							$search_arr['from_date']			=	date("Y/m/d",strtotime($this->input->post('from_date')));

							$search_arr['to_date']				=	date("Y/m/d",strtotime($this->input->post('to_date')));

							break;		

					default:

							$search_arr['from_date']			=	date("Y/m/d",strtotime('Today - 29 Day'));

							$search_arr['to_date']				=	date("Y/m/d");

							break;		

				}

				

				return	$search_arr;

		}

	}	

	

	/**

	 * Formats the Bytes into human readable format (size)

	 *

	 * This is a helper function which is used to convert the bytes into kb,mb etc

	 * 

	 *  

	 * @access	public

	 * @param	string {$bytes}

	 * @param	string {$precision}

	 * @return	formatted file size

	*/

	

	if (!function_exists('formatBytes')) {

	

		function formatBytes($bytes, $precision = 2) { 

			$units = array('B', 'KB', 'MB', 'GB', 'TB'); 



			$bytes = max($bytes, 0); 

			$pow = floor(($bytes ? log($bytes) : 0) / log(1024)); 

			$pow = min($pow, count($units) - 1); 



			// Uncomment one of the following alternatives

			// $bytes /= pow(1024, $pow);

			 $bytes /= (1 << (10 * $pow)); 



			return round($bytes, $precision) . ' ' . $units[$pow]; 

		} 

	

	}

	

	

	/**

	 * Converts the KB,MB into Bytes

	 *

	 * This is a helper function which is used to convert the kb,mb etc into bytes

	 * 

	 *  

	 * @access	public

	 * @param	string {$bytes}

	 * @param	string {$precision}

	 * @return	formatted file size

	*/

	

	if (!function_exists('convertToBytes')) {

		function convertToBytes($from){

			$number=substr($from,0,-2);

				switch(strtoupper(substr($from,-2))){

					case "KB":

						return $number*1024;

					case "MB":

						return $number*pow(1024,2);

					case "GB":

						return $number*pow(1024,3);

					case "TB":

						return $number*pow(1024,4);

					case "PB":

						return $number*pow(1024,5);

					default:

						return $from;

				}

		}

	}

	

	if (!function_exists('convert_to_shortform')) {

	function convert_to_shortform($value,$decimal=0){

	

		$numeric_symbol = array(

				'THOUSAND'=>'K',

				'MILLION' =>'M',

				'BILLION'=>'B',

				'TRILLION'=>'T',

				'QUADRILLION'=>'QD',

				'QUINTRILLION'=>'QT',

				'SEXTRILLION'=>'ST'

		);

	

		if($value<=1000){

			return number_format($value,$decimal);

		}

		else if($value <= 1000000)

		{

			$res = $value / 1000; //3 Zeros Thousands

			return number_format($res,$decimal).' '.$numeric_symbol['THOUSAND'];

		}

		else if($value <= 100000000)

		{

			$res = $value / 1000000; // 6 Zeros Million

			return number_format($res,$decimal).' '.$numeric_symbol['MILLION'];

		}

		else if($value <= 100000000000)

		{

			$res = $value / 1000000000; //9 Zeros Billion

			return number_format($res,$decimal).' '.$numeric_symbol['BILLION'];

		}

		else if($value <= 100000000000000)

		{

			$res = $value / 1000000000000; //12 Zeros trillion

			return number_format($res,$decimal).' '.$numeric_symbol['TRILLION'];

		}

		else if($value <= 100000000000000000)

		{

			$res = $value / 1000000000000000; //15 Zeros Quadrillion

			return number_format($res,$decimal).' '.$numeric_symbol['QUADRILLION'];

		}

		else if($value <= 100000000000000000000)

		{

			$res = $value / 1000000000000000000; //18 Zeros Quintrillion

			return number_format($res,$decimal).' '.$numeric_symbol['QUINTRILLION'];

		}

		else if($value <= 100000000000000000000000)

		{

			$res = $value / 1000000000000000000000; //21 Zeros Sextillion

			return number_format($res,$decimal).' '.$numeric_symbol['SEXTRILLION'];

		}

	}

	

	}

     

	/**

		 * Returns the size of a file without downloading it, or -1 if the file

		 * size could not be determined.

		 *

		 * @param $url - The location of the remote file to download. Cannot

		 * be null or empty.

		 *

		 * @return The size of the file referenced by $url, or -1 if the size

		 * could not be determined.

		 */

		function curl_get_file_size( $url ) {

		  // Assume failure.

		  $result = -1;



		  $curl = curl_init( $url );



		  // Issue a HEAD request and follow any redirects.

		  curl_setopt( $curl, CURLOPT_NOBODY, true );

		  curl_setopt( $curl, CURLOPT_HEADER, true );

		  curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );

		  curl_setopt( $curl, CURLOPT_FOLLOWLOCATION, true );

		  curl_setopt( $curl, CURLOPT_USERAGENT, get_user_agent_string() );



		  $data = curl_exec( $curl );

		  curl_close( $curl );



		  if( $data ) {

			$content_length = "unknown";

			$status = "unknown";



			if( preg_match( "/^HTTP\/1\.[01] (\d\d\d)/", $data, $matches ) ) {

			  $status = (int)$matches[1];

			}



			if( preg_match( "/Content-Length: (\d+)/", $data, $matches ) ) {

			  $content_length = (int)$matches[1];

			}



			// http://en.wikipedia.org/wiki/List_of_HTTP_status_codes

			if( $status == 200 || ($status > 300 && $status <= 308) ) {

			  $result = $content_length;

			}

		  }



		  return $result;

		}



	/* Method : walk_array

	 * 

	 * This helper will returns only the values from the multi-dimensional array

	 * 

	 * @return $items_array

	 * 

	 * *******/

	

	if (!function_exists('walk_array')) {

		function walk_array(&$value, $key, $userdata = array())

		{

			global $items_array;

			$CI = &get_instance();

			if(is_array($value))

			{

				array_walk($value,'walk_array');	

			}else{

			

				if(is_array($items_array))

				{

					if(array_key_exists($key,$items_array))

					{

						$temp =$items_array[$key];

						if(is_array($temp))

						{

							array_push($items_array[$key],$value);

						}else{

							$items_array[$key] = array($temp,$value);	

						}

					}else{

						$items_array[$key] = $value;

					}

				}else{

					$items_array[$key] = $value;

				}

				

				

			}

			

			$CI->config->set_item('menu_items',$items_array);	

				//print_r($items_array);

		}

	}

	

	/* Method : array_non_empty_items

	 * 

	 * This helper will remove the empty string/values from multi-dimansional array

	 * 

	 * @return $items_array

	 * 

	 * *******/

	

	if (!function_exists('array_non_empty_items')) {

		function array_non_empty_items($input) {

			// If it is an element, then just return it.

			if (!is_array($input)) {

			  return $input;

			}

		 

			$non_empty_items = array();

		 

			foreach ($input as $key => $value) {

				

			  // Ignore empty cells

			  if($value) {

				// Use recursion to evaluate cells.

				$non_empty_items[$key] = array_non_empty_items($value);

			  }

			}

		 

			// Finally returns the array without empty items.

			return $non_empty_items;

		}

	}

	

   /* Method : generate_user_apikey

	 * 

	 * This helper will return the unique generated api key for users

	 * 

	 * @return TRUE

	 * 

	 * *******/

	if (!function_exists('generate_user_apikey')){

		function generate_user_apikey($userid)
		{
			$CI = &get_instance();

			$CI->load->library('encrypt');
			while($encrypted_string=$CI->encrypt->encode($userid))
			{
				if(preg_match('/^[a-zA-Z0-9-_=]+$/', $encrypted_string)) break;
			}

			return $encrypted_string;

		}
	}

	/* Method : recursiveRemoval

	 * 

	 * This helper will recursively remove the value from the multi-dimensional array

	 * 

	 * @return TRUE

	 * 

	 * *******/

	if (!function_exists('recursiveRemoval')) {

		function recursiveRemoval(&$array, $val)
		{
			if(is_array($array))
			{

				foreach($array as $key=>&$arrayElement)
				{					
					if(is_array($arrayElement))
					{
						recursiveRemoval($arrayElement, $val);
					}
					else
					{					
						if($arrayElement == $val)
						{
							unset($array[$key]);
						}
					}
				}
			}
			
			return TRUE;

		}

}
	if ( ! function_exists('get_session_acc_details'))

	{	

		function get_session_acc_details($account_id,$user_id,$account_type)

		{
		   $CI = &get_instance();

		   $CI->load->database();
			if($account_type=='ADMIN')		
			{
				$query = $CI->db->query("SELECT  first_name, last_name, is_denied as denied FROM `djax_networks` WHERE `account_id` =$account_id");
			}
			if($account_type=='ADVERTISER')		
			{
				$query = $CI->db->query("SELECT dj_first_name as first_name, dj_last_name as last_name, dj_is_denied as denied FROM `rv_clients` WHERE `account_id` =$account_id");
			}
			if($account_type=='TRAFFICKER')		
			{
				$query = $CI->db->query("SELECT dj_first_name as first_name, dj_last_name as last_name, dj_is_denied as denied FROM `rv_affiliates` WHERE `account_id` =$account_id");
			}
			
			if($query->num_rows>0)
			{
				$result=$query->result_array();
				return $result[0]; 
			}
		}

	}
