<?php

if (!class_exists('Services_Twilio')) {
	/**
	 * The main Twilio.php file contains an autoload method for its dependent
	 * classes, we only need to include the one file manually.
	 */
	include_once(APPPATH.'libraries/Services/Twilio.php');
}

/**
 * Return a twilio services object.
 *
 * Since we don't want to create multiple connection objects we
 * will return the same object during a single page load
 *
 * @return object Services_Twilio
 */
function get_twilio_service() {
	static $twilio_service;

	if (!($twilio_service instanceof Services_Twilio)) {
		/**
		 * This assumes that you've defined your SID & TOKEN as constants
		 * Replace with a way to get your SID & TOKEN if different
		 */
		//$twilio_service = new Services_Twilio('ACb8099d5a45896e42a8a7f6a286eff05f','bbfec0610069cb860e1f62c50a7d3286');
		$twilio_service = new Services_Twilio('ACf23e2a3b1d6664374f46200027aa3052','9b7b16809471fcaf2490453b5bd7769d');
	}

	return $twilio_service;
}

?>
