<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "site";
$route['404_override'] 	     = 'error/page_not_found';

$route['api/v1/(:any)'] = 	'api.v_1/$1';

$route['login'] 					= 	'site/login';
$route['advertiser'] 				= 	'site/advertiser';
$route['publisher'] 				= 	'site/publisher';
$route['signup']					=   'site/signup';
$route['forget_password/advertiser']=   'site/forget_password/advertiser';
$route['forget_password/publisher'] =   'site/forget_password/publisher';
$route['logout/advertiser']			=   'site/logout/advertiser';
$route['logout/publisher']			=   'site/logout/publisher';
$route['logout/admin']			=   'site/logout/admin';

//$route['admin'] 					= 	'user_login/admin';
//$route['manager'] 					= 	'user_login/manager';

/* Site Module- Redirection */
//$route[''] 		= 	'site';
$route['admin'] 	= 	'site/admin';
$route['advertisers'] 	= 	'site/advertisers';
$route['publishers'] 	= 	'site/publishers';
$route['report'] 		= 	'site/report';
$route['report/advertiser'] 	= 	'site/report/advertiser';
$route['report/publisher'] 		= 	'site/report/publisher';
$route['adv_overview'] 			= 	'site/adv_overview';
$route['pub_overview'] 			= 	'site/pub_overview';
$route['fetch_advertiser_stats'] 			= 	'site/fetch_advertiser_stats';
$route['remove_session'] 		= 	'site/remove_session';
$route['network'] 		= 	'site/network';
$route['campaigns'] 	= 	'site/campaigns';
$route['news'] 			= 	'site/news';
$route['admarket']		= 	'site/admarket';
$route['FAQs'] 			= 	'site/FAQs';
$route['careers'] 		= 	'site/careers';
$route['contact_us'] 	= 	'site/contact_us';
$route['supports'] 		= 	'site/supports';
$route['sign_up'] 		= 	'site/sign_up';
$route['sign_up/adv'] 	= 	'site/sign_up/adv';
$route['sign_up/pub'] 	= 	'site/sign_up/pub';
$route['mediakit'] 		= 	'site/mediakit';

$route['about'] 		= 	'site/about';
$route['terms_of_use'] 	= 	'site/terms_of_use';
$route['privacy_policy']= 	'site/privacy_policy';
$route['it_php'] 		= 	'site/it_php';
$route['apply_php'] 	= 	'site/apply_php';
$route['it_bigdata'] 	= 	'site/it_bigdata';
$route['apply_bigdata'] = 	'site/apply_bigdata';
$route['it_pm'] 		= 	'site/it_pm';
$route['apply_pm'] 		= 	'site/apply_pm';
$route['mp_product'] 	= 	'site/mp_product';
$route['apply_product'] = 	'site/apply_product';
$route['mp_self'] 		= 	'site/mp_self';
$route['apply_self'] 	= 	'site/apply_self';
$route['finance_fanalyst']= 'site/finance_fanalyst';
$route['apply_fanayst'] = 	'site/apply_fanayst';

/* Referral */
$route['publishers/referral/(:any)'] 	= 	'site/publishers/referral/$1';
$route['campaigns/direct/(:any)'] 		= 	'site/campaigns/direct/$1';
$route['campaigns/edit/(:any)'] 		= 	'site/campaigns/edit/$1';
$route['directads'] 	= 	'site/directads';
$route['direct_demo'] 	= 	'site/direct_demo';
$route['custom_url'] 	= 	'site/custom_url';

/* End of file routes.php */
/* Location: ./application/config/routes.php */
