<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|-------------------------------------------------------------------------- 
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/ 
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);



/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');


/*
|--------------------------------------------------------------------------
| Define Constants for Managers
|--------------------------------------------------------------------------
|
*/
define('MANAGER_ROLE_FINANCE',	'FINANCE');
define('MANAGER_ROLE_OPERATION',	'OPERATION');
define('MANAGER_ROLE_ADMIN',	'ADMIN');

/*
|--------------------------------------------------------------------------
| Define Constants for PHYSICAL PATH for Image Upload
|--------------------------------------------------------------------------
|
*/

define('USER_PROFILE_IMAGE','user_profile');
define('USER_PROFILE_IMAGE_THUMB','user_profile/thumb/');


/*
|--------------------------------------------------------------------------
| Define Constants for creatives
|--------------------------------------------------------------------------
|
*/

#WEB CREATIVE
define('WEB_CREATIVE_SQL',		'W_SQL'); //Delivery no. - 0,1
define('WEB_CREATIVE_URL',		'W_URL'); //Delivery no. - 0,1
define('WEB_CREATIVE_WEB',		'W_IMG'); //Delivery no. - 0,1
define('WEB_CREATIVE_HTML',		'W_HTML'); //Delivery no. - 0,1
define('WEB_CREATIVE_SWF',		'W_SWF'); //Delivery no. - 0,1
define('WEB_CREATIVE_TEXT',		'W_TEXT'); //Delivery no. - 3
define('WEB_CREATIVE_TOPBAR',	'W_TB'); //Delivery no. - 3

#VIDEO CREATIVE
define('VIDEO_CREATIVE_OVERLAY',	'V_OL'); //Delivery no. - 7
define('VIDEO_CREATIVE_INLINE',		'V_IN'); //Delivery no. - 6


define('VIDEO_CREATIVE_REAL',		'V_RD'); //Delivery no. - 6
define('VIDEO_CREATIVE_SMALL',		'V_SM'); //Delivery no. - 6
define('VIDEO_CREATIVE_BOX',		'V_BOX'); //Delivery no.- 6
define('VIDEO_CREATIVE_HEAD',		'V_HEAD'); //Delivery no.- 6

#MOBILE CREATIVE
define('MOBILE_IMAGE_CREATIVE',		'M_IMG'); //Delivery no. - 0
define('MOBILE_TEXT_CREATIVE',		'M_TEXT'); //Delivery no. - 0
define('MOBILE_DIALOGUE_CREATIVE',	'M_MR_DLG'); //Delivery no. - 0
#MRAIDS
define('MOBILE_MRAID_CREATIVE_EXPAND',		'M_MR_EXP'); //Delivery no. - 0
define('MOBILE_MRAID_CREATIVE_REVEAL',		'M_MR_REV'); //Delivery no. - 0
define('MOBILE_MRAID_CREATIVE_INTERSTITAL',	'M_MR_INT'); //Delivery no. - 0
define('MOBILE_NOTIFICATION_CREATIVE',	'M_MR_NF'); //Delivery no. - 0

#IAB Raising stars
define('MOBILE_RS_CREATIVE_FLEX',		'M_RS_FL'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_ADHESION',	'M_RS_ADH'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_PULL',		'M_RS_PL'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_SLIDER',		'M_RS_SL'); //Delivery no. - 0
define('MOBILE_RS_CREATIVE_FILMSTRIP',	'M_RS_FS'); //Delivery no. - 0
	
# ADDITIONAL AD FORMATS
define('WEB_CREATIVE_POP',		'W_POP'); //Delivery no. - 0,1
define('WEB_CREATIVE_LAYER',	'W_LAY'); //Delivery no. - 0,1
define('WEB_CREATIVE_GAMEBOX',	'W_GB'); //Delivery no. - 0,1
define('WEB_CREATIVE_BANNERBOX','W_BB'); //Delivery no. - 0,1
define('WEB_CREATIVE_SLIDER',	'W_SL'); //Delivery no. - 0,1
define('WEB_CREATIVE_CATFISH',	'W_CF'); //Delivery no. - 0,1
define('WEB_CREATIVE_SITESKIN',	'W_SS'); //Delivery no. - 3
define('WEB_CREATIVE_EXIT_POPUNDER','W_EP'); //Delivery no. - 3

define('WEB_CREATIVE_DIRECT',		'W_DIR'); //Delivery no. - 0,1
define('WEB_CREATIVE_NATIVE',	'W_NA'); //Delivery no. - 3
define('VIDEO_CREATIVE_HTML5',		'V_HTML'); //Delivery no. - 6
define('MOBILE_CREATIVE_CATFISH',	'M_CF'); //Delivery no. - 0,1
define('MOBILE_CREATIVE_SLIDER',	'M_SL'); //Delivery no. - 0,1
define('MOBILE_CREATIVE_HTML',	'M_HTML'); //Delivery no. - 0,1
define('APP_CREATIVE_CATFISH',	'A_CF'); //Delivery no. - 0
define('APP_CREATIVE_INTERSTITAL',	'A_INT'); //Delivery no. - 0
define('APP_VIDEO_CREATIVE_HTML5',	'A_HTML'); //Delivery no. - 6

# GAMEBOX
define('WEB_CREATIVE_GAME',		'GAMEBOX');
define('WEB_CREATIVE_GAMEBOX_ONE',		'G_ONE');
define('WEB_CREATIVE_GAMEBOX_TWO', 'G_TWO');
define('WEB_CREATIVE_GAMEBOX_THREE', 'G_THREE');
define('WEB_CREATIVE_GAMEBOX_FOUR',	'G_FOUR');
define('WEB_CREATIVE_GAMEBOX_FIVE','G_FIVE');
define('WEB_CREATIVE_GAMEBOX_SIX','G_SIX');


# BANNERBOX
define('WEB_CREATIVE_BANNER',		'BANNERBOX');
define('WEB_CREATIVE_BANNERBOX_ONE', 'B_ONE');
define('WEB_CREATIVE_BANNERBOX_TWO', 'B_TWO');
define('WEB_CREATIVE_BANNERBOX_THREE', 'B_THREE');
define('WEB_CREATIVE_BANNERBOX_FOUR',	'B_FOUR');
define('WEB_CREATIVE_BANNERBOX_FIVE','B_FIVE');
define('WEB_CREATIVE_BANNERBOX_SIX','B_SIX');

# SITESKIN
define('WEB_CREATIVE_SITE',		'SITESKIN');
define('WEB_CREATIVE_SITESKIN_LEFT',		'S_LEFT');
define('WEB_CREATIVE_SITESKIN_RIGHT',		'S_RIGHT');
define('WEB_CREATIVE_SITESKIN_BACKGROUND',		'S_BGD');

#SWF CREATIVE

define ('swf_tag_identify', 		 "FWS");
define ('swf_tag_compressed', 		 "CWS");
define ('swf_tag_geturl',   		 "\x83");
define ('swf_tag_null',     		 "\x00");
define ('swf_tag_actionpush', 		 "\x96");
define ('swf_tag_actiongetvariable', "\x1C");
define ('swf_tag_actiongeturl2', 	 "\x9A\x01");
define ('swf_tag_actiongetmember', 	 "\x4E");

/*
|--------------------------------------------------------------------------
| Define Constants for Ad Blocks /Zones
|--------------------------------------------------------------------------
|
*/

#WEB Ad Blocks/Zones
define('WEB_AD_BLOCK_BANNER',	'W_BAN'); //Delivery no. - 0
define('WEB_AD_BLOCK_DHTML',	'W_DHTML'); //Delivery no. - 1
define('WEB_AD_BLOCK_TEXT',		'W_TEXT'); //Delivery no. - 3
define('WEB_AD_BLOCK_EMAIL_NL',	'W_EMAIL'); //Delivery no. - 4
define('WEB_AD_BLOCK_GOOGLE_TEXT',	'WEB_AD_GOOGLE'); //Delivery no. - 5

#VIDEO Ad Blocks/Zones
define('VIDEO_AD_BLOCK_OVERLAY','V_A_OL'); //Delivery no. - 7
define('VIDEO_AD_BLOCK_INLINE',	'V_A_IN'); //Delivery no. - 6
define('VIDEO_AD_BLOCK_REAL',	'V_A_RD'); //Delivery no. - 17
define('VIDEO_AD_BLOCK_SMALL',	'V_A_SM'); //Delivery no. - 17
define('VIDEO_AD_BLOCK_BOX',	'V_A_BOX'); //Delivery no. - 17
define('VIDEO_AD_BLOCK_HEAD',	'V_A_HEAD'); //Delivery no. - 17

#Additional Ad Blocks/Zones
define('WEB_AD_BLOCK_DIRECT',	'W_A_DL'); //Delivery no. - 8
define('WEB_AD_BLOCK_EXIT_POPUNDER','W_A_EP'); //Delivery no. - 8
define('WEB_AD_BLOCK_POPUP',	'W_A_PUP'); //Delivery no. - 9
define('WEB_AD_BLOCK_POPUNDER',	'W_A_PUN'); //Delivery no. - 10
define('WEB_AD_BLOCK_LAYER',	'W_A_LAY'); //Delivery no. - 11
define('WEB_AD_BLOCK_GAMEBOX',	'W_A_GB'); //Delivery no. - 12
define('WEB_AD_BLOCK_SLIDER',	'W_A_SL'); //Delivery no. - 13
define('WEB_AD_BLOCK_CATFISH',	'W_A_CF'); //Delivery no. - 14
define('WEB_AD_BLOCK_SITESKIN',	'W_A_SS'); //Delivery no. - 15
define('WEB_AD_BLOCK_BANNERBOX','W_A_BB'); //Delivery no. - 16
define('WEB_AD_BLOCK_TOPBAR','W_TB'); //Delivery no. - 16
define('WEB_AD_BLOCK_INTERSTITIAL','W_A_INTT'); //Delivery no. -  
define('WEB_AD_BLOCK_NATIVE','W_A_NAT');

#MOBILE Ad Blocks/Zones - BASIC
define('MOBILE_AD_BLOCK_IMAGE','M_A_IM'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_TEXT','M_A_TXT'); //Delivery no. - 0

#MOBILE Ad Blocks/Zones - MRAID
define('MOBILE_AD_BLOCK_NOTIFICATION','M_A_NF'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_INTERSTITIAL','M_A_INT'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_EXPAND','M_A_EXD'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_REVEAL','M_A_RVL'); //Delivery no. - 0 
define('MOBILE_AD_BLOCK_DIALOG','M_A_DLG'); //Delivery no. - 0 

#MOBILE Ad Blocks/Zones - RISING
define('MOBILE_AD_BLOCK_FLEX','M_A_FX'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_ADHENSION','M_A_AD'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_FLIMSTRIP','M_A_FS'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_SLIDER','M_A_SLI'); //Delivery no. - 0
define('MOBILE_AD_BLOCK_PULL','M_A_PULL'); //Delivery no. - 0


#MOBILE App Ad Blocks/Zones 
define('MOBILE_APP_AD_BLOCK_INTERSTITIAL','M_AP_A_IN'); //Delivery no. - 0
define('MOBILE_APP_AD_BLOCK_FOOTER','M_AP_A_FT'); //Delivery no. - 0
define('MOBILE_APP_AD_BLOCK_VIDEO','M_AP_A_VI'); //Delivery no. - 0

/*
|--------------------------------------------------------------------------
| Define Constants for mobile creatives
|--------------------------------------------------------------------------
|
*/

define('MOBILE_CREATIVE_BASE',		'BASE');
define('MOBILE_CREATIVE_BACKGROUND', 'BGI');
define('MOBILE_CREATIVE_HORIZONTAL', 'HOR');
define('MOBILE_CREATIVE_VERTICAL',	'VER');
define('MOBILE_CREATIVE_NAVIGATION','NAVICO');
define('MOBILE_CREATIVE_CONTENT',	'CONT');
define('MOBILE_CREATIVE_SWIPE',	'SWIPE');
define('MOBILE_CREATIVE_LANDSCAPE',	'LAND');
define('MOBILE_CREATIVE_TABLET_LANDSCAPE', 'TAB_LAND');
define('MOBILE_CREATIVE_TABLET_PORTRAIT',	'TAB_PORT');
define('MOBILE_CREATIVE_PORTRAIT',	'PORT');
define('MOBILE_CREATIVE_FILMSTRIP',	'FILM');
define('MOBILE_CREATIVE_ADHESION',	'ADHESION');
define('MOBILE_CREATIVE_EXPAND',	'EXP');
define('MOBILE_CREATIVE_REVEAL',	'REV');
define('MOBILE_CREATIVE_NAVIGATION_VIDEO','N_VIDEO');
define('MOBILE_CREATIVE_NAVIGATION_MESSAGE','N_MSG');
define('MOBILE_CREATIVE_NAVIGATION_SOCIAL','N_SOC');
define('MOBILE_CREATIVE_NAVIGATION_ICON','N_ICON');

define('MOBILE_CREATIVE_NAVIGATION_TAB', 'TABLET');

define('MOBILE_CREATIVE',		'MOB');

define('MOBILE_SMARTPHONE_WIDE_CREATIVE',	'S_WIDE');
define('MOBILE_SMARTPHONE_STATIC_CREATIVE',	'S_STAT');
define('MOBILE_SMARTPHONE_INTERSTITIAL_CREATIVE', 'S_INT');
define('MOBILE_FEATURE_PHONE_LARGE_CREATIVE',	'F_LARGE');
define('MOBILE_FEATURE_PHONE_MEDIUM_CREATIVE',	'F_MEDIUM');
define('MOBILE_FEATURE_PHONE_SMALL_CREATIVE',	'F_SMALL');
define('MOBILE_TABLET_PHONE_LARGE_CREATIVE',	'T_LARGE');
define('MOBILE_TABLET_PHONE_MEDIUM_CREATIVE',	'T_MEDIUM');
define('MOBILE_TABLET_PHONE_SMALL_CREATIVE',	'T_SMALL');





//Display size
define('XX_LARGE', 'XXL');
define('X_LARGE',	'XL');
define('LARGE',	'L');
define('MEDIUM',	'M');
define('SMALL',	'S');

/*
|--------------------------------------------------------------------------
| Database Tables for dJAX Ad Exchange Product
|--------------------------------------------------------------------------
|
*/
 
define('TAB_NOTIFY_MSG','djax_notificationmsg');
define('TAB_NOTIFY_OPTION','djax_adv_pub_notification_options');
define('TAB_ADMARKET_PUB','djax_admarket_approve_publisher');
define('TAB_CAMP_TRAFFIC','djax_campaign_traffic_source');		// Source traffic
define('TAB_CAMP_ZONE','djax_campaign_zone_bidding');		// Source traffic
define('TAB_APP_CONFIG','djax_app_configurations');
define('TAB_BAN_CAM_ASSOC','djax_banner_campaign_assoc');
define('TAB_BROWESR_STAT','djax_browsers_stats ');
define('TAB_ADBLOCK_DOMAIN','djax_adblock_domains');
define('TAB_CLIENT_STAT','djax_clients_stats ');
define('TAB_CONF_BANNER_SIZE','djax_conf_banner_sizes ');
define('TAB_CONF_CAM_STATUS','djax_conf_campaign_status');
define('TAB_CONF_REVENUE_TYPE','djax_conf_revenue_type ');
define('TAB_CONF_ZONE_TYPE','djax_conf_zone_type ');
define('TAB_CURRENCY','djax_currency');
define('TAB_GEO_STATS','djax_geographical_stats ');
define('TAB_MOB_BANNERS','djax_mobile_banners ');
define('TAB_MOB_DEVICE_STAT','djax_mobile_devices_stats');
define('TAB_MOB_MANUFACT','djax_mobile_manufacturer');
define('TAB_MOB_OS','djax_mobile_os');
define('TAB_NETWORKS','djax_networks  ');
define('TAB_NWK_MANAGERS','djax_network_managers  ');
define('TAB_PUB_SITES','djax_publisher_sites  ');
define('TAB_SITES_STATS','djax_sites_stats  ');
define('TAB_SITE_CATEGORIES','djax_site_categories  ');
define('TAB_SITE_CAT_ASSOC','djax_site_category_assoc ');
define('TAB_APP_CAT_ASSOC','djax_app_category_assoc ');
define('TAB_TARG_BROWSERS','djax_targ_browsers');
define('TAB_TARG_BROWSER_VERSION','djax_targ_browser_versions');
define('TAB_TARG_CONTINENT','djax_targ_continent ');
define('TAB_TARG_COUNTRY','djax_targ_country');
define('TAB_TARG_STATE','Geo_region');
define('TAB_TARG_COUNTRY_REGION','djax_targ_country_region');
define('TAB_TARG_MOB_CAPA','djax_targ_mobile_capability');
define('TAB_TARG_MOB_MANU','djax_targ_mobile_manufacturer');
define('TAB_TARG_MOB_OS','djax_targ_mobile_os');
define('TAB_TARG_MOB_TC','djax_targ_mobile_telecom_circle');
define('TAB_TARG_MOBILE_CARRIER','djax_targ_carrier_detail');
define('TAB_TARG_KEYWORD','djax_targ_keywords');

define('TAB_TARG_BROWSER_LANG','djax_targ_browser_language');
define('TAB_TARG_TIME','djax_targ_time');
define('TAB_TARG_DAYS','djax_targ_days');
define('TAB_TARG_OS_SET','djax_targ_os_set');
define('TAB_TARG_DEV_TYPE','djax_targ_device_type');
define('TAB_TARG_DEVICE','djax_targ_device');
define('TAB_TARG_CONN_TYPE','djax_targ_connection_type');
define('TAB_TARG_CITY','GeoIPCity');


define('TAB_AD_FRAUD_CLK','djax_ad_fraud_click');
define('TAB_AD_ZONE_CLK','djax_ad_zone_click');
define('TAB_PENALITIES','djax_penalties');
define('TAB_IMP_PENALITIES','djax_imp_penalties');

define('TAB_TARG_OS','djax_targ_operating_system ');
define('TAB_TARG_OS_VERSION','djax_targ_os_version');

define('TAB_TEMP_USER','djax_temp_user ');
define('TAB_TZ','djax_timezone ');
define('TAB_TRACK_AD_REQ','djax_track_ad_requests ');
define('TAB_TRACK_AD_RV_REQ','rv_djax_track_ad_requests ');
define('TAB_TRACK_AD_RES','djax_track_ad_responses ');
define('TAB_TRACK_AD_RV_RES','rv_djax_track_ad_responses ');  
define('TAB_TRACK_VIEWERS','djax_track_viewers ');
define('TAB_VIEWER_STATS','djax_viewer_stats ');
define('TAB_ACCOUNTS','rv_accounts');
define('TAB_ACC_PER_ASSOC','rv_account_preference_assoc');
define('TAB_ACC_USER_ASSOC','rv_account_user_assoc');
define('TAB_ACC_USER_PER_ASSOC','rv_account_user_permission_assoc');
define('TAB_ACLS','rv_acls ');
define('TAB_ACLS_CHANNEL','rv_acls_channel');
define('TAB_AD_CAT_ASSOC','rv_ad_category_assoc');
define('TAB_AD_ZONE_ASSOC','rv_ad_zone_assoc');
define('TAB_AFFILIATE','rv_affiliates');
define('TAB_AFF_EXT','rv_affiliates_extra');
define('TAB_AGENCY','rv_agency');
define('TAB_APP_VAR','rv_application_variable');
define('TAB_AUDIT','rv_audit');
define('TAB_BANNERS','rv_banners ');
define('TAB_BAN_VAST_ELE','rv_banner_vast_element ');
define('TAB_CAMPAIGNS','rv_campaigns');
define('TAB_CAM_TRACKERS','rv_campaigns_trackers');
define('TAB_CATEGORY','rv_category ');
define('TAB_CHANNEL','rv_channel ');
define('TAB_CLIENTS','rv_clients ');
define('TAB_DB_ACTION','rv_database_action');
define('TAB_DATA_BKT_A','rv_data_bkt_a ');
define('TAB_DATA_BKT_A_VAR','rv_data_bkt_a_var  ');
define('TAB_DATA_BKT_C','rv_data_bkt_c ');
define('TAB_DATA_BKT_M','rv_data_bkt_m ');
define('TAB_DATA_BKT_R','rv_data_bkt_r ');
define('TAB_DATA_BKT_VAST_E','rv_data_bkt_vast_e  ');
define('TAB_DATA_IM_AD','rv_data_intermediate_ad  ');
define('TAB_DATA_IM_AD_CON','rv_data_intermediate_ad_connection ');
define('TAB_DATA_IM_AD_VAR_VALUE','rv_data_intermediate_ad_variable_value ');
define('TAB_DATA_RAW_AD_CLK','rv_data_raw_ad_click');
define('TAB_DATA_RAW_AD_IMP','rv_data_raw_ad_impression');
define('TAB_DATA_RAW_AD_REQ','rv_data_raw_ad_request');
define('TAB_DATA_RAW_TRACKER_IMP','rv_data_raw_tracker_impression ');
define('TAB_DATA_RAW_TRACKER_VAR_VALUE','rv_data_raw_tracker_variable_value ');
define('TAB_DATA_SUM_AD_HOURLY','rv_data_summary_ad_hourly');
define('TAB_DATA_SUM_AD_ZONE_ASSOC','rv_data_summary_ad_zone_assoc');
define('TAB_DATA_SUM_CHANNEL_DAILY','rv_data_summary_channel_daily');
define('TAB_DATA_SUM_ZONE_IMP_HISTORY','rv_data_summary_zone_impression_history');
define('TAB_EXT_MKT_ADV','rv_ext_market_advertiser');
define('TAB_MKT_ASSOC_DATA','rv_ext_market_assoc_data ');
define('TAB_EXT_MKT_CAM_PREF','rv_ext_market_campaign_pref ');
define('TAB_EXT_MKT_GEN_PREF','rv_ext_market_general_pref ');
define('TAB_EXT_MKT_PLUGIN_VAR','rv_ext_market_plugin_variable');
define('TAB_EXT_MKT_SETTING','rv_ext_market_setting');
define('TAB_EXT_MKT_STATS','rv_ext_market_stats');
define('TAB_EXT_MKT_WEB_PREF','rv_ext_market_website_pref');
define('TAB_EXT_MKT_WEB_STATS','rv_ext_market_web_stats');
define('TAB_IMAGES','rv_images');
define('TAB_LOG_MAT_FORECAST','rv_log_maintenance_forecasting');
define('TAB_LOG_MAT_PRIORITY','rv_log_maintenance_priority ');
define('TAB_LOG_MAT_STAT','rv_log_maintenance_statistics');
define('TAB_PWD_RECOVERY','rv_password_recovery');
define('TAB_PLACE_ZONE_ASSOC','rv_placement_zone_assoc');
define('TAB_PREFERENCES','rv_preferences');
define('TAB_SESSION','rv_session');
define('TAB_STATS_VAST','rv_stats_vast');
define('TAB_TARGET','rv_targetstats');
define('TAB_TRACKERS','rv_trackers');
define('TAB_TKR_APP','rv_tracker_append');
define('TAB_UPGRADE_ACTION','rv_upgrade_action');
define('TAB_USERLOG','rv_userlog');
define('TAB_USERS','rv_users');
define('TAB_VAR','rv_variables');
define('TAB_VAR_PUB','rv_variable_publisher');
define('TAB_ZONES','rv_zones');
define('TAB_BAN_DEPEND','djax_additional_banners');
define('TAB_SITE_ZONE_ASSOC','djax_site_zone_assoc');
define('TAB_APP_ZONE_ASSOC','djax_app_zone_assoc');
define('TAB_CONF_MOBILE_SCREEN_SIZE','djax_conf_mobile_screen_sizes');
define('TAB_CONF_DISPLAY_SCREEN_SIZE','djax_conf_display_screen_sizes');
define('TAB_CAMPAIGNS_CATEGORY_ASSOC','djax_campaign_category_assoc');
define('TAB_ADMIN_PAYD','djax_admin_payment_details');
define('TAB_BILL_INFO','djax_billing_information');
define('TAB_INVOICE','djax_invoice');
define('TAB_INVOICE_ITEM','djax_invoice_item');
define('TAB_INVOICE_GEN','djax_invoice_generation');
define('TAB_INVOICE_PAY','djax_invoice_payment');
define('TAB_PAY_PERIOD','djax_payment_period');
define('TAB_PAY_RES','djax_payment_response');
define('TAB_PAY_TRANS','djax_payment_transaction');
define('TAB_PUB_PAYD','djax_publisher_payment_details');
define('TAB_MESSAGES','rv_djax_messages');
define('TAB_NOTIFICATION_MESSAGES','rv_djax_notifaction_center');
define('TAB_ANTI_FRAUD','djax_anti_fraud_stats'); 
define('TAB_ANTI_FRAUD_IMP','djax_anti_fraud_imp_stats'); 
define('TAB_ROLES','djax_roles'); 
define('TAB_ROLE_PERMISSION_ASSOC','djax_role_permission_assoc');
define('TAB_USER_ROLE_ASSOC','djax_user_role_assoc');
define('TAB_USER_APIKEY','djax_user_apikey');
define('TAB_LOGIN_INFO','djax_login_info');
define('TAB_NET_STATS','djax_network_stats');
define('TAB_GEO_SETTING','djax_cpm_geo_settings');
define('TAB_COUN_BID','djax_country_bidding');
define('TAB_ZONE_LIT','djax_zone_limitations');
define('TAB_ZONE_PUB_LIT','djax_pub_zone_limitations');
define('TAB_LANG','djax_language');
define('TAB_TEMP_ZONES','temp_rv_zones');
define('TAB_TAG_PARAMETERS','djax_tag_parameters');
define('TAB_REQUEST_REPORT','djax_request_report');
define('TAB_DIR_CAMP_PAY','djax_direct_campaign_payment');
define('TAB_TEMP_MAIL','djax_template_mail');
define('TAB_CONV_LIST','djax_conversion_list');
define('TAB_ADM_ADV_PUB','djax_admarket_adv_pub_appr');
define('TAB_INLINE_KEYWORDS','djax_inline_keywords');



// DSP and SSP
//OpenRTB
define('TAB_PARTY_ADX','djax_3rd_party_ad_exchange' );
define('TAB_DSP_BID_REQ','djax_dsp_bid_request');
define('TAB_DSP_RESPONSE','djax_dsp_response');
define('TAB_DSP_WIN_NOTICE','djax_dsp_win_notice');
define('TAB_3RD_ADX',' djax_3rd_party_ad_exchange');
define('TAB_RTB_REQUEST','djax_ad_requests_rtb_buyers');
define('TAB_RTB_RESPONSE','djax_ad_response_rtb_buyers');
define('TAB_GROUP','djax_group');
define('TAB_GROUP_ASSOC','djax_group_assoc');



/*
 * MEMCACHE CONSTANTS
 */
 
 /* ADMIN */
 define('HOUSE_CAMPAIGN_CHANGES','housead_campaign_changes');
 define('ADD_TARGETING','add_targetting_admin');
 define('USER_APPROVALS','fetch_user_approval_');
 define('ADV_APPROVALS','fetch_approval_advertisers');
 define('PUB_APPROVALS','fetch_approval_publishers');
 define('ADMIN_MAIN_CATEGORY','main_category');
 define('ADMIN_SUB_CATEGORY','fetch_admin_sub_category');
 define('ADMIN_OPERATING_SYSTEM','admin_targetting_operating_system');
 define('ADMIN_TARGETTING_BROWSER','admin_targetting_browser');
 define('ADMIN_TARGETTING_BROWSER_LANGUAGE','admin_targetting_browser_language');
 define('FETCH_MOBILE_MANUFACTURER','fetch_mobile_manufacturers');
 define('ADMIN_MOBILE_MANUFACTURER','admin_targetting_mobile_manufacturer');
 define('FETCH_MOBILE_CAPABILITIES','fetch_mobile_capability');
 define('ADMIN_MOBILE_CAPABILITIES','admin_mobile_capability');
 define('ADVERTISER_APPROVE_LIST','adv_user_approve_list');
 define('ADVERTISER_PAYMENT_APPROVE_LIST','adv_paymnt_approve_list');
 define('ADMIN_TARGETTING_FETCH_KEYWORD','fetch_admin_targetting_contextual_keywords');
 define('ADMIN_CONTEXTUAL_KEYWORD','fetch_admin_contextual_keywords');
 define('ADMIN_FETCH_USERS','fetch_admin_users');
 define('ADMIN_FETCH_ADVERTISERS','fetch_admin_advertisers');
 define('ADMIN_ADV_PAYMENT_REJECT','admin_adv_payment_reject');
 define('ADMIN_CAMPAIGN_FETCH_ADV','admin_adv_campaign_fetch');
 define('ADMIN_FETCH_RTB','fetch_admin_rtb');
 define('ADMIN_RTB_LIST','admin_rtb_list');
 define('ADMIN_FETCH_PUBLISHER_LIST','fetch_admin_publisher_list');
 define('ADBLOCK_CHANGES','pub_adblock_list');
 define('ADMIN_DIRECT_CAMPAIGN_APPROVALS','admin_directcampaign_payment_approvals');
 define('PUBLISHER_APPROVE_LIST','Pub_user_approve_list');
 define('APPROVAL_FETCH_ALL_CREATIVES','fetch_all_approval_creatives_');
 define('FETCH_MESSAGE_RELOAD','message_fetch_all_message');
 define('FETCH_MESSAGE_INBOX','message_fetch_all_message_inbox');
 define('FETCH_MESSAGE_SENT','message_fetch_all_sent');
 define('FETCH_MESSAGE_TRASH','message_fetch_all_trash');
 define('FETCH_MESSAGE_NOTIFY','message_fetch_all_message_notify');
 define('FETCH_ALL_UNREAD_MESSAGE_COUNT','message_fetch_all_unread_message_count');
 define('ADMIN_FETCH_ADMARKET_BANNER_ALLOW','admin_fetch_admarket_banner_allow');
 define('FETCH_ADMARKET_ADVERTISER_CAMPAIGN','fetch_admarket_advertiser_campaigns');
 define('FETCH_PUB_PAYMENT_LIST_APPROVAL',' fetch_pub_payment_list_approval ');
 define('FETCH_DIRECT_CAMPAIGN',' fetch_direct_campaign_approve ');
 define('ACCOUNT_SETTINGS_USER_INFORMATION',' get_user_information_account_settings');
 define('ADMIN_ACCOUNT_SETTINGS','admin_account_settings');
 define('ADMIN_PAYMENT_INFO','get_admin_payment_info');
 define('ADMIN_SET_PAYMENT_INFO','admin_settings_payment_info');
 define('ADMIN_FETCH_USER_ROLE','fetch_user_role_list');
 define('USER_ROLE_LIST','admin_user_role_list');
 define('FETCH_ADMIN_GEO_SETTINGS','fetch_geo_settings_admin');
 define('FETCH_DOMAINS','fecth_adblock_domains');
 define('FETCH_ALL_GEO_SETTINGS','geo_settings_fetch_all');
 define('DISPLAY_SCREEN_SIZES','dislay_screen_size');
 define('EDIT_CAMPAIGNS','edit_campaigns');
 define('FETCH_EDIT_ROLE','fetch_edit_roles');
 define('FETCH_USER_ROLE','fetch_user_roles');
 define('USER_ROLE','admin_user_role');
 define('FETCH_USER_ROLE_PERMISSION','fetch_user_roles_permission');
 define('USER_ROLE_PERMISSION','admin_user_roles_permission');
 define('FETCH_ADVERTISER_MAIL','fetch_adv_mail_admin');
 define('ADVERTISER_MASS_EMAIL','mass_email_advertiser');
 define('FETCH_PUBLISHER_MAIL','fetch_pub_mail_admin');
 define('PUBLISHER_MASS_EMAIL','mass_email_publisher');
 define('ADMIN_MASS_EMAIL_FETCH_ADVERTISERS','mass_email_fetch_user_list');

 
/* ADVERTISER */

define('FETCH_CAMP_TARG','fetch_camapign_targeting_');
define('CAMPAIGN_CHANGES','campaign_changes');
define('DELETE_CAMPAIGN','delete_camapign');
define('FETCH_CREATIVES','fetch_creatives');
define('FETCH_MOB_CREATIVES','fetch_mob_creatives');
define('FETCH_MODAL_CREATIVES','fetch_modal_creatives');
define('ADV_BIDDING_TRAFFIC_SOURCES','special_bidding_traffic_sources');
define('ADV_ZONE_LIMITATIONS','pub_zone_limitations_fetch');
define('ADV_ZONE_LIMITATIONS_EDIT','pub_zone_limitations_fetch_edit');
define('ADV_TRACKER_LIST','adv_pixel_tracker_list');
define('ADV_USER_INFO','adv_fetch_pesrs_info');
define('FETCH_VIDEO_MEMCACHE_INLINE','fetch_video_memcache_inline');
define('FETCH_VIDEO_VAST_MEMCACHE_INLINE','fetch_video_vast_memcache_inline');
define('FETCH_ALL_PREVIEW_CREATIVES','fetch_preview_all_creatives');
define('ADV_GROUP_LIST','adv_group_list');
define('ADV_KEYWORD_LIST','adv_keyword_list');
define('CAMPAIGN_TRACKER_CHANGES','campaign_tracker_assoc');
define('ADVERTISER_PAYMENT_LIST','adv_payment_list');
define('ADVERTISER_DATEWISE_PAYMENT_LIST','adv_datewise_payment_list');
define('ADVERTISER_DEPOSIT_LIST','adv_deposit_list');
define('ADVERTISER_ZONELIMIT_LIST','adv_zonelimitation_list');

/* PUBLISHER */

define('SITE_CHANGES','site_changes');
define('PUB_SITE','fetch_pub_site_');
define('APP_CHANGES','app_changes');
define('PUB_APP','fetch_pub_app_');
define('EDIT_APP_CHANGES','edit_app_changes');
define('EDIT_APP_CATEGORY_CHANGES','edit_app_category_changes');
define('PUB_ADBLOCK_CHANGES','pub_adblock_changes');
define('FETCH_PUB_ADBLOCK','fetch_pub_adblocks_');
define('REQUEST_PAYOUT','site_changes');
define('PUB_PERSONAL_INFO','pub_personal_info');
define('FETCH_COUNTRY_BIDDING','list_bidding_country');
define('FETCH_EXPAND_PARENT_CRE','fetch_expand_parent_creative');
define('FETCH_EXPAND_CHILD_CRE','fetch_expand_child_creative');
define('FETCH_SITE_TAG_PARAMETERS','fetch_site_tag_parameters');
define('EDIT_SITE_CHANGES','edit_site_changes');
define('EDIT_SITE_CATEGORY_CHANGES','edit_site_category_changes');

/* COMMON FOR ALL*/
define('TAB_ACTIVITY','djax_activity_log');
define('TAB_PAY_ACTIVITY','djax_payment_activity_log');
define('TAB_PAYMENT','djax_payment_changes');
define('TAB_TEMP_URL','djax_temp_url');
define('TAB_SECURITY','djax_security');
define('TAB_SECURITY_QUESTION','djax_security_option');
define('SUBACCOUNT_CHANGES','subaccount_changes');
define('APP_NOTIFY','app_notification');
define('SEC_QUES','get_security_question');
define('ROLES_LIST','roles_listing');

define('ADMIN_ID','2');

define('ADV_ADD_TRAFFIC_SOURCES','sbidding_add_traffic_sources');
define('ADV_CHECK_TRAFFIC_SOURCES','sbidding_check_traffic_sources');  
define('ADV_CHECK_ZONE_BIDDING','advertiser_check_zone_bidding');
define('ADV_ADD_ZONE_BIDDING','advertiser_add_zone_bidding');
define('FETCH_EDIT_COUNTRY_BIDDING','edit_bidding_country');
define('FETCH_REQUEST_REPORT','fetch_request_reports');
define('GET_REQUEST_REPORT','get_request_reports');
define('PUBLISHER_REFERRAL_LIST','pub_referral_list');
define('FETCH_APPROVE_CAMPAIGN',' fetch_campaign_approve');
define('PUB_CAMPAIGN_NOTLIST',' fetch_pub_camp_notlist');
define('CAMP_PUB_NOTLIST',' fetch_camp_pub_notlist');
define('CAMPAIGN_APPROVE_CREATIVE_CHANGES',' fetch_camp_approve_creative');
define('CONVERSION_CHANGES',' fetch_conversion_changes');


/* Modules and process*/
define('CAMPAIGN','campaign');
define('BANNER','banner');
//define('SITE','site');
//define('ADBLOCK','adblock');
define('APPS','apps');
define('ADD','add');
define('EDIT','edit');
define('DELETE','delete');
define('PAUSE','pause');
define('RUN','run');
define('WTRANS','wtoc');
define('CTRANS','ctow');
define('REQUEST','request');
define('APPROVE','approve');
define('REJECT','reject');
define('DUPLICATE','duplicate');
define('MOVE','move');
define('BLOCK','block');
define('UNBLOCK','unblock');
define('COUNTRY_BIDDING','Country Bidding');
define('ZONE_LIMITATION','Zone Limitation');
define('ZONE_BIDDING','Zone bidding');
define('TRAFFIC_SOURCE','Traffic Source');
define('PIXEL_TRACKER','Pixel Tracker');
define('FORGET_PASSWORD','Forget Password');
/* Login modules and process */
define('LOGIN','login');
define('MANAGER','manager');
define('ADMIN','admin');
define('PUBLISHER','publisher');
define('ADVERTISER','advertiser');
define('DISABLE','disable');
define('ENABLE','enable');
define('CREATIVE_DIS','creative_disable');
define('CREATIVE_ENA','creative_enable');
/* Payments*/

define('PAYMENT','payment');
define('PAYMENT_REQUEST','payment_request');
define('PAYMENT_ADD','payment_add');

/*** Log Settings Admin Value**/
define('ENABLE_LOG','enable_log');
define('CAMPAIGNS','campaigns');
define('CAMP_APP','camp_app');
define('CAMP_REJ','camp_rej');
define('CAMP_ADD','camp_add');
define('CAMP_EDIT','camp_edit');

define('CAMP_DEL','camp_del');
define('CAMP_ACT','camp_act');
define('CAMP_DEACT','camp_deact');
define('CAMP_MOVED','camp_moved');
define('CAMP_DUP','camp_dup');
define('CREATIVES','creatives');
define('CREATIVE_APPR','creative_appr');
define('CREATIVE_REJ','creative_rej');
define('CREATIVE_ADD','creative_add');
define('CREATIVE_EDIT','creative_edit');
define('CREATIVE_DEL','creative_del');
define('PAYMENT_SETTINGS','payment_settings');
define('PAYMENT_APPR','payment_appr');
define('PAYMENT_REJECT','payment_reject');
define('PAYMENT_REQ','payment_req');
define('PAYMENT_PUB_REQ','payment_pub_req');
define('NETWORK','network');
define('PIXEL_TRACK_ADD','pixel_track_add');

define('PIXEL_TRACK_EDIT','pixel_track_edit');
define('PIXEL_TRACK_DEL','pixel_track_del');
define('TRAFFIC_SOURCE_ADD','traffic_source_add');
define('TRAFFIC_SOURCE_DEL','traffic_source_del');
define('ZONE_BIDDING_ADD','zone_bidding_add');
define('ZONE_BIDDING_DEL','zone_bidding_del');
define('ZONE_LIMIT_ADD','zone_limit_add');
define('ZONE_LIMIT_EDIT','zone_limit_edit');
define('ZONE_LIMIT_DEL','zone_limit_del');
//define('LOGIN','login');
define('FORGET_PWD','forget_pwd');
define('USER_ACCESS_BLOCK','user_access_block');
define('USER_ACCESS_UNBLOCK','user_access_unblock');
define('COUNTRY_BIDDING_ADD','country_bidding_add');
define('COUNTRY_BIDDING_EDIT','country_bidding_edit');
define('COUNTRY_BIDDING_DEL','country_bidding_del');
define('SITE','site');
define('SITE_ADD','site_add');
define('SITE_EDIT','site_edit');
define('SITE_DEL','site_del');
//define('APPS','apps');
define('APP_ADD','app_add');
define('APP_EDIT','app_edit');
define('APP_DEL','app_del');
define('ADBLOCK','adblock');
define('ADB_ADD','adb_add');
define('ADB_EDIT','adb_edit');
define('ADB_DELETE','adb_del');
define('CAMPAIGN_APPROVE','campaign_approve');
define('CAMPAIGN_REJECT','campaign_reject');
define('BANNER_APPROVE','banner_approve');
define('BANNER_REJECT','banner_reject');

/* Settings */
/*Modules*/
define('ACCOUNT_SETTINGS','account_settings');
/*Process*/
define('ACC_SETTINGS','acc_settings');
define('PERSONAL_INFORMATION','personal_info');
define('COMPANY_INFORMATION','company_info');
define('SECURTIY','security');
define('NOTIFICATION_SETTINGS','notification_settings');
//define('PAYMENT_SETTINGS','payment_settings');
define('PAYMENT_MODE','paymentmode');
/*Admin panel*/
define('NETWORK_USERS','network_users');
define('MANAGER_ADD','manager_add');
define('MANAGER_EDIT','manager_edit');
define('MANAGER_BLOCK','manager_block');
define('MANAGER_UNBLOCK','manager_unblock');
//define('ADVERTISER','advertiser');
define('ADVERTISER_ADD','advertiser_add');
define('ADVERTISER_EDIT','advertiser_edit');
define('ADVERTISER_DELETE','advertiser_delete');
define('ADVERTISER_BLOCK','advertiser_block');
define('ADVERTISER_UNBLOCK','advertiser_unblock');
define('PUBLISHER_ADD','publisher_add');
define('PUBLISHER_EDIT','publisher_edit');
define('PUBLISHER_DELETE','publisher_delete');
define('PUBLISHER_BLOCK','publisher_block');
define('PUBLISHER_UNBLOCK','publisher_unblock');
define('RTB','rtb');
define('RTB_ADD','rtb_add');
define('RTB_EDIT','rtb_edit');
define('RTB_BLOCK','rtb_block');
define('RTB_UNBLOCK','rtb_unblock');

define('ADMIN_APPROVALS','admin_approvals');
define('ADV_APPROVE','adv_approve');
define('ADV_REJECT','adv_reject');
define('PUB_APPROVE','pub_approve');
define('PUB_REJECT','pub_reject');
define('PUB_PAYMENT_APPROVAL','pub_payment_approve');
define('DRC_PAYMENT_APPROVAL','drc_payment_approve');
define('DRC_APPROVAL','drc_appove');
define('DRC_REJECT','drc_reject');
define('APP_APPROVAL','app_approve');
define('APP_REJECT','app_reject');
define('MOBILE_APP','Mobileapp');
define('DRCAMPAIGN','Direct Campaign');

/* Targeting */
define('MAIN_CATEGORY','Main category');
define('SUB_CATEGORY','Sub category');
define('CAT_TARGETING','category_targeting');
define('SUB_CAT_ADD','sub_cat_add');
define('SUB_CAT_EDIT','sub_cat_edit');
define('SUB_CAT_DELETE','sub_cat_delete');
define('SUB_CAT_BLOCK','sub_cat_block');
define('SUB_CAT_UNBLOCK','sub_cat_unblock');
define('MAIN_CAT_ADD','main_cat_add');
define('MAIN_CAT_EDIT','main_cat_edit');
define('MAIN_CAT_DELETE','main_cat_delete');
define('MAIN_CAT_BLOCK','main_cat_block');
define('MAIN_CAT_UNBLOCK','main_cat_unblock');
define('OS','os');
define('DEVICE','device');
define('DEVICE_OS','device_os');
define('DEVICE_ADD','device_add');
define('DEVICE_EDIT','device_edit');
define('DEVICE_DELETE','device_delete');
define('DEVICE_BLOCK','device_block');
define('DEVICE_UNBLOCK','device_unblock');
define('OS_ADD','os_add');
define('OS_EDIT','os_edit');
define('OS_DELETE','os_delete');
define('OS_BLOCK','os_block');
define('OS_UNBLOCK','os_unblock');
define('BROWSERS','browsers');
define('BROWSERS_LANG','browsers_lang');
define('BROWSER_ADD','browser_add');
define('BROWSER_EDIT','browser_edit');
define('BROWSER_DELETE','browser_delete');
define('BROWSER_BLOCK','browser_block');
define('LANGUAGE','language');
define('BROWSER_UNBLOCK','browser_unblock');
define('BROWSER_LANG_ADD','browser_lang_add');
define('BROWSER_LANG_EDIT','browser_lang_edit');
define('BROWSER_LANG_DELETE','browser_lang_delete');
define('BROWSER_LANG_BLOCK','browser_lang_block');
define('BROWSER_LANG_UNBLOCK','browser_lang_unblock');
define('MANUFACTURES','manufactures');
define('MANUFACTURE_CAP','manufacture_cap');
define('MANUFACTURER_ADD','manufacturer_add');
define('MANUFACTURER_EDIT','manufacturer_edit');
define('MANUFACTURER_DELETE','manufacturer_delete');
define('MANUFACTURER_BLOCK','manufacturer_block');
define('MANUFACTURER_UNBLOCK','manufacturer_unblock');
define('CAPABILITY','capability');
define('CAP_ADD','cap_add');
define('CAP_EDIT','cap_edit');
define('CAP_DELETE','cap_delete');
define('CAP_BLOCK','cap_block');
define('CAP_UNBLOCK','cap_unblock');
define('ISP_CONNECTION','isp_connection');
define('CONNECTION','connection');
define('CONNECTION_ISP','connection_isp');
define('CONNECTION_ADD','connection_add');
define('CONNECTION_EDIT','connection_edit');
define('CONNECTION_DELETE','connection_delete');
define('CONNECTION_BLOCK','connection_block');
define('CONNECTION_UNBLOCK','connection_unblock');
define('ISP','isp');
define('ISP_ADD','isp_add');
define('ISP_EDIT','isp_edit');
define('ISP_DELETE','isp_delete');
define('ISP_BLOCK','isp_block');
define('ISP_UNBLOCK','isp_unblock');
define('CONTEXTUAL','contextual');
define('KEYWORD','keyword');
define('KEYWORD_ADD','keyword_add');
define('KEYWORD_EDIT','keyword_edit');
define('KEYWORD_DELETE','keyword_delete');
define('KEYWORD_BLOCK','keyword_block');
define('KEYWORD_UNBLOCK','keyword_unblock');
define('CAMPAIGN_APPROVES','campaign+approve');
define('CAMPAIGN_REJECTS','campaign+reject');
define('BANNER_APPROVES','banner+approve');
define('BANNER_REJECTS','banner+reject');
define('ADVERTISER_APPROVE','advertiser+approve');
define('ADVERTISER_REJECT','advertiser+reject');
define('PUBLISHER_APPROVE','publisher+approve');
define('PUBLISHER_REJECT','publisher+reject');
define('PAYMENT_APPROVE','payment+approve');
define('PAYMENTS_REJECT','payment+reject');
define('MAKE_PUBLISHER_PAYMENT','publisher+pub_payment_approve');
define('DRC_PAYMENT_APPROVES','publisher+drc_payment_approve');
define('DRC_APPROVES','Direct Campaign+approve');
define('DRC_REJECTS','Direct Campaign+reject');
define('MOBILE_APP_APPROVE','Mobileapp+approve');
define('MOBILE_APP_REJECT','Mobileapp+reject');

/* admin_settings*/
define('ADMIN_SETTINGS','admin_settings');
define('BILLING_INFO','billing_info');
define('USER_ROLE_FORM','user_role');
define('PAYMENT_CHANGES','payment_changes');
define('PAYMENT_TYPE_CHANGE','type_change');
define('CPM_GEO','geo');
define('CPM_ADD','cpm_add');
define('CPM_EDIT','cpm_edit');
define('CPM_DELETE','cpm_delete');
define('CPM_BLOCK','cpm_block');
define('CPM_UNBLOCK','cpm_unblock');
define('SCREEN','screen');
define('SCREEN_ADD','screen_add');
define('SCREEN_EDIT','screen_edit');
define('SCREEN_BLOCK','screen_block');
define('SCREEN_UNBLOCK','screen_unblock');
define('ADBLOCK_DOMAIN','domain');
define('DOMAIN_ADD','domain_add');
define('DOMAIN_EDIT','domain_edit');
define('DOMAIN_DELETE','domain_delete');
define('DOMAIN_BLOCK','domain_block');
define('DOMAIN_UNBLOCK','domain_unblock');
define('DOMAIN_CHANGES','domain_changes'); 
//define('MANAGER','manager');
define('HOUSE_CAMPAIGN','house_campaign');

/**** SUB ACCOUNTS ****/
define('TAB_SUB_ACCOUNT_ROLES','djax_sub_account_roles');
define('TAB_SUB_ACCOUNT_ROLE_ASSOC','djax_sub_account_role_assoc');
define('TAB_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC','djax_sub_account_role_permission_assoc');
define('TAB_SUB_ACCOUNT_MODULE_PERMISSION','djax_user_module_permissions');
define('FETCH_SUB_ACCOUNT_ROLE_PERMISSION_ASSOC','get_sub_account_role_permission_assoc');
define('FETCH_SUB_ACCOUNT_ROLE_PERMISSION','get_sub_account_role_permission');
/**** SUB ACCOUNTS ****/


/******NEWSLETTER TEMPLATE*****/
define('TAB_NEWSLETTER','djax_newsletter_template');
define('FETCH_NEWSLETTER','fetch_newsletter_template');
define('FETCH_NEWSLETTER_SETTINGS','fetch_newsletter_template_set');
define('FETCH_ALL_EMAIL_TEMPLATE','fetch_email_template');
define('TAB_NEWS','djax_news');
define('TAB_ADMDESC','djax_admarket_description');

//define('ZONE_BIDDING','Zone Bidding');

/******NEWSLETTER TEMPLATE*****/
/*Adblock Domains*/

 
 

/*
 * MEMCACHE CONSTANTS
 */
/* End of file constants.php */
/* Location: ./application/config/constants.php */
