<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------
| AUTO-LOADER
| -------------------------------------------------------------------
| This file specifies which systems should be loaded by default.
|
| In order to keep the framework as light-weight as possible only the
| absolute minimal resources are loaded by default. For example,
| the database is not connected to automatically since no assumption
| is made regarding whether you intend to use it.  This file lets
| you globally define which systems you would like loaded with every
| request.
|
| -------------------------------------------------------------------
| Instructions
| -------------------------------------------------------------------
|
| These are the things you can load automatically:
|
| 1. Packages
| 2. Libraries
| 3. Helper files
| 4. Custom config files
| 5. Language files
| 6. Models
|
*/

/*
| -------------------------------------------------------------------
|  Auto-load Packges
| -------------------------------------------------------------------
| Prototype:
|
|  $autoload['packages'] = array(APPPATH.'third_party', '/usr/local/shared');
|
*/

$autoload['packages'] = array();


/*
| -------------------------------------------------------------------
|  Auto-load Libraries
| -------------------------------------------------------------------
| These are the classes located in the system/libraries folder
| or in your application/libraries folder.
|
| Prototype:
|
|	$autoload['libraries'] = array('database', 'session', 'xmlrpc');
*/

$autoload['libraries'] = array('database','template','autoacl','template_widget','form_validation','upload','image_lib','Default_configurations','UASparser','encrypt');


/*
| -------------------------------------------------------------------
|  Auto-load Helper Files
| -------------------------------------------------------------------
| Prototype:
|
|	$autoload['helper'] = array('url', 'file');
*/

$autoload['helper'] = array('url','security','breadcrumb','sidebar_widget','utilities','form');


/*
| -------------------------------------------------------------------
|  Auto-load Config files
| -------------------------------------------------------------------
| Prototype:
|
|	$autoload['config'] = array('config1', 'config2');
|
| NOTE: This item is intended for use ONLY if you have created custom
| config files.  Otherwise, leave it blank.
|
*/

$autoload['config'] = array('template','sidebar_settings');


/*
| -------------------------------------------------------------------
|  Auto-load Language files
| -------------------------------------------------------------------
| Prototype:
|
|	$autoload['language'] = array('lang1', 'lang2');
|
| NOTE: Do not include the "_lang" part of your file.  For example
| "codeigniter_lang.php" would be referenced as array('codeigniter');
|
*/

//$autoload['language'] = array('home_page','adv_dashboard','onetime_wizard','campaign','report','country_wise_bidding','settings','personal_info','security_info', 'creative','zone_bidding','traffic_sources','macro','massemail_info','userroles_info','zone_limitation','top_sources','admarket','pixel','pub_dashboard','sites','pub_payment_info','app','pub_adblock','sub_account','admin_dashboard','payments','approval','network_manager','targeting','admin_analytics','users', 'rtb');

$autoload['language'] = array('home_page','adv_dashboard','campaign','onetime_wizard','report','country_wise_bidding','settings','personal_info','security_info','creative','zone_bidding','traffic_sources','macro','massemail_info','userroles_info','zone_limitation','top_sources','admarket','pixel','pub_dashboard','sites','pub_payment_info','app','pub_adblock','sub_account','admin_dashboard','payments','approval','network_manager','targeting','admin_analytics','users','rtb','admin_appconfig','adcode','careers');



/*
| -------------------------------------------------------------------
|  Auto-load Models
| -------------------------------------------------------------------
| Prototype:
|
|	$autoload['model'] = array('model1', 'model2');
|
*/

$autoload['model'] = array('api.v_1/do_app_config');


/* End of file autoload.php */
/* Location: ./application/config/autoload.php */
