(function($){

	  $.fn.ads = function(options) {
		  
			var element = $(this);
					
			var settings = $.extend({
										
				setContainer:{
					container:true,					
					center:true,
					setCustomize:{
						customize:true,
						width:728,
						height:300,
						widthAndHeightOnly:true,
						from:{
							//this is shift to nagative values
							top:0,
							left:100,
							right:-100,
							bottom:-100
						},
						to:{
							top:100,
							left:100,
							right:100,
							bottom:100
						}
					},					
					direction:'left',
					scroll:true
					
				},				
				setTitle:{
					title:true,
					width:'auto',
					height:20,
					font:'12px/20px arial',
					color:'#000000'					
				},				
				setTopBanner:{
					banner:false,
					width:'100%',
					height:60,
					setImage:{
						image:true,
						width:'auto',
						height:'auto'
					},
					setIframe:{
						iframe:true,
						width:'100%',
						height:'100px'   
					}					
				},	
				setMiddleBanner:{
					banner:true,
					width:'auto',
					height:'auto',
					setImage:{
						image:true,
						width:'auto',
						height:'auto'
					},
					setIframe:{
						iframe:false,
						width:'100%',
						height:'100px'   
					}				
				},
				setBottomBanner:{
					banner:false,
					width:'100%',
					height:'auto',
					setImage:{
						image:true,
						width:'auto',
						height:'auto'
					},
					setIframe:{
						iframe:true,
						width:'100%',
						height:'100px'   
					}					
				},
				setClose:{
					close:true,
					width:'100%',
					height:'auto',
					setRedirect:{
						redirect:false,
						url:'',
						target:'_blank'
					}				
				}
				      
			},options);	
			
			
									
						
			return this.each(function(e){ 
				
				var sWidth = Math.min(window.innerWidth, window.outerWidth);
				var sHeight = Math.min(window.innerHeight, window.outerHeight);														
								
				//title				
				if(settings.setTitle.title == true){
					
					$('.title',e).show();
					createTitle(element,settings);
					
				}else{
					
					$('.title',e).hide();
					
				}								
				
				//top banner
				if(settings.setTopBanner.banner == true){
					
					$('.topBanner',e).show();					
					createTopBanner(element,settings);
					
				}else{
					
					$('.topBanner',e).hide();
					
				}
				
				//middle banner
				if(settings.setMiddleBanner.banner == true){
					
					$('.middleBanner',e).show();					
					createMiddleBanner(element,settings);
					
				}else{
					
					$('.middleBanner',e).hide();
					
				}
				
				//bottom banner
				if(settings.setBottomBanner.banner == true){
					
					$('.bottomBanner',e).show();
					createBottomBanner(element,settings);
					
				}else{
					
					$('.bottomBanner',e).hide();
					
				}
				
				//container				
				if(settings.setContainer.container == true){
					
					$('.container',e).show();
					createContainer(element,settings);
					
				}else{
					
					$('.container',e).hide();
					
				}	
				
				setDirection(element,settings,sWidth,sHeight);				
				setBox(element,settings,sWidth,sHeight);								
				setTimeout(setAnimations,1000,this,settings,sWidth,sHeight);
				
				//close button
				
				if(settings.setClose.close == true){
					
					$('.close',element).click(function(){
						
							if(settings.setClose.setRedirect.redirect == true){
															
								window.open(settings.setClose.setRedirect.url,settings.setClose.setRedirect.target);		
											
							}
							
							$(element).hide();
							
					})					
					
				}else{
					
					$('.close',element).hide();
				
				}				
								
				
			});
						
			function setBox(e,s,w,h){
				
							
				var b = {};
				
								
				if(s.setContainer.direction == "left"){ 									
					b['top'] = s.setContainer.setCustomize.from.top;
					b['left'] = s.setContainer.setCustomize.from.left;
					b['right'] = 'auto';
					b['bottom'] =  'auto';
					
				}else if(s.setContainer.direction == "top"){
					
					b['top'] = s.setContainer.setCustomize.from.top;
					b['left'] = s.setContainer.setCustomize.from.left;
					b['right'] = 'auto';
					b['bottom'] =  'auto';
					
				}else if(s.setContainer.direction == "right"){				
					
					b['top'] = s.setContainer.setCustomize.from.top;
					b['left'] = 'auto';
					b['right'] = s.setContainer.setCustomize.from.right;
					b['bottom'] =  'auto';
					
					
					
				}else if(s.setContainer.direction == "bottom"){
									
					b['top'] = 'auto';
					b['left'] = s.setContainer.setCustomize.from.left;
					b['right'] = 'auto';
					b['bottom'] =  s.setContainer.setCustomize.from.bottom;
					
				}
				
				if(s.setContainer.scroll == true){
					b['position'] = 'fixed';
				}else{
					b['position'] = 'absolute';
				}													
														
				$(e).css(b);					
												
			}
			
			function setDirection(e,s,w,h){			
												
				switch(s.setContainer.direction){					
			
					case 'left':						  
						  if(s.setContainer.center == true){
							  
							  if(s.setContainer.setCustomize.customize == true && s.setContainer.setCustomize.widthAndHeightOnly == false){
								 s.setContainer.setCustomize.from.top = s.setContainer.setCustomize.from.top;
							     s.setContainer.setCustomize.from.left = s.setContainer.setCustomize.from.left;
						      }else{  
								 s.setContainer.setCustomize.from.top = (h / 2) - (s.setContainer.setCustomize.height / 2);
								 s.setContainer.setCustomize.from.left = - w; 
							  }
							  
						  }else{
							  
							  s.setContainer.setCustomize.from.top = s.setContainer.setCustomize.from.top;
							  s.setContainer.setCustomize.from.left = s.setContainer.setCustomize.from.left;
						  }						  				  
						  						  
						  break;
						  
					case 'right':
					
						  if(s.setContainer.center == true){
							  
							  if(s.setContainer.setCustomize.customize == true && s.setContainer.setCustomize.widthAndHeightOnly == false){								  
								  s.setContainer.setCustomize.from.top = s.setContainer.setCustomize.from.top;
								  s.setContainer.setCustomize.from.right = s.setContainer.setCustomize.from.right;
						      }else{ 								  
								  s.setContainer.setCustomize.from.top = (h / 2) - (s.setContainer.setCustomize.height / 2);
								  s.setContainer.setCustomize.from.right = - w;
							  }
							  
						  }else{
							  s.setContainer.setCustomize.from.top = s.setContainer.setCustomize.from.top;
							  s.setContainer.setCustomize.from.right = s.setContainer.setCustomize.from.right;
						  }
						  						  					  
						  break;
						  
					case 'top':
					
						  if(s.setContainer.center == true){
							  
							  if(s.setContainer.setCustomize.customize == true && s.setContainer.setCustomize.widthAndHeightOnly == false){								  
								  s.setContainer.setCustomize.from.top = s.setContainer.setCustomize.from.top;
								  s.setContainer.setCustomize.from.left = s.setContainer.setCustomize.from.left ;							  
						      }else{ 								  
								  s.setContainer.setCustomize.from.top = - h;
								  s.setContainer.setCustomize.from.left = (w / 2) - (s.setContainer.setCustomize.width / 2);
							  }
							  
						  }else{
							  s.setContainer.setCustomize.from.top = s.setContainer.setCustomize.from.top;
							  s.setContainer.setCustomize.from.left = s.setContainer.setCustomize.from.left;
						  }	
						  				  
						  break;
						  
					case 'bottom':					      	
					      	
					      if(s.setContainer.center == true){
							  
							  if(s.setContainer.setCustomize.customize == true && s.setContainer.setCustomize.widthAndHeightOnly == false){
								  s.setContainer.setCustomize.from.bottom = s.setContainer.setCustomize.from.bottom;
								  s.setContainer.setCustomize.from.left = s.setContainer.setCustomize.from.left;
						      }else{ 								  
								  s.setContainer.setCustomize.from.bottom = - h;
								  s.setContainer.setCustomize.from.left = (w / 2) - (s.setContainer.setCustomize.width / 2);
							  }
							  
						  }else{
							  s.setContainer.setCustomize.from.bottom = s.setContainer.setCustomize.from.bottom;
							  s.setContainer.setCustomize.from.left = s.setContainer.setCustomize.from.left;
						  }	
						  						  						  
						  break;					  
						  
				
				}
				
			}		
			
			function setAnimations(e,s,w,h){
				
				var a = {};
				
				
				
				if(s.setContainer.direction == "left"){
					
					if(s.setContainer.center == true){					
						a['top'] = (h / 2) - (s.setContainer.setCustomize.height / 2);
						a['left'] = (w / 2) - (s.setContainer.setCustomize.width / 2);
						a['right'] = 'auto';
						a['bottm'] =  'auto';
					}else{						
						a['top'] = s.setContainer.setCustomize.to.top;
						a['left'] = s.setContainer.setCustomize.to.left;
						a['right'] = 'auto';
						a['bottm'] =  'auto';
					}
					
				}else if(s.setContainer.direction == "top"){							
					
					if(s.setContainer.center == true){					
						a['top'] = (h / 2) - (s.setContainer.setCustomize.height / 2);
						a['left'] = (w / 2) - (s.setContainer.setCustomize.width / 2);
						a['right'] = 'auto';
						a['bottm'] =  'auto';
					}else{						
						a['top'] = s.setContainer.setCustomize.to.top;
						a['left'] = s.setContainer.setCustomize.to.left;
						a['right'] = 'auto';
						a['bottm'] =  'auto';
					}
					
				}else if(s.setContainer.direction == "right"){
					
					if(s.setContainer.center == true){		
						a['top'] =0;// (h / 2) - (s.setContainer.setCustomize.height / 2); (DAC020 )
						a['right'] = (w / 2) - (s.setContainer.setCustomize.width / 2);
						a['left'] = 'auto';
						a['bottm'] =  'auto';
					}else{	
						a['top'] = s.setContainer.setCustomize.to.top;
						a['right'] = s.setContainer.setCustomize.to.right;
						a['left'] = 'auto';
						a['bottm'] =  'auto';
					}
					
										
				}else if(s.setContainer.direction == "bottom"){
					
					if(s.setContainer.center == true){					
						a['bottom'] = (h / 2) - (s.setContainer.setCustomize.height / 2);
						a['left'] = (w / 2) - (s.setContainer.setCustomize.width / 2);
						a['top'] = 'auto';
						a['right'] =  'auto';
					}else{						
						a['bottom'] = s.setContainer.setCustomize.to.bottom;
						a['left'] = s.setContainer.setCustomize.to.right;
						a['top'] = 'auto';
						a['right'] =  'auto';
					}
					
				}
								
				$(e).animate(a,500);				
				
			}
			
			function createTitle(e,s){			
				
				$('.title',e).css({
						'width':s.setTitle.width,
						'height':s.setTitle.height,
						'font':s.setTitle.font,
						'color':s.setTitle.color
				});
							
			}
			
			function createTopBanner(e,s){				
				
				$('.topBanner',e).css({
						'width':s.setTopBanner.width,
						'height':s.setTopBanner.height
				});
				
				//set image				
				if(s.setTopBanner.setImage.image == true){
					$('.topBanner .image',e).css({
							'width':s.setTopBanner.setImage.width,
							'height':s.setTopBanner.setImage.height
					});
				}else{
					$('.topBanner .image',e).hide();
				}
								
				//set iframe				
				if(s.setTopBanner.setIframe.iframe == true){
					$('.topBanner .iframe',e).css({
							'width':s.setTopBanner.setIframe.width,
							'height':s.setTopBanner.setIframe.height
					});
				}else{
					$('.topBanner .iframe',e).hide();
				}
							
			}
			
			function createMiddleBanner(e,s){
				
				
				$('.middleBanner',e).css({
						'width':s.setMiddleBanner.width,
						'height':s.setMiddleBanner.height
				});
				
				
				if(s.setMiddleBanner.width == "auto"){
					s.setMiddleBanner.width = $('.middleBanner .image',e).width();
					$('.middleBanner',e).width(s.setMiddleBanner.width);
				}
				
				//set image				
				if(s.setMiddleBanner.setImage.image == true){
					$('.middleBanner .image',e).css({
							'width':s.setMiddleBanner.setImage.width,
							'height':s.setMiddleBanner.setImage.height
					});
				}else{
					$('.middleBanner .image',e).hide();
				}
								
				//set iframe				
				if(s.setMiddleBanner.setIframe.iframe == true){
					$('.middleBanner .iframe',e).css({
							'width':s.setMiddleBanner.setIframe.width,
							'height':s.setMiddleBanner.setIframe.height
					});
				}else{
					$('.middleBanner .iframe',e).hide();
				}
							
			}
			
			function createBottomBanner(e,s){
				
				
				$('.bottomBanner',e).css({
						'width':s.setBottomBanner.width,
						'height':s.setBottomBanner.height
				});
				
				//set image				
				if(s.setBottomBanner.setImage.image == true){
					$('.bottomBanner .image',e).css({
							'width':s.setBottomBanner.setImage.width,
							'height':s.setBottomBanner.setImage.height
					});
				}else{
					$('.bottomBanner .image',e).hide();
				}
								
				//set iframe				
				if(s.setBottomBanner.setIframe.iframe == true){
					$('.bottomBanner .iframe',e).css({
							'width':s.setBottomBanner.setIframe.width,
							'height':s.setBottomBanner.setIframe.height
					});
				}else{
					$('.bottomBanner .iframe',e).hide();
				}			
			}
			
			function createContainer(e,s){	
						
				
				
				//implement width and height	
				
				if(s.setContainer.setCustomize.customize == true){	
					
					if(s.setContainer.setCustomize.width == 'auto'){
						s.setContainer.setCustomize.width = $(e).width();
					}
					
					if(s.setContainer.setCustomize.height == 'auto'){
						s.setContainer.setCustomize.height = $(e).height();
					}						
					
					$('.container').css({
						//'width':s.setContainer.setCustomize.width//,
						//'height':s.setContainer.setCustomize.height
					});
				
				}else{
					
					s.setContainer.setCustomize.width = $(e).width();
					s.setContainer.setCustomize.height = $(e).height();			
					
					$('.container').css({
							//'width':s.setContainer.setCustomize.width//,
							//'height':s.setContainer.setCustomize.height
					});					
				}		
										
			}
					
	  };

}(jQuery));
