<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/


MAX_Dal_Delivery_Include();

function Plugin_deliveryLog_oxLogVast_logImpressionVast_Delivery_logImpressionVast($adId = 0, $zoneId = 0, $okToLog = true)
{
    $aData = $GLOBALS['_MAX']['deliveryData'];

    if (!$okToLog || empty($aData['interval_start']) || empty($aData['vast_event_id'])) {
        return false;
    }
	
	/* Fetch Campaignid */
	$aConf = $GLOBALS['_MAX']['CONF'];
	$SQL="select c.campaignid as campaignid,c.cpv_percentage as percentage from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." as c JOIN ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." as b ON b.campaignid=c.campaignid where b.bannerid=".$aData['creative_id'];
	$vast_query=OA_Dal_Delivery_query($SQL);
	$vast_result=OA_Dal_Delivery_fetchAssoc($vast_query);
	$cpv_percentage=$vast_result['percentage'];
	
	if($cpv_percentage=="25")
	{
		$vast_id="3";
	}
	else if($cpv_percentage=="50")	
	{
		$vast_id="2";
	}
	else if($cpv_percentage=="75")	
	{
		$vast_id="4";
	}
	else if($cpv_percentage=="100")	
	{
		$vast_id="5";
	}
	$request_id=$_REQUEST['request_id'];

	/* Special bidding options */
	$traffic_bid_rate=0;
	$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['affiliates'])." as oxa join ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])." as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$aData['zone_id'].") AND campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].")";
	$special_bidding=OA_Dal_Delivery_query($traffic_query);
	$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);  
	$traffic_bid_rate=$traffic_result['bid_rate']; 
				
														
	/* Countrywise bidding based on the campaign */	
	$country_val=$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
	$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='1' AND country_value='$country_val'";
	$special_country_bidding=OA_Dal_Delivery_query($country_query);
	$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
	$country_bid_rate=$bidding_result['bidding_value']; 
				
	$win_bid=djax_win_bid_cpm($request_id);
	
	if(!empty($traffic_bid_rate))
		{
		    $win_bid['win_bid_amount']= $traffic_bid_rate;
		}
	else
		{
		    $win_bid['win_bid_amount'] = $win_bid['win_bid_amount'];
		}
		
	if(!empty($country_bid_rate))
		{
			$win_bid['win_bid_amount']=$country_bid_rate;
		}
				
	if(!empty($win_bid))
		{
			$detect_spent_amt=djax_detect_spent_amt($win_bid);
		}
	
	$publisher_percentage=djax_publisher_share($aData['zone_id']);
	$publisershare=$win_bid['win_bid_amount']*($publisher_percentage/100);
	$winning_bid=$win_bid['win_bid_amount'];
	$admin_revenue=$winning_bid-$publisershare;

	$zone_id=$aData['zone_id'];
	$creative_id=$aData['creative_id'];
	
	/* Fetch value from DB */
	$db_query="select dj_win_bid,dj_publisher_revenue,dj_admin_revenue from rv_data_bkt_vast_e where dj_request_id='$request_id' AND zone_id='$zone_id' AND creative_id='$creative_id' AND vast_event_id='$vast_id'";
	$db_qry=OA_Dal_Delivery_query($db_query);
	if(OA_Dal_Delivery_numRows($db_qry)>0)
	{
	$db_result=OA_Dal_Delivery_fetchAssoc($db_qry);
	$db_win_bid=$db_result['dj_win_bid']; 
	$db_publishershare=$db_result['dj_publisher_revenue']; 
	$db_admin_revenue=$db_result['dj_admin_revenue']; 
	  if($vast_id==$aData['vast_event_id'])
	  { 
		$winning_bid=$winning_bid+$db_win_bid;
		$publishershare=$publisershare+$db_publishershare;
		$admin_revenue=$admin_revenue+$db_admin_revenue;	
	  }
	  else
	  { 
		$winning_bid="0.0000";
		$publishershare="0.0000";
		$admin_revenue="0.0000";
	  }	
	
	}
	else
	{
	  if($vast_id==$aData['vast_event_id'])
	  {  
		$winning_bid=$winning_bid;
		$publishershare=$publisershare;
		$admin_revenue=$admin_revenue;	
	  }
	  else
	  {  
		$winning_bid="0.0000";
		$publishershare="0.0000";
		$admin_revenue="0.0000";
	  }
	}
	
	
		$aQuery = array(
        'interval_start' => $aData['interval_start'],
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
        'vast_event_id'  => $aData['vast_event_id'],
		'dj_request_id'  => $request_id,
		'dj_win_bid'	 => $winning_bid,
		'dj_publisher_revenue'=>$publishershare,
		'dj_admin_revenue'=> $admin_revenue		    	
    );
	
	/*$to = "renukadevi.ciet@gmail.com";
	$subject = "From click";
	$txt = $djax_win_bid_cpc['win_bid_amount'];
	$txt.= OX_bucket_updateTable('data_bkt_c', $aQuery);
	$headers = "From: webmaster@example.com" . "\r\n" .
	"CC: somebodyelse@example.com";

	mail($to,$subject,$txt,$headers);*/
 
	return OX_bucket_updateTable('data_bkt_vast_e', $aQuery);
}

function djax_win_bid_cpm($request_id)
{	
		$aConf = $GLOBALS['_MAX']['CONF'];

		$query="select r.win_bid_amount as win_bid_amount,c.clientid as clientid,c.campaignid as campaignid,c.dj_campaign_remain_budget as dj_campaign_remain_budget,dj_campaign_remain_total_budget as dj_campaign_remain_total_budget from 
		".OX_escapeIdentifier($aConf['table']['djax_track_ad_responses'])." AS r,  
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  AS c,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])."  AS b
		where r.request_id='$request_id' and  b.bannerid=r.ad_id and r.win_status='1' and c.revenue_type='7' and b.campaignid=c.campaignid";		
						
		$rAdResponse=OA_Dal_Delivery_query($query);

		$result=OA_Dal_Delivery_fetchAssoc($rAdResponse);
				
		return $result;
}
function djax_publisher_share($zoneid)
	{
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		$chk_pub_share="select a.dj_share_per as dj_share_per from 
		
		".$aConf['table']['prefix'].$aConf['table']['affiliates']." AS a,
		".$aConf['table']['prefix'].$aConf['table']['zones']." AS z
		
		where z.affiliateid=a.affiliateid and z.zoneid='$zoneid'";
		
		$rsResult = OA_Dal_Delivery_query($chk_pub_share);
					       
		$fetch_record=OA_Dal_Delivery_fetchAssoc($rsResult);
					
		if(!empty($fetch_record['dj_share_per']))
		{
			return $fetch_record['dj_share_per'];
		}
		else
		{
			$chk_pub_share="select pub_min_share from ".$aConf['table']['djax_app_configurations']."";
			$rsResult = OA_Dal_Delivery_query($chk_pub_share);
			$fetch_record=OA_Dal_Delivery_fetchAssoc($rsResult);
			return $fetch_record['pub_min_share'];
		}
		
}
function djax_detect_spent_amt($results)
{  
		
		$aConf = $GLOBALS['_MAX']['CONF'];

		$status='and dj_is_default!=1';
		
		$query="select dj_cur_balance,dj_is_default from
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." 
		where clientid='".$results['clientid']."' $status ";
		
		$rAdResponse=OA_Dal_Delivery_query($query);
						
		if(OA_Dal_Delivery_numRows($rAdResponse) > 0)
		{
			$res=OA_Dal_Delivery_fetchAssoc($rAdResponse);
			
			if($res['dj_cur_balance']>0)
			{
				$remain_balance=$results['dj_campaign_remain_budget'] + $results['win_bid_amount'];
				
				$current_balance=$res['dj_cur_balance'] - $results['win_bid_amount'];
			
				$remain_total_balance=$results['dj_campaign_remain_total_budget'] + $results['win_bid_amount'];

				//////Update Remain budget
				$budget = OA_Dal_Delivery_query("SELECT dj_campaign_budget,dj_daily_budget FROM 
				
				".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
				where campaignid='".$results['campaignid']."'");
				
				$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);

				$campaign_budget = $fetch_budget['dj_campaign_budget'];

				$campaign_daily_budget = $fetch_budget['dj_daily_budget'];
				
				$campaign_remaining_budget = $campaign_budget - $remain_total_balance;

				$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance;

				if($campaign_remaining_budget > 0 && $campaign_remaining_daily_budget > 0)
				{			
			
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");

					if($res['dj_is_default']!='2')
					{
							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])."  
							set dj_cur_balance='$current_balance' where clientid='".$results['clientid']."'");
					}
				}
			}
		}
}

