<?php  
function parseDeliveryIniFile($configPath = null, $configFile = null, $sections = true)
{
	if (!$configPath)
	{
		$configPath = MAX_PATH . '/var';
	}
	if ($configFile)
	{
		$configFile = '.' . $configFile;
	}
	$host = OX_getHostName();
	$configFileName = $configPath . '/' . $host . $configFile . '.conf.php';
	$conf = @parse_ini_file($configFileName, $sections);
	if (isset($conf['realConfig']))
	{
		$realconf = @parse_ini_file(MAX_PATH . '/var/' . $conf['realConfig'] . '.conf.php', $sections);
		$conf = mergeConfigFiles($realconf, $conf);
	}
	if (!empty($conf))
	{
		return $conf;
	}
	elseif ($configFile === '.plugin')
	{
		$pluginType = basename($configPath);
		$defaultConfig = MAX_PATH . '/plugins/' . $pluginType . '/default.plugin.conf.php';
		$conf = @parse_ini_file($defaultConfig, $sections);
		if ($conf !== false) {
		return $conf;
		}
		echo "Revive Adserver could not read the default configuration file for the {$pluginType} plugin";
		exit(1);
	}
	$configFileName = $configPath . '/default' . $configFile . '.conf.php';
	$conf = @parse_ini_file($configFileName, $sections);
	if (isset($conf['realConfig']))
	{
		$conf = @parse_ini_file(MAX_PATH . '/var/' . $conf['realConfig'] . '.conf.php', $sections);
	}
	if (!empty($conf))
	{
		return $conf;
	}
	if (file_exists(MAX_PATH . '/var/INSTALLED'))
	{
		echo "Revive Adserver has been installed, but no configuration file was found.\n";
		exit(1);
	}
		echo "Revive Adserver has not been installed yet -- please read the INSTALL.txt file.\n";
		exit(1);
}

function OX_getHostName()
{
	if (!empty($_SERVER['HTTP_HOST']))
	{
	$host = explode(':', $_SERVER['HTTP_HOST']);
	$host = $host[0];
	}
	else if (!empty($_SERVER['SERVER_NAME']))
	{
	$host = explode(':', $_SERVER['SERVER_NAME']);
	$host = $host[0];
	}
	return $host;
}

function MAX_javascriptToHTML($string, $varName, $output = true, $localScope = true)
{
			$jsLines = array();
			$search[] = "\\"; $replace[] = "\\\\";
			$search[] = "\r"; $replace[] = '';
			$search[] = '"'; $replace[] = '\"';
			$search[] = "'"; $replace[] = "\\'";
			$search[] = '<'; $replace[] = '<"+"';
			$string = str_replace($search, $replace, $string);
			$lines = explode("\n", $string);
			foreach ($lines AS $line) {
			if(trim($line) != '') {
			$jsLines[] = $varName . ' += "' . trim($line) . '\n";';
			}
			}
			$buffer = (($localScope) ? 'var ' : '') . $varName ." = '';\n";
			$buffer .= implode("\n", $jsLines);
			if ($output == true) {
			$buffer .= "\ndocument.write({$varName});\n";
			}
			return $buffer;
}

if (!defined('MAX_PATH'))
{
define('MAX_PATH', dirname(__FILE__).'/../..');
}

if ( !(isset($GLOBALS['_MAX']['CONF'])))
{
$GLOBALS['_MAX']['CONF'] = parseDeliveryIniFile();
}

function fetch_domain()
{
	$domain_query = OA_Dal_Delivery_query("SELECT * FROM djax_adblock_domains where status='1' AND is_deleted='0'");
	$domain_result=array();
	if (OA_Dal_Delivery_numRows($domain_query) > 0)
		{ 
			while($res = OA_Dal_Delivery_fetchAssoc($domain_query))
				{		
					$domain_result[]=$res['url'];
				}		
				$rand_keys=array_rand($domain_result,1);		
				$domain=$domain_result[$rand_keys];	
				return $domain;						
		}									
}

		/*Djax Custom methods*/

		function djax_methods()
		{
			require_once 'djax_tracking.php';
		}

		function viewer_tracking()
		{
				session_start();
				djax_methods();

				/*Get country name for country code*/
				$country_code  = $GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
				$country_query = OA_Dal_Delivery_query("SELECT name FROM djax_targ_country WHERE value='$country_code'");
				
				$fetch_country = OA_Dal_Delivery_fetchAssoc($country_query);
				
				$country_name = ucfirst($fetch_country['name']);
				
				/*Get country name for country code*/
				$viewrid = $GLOBALS['_MAX']['CONF']['var']['viewrid'];
				if (isset($_COOKIE[$viewrid])) { 
				$viewer_id = $_COOKIE[$viewrid]; ///Need to chk this cache			
				} else {  
				$viewer_id = djax_tracking_viewer($country_name);
				}	
				
				$zoneid = $GLOBALS['zoneid'];
								
				$z = djax_tracking_ad_request($viewer_id, $zoneid, $country_name);
							
				$_SESSION['request_id'] = $z;

		}

		
/*DAC020-Calculate priority based on countrybidding*/

function _setPriorityFromcountry(&$aAds,$client_bidding)
{
	if (!count($aAds)) {
	return 0;
	}
	$aCampaignWeights = array();
	$aCampaignAdWeight = array();
	foreach ($aAds as $v) 
	{
		if (!isset($aCampaignWeights[$v['client_id']])) 
		{

			$revenue=$client_bidding[$v['client_id']];
			$aCampaignWeights[$v['client_id']] = $revenue;
			$aCampaignAdWeight[$v['client_id']] = 0;
		}
		$aCampaignAdWeight[$v['client_id']] += $v['weight'];
	}
 
	foreach ($aCampaignWeights as $k => $v) 
	{
		if ($aCampaignAdWeight[$k]) 
		{
		$aCampaignWeights[$k] /= $aCampaignAdWeight[$k];
		}
	}
	$totalPri = 0;
	foreach ($aAds as $k => $v) 
	{

		$aAds[$k]['priority'] = $aCampaignWeights[$v['client_id']] * 1;
		$totalPri += $aAds[$k]['priority'];
	}
	if ($totalPri) 
	{
		foreach ($aAds as $k => $v) 
		{
		$aAds[$k]['priority'] /= $totalPri;
		}			
		//return 1;
		return $aAds; 
	}

	return 0;
}
/*DAC020-Calculate priority based on country bidding*/

	
function djax_ecpmpriority($aAds,$results)
		{
				
			  			$max_ecpm = 0;
						$top_ecpms = array();
				
						foreach ($aAds as $key => $ad) 
						{
							
							if($results[$ad['placement_id']]==1)
							{
									$weights[$ad['placement_id']]=$ad['campaign_weight'];		
					
									$revneue=($ad['revenue_type']==1)?$ad['revenue']/1000:$ad['revenue'];

									$max_ecpm =($ad['ecpm']!='0.0000')?$ad['ecpm']:$revneue;							
									$total_ecpm +=$max_ecpm;
			
									$total_weight+= $ad['campaign_weight'];

									$top_ecpms[$key] = 1;
								
							}
							else
							{
							unset($aAds[$key]);
							}
						}
																		
						$chk_camp_weight=array_values($weights);
						
						
						
				
						if(count($aAds)>0)
						{
										if(count(array_unique($chk_camp_weight)) === 1)
										{

													$weight_based=0;
										}
										else
										{
													$weight_based=1;
										}
																									
										
										if($total_ecpm <= 0)
										{
											$GLOBALS['_MAX']['ECPM_CONTROL'] = 1;
											$total_priority = _setPriorityFromWeights($aAds,$results);						
											return $aAds;
		
										}
										else
										{
			
											$GLOBALS['_MAX']['ECPM_SELECTION'] = 1;

											$total_priority = 1;
											
											
											if($weight_based==1)
											{												
												foreach ($aAds as $key => $ad)
												{												
																							
													if(!empty($top_ecpms[$key]))
													{
																																								
													$revneue=($ad['revenue_type']==1)?$ad['revenue']/1000:$ad['revenue'];
																									
													$ecpm =($ad['ecpm']!='0.0000')?$ad['ecpm']:$revneue; 													
																																				
													$temp[$key] = ($ecpm/ $total_ecpm) +($aAd[$key]['campaign_weigh']/$total_weight);																						
													
													$aAds[$key]['priority'] =$temp[$key]/2;													
													
													}
													else
													{																												 
													$aAds[$key]['priority'] = 0;
													}
												} 
																	
											}
											else
											{ 	

												foreach ($aAds as $key => $ad)
												{
													$revneue=($ad['revenue_type']==1)?$ad['revenue']/1000:$ad['revenue'];
													$ecpm =($ad['ecpm']!='0.0000')?$ad['ecpm']:$revneue;

													if(!empty($top_ecpms[$key]))
													{
														$aAds[$key]['priority'] =$ecpm/ $total_ecpm;
													}
													else
													{ 
														$aAds[$key]['priority'] = 0;
													}
												}
											}
											
																											 

											return $aAds;
										}
						}
						else
						{

									return array();
						}

			}



		/*Djax Custom methods*/


		if (!function_exists('mergeConfigFiles'))
		{
			function mergeConfigFiles($realConfig, $fakeConfig)
			{
				foreach ($fakeConfig as $key => $value)
				{
					if (is_array($value))
					{
						if (!isset($realConfig[$key]))
						{
						$realConfig[$key] = array();
						}
						$realConfig[$key] = mergeConfigFiles($realConfig[$key], $value);
					}
					else
					{
						if (isset($realConfig[$key]) && is_array($realConfig[$key]))
						{
							$realConfig[$key][0] = $value;
						}
						else
						{
							if (isset($realConfig) && !is_array($realConfig))
							{
							$temp = $realConfig;
							$realConfig = array();
							$realConfig[0] = $temp;
							}
							$realConfig[$key] = $value;
						}
					}
				}
				unset($realConfig['realConfig']);
				return $realConfig;
			}
		}


		function OX_getMinimumRequiredMemory($limit = null)
		{
			if ($limit == 'maintenance')
			{
				return 134217728;
			}
			return 134217728;
		}
		function OX_getMemoryLimitSizeInBytes()
		{
			$phpMemoryLimit = ini_get('memory_limit');
			if (empty($phpMemoryLimit) || $phpMemoryLimit == -1)
			{
			return -1;
			}
			$aSize = array(
			'G' => 1073741824,
			'M' => 1048576,
			'K' => 1024
			);
			$phpMemoryLimitInBytes = $phpMemoryLimit;
			foreach($aSize as $type => $multiplier)
			{
				$pos = strpos($phpMemoryLimit, $type);
				if(!$pos)
				{
					$pos = strpos($phpMemoryLimit, strtolower($type));
				}
				if($pos)
				{
				$phpMemoryLimitInBytes = substr($phpMemoryLimit, 0, $pos) * $multiplier;
				}
			}
			return $phpMemoryLimitInBytes;
		}

		function OX_increaseMemoryLimit($setMemory)
		{
			$phpMemoryLimitInBytes = OX_getMemoryLimitSizeInBytes();

			if ($phpMemoryLimitInBytes == -1)
			{
				return true;
			}
			if ($setMemory > $phpMemoryLimitInBytes)
			{
				if (@ini_set('memory_limit', $setMemory) === false) {
				return false;
			}
			}
			return true;
		}

		function setupConfigVariables()
		{
			$GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'] = '|';
			$GLOBALS['_MAX']['MAX_COOKIELESS_PREFIX'] = '__';
			$GLOBALS['_MAX']['thread_id'] = uniqid();
			$GLOBALS['_MAX']['SSL_REQUEST'] = false;
			if (
			(!empty($_SERVER['SERVER_PORT']) && !empty($GLOBALS['_MAX']['CONF']['openads']['sslPort']) && ($_SERVER['SERVER_PORT'] == $GLOBALS['_MAX']['CONF']['openads']['sslPort'])) ||
			(!empty($_SERVER['HTTPS']) && ((strtolower($_SERVER['HTTPS']) == 'on') || ($_SERVER['HTTPS'] == 1))) ||
			(!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && (strtolower($_SERVER['HTTP_X_FORWARDED_PROTO']) == 'https')) ||
			(!empty($_SERVER['HTTP_X_FORWARDED_SSL']) && (strtolower($_SERVER['HTTP_X_FORWARDED_SSL']) == 'on')) ||
			(!empty($_SERVER['HTTP_FRONT_END_HTTPS']) && (strtolower($_SERVER['HTTP_FRONT_END_HTTPS']) == 'on')) ||
			(!empty($_SERVER['FRONT-END-HTTPS']) && (strtolower($_SERVER['FRONT-END-HTTPS']) == 'on'))
			) {
			$GLOBALS['_MAX']['SSL_REQUEST'] = true;
			}
			$GLOBALS['_MAX']['MAX_RAND'] = isset($GLOBALS['_MAX']['CONF']['priority']['randmax']) ?
			$GLOBALS['_MAX']['CONF']['priority']['randmax'] : 2147483647;
			list($micro_seconds, $seconds) = explode(" ", microtime());
			$GLOBALS['_MAX']['NOW_ms'] = round(1000 *((float)$micro_seconds + (float)$seconds));
			if (substr($_SERVER['SCRIPT_NAME'], -11) != 'install.php')
			{
			$GLOBALS['serverTimezone'] = date_default_timezone_get();
			OA_setTimeZoneUTC();
			}

			$zoneid=$GLOBALS['zoneid'];   

			djax_methods();
			
			$GLOBALS['_MAX']['device']=djax_mobileparameter();
			

		}
		function setupServerVariables()
		{
			if (empty($_SERVER['REQUEST_URI']))
			{
				$_SERVER['REQUEST_URI'] = $_SERVER['SCRIPT_NAME'];
			if (!empty($_SERVER['QUERY_STRING']))
			{
				$_SERVER['REQUEST_URI'] .= '?' . $_SERVER['QUERY_STRING'];
			}
			}
		}
		function setupDeliveryConfigVariables()
		{
			if (!defined('MAX_PATH'))
			{
			define('MAX_PATH', dirname(__FILE__).'/../..');
			}
			if (!defined('OX_PATH'))
			{
			define('OX_PATH', MAX_PATH);
			}
			if (!defined('RV_PATH')) 
			{
			define('RV_PATH', MAX_PATH);
			}
			if (!defined('LIB_PATH'))
			{
			define('LIB_PATH', MAX_PATH. DIRECTORY_SEPARATOR. 'lib'. DIRECTORY_SEPARATOR. 'OX');
			}
			if ( !(isset($GLOBALS['_MAX']['CONF'])))
			{
			$GLOBALS['_MAX']['CONF'] = parseDeliveryIniFile();
			}
			setupConfigVariables();
		}
		function OA_setTimeZone($timezone)
		{
			date_default_timezone_set($timezone);
			$GLOBALS['_DATE_TIMEZONE_DEFAULT'] = $timezone;
		}
		function OA_setTimeZoneUTC()
		{
			OA_setTimeZone('UTC');
		}
		function OA_setTimeZoneLocal()
		{
			$tz = !empty($GLOBALS['_MAX']['PREF']['timezone']) ? $GLOBALS['_MAX']['PREF']['timezone'] : 'GMT';
			OA_setTimeZone($tz);
		}
		function OX_getHostNameWithPort()
		{
			if (!empty($_SERVER['HTTP_HOST']))
			{
			$host = $_SERVER['HTTP_HOST'];
			}
			else if (!empty($_SERVER['SERVER_NAME']))
			{
			$host = $_SERVER['SERVER_NAME'];
			}
			return $host;
		}
		function setupIncludePath()
		{
			static $checkIfAlreadySet;
			if (isset($checkIfAlreadySet))
			{
			return;
			}
			$checkIfAlreadySet = true;
			$oxPearPath = MAX_PATH . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'pear';
			$oxZendPath = MAX_PATH . DIRECTORY_SEPARATOR . 'lib';
			set_include_path($oxPearPath . PATH_SEPARATOR . $oxZendPath . PATH_SEPARATOR . get_include_path());
		}

		OX_increaseMemoryLimit(OX_getMinimumRequiredMemory());

		if (!defined('E_DEPRECATED'))
		{
			define('E_DEPRECATED', 0);
		}
		setupServerVariables();
		setupDeliveryConfigVariables();

		$conf = $GLOBALS['_MAX']['CONF'];
		include MAX_PATH.'/lib/vendor/autoload.php';
		$GLOBALS['_OA']['invocationType'] = array_search(basename($_SERVER['SCRIPT_FILENAME']), $conf['file']);
			if (!empty($conf['debug']['production']))
			{
			error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
			}
			else
			{
			error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
			}

		$file = '/lib/max/Delivery/common.php';
		$GLOBALS['_MAX']['FILES'][$file] = true;

		$file = '/lib/max/Delivery/cookie.php';
		$GLOBALS['_MAX']['FILES'][$file] = true;
		$GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'] = array();

		if (!is_callable('MAX_cookieSet'))
		{
			if (!empty($conf['cookie']['plugin']) && is_readable(MAX_PATH . "/plugins/cookieStorage/{$conf['cookie']['plugin']}.delivery.php")) {
			include MAX_PATH . "/plugins/cookieStorage/{$conf['cookie']['plugin']}.delivery.php";
			} else {
			function MAX_cookieSet($name, $value, $expire, $path = '/', $domain = null) { return MAX_cookieClientCookieSet($name, $value, $expire, $path, $domain); }
			function MAX_cookieUnset($name) { return MAX_cookieClientCookieUnset($name); }
			function MAX_cookieFlush() { return MAX_cookieClientCookieFlush(); }
			function MAX_cookieLoad() { return true; }
			}
		}
		function MAX_cookieAdd($name, $value, $expire = 0)
		{
			if (!isset($GLOBALS['_MAX']['COOKIE']['CACHE'])) {
			$GLOBALS['_MAX']['COOKIE']['CACHE'] = array();
			}
			$GLOBALS['_MAX']['COOKIE']['CACHE'][$name] = array($value, $expire);
		}

		function _getTimeThirtyDaysFromNow()
		{
			return MAX_commonGetTimeNow() + 2592000; 
		}
		function _getTimeYearFromNow()
		{
			return MAX_commonGetTimeNow() + 31536000;
		}
		function _getTimeYearAgo()
		{
			return MAX_commonGetTimeNow() - 31536000;
		}

		function MAX_cookieUnpackCapping()
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			$cookieNames = $GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'];
			if (!is_array($cookieNames))
			return;
			foreach ($cookieNames as $cookieName)
			{
				if (!empty($_COOKIE[$cookieName]))
				{
					if (!is_array($_COOKIE[$cookieName]))
					{
						$output = array();
						$data = explode('_', $_COOKIE[$cookieName]);
						foreach ($data as $pair)
						{
						list($name, $value) = explode('.', $pair);
						$output[$name] = $value;
						}
						$_COOKIE[$cookieName] = $output;
					}
				}
				if (!empty($_COOKIE['_' . $cookieName]) && is_array($_COOKIE['_' . $cookieName]))
				{
					foreach ($_COOKIE['_' . $cookieName] as $adId => $cookie)
					{
						if (_isBlockCookie($cookieName))
						{
						$_COOKIE[$cookieName][$adId] = $cookie;
						}
						else
						{
							if (isset($_COOKIE[$cookieName][$adId]))
							{
							$_COOKIE[$cookieName][$adId] += $cookie;
							}
							else
							{
							$_COOKIE[$cookieName][$adId] = $cookie;
							}
						}
						MAX_cookieUnset("_{$cookieName}[{$adId}]");
					}
				}
			}
		}
		function _isBlockCookie($cookieName)
		{
				return in_array($cookieName, array(
				$GLOBALS['_MAX']['CONF']['var']['blockAd'],
				$GLOBALS['_MAX']['CONF']['var']['blockCampaign'],
				$GLOBALS['_MAX']['CONF']['var']['blockZone'],
				$GLOBALS['_MAX']['CONF']['var']['lastView'],
				$GLOBALS['_MAX']['CONF']['var']['lastClick'],
				$GLOBALS['_MAX']['CONF']['var']['blockLoggingClick'],
				));
		}
		function MAX_cookieGetUniqueViewerId($create = true)
		{
			static $uniqueViewerId = null;

			if(!is_null($uniqueViewerId))
			{
			return $uniqueViewerId;
			}
			$conf = $GLOBALS['_MAX']['CONF'];
			if (isset($_COOKIE[$conf['var']['viewerId']]))
			{
				$uniqueViewerId = $_COOKIE[$conf['var']['viewerId']];
			}
			elseif ($create)
			{
				$uniqueViewerId = md5(uniqid('', true));  $GLOBALS['_MAX']['COOKIE']['newViewerId'] = true;
			}
			return $uniqueViewerId;
		}
		function MAX_Delivery_cookie_cappingOnRequest()
		{
			if (isset($GLOBALS['_OA']['invocationType']) &&
			($GLOBALS['_OA']['invocationType'] == 'xmlrpc' || $GLOBALS['_OA']['invocationType'] == 'view')
			)
			{
			return true;
			}
			return !$GLOBALS['_MAX']['CONF']['logging']['adImpressions'];
		}
		function MAX_Delivery_cookie_setCapping($type, $id, $block = 0, $cap = 0, $sessionCap = 0)
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			$setBlock = false;
			if ($cap > 0)
			{
				$expire = MAX_commonGetTimeNow() + $conf['cookie']['permCookieSeconds'];
				if (!isset($_COOKIE[$conf['var']['cap' . $type]][$id])) {
				$value = 1;
				$setBlock = true;
				} else if ($_COOKIE[$conf['var']['cap' . $type]][$id] >= $cap) {
				$value = -$_COOKIE[$conf['var']['cap' . $type]][$id]+1;
				$setBlock = true;
				} else {
				$value = 1;
				}
				MAX_cookieAdd("_{$conf['var']['cap' . $type]}[{$id}]", $value, $expire);
			}
			if ($sessionCap > 0)
			{
				if (!isset($_COOKIE[$conf['var']['sessionCap' . $type]][$id])) {
				$value = 1;
				$setBlock = true;
				} else if ($_COOKIE[$conf['var']['sessionCap' . $type]][$id] >= $sessionCap) {
				$value = -$_COOKIE[$conf['var']['sessionCap' . $type]][$id]+1;
				$setBlock = true;
				} else {
				$value = 1;
				}
				MAX_cookieAdd("_{$conf['var']['sessionCap' . $type]}[{$id}]", $value, 0);
			}
			if ($block > 0 || $setBlock)
			{
			MAX_cookieAdd("_{$conf['var']['block' . $type]}[{$id}]", MAX_commonGetTimeNow(), _getTimeThirtyDaysFromNow());
			}
		}
		function MAX_cookieClientCookieSet($name, $value, $expire, $path = '/', $domain = null)
		{
			if (isset($GLOBALS['_OA']['invocationType']) && $GLOBALS['_OA']['invocationType'] == 'xmlrpc')
			{
				if (!isset($GLOBALS['_OA']['COOKIE']['XMLRPC_CACHE']))
				{
				$GLOBALS['_OA']['COOKIE']['XMLRPC_CACHE'] = array();
				}
				$GLOBALS['_OA']['COOKIE']['XMLRPC_CACHE'][$name] = array($value, $expire);
			}
			else
			{
				@setcookie($name, $value, $expire, $path, $domain);
			}
		}
		function MAX_cookieClientCookieUnset($name)
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			$domain = (!empty($conf['cookie']['domain'])) ? $conf['cookie']['domain'] : null;
			MAX_cookieSet($name, false, _getTimeYearAgo(), '/', $domain);
			MAX_cookieSet(str_replace('_', '%5F', urlencode($name)), false, _getTimeYearAgo(), '/', $domain);
		}
		function MAX_cookieClientCookieFlush()
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			$domain = !empty($conf['cookie']['domain']) ? $conf['cookie']['domain'] : null;
			MAX_cookieSendP3PHeaders();
			if (!empty($GLOBALS['_MAX']['COOKIE']['CACHE']))
			{
				reset($GLOBALS['_MAX']['COOKIE']['CACHE']);
				while (list($name,$v) = each ($GLOBALS['_MAX']['COOKIE']['CACHE']))
				{
					list($value, $expire) = $v;
					if ($name == $conf['var']['viewerId'])
					{
					MAX_cookieClientCookieSet($name, $value, $expire, '/', !empty($conf['cookie']['viewerIdDomain']) ? $conf['cookie']['viewerIdDomain'] : $domain);
                     } 
               else {
                 MAX_cookieSet($name, $value, $expire, '/', $domain);
					}
				}
				$GLOBALS['_MAX']['COOKIE']['CACHE'] = array();
			}
			$cookieNames = $GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'];
			if (!is_array($cookieNames))
			return;
			$maxCookieSize = !empty($conf['cookie']['maxCookieSize']) ? $conf['cookie']['maxCookieSize'] : 2048;
			foreach ($cookieNames as $cookieName)
			{
				if (empty($_COOKIE["_{$cookieName}"]))
				{
				continue;
				}
				switch ($cookieName)
				{
					case $conf['var']['blockAd'] :
					case $conf['var']['blockCampaign'] :
					case $conf['var']['blockZone'] : $expire = _getTimeThirtyDaysFromNow(); break;
					case $conf['var']['lastClick'] :
					case $conf['var']['lastView'] :
					case $conf['var']['capAd'] :
					case $conf['var']['capCampaign'] :
					case $conf['var']['capZone'] : $expire = _getTimeYearFromNow(); break;
					case $conf['var']['sessionCapCampaign'] :
					case $conf['var']['sessionCapAd'] :
					case $conf['var']['sessionCapZone'] : $expire = 0; break;
				}
				if (!empty($_COOKIE[$cookieName]) && is_array($_COOKIE[$cookieName]))
				{
					$data = array();
					foreach ($_COOKIE[$cookieName] as $adId => $value)
					{
					$data[] = "{$adId}.{$value}";
					}
					while (strlen(implode('_', $data)) > $maxCookieSize)
					{
					$data = array_slice($data, 1);
					}
					
					MAX_cookieSet($cookieName, implode('_', $data), $expire, '/', $domain);
				}
			}
		}
		function MAX_cookieSendP3PHeaders()
		{
			if ($GLOBALS['_MAX']['CONF']['p3p']['policies'])
			{
				MAX_header("P3P: ". _generateP3PHeader());
			}
		}
		function _generateP3PHeader()
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			$p3p_header = '';
			if ($conf['p3p']['policies']) {
			if ($conf['p3p']['policyLocation'] != '') {
			$p3p_header .= " policyref=\"".$conf['p3p']['policyLocation']."\"";
			}
			if ($conf['p3p']['policyLocation'] != '' && $conf['p3p']['compactPolicy'] != '') {
			$p3p_header .= ", ";
			}
			if ($conf['p3p']['compactPolicy'] != '') {
			$p3p_header .= " CP=\"".$conf['p3p']['compactPolicy']."\"";
			}
			}
			return $p3p_header;
		}


		$file = '/lib/max/Delivery/remotehost.php';
		$GLOBALS['_MAX']['FILES'][$file] = true;

		function MAX_remotehostSetInfo($run = false)
		{
			if (empty($GLOBALS['_OA']['invocationType']) || $run || ($GLOBALS['_OA']['invocationType'] != 'xmlrpc'))
			{
			MAX_remotehostProxyLookup();
			MAX_remotehostReverseLookup();
			MAX_remotehostSetGeoInfo();
			}
		}
		function MAX_remotehostProxyLookup()
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			if ($conf['logging']['proxyLookup'])
			{
				OX_Delivery_logMessage('checking remote host proxy', 7);
				$proxy = false;
				if (!empty($_SERVER['HTTP_VIA']) || !empty($_SERVER['HTTP_X_FORWARDED_FOR']))
				{
					$proxy = true;
				}
				elseif (!empty($_SERVER['REMOTE_HOST']))
				{
					$aProxyHosts = array(
					'proxy',
					'cache',
					'inktomi'
					);
					foreach ($aProxyHosts as $proxyName) {
					if (strpos($_SERVER['REMOTE_HOST'], $proxyName) !== false) {
					$proxy = true;
					break;
					}
					}
				}
				if ($proxy)
				{
					OX_Delivery_logMessage('proxy detected', 7);
					$aHeaders = array(
					'HTTP_FORWARDED',
					'HTTP_FORWARDED_FOR',
					'HTTP_X_FORWARDED',
					'HTTP_X_FORWARDED_FOR',
					'HTTP_CLIENT_IP'
					);
					foreach ($aHeaders as $header)
					{
						if (!empty($_SERVER[$header]))
						{
						$ip = $_SERVER[$header];
						break;
						}
					}
					if (!empty($ip))
					{
						foreach (explode(',', $ip) as $ip)
						{
							$ip = trim($ip);
							if (($ip != 'unknown') && (!MAX_remotehostPrivateAddress($ip))) {
							$_SERVER['REMOTE_ADDR'] = $ip;
							$_SERVER['REMOTE_HOST'] = '';
							$_SERVER['HTTP_VIA'] = '';
							OX_Delivery_logMessage('real address set to '.$ip, 7);
							break;
							}
						}
					}
				}
			}
		}
		function MAX_remotehostReverseLookup()
		{
			if (empty($_SERVER['REMOTE_HOST']))
			{
				if ($GLOBALS['_MAX']['CONF']['logging']['reverseLookup'])
				{
					$_SERVER['REMOTE_HOST'] = @gethostbyaddr($_SERVER['REMOTE_ADDR']);
				}
				else
				{
					$_SERVER['REMOTE_HOST'] = $_SERVER['REMOTE_ADDR'];
				}
			}
		}
		function MAX_remotehostSetGeoInfo()
		{
			if (!function_exists('parseDeliveryIniFile'))
			{

			}
				$aConf = $GLOBALS['_MAX']['CONF'];
				$type = (!empty($aConf['geotargeting']['type'])) ? $aConf['geotargeting']['type'] : null;
			if (!is_null($type) && $type != 'none')
			{
				$aComponent = explode(':', $aConf['geotargeting']['type']);
				if (!empty($aComponent[1]) && (!empty($aConf['pluginGroupComponents'][$aComponent[1]])))
				{
				$GLOBALS['_MAX']['CLIENT_GEO'] = OX_Delivery_Common_hook('getGeoInfo', array(), $type);
				}
			}
		}
		function MAX_remotehostPrivateAddress($ip)
		{
		$ip = ip2long($ip);
		if (!$ip) return false;
		return (MAX_remotehostMatchSubnet($ip, '10.0.0.0', 8) ||
		MAX_remotehostMatchSubnet($ip, '172.16.0.0', 12) ||
		MAX_remotehostMatchSubnet($ip, '192.168.0.0', 16) ||
		MAX_remotehostMatchSubnet($ip, '127.0.0.0', 8)
		);
		}
		function MAX_remotehostMatchSubnet($ip, $net, $mask)
		{
		$net = ip2long($net);
		if (!is_integer($ip)) {
		$ip = ip2long($ip);
		}
		if (!$ip || !$net) {
		return false;
		}
		if (is_integer($mask)) {
		if ($mask > 32 || $mask <= 0)
		return false;
		elseif ($mask == 32)
		$mask = ~0;
		else
		$mask = ~((1 << (32 - $mask)) - 1);
		} elseif (!($mask = ip2long($mask))) {
		return false;
		}
		return ($ip & $mask) == ($net & $mask) ? true : false;
		}

		$file = '/lib/max/Delivery/log.php';
		$GLOBALS['_MAX']['FILES'][$file] = true;

		$file = '/lib/max/Dal/Delivery.php';
		$GLOBALS['_MAX']['FILES'][$file] = true;

		$file = '/lib/OA/Dal/Delivery.php';
		$GLOBALS['_MAX']['FILES'][$file] = true;

		function OA_Dal_Delivery_isValidResult($result) {
		return is_resource($result) || $result instanceof mysqli_result;
		}
		
		function OA_Dal_Delivery_getappInfo()
		{ 
		$aConf    = $GLOBALS['_MAX']['CONF'];
		$djax_app = 'select * from djax_app_configurations';
		$app_dj   = OA_Dal_Delivery_query($djax_app);
		$djax_set = OA_Dal_Delivery_fetchAssoc($app_dj);
		return $djax_set;  
		}
		function OA_Dal_Delivery_getpubnotifyInfo($accountid)
		{ 
		$conf            = $GLOBALS['_MAX']['CONF'];
		$accountid       = (int) $accountid;
		$dbs             = 'select * from djax_adv_pub_notification_settings where account_id=' . $accountid;
		$jbs             = OA_Dal_Delivery_query($dbs);
		$djax_adv_pub_nt = OA_Dal_Delivery_fetchAssoc($jbs);
		return $djax_adv_pub_nt;
		}
		function OA_Dal_Delivery_getzonecategoryInfo($zoneid)
		{
		$conf             = $GLOBALS['_MAX']['CONF'];
		$zoneid           = (int) $zoneid;
		$site_category    = OA_Dal_Delivery_query("SELECT
					 c.category_id as category_id
				FROM
					" . $conf['table']['prefix'] . $conf['table']['zones'] . " AS z,
					" . $conf['table']['djax_site_zone_assoc'] . " AS a,
					" . $conf['table']['djax_site_category_assoc'] . " AS c
				WHERE
					z.zoneid = '" . $zoneid . "'
				  AND
				   z.zoneid=a.zone_id
				  AND
				   a.site_id=c.site_id");
		$site_category_id = array();
		while ($fetch_site_category = OA_Dal_Delivery_fetchAssoc($site_category)) {
			$site_category_id[] = $fetch_site_category['category_id'];
		}
		return $site_category_id;
		}

		function OA_Dal_Delivery_getCampaignInfo($campaignId, $datetime = false)
		{ 
		$conf       = $GLOBALS['_MAX']['CONF'];
		$campaignid = (int) $campaignId;
		if (!empty($datetime)) {
			$campaign_statquery = OA_Dal_Delivery_query("select dj_current_date,dj_daily_budget,dj_campaign_budget,dj_campaign_remain_budget,dj_campaign_remain_total_budget,dj_favourite_status,test_budget,smart_desktop_imp,smart_mobile_imp,smart_conversion,smart_cpa FROM 
			" . OX_escapeIdentifier($conf['table']['prefix'] . $conf['table']['campaigns']) . " WHERE campaignid='" . $campaignid . "' AND dj_current_date='$datetime'");
			
		} else {
			$campaign_statquery = OA_Dal_Delivery_query("select dj_current_date,dj_daily_budget,dj_campaign_budget,dj_campaign_remain_budget,dj_campaign_remain_total_budget,dj_favourite_status,test_budget,smart_desktop_imp,smart_mobile_imp,smart_conversion,smart_cpa FROM 
			" . OX_escapeIdentifier($conf['table']['prefix'] . $conf['table']['campaigns']) . " WHERE campaignid='" . $campaignid . "'");
		}
		if (!OA_Dal_Delivery_isValidResult($campaign_statquery)) {
			return (defined('OA_DELIVERY_CACHE_FUNCTION_ERROR')) ? OA_DELIVERY_CACHE_FUNCTION_ERROR : false;
		}
		$campaigndetails = OA_Dal_Delivery_fetchAssoc($campaign_statquery);
		return $campaigndetails;
		}

		function OA_Dal_Delivery_getZoneInfo($zoneid)
		{
			$aConf = $GLOBALS['_MAX']['CONF'];
			$zoneid = (int)$zoneid;  
			$query = "
				SELECT
				    z.zoneid AS zone_id,
				    z.zonename AS name,
				    z.delivery AS type,
				    z.description AS description,
				    z.width AS width,
				    z.height AS height,
				    z.chain AS chain,
				    z.prepend AS prepend,
				    z.append AS append,
				    z.appendtype AS appendtype,
				    z.forceappend AS forceappend,
				    z.inventory_forecast_type AS inventory_forecast_type,
				    z.block AS block_zone,
				    z.capping AS cap_zone,
				    z.session_capping AS session_cap_zone,
				    z.show_capped_no_cookie AS show_capped_no_cookie_zone,
				    z.ext_adselection AS ext_adselection,
				    z.affiliateid AS publisher_id,
					z.fixed_cpm AS fixed_cpm,
					z.fixed_system_cpm AS fixed_system_cpm,					    				
				    z.dj_floor_price as dj_floor_price,
				    z.dj_passback_tag as dj_passback_tag,
				    z.dj_zone_type AS dj_zone_type,
				    z.dj_ad_position as dj_ad_position,
					z.is_div_link as is_div_link,
				    a.agencyid AS agency_id,
				    a.account_id AS trafficker_account_id,
				    m.account_id AS manager_account_id,
					a.floor_price_enable AS floor_price_enable
				FROM
				    ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])." AS z,
				    ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['affiliates'])." AS a,
				    ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['agency'])." AS m,
					" . OX_escapeIdentifier('djax_network_managers') . " AS ma,
					" . OX_escapeIdentifier('djax_publisher_sites') . " AS s,
					" . OX_escapeIdentifier('djax_site_zone_assoc') . " AS za			
				WHERE
				    z.zoneid = {$zoneid}
				  AND
				    z.affiliateid = a.affiliateid
				  AND
				    a.agencyid = m.agencyid
				  AND
					m.active=1
				  AND 
			        ma.agency_id=m.agencyid  
				  AND 
					za.zone_id=z.zoneid 
				  AND 
					s.site_id=za.site_id 
				  AND 
					ma.is_deleted=0 
				  AND 
					ma.manager_status=1
				  AND 
					s.is_deleted=0 
				  AND 
					z.dj_is_deleted=0
				  AND 
					a.dj_is_deleted=0
				  AND
					a.dj_is_denied=0
				  AND
					a.dj_approval_status=1"; 					
				$rZoneInfo = OA_Dal_Delivery_query($query);
				if (!OA_Dal_Delivery_isValidResult($rZoneInfo))
				{
				return (defined('OA_DELIVERY_CACHE_FUNCTION_ERROR')) ? OA_DELIVERY_CACHE_FUNCTION_ERROR : false;
				}
				$aZoneInfo = OA_Dal_Delivery_fetchAssoc($rZoneInfo);
												
				if (empty($aZoneInfo)) {
				return false;
				}
				else
				{
					return $aZoneInfo;
				}

		}

		function OA_Dal_Delivery_getZoneLinkedAdInfos($zoneid)
		{
				$conf = $GLOBALS['_MAX']['CONF'];
				$zoneid = (int)$zoneid;
				$aRows['xAds'] = array();
				$aRows['ads'] = array();
				$aRows['lAds'] = array();
				$aRows['eAds'] = array();
				$aRows['dj_is_default'] = array();
				$aRows['zone_companion'] = false;
				$aRows['count_active'] = 0;
				$aRows['bidding_val']=array();
		
				$query =
				"SELECT "
				."d.bannerid AS ad_id, "  ."d.campaignid AS placement_id, "  ."d.status AS status, "  ."d.width AS width, "
				."d.ext_bannertype AS ext_bannertype, "
				."cl.dj_is_denied AS dj_is_denied, "
				."d.height AS height, "
				."c.dj_category_id AS dj_category_id, "
				."d.storagetype AS type, "  ."d.contenttype AS contenttype, "  ."d.weight AS weight, "  ."d.adserver AS adserver, "  ."d.block AS block_ad, "  ."d.capping AS cap_ad, "  ."d.session_capping AS session_cap_ad, "  ."d.compiledlimitation AS compiledlimitation, "  ."d.acl_plugins AS acl_plugins, "  ."d.alt_filename AS alt_filename, "  ."az.priority AS priority, "  ."az.priority_factor AS priority_factor, "  ."az.to_be_delivered AS to_be_delivered, "  ."c.campaignid AS campaign_id, "  ."c.priority AS campaign_priority, "  ."c.weight AS campaign_weight, "  ."c.companion AS campaign_companion, "  ."c.block AS block_campaign, "  ."c.capping AS cap_campaign, "  ."c.session_capping AS session_cap_campaign, " ."c.show_capped_no_cookie AS show_capped_no_cookie, "
				."c.clientid AS client_id, "  ."c.expire_time AS expire_time, "
				."c.compiledlimitation AS compiledlimitations," ."c.acl_plugins AS acl_plugins, "
				."c.revenue_type AS revenue_type, "
				."c.revenue AS revenue, "
				."c.dj_is_retargeted as retarget, "
				."c.ecpm_enabled AS ecpm_enabled, "
				."c.ecpm AS ecpm, "
				."cl.dj_is_default as dj_is_default, "
				."cl.dj_cur_balance as dj_cur_balance, "
				."c.dj_current_date as dj_current_date, "
				."c.dj_is_checkout as dj_checkout, "
				."c.dj_daily_budget as dj_daily_budget, "
				."c.daily_budget_unlimit as dj_budget_unlimit, "
				."c.dj_campaign_budget as dj_campaign_budget, "
				."c.dj_campaign_remain_budget as dj_campaign_remain_budget, "
				."ct.status AS tracker_status, "
				."c.test_budget as test_budget, "
				."c.smart_desktop_imp as smart_desktop_imp, "
				."c.smart_mobile_imp as smart_mobile_imp, "
				."c.smart_conversion as smart_conversion, "
				."c.smart_cpa as smart_cpa, "."c.rotation_week as rotation_week,"
				.OX_Dal_Delivery_regex("d.htmlcache", "src\\s?=\\s?[\\'\"]http:")." AS html_ssl_unsafe, "
				.OX_Dal_Delivery_regex("d.imageurl", "^http:")." AS url_ssl_unsafe "
				."FROM "
				.OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['banners'])." AS d JOIN "
				.OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." AS az ON (d.bannerid = az.ad_id) JOIN "
				.OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['campaigns'])." AS c ON (c.campaignid = d.campaignid) LEFT JOIN "
				.OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['campaigns_trackers'])." AS ct ON (ct.campaignid = c.campaignid) LEFT JOIN "
				.OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['clients'])." AS cl ON (cl.clientid = c.clientid) LEFT JOIN"
				.OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['agency'])." AS a ON (a.agencyid = cl.agencyid) LEFT JOIN"
				.OX_escapeIdentifier('djax_network_managers')." AS m ON (m.agency_id = a.agencyid)"
				."WHERE "
				."az.zone_id = {$zoneid} "
				."AND "
				."a.active = 1 "
				."AND "
				."m.manager_status = 1 "
				."AND "
				."m.is_deleted = 0 "
				."AND "
				."d.status <= 0 "
				."AND "
				."c.status <= 0 "
				."AND "
				."d.dj_is_deleted = 0 "
				."AND "
				."c.dj_is_deleted = 0 "
				."AND "
				."cl.dj_is_deleted = 0 "
				."AND "
				."cl.dj_is_denied = 0 "
				."AND "
				."d.dj_admin_approve = 1 ";
				
				

				$rAds = OA_Dal_Delivery_query($query);
		
		
				if (!OA_Dal_Delivery_isValidResult($rAds))
				{
				return (defined('OA_DELIVERY_CACHE_FUNCTION_ERROR')) ? OA_DELIVERY_CACHE_FUNCTION_ERROR : null;
				}

				while ($aAd = OA_Dal_Delivery_fetchAssoc($rAds))
				{		
					if ($aAd['campaign_priority'] == -1)
					{
						$aRows['xAds'][$aAd['ad_id']] = $aAd;
						$aRows['count_active']++;
					}
					elseif ($aAd['campaign_priority'] == 0)
					{
						$aRows['lAds'][$aAd['ad_id']] = $aAd;
						$aRows['count_active']++;
					}
					elseif ($aAd['campaign_priority'] == -2)
					{
				
						if($aAd['dj_is_default']!='1')
						{
						/*DAC020*/
							
							$client_id=$aAd['client_id'];
										
						    $country_val=$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
							
							if(!empty($country_val))
							{
								$bidding_query=OA_Dal_Delivery_query("SELECT b.bidding_value as bidding from ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['clients'])." As c join djax_country_bidding b on b.account_id=c.account_id where c.clientid='$client_id' and b.country_value='$country_val'")or die("Error");
																				  
								$bidding_data=OA_Dal_Delivery_fetchAssoc($bidding_query);
		
								$bidding_val=$bidding_data['bidding'];
							}
							else
							{ 
								$bidding_val=0;
							}	
							
							$aRows['bidding_val'][$aAd['client_id']]=$bidding_val; 					
							$aRows['eAds'][$aAd['ad_id']] = $aAd;
							$aRows['campaignid'][$aAd['placement_id']]=$aAd;
							$aRows['count_active']++;
							/* DAC020*/
						}
						else
						{
						$aRows['dj_is_default'][$aAd['ad_id']] = $aAd;
						$aRows['campaignid'][$aAd['placement_id']]=$aAd;
						$aRows['count_active']++;
						}
			
					}
					else
					{
						$aRows['ads'][$aAd['campaign_priority']][$aAd['ad_id']] = $aAd;
						$aRows['count_active']++;
					}	
					if ($aAd['campaign_companion'] == 1)
					{
					$aRows['zone_companion'][] = $aAd['placement_id']; 
					}
				}
				

				return $aRows;
		}


		function OA_Dal_Delivery_getAd($ad_id)
		{
		/* DAC020 - Included imagepath field in banners table */	  
		$conf = $GLOBALS['_MAX']['CONF'];
		$ad_id = (int)$ad_id;
		$query = "
			SELECT
			d.bannerid AS ad_id,
			d.dj_image_path AS image_path,
			d.campaignid AS placement_id,
			d.status AS status,
			d.description AS name,
			d.storagetype AS type,
			d.contenttype AS contenttype,
			d.pluginversion AS pluginversion,
			d.filename AS filename,
			d.dj_additional_layer As filename1,
			d.imageurl AS imageurl,
			d.htmltemplate AS htmltemplate,
			d.htmlcache AS htmlcache,
			d.width AS width,
			d.height AS height,
			d.weight AS weight,
			d.seq AS seq,
			d.target AS target,
			d.url AS url,
			d.alt AS alt,
			d.statustext AS statustext,
			d.bannertext AS bannertext,
			d.adserver AS adserver,
			d.block AS block_ad,
			d.capping AS cap_ad,
			d.session_capping AS session_cap_ad,
			d.compiledlimitation AS compiledlimitation,
			d.acl_plugins AS acl_plugins,
			d.prepend AS prepend,
			d.append AS append,
			d.bannertype AS bannertype,
			d.alt_filename AS alt_filename,
			d.alt_imageurl AS alt_imageurl,
			d.alt_contenttype AS alt_contenttype,
			d.parameters AS parameters,
			d.transparent AS transparent,
			d.ext_bannertype AS ext_bannertype,
			d.iframe_friendly AS iframe_friendly,
			c.campaignid AS campaign_id,
			c.block AS block_campaign,
			c.capping AS cap_campaign,
			c.session_capping AS session_cap_campaign,
			c.show_capped_no_cookie AS show_capped_no_cookie,
			m.clientid AS client_id,
			c.clickwindow AS clickwindow,
			c.viewwindow AS viewwindow,
			c.revenue_type AS revenue_type, 
			c.revenue AS revenue,			
			m.advertiser_limitation AS advertiser_limitation,
			m.agencyid AS agency_id
		    FROM
			".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['banners'])." AS d,
			".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['campaigns'])." AS c,
			".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['clients'])." AS m
		    WHERE
			d.bannerid={$ad_id}
			AND
			d.campaignid = c.campaignid
			AND
			m.clientid = c.clientid
		    ";
			$rAd = OA_Dal_Delivery_query($query);
			if (!OA_Dal_Delivery_isValidResult($rAd)) 
			{
				return (defined('OA_DELIVERY_CACHE_FUNCTION_ERROR')) ? OA_DELIVERY_CACHE_FUNCTION_ERROR : null;
			}
			else
			{
				return (OA_Dal_Delivery_fetchAssoc($rAd));
			}
		}

		function _setPriorityFromWeights(&$aAds,$results)
		{
		  
			if (!count($aAds))
			{
		
			return 0;
			}
	
			$aCampaignWeights = array();
			$aCampaignAdWeight = array();
			foreach ($aAds as $v)
			{	
				if (!isset($aCampaignWeights[$v['placement_id']]))
				{
				$aCampaignWeights[$v['placement_id']] = $v['campaign_weight'];
				$aCampaignAdWeight[$v['placement_id']] = 0;
				}
				$aCampaignAdWeight[$v['placement_id']] += $v['weight'];
			}
			foreach ($aCampaignWeights as $k => $v)
			{
				if ($aCampaignAdWeight[$k])
				{
					$aCampaignWeights[$k] /= $aCampaignAdWeight[$k];
				}
			}
			$totalPri = 0;
			foreach ($aAds as $k => $v)
			{
				$aAds[$k]['priority'] = $aCampaignWeights[$v['placement_id']] * $v['weight'];
				$totalPri += $aAds[$k]['priority'];
	
			}
			if ($totalPri)
			{		
				foreach ($aAds as $k => $v)
				{
				$aAds[$k]['priority'] /= $totalPri;
				}
				return 1;
			}
			return 0;
		}

		function MAX_Dal_Delivery_Include()
		{
			static $included;
			if (isset($included))
			{
			return;
			}
			$included = true;
			$conf = $GLOBALS['_MAX']['CONF'];
			if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php'))
			{
				require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
			}
			else
			{
				require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
			}
		}

		/*Pending to remove*/

		function _getActionTypes()
		{
			return array(0 => 'view', 1 => 'click');
		}
		function _getTrackerTypes()
		{
			return array(1 => 'sale', 2 => 'lead', 3 => 'signup');
		}
		/*Pending to remove*/

		function MAX_Delivery_log_logAdRequest($adId, $zoneId, $aAd = array())
		{
			if (empty($GLOBALS['_MAX']['CONF']['logging']['adRequests'])) { return true; }
			OX_Delivery_Common_hook('logRequest', array($adId, $zoneId, $aAd, _viewersHostOkayToLog($adId, $zoneId)));
		}


		function _viewersHostOkayToLog($adId=0, $zoneId=0, $trackerId=0)
		{
			$aConf = $GLOBALS['_MAX']['CONF'];
			$agent = strtolower($_SERVER['HTTP_USER_AGENT']);
			$okToLog = true;
			if (!empty($aConf['logging']['enforceUserAgents'])) 
			{
				$aKnownBrowsers = explode('|', strtolower($aConf['logging']['enforceUserAgents']));
				$allowed = false;
				foreach ($aKnownBrowsers as $browser)
				{
					if (strpos($agent, $browser) !== false)
					{
					$allowed = true;
					break;
					}
				}
				OX_Delivery_logMessage('user-agent browser : '.$agent.' is '.($allowed ? '' : 'not ').'allowed', 7);
				if (!$allowed)
				{
				$GLOBALS['_MAX']['EVENT_FILTER_FLAGS'][] = 'enforceUserAgents';
				$okToLog = false;
				}
			}
			if (!empty($aConf['logging']['ignoreUserAgents']))
			{
				$aKnownBots = explode('|', strtolower($aConf['logging']['ignoreUserAgents']));
				foreach ($aKnownBots as $bot)
				{
				if (strpos($agent, $bot) !== false) {
				OX_Delivery_logMessage('user-agent '.$agent.' is a known bot '.$bot, 7);
				$GLOBALS['_MAX']['EVENT_FILTER_FLAGS'][] = 'ignoreUserAgents';
				$okToLog = false;
				}
				}
			}
			if (!empty($aConf['logging']['ignoreHosts']))
			{
				$hosts = str_replace(',', '|', $aConf['logging']['ignoreHosts']);
				$hosts = '#^('.$hosts.')$#i';
				$hosts = str_replace('.', '\.', $hosts);
				$hosts = str_replace('*', '[^.]+', $hosts);
				if (preg_match($hosts, $_SERVER['REMOTE_ADDR'])) {
				OX_Delivery_logMessage('viewer\'s ip is in the ignore list '.$_SERVER['REMOTE_ADDR'], 7);
				$GLOBALS['_MAX']['EVENT_FILTER_FLAGS'][] = 'ignoreHosts_ip';
				$okToLog = false;
				}
				if (preg_match($hosts, $_SERVER['REMOTE_HOST'])) {
				OX_Delivery_logMessage('viewer\'s host is in the ignore list '.$_SERVER['REMOTE_HOST'], 7);
				$GLOBALS['_MAX']['EVENT_FILTER_FLAGS'][] = 'ignoreHosts_host';
				$okToLog = false;
				}
			}
			if ($okToLog) OX_Delivery_logMessage('viewer\'s host is OK to log', 7);
			$result = OX_Delivery_Common_Hook('filterEvent', array($adId, $zoneId, $trackerId));
			if (!empty($result) && is_array($result))
			{
				foreach ($result as $pci => $value)
				{
				if ($value == true) {
				$GLOBALS['_MAX']['EVENT_FILTER_FLAGS'][] = $pci;
				$okToLog = false;
				}
				}
			}
			return $okToLog;
		}

		function MAX_Delivery_log_ensureIntegerSet(&$aArray, $index)
		{
			if (!is_array($aArray))
			{
			$aArray = array();
			}
			if (empty($aArray[$index]))
			{
			$aArray[$index] = 0;
			}
			else
			{
			if (!is_integer($aArray[$index]))
			{
			$aArray[$index] = intval($aArray[$index]);
			}
			}
		}

		function MAX_Delivery_log_setAdLimitations($index, $aAds, $aCaps)
		{
			_setLimitations('Ad', $index, $aAds, $aCaps);
		}
		function MAX_Delivery_log_setCampaignLimitations($index, $aCampaigns, $aCaps)
		{
			_setLimitations('Campaign', $index, $aCampaigns, $aCaps);
		}
		function MAX_Delivery_log_setZoneLimitations($index, $aZones, $aCaps)
		{
			_setLimitations('Zone', $index, $aZones, $aCaps);
		}

		function MAX_Delivery_log_setLastAction($index, $aAdIds, $aZoneIds, $aSetLastSeen, $action = 'view')
		{
			$aConf = $GLOBALS['_MAX']['CONF'];
			if (!empty($aSetLastSeen[$index]))
			{
				$cookieData = MAX_commonCompressInt(MAX_commonGetTimeNow()) . "-" . $aZoneIds[$index];
				$conversionParams = OX_Delivery_Common_hook('addConversionParams', array(&$index, &$aAdIds, &$aZoneIds, &$aSetLastSeen, &$action, &$cookieData));
					if (!empty($conversionParams) && is_array($conversionParams)) {
					foreach ($conversionParams as $params)
					{
						if (!empty($params) && is_array($params))
						{
							foreach ($params as $key => $value)
							{
								$cookieData .= " {$value}";
							}
						}
					}
				}
				MAX_cookieAdd("_{$aConf['var']['last' . ucfirst($action)]}[{$aAdIds[$index]}]", $cookieData, _getTimeThirtyDaysFromNow());
			}
		}
		function MAX_Delivery_log_setClickBlocked($index, $aAdIds)
		{
			$aConf = $GLOBALS['_MAX']['CONF'];
			MAX_cookieAdd("_{$aConf['var']['blockLoggingClick']}[{$aAdIds[$index]}]", MAX_commonCompressInt(MAX_commonGetTimeNow()), _getTimeThirtyDaysFromNow());
		}
		function MAX_Delivery_log_isClickBlocked($adId, $aBlockLoggingClick)
		{
			if (isset($GLOBALS['conf']['logging']['blockAdClicksWindow']) && $GLOBALS['conf']['logging']['blockAdClicksWindow'] != 0)
			{
				if (isset($aBlockLoggingClick[$adId]))
				{
					$endBlock = MAX_commonUnCompressInt($aBlockLoggingClick[$adId]) + $GLOBALS['conf']['logging']['blockAdClicksWindow'];
					if ($endBlock >= MAX_commonGetTimeNow())
					{
					OX_Delivery_logMessage('adID '.$adId.' click is still blocked by block logging window ', 7);
					return true;
					}
				}
			}
			return false;
		}
		function _setLimitations($type, $index, $aItems, $aCaps)
		{
			MAX_Delivery_log_ensureIntegerSet($aCaps['block'], $index);
			MAX_Delivery_log_ensureIntegerSet($aCaps['capping'], $index);
			MAX_Delivery_log_ensureIntegerSet($aCaps['session_capping'], $index);
			MAX_Delivery_cookie_setCapping(
			$type,
			$aItems[$index],
			$aCaps['block'][$index],
			$aCaps['capping'][$index],
			$aCaps['session_capping'][$index]
			);
		}

		function MAX_commonGetDeliveryUrl($file = null)
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			if ($GLOBALS['_MAX']['SSL_REQUEST'])
			{
			$url = MAX_commonConstructSecureDeliveryUrl($file);
			}
			else
			{
			$url = MAX_commonConstructDeliveryUrl($file);
			}
			return $url;
		}
	function MAX_commonConstructDeliveryUrl($file)
	{
		$conf = $GLOBALS['_MAX']['CONF'];
		$domain_query = OA_Dal_Delivery_query("SELECT * FROM djax_adblock_domains");
		$domain_result=array();
		if (OA_Dal_Delivery_numRows($domain_query) > 0)
		{ 
			while($res = OA_Dal_Delivery_fetchAssoc($domain_query))
				{		
					$domain_result[]=$res['url'];
				}		
				$rand_keys=array_rand($domain_result,1);		
				$domain=$domain_result[$rand_keys];	
				
		}		
		$domain_path=$domain;	
		
		if(!empty($domain_path))
		{
				return $domain_path . $file;
		}
		else
		{
				return 'http://' . $conf['webpath']['delivery'] . '/' . $file;
		}
		
	}
		function MAX_commonConstructSecureDeliveryUrl($file)
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			if ($conf['openads']['sslPort'] != 443)
			{
				$path = preg_replace('#/#', ':' . $conf['openads']['sslPort'] . '/', $conf['webpath']['deliverySSL'], 1);
			}
			else
			{
				$path = $conf['webpath']['deliverySSL'];
			}
			return 'https://' . $path . '/' . $file;
		}
		function MAX_commonConstructPartialDeliveryUrl($file, $ssl = false)
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			if ($ssl)
			{
			return '//' . $conf['webpath']['deliverySSL'] . '/' . $file;
			}
			else
			{
			return '//' . $conf['webpath']['delivery'] . '/' . $file;
			}
		}
		function MAX_commonRemoveSpecialChars(&$var)
		{
			static $magicQuotes;
			if (!isset($magicQuotes))
			{
				$magicQuotes = get_magic_quotes_gpc();
			}
			if (isset($var))
			{
				if (!is_array($var))
				{
					if ($magicQuotes)
					{
					$var = stripslashes($var);
					}
					$var = strip_tags($var);
					$var = str_replace(array("\n", "\r"), array('', ''), $var);
					$var = trim($var);
				}
				else
				{
				array_walk($var, 'MAX_commonRemoveSpecialChars');
				}
			}
		}
		function MAX_commonConvertEncoding($content, $toEncoding, $fromEncoding = 'UTF-8', $aExtensions = null)
		{
			if (($toEncoding == $fromEncoding) || empty($toEncoding))
			{
				return $content;
			}
			if (!isset($aExtensions) || !is_array($aExtensions))
			{
				$aExtensions = array('iconv', 'mbstring', 'xml');
			}
			if (is_array($content))
			{
				foreach ($content as $key => $value)
				{
					$content[$key] = MAX_commonConvertEncoding($value, $toEncoding, $fromEncoding, $aExtensions);
				}
				return $content;
			}
			else
			{
				$toEncoding = strtoupper($toEncoding);
				$fromEncoding = strtoupper($fromEncoding);
				$aMap = array();
				$aMap['mbstring']['WINDOWS-1255'] = 'ISO-8859-8';  $aMap['xml']['ISO-8859-15'] = 'ISO-8859-1';   $converted = false;
				foreach ($aExtensions as $extension) {
				$mappedFromEncoding = isset($aMap[$extension][$fromEncoding]) ? $aMap[$extension][$fromEncoding] : $fromEncoding;
				$mappedToEncoding = isset($aMap[$extension][$toEncoding]) ? $aMap[$extension][$toEncoding] : $toEncoding;
				switch ($extension) {
				case 'iconv':
				if (function_exists('iconv')) {
				$converted = @iconv($mappedFromEncoding, $mappedToEncoding, $content);
				}
				break;
				case 'mbstring':
				if (function_exists('mb_convert_encoding')) {
				$converted = @mb_convert_encoding($content, $mappedToEncoding, $mappedFromEncoding);
				}
				break;
				case 'xml':
				if (function_exists('utf8_encode')) {
				if ($mappedToEncoding == 'UTF-8' && $mappedFromEncoding == 'ISO-8859-1') {
				$converted = utf8_encode($content);
				} elseif ($mappedToEncoding == 'ISO-8859-1' && $mappedFromEncoding == 'UTF-8') {
				$converted = utf8_decode($content);
				}
				}
				break;
				}
				}
				return $converted ? $converted : $content;
			}
		}
		function MAX_commonSendContentTypeHeader($type = 'text/html', $charset = null)
		{
			$header = 'Content-type: ' . $type;
			if (!empty($charset) && preg_match('/^[a-zA-Z0-9_-]+$/D', $charset)) {
			$header .= '; charset=' . $charset;
			}
			MAX_header($header);
		}
		function MAX_commonSetNoCacheHeaders()
		{
			MAX_header('Pragma: no-cache');
			MAX_header('Cache-Control: no-cache, no-store, must-revalidate');
			MAX_header('Expires: 0');
			MAX_header('Access-Control-Allow-Origin: *');
		}
		function MAX_commonAddslashesRecursive($a)
		{
			if (is_array($a))
			{
				reset($a);
				while (list($k,$v) = each($a)) {
				$a[$k] = MAX_commonAddslashesRecursive($v);
			}
			reset ($a);
			return ($a);
			}
			else
			{
				return is_null($a) ? null : addslashes($a);
			}
		}
		function MAX_commonRegisterGlobalsArray($args = array())
		{
			static $magic_quotes_gpc;
			if (!isset($magic_quotes_gpc)) {
			$magic_quotes_gpc = ini_get('magic_quotes_gpc');
			}
			$found = false;
			foreach($args as $key) {
			if (isset($_GET[$key])) {
			$value = $_GET[$key];
			$found = true;
			}
			if (isset($_POST[$key])) {
			$value = $_POST[$key];
			$found = true;
			}
			if ($found) {
			if (!$magic_quotes_gpc) {
			if (!is_array($value)) {
			$value = addslashes($value);
			} else {
			$value = MAX_commonAddslashesRecursive($value);
			}
			}
			$GLOBALS[$key] = $value;
			$found = false;
			}
			}
		}
		function MAX_commonDeriveSource($source)
		{
			return MAX_commonEncrypt(trim(urldecode($source)));
		}
		function MAX_commonEncrypt($string)
		{
			$convert = '';
			if (isset($string) && substr($string,1,4) != 'obfs' && $GLOBALS['_MAX']['CONF']['delivery']['obfuscate']) {
			$strLen = strlen($string);
			for ($i=0; $i < $strLen; $i++) {
			$dec = ord(substr($string,$i,1));
			if (strlen($dec) == 2) {
			$dec = 0 . $dec;
			}
			$dec = 324 - $dec;
			$convert .= $dec;
			}
			$convert = '{obfs:' . $convert . '}';
			return ($convert);
			} else {
			return $string;
			}
		}

		function MAX_commonInitVariables()
		{
			MAX_commonRegisterGlobalsArray(array('context', 'source', 'target', 'withText', 'withtext', 'ct0', 'what', 'loc', 'referer', 'zoneid', 'campaignid', 'bannerid', 'clientid', 'charset'));
			global $context, $source, $target, $withText, $withtext, $ct0, $what, $loc, $referer, $zoneid, $campaignid, $bannerid, $clientid, $charset;
			if (isset($withText) && !isset($withtext)) $withtext = $withText;
			$withtext = (isset($withtext) && is_numeric($withtext) ? $withtext : 0 );
			$ct0 = (isset($ct0) ? $ct0 : '' );
			$context = (isset($context) ? $context : array() );
			$target = (isset($target) && (!empty($target)) && (!strpos($target , chr(32))) ? $target : '' );
			$charset = (isset($charset) && (!empty($charset)) && (!strpos($charset, chr(32))) ? $charset : 'UTF-8' );
			$bannerid = (isset($bannerid) && is_numeric($bannerid) ? $bannerid : '' );
			$campaignid = (isset($campaignid) && is_numeric($campaignid) ? $campaignid : '' );
			$clientid = (isset($clientid) && is_numeric($clientid) ? $clientid : '' );
			$zoneid = (isset($zoneid) && is_numeric($zoneid) ? $zoneid : $GLOBALS['zoneid'] );
			if (!isset($what))
			{  
				if (!empty($bannerid))
				{ 
					$what = 'bannerid:'.$bannerid;
				}
				elseif (!empty($campaignid))
				{ 
					$what = 'campaignid:'.$campaignid;
				}
				elseif (!empty($zoneid))
				{ 
					$what = 'zone:'.$zoneid;
				}
				else
				{ 
					$what = '';
				}
			}
			elseif (preg_match('/^([a-z]+):(\d+)$/', $what, $matches))
			{ 
				switch ($matches[1])
				{
				case 'zoneid':
				case 'zone':
				$zoneid = $matches[2];
				break;
				case 'bannerid':
				$bannerid = $matches[2];
				break;
				case 'campaignid':
				$campaignid = $matches[2];
				break;
				case 'clientid':
				$clientid = $matches[2];
				break;
				}
			}
			if (!isset($clientid)) $clientid = '';
			if (empty($campaignid)) $campaignid = $clientid;
			$source = MAX_commonDeriveSource($source);
			if (!empty($loc))
			{
				$loc = stripslashes($loc);
			}
			elseif (!empty($_SERVER['HTTP_REFERER']))
			{
				$loc = $_SERVER['HTTP_REFERER'];
			}
			else
			{
				$loc = '';
			}
			if(!empty($referer))
			{
				$_SERVER['HTTP_REFERER'] = stripslashes($referer);
			}
			else
			{
				if (isset($_SERVER['HTTP_REFERER'])) unset($_SERVER['HTTP_REFERER']);
			}
			$GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'] = array(
			$GLOBALS['_MAX']['CONF']['var']['blockAd'],
			$GLOBALS['_MAX']['CONF']['var']['capAd'],
			$GLOBALS['_MAX']['CONF']['var']['sessionCapAd'],
			$GLOBALS['_MAX']['CONF']['var']['blockCampaign'],
			$GLOBALS['_MAX']['CONF']['var']['capCampaign'],
			$GLOBALS['_MAX']['CONF']['var']['sessionCapCampaign'],
			$GLOBALS['_MAX']['CONF']['var']['blockZone'],
			$GLOBALS['_MAX']['CONF']['var']['capZone'],
			$GLOBALS['_MAX']['CONF']['var']['sessionCapZone'],
			$GLOBALS['_MAX']['CONF']['var']['lastClick'],
			$GLOBALS['_MAX']['CONF']['var']['lastView'],
			$GLOBALS['_MAX']['CONF']['var']['blockLoggingClick'],
			);
			if (strtolower($charset) == 'unicode') { $charset = 'utf-8'; }
		}

		function MAX_commonGetTimeNow()
		{
			if (!isset($GLOBALS['_MAX']['NOW']))
			{
			$GLOBALS['_MAX']['NOW'] = time();
			}
			return $GLOBALS['_MAX']['NOW'];
		}
		function MAX_getRandomNumber($length = 10)
		{
			return substr(md5(uniqid(time(), true)), 0, $length);
		}
		function MAX_header($value)
		{
		 	header($value);
		}

		function MAX_sendStatusCode($iStatusCode)
		{
			$aConf = $GLOBALS['_MAX']['CONF'];
			$arr = array(
			100 => 'Continue',
			101 => 'Switching Protocols',
			200 => 'OK',
			201 => 'Created',
			202 => 'Accepted',
			203 => 'Non-Authoritative Information',
			204 => 'No Content',
			205 => 'Reset Content',
			206 => 'Partial Content',
			300 => 'Multiple Choices',
			301 => 'Moved Permanently',
			302 => 'Found',
			303 => 'See Other',
			304 => 'Not Modified',
			305 => 'Use Proxy',
			306 => '[Unused]',
			307 => 'Temporary Redirect',
			400 => 'Bad Request',
			401 => 'Unauthorized',
			402 => 'Payment Required',
			403 => 'Forbidden',
			404 => 'Not Found',
			405 => 'Method Not Allowed',
			406 => 'Not Acceptable',
			407 => 'Proxy Authentication Required',
			408 => 'Request Timeout',
			409 => 'Conflict',
			410 => 'Gone',
			411 => 'Length Required',
			412 => 'Precondition Failed',
			413 => 'Request Entity Too Large',
			414 => 'Request-URI Too Long',
			415 => 'Unsupported Media Type',
			416 => 'Requested Range Not Satisfiable',
			417 => 'Expectation Failed',
			500 => 'Internal Server Error',
			501 => 'Not Implemented',
			502 => 'Bad Gateway',
			503 => 'Service Unavailable',
			504 => 'Gateway Timeout',
			505 => 'HTTP Version Not Supported'
			);
			if (isset($arr[$iStatusCode]))
			{
				$text = $iStatusCode . ' ' . $arr[$iStatusCode];
				if (!empty($aConf['delivery']['cgiForceStatusHeader']) && strpos(php_sapi_name(), 'cgi') !== 0)
				{
					MAX_header('Status: ' . $text);
				}
				else
				{
					MAX_header($_SERVER["SERVER_PROTOCOL"] .' ' . $text);
				}
			}
		}
		function MAX_commonPackContext($context = array())
		{
			$include = array();
			$exclude = array();
			foreach ($context as $idx => $value)
			{
				reset($value);
				list($key, $value) = each($value);
				list($item,$id) = explode(':', $value);
				switch ($item){
				case 'campaignid': $value = 'c:' . $id; break;
				case 'clientid': $value = 'a:' . $id; break;
				case 'bannerid': $value = 'b:' . $id; break;
				case 'companionid': $value = 'p:' . $id; break;
				}
				switch ($key) {
				case '!=': $exclude[$value] = true; break;
				case '==': $include[$value] = true; break;
				}
			}
			$exclude = array_keys($exclude);
			$include = array_keys($include);
			return base64_encode(implode('#', $exclude) . '|' . implode('#', $include));
		}
		function MAX_commonUnpackContext($context = '')
		{
			list($exclude,$include) = explode('|', base64_decode($context));
			return array_merge(_convertContextArray('!=', explode('#', $exclude)), _convertContextArray('==', explode('#', $include)));
		}
		function MAX_commonCompressInt($int)
		{
			return base_convert($int, 10, 36);
		}
		function MAX_commonUnCompressInt($string)
		{
			return base_convert($string, 36, 10);
		}
		function _convertContextArray($key, $array)
		{
			$unpacked = array();
			foreach ($array as $value) {
			if (empty($value)) { continue; }
			list($item, $id) = explode(':', $value);
			switch ($item) {
			case 'c': $unpacked[] = array($key => 'campaignid:' . $id); break;
			case 'a': $unpacked[] = array($key => 'clientid:' . $id); break;
			case 'b': $unpacked[] = array($key => 'bannerid:' . $id); break;
			case 'p': $unpacked[] = array($key => 'companionid:'.$id); break;
			}
			}
			return $unpacked;
		}
		function OX_Delivery_Common_hook($hookName, $aParams = array(), $functionName = '')
		{
			$return = null;
			if (!empty($functionName))
			{
				$aParts = explode(':', $functionName);
				if (count($aParts) === 3)
				{
				$functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
				}
				if (function_exists($functionName))
				{
					$return = call_user_func_array($functionName, $aParams);
				}
			}
			else
			{
				if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) {
				$return = array();
				$hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
				foreach ($hooks as $identifier) {
				$functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
				if (function_exists($functionName)) {
				OX_Delivery_logMessage('calling on '.$functionName, 7);
				$return[$identifier] = call_user_func_array($functionName, $aParams);
				}
				}
				}
			}
			return $return;
		}
		function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null)
		{
			if (preg_match('/[^a-zA-Z0-9:]/', $identifier)) {
			if (PHP_SAPI === 'cli') {
			exit(1);
			} else {
			MAX_sendStatusCode(400);
			exit;
			}
			}
			$aInfo = explode(':', $identifier);
			$functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
			if (!function_exists($functionName)) {
			if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
			if (!function_exists($functionName)) {
			_includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
			if (!function_exists($functionName)) {
			_includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
			$functionName = 'Plugin_' . $aInfo[0] . '_delivery';
			if (!empty($hook) && function_exists($functionName . '_' . $hook))
			{
			$functionName .= '_' . $hook;
			}
			}
			}
			}
			return $functionName;
		}
		function _includeDeliveryPluginFile($fileName)
		{
			if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) {
			$GLOBALS['_MAX']['FILES'][$fileName] = true;
			if (file_exists(MAX_PATH . $fileName)) {
			include MAX_PATH . $fileName;
			}
			}
			}
		function OX_Delivery_logMessage($message, $priority = 6)
		{
	
			$conf = $GLOBALS['_MAX']['CONF'];	
			if (empty($conf['deliveryLog']['enabled'])) return true;
	
			$priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
			if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) { 
		
		
				return true; }
			error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
			OX_Delivery_Common_hook('logMessage', array($message, $priority));
			return true;
		}


		$file = '/lib/max/Delivery/cache.php';

		$GLOBALS['_MAX']['FILES'][$file] = true;

		define ('OA_DELIVERY_CACHE_FUNCTION_ERROR', 'Function call returned an error');
		$GLOBALS['OA_Delivery_Cache'] = array(
		'prefix' => 'deliverycache_',
		'host' => OX_getHostName(),
		'expiry' => $GLOBALS['_MAX']['CONF']['delivery']['cacheExpire']
		);

		function OA_Delivery_Cache_fetch($name, $isHash = false, $expiryTime = null)
		{
			$filename = OA_Delivery_Cache_buildFileName($name, $isHash);
			$aCacheVar = OX_Delivery_Common_hook(
			'cacheRetrieve',
			array($filename),
			$GLOBALS['_MAX']['CONF']['delivery']['cacheStorePlugin']
			);
			if ($aCacheVar !== false) {
			if ($aCacheVar['cache_name'] != $name) {
			OX_Delivery_logMessage("Cache ERROR: {$name} != {$aCacheVar['cache_name']}", 7);
			return false;
			}
			if ($expiryTime === null) {
			$expiryTime = $GLOBALS['OA_Delivery_Cache']['expiry'];
			}
			$now = MAX_commonGetTimeNow();
			if ( (isset($aCacheVar['cache_time']) && $aCacheVar['cache_time'] + $expiryTime < $now)
			|| (isset($aCacheVar['cache_expire']) && $aCacheVar['cache_expire'] < $now) )
			{
			OA_Delivery_Cache_store($name, $aCacheVar['cache_contents'], $isHash);
			OX_Delivery_logMessage("Cache EXPIRED: {$name}", 7);
			return false;
			}
			OX_Delivery_logMessage("Cache HIT: {$name}", 7);
			return $aCacheVar['cache_contents'];
			}
			OX_Delivery_logMessage("Cache MISS {$name}", 7);
			return false;
		}
		function OA_Delivery_Cache_store($name, $cache, $isHash = false, $expireAt = null)
		{
			if ($cache === OA_DELIVERY_CACHE_FUNCTION_ERROR) {
			return false;
			}
			$filename = OA_Delivery_Cache_buildFileName($name, $isHash);
			$aCacheVar = array();
			$aCacheVar['cache_contents'] = $cache;
			$aCacheVar['cache_name'] = $name;
			$aCacheVar['cache_time'] = MAX_commonGetTimeNow();
			$aCacheVar['cache_expire'] = $expireAt;
			return OX_Delivery_Common_hook(
			'cacheStore',
			array($filename, $aCacheVar),
			$GLOBALS['_MAX']['CONF']['delivery']['cacheStorePlugin']
			);
		}
		function OA_Delivery_Cache_store_return($name, $cache, $isHash = false, $expireAt = null)
		{
			OX_Delivery_Common_hook(
			'preCacheStore_'.OA_Delivery_Cache_getHookName($name),
			array($name, &$cache)
			);
			if (OA_Delivery_Cache_store($name, $cache, $isHash, $expireAt)) {
			return $cache;
			}
			$currentCache = OA_Delivery_Cache_fetch($name, $isHash);
			if ($currentCache === false) {
			return $cache;
			}
			return $currentCache;
		}
		function OA_Delivery_Cache_getHookName($name)
		{
			$pos = strpos($name, '^');
			return $pos ? substr($name, 0, $pos) : substr($name, 0, strpos($name, '@'));
		}
		function OA_Delivery_Cache_buildFileName($name, $isHash = false)
		{
			if(!$isHash) {
			$name = md5($name);
			}
			return $GLOBALS['OA_Delivery_Cache']['prefix'].$name.'.php';
		}
		function OA_Delivery_Cache_getName($functionName)
		{
			$args = func_get_args();
			$args[0] = strtolower(str_replace('MAX_cacheGet', '', $args[0]));
			return join('^', $args).'@'.$GLOBALS['OA_Delivery_Cache']['host'];
		}
		function MAX_cacheGetAd($ad_id, $cached = true)
		{
			$sName = OA_Delivery_Cache_getName(__FUNCTION__, $ad_id);
			if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
			MAX_Dal_Delivery_Include();
			$aRows = OA_Dal_Delivery_getAd($ad_id);
			$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
			}
			return $aRows;
		}

		function MAX_cacheGetZoneLinkedAdInfos($zoneId, $cached = true)
		{
			$sName = OA_Delivery_Cache_getName(__FUNCTION__, $zoneId);
			MAX_Dal_Delivery_Include();

			////////////DJAX ADEXCHANGE VIWER/AD REQUEST TRACKING/////
			viewer_tracking();
			////////////DJAX ADEXCHANGE VIWER/AD REQUEST TRACKING/////

			if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false)
			{			
			$aRows = OA_Dal_Delivery_getZoneLinkedAdInfos($zoneId);
			$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
			}
			return $aRows;
		}
		function MAX_cacheGetZoneInfo($zoneId, $cached = true)
		{
			$sName = OA_Delivery_Cache_getName(__FUNCTION__, $zoneId);
			if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
			MAX_Dal_Delivery_Include();
			$aRows = OA_Dal_Delivery_getZoneInfo($zoneId);
			$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
			}
			return $aRows;
		}
		function MAX_cacheGetCampaignInfo($campaignId, $datetime = false, $cached = true)
		{ 
		$sName = OA_Delivery_Cache_getName(__FUNCTION__, $campaignId);
		if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
			MAX_Dal_Delivery_Include();
			$aRows = OA_Dal_Delivery_getCampaignInfo($campaignId, $datetime);
			$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
		}
		return $aRows;
		}
		function MAX_cacheGetzonecategoryInfo($zoneId, $cached = true)
		{  
			$sName = OA_Delivery_Cache_getName(__FUNCTION__, $zoneId);
			if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
				MAX_Dal_Delivery_Include();
				$aRows = OA_Dal_Delivery_getzonecategoryInfo($zoneId);
				$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
			}
			return $aRows;
		}
		function MAX_cacheGetpubnotifyInfo($accountId, $cached = true)
		{
			$sName = OA_Delivery_Cache_getName(__FUNCTION__, $accountId);
			if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
				MAX_Dal_Delivery_Include();
				$aRows = OA_Dal_Delivery_getpubnotifyInfo($accountId);
				$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
			}
			return $aRows;
		}
		function MAX_cacheGetappInfo($cached = true)
		{ 
			$appinfo = 'app';
			$sName   = OA_Delivery_Cache_getName(__FUNCTION__, $appinfo);
			if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
				MAX_Dal_Delivery_Include();
				$aRows = OA_Dal_Delivery_getappInfo();
				$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
			}
			return $aRows;
		}

		OX_Delivery_logMessage('starting delivery script: ' . basename($_SERVER['REQUEST_URI']), 7);
		if (!empty($_REQUEST[$conf['var']['trace']]))
		{
			OX_Delivery_logMessage('trace enabled: ' . $_REQUEST[$conf['var']['trace']], 7);
		}
		MAX_remotehostSetInfo();
		MAX_commonInitVariables();
		MAX_cookieLoad();
		MAX_cookieUnpackCapping();
		if (empty($GLOBALS['_OA']['invocationType']) || $GLOBALS['_OA']['invocationType'] != 'xmlrpc')
		{
			OX_Delivery_Common_hook('postInit');
		}



		function MAX_limitationsCheckAcl($row, $source = '')
		{
	
		djax_methods();
		if (!empty($row['compiledlimitations'])) {
		if (!isset($GLOBALS['_MAX']['FILES']['aIncludedPlugins'])) {
		$GLOBALS['_MAX']['FILES']['aIncludedPlugins'] = array();
		}
		$result = true;
		$aConf = $GLOBALS['_MAX']['CONF'];
		if(strlen($row['acl_plugins'])) {
		$acl_plugins = explode(',', $row['acl_plugins']);
		foreach ($acl_plugins as $acl_plugin) {
		$acldata = explode(':',$acl_plugin);
        $djax_limitations=array('device','os','handset','country','profile','teleco','capability','connection','carrier','keyword','Include','Exclude');

							if(!in_array($acldata[0],$djax_limitations))
							{
						
								list($extension, $package, $name) = explode(':', $acl_plugin);
								$pluginName = MAX_PATH . $aConf['pluginPaths']['plugins'] . "{$extension}/{$package}/{$name}.delivery.php";
				
								if (!isset($GLOBALS['_MAX']['FILES']['aIncludedPlugins'][$pluginName]))
								{
									if (include($pluginName))
									{
											$GLOBALS['_MAX']['FILES']['aIncludedPlugins'][$pluginName] = true;
									}
									else
									{
											return true;
									}
								}
							}
							else
							{						
								$row['compiledlimitations']=str_replace(':','_',$row['compiledlimitations']);
							}

						}
					}

				@eval('$result = (' . $row['compiledlimitations'] . ');');
			


		return $result;
		} else {
		return true;
		}

		}
		function MAX_limitationsIsAdForbidden($aAd)
		{
			$campaignId = $aAd['placement_id'];
			$showCappedNoCookie = (bool)$aAd['show_capped_no_cookie'];
			return (_limitationsIsCampaignCapped($campaignId, $aAd['cap_campaign'], $aAd['session_cap_campaign'], $aAd['block_campaign'], $showCappedNoCookie));
		}
		function MAX_limitationsIsZoneForbidden($zoneId, $aCapping)
		{
			
						
			$capZone = isset($aCapping['cap_zone']) ? $aCapping['cap_zone'] :null;
			
     /* Views count - Start */
     //get tag settings capping and time(block) count 
     
     /* Views count - start - DAC020*/
	
		
		$zoneid=$GLOBALS['zoneid']; 
		$row =data_from_memcache($zoneid);
		$session_cap_zone = $row['views_count'];
		$block_zone = $row['views_time'];
		$reload_trigger=$row['reload_trigger'];		
		$session_click_zone=$row['clicks_count'];
		$block_click_zone = $row['clicks_time'];
			
		if($reload_trigger!='2')
		{
			$default_blkzone=300;
			$default_session_cap=1;
			$sessionCapZone=(!empty($session_cap_zone))?$session_cap_zone:$default_session_cap;
			$blockZone=(!empty($block_zone))?$block_zone:$default_blkzone;
		}
		else
		{
			$sessionCapZone = (!empty($session_click_zone)) ? $session_click_zone : null;
			$blockZone = (!empty($block_click_zone)) ? $block_click_zone : null;
		}
		
		 //get tag settings capping and time(block) count 
		 /* Views count end*/
		 //echo $capZone;die("ddd");
			$showCappedNoCookie = !empty($aCapping['show_capped_no_cookie_zone']);
			return (_limitationsIsZoneCapped($zoneId, $capZone, $sessionCapZone, $blockZone, $showCappedNoCookie));
		}
		function _limitationsIsAdCapped($adId, $cap, $sessionCap = 0, $block, $showCappedNoCookie)
		{
			return _limitationsIsCapped('Ad', $adId, $cap, $sessionCap, $block, $showCappedNoCookie);
		}
		function _limitationsIsCampaignCapped($campaignId, $cap, $sessionCap = 0, $block, $showCappedNoCookie)
		{
			return _limitationsIsCapped('Campaign', $campaignId, $cap, $sessionCap, $block, $showCappedNoCookie);
		}
		function _limitationsIsZoneCapped($zoneId, $cap, $sessionCap = 0, $block, $showCappedNoCookie)
		{
			return _limitationsIsCapped('Zone', $zoneId, $cap, $sessionCap, $block, $showCappedNoCookie);
		}
		function _limitationsIsCapped($type, $id, $cap, $sessionCap, $block, $showCappedNoCookie)
		{
			
			if (_areCookiesDisabled((($cap > 0) || ($sessionCap > 0) || ($block > 0)) && !$showCappedNoCookie))
			{ 
			//return true;
			}
			$conf = $GLOBALS['_MAX']['CONF'];
			$cookieName = $conf['var']['cap' . $type];
			if (isset($_COOKIE[$cookieName][$id]))
			{
			$totalImpressions = $_COOKIE[$cookieName][$id];
			}
			$cookieName = $conf['var']['sessionCap' . $type];
			if (isset($_COOKIE[$cookieName][$id]))
			{
			$sessionImpressions = $_COOKIE[$cookieName][$id];
			}
			$cookieName = $conf['var']['block' . $type];
			if (isset($_COOKIE[$cookieName][$id]))
			{
			$lastSeen = $_COOKIE[$cookieName][$id];
			}
		if ((($cap > 0) && isset($totalImpressions) && ($totalImpressions >= $cap)) ||
		(($sessionCap > 0) && isset($sessionImpressions) && ($sessionImpressions >= $sessionCap)))
		{
			
			if ($block > 0 && MAX_commonGetTimeNow() > $lastSeen + $block)
			{
				//die("ddddddd");
			return false;
			}
			else
			{
			return true;
			}
		}
		else if ($block > 0 && ($cap == 0 && $sessionCap == 0) && MAX_commonGetTimeNow() <= $lastSeen + $block)
		{
			return true;
		}
		else
		{
			return false;
		}
		}
		function _areCookiesDisabled($filterActive = true)
		{
		return !empty($GLOBALS['_MAX']['COOKIE']['newViewerId']) && $filterActive;
		}


		function MAX_adRender(&$aBanner, $zoneId=0, $source='', $target='', $ct0='', $withText=false, $charset = '', $logClick=true, $logView=true, $richMedia=true, $loc='', $referer='', &$context = array())
		{
				$zoneinfo = MAX_cacheGetZoneInfo($zoneId);
				$conf = $GLOBALS['_MAX']['CONF'];
				if (empty($target)) {
				$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
				}
				$target = htmlspecialchars($target, ENT_QUOTES);
				$source = htmlspecialchars($source, ENT_QUOTES);
				$aBanner['bannerContent'] = "";
				OX_Delivery_Common_hook('preAdRender', array(&$aBanner, &$zoneId, &$source, &$ct0, &$withText, &$logClick, &$logView, null, &$richMedia, &$loc, &$referer));
				$functionName = _getAdRenderFunction($aBanner, $richMedia);
				$code = OX_Delivery_Common_hook('adRender', array(&$aBanner, &$zoneId, &$source, &$ct0, &$withText, &$logClick, &$logView, null, &$richMedia, &$loc, &$referer), $functionName);
				list($usec, $sec) = explode(' ', microtime());
				$time = (float)$usec + (float)$sec;
				$random = MAX_getRandomNumber();
				global $cookie_random;  $cookie_random = $random;
				$clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick, true);
				$urlPrefix = substr(MAX_commonGetDeliveryUrl(), 0, -1);
				//$code = str_replace('{clickurl}', $clickUrl, $code); 
								if (strpos($clickUrl, '{logurl}') !== false) {
				$logUrl = _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&');
				
				  }
				if (strpos($clickUrl, '{logurl_enc}') !== false) {
				$logUrl_enc = urlencode(_adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&'));

				 }
				if (strpos($clickUrl, '{clickurlparams}')) {
				$maxparams = _adRenderBuildParams($aBanner, $zoneId, $source, urlencode($ct0), $logClick, true);
				  
				}
				
				/*Additional macro replace */
				//Existing {advertiserid},{campaignid},{bannerid},{zoneid}
				/*CampaignGroupId*/
				if (strpos($clickUrl,'{campaignGroupId}')) {
					/*Fetch group id from table */	
					$campaign_id=	$aBanner['placement_id'];
					$djax_group	=	OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("Select g.id as groupid from djax_group as g join djax_group_assoc as ga on g.id=ga.group_id where ga.campaign_id='".$campaign_id."'"));
					$group_id	=	$djax_group['groupid'];
					 
				}
				
				/*campaign type*/
				if (strpos($clickUrl,'{type}')) {
					$campaign_id	=	$aBanner['placement_id'];
					$type			=	$aBanner['revenue_type'];
					$revenue_type	=	array("1"=>"CPM","2"=>"CPC","3"=>"CPA","4"=>"CPL","5"=>"CPS","6"=>"CPI","7"=>"CPV");
					 
				} 
				
				/*cost*/
				if (strpos($clickUrl,'{cost}')) {  
					$campaign_id=	$aBanner['placement_id'];				
					$cost		=	$aBanner['revenue']/1000;		
					
				}
				
					/*bidprice*/
				if (strpos($clickUrl, '{bidprice}'))
				{
				$campaign_id = $aBanner['placement_id'];
				$banner_id = $aBanner['ad_id'];
				$type        = $aBanner['revenue_type'];
				$revenue     = $aBanner['revenue'];
				$aConf = $GLOBALS['_MAX']['CONF'];
				/*Traffic Bidrate*/
				$traffic_bid_rate = '';
				$traffic_query = "select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from " . OX_escapeIdentifier($aConf['table']['prefix'] . $aConf['table']['affiliates']) . " as oxa join " . OX_escapeIdentifier($aConf['table']['prefix'] . $aConf['table']['zones']) . " as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=" . $zoneId . ") AND campaign_id IN (select campaignid from " . OX_escapeIdentifier($aConf['table']['prefix'] . $aConf['table']['banners']) . " where bannerid=" . $banner_id . ")";
				$special_bidding = OA_Dal_Delivery_query($traffic_query);
				$traffic_result = OA_Dal_Delivery_fetchAssoc($special_bidding);
				$traffic_bid_rate = $traffic_result['bid_rate'];
				/* Countrywise bidding based on the campaign */
				$country_bid_rate = '';
				$country_val = $GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
				$country_query = "select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from " . OX_escapeIdentifier($aConf['table']['prefix'] . $aConf['table']['banners']) . " where bannerid=" . $banner_id . ") AND revenue_type=" . $type . " AND country_value='$country_val'";
				$special_country_bidding = OA_Dal_Delivery_query($country_query);
				$bidding_result = OA_Dal_Delivery_fetchAssoc($special_country_bidding);
				$country_bid_rate = $bidding_result['bidding_value'];
				$bid_rate = $revenue;
				
				if (!empty($country_bid_rate)) {
					$bid_price = $country_bid_rate;
				}
				else
				if (!empty($traffic_bid_rate)) {
					$bid_price = $traffic_bid_rate;
				}
				else {
					$bid_price = $revenue;
				}

				if ($type == '1') {
					$bidprice = $bid_price / 1000;
				}
				else {
					$bidprice = $bid_price;
				}

				
				}
					
				/*Country*/				
				if (strpos($clickUrl,'{country}')) {
					$country=	$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
					
				}
				
				/*Region*/
				if (strpos($clickUrl,'{region}')) {
					$region_code	=	$GLOBALS['_MAX']['CLIENT_GEO']['region'];
					$country_code	=	$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
					$djax_region	=	OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("Select region from djax_targ_country_region where value='".$region_code."' AND country_code='".$country_code."'"));
					$region			=	$djax_region['region'];				
					 
				}
				
			
				if (strpos($clickUrl,'{ip}')) {
					$ip		=	$_SERVER['REMOTE_ADDR']; 	
					$code 	= 	str_replace('{ip}', $ip, $code); 
				} 
				
				/*isp*/
				if (strpos($clickUrl,'{isp}')) {
					$isp	=	$GLOBALS['_MAX']['CLIENT_GEO']['isp'];
					 
				}
				 					
				/*Browser*/  
				if (strpos($clickUrl,'{browser}')) {
					$browser=geo_data('browser');								
					
				}
				 
				/*OS*/
				if (strpos($clickUrl,'{os}')) {
					$os		=	geo_data('os');
					$code 	= 	str_replace('{os}',$os,$code); 
				} 
				
				/*Language*/
				if (strpos($clickUrl,'{lang}')) {
					$browser_language	=	$_SERVER['HTTP_ACCEPT_LANGUAGE'];
					 
				}
				/*Device*/
				if (strpos($clickUrl,'{device}')) {
					$device_type	= $GLOBALS['devicetype'];
					
				} 
				
				/*carrier*/	
				if (strpos($clickUrl,'{carrier}')) { 
					$carrier_result = 	OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("select carriername from djax_targ_carrier_detail where '".$_SERVER['REMOTE_ADDR']."' BETWEEN start_ip AND end_ip"));	
					$carrier_name	=	$carrier_result['carriername'];
					 
				}
								
				/*connectiontype*/				
				if (strpos($clickUrl,'{connectiontype}')) {
					$connection_result 	= 	OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT connection_type  FROM GeoIPCon_type WHERE INET_ATON('".$_SERVER['REMOTE_ADDR']."') BETWEEN startIP1 AND endIP1"));
					$connectiontype		=	$connection_result['connection_type'];
					 
				}
				
				/*gender*/
				if (strpos($clickUrl,'{gender}')) {
					$user 	=	data_from_memcache($zoneId);	
					$gender = 	$user['target_gender'];
					 
				}
				
				/*age*/
				if (strpos($clickUrl,'{age}')) {
					$user 	=	data_from_memcache($zoneId);	
					$age 	= 	$user['target_age'];
					 
				}
				
				/*color*/
				if (strpos($clickUrl,'{color}')) {
					$user 	=	data_from_memcache($zoneId);	
					$color 	= 	$user['target_color'];				
					 
				}
				
				/*height*/
				if (strpos($clickUrl,'{profile_height}')) {
					$user 	=	data_from_memcache($zoneId);	
					$height = 	$user['target_height'];				
					
				}
				
				/*weight*/
				if (strpos($clickUrl,'{weight}')) {
					$user 	=	data_from_memcache($zoneId);	
					$weight = 	$user['target_weight'];				
					
				}
												
				/*trafficzone*/				
				if (strpos($clickUrl,'{trafficzone}')) {
					$trafficzone=	$zoneId;
					
				}
				
				/*trafficurl*/				
				if (strpos($clickUrl,'{trafficurl}')) {				
					$site_result = MAX_cacheGetZoneInfo($zoneId);
					$traffic_url=	$site_result['site_url'];
					
				}
				
				/*referrer*/			
				if (strpos($clickUrl,'{referer}')) { 				
					$referrer	=	$GLOBALS['referrer'];
					
				}	
					
				/*cache buster*/
				if (strpos($clickUrl,'{cache_buster}')) {
					$cache_buster	=	$GLOBALS['cb'];
					
				}	
		if (strpos($code, '{referer_enc}') || strpos($clickUrl,'{referer_enc}')) {
			//$referrer = $GLOBALS['referrer'];
			$referrer_enc = str_rot13(base64_encode($GLOBALS['referrer']) . base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key']));			
			$code = str_replace('{referer_enc}', $referrer_enc, $code);
		}
		
		if (strpos($code, '{requestid}') || strpos($clickUrl,'{requestid}')) {
			$request_id = (isset($_SESSION['request_id'])) ? $_SESSION['request_id'] : 0;
			$code = str_replace('{requestid}', $request_id, $code);
		}
		if (strpos($code, '{domain}') || strpos($clickUrl,'{domain}')) {
			$website = (isset($zoneinfo['site_url'])) ? $zoneinfo['site_url'] : 0;
			$code = str_replace('{domain}', $website, $code);
		}
		if (strpos($code, '{domain_id}') || strpos($clickUrl,'{domain_id}')) {
			$websiteid = (!empty($zoneinfo['site_id'])) ? $zoneinfo['site_id'] : '0';
			$code = str_replace('{domain_id}', $websiteid, $code);
		}
		if (strpos($code, '{publisherid}') || strpos($clickUrl,'{publisherid}')) {
			$publisher_id = (!empty($zoneinfo['publisher_id'])) ? $zoneinfo['publisher_id'] : '0';
			$code = str_replace('{publisherid}', $publisher_id, $code);
		}
		if (strpos($code, '{networkid}') || strpos($clickUrl,'{networkid}')) {
			$net_id = '1';
			$code = str_replace('{networkid}', $net_id, $code);
		}
		if (strpos($code, '{userid}') || strpos($clickUrl,'{userid}')) {
			
			$country_query = "	SELECT t3.user_id FROM rv_zones as t1
								JOIN rv_affiliates as t2 ON t2.affiliateid = t1.affiliateid
								JOIN rv_users as t3 ON t3.email_address = t2.email
								WHERE t1.zoneid = '".$zoneId."' ";
			$user_id_query = OA_Dal_Delivery_query($country_query);
			$user_id = OA_Dal_Delivery_fetchAssoc($user_id_query);						
			$code = str_replace('{userid}', $user_id['user_id'], $code);
		}
		if (strpos($code, '{userip}') || strpos($clickUrl,'{userip}')) {					
			$code = str_replace('{userip}', $_SERVER['REMOTE_ADDR'], $code);
		}				
				/*******************Additional Changes *********************/
				
				$search = array(
			'{timestamp}',
			'{random}',
			'{target}',
			'{url_prefix}',
			'{bannerid}',
			'{zoneid}',
			'{source}',			
			'{width}',
			'{height}',
			'{websiteid}',
			'{campaignid}',
			'{advertiserid}',			
			'{country}',
			'{region}',
			'{gender}',
			'{os}',
			'{browser}',
			'{campaignGroupId}',
			'{type}',
			'{ip}',
			'{age}',
			'{city}',
			'{zip}',
			'{cost}',
			'{bidprice}',
			'{lang}',
			'{color}',
			'{trafficurl}',
			'{weight}',
			'{carrier}',
			'{device}',
			'{logurl}',
			'{logurl_enc}',
			'{clickurlparams}',
			'{cache_buster}',
			'{connectiontype}'
			
		);
		//print_r($search);die("ss");
		$locReplace = isset($GLOBALS['loc']) ? $GLOBALS['loc'] : '';
		$websiteid = (!empty($aBanner['affiliate_id'])) ? $aBanner['affiliate_id'] : '0';
		$replace = array(
			$time,
			$random,
			$target,
			$urlPrefix,
			$aBanner['ad_id'],
			$zoneId,
			$source,			
			$aBanner['width'],
			$aBanner['height'],
			$websiteid,
			$aBanner['campaign_id'],
			$aBanner['client_id'],			
			$country,
			$region,
			$gender,
			$os,
			$browser,
			$group_id,
			$revenue_type[$type],
			$ip,
			$age,
			$GLOBALS['_MAX']['CLIENT_GEO']['city'],
			$GLOBALS['_MAX']['CLIENT_GEO']['postal_code'],
			$cost,
			$bidprice,
			$browser_language,
			$color,
			$traffic_url,
			$weight,
			$carrier_name,
			$device_type,
			$logUrl,
			$logUrl_enc,
			$maxparams,
			$cache_buster,
			$connectiontype
					
		);
				preg_match_all('#{(.*?)(_enc)?}#', $code, $macros);
				for ($i=0;$i<count($macros[1]);$i++) {
				if (!in_array($macros[0][$i], $search) && isset($_REQUEST[$macros[1][$i]])) {
				$search[] = $macros[0][$i];
				$replace[] = (!empty($macros[2][$i])) ? urlencode(stripslashes($_REQUEST[$macros[1][$i]])) : htmlspecialchars(stripslashes($_REQUEST[$macros[1][$i]]), ENT_QUOTES);
				}
				}
				$componentParams = OX_Delivery_Common_hook('addUrlParams', array($aBanner));
				if (!empty($componentParams) && is_array($componentParams)) {
				foreach ($componentParams as $params) {
				if (!empty($params) && is_array($params)) {
				foreach ($params as $key => $value) {
				$search[] = '{' . $key . '}';
				$replace[] = urlencode($value);
				}
				}
				}
				}
				//$code = str_replace($search, $replace, $code);
				$clickUrl = str_replace($search, $replace, $clickUrl);
		
				setcookie("c134n".$zoneId,$clickUrl);
				
				/* Macro changes for clickurl  */				
				$click_url=explode("?",$clickUrl);
				$enc_clickurl=$click_url[1];
				
				$clickUrl=$click_url[0]."?".str_rot13(base64_encode($enc_clickurl).base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key']));
                  
				/* Macro changes */
				
				$code = str_replace('{clickurl}', $clickUrl, $code);
		        $aBanner['clickUrl'] = $clickUrl;
	
				$logUrl = _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&');
				$logUrl = str_replace($search, $replace, $logUrl);
				$aBanner['logUrl'] = $logUrl;
				$aBanner['aSearch'] = $search;
				$aBanner['aReplace'] = $replace;
				OX_Delivery_Common_hook('postAdRender', array(&$code, $aBanner, &$context));
				return MAX_commonConvertEncoding($code, $charset);
		}
		function MAX_adRenderImageBeacon($logUrl, $beaconId = 'beacon', $userAgent = null)
		{
				if (!isset($userAgent) && isset($_SERVER['HTTP_USER_AGENT'])) {
				$userAgent = $_SERVER['HTTP_USER_AGENT'];
				}
				$beaconId .= '_{random}';
				if (isset($userAgent) && preg_match("#Mozilla/(1|2|3|4)#", $userAgent)
				&& !preg_match("#compatible#", $userAgent)) {
				$div = "<layer id='{$beaconId}' width='0' height='0' border='0' visibility='hide'>";
				$style = '';
				$divEnd = '</layer>';
				} else {
				$div = "<div id='{$beaconId}' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>";
				$style = " style='width: 0px; height: 0px;'";
				$divEnd = '</div>';
				}
				//$beacon = "$div<img src='".htmlspecialchars($logUrl)."' width='0' height='0' alt=''{$style} />{$divEnd}";
				if($_GET['iscurl']==1) 
				{
					$logUrl = file_get_contents($logUrl);
					$beacon = "$div<img src='".htmlspecialchars($logUrl)."'  style= 'width:0; height:0; ' alt=''{$style} />{$divEnd}";
				}
				else
				{
					$beacon = "$div<img src='".htmlspecialchars($logUrl)."'  style= 'width:0; height:0; ' alt=''{$style} />{$divEnd}";
				}
				return $beacon;
		}
		function MAX_adRenderBlankBeacon($zoneId, $source, $loc, $referer)
		{
		$logUrl = _adRenderBuildLogURL(array(
		'ad_id' => 0,
		'placement_id' => 0,
		), $zoneId, $source, $loc, $referer, '&');
		return str_replace('{random}', MAX_getRandomNumber(), MAX_adRenderImageBeacon($logUrl));
		}
		function _adRenderImage(&$aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $richMedia=true, $loc='', $referer='', $context=array(), $useAppend=true)
		{
				$conf = $GLOBALS['_MAX']['CONF'];
				$aBanner['bannerContent'] = $imageUrl = _adRenderBuildFileUrl($aBanner, $useAlt);
				if (!$richMedia) {
				return _adRenderBuildFileUrl($aBanner, $useAlt);
				}
				$prepend = (!empty($aBanner['prepend']) && $useAppend) ? $aBanner['prepend'] : '';
				$append = (!empty($aBanner['append']) && $useAppend) ? $aBanner['append'] : '';
				$clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick);
				 /*if (!empty($clickUrl)) {  
    
				//$status = _adRenderBuildStatusCode($aBanner);
				//$clickTag = "<a href='$clickUrl' target='{target}'$status>";
				
				$hide_value=MAX_cacheGetappInfo();
				$hide_status=$hide_value['hide_url_enable'];
				
				if($hide_status=="enable")
				{
				// Hide ClickUrl //
				$aBanner['target'] = empty($aBanner['target']) ? '_blank' : $aBanner['target'];
				
				$uniqueid = 'a'.substr(md5(uniqid('', 1)), 0, 7);
				
				$temp_ck = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' . $_SERVER['HTTP_HOST'] .'/'. $uniqueid : 'http://' . $_SERVER['HTTP_HOST'] .'/'. $uniqueid;
				
				
				if($aBanner['target']=='_blank')
				{
				$clickTag = "<a target='{target}'$status  onclick=\"Javascript:window.open('".$clickUrl."','Hide');return false;\" onmouseover=this.setAttribute('href','".$temp_ck."'); >";
				}
				else
				{
				$clickTag = "<a target='{target}'$status  onclick=\"Javascript:window.open('".$clickUrl."');return false;\" onmouseover=this.setAttribute('href','".$temp_ck."'); >";
				}
				
				// Hide ClickUrl //
				}
				
				else
				{
				$status = _adRenderBuildStatusCode($aBanner);
				$clickTag = "<a href='$clickUrl' target='{target}'$status>";	
				
				}	 
				$clickTagEnd = '</a>';
				} else {
				$clickTag = '';
				$clickTagEnd = '';
				}*/
				if (!empty($clickUrl)) {
				$status      = _adRenderBuildStatusCode($aBanner);
				$clickTag    = "<a href='" . htmlspecialchars($clickUrl, ENT_QUOTES) . "' target='{target}'$status>";
				$clickTagEnd = '</a>';
				} else {
				$clickTag    = '';
				$clickTagEnd = '';
				}
				if (!empty($imageUrl)) {
				$imgStatus = empty($clickTag) && !empty($status) ? $status : '';
				$width = !empty($aBanner['width']) ? $aBanner['width'] : 0;
				$height = !empty($aBanner['height']) ? $aBanner['height'] : 0;
				$alt = !empty($aBanner['alt']) ? htmlspecialchars($aBanner['alt'], ENT_QUOTES) : '';
				$imageTag = "$clickTag<img src='$imageUrl' width='$width' height='$height' alt='$alt' title='$alt' border='0'$imgStatus />$clickTagEnd";
				} else {
				$imageTag = '';
				}
				$bannerText = $withText && !empty($aBanner['bannertext']) ? "<br />$clickTag" . htmlspecialchars($aBanner['bannertext'], ENT_QUOTES) . "$clickTagEnd" : '';
				$beaconTag = ($logView && $conf['logging']['adImpressions']) ? _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer) : '';
				return $prepend . $imageTag . $bannerText . $beaconTag . $append;
		}
		function _adRenderFlash(&$aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $richMedia=true, $loc='', $referer='', $context=array())
		{
				$conf = $GLOBALS['_MAX']['CONF'];
				$prepend = !empty($aBanner['prepend']) ? $aBanner['prepend'] : '';
				$append = !empty($aBanner['append']) ? $aBanner['append'] : '';
				$width = !empty($aBanner['width']) ? $aBanner['width'] : 0;
				$height = !empty($aBanner['height']) ? $aBanner['height'] : 0;
				$pluginVersion = !empty($aBanner['pluginversion']) ? _adRenderGetRealPluginVersion($aBanner['pluginversion']) : '4';
				$logURL = _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&');
				if (!empty($aBanner['alt_filename']) || !empty($aBanner['alt_imageurl'])) {
				$altImageAdCode = _adRenderImage($aBanner, $zoneId, $source, $ct0, false, $logClick, false, true, true, $loc, $referer, $context, false);
				$fallBackLogURL = _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&', true);
				} else {
				$alt = !empty($aBanner['alt']) ? htmlspecialchars($aBanner['alt'], ENT_QUOTES) : '';
				$altImageAdCode = "<img src='" . _adRenderBuildImageUrlPrefix() . '/1x1.gif' . "' alt='".$alt."' title='".$alt."' border='0' />";
				if ($zoneId) {
				$fallBackLogURL = _adRenderBuildLogURL(array(
				'ad_id' => 0,
				'placement_id' => 0,
				), $zoneId, $source, $loc, $referer, '&', true);
				} else {
				$fallBackLogURL = false;
				}
				}
				$clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick);
				if (!empty($clickUrl)) {  $status = _adRenderBuildStatusCode($aBanner);
				$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
				$swfParams = array('clickTARGET' => $target, 'clickTAG' => $clickUrl);
				$clickTag = "<a href='".htmlspecialchars($clickUrl, ENT_QUOTES)."' target='$target'$status>";
				$clickTagEnd = '</a>';
				} else {
				$swfParams = array();
				$clickTag = '';
				$clickTagEnd = '';
				}
				if (!empty($aBanner['parameters'])) {
				$aAdParams = unserialize($aBanner['parameters']);
				if (isset($aAdParams['swf']) && is_array($aAdParams['swf'])) {
				$swfParams = array();
				$aBannerSwf = $aBanner;
				$aBannerSwf['noClickTag'] = true;
				foreach ($aAdParams['swf'] as $iKey => $aSwf) {
				$aBannerSwf['url'] = $aSwf['link'];
				$swfParams["alink{$iKey}"] = _adRenderBuildClickUrl($aBannerSwf, $zoneId, $source, $ct0, $logClick);
				$swfParams["atar{$iKey}"] = $aSwf['tar'];
				}
				}
				}
				$fileUrl = _adRenderBuildFileUrl($aBanner, false);
				$id = 'rv_swf_{random}';
				$swfId = (!empty($aBanner['alt']) ? $aBanner['alt'] : 'Advertisement');
				$swfId = 'id-' . preg_replace('/[a-z0-1]+/', '', strtolower($swfId));
				$code = "
				<div id='{$id}' style='display: inline;'>$altImageAdCode</div>
				<script type='text/javascript'><!--/"."/ <![CDATA[
					var ox_swf = new FlashObject('{$fileUrl}', '{$swfId}', '{$width}', '{$height}', '{$pluginVersion}');\n";
				foreach ($swfParams as $key => $value) {
				$code .= "    ox_swf.addVariable('{$key}', '" . preg_replace('#%7B(.*?)%7D#', '{$1}', urlencode($value)) . "');\n";
				}
				if (!empty($aBanner['transparent'])) {
				$code .= "    ox_swf.addParam('wmode','transparent');\n";
				} else {
				$code .= "    ox_swf.addParam('wmode','opaque');\n";
				}
				$code .= "    ox_swf.addParam('allowScriptAccess','always');\n";
				if ($logView && $conf['logging']['adImpressions']) {
				$code .= "    ox_swf.write('{$id}', ".json_encode($logURL).", ".json_encode($fallBackLogURL).");\n";
				} else {
				$code .= "    ox_swf.write('{$id}');\n";
				}
				$code .= "/"."/ ]]> --></script>";
				if ($fallBackLogURL) {
				$code .= '<noscript>' . _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer, $fallBackLogURL) . '</noscript>';
				}
				$bannerText = $withText && !empty($aBanner['bannertext']) ? "<br />{$clickTag}{$aBanner['bannertext']}{$clickTagEnd}" : '';
				return $prepend . $code . $bannerText . $append;
				}
		function _adRenderHtml(&$aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $richMedia=true, $loc='', $referer='', $context=array())
		{
			$aConf = $GLOBALS['_MAX']['CONF'];
			if (!function_exists('Plugin_BannerTypeHtml_delivery_adRender')) {
			@include LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtmlDelivery.php';
			}
			return Plugin_BannerTypeHtml_delivery_adRender($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, $useAlt, $richMedia, $loc, $referer);
		}
		function _adRenderText(&$aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $richMedia=false, $loc='', $referer='', $context=array())
		{
			$aConf = $GLOBALS['_MAX']['CONF'];
			if (!function_exists('Plugin_BannerTypeText_delivery_adRender')) {
			@include LIB_PATH . '/Extension/bannerTypeText/bannerTypeTextDelivery.php';
			}
			return Plugin_BannerTypeText_delivery_adRender($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, $useAlt, $richMedia, $loc, $referer);

		}
		function _adRenderBuildFileUrl($aBanner, $useAlt = false, $params = '')
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			$fileUrl = '';
			if ($aBanner['type'] == 'url') {
			$fileUrl = $useAlt ? $aBanner['alt_imageurl'] : $aBanner['imageurl'];
			if (!empty($params)) {
			$fileUrl .= "?{$params}";
			}
			} else {
			$fileName = $useAlt ? $aBanner['alt_filename'] : $aBanner['filename'];
			$params = !empty($params) ? $params : '';
			if (!empty($fileName)) {
			if ($aBanner['type'] == 'web') {
			$fileUrl = _adRenderBuildImageUrlPrefix() . "/{$fileName}";
			if (!empty($params)) {
			$fileUrl .= "?{$params}";
			}
			} elseif ($aBanner['type'] == 'sql') {
			$fileUrl = MAX_commonGetDeliveryUrl($conf['file']['image']) . "?filename={$fileName}&contenttype={$aBanner['contenttype']}";
			if (!empty($params)) {
			$fileUrl .= "&{$params}";
			}
			}
			}
			}
			return $fileUrl;
		}
		function _adRenderBuildImageUrlPrefix()
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			return $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' . $conf['webpath']['imagesSSL'] : 'http://' . $conf['webpath']['images'];
		}
		function _adRenderBuildLogURL($aBanner, $zoneId = 0, $source = '', $loc = '', $referer = '', $amp = '&amp;', $fallBack = false)
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			$delimiter = $GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'];
			$logLastAction = (!empty($aBanner['viewwindow']) && !empty($aBanner['tracker_status'])) ? '1' : '';
			if (!empty($GLOBALS['_MAX']['adChain']))
			{
				foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad)
				{
					$aBanner['ad_id'] .= $delimiter . $ad['ad_id'];
					$aBanner['placement_id'] .= $delimiter . $ad['placement_id'];
					$zoneId .= $delimiter . $ad['zoneid'];
					$aBanner['block_ad'] .= $delimiter . $ad['block_ad'];
					$aBanner['cap_ad'] .= $delimiter . $ad['cap_ad'];
					$aBanner['session_cap_ad'] .= $delimiter . $ad['session_cap_ad'];
					$aBanner['block_campaign'] .= $delimiter . $ad['block_campaign'];
					$aBanner['cap_campaign'] .= $delimiter . $ad['cap_campaign'];
					$aBanner['session_cap_campaign'] .= $delimiter . $ad['session_cap_campaign'];
					$aBanner['block_zone'] .= $delimiter . $ad['block_zone'];
					$aBanner['cap_zone'] .= $delimiter . $ad['cap_zone'];
					$aBanner['session_cap_zone'] .= $delimiter . $ad['session_cap_zone'];
					$logLastAction .= $delimiter . (!empty($ad['viewwindow']) && !empty($ad['tracker_status'])) ? '1' : '0';
				}
			}
			$urllink = MAX_commonGetDeliveryUrl($conf['file']['log'])."?";
			$url = $conf['var']['adId'] . "=" .$aBanner['ad_id'];  
			$url .= $amp . $conf['var']['campaignId'] . "=" . $aBanner['placement_id'];
			$url .= $amp . $conf['var']['zoneId'] . "=" . $zoneId;
			if (!empty($source)) $url .= $amp . $conf['var']['channel'] . "=" . $source;
			if (!empty($aBanner['block_ad'])) $url .= $amp . $conf['var']['blockAd'] . "=" . $aBanner['block_ad'];
			if (!empty($aBanner['cap_ad'])) $url .= $amp . $conf['var']['capAd'] . "=" . $aBanner['cap_ad'];
			if (!empty($aBanner['session_cap_ad'])) $url .= $amp . $conf['var']['sessionCapAd'] . "=" . $aBanner['session_cap_ad'];
			if (!empty($aBanner['block_campaign'])) $url .= $amp . $conf['var']['blockCampaign'] . "=" . $aBanner['block_campaign'];
			if (!empty($aBanner['cap_campaign'])) $url .= $amp . $conf['var']['capCampaign'] . "=" . $aBanner['cap_campaign'];
			if (!empty($aBanner['session_cap_campaign'])) $url .= $amp . $conf['var']['sessionCapCampaign'] . "=" . $aBanner['session_cap_campaign'];
			if (!empty($aBanner['block_zone'])) $url .= $amp . $conf['var']['blockZone'] . "=" . $aBanner['block_zone'];
			if (!empty($aBanner['cap_zone'])) $url .= $amp . $conf['var']['capZone'] . "=" . $aBanner['cap_zone'];
			if (!empty($aBanner['session_cap_zone'])) $url .= $amp . $conf['var']['sessionCapZone'] . "=" . $aBanner['session_cap_zone'];
			if (!empty($logLastAction)) $url .= $amp . $conf['var']['lastView'] . "=" . $logLastAction;
			if (!empty($loc)) $url .= $amp . "loc=" . urlencode($loc);
			if (!empty($referer)) $url .= $amp . "referer=" . urlencode($referer);
			if (!empty($fallBack)) $url .= $amp . $conf['var']['fallBack'] . '=1';
			$url .= $amp . "cb={random}";

			/*			DJAX ADEXCHANGE REQUEST ID PASSING TO LOGIMPRESSION FILES	START	*/

			$request_id=(isset($_SESSION['request_id']))?$_SESSION['request_id']:0;

			$url .= $amp ."request_id=".$request_id;

			/*			DJAX ADEXCHANGE REQUEST ID PASSING TO LOGIMPRESSION FILES	END	*/

			$componentParams = OX_Delivery_Common_hook('addUrlParams', array($aBanner));
			if (!empty($componentParams) && is_array($componentParams))
			{
				foreach ($componentParams as $params)
				{
					if (!empty($params) && is_array($params))
					{
						foreach ($params as $key => $value)
						{
							$url .= $amp . urlencode($key) . '=' . urlencode($value);
						}
					}
				}
			}
			
			//$url	=	$urllink.str_rot13(base64_encode($url).base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key'])); 
			$devicename='&devicename='.$GLOBALS['deviceName'].'&enc_key=';
			$url	=	$urllink.str_rot13(base64_encode($url.$devicename).base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key']));   
return $url;
		}
		function _adRenderImageBeacon($aBanner, $zoneId = 0, $source = '', $loc = '', $referer = '', $logUrl = '')
		{
			if (empty($logUrl))
			{
			$logUrl = _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&');
			}
			return MAX_adRenderImageBeacon($logUrl);
		}
		function _adRenderBuildParams($aBanner, $zoneId=0, $source='', $ct0='', $logClick=true, $overrideDest=false)
		{

			if (isset($aBanner['ad_id']) && empty($aBanner['bannerid']))
			{
			$aBanner['bannerid'] = $aBanner['ad_id'];
			}
			$conf = $GLOBALS['_MAX']['CONF'];
			$delimiter = $GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'];
			$logLastClick = (!empty($aBanner['clickwindow'])) ? '1' : '';
			if (!empty($GLOBALS['_MAX']['adChain'])) {
			foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad) {
			$aBanner['bannerid'] .= $delimiter . $ad['bannerid'];
			$aBanner['placement_id'] .= $delimiter . $ad['placement_id'];
			$zoneId .= $delimiter . $ad['zoneid'];
			$logLastClick .= (!empty($aBanner['clickwindow'])) ? '1' : '0';
			}
			}
			$maxparams = '';
			if (!empty($aBanner['url']) || $overrideDest)
			{
				$del = $conf['delivery']['ctDelimiter'];
				$delnum = strlen($del);
				$random = "{$del}{$conf['var']['cacheBuster']}={random}";
				$request_id=(isset($_SESSION['request_id']))?$_SESSION['request_id']:0;	
				$bannerId = !empty($aBanner['bannerid']) ? "{$del}{$conf['var']['adId']}={$aBanner['bannerid']}" : '';
				$zoneId = "{$del}{$conf['var']['zoneId']}={$zoneId}";
				$source = !empty($source) ? "{$del}source=" . urlencode($source) : '';
				$log = $logClick ? '' : "{$del}{$conf['var']['logClick']}=no";
				$dest = !empty($aBanner['url']) ? $aBanner['url'] : '';			    
				if (!empty($ct0) && strtolower(substr($ct0, 0, 4)) == 'http') {
				$dest = $ct0.preg_replace('/%7B(.*?)%7D/', '{$1}', urlencode($dest));
				}
				$dest = preg_replace('/%7B(.*?)%7D/', '{$1}', urlencode($dest));

				$maxdest = "{$del}{$conf['var']['dest']}={$dest}";
				$log .= (!empty($logLastClick)) ? $del . $conf['var']['lastClick'] . '=' . $logLastClick : '';
				$maxparams = $delnum . $bannerId . $zoneId . $source . $log . $random;
				
				
				/*			S2S TOKEN  PASSING TO CLICKURL 	START	*/

					$conf = $GLOBALS['_MAX']['CONF'];

					$query_val="select * from {$conf['table']['prefix']}trackers t,{$conf['table']['prefix']}campaigns_trackers c,{$conf['table']['prefix']}campaigns cl,{$conf['table']['prefix']}banners b where cl.campaignid=c.campaignid  and c.trackerid=t.trackerid  and  c.cookieless_tracker='1' and c.campaignid=b.campaignid and bannerid='".$aBanner['ad_id']."'";
					  
					$fetch_rows=OA_Dal_Delivery_query($query_val);

					if(OA_Dal_Delivery_numRows($fetch_rows)>0)
					{
						
						$maxparams.='__transaction_id={transaction_id}';
						
					}

				/*			S2S TOKEN REQUEST ID PASSING TO CLICKURL	END	*/
				
				
				$componentParams = OX_Delivery_Common_hook('addUrlParams', array($aBanner));
				if (!empty($componentParams) && is_array($componentParams)) {
				foreach ($componentParams as $params) {
				if (!empty($params) && is_array($params)) {
				foreach ($params as $key => $value) {
				$maxparams .= $del . urlencode($key) . '=' . urlencode($value);
				}
				}
				}
				}

				/*			DJAX ADEXCHANGE REQUEST ID PASSING TO CLICKURL 	START	*/

				//$request_id=(isset($_SESSION['request_id']))?$_SESSION['request_id']:0;
				
				if($aBanner['contenttype'] == 'html' && $aBanner['url']=='')
				{
			    	
				$maxparams .= '__request_id='.$request_id.'__'.$maxdest;
				
				}
				else
				{
				
				 $maxparams .= $maxdest.'__'.'request_id='.$request_id;
				
				}

				/*			DJAX ADEXCHANGE REQUEST ID PASSING TO CLICKURL	END	*/
			}

			return $maxparams;
		}
		function _adRenderBuildClickUrl($aBanner, $zoneId=0, $source='', $ct0='', $logClick=true, $overrideDest=false)
		{
		/* Encryption - for click url  */
			$conf = $GLOBALS['_MAX']['CONF'];
			$clickUrl = '';
			if (is_string($logClick)) {
			$clickUrl 	= 	str_rot13(base64_encode($logClick).base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key']));
			} elseif (!empty($aBanner['url']) || $overrideDest) {				
	
			//$link		=	str_rot13(base64_encode($conf['var']['params'].'='. _adRenderBuildParams($aBanner, $zoneId, $source, $ct0, $logClick, true)).base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key']));	
			$link	=	$conf['var']['params'].'='. _adRenderBuildParams($aBanner, $zoneId, $source, $ct0, $logClick, true); //Hided base64 encode	
			$clickUrl = MAX_commonGetDeliveryUrl($conf['file']['click']) . '?' . $link;
			}

			return $clickUrl;
			}
		function _adRenderBuildStatusCode($aBanner)
		{
			return !empty($aBanner['status']) ? " onmouseover=\"self.status='" . addslashes($aBanner['status']) . "'; return true;\" onmouseout=\"self.status=''; return true;\"" : '';
		}
		function _adRenderGetRealPluginVersion($swfVersion)
		{
			if ($swfVersion <= 10)
			{
			$pluginVersion = $swfVersion;
			}
			elseif ($swfVersion >= 23)
			{
			$pluginVersion = $swfVersion - 11;
			} elseif ($swfVersion == 11 || $swfVersion == 12)
			{
			$pluginVersion = 10 + ($swfVersion - 9) / 10;
			} elseif ($swfVersion >= 13 && $swfVersion <= 22) {
			$pluginVersion = 11 + ($swfVersion - 13) / 10;
			}
			return (string)$pluginVersion;
		}
		function _getAdRenderFunction($aBanner, $richMedia = true)
		{
			$functionName = false;
			if (!empty($aBanner['ext_bannertype'])) {
			return OX_Delivery_Common_getFunctionFromComponentIdentifier($aBanner['ext_bannertype'], 'adRender');
			} else {
			switch ($aBanner['contenttype']) {
			case 'gif' :
			case 'jpeg' :
			case 'png' :
			$functionName = '_adRenderImage';
			break;
			case 'swf' :
			if ($richMedia) {
			$functionName = '_adRenderFlash';
			} else {
			$functionName = '_adRenderImage';
			}
			break;
			case 'txt' :
			$functionName = '_adRenderText';
			break;
			default :
			switch ($aBanner['type']) {
			case 'html' :
			$functionName = '_adRenderHtml';
			break;
			case 'url' :  $functionName = '_adRenderImage';
			break;
			case 'txt' :
			$functionName = '_adRenderText';
			break;
			default:
			$functionName = '_adRenderHtml';
			break;
			}
			break;
			}
			}
			return $functionName;
		}


		define ("PRI_ECPM_FROM", 6);
		define ("PRI_ECPM_TO", 9);
		$GLOBALS['OX_adSelect_SkipOtherPriorityLevels'] = -1;

		function MAX_adSelect($what, $campaignid = '', $target = '', $source = '', $withtext = 0, $charset = '', $context = array(), $richmedia = true, $ct0 = '', $loc = '', $referer = '',$devicetype='',$cb='')
		{	 
		$conf = $GLOBALS['_MAX']['CONF'];
		if(!empty($what))
		{
			if (strpos($what,'zone:') === 0) { 
			$GLOBALS['zoneid'] = intval(substr($what,5));
			} 
		}
		if(!empty($cb))
		{
			$cb_val=explode('=',$cb);
			$GLOBALS['cb']=$cb_val[1];
		}
		if(!empty($devicetype))	
		{
			$device_val=explode('=',$devicetype);
			$GLOBALS['devicetype']=$device_val[1];
		}		
		if (empty($GLOBALS['source'])) {
		$GLOBALS['source'] = $source;
		}
		if (empty($GLOBALS['loc'])) {
		$GLOBALS['loc'] = $loc;
		}
		$originalZoneId = null;
		if (strpos($what,'zone:') === 0) {
		$originalZoneId = intval(substr($what,5));
		} elseif (strpos($what,'campaignid:') === 0) {
		$originalCampaignId = intval(substr($what,11));
		} elseif (strpos($what, 'bannerid:') === 0) {
		$originalBannerId = intval(substr($what,9));
		}
		$userid = MAX_cookieGetUniqueViewerID();
		MAX_cookieAdd($conf['var']['viewerId'], $userid, _getTimeYearFromNow());
		$outputbuffer = '';
		$found = false;
		$GLOBALS['_MAX']['followedChain'] = array();
		$GLOBALS['_MAX']['adChain'] = array();
		$GLOBALS['_MAX']['considered_ads'] = array();
		$first = true;
		global $g_append, $g_prepend;
		$g_append = '';
		$g_prepend = '';
		if(!empty($what)) {
		while ($first || ($what != '' && $found == false)) {
		$first = false;
		$ix = strpos($what, '|');
		if ($ix === false) {
		$remaining = '';
		} else {
		$remaining = substr($what, $ix+1);
		$what = substr($what, 0, $ix);
		}
		if (strpos($what, 'zone:') === 0) {
		$zoneId = intval(substr($what,5));
		$row = _adSelectZone($zoneId, $context, $source, $richmedia);
		} else {
		if (strpos($what, '/') > 0) {
		if (strpos($what, '@') > 0) {
		list ($what, $append) = explode ('@', $what);
		} else {
		$append = '';
		}
		$separate = explode ('/', $what);
		$expanded = '';
		$collected = array();
		reset($separate);
		while (list(,$v) = each($separate)) {
		$expanded .= ($expanded != '' ? ',+' : '') . $v;
		$collected[] = $expanded . ($append != '' ? ',+'.$append : '');
		}
		$what = strtok(implode('|', array_reverse ($collected)), '|');
		$remaining = strtok('').($remaining != '' ? '|'.$remaining : '');
		}
		
		$row = _adSelectDirect($what, $campaignid, $context, $source, $richmedia, $remaining == '');
		}OX_Delivery_logMessage('navani ' . $row['ad_id'], 7);
		if (is_array($row) && empty($row['default'])) {
		$row['request_id']=$_SESSION['request_id'];
		MAX_Delivery_log_logAdRequest($row['bannerid'], $row['zoneid'], $row);
		if (($row['adserver'] == 'max' || $row['adserver'] == '3rdPartyServers:ox3rdPartyServers:max')
		&& preg_match("#{$conf['webpath']['delivery']}.*zoneid=([0-9]+)#", $row['htmltemplate'], $matches) && !stristr($row['htmltemplate'], $conf['file']['popup'])) {
		$GLOBALS['_MAX']['adChain'][] = $row;
		$found = false;
		$what = "zone:{$matches[1]}";
		} else {
		$found = true;
		}
		} else {
		MAX_Delivery_log_logAdRequest(null, $originalZoneId, null);
		$what = $remaining;
		}
		}
		}
		if ($found) {
		$zoneId = empty($row['zoneid']) ? 0 : $row['zoneid'];
		if (!empty($GLOBALS['_MAX']['adChain'])) {
		foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad) {
		if (($ad['ad_id'] != $row['ad_id']) && !empty($ad['append'])) {
		$row['append'] .= $ad['append'];
		}
		}
		}
		$outputbuffer = MAX_adRender($row, $zoneId, $source, $target, $ct0, $withtext, $charset, true, true, $richmedia, $loc, $referer, $context);		
		$djax_zone_info=MAX_cacheGetZoneInfo($zoneId);    
		
		$zoneid=!empty($GLOBALS['zoneid'])?$GLOBALS['zoneid']:$zoneId;  
			
		$zone_statquery=OA_Dal_Delivery_query("SELECT z.status as zstat,s.status as sstat FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." as z, djax_publisher_sites as s, djax_site_zone_assoc as zs WHERE z.zoneid='".$zoneid."' AND z.zoneid=zs.zone_id AND zs.site_id=s.site_id")or die("eerror zone");
							  
		$zone_data=OA_Dal_Delivery_fetchAssoc($zone_statquery);  
		
		$div_random = MAX_getRandomNumber();
						
		if($row['bannerid']!='' && $zone_data['zstat']==0 && $zone_data['sstat']==0)
		{   
				if($djax_zone_info['dj_zone_type']=='W_A_LAY')
				{
					/* Add div link here */
					$adParam			=	'';
					$is_add_div_link	=	'';
					if($row['campaignid'] && $row['bannerid'])
					{
						$adParam	=	urlencode(base64_encode($row['campaignid'].'/'.$row['bannerid']));
					}
					
					if($djax_zone_info['is_div_link']=='-1' || $djax_zone_info['is_div_link']=='1')
					{
						//$is_add_div_link	=	"<script type='text/javascript'>function close_link_layer(){ document.getElementById('add_div_link_layer').style.visibility='hidden'; } </script><div id='add_div_link_layer' style='border-radius:2px; font-size:12px; background-color:#000000; opacity:0.6; z-index:1; float:right; position: absolute; top: 25px; right:0px; padding:2px;' ><a href='http://".$GLOBALS['_MAX']['CONF']['webpath']['directads'].(($adParam)?"/".$adParam:"")."' style='text-decoration:none; color:#ffffff;' >Your ad here</a><span onclick='close_link_layer();' style='color:#ffffff;font-weight:bold;cursor:pointer;'>&nbsp;&nbsp;&times;</span></div>"; 
						$is_add_div_link='';
					}
					/* Add div link here */
              
                       $conf = $GLOBALS['_MAX']['CONF'];
						
					   $mopath ="http://".$conf['webpath']['delivery'] . '/';
						
					   $adblockerpath ="http://".$conf['webpath']['deliveryPlugins'] . '/';
					
					   $icon="http://".$conf['webpath']['icons'] . '/';
						
					   $image_path=$row['image_path']; 
						
					   $img_path=explode("/",$image_path);
					   foreach($img_path as $key=>$value)
						{
							if($value=="delivery")
							{					
								$key_val=$key+1;
							}									  
						}		
						$image_val=$img_path[$key_val];  														
						$domain = fetch_domain();
						$img=$domain.$img_path[$key_val].'/'.$img_path[$key_val+1].'/';
						$img_close="http://".$conf['webpath']['images'] . '/';
						$close_img="http://".$conf['webpath']['icons'].'/';
						$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
						
						$type=$row['storagetype'];
						 
						$add_bannerid=$row['filename1'];

						$direct_query=OA_Dal_Delivery_query("SELECT zoneid  FROM ".$conf['table']['prefix'].$conf['table']['zones']." where dj_zone_type='W_A_DL' AND dj_is_deleted='0' AND affiliateid=".$djax_zone_info['publisher_id']."")or die("Error zone");  
	 						
						  if(OA_Dal_Delivery_numRows($direct_query)>0)
						  {							  							   
							  while($directurl=OA_Dal_Delivery_fetchAssoc($direct_query))
							  {		  					
								$directzone[]=$directurl['zoneid'];						
							  }							  
							  $direct_zone=array_rand($directzone);				  
												 
							  $link_ad=$directzone[$direct_zone];					 											
						  }
						  else
						  {  
							  
						  $popup_query=OA_Dal_Delivery_query("SELECT zoneid  FROM ".$conf['table']['prefix'].$conf['table']['zones']." where dj_zone_type='W_A_PUP' AND dj_is_deleted='0' AND affiliateid=".$djax_zone_info['publisher_id']."")or die("Popup Zone");  
						  while($popupurl=OA_Dal_Delivery_fetchAssoc($popup_query))
						  {
							  $popupzone[]=$popupurl['zoneid'];						 
						  }     
														
							 $popup_zone=array_rand($popupzone);				  
												 
							 $link_ad=$popupzone[$popup_zone];   							
						  }
						  
						 $query="SELECT filename FROM ".$conf['table']['prefix'].$conf['table']['banners']." WHERE bannerid=".$add_bannerid."";						 
						 
						 $data = OA_Dal_Delivery_query($query) or die(mysql_error());
						
						 $result=OA_Dal_Delivery_fetchAssoc($data);
						 
						 if($type=="url")
						 {
							 $urlad_status='true';
							 $img_status='false';
							 $content_status='false';
							 
					     }	 
					     else if($type=="html")
					     {
							 
							  $urlad_status='false';
							  $img_status='false';
							  $content_status='true';
							 
					     }	
					     else
					     {
							  $urlad_status='false';
							  $img_status='true';
							  $content_status='false';
					     }	  
					    				     
					    	if(isset($_COOKIE['layerad_'.$zoneid]))
							{
								return false;
							}
							$db_row=data_from_memcache($zoneid);
							$db_width = $db_row['width'];
							$db_height = $db_row['height'];									
							$db_top=$db_row['top_banner'];
							$db_topzone=$db_row['top_adblock']; 
			                $db_bottom=$db_row['bottom_banner'];
							$db_bottomzone=$db_row['bottom_adblock'];
							$db_exit=$db_row['exit_link'];
							$db_exiturl=$db_row['frame_url'];
							$db_exitcolor=$db_row['exit_link_color'];
							$db_closetext=$db_row['exit_link_text'];
							$db_closeposition=$db_row['close_link_position'];
							$db_position=$db_row['float_position'];
							$layer_position=$db_row['layer_position'];  
							$db_backgroundcolor=$db_row['background_color'];
							$db_bordercolor=$db_row['border_color'];
							$db_titlecolor=$db_row['title_color'];
							$db_title=$db_row['title'];
							$db_autoreload=$db_row['auto_reload'];
							$db_reloadtime=$db_row['reload_time'];
							$db_colorstyle=$db_row['color_style'];
							$db_top_option=$db_row['layer_top_option'];
							$db_top_backgroundcolor=$db_row['top_backgroundcolor'];
							$db_bottom_option=$db_row['layer_bottom_option'];
							$db_bottom_backgroundcolor=$db_row['bottom_backgroundcolor'];
							$db_layer_border=$db_row['layer_border'];
							$db_layer_option=$db_row['layer_border_option'];
							$db_layer_border_bg_color=$db_row['border_backgroundcolor'];
							$db_auto_scroll=$db_row['auto_scroll'];
							$automatically_close=$db_row['automatically_close'];
							$automatically_close_time=$db_row['automatically_close_time'];
							$reload_trigger=$db_row['reload_trigger'];	
							$viewrid = $GLOBALS['_MAX']['CONF']['var']['viewrid'];
							$current_viewerid=$_COOKIE[$viewrid];
							
							/**center layer DAC091**/
														
							if($layer_position=='center')
							{
								$topandbottom = 'false';
								$auto='parent';
								$top=0;
								$bottom1=-100;
								$bottom2=100;
							}
							else if($layer_position=='top'){
								$topandbottom = 'true';
								$auto='auto';
								$top=0;
								$bottom1=100;
								$bottom2=100;
							}
							else if($layer_position=='bottom'){
								$topandbottom = 'true';
								$auto='auto';
								$top='(bh-ht)+200';
								$bottom1=0;
								$bottom2=0;
							}
							else
							{
								$topandbottom = 'true';
								$auto='auto';
								$top=0;
								$bottom1=100;
								$bottom2=100;
								
								}
							
							/**cenetr layer DAC091**/
							
																											
							if($reload_trigger=='2')
							{
								$clicks_count=$db_row['clicks_count'];
								$clicks_time=$db_row['clicks_time'];			
							
							$djax_resettime = time() - $clicks_time;
							$djax_imp_resettime = date("Y-m-d H:i:s",$djax_resettime);	
					
							$zone_click = OA_Dal_Delivery_query("Select * from djax_ad_zone_click_count WHERE viewer_id='".$current_viewerid."' AND zone_id='".$zoneid."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC") or die("Error");
							
							$count=OA_Dal_Delivery_numRows($zone_click); 
							
							if($count>=$clicks_count)
								{ 
									return false;  
								}
							}
						
						if((empty($db_width) && empty($db_height)) || ($db_width=='-1' && $db_height=='-1') )
						{
							if($type=="url")
							{
							   $width=$djax_zone_info['width'];
							   $height=$djax_zone_info['height'];
							   $img_height=$djax_zone_info['height']-20;						
						    }
						    else 
						    {
							 $width= $djax_zone_info['width'];  
						     $height=$djax_zone_info['height']; 
						     $img_height=$djax_zone_info['height']-20;
						     }		
					    }
					    else
					    {							

						   $width=$db_width;
						      
						   $height=$db_height; 
						   
						   $img_height= $db_height-20;						 						   
						}	
					
						/* Layer border */
						
						if($db_layer_option=='yes')
						{
							$db_layer_color='transparent';				
						}
						else
						{
							if($db_layer_border_bg_color!='')
							{
								$db_layer_color=$db_layer_border_bg_color;
							}
							else
							{
								$db_layer_color='#000000';
							}
						}
					
						if($db_layer_border=="dark")
						{
							$layer_border="border-style: solid;border-width:thick;";
							$layer_border.="border-color:".$db_layer_color;
						}
						else if($db_layer_border=="thin")
						{
							$layer_border="border-style: solid;border-width:thin;";
							$layer_border.="border-color:".$db_layer_color;
						} 
						else
						{
							$layer_border="border-style: solid;border-width:thin;";
							$layer_border.="border-color:#000000";
						}						
						
						
						/* Auto scrolling */
						
						if(!empty($db_row))
						{
							if($db_auto_scroll=='1')
							{
								$auto_scroll="true";
							}
							else
							{
								$auto_scroll="false";
							}
						}
						else
						{
							$auto_scroll="true";
						}
						
						
							
					 $db_top=($db_top!='')?$db_top:'1';  
					 
					 $domain=fetch_domain();
										 
				    if($db_top==1 )
					{
					  $top_status='true';
					  
					  	  if(empty($db_topzone) || $db_topzone=='-1')  
						  {  						  
							  $publisherid=$row['affiliate_id'];
							  
							  $default_query=OA_Dal_Delivery_query("SELECT zoneid  FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." where dj_is_deleted='0' AND dj_zone_type='W_BAN' AND affiliateid=".$publisherid." AND width='728' AND height='90'")or die("test zone");     
				  
							   if(OA_Dal_Delivery_numRows($default_query)>0)
							   {   
								   while($defaulturl=OA_Dal_Delivery_fetchAssoc($default_query))
									{		
										 $sel_zoneid=$defaulturl['zoneid'];
										 $ad_zone_query= OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." where zone_id='$sel_zoneid'")or die("zone");
																	
										 if(OA_Dal_Delivery_numRows($ad_zone_query)>0)
										 { 		
											$defaulturl_zone[]=$sel_zoneid;						
										 }
									}
									
								$rand = array_rand($defaulturl_zone);
								$top_zone=$defaulturl_zone[$rand];    
								
								$userAgent = $_SERVER["HTTP_USER_AGENT"];
								$devicesTypes = array(
									"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera"),
									"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
									"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini")        
								);
								foreach($devicesTypes as $deviceType => $devices) {           
									foreach($devices as $device) {
										if(preg_match("/" . $device . "/i", $userAgent)) {
											$deviceName = $deviceType;
										}
									}
								}
								$device_type= $deviceName;  
								$random=rand();	
								$cb="c=";
								$loc="l=";
								$ref="r=";
								
								echo 'var script = document.createElement("script");
								script.src = "'.$domain.'a4c32938.php?"+"'.$cb.'"+"'.$random.'"+"'.$loc.'"+escape(window.location)+"'.$ref.'"+escape(document.referrer);
								document.getElementsByTagName("head")[0].appendChild(script);';
								
								$enc_key='d07484bhd3';	
								$val="zoneid=".$top_zone."&devicetype=".$device_type."&cb=".$random;
								$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
								
								$top_url=$domain."60f2faf4cf978b74921e53ec82b6e7fd.php?".$value;
								
								//header("Content-Type: image/jpeg");  
								$protocol 	= stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
								$loc 		= "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
								$referer 	= "";
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL,$top_url);
								$headers = array(	'Accept: application/json',
													'Content-type: application/json',
													'X-ApiKey : XXXXXXXXXX',
													'Accept-Language: en'
												);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_HEADER, false);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
								curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
								curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER ['HTTP_USER_AGENT']);
								$result = curl_exec($ch);
								$top_code= '<script type="text/javascript" >'.$result.'</script>';
								}
								else
								{ 
								
								$default_banner_query=OA_Dal_Delivery_query("SELECT zoneid  FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." where dj_is_deleted='0' AND dj_zone_type='W_BAN' AND width='728' AND height='90'")or die("eerror zone");  
								  
								  if(OA_Dal_Delivery_numRows($default_banner_query)>0)
										{
											while($defaulturl=OA_Dal_Delivery_fetchAssoc($default_banner_query))
											{		
												 $sel_zoneid=$defaulturl['zoneid'];
												 $ad_zone_query= OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." where zone_id='$sel_zoneid'")or die("zone");
																			
												 if(OA_Dal_Delivery_numRows($ad_zone_query)>0)
												 { 		
													$defaulturl_zone[]=$sel_zoneid;						
												 }
											}
											
											$rand = array_rand($defaulturl_zone); 											
																 
											$top_zone=$defaulturl_zone[$rand];
																																									$userAgent = $_SERVER["HTTP_USER_AGENT"];
										$devicesTypes = array(
											"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera"),
											"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
											"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini")        
										);
										foreach($devicesTypes as $deviceType => $devices) {           
											foreach($devices as $device) {
												if(preg_match("/" . $device . "/i", $userAgent)) {
													$deviceName = $deviceType;
												}
											}
										}
										$device_type= $deviceName;  
										$random=rand();	
										$cb="c=";
										$loc="l=";
										$ref="r=";
										
										echo 'var script = document.createElement("script");
										script.src = "'.$domain.'a4c32938.php?"+"'.$cb.'"+"'.$random.'"+"'.$loc.'"+escape(window.location)+"'.$ref.'"+escape(document.referrer);
										document.getElementsByTagName("head")[0].appendChild(script);';
										
										$enc_key='d07484bhd3';	
										$val="zoneid=".$top_zone."&devicetype=".$device_type."&cb=".$random;
										$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
										
										$top_url=$domain."60f2faf4cf978b74921e53ec82b6e7fd.php?".$value;
										
										//header("Content-Type: image/jpeg");  
										$protocol 	= stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
										$loc 		= "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
										$referer 	= "";
										$ch = curl_init();
										curl_setopt($ch, CURLOPT_URL,$top_url);
										$headers = array(	'Accept: application/json',
															'Content-type: application/json',
															'X-ApiKey : XXXXXXXXXX',
															'Accept-Language: en'
														);
										curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
										curl_setopt($ch, CURLOPT_HEADER, false);
										curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
										curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
										curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
										curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER ['HTTP_USER_AGENT']);
										$result = curl_exec($ch);
										$top_code= '<script type="text/javascript" >'.$result.'</script>';
										
								}
								 		else
								 		{
											$top_code='<img src="'.$adblockerpath.'/images/bottom.jpg">';
										}						 		
								  
								}	  							
							 
						  }   
						  else
						  {							  
							  							
						  		$protocol 	= stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
								$loc 		= "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
								$referer 	= "";
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL, 	"".$mopath."top_banners.php?zoneid=".$top_zone."&autoreload=0&devicetype=web&loc=$loc&referrer=$referer");
									
								$headers = array(	'Accept: application/json',
													'Content-type: application/json',
													'X-ApiKey : XXXXXXXXXX',
													'Accept-Language: en'
												);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_HEADER, false);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
								curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
								curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER ['HTTP_USER_AGENT']);
								$result = curl_exec($ch);
								$top_code= '<script>'.$result.'</script>';
					
						  }
						
				     }	
				     else
				     {  
						 $top_status='false';
						 $top_code='';
				     }	 
				   			
					
				    
				    $db_bottom=($db_bottom!='')?$db_bottom:'1';
				    
				   			       
				    if($db_bottom==1 )
				    {
						 
						  $bottom_status='true';
						  if(empty($db_bottomzone) || $db_bottomzone=='-1')
						  {							
							  $publisherid=$row['affiliate_id'];
							  
							  $default_query=OA_Dal_Delivery_query("SELECT zoneid  FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." where dj_is_deleted='0' AND dj_zone_type='W_BAN' AND affiliateid=".$publisherid." AND width='728' AND height='90'")or die("eerror zone");  
				  
							  if(OA_Dal_Delivery_numRows($default_query)>0)
							  {
								  while($defaulturl=OA_Dal_Delivery_fetchAssoc($default_query))
								  {		
									 $sel_zoneid=$defaulturl['zoneid'];
									 $ad_zone_query= OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." where zone_id='$sel_zoneid'")or die("zone");
																
									 if(OA_Dal_Delivery_numRows($ad_zone_query)>0)
									 { 		
										$defaulturl_zone[]=$sel_zoneid;						
									 }
								  }
								  
								  $rand = array_rand($defaulturl_zone);
							 
							      $bottom_zone=$defaulturl_zone[$rand];			


								$userAgent = $_SERVER["HTTP_USER_AGENT"];
								$devicesTypes = array(
									"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera"),
									"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
									"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini")        
								);
								foreach($devicesTypes as $deviceType => $devices) {           
									foreach($devices as $device) {
										if(preg_match("/" . $device . "/i", $userAgent)) {
											$deviceName = $deviceType;
										}
									}
								}
								$device_type= $deviceName;  
								$random=rand();										
								$cb="c=";
								$loc="l=";
								$ref="r=";
																										
								echo 'var script = document.createElement("script");
								script.src = "'.$domain.'a4c32938.php?"+"'.$cb.'"+"'.$random.'"+"'.$loc.'"+escape(window.location)+"'.$ref.'"+escape(document.referrer);
								document.getElementsByTagName("head")[0].appendChild(script);';
								
								$enc_key='d07484bhd3';	
								$val="zoneid=".$bottom_zone."&devicetype=".$device_type."&cb=".$random;
								$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
								
								$bottom_url=$domain."f4d0207cbe297fcffc6ccfc615706483.php?".$value;
								
								$protocol 	= stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
								$loc 		= "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
								$referer 	= "";
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL,$bottom_url);
								$headers = array(	'Accept: application/json',
													'Content-type: application/json',
													'X-ApiKey : XXXXXXXXXX',
													'Accept-Language: en'
												);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_HEADER, false);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
								curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
								curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER ['HTTP_USER_AGENT']);
								$result = curl_exec($ch);
								$bottom_code= '<script>'.$result.'</script>';


								 
							  }
							  else
							  {
								  $default_banner_query=OA_Dal_Delivery_query("SELECT zoneid  FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." where dj_is_deleted='0' AND dj_zone_type='W_BAN' AND width='728' AND height='90'")or die("eerror zone");  
								  
								  if(OA_Dal_Delivery_numRows($default_banner_query)>0)
										{
											while($defaulturl=OA_Dal_Delivery_fetchAssoc($default_banner_query))
											{		
												 $sel_zoneid=$defaulturl['zoneid'];
												 $ad_zone_query= OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." where zone_id='$sel_zoneid'")or die("zone");
																			
												 if(OA_Dal_Delivery_numRows($ad_zone_query)>0)
												 { 		
													$defaulturl_zone[]=$sel_zoneid;						
												 }
											}
											
											$rand = array_rand($defaulturl_zone);
							 
											$bottom_zone=$defaulturl_zone[$rand];	

										    $userAgent = $_SERVER["HTTP_USER_AGENT"];
										$devicesTypes = array(
											"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera"),
											"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
											"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini")        
										);
										foreach($devicesTypes as $deviceType => $devices) {           
											foreach($devices as $device) {
												if(preg_match("/" . $device . "/i", $userAgent)) {
													$deviceName = $deviceType;
												}
											}
										}
										$device_type= $deviceName;  
										$random=rand();										
										$cb="c=";
										$loc="l=";
										$ref="r=";
																												
										echo 'var script = document.createElement("script");
										script.src = "'.$domain.'a4c32938.php?"+"'.$cb.'"+"'.$random.'"+"'.$loc.'"+escape(window.location)+"'.$ref.'"+escape(document.referrer);
										document.getElementsByTagName("head")[0].appendChild(script);';
										
										$enc_key='d07484bhd3';	
										$val="zoneid=".$bottom_zone."&devicetype=".$device_type."&cb=".$random;
										$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
										
										$bottom_url=$domain."f4d0207cbe297fcffc6ccfc615706483.php?".$value;
										
										$protocol 	= stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
										$loc 		= "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
										$referer 	= "";
										$ch = curl_init();
										curl_setopt($ch, CURLOPT_URL,$bottom_url);
										$headers = array(	'Accept: application/json',
															'Content-type: application/json',
															'X-ApiKey : XXXXXXXXXX',
															'Accept-Language: en'
														);
										curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
										curl_setopt($ch, CURLOPT_HEADER, false);
										curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
										curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
										curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
										curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER ['HTTP_USER_AGENT']);
										$result = curl_exec($ch);
										$bottom_code= '<script>'.$result.'</script>';
								 		}
								 		else
								 		{
											$bottom_code='<img src="'.$adblockerpath.'/images/bottom.jpg">';
										}						 		
								  
							  }														  
							  
						  }  
						  else
						  {
						 
						       $protocol 	= stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
								$loc 		= "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
								$referer 	= "";
								$ch = curl_init();
								curl_setopt($ch, CURLOPT_URL, 	"".$mopath."bottom_banners.php?zoneid=".$bottom_zone."&autoreload=0&devicetype=web&loc=$loc&referrer=$referer");
								$headers = array(	'Accept: application/json',
													'Content-type: application/json',
													'X-ApiKey : XXXXXXXXXX',
													'Accept-Language: en'
												);
								curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
								curl_setopt($ch, CURLOPT_HEADER, false);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
								curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
								curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
								curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER ['HTTP_USER_AGENT']);
								$result = curl_exec($ch);
								$bottom_code= '<script>'.$result.'</script>';
					     		      
					  }				
						
				     }	
				     else
				     {
						 $bottom_status='false';
						 $bottom_code='';
				     }	 
				    	 
				    
				    //////////exit url custom code start/////////////////////////	
				  			  
				     if($db_exit==0)
				     {
						
						 $url_status='false';
						 $url_value='www.google.com';
				     }	
				      
				     else if($db_exit==3)
				     {
						$url_status='true';
						
						$url_value=$db_exiturl;
					 }	 
					 else if($db_exit==1)
				     {
						$url_status='true';
						
						$url_value=$row['url'];
					 }	
					 else if($db_exit==2)
				     {
						 $url_status='false';
						
						 $url_value='';
					 }
					 else
					 {
						 $url_status='false';
						
						 $url_value='';
					 }
					 
										 
					 //////////exit url custom code end/////////////////////////	  
				      	
				      	if(empty($db_closetext) || $db_closetext=='-1')
				      	{
							$close_txt="Close!";
					    }			
					    else
					    {
							$close_txt=$db_closetext;
					    }	
					    if(empty($db_position) || $db_position=='-1')	
					    {
							$direction='left';
					    }	
					    else
					    {
							$direction=$db_position;				
							
					    }	
					    
					    
					    if(empty($db_closeposition) || $db_closeposition=='-1' )
					    {
							$clo_dir="right";
							$titalign='left';
							$value='3px';
					    }	
					    else
					    {
							$clo_dir=$db_closeposition;
							if($clo_dir=='center')
							{
								$clo_dir='left';
								$value='50%';
								$titalign='left';
						    }
						    else
						    {
								$titalign=($clo_dir=='left')?'center':'left';
								$value='3px';
						    }		
					    }
					    
					     //layer border color 
							 
							
						 if(empty($db_bordercolor) || $db_bordercolor=='1')
						{
							$border_color='#000000';
						}	 
						else
						{
							 $border_color=$db_bordercolor; 
						}
					    if($db_colorstyle==1)
					    {
								  //back ground color
							 if(empty($db_backgroundcolor) || $db_backgroundcolor=='-1' )
							 {
								 $back_color='#000000';
							 }	 
							 else
							 {
								  $back_color=$db_backgroundcolor;
							 }	 
							 
							
							 
							 //exit link(close button) color
								 
							 if(empty($db_exitcolor) || $db_exitcolor=='1')
							 {
								 $exit_color='#FFFFFF';
							 }	 
							 else
							 {
								  $exit_color=$db_exitcolor;
							 }	
							 //title color 
							  if(empty($db_titlecolor) || $db_titlecolor=='1' )
							 {
								 $title_color='#FFFFFF';
							 }	 
							 else
							 {
								 
								  $title_color=$db_titlecolor;
							 }	    
					    }	
				    else
					{
						 $back_color='#000000';
						 $title_color='#FFFFFF';
						 $exit_color='#FFFFFF';
						// $border_color='#000000';
				    }	 
				    
				    
					if($db_top_option=='yes')
					{
						$top_bg_color='transparent';				
					}
					else
					{
						if($db_top_backgroundcolor!='')
						{
							$top_bg_color=$db_top_backgroundcolor;
						}
						else
						{
							$top_bg_color='#000000';
						}
					}
					
					if($db_bottom_option=='yes')
					{	
						$bottom_bg_color='transparent';
					}
					else
					{
						if($db_bottom_backgroundcolor!='')
						{
							$bottom_bg_color=$db_bottom_backgroundcolor;
						}
						else
						{
							$bottom_bg_color='#000000';
						}
					}
					//variable initialized for the height of the ad	
				$auto_val='$auto_val';
				$jsoutput= "<script  type='text/javascript'  src='{$adblockerpath}js/jquery-latest.min.js'></script>";
								
				$jsoutput .= "<script  type='text/javascript'  src='{$adblockerpath}js/custom_finaldg.js'></script>";
			
				if($automatically_close=='1')
				{	
					$closing_time=$automatically_close_time*1000;
					
				    $jsoutput .= "<script  type='text/javascript'>				
					setTimeout(function(){ document.getElementById('se".$div_random."').style.display = 'none'; 	
					$('.t".$div_random."').fadeOut(800);},'".$closing_time."');					
					</script>";
				}
				
				
			
									
			/*Condition for layer ad */
			if($width<800)
			{		
				$top_status="false";
				$jsoutput .= "<style>
				#b_b".$div_random."
				{
					display:none;
				}
				</style>";				
			}	
			
			 
	     	$jsoutput .= "<script type='text/javascript'>
						//changed by DAC091
				function cls(){
				$('.t".$div_random."').fadeOut(800);
				document.getElementById('se".$div_random."').style.display = 'none'; 
				}
                $(document).ready(function(){
				var ht = $('#se".$div_random."').height();
				var body = document.body,
				html = document.documentElement;
				var by = Math.max( body.scrollHeight, body.offsetHeight, 
                       html.clientHeight, html.scrollHeight, html.offsetHeight );					
				if(by < ht)
				 {
				  $('body').height('ht');
				  var bh=ht;
				  var top_val='0';
				  var topbtm=true;  
				 ".$auto_val."='auto';
				 var bottom1='100';  
			
				} 
				else{
				 var bh = by;
				 var top_val=".$top.";
				var topbtm =".$topandbottom.";
				var bottom1 ='".$bottom1."';
				
				if('$auto'=='parent')
				{
					".$auto_val."='parent';
				}
				else{
					".$auto_val."='auto';
				}
				
				}
				
		    $('#se".$div_random."').show();
	    	$('#se".$div_random."').ads({
		
				setContainer:{
					container:true,					
					center:true, 
					setCustomize:{
						customize:true,
						width:'auto',
						height:".$auto_val.", 
						widthAndHeightOnly:true,
						topAndBottomOnly:topbtm,
						from:{
							//this is shift to nagative values
							top:top_val,
							left:100,
							right:-100,
							bottom:bottom1
						},
						to:{
							top:top_val,
							left:100,
							right:100,
							bottom:".$bottom2."
						}
					},					
					direction:'".$direction."',
					layer_position:'".$layer_position."'
					//scroll:true
					
				},				
				setTitle:{
					title:true,
					width:'auto',
					height:20,
					font:'12px/20px arial',
					color:'".$title_color."'				
				},				
				setTopBanner:{
					banner:".$top_status.",
					width:'auto',
					height:'auto',
					setImage:{
						image:true,
						width:'auto',
						height:90
					},
					setIframe:{
						iframe:false,
						width:'100%',
						height:'100px'   
					}					
				},	
				setMiddleBanner:{
					banner:true,
					width:'".$width."',
					height:'".$height."',
					setImage:{
						image:".$img_status.",
						width:'".$width."',
						height:'".$img_height."'
					},
					setIframe:{
						iframe:".$urlad_status.",
						width:'".$width."',
						height:'".$img_height."'   
					},
					setContent:{
						content:".$content_status.",
						width:'".$width."',
						height:'".$img_height."'   
					}			
					
									
				},
				setBottomBanner:{
					banner:".$bottom_status.",
					width:'100%',
					height:60,
					setImage:{
						image:true,
						width:'100%',
					     height:60
					},
					setIframe:{
						iframe:false,
						width:'100%',
						height:'100px'   
					}					
				},
				setClose:{
				
					close:true,
					width:'100%',
					height:'auto',
					setRedirect:{
						redirect:".$url_status.",
						url:'".$url_value."',
						target:'_blank'
					}			
				}	
			
		});
		var scroll = '$auto_scroll';  
	  
		if(scroll =='true')
		{
			//changed by DAC091
			var body = document.body;
			var html = document.documentElement;
			var height = Math.max( body.scrollHeight, body.offsetHeight, 
            html.clientHeight, html.scrollHeight, html.offsetHeight );
			var center = height/3;
			var bottom = (bh-ht)+200;
			if('$layer_position'=='center')
			{
				 setTimeout(  function()   { $('html, body').animate({ scrollTop:center }, 1500);},2000);
			}
			else if('$layer_position'=='bottom')
			{
				setTimeout(  function()   { $('html, body').animate({ scrollTop:bottom }, 1500);},2000);
			}
			else{
				setTimeout(  function()   { $('html, body').animate({ scrollTop:200 }, 1500);},2000);
			}
			////changed by DAC091
		}
		setTimeout(  function()   {
			$('.t".$div_random."').fadeIn(800);
			},800);
			})
				function popup()
				{
					$('.t".$div_random."').fadeOut(800);
					var image=new Image();
					image.src='".$row['clickUrl']."';					 					
					var head = document.getElementsByTagName('head')[0];
					var js = document.createElement('script');
					js.type = 'text/javascript';
					js.src = '".$mopath."layer_popup.php?zoneid=".$link_ad."';
					head.appendChild(js);
					
					return false;
				}	

				function trigger()
				{		
					$('.t".$div_random."').fadeOut(800);	
					var image=new Image();
					image.src='".$row['clickUrl']."';					 
					
				}
					
			</script>";  
			/*function popup()
				{
					$('.t".$div_random."').fadeOut(800);
					var image=new Image();
					image.src='".$row['clickUrl']."';					 					
					jQuery('#di".$zoneid."').attr('src','".$mopath."cookie.php?zone_id=".$zoneid."');	
					var head = document.getElementsByTagName('head')[0];
					var js = document.createElement('script');
					js.type = 'text/javascript';
					js.src = '".$mopath."layer_popup.php?zoneid=".$link_ad."';
					head.appendChild(js);					
					return false;
				}	

				function trigger()
				{		
					$('.t".$div_random."').fadeOut(800);	
					var image=new Image();
					image.src='".$row['clickUrl']."';					 
					jQuery('#di".$zoneid."').attr('src','".$mopath."cookie.php?zone_id=".$zoneid."');				
				}*/
					
			$jsoutput .= "<style>									
			.title{ background-color:".$back_color."; margin:0px; text-align:".$titalign."; padding-left:10px;font: 15px/60px arial;}
			.tb".$div_random." {
				text-align:center;
				font: 15px/10px arial;
				background-color:".$top_bg_color.";
				}
			.tb".$div_random." img {
			 margin: 0 auto;
			}
			#se".$div_random."{ position:absolute; z-index:11;padding-top:5px;}
					.close {
					cursor: pointer;
					position: absolute;
					".$clo_dir.":".$value.";
					top: 3px;
					z-index: 1111;
					color:".$exit_color.";
				}
				#close_top{
				cursor: pointer;
				position: absolute;
				right:-10px;
				top: -6px;
				z-index: 1111;
				color:#FFFFFF;
				}
				.mb".$div_random." {
					position: relative;	
				}
				.bb".$div_random." {
				text-align:center;
				font: 15px/10px arial;
				background-color:".$bottom_bg_color.";
				}
				.bb".$div_random." img {
				margin: 0 auto;
					}
				.i".$div_random."{ border:1px solid #ccc;display:none;}
			   
				img{
				opacity:1;
				}
				body{ margin:0px;}
				.t".$div_random." {
				background-color: black;
				display: none;
				height: 100%;
				opacity: 0.65;
				position: fixed;
				width: 100%;
				z-index: 11;
				}			
			</style>";
			
			 $layer_image=$img.$row['filename'];   
			
			 $layer_url=$row['imageurl'];		
		
		    $html_text=$row['htmltemplate'];  
		    $add_image=$img.$result['filename'];      
		  	
			$jsoutput .= '<div class="t'.$div_random.'"></div>
			<div id="se'.$div_random.'" style="display:none;" >					
					<div class="c'.$div_random.'" id="c'.$div_random.'" style="'.$layer_border.'">					
					<div class="tb'.$div_random.'"> 
					'.$top_code.'
					</div>	
                    <div class="mb'.$div_random.'" style="height:'.$height.'">					
					<img src="" id="di'.$zoneid.'" style="display:none" width="1px" height="1px">';
							    
					if($url_status=="true")
					  	{							
					     	 $jsoutput .= ' <div class="close" id="ct'.$div_random.'"><a onclick="return trigger()"><img src="'.$close_img.'/close_button2.png"/></a></div>';
					    }
						else
						 {						
								if($db_exit==2)
								{
							    $jsoutput .= '<div class="close" id="ct'.$div_random.'"><a onclick="return popup()"><img src="'.$close_img.'/close_button2.png"/></a></div>';
								
								}
							    else
							    {
								       $jsoutput .= '<div class="close" id="ct'.$div_random.'"><a onclick="return trigger()"><img src="'.$close_img.'/close_button2.png"/></a></div>';	
							    }	
						    }	
						  
						      $type=explode('.',$layer_image);
						      $im_type=$type[4];   
						      
						    						
							  
						    if($im_type=='swf')
						    {								 							
								  $b='flashvars="clickTAG='.$row['clickUrl'].'"';
			                      $b1='<param value="clickTAG='.$row['clickUrl'].'" name="flashvars">';
								
								   $jsoutput .= '  
								<object width="800" height="400" >'.$b1.'
								<param name="movie" width='.$width.'height='.$img_height.' value='.$layer_image.'/>
								<embed width='.$width.' height='.$img_height.' src='.$layer_image.''.$b.'  /> </embed></object>
								'.$is_add_div_link.'<div class="c'.$div_random.'t">'. $html_text.'</div>
								 <iframe class="i'.$div_random.'" src="'.$layer_url.'"></iframe>
								 </a>
								<img src="'.$row['logUrl'].'" style="display:none;" style= "width:0px; height:0px;" >						
								</div>	
								<div class="bb'.$div_random.'" id="b_b'.$div_random.'">'.$bottom_code.'</div>
								</div>							
								</div>';
							}
							else
							{				 	        
								$jsoutput .= '<a href="'.$row['clickUrl'].'" target="_blank">
								<img style="border:1px thin black;" src='.$layer_image.' />
								<div class="c'.$div_random.'t">'. $html_text.'</div>
								 <iframe class="i'.$div_random.'" src="'.$layer_url.'"></iframe>
								 '.$is_add_div_link.'</a>
								<img src="'.$row['logUrl'].'" style="display:none;" style= "width:0px; height:0px;">						
								</div>	
								<div class="bb'.$div_random.'" id="b_b'.$div_random.'">'.$bottom_code.'</div>						
								</div></div>';
			           }				   
					   		
                
                  	if($db_autoreload==1)
					{
					 $reload_time=1000 * $db_reloadtime;
                     $jsoutput .= "<script type='text/javascript'>setInterval(function(){
                 location.href=location.href; },".$reload_time.");</script>";
                 
			       }
			       			      
			    }
			    
		}
		else
		{

			if($zone_data['zstat']==0 && $zone_data['sstat']==0){
				
															
				$passback_ad=djax_passback_ads($djax_zone_info);

				if($row['type']=='txt')
				{
					$row['html']=$passback_ad['tag'];
			
					$jsoutput=$row['html'];
				}
				else
				{
					$widthx =$GLOBALS['_MAX']['device']['device_width']; //device width

					$heightx =$GLOBALS['_MAX']['device']['device_height']; //device height
			
					$jsoutput="<div style='width:".$widthx.";height:".$heightx.";overflow:hidden;'>".$passback_ad['tag']."</div>";

				}
			}
			else
			{
				$jsoutput='';
			}

		}

			/*$exit_popup= data_from_memcache($zone_id);
			$enable_exit_popunder=$exit_popup['enable_exit_popunder'];
			$exit_popunder_id=$exit_popup['exit_popunder_id'];
			
			if($enable_exit_popunder=='1')
			{
								$userAgent = $_SERVER["HTTP_USER_AGENT"];
								$devicesTypes = array(
									"web" => array("msie 10", "msie 9", "msie 8", "windows.*firefox", "windows.*chrome", "x11.*chrome", "x11.*firefox", "macintosh.*chrome", "macintosh.*firefox", "opera"),
									"tablet"   => array("tablet", "android", "ipad", "tablet.*firefox"),
									"mobile"   => array("mobile ", "android.*mobile", "iphone", "ipod", "opera mobi", "opera mini")        
								);
								foreach($devicesTypes as $deviceType => $devices) {           
									foreach($devices as $device) {
										if(preg_match("/" . $device . "/i", $userAgent)) {
											$deviceName = $deviceType;
										}
									}
								}
								$device_type= $deviceName;  
								$random=rand();										
								$cb="c=";
								$loc="l=";
								$ref="r=";
								
								$domain_query = OA_Dal_Delivery_query("SELECT * FROM djax_adblock_domains where status='1' AND is_deleted='0'");
								$domain_result=array();
								if (OA_Dal_Delivery_numRows($domain_query) > 0)
									{ 
										while($res = OA_Dal_Delivery_fetchAssoc($domain_query))
											{		
												$domain_result[]=$res['url'];
											}		
											$rand_keys=array_rand($domain_result,1);		
											$domain=$domain_result[$rand_keys];											
									}	
																																	
								echo 'var script = document.createElement("script");
								script.src = "'.$domain.'a4c32938.php?"+"'.$cb.'"+"'.$random.'"+"'.$loc.'"+escape(window.location)+"'.$ref.'"+escape(document.referrer);
								document.getElementsByTagName("head")[0].appendChild(script);';
								
								$enc_key='d07484bhd3';	
								$val="zoneid=".$exit_popunder_id."&devicetype=".$device_type."&cb=".$random;
								$value=str_rot13(base64_encode($val).base64_encode($enc_key));  
								
								$exit_url=$domain."ZvJxcX3LkZTXL4XNxyWsI0.php?".$value;
																						
								$jsoutput.='<script type="text/javascript" src="'.$exit_url.'"></script>';			
			}*/
					
		$output = array(
		'html' => $jsoutput,
		'bannerid' => $row['bannerid'],
		'contenttype' => $row['contenttype'],
		'alt' => $row['alt'],
		'width' => $row['width'],
		'height' => $row['height'],
		'url' => $row['url'],
		'campaignid' => $row['campaignid'],
		'clickUrl' => $row['clickUrl'],
		'logUrl' => $row['logUrl'],
		'aSearch' => $row['aSearch'],
		'aReplace' => $row['aReplace'],
		'bannerContent' => $row['bannerContent'],
		'clickwindow' => $row['clickwindow'],
		'aRow' => $row,
		'context' => _adSelectBuildContext($row, $context),
		'iframeFriendly' => (bool)$row['iframe_friendly'],
		);
		$row += array(
		'block_ad' => 0,
		'cap_ad' => 0,
		'session_cap_ad' => 0,
		'block_campaign' => 0,
		'cap_campaign' => 0,
		'session_cap_campaign' => 0,
		'block_zone' => 0,
		'cap_zone' => 0,
		'session_cap_zone' => 0,
		);


		if (MAX_Delivery_cookie_cappingOnRequest()) {
		if ($row['block_ad'] > 0 || $row['cap_ad'] > 0 || $row['session_cap_ad'] > 0) {
		MAX_Delivery_cookie_setCapping('Ad', $row['bannerid'], $row['block_ad'], $row['cap_ad'], $row['session_cap_ad']);
		}
		if ($row['block_campaign'] > 0 || $row['cap_campaign'] > 0 || $row['session_cap_campaign'] > 0) {
		MAX_Delivery_cookie_setCapping('Campaign', $row['campaign_id'], $row['block_campaign'], $row['cap_campaign'], $row['session_cap_campaign']);
		}
		if ($row['block_zone'] > 0 || $row['cap_zone'] > 0 || $row['session_cap_zone'] > 0) {
		MAX_Delivery_cookie_setCapping('Zone', $row['zoneid'], $row['block_zone'], $row['cap_zone'], $row['session_cap_zone']);
		}
		MAX_Delivery_log_setLastAction(0, array($row['bannerid']), array($zoneId), array($row['viewwindow']));
		}
		} else {
			if (!empty($zoneId)) {
			$g_append = MAX_adRenderBlankBeacon($zoneId, $source, $loc, $referer).$g_append;
			$outputbuffer = join("\n", OX_Delivery_Common_hook('blankAdSelect', array($zoneId, $context, $source, $richmedia)) ?: []);
			}
			/* Passback Tag */			 
			 $djax_zone_info = MAX_cacheGetZoneInfo($zoneId); 	
             $passback_ad = djax_passback_ads($djax_zone_info);	
					 
             $widthx = $GLOBALS['_MAX']['device']['device_width']; //device width
			 $heightx = $GLOBALS['_MAX']['device']['device_height']; //device height
			 $jsoutput = "<div style='width:" . $widthx . ";height:" . $heightx . ";overflow:hidden;'>" . $passback_ad['tag'] . "</div>";
			
			if (!empty($outputbuffer)) {
			$outputbuffer = $g_prepend . $outputbuffer . $g_append;
			$output = array('html' => $outputbuffer, 'bannerid' => '' );
			} elseif (!empty($row['default'])) {
			if (empty($target)) {
			$target = '_blank';  }
			$outputbuffer = $g_prepend . '<a href=\'' . $row['default_banner_destination_url'] . '\' target=\'' .
			$target . '\'><img src=\'' . $row['default_banner_image_url'] .
			'\' border=\'0\' alt=\'\'>'.$is_add_div_link.'</a>' . $g_append;
			$output = array('html' => $outputbuffer, 'bannerid' => '', 'default_banner_image_url' => $row['default_banner_image_url'] );
			} elseif (!empty($conf['defaultBanner']['imageUrl'])) {
			if (empty($target)) {
			$target = '_blank';  }
			$outputbuffer = "{$g_prepend}<img src='{$conf['defaultBanner']['imageUrl']}' border='0' alt=''>{$is_add_div_link}{$g_append}";
			$output = array('html' => $outputbuffer, 'bannerid' => '', 'default_banner_image_url' => $conf['defaultBanner']['imageUrl']);
			} else {
			$outputbuffer = $g_prepend . $g_append;
			$output = array('html' => $jsoutput, 'bannerid' => '' );
			}
			}
			OX_Delivery_Common_hook('postAdSelect', array(&$output));
			return $output;
			}

		function _getNextZone($zoneId, $arrZone)
		{
			if (!empty($arrZone['chain']) && (substr($arrZone['chain'],0,5) == 'zone:')) {
			return intval(substr($arrZone['chain'],5));
			}
			else {
			return $zoneId;
			}
		}
		function _adSelectZone($zoneId, $context = array(), $source = '', $richMedia = true)
		{  
			if ($zoneId === 0)
			{ 
				return false; 
			}
			global $g_append, $g_prepend;
			while (!in_array($zoneId, $GLOBALS['_MAX']['followedChain']))
			{
			$GLOBALS['_MAX']['followedChain'][] = $zoneId;
			$appendedThisZone = false;
			$aZoneInfo = MAX_cacheGetZoneInfo($zoneId);
			$appinfo   = MAX_cacheGetappInfo(); //DAC015
			if (empty($aZoneInfo)) {
			return false;
			}	
			if ($zoneId != 0 && MAX_limitationsIsZoneForbidden($zoneId, $aZoneInfo))
			{
				
			$zoneId = _getNextZone($zoneId, $aZoneInfo);
			continue;
			}
			$aZoneLinkedAdInfos = MAX_cacheGetZoneLinkedAdInfos ($zoneId);	
			if (is_array($aZoneInfo)) {
			if (isset($aZoneInfo['forceappend']) && $aZoneInfo['forceappend'] == 't') {
			$g_prepend .= $aZoneInfo['prepend'];
			$g_append = $aZoneInfo['append'] . $g_append;
			$appendedThisZone = true;
			}
			$aZoneLinkedAdInfos += $aZoneInfo;
			$aLinkedAd = _adSelectCommon($aZoneLinkedAdInfos, $context, $source, $richMedia);
			if (is_array($aLinkedAd)) {
			$aLinkedAd['zoneid'] = $zoneId;
			$aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
			$aLinkedAd['storagetype'] = $aLinkedAd['type'];
			$aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
			$aLinkedAd['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
			//$aLinkedAd['block_zone'] = @$aZoneInfo['block_zone'];
			$aLinkedAd['cap_zone'] = @$aZoneInfo['cap_zone'];
			if($aLinkedAd['cap_zone']==0)
			{
				$aLinkedAd['cap_zone']=1;
		   }	
			//$aLinkedAd['session_cap_zone'] = @$aZoneInfo['session_cap_zone'];
			
			
			//get tag settings capping and time(block) count
			/* Views count - start - DAC020*/
			
				$default_blkzone=300;
				$default_session_cap=1;
				
								
				$row = data_from_memcache($zoneId);
				$reload_trigger=$row['reload_trigger'];	
				if($reload_trigger!='2')
				{
				$session_cap_zone = ($row['views_count']!='')?$row['views_count']:$default_session_cap;
				$block_zone = ($row['views_time']!='')?$row['views_time']:$default_blkzone;			
				}
				else
				{
				$session_cap_zone = @$aZoneInfo['block_zone'];
				$block_zone = @$aZoneInfo['session_cap_zone'];
				}   
						

				$aLinkedAd['block_zone'] = $block_zone;
				$aLinkedAd['session_cap_zone'] = $session_cap_zone;
			//print_r($aLinkedAd);die("fff");
			/* views count - end - Dac020*/

			//get tag settings capping and time(block) count				
			
			/* add div link */
			$aLinkedAd['is_div_link'] = @$aZoneInfo['is_div_link'];
			/* add div link */				
			
			$aLinkedAd['affiliate_id'] = @$aZoneInfo['publisher_id'];
			if (!$appendedThisZone) {
			$aLinkedAd['append'] .= @$aZoneInfo['append'] . $g_append;
			$aLinkedAd['prepend'] = $g_prepend . @$aZoneInfo['prepend'] . $aLinkedAd['prepend'];
			} else {
			$aLinkedAd['append'] .= $g_append;
			$aLinkedAd['prepend'] = $g_prepend . $aLinkedAd['prepend'];
			}
			return ($aLinkedAd);
			}
			$zoneId = _getNextZone($zoneId, $aZoneInfo);
			}
			}
			if (!empty($aZoneInfo['default_banner_image_url'])) {
			return array(
			'default' => true,
			'default_banner_image_url' => $aZoneInfo['default_banner_image_url'],
			'default_banner_destination_url' => $aZoneInfo['default_banner_destination_url']
			);
			}
			return false;
		}
		function _adSelectCommon($aAds, $context, $source, $richMedia)
		{
			OX_Delivery_Common_hook('preAdSelect', array(&$aAds, &$context, &$source, &$richMedia));
			if (!empty($aAds['ext_adselection']))
			{
				$adSelectFunction = OX_Delivery_Common_getFunctionFromComponentIdentifier($aAds['ext_adselection'], 'adSelect');
			}
			if (empty($adSelectFunction) || !function_exists($adSelectFunction))
			{
				$adSelectFunction = '_adSelect';
			}
			if (!empty($aAds['count_active']))
			{
				if (isset($aAds['zone_companion']) && isset($context)) 
				{
					foreach ($context as $contextEntry)
					{
						if (isset($contextEntry['==']) && preg_match('/^companionid:/', $contextEntry['=='])) {
						if ($aLinkedAd = _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia, true)) {
						return $aLinkedAd;
						}
						}
					}
				}
				$aLinkedAd = _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia);
				if (is_array($aLinkedAd))
				{
				return $aLinkedAd;
				}
			}
			return false;
		}
		function _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia, $companion = false)
		{
			$aCampaignTypes = array(
			'xAds' => false,  'ads' => array(10, 9, 8, 7, 6, 5, 4, 3, 2, 1),
			'lAds' => false,  'eAds' => array(-2),  );
			$GLOBALS['_MAX']['considered_ads'][] = &$aAds;
			foreach ($aCampaignTypes as $type => $aPriorities) {
			if ($aPriorities) {
			$ad_picked = false;
			foreach ($aPriorities as $pri) {
			if (!$ad_picked) {
			$aLinkedAd = OX_Delivery_Common_hook('adSelect',
			array(&$aAds, &$context, &$source, &$richMedia, $companion, $type, $pri), $adSelectFunction);
			if (is_array($aLinkedAd)) {
			$ad_picked = true;
			}
			if ($aLinkedAd == $GLOBALS['OX_adSelect_SkipOtherPriorityLevels']) {
			$ad_picked = true;
			}
			}
			else
			{
			if (!empty($aAds[$type][$pri])) {
			}
			}
			}
			if ($ad_picked && is_array ($aLinkedAd)) {
			return $aLinkedAd;
			}
			} else {
			$aLinkedAd = OX_Delivery_Common_hook('adSelect', array(&$aAds, &$context, &$source, &$richMedia, $companion, $type), $adSelectFunction);
			if (is_array($aLinkedAd)) {
			return $aLinkedAd;
			}
			}
			}
			return false;
		}
		function _adSelect(&$aLinkedAdInfos, $context, $source, $richMedia, $companion, $adArrayVar = 'ads', $cp = null)
		{				
			
			$aAds = array();
			$results=array();
             ///House ads concept implementation
			

			foreach($aLinkedAdInfos['campaignid'] as $key => $value)
			{

				$results[$key]=_adSelectCheckCriteria($value);
				if($results[$key]!=1)
				{
				$temp_camp[] = $key;
				}
		
			}
			foreach($aLinkedAdInfos['eAds'] as $key => $value)
			{
			
				if(in_array($value['placement_id'],$temp_camp))
				{
					unset($aLinkedAdInfos['eAds'][$key]);
					if(in_array($value['client_id'],array_keys($aLinkedAdInfos['bidding_val'])))
					{
						unset($aLinkedAdInfos['bidding_val'][$value['client_id']]);
					}
					
				}
		
			}
			$country_bidenable = array_values($aLinkedAdInfos['bidding_val']);
			
			foreach($aLinkedAdInfos['dj_is_default'] as $key => $value) {
			if (in_array($value['placement_id'], $temp_camp)) {
				unset($aLinkedAdInfos['dj_is_default'][$key]);				
			}
			}

			$djax_superads=$aLinkedAdInfos['dj_is_default'];	
			

			$djax_original_filtered_ads=$aLinkedAdInfos['eAds'];

	
	


			if(count($djax_original_filtered_ads)>0)
			{
				$is_house_ad=0;
				$aAds=$djax_original_filtered_ads;
			}
			else if(count($djax_superads)>0)
			{
				$is_house_ad=1;
				$aAds=$djax_superads;
				
			}
			
			else
			{
				$is_house_ad=0;
				$aAds = array();
			}

			
			if (count($aAds) == 0)
			{
			return;
			}


		////house ads concept implementation
			 
			global $n;
			mt_srand
			(floor
			((isset ($n) && strlen ($n) > 5
			? hexdec ($n[0].$n[2].$n[3].$n[4].$n[5])
			: 1000000) * (double) microtime ()));
			$conf = $GLOBALS['_MAX']['CONF'];
			$random_num =
			mt_rand (0, $GLOBALS['_MAX']['MAX_RAND'])
			/ $GLOBALS['_MAX']['MAX_RAND'];
		
				/* DAC020 -Start */
							
								if($is_house_ad!=1)
								{					
									if(count(array_filter($country_bidenable))==0)
									{		
										$aAds=djax_ecpmpriority($aAds,$results);	  	
									}
									else
									{ 	
											
										$aAds=_setPriorityFromcountry($aAds,$aLinkedAdInfos['bidding_val']);
																	
									}
								}
								else
								{
									foreach ($aAds as $key => $ad) 
									{
										$aAds[$key]['priority'] =1;													
									}
								}
									
		         /* DAC020 - End*/
		
		
				$total_priority=1;

			    	if (count($aAds) == 0)
				{ 
				return;
				}

			if ($random_num > $total_priority) 
			{
			return;
			}

			$low = 0;
			$high = 0;

			foreach($aAds as $aLinkedAd)
			{
				if (!empty($aLinkedAd['priority']))
				{
					$low = $high;
					$high += $aLinkedAd['priority'];

					if ($high > $random_num && $low <= $random_num)
					{
				/*==================================retargeting start==========================*/			
				
				$zoneid=$GLOBALS['zoneid'];   
					
						
				
			$_query = OA_Dal_Delivery_query("
				SELECT
					
			  
					distinct(d.campaignid) AS placement_id,behavior
					
				FROM
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['banners'])." AS d JOIN
				".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." AS az ON (d.bannerid = az.ad_id) JOIN
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." AS z ON (az.zone_id = z.zoneid) JOIN	
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['campaigns'])." AS c ON (c.campaignid = d.campaignid) 	LEFT JOIN
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['clients'])." AS m ON (m.clientid = c.clientid) LEFT JOIN
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['agency'])." AS a ON (a.agencyid = m.agencyid)
				WHERE
			
			
				 z.zoneid = '".$zoneid."'
				  AND
					d.status <= 0
				
				  AND
					c.status <= 0
			") or die(mysql_error());
			
			while($_rAdset = OA_Dal_Delivery_fetchAssoc($_query)) {
		$_resultSet[] = $_rAdset;
			}

		foreach($_resultSet as $value){
		$Camp_ids[$value['placement_id']] =array(
						"placement_id"=>$value['placement_id'],"behavior"=>$value['behavior']
						
						);


		}
		//Get cookie details based on campaignID
		$oacid = $GLOBALS['_MAX']['CONF']['var']['oacid'];
		foreach($Camp_ids as $value) {
			
						$retarg = $GLOBALS['_MAX']['CONF']['var']['djaxretarget'];	

						$cookie_ID = $_COOKIE[$retarg.'_'.$value['placement_id']];				
		//$cookie_ID = $_COOKIE[$oacid.'_'.$value['placement_id']];

		if(!empty($cookie_ID)) {
			
		$campaignID[]=explode('_',$cookie_ID);}
		}


foreach($campaignID as $key=>$value) {
	$_campIDs[$value[$key]] = $value[$key];
	
}




		$Camp_id = array_rand($_campIDs);



						//If campaignid exist in cookie deliver re-targeted campaign's banner

		  if(!empty($Camp_id)) {
		$behavior=$Camp_ids[$Camp_id]['behavior'];
		$zoneid=$GLOBALS['zoneid'];   
                                                                                                                                                                                                          
		$Selection_query = "
				SELECT
					distinct(d.bannerid) AS ad_id,
				c.compiledlimitation AS compiledlimitation,
					c.acl_plugins AS acl_plugins,		
					d.campaignid AS placement_id
					
				FROM
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['banners'])." AS d JOIN
				".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." AS az ON (d.bannerid = az.ad_id) JOIN
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." AS z ON (az.zone_id = z.zoneid) JOIN	
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['campaigns'])." AS c ON (c.campaignid = d.campaignid) 	LEFT JOIN
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['clients'])." AS m ON (m.clientid = c.clientid) LEFT JOIN
					".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['agency'])." AS a ON (a.agencyid = m.agencyid)
							";
						if($behavior==1)
						{	
						$Selection_query.=" WHERE c.campaignid=".$Camp_id."";
					    }
					    else
					    {
						 $Selection_query.=" WHERE c.campaignid!=".$Camp_id."";	
					    }	
						
						 $Selection_query.=" AND
							 z.zoneid = ".$zoneid."
							  AND
								d.status <= 0
							
							  AND
								c.status <= 0
						";



		$r_Ads = OA_Dal_Delivery_query($Selection_query)or die(mysql_error());

		if (!is_resource($r_Ads)) {
		return (defined('OA_DELIVERY_CACHE_FUNCTION_ERROR')) ? OA_DELIVERY_CACHE_FUNCTION_ERROR : null;
		}
		while($r_Adset = OA_Dal_Delivery_fetchAssoc($r_Ads)) {
		$retarget[] = $r_Adset;
			}
		;



		foreach($retarget as $retarget_value){
		$Ad__ids[$retarget_value['ad_id']] =array("ad_id"=>$retarget_value['ad_id'],
						"placement_id"=>$retarget_value['placement_id'],
						"compiledlimitation"=>$retarget_value['compiledlimitation'],
						"acl_plugins"=>$retarget_value['acl_plugins']);

		_adSelectCheckCriteria($Ad__ids, $aContext, $source, $richMedia);
		}




		//die("ssdfs");
		//Check for delivery limitations





		if (count($Ad__ids) == 0) {
		return;
		}
		else  {
			

			
			foreach($Ad__ids as $bannerId => $value) {
				
				
					$bannerIds[$bannerId] = $bannerId;$i++;

				
			  
				
			}


			if(!empty($bannerIds)) {
				
				$ad = MAX_cacheGetAd(array_rand($bannerIds));
			}

			else {
				
				$ad = MAX_cacheGetAd($aLinkedAd['ad_id']);
			}

		}

		}

		else 

		$ad = MAX_cacheGetAd($aLinkedAd['ad_id']);
						
				
	/*==================================retargeting end==========================*/
						$ad['tracker_status'] = (!empty($aLinkedAd['tracker_status'])) ? $aLinkedAd['tracker_status'] : null;
						if($ad['width'] == $ad['height'] && $ad['width'] == -1)
						{
						$ad['width'] = $aLinkedAd['width'];
						$ad['height'] = $aLinkedAd['height'];
						}

					//djax_track_ad_responses($aLinkedAd,$aLinkedAd['ad_id']);/*DAC015*/
                      
				/*	if($aLinkedAd['revenue_type']==2 && $aLinkedAd['retarget']==1 || $aLinkedAd['revenue_type']==3 && $aLinkedAd['retarget']==1)
					{
						
						$expire=time()+60*60*24*30;

						if(!isset($_COOKIE["retarget_".$aLinkedAd['ad_id']]))
						{
		
						setcookie("retarget_".$aLinkedAd['ad_id'], "retarget__".$aLinkedAd['ad_id']."__".$aLinkedAd['placement_id']."__".$aLinkedAdInfos['zone_id'],$expire);
							 
						}
						else
						{		
		
						}
					}*/
				    
					return $ad;
					}
				}
			}
			return;
		}
		function _controlTrafficEnabled (&$aAds)
		{
			$control_enabled = true;
			if (empty ($GLOBALS['_MAX']['CONF']['delivery']['enableControlOnPureCPM']))
			{
			$control_enabled = false;
			foreach ($aAds as $ad) {
			if ($ad['revenue_type'] != MAX_FINANCE_CPM)
			{
			$control_enabled = true;
			break;
			}
			}
			}
			return $control_enabled;
		}
		function _adSelectCheckCriteria($aAd, $aContext, $source, $richMedia)
		{				
		if ($aAd['dj_is_denied'] == 1) 
		{
		return false;
		}	
			
		$request_id=(isset($_SESSION['request_id']))?$_SESSION['request_id']:0;

			$conf = $GLOBALS['_MAX']['CONF'];
			if (!empty ($aAd['rotation_week']))
			{  
					$rotation_week	=	$aAd['rotation_week'];
					$r_week	= 	explode(",",$rotation_week);
					$t_week1	=	[];
					$t_week2	=	[];
					$t_week3	=	[];
					$t_week4	=	[];
					$now_d = date("d");
					if (in_array("1", $r_week))
					{
						$t_week1=array(1,2,3,4,5,6,7);
					}
					if (in_array("2", $r_week))
					{
						$t_week2=array(8,9,10,11,12,13,14);
					}
					if (in_array("3", $r_week))
					{
						$t_week3=array(15,16,17,18,19,20,21);
					}
					if (in_array("4", $r_week))
					{
						$t_week4=array(22,23,24,25,26,27,28,29,30,31);
					}
					$t_w_days	= array_merge($t_week1,$t_week2,$t_week3,$t_week4);
			
					if (!in_array($now_d, $t_w_days)) {
					OX_Delivery_logMessage('Campaign has expired for bannerid '.$aAd['ad_id'], 7);
					return false;
					}
					
			}
			if (!empty ($aAd['expire_time']))
			{  
				$expire = strtotime ($aAd['expire_time']);
				$now = MAX_commonGetTimeNow ();
				if ($expire > 0 && $now > $expire)
				{
			      
					OX_Delivery_logMessage('Campaign has expired for bannerid '.$aAd['ad_id'], 7);
					return false;
				}
			}
			if (MAX_limitationsIsAdForbidden($aAd))
			{
		     
				OX_Delivery_logMessage('MAX_limitationsIsAdForbidden = true for bannerid '.$aAd['placement_id'], 7);
		
				return false;
			}
			if ($conf['delivery']['acls'] && !MAX_limitationsCheckAcl($aAd, $source))
			{
		          
				OX_Delivery_logMessage('MAX_limitationsCheckAcl = false for bannerid '.$aAd['placement_id'], 7);
				return false;
			}
			
			
			$zoneid=$GLOBALS['zoneid'];   

	
		
			if($aAd['dj_is_default']==1)
			{
				$result=djax_check_category($zoneid,$aAd);
		       
				if($result!=1)
				{
		        
						return false;
			
				} 
			/*Fixed CPM  and minimum CPM for house Ad */
			
			$djax_data = MAX_cacheGetappInfo();   
			$zoneinfo = MAX_cacheGetZoneInfo($zoneid);
			$fixed_cpm=$zoneinfo['fixed_cpm'];
			
			if($fixed_cpm=='0.0000')
			{
				if ($djax_data['floor_price_enable'] == 'enable' && $zoneinfo['floor_price_enable'] == 1)
				{  
					$djax_floor_price = $zoneinfo['dj_floor_price'];
					$bid_response = $aAd['revenue'];
					
					if (!empty($djax_floor_price))
					{
						if ($bid_response >= $djax_floor_price)
						{  
							return true;
						}
						else
						{  	
							return false;   
						}	
					}		
				}
			}					
			}
			else
			{

				$result=djax_filter_ads($zoneid,$aAd,$request_id);			
		 
			$imp_result= djax_impression_count($zoneid,$aAd);
			if ($result != 1 || $imp_result=='error') {  
				return false;
			}

			}		


				if (!empty($aAd['ad_id']) && $aAd['retarget']=='1') 
				{

				$all_bids=array();

				$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
			
				$all_bids=array_keys($GLOBALS['_MAX']['considered_ads'][0]['lAds']);  


						if(!empty($_COOKIE))
						{
							   $lstclk = $GLOBALS['_MAX']['CONF']['var']['lstclk'];
							   $lstcon = $GLOBALS['_MAX']['CONF']['var']['lstcon'];                            

								if($aAd['revenue_type']==2)
								{
									if(!empty($_COOKIE[$lstclk."_".$aAd['ad_id']])){				
					                    
											if($_COOKIE[$lstclk."_".$aAd['ad_id']]==$aAd['ad_id']){
						                        
												unset($_COOKIE[$lstclk."_".$aAd['ad_id']]);
												
												setcookie($lstclk."_".$aAd['ad_id'],$aAd['ad_id'],time()-60*60*24*30);	
						
												return false;
											}else{
												
						
												unset($_COOKIE[$lstclk."_".$aAd['ad_id']]);
												setcookie($lstclk."_".$aAd['ad_id'],$aAd['ad_id'],time()-60*60*24*30);	
						
											}
									}
							}
		
								if($aAd['revenue_type']==3){
			
									if(!empty($_COOKIE[$lstcon."_".$aAd['ad_id']])){
					
											if($_COOKIE[$lstcon."_".$aAd['ad_id']]==$aAd['ad_id']){
						
												unset($_COOKIE[$lstcon."_".$aAd['ad_id']]);
												setcookie($lstcon."_".$aAd['ad_id'],$aAd['ad_id'],time()-60*60*24*30);	
						
												return false;
						
											}
											else{
						
												unset($_COOKIE[$lstcon."_".$aAd['ad_id']]);
												setcookie($lstcon."_".$aAd['ad_id'],$aAd['ad_id'],time()-60*60*24*30);	
						
											}
									}
								}
	
								$explode_cookie=implode(',',$_COOKIE);
		
	
								$exploded_array=explode(',',$explode_cookie);
		
								$i=1;
		

			
								foreach($exploded_array as $val){
			
									$retarget_val=explode('__',$val);
			
									if($retarget_val[0]=="retarget"){
				
										$array_cookie[$i]=$retarget_val[1];
				
										$campaign_cookie[$i]=$retarget_val[2];
				
										$zone_array[$i]=$retarget_val[3];
										$i++;
									}			
			
								}		
		
			
								if(!empty($array_cookie))
								{
										if(in_array($aAd['ad_id'],$array_cookie))
										{ //matching of retarget cookie with current AD.
													return true;
										}
										else
										{ //non matching of retarget cookie with current AD.
				
											if(in_array($aAd['placement_id'],$campaign_cookie))
											{ // match reatrgeting campagin.
												if(!in_array($aAd['placement_id'],$all_bids))
												{
													return true; // same camapign ad from other zone true;
												}
												else
												{
													return true; // same ad from other zone true;
												}
											}
											else
											{
												
												$zoneid=$GLOBALS['zoneid'];   
												if(in_array($zoneid,$zone_array))	
												{ //compare same zone or other zone 
													return false; // same zone false;
												}
												else
												{
													return true; // other zone true;
												}
											}					
							
				
										}	
								}
								else
								{
							
									 //empty of retarget cookie
									return true;
								}
				
					}
					else
					{
					
						 //empty of cookie
						return true;
					}

				}

			return true;
		}
		function _adSelectBuildContextArray(&$aLinkedAds, $adArrayVar, $context, $companion = false)
		{
			$aContext = array(
			'campaign' => array('exclude' => array(), 'include' => array()),
			'banner' => array('exclude' => array(), 'include' => array()),
			'client' => array('exclude' => array(), 'include' => array()),
			);
			if (is_array($context) && !empty($context)) {
			$cContext = count($context);
			for ($i=0; $i < $cContext; $i++) {
			reset($context[$i]);
			list ($key, $value) = each($context[$i]);
			$valueArray = explode(':', $value);
			if (count($valueArray) == 1) {
			list($value) = $valueArray;
			$type = "";
			} else {
			list($type, $value) = $valueArray;
			}
			if (empty($value)) {
			continue;
			}
			switch($type) {
			case 'campaignid':
			switch ($key) {
			case '!=': $aContext['campaign']['exclude'][$value] = true; break;
			case '==': $aContext['campaign']['include'][$value] = true; break;
			}
			break;
			case 'clientid':
			switch ($key) {
			case '!=': $aContext['client']['exclude'][$value] = true; break;
			case '==': $aContext['client']['include'][$value] = true; break;
			}
			break;
			case 'companionid':
			switch ($key) {
			case '!=':
			$aContext['campaign']['exclude'][$value] = true;
			break;
			case '==':
			if ($companion) {
			$aContext['campaign']['include'][$value] = true;
			}
			break;
			}
			break;
			default:
			switch ($key) {
			case '!=': $aContext['banner']['exclude'][$value] = true; break;
			case '==': $aContext['banner']['include'][$value] = true; break;
			}
			}
			}
			}
			return $aContext;
		}
		function _adSelectBuildContext($aBanner, $context = array())
		{
			if (!empty($aBanner['zone_companion']))
			{
				foreach ($aBanner['zone_companion'] AS $companionCampaign)
				{
					$value = 'companionid:'.$companionCampaign;
					if ($aBanner['placement_id'] == $companionCampaign)
					{
					$context[] = array('==' => $value);
					}
					else
					{
					$key = array_search(array('==', $value), $context);
					if ($key === false) {
					$context[] = array('!=' => $value);
					}
					}
				}
			}
			if (isset($aBanner['advertiser_limitation']) && $aBanner['advertiser_limitation'] == '1')
			{
			$context[] = array('!=' => 'clientid:' . $aBanner['client_id']);
			}
			return $context;
		}

		function MAX_flashGetFlashObjectExternal()
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			if (substr($conf['file']['flash'], 0, 4) == 'http')
			{
			$url = $conf['file']['flash'];
			}
			else
			{
			$url = MAX_commonGetDeliveryUrl($conf['file']['flash']);
			}
			return "<script type='text/javascript' src='{$url}'></script>";
		}
		function MAX_flashGetFlashObjectInline()
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			if (substr($conf['file']['flash'], 0, 4) == 'http')
			{
			if (file_exists(MAX_PATH . '/www/delivery/' . basename($conf['file']['flash'])))
			{
				return file_get_contents(MAX_PATH . '/www/delivery/' . basename($conf['file']['flash']));
			}
			else
			{
				return @file_get_contents($conf['file']['flash']);
			}
			}
			elseif (file_exists(MAX_PATH . '/www/delivery/' . $conf['file']['flash']))
			{
			return file_get_contents(MAX_PATH . '/www/delivery/' . $conf['file']['flash']);
			}
		}

		
		function MAX_javascriptEncodeJsonField($string)
		{
			$string = addcslashes($string, "\\/\"\n\r\t");
			$string = str_replace("\x08", "\\b", $string);
			$string = str_replace("\x0C", "\\f", $string);
			return '"'.$string.'"';
		}

		/*priya temp*/

		function MAX_Delivery_log_getArrGetVariable($name)
		{
		$varName = $GLOBALS['_MAX']['CONF']['var'][$name];
		return isset($_GET[$varName]) ? explode($GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'], $_GET[$varName]) : array();
		}

		/* temp*/

		MAX_commonSetNoCacheHeaders();
		MAX_commonRegisterGlobalsArray(array('block', 'blockcampaign', 'exclude', 'mmm_fo', 'q'));
		if (isset($context) && !is_array($context))
		{
		$context = MAX_commonUnpackContext($context);
		}
		if (!is_array($context))
		{
		$context = array();
		}
		if (isset($exclude) && $exclude != '' && $exclude != ',')
		{
		$exclude = explode(',', trim($exclude, ','));
		for ($i = 0; $i < count($exclude); $i++) {
		if ($exclude[$i] != '' && array_search(array ("!=" => $exclude[$i]), $context) === false) {
		$context[] = array ("!=" => $exclude[$i]);
		}
		}
		}
		MAX_cookieFlush();  
?>
