
function AdSlot(_name,_type,_time,_zone) {
	this.name = _name;
	this.type = _type;
	this.time = _time;
	this.zone = _zone;
	this.source = "";
	this.width = "";
	this.height = "";this.bitrate = "";
	this.seen = false;
	this.playOnce = true;	
	this.beaconurl="";
	this.start="";
	this.midpoint="";
	this.firstQuartile="";
	this.thirdQuartile="";
	this.complete="";
	this.mute="";
	this.pause="";
	this.replay="";
	this.fullscreen="";
	this.stop="";
	this.unmute="";
	this.resume="";
	this.duration="";
	this.createview="";
	this.click_url="";
	this.skip=true;
	this.skipduration="";
	this.skipurl="";
}
	
function convertTimeFormat(hhmmss) {
	var _time = hhmmss.substr(0,1)*3600+hhmmss.substr(3,2)*60+hhmmss.substr(6,2)*1;
	return _time
}

function removeWhitespace(xml)
{
		 var loopIndex;

		 for (loopIndex = 0; loopIndex < xml.childNodes.length; loopIndex++) 
		 {
			 var currentNode = xml.childNodes[loopIndex];
			
			 if (currentNode.nodeType == 1) 
				 {
				 	 removeWhitespace(currentNode);
				 }
			 
			 if (!(/\S/.test(currentNode.nodeValue)) && (currentNode.nodeType == 3)) 
				 {
				 	 xml.removeChild(xml.childNodes[loopIndex--]);
				 }
		 }
		
}

function constructAdList(responseObj)
{	

		var xmldoc = removeWhitespace(responseObj);

		var obj_vast ={};

		for (v in AdList) 
		{
			if (AdList[v].type.indexOf("roll") +1 ) 
			{
				var adElement = responseObj.getElementById(AdList[v].name);

				var adsystem=responseObj.getElementsByTagName("AdSystem")[0].childNodes[0].nodeValue;//AdTitle

				var title=responseObj.getElementsByTagName("AdTitle")[0].childNodes[0].nodeValue;

    					//Get impression tag
				var impression = responseObj.getElementsByTagName("Impression");
				if(impression != null){
					//obj_vast.impression_url = impression[0].childNodes[0].nodeValue;
					obj_vast.impression = impression;
					
				}

				//Get Creative
		var creative = responseObj.getElementsByTagName("Creative");				
		var media_files;
		
		var tracking_events;
		for(var i=0;i<creative.length;i++){
			var creative_linear = creative[i].getElementsByTagName("Linear");


			if(creative_linear != null){
				for(var j=0;j<creative_linear.length;j++){

					//Get media files
					var creative_linear_mediafiles = creative_linear[j].getElementsByTagName("MediaFiles");
					if(creative_linear_mediafiles!=null){
						for(var k=0;k<creative_linear_mediafiles.length;k++){
							var creative_linear_mediafiles_mediafile = creative_linear_mediafiles[k].getElementsByTagName("MediaFile");
							if(creative_linear_mediafiles_mediafile!=null){
								media_files = creative_linear_mediafiles_mediafile;
								
							}
						}
					}
					
						
					//Get Clickthrough URL
					var creative_linear_videoclicks = creative_linear[j].getElementsByTagName("VideoClicks");
					if(creative_linear_videoclicks!=null)
					{
						for(var k=0;k<creative_linear_videoclicks.length;k++)
						{ 
							var creative_linear_videoclicks_clickthrough = creative_linear_videoclicks[k].getElementsByTagName("ClickThrough")[0].childNodes[0].nodeValue;

							if(creative_linear_videoclicks_clickthrough!=null){
								obj_vast.clickthrough_url = creative_linear_videoclicks_clickthrough;
							}
							
						}
					}	
					
					//Get Skip Features

					if(creative_linear[j].getAttribute('skipoffset')!=null)
					{

						var skipoffset = creative_linear[j].getAttribute('skipoffset');
						
						var arrD1 = skipoffset.split(':');
						var skipSecs = (+arrD1[0]) * 60 * 60 + (+arrD1[1]) * 60 + (+arrD1[2]);
						obj_vast.skipduration=skipSecs;
						obj_vast.skip=1;
					}
					else
					{
						obj_vast.skip=0;
						obj_vast.skipduration=0;
					}
					
					//Get Tracking Events
					var creative_linear_trackingevents = creative_linear[j].getElementsByTagName("TrackingEvents");
					if(creative_linear_trackingevents!=null){
						for(var k=0;k<creative_linear_trackingevents.length;k++){ 

								var creative_linear_trackingevents_tracking = creative_linear_trackingevents[k].getElementsByTagName("Tracking");
								if(creative_linear_trackingevents_tracking!=null){
									tracking_events = creative_linear_trackingevents_tracking;
								}
						}
					}

						
					//Get AD Duration
					
					var creative_linear_duration =  creative_linear[j].getElementsByTagName("Duration")[0];
					if(creative_linear_duration!=null){
						obj_vast.duration = creative_linear_duration.childNodes[0].nodeValue;
						
						var arrD = obj_vast.duration.split(':');
						var strSecs = (+arrD[0]) * 60 * 60 + (+arrD[1]) * 60 + (+arrD[2]);
						obj_vast.duration = strSecs;
					}
					
				}
			}
		}

			/*Media Files*/

			for(var i=0;i<media_files.length;i++)
			{
				obj_vast.media_file=media_files[i].childNodes[0].nodeValue;
				obj_vast.media_width=media_files[i].getAttribute('width'); 
				obj_vast.media_height=media_files[i].getAttribute('height');
				obj_vast.media_bitrate=media_files[i].getAttribute('bitrate');
				obj_vast.media_type=media_files[i].getAttribute('type');
			}	
		
			//console.log(tracking_events);
			/*Tracking Events*///Tracking events
			for(var i=0;i<tracking_events.length;i++)
			{

				if(tracking_events[i].getAttribute('event')=="start"){
						if(obj_vast.tracking_start != null){
							obj_vast.tracking_start += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_start =tracking_events[i].childNodes[0].nodeValue;
						}						
						tracking_start_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="firstQuartile"){
						if(obj_vast.tracking_first_quartile != null){
							obj_vast.tracking_first_quartile += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_first_quartile =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_first_quartile_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="midpoint"){
						if(obj_vast.tracking_midpoint != null){
							obj_vast.tracking_midpoint += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_midpoint =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_midpoint_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="thirdQuartile"){
						if(obj_vast.tracking_third_quartile != null){
							obj_vast.tracking_third_quartile += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_third_quartile =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_third_quartile_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="complete"){
						if(obj_vast.tracking_complete != null){
							obj_vast.tracking_complete += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_complete =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_complete_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="mute"){
						if(obj_vast.tracking_mute != null){
							obj_vast.tracking_mute += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_mute =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_mute_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="unmute"){
						if(obj_vast.tracking_unmute != null){
							obj_vast.tracking_unmute += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_unmute =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_unmute_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="pause"){
						if(obj_vast.tracking_pause != null){
							obj_vast.tracking_pause += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_pause =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_pause_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="resume"){
						if(obj_vast.tracking_resume != null){
							obj_vast.tracking_resume += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_resume =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_resume_tracked=false;
				}
				if(tracking_events[i].getAttribute('event')=="fullscreen"){
						if(obj_vast.tracking_fullscreen != null){
							obj_vast.tracking_fullscreen += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_fullscreen =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_fullscreen_tracked=false;
				}//creativeView
				if(tracking_events[i].getAttribute('event')=="creativeView"){
						if(obj_vast.tracking_createview != null){
							obj_vast.tracking_createview += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_createview =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_createview_tracked=false;
				}
				//acceptInvitation
				if(tracking_events[i].getAttribute('event')=="acceptInvitation"){
						if(obj_vast.tracking_acceptInvitation != null){
							obj_vast.tracking_acceptInvitation += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_acceptInvitation =tracking_events[i].childNodes[0].nodeValue;
						}
						obj_vast.tracking_acceptInvitation_tracked=false;
				}
					//Skip clicked
				if(tracking_events[i].getAttribute('event')=="skip"){ 
						if(obj_vast.tracking_skip != null){
							obj_vast.tracking_skip += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_skip =tracking_events[i].childNodes[0].nodeValue;
						}
						
				}
				//Skip shown
				if(tracking_events[i].getAttribute('event')=="skip_show"){
						if(obj_vast.tracking_skip_show != null){
							obj_vast.tracking_skipshow += " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_skipshow =tracking_events[i].childNodes[0].nodeValue;
						}
						
				}
				//Current viewer time
				
				if(tracking_events[i].getAttribute('event')=="viewtime"){
						if(obj_vast.tracking_viewtime != null){
							obj_vast.tracking_viewtime+= " "+tracking_events[i].childNodes[0].nodeValue;
						}else{
							obj_vast.tracking_viewtime=tracking_events[i].childNodes[0].nodeValue;
						}
						
				}
				}
			
				AdList[v].source =obj_vast.media_file;
				AdList[v].width =obj_vast.media_width;
				AdList[v].height =obj_vast.media_height;
				AdList[v].bitrate =obj_vast.media_bitrate;
				AdList[v].beaconurl=obj_vast.impression;
				AdList[v].click_url=obj_vast.clickthrough_url;
				AdList[v].duration =obj_vast.duration;	
				AdList[v].start=obj_vast.tracking_start;
				AdList[v].midpoint=obj_vast.tracking_midpoint;
				AdList[v].firstQuartile=obj_vast.tracking_first_quartile;
				AdList[v].thirdQuartile=obj_vast.tracking_third_quartile
				AdList[v].complete=obj_vast.tracking_complete;
				AdList[v].mute=obj_vast.tracking_mute;
				AdList[v].unmute=obj_vast.tracking_unmute;
				AdList[v].pause=obj_vast.tracking_pause;
				//AdList[v].stop=obj_vast.stop;
				AdList[v].fullscreen=obj_vast.tracking_fullscreen;
				AdList[v].replay=obj_vast.tracking_resume;
				AdList[v].createview=obj_vast.tracking_createview;
				AdList[v].skip=obj_vast.skip;
				AdList[v].skipduration=Math.round(obj_vast.skipduration);
				AdList[v].skipurl=obj_vast.tracking_skip;
				skipurl=obj_vast.tracking_skip;
				skipshowurl=obj_vast.tracking_skipshow;
				viewtime=obj_vast.tracking_viewtime;
				document.getElementById('djaxvastvideo').muted=false;
				obj_vast.firsttime=Math.round(25*obj_vast.duration/100);
				obj_vast.midtime=Math.round(50*obj_vast.duration/100);
				obj_vast.thirdtime=Math.round(75*obj_vast.duration/100);
				console.log(obj_vast);
			
			}
		}
		startTime = new Date();//time
		h5vPreRoll(videoTag.id,obj_vast);
}	
	 


	//Preroll 
	function h5vPreRoll(video_player_id, obj_vast)
	{

			var video_player = document.getElementById(video_player_id);

				//Change source to PreRoll
				video_player.src = obj_vast.media_file;
				video_player.bitrate =obj_vast.media_bitrate;
				video_player.type =obj_vast.media_type;
				
				
				//video_player.autoplay = true;
				video_player.load();
				
				//On content load
				var video_player_loaded = function(event){

				//	h5vAddClickthrough(video_player_id,obj_vast.clickthrough_url);

					video_player.play();							
					
					//Fire impression(s)
					if(obj_vast.impression!=null){
					
					
						for(var k=0;k<obj_vast.impression.length;k++){ 

							h5vAddPixel(obj_vast.impression[k].childNodes[0].nodeValue); 

							if (obj_vast.impression[k].childNodes[1] && typeof obj_vast.impression[k].childNodes[1].nodeValue !== 'undefined') {
							h5vAddPixel(obj_vast.impression[k].childNodes[1].nodeValue);
							}

						}
						var view = new Image(1,1); 
						view.src =obj_vast.tracking_createview;
					}
					if(obj_vast.skip==1)
					{ 
						
					var img_track = new Image();
					img_track.src=obj_vast.tracking_skipshow;
					}
					video_player.removeEventListener('loadedmetadata',video_player_loaded);

					
				}
				
				//On PreRoll End
				var video_player_ended = function(event){
					/*video_player.src = prev_src;
					video_player.load();
					video_player.play();*/
					h5vRemoveClickthrough(video_player_id);
					if(obj_vast.skip==1)
					{
					h5vRemoveCaption(video_player_id);
					}
					/*Time*/
							var endTime = new Date();        //Get the current time.
							var timeSpent=(endTime - startTime);        //Find out how long it's been.
						       //Pop up a window with the time spent in microseconds.alert('test');
							var viewertime=new Image();
							viewertime.src=obj_vast.tracking_viewtime+'&timespent='+timeSpent;
							/*Time*/
						
					//video_player.setAttribute("controls","controls"); //Add Controls back in
					video_player.removeEventListener('ended',video_player_ended);
					
				}
				
				video_player.addEventListener('loadedmetadata', video_player_loaded);
				video_player.addEventListener('ended', video_player_ended);						
				

		
		var video_player_timeupdate  = function(event){

 			if(Math.round(video_player.currentTime)==0 && !video_player.pixelcall_start)
			{
				video_player.pixelcall_start=true;
					if(obj_vast.tracking_start != null)
					{
						var arrTrack = obj_vast.tracking_start.split(" ");
						for(var i=0;i<arrTrack.length;i++)
						{
							var img_track = new Image();
							img_track.src=arrTrack[i];
						}
					}
				//Call here your pixel function
				//console.log('start');
			}
			
			
			if(Math.round(video_player.currentTime)==obj_vast.firsttime && !video_player.pixelcall_quarter)
			{
				//console.log('1=>'+Math.round(video_player.currentTime)+'=='+obj_vast.firsttime);
				video_player.pixelcall_quarter=true;
						if(obj_vast.tracking_first_quartile != null){
						var arrTrack = obj_vast.tracking_first_quartile.split(" ");
						for(var i=0;i<arrTrack.length;i++){
							var img_track = new Image();
							img_track.src=arrTrack[i];
						}
					}

				
				//Call here your pixel function
				//console.log('first');
			}
			//console.log(obj_vast.midtime);
			//console.log('2=>'+Math.round(video_player.currentTime)+'=='+obj_vast.midtime);
			if(Math.round(video_player.currentTime)==obj_vast.midtime && !video_player.pixelcall_half)
			{
				//console.log('2=>'+Math.round(video_player.currentTime)+'=='+obj_vast.midtime);
				video_player.pixelcall_half=true;
					if(obj_vast.tracking_midpoint != null){
						var arrTrack = obj_vast.tracking_midpoint.split(" ");
						for(var i=0;i<arrTrack.length;i++){
							var img_track = new Image();
							img_track.src=arrTrack[i];
						}
					}

				
				//Call here your pixel function
				//console.log('second quartile');
			}
			
			if(Math.round(video_player.currentTime)==obj_vast.thirdtime && !video_player.pixelcall_third)
			{
				video_player.pixelcall_third=true;
				if(obj_vast.tracking_third_quartile != null){
						var arrTrack = obj_vast.tracking_third_quartile.split(" ");
						for(var i=0;i<arrTrack.length;i++){
							var img_track = new Image();
							img_track.src=arrTrack[i];
						}
					}

				
				//Call here your pixel function
				//console.log('third quartile');
			}
			
			if(Math.round(video_player.currentTime)==(obj_vast.duration-1) && !video_player.pixelcall_over)
			{
				
					video_player.pixelcall_over=true;
				//Call here your pixel function
				//console.log('completed quartile');
					if(obj_vast.tracking_complete != null){
						var arrTrack = obj_vast.tracking_complete.split(" ");
						for(var i=0;i<arrTrack.length;i++){
							var img_track = new Image();
							img_track.src=arrTrack[i];
						}
					}
		
			}

			if(obj_vast.skip==1)
			{
				
				if(obj_vast.skipduration==Math.round(video_player.currentTime))
				{ 

						h5vAddCaption(video_player_id,'Skip');

						jQuery(document).on('click','#h5vcaption_djaxvastvideo', function(e)
						{
						video_player.pixelcall_over=true;

						var img_track = new Image();
						img_track.src = obj_vast.tracking_skip;
						h5vRemoveCaption(video_player_id);
						var vid = document.getElementById(video_player_id);
						vid.muted = true;
							/*Time*/
							var endTime = new Date();        //Get the current time.
							var timeSpent=(endTime - startTime);        //Find out how long it's been.
						       //Pop up a window with the time spent in microseconds.alert('test');
							var viewertime=new Image();
							viewertime.src=obj_vast.tracking_viewtime+'&timespent='+timeSpent;
							/*Time*/
						
						});
						
						
						
						//~ document.getElementById('html5_video-container')[0].style.display='none';
						//~ document.getElementById('html5_close_default')[0].style.display='none';
						
						return false;
				}
			}

		}
		video_player.addEventListener('timeupdate', video_player_timeupdate);
	}


	 // Loading ads data from defined server
AdsRequest = function (AdObj)
{

	var video_player = document.getElementById('djaxvastvideo');
		

	var http_request = new XMLHttpRequest();
	var script = "bannerTypeHtml:vastOutstreamBannerTypeHtml:vastOutstreamHtml";
		
	//constructing list for further populating and sorting
		
	var i1 = 0;
	var i2 = 0;
	var i3 = 0;
	var i4 = 0;
	var zones = "";
	var value="";
	for (v in AdObj.schedule) 
	{
		
		switch (AdObj.schedule[v].position) {
			case "pre-roll":
				var a = new AdSlot("pre-roll-"+i1,"pre-roll",0,AdObj.schedule[v].zone);
				i1++;
				AdList.push(a);
				break
			case "mid-roll":
				var a = new AdSlot("mid-roll-"+i2,"mid-roll",convertTimeFormat(AdObj.schedule[v].startTime),AdObj.schedule[v].zone);
				i2++;
				AdList.push(a);
				break
			case "post-roll":
				var a = new AdSlot("post-roll-"+i3,"post-roll",0,AdObj.schedule[v].zone);
				i3++;
				AdList.push(a);
				break
			case "auto:bottom":
				var a = new AdSlot("auto:bottom-"+i4,"auto:bottom",convertTimeFormat(AdObj.schedule[v].startTime),AdObj.schedule[v].zone);
				i4++;
				AdList.push(a);
				break
			default:
				break
		} 

	value=AdObj.schedule[v].value;
	}
		
	for (v in AdList) {

		zones += AdList[v].name +"=" +AdList[v].zone + "|";
	}
	zones = zones.substr(0,zones.length - 1);

	video_player.pause();
	
	var nz = "1";
	var format = "vast";
	//var format = "vast";
	var charset = "UTF-8";
	var params = "script="+script+"&zones="+encodeURIComponent(zones)+"&nz="+nz+"&format="+format+"&charset="+charset+"&value="+value;
	
	http_request.open( "GET",AdObj.servers[0]["apiAddress"]+"?"+params, true );
	http_request.send(null);
	http_request.onreadystatechange = function () {
		if ( http_request.readyState == 4 ) {
			if ( http_request.status == 200 ) {
				var xml = http_request.responseXML;
				
				constructAdList(xml);
			}
			http_request = null;
		}
	}
};
	 
		 //Parsing parameters from video tag
	parseAdsParameters = function (input) {
		var AdObj = !(/[^,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t]/.test(input.replace(/"(\\.|[^"\\])*"/g, ''))) &&eval('(' + input + ')');
		return AdObj;
	}	 
		video_player_timeupdate =	function enforcePrecision(n, nDecimalDigits){
		return +(n).toFixed(nDecimalDigits);
	}


	function initAdsFor(videoID) 
	{
		window.tempTime = 0;
		window.counterOfStreams = 0;
	    	window.videoTag = document.getElementById(videoID);
		videoTag.mainTrack = videoTag.src;
		window.AdList = new Array;
		
		//Create Wrapper Div-priya
		var wrapper_div = document.createElement('div');
		wrapper_div.className = 'h5vwrapper';
		wrapper_div.id = 'h5vwrapper_'+videoID;
		//wrapper_div.style.height = videoTag.height;
		//wrapper_div.style.width = videoTag.width;
		videoTag.parentNode.insertBefore(wrapper_div,videoTag);
		wrapper_div.appendChild(videoTag);	
		var close_div = document.createElement('div');
		close_div.className = 'close html5_close_default';
		close_div.id = 'html_btn_cls';
		//close_div.innerHTML = 'X';
		wrapper_div.appendChild(close_div);
		window.AdObj = parseAdsParameters(videoTag.getAttribute('ads'));
		window.AdsRequest(AdObj);
	}
	
		 
  	//Add pixel for firing impressions, tracking etc
	function h5vAddPixel(pixel_url)
	{
		var image = new Image(1,1); 
		image.src = pixel_url;
	}
 


	//Add Caption
	function h5vAddCaption(video_player_id, caption_text)
	{ 
		//console.log(video_player_id);
		var video_player = document.getElementById(video_player_id);
		var wrapper_div = document.getElementById('h5vwrapper_'+video_player_id);
		
		//Create Caption div
		var caption_div = document.createElement('div');
		caption_div.className = 'vast-skip-button enabled';
		caption_div.id='h5vcaption_'+video_player_id;
		caption_div.innerHTML=caption_text;
		
		wrapper_div.appendChild(caption_div);		
	

	}
		
	
	//Remove Caption

	function h5vRemoveCaption(video_player_id)
	{
	document.getElementsByClassName("html5_video-container")[0].style.display = "none";
	
	}
	
	//Add Clickthrough

	function h5vAddClickthrough(video_player_id,clickurl)
	{
		var video_player = document.getElementById(video_player_id); 
		var wrapper_div = document.getElementById('h5vwrapper_'+video_player_id);
		//Create Clickthrough div
		var clickt_div = document.createElement('div');
		clickt_div.className = 'h5vclickt';
		clickt_div.id='h5vclickt_'+video_player_id;
		clickt_div.style.position='absolute';
		clickt_div.style.height='812px';
		clickt_div.style.width='100%';
		clickt_div.style.left='0';
		clickt_div.style.top='0';
		clickt_div.style.cursor='pointer';
		
		//~ clickt_div.style.cursor = 'pointer';
		//~ clickt_div.style.left=0;
		//~ clickt_div.style.top=0;
		//~ clickt_div.style.width=video_player.width+'px';
		//~ clickt_div.style.height=video_player.height+'px';
		//clickt_div.innerHTML="<a href='' style='width:100%;height:100%;'></a>";
		wrapper_div.appendChild(clickt_div);
		//Bind Onclick
		var clickt_obj = document.getElementById('h5vclickt_'+video_player_id);
		clickt_obj.onclick = function(){window.open(clickurl)};	
		
		
	}
	
	//Remove Clickthrough
	function h5vRemoveClickthrough(video_player_id)
	{
		
	//return (elem=document.getElementById('h5vwrapper_djaxvastvideo')).parentNode.removeChild(elem);
	document.getElementsByClassName("html5_video-container")[0].style.display = "none";
	

		
	}
	

