<?php
// Require the initialisation file
$path = dirname(__FILE__);
require_once $path . '/../../init.php';
date_default_timezone_set('Europe/Amsterdam');
function OX_Delivery_logMessage($message, $priority = 6) 
{
    $conf = $GLOBALS['_MAX']['CONF'];
    if (empty($conf['deliveryLog']['enabled'])) return true;
    $priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
	if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) {
        return true;
    }
    error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
    OX_Delivery_Common_hook('logMessage', array(
        $message,
        $priority
    ));
    return true;
}

function OX_Delivery_Common_hook($hookName, $aParams = array(), $functionName = '')
{
    $return = null;
	if (!empty($functionName)) {
        $aParts = explode(':', $functionName);
		if (count($aParts) === 3) {
            $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
        }
		if (function_exists($functionName)) {
            $return = call_user_func_array($functionName, $aParams);
        }
	} else {
		if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) {
            $return = array();
            $hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
			foreach ($hooks as $identifier) {
                $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
				if (function_exists($functionName)) {
                    OX_Delivery_logMessage('calling on ' . $functionName, 7);
                    $return[$identifier] = call_user_func_array($functionName, $aParams);
                }
            }
        }
    }
    return $return;
}

function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null)
{
    $aInfo = explode(':', $identifier);
    $functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
	if (!function_exists($functionName)) {
        if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
		if (!function_exists($functionName)) {
            _includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
			if (!function_exists($functionName)) {
                _includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
                $functionName = 'Plugin_' . $aInfo[0] . '_delivery';
				if (!empty($hook) && function_exists($functionName . '_' . $hook)) {
					$functionName .= '_' . $hook;
                }
            }
        }
    }
    return $functionName;
}

function _includeDeliveryPluginFile($fileName)
{
	if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) {
        $GLOBALS['_MAX']['FILES'][$fileName] = true;
		if (file_exists(MAX_PATH . $fileName)) {
            include MAX_PATH . $fileName;
        }
    }
}

function MAX_Dal_Delivery_Include()
{
    static $included;
	if (isset($included)) {
        return;
    }
    $included = true;
    $conf = $GLOBALS['_MAX']['CONF'];
	if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
	} else {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
	}
}
MAX_Dal_Delivery_Include();
if (!empty($conf['debug']['production'])) {
	error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
} else {
	error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
}
//Setting up for unlimited time.
set_time_limit(0);

$current_date = date("Y-m-d");   

/*************************Traffic source Hourly bid rate update-START*****************************************************************************************/

$query = "select campaign_id,traffic_id,status,bid_rate,account_id,source_type from djax_campaign_traffic_source";

$camp_query = OA_Dal_Delivery_query($query);

if(OA_Dal_Delivery_numRows($camp_query)>0)
{
	while ($djax_cams = OA_Dal_Delivery_fetchAssoc($camp_query)) 
	{
		$campaign_data[] = $djax_cams;
	}	
}
//print_r($campaign_data); die();

	
foreach($campaign_data as $cam_data)
{
	$campaign_id = $cam_data['campaign_id'];
	$traffic_id  = $cam_data['traffic_id'];
	$accout_id   = $cam_data['account_id'];
	$bid_rate    = $cam_data['bid_rate'];
	$source_type =  $cam_data['source_type'];
	
	$bid_query = "select 
					IFNULL(ROUND(AVG(h.impressions),2),0) as imp_bid_rate,
					IFNULL(ROUND(AVG(h.clicks),2),0) as clk_bid_rate,
					IFNULL(ROUND(AVG(h.conversions),2),0) as conv_bid_rate
				  from rv_data_summary_ad_hourly as h 
					JOIN rv_campaigns as c 
					JOIN rv_banners as b ON b.bannerid=h.ad_id AND b.campaignid=c.campaignid
					JOIN rv_zones as z ON z.zoneid=h.zone_id
					JOIN rv_affiliates as a ON a.affiliateid=z.affiliateid AND a.account_id=".$traffic_id."
				  where 1 AND date_time >= DATE_FORMAT(NOW()- INTERVAL 1 HOUR,'%Y-%m-%d %H:00:00')";
	if($source_type!=0)
	{
		$bid_query .= " AND c.revenue_type=".$source_type;
	}
	//print_r($bid_query);
	$hour_query = OA_Dal_Delivery_query($bid_query);
	if(OA_Dal_Delivery_numRows($hour_query)>0)
	{
		while ($hour_bid = OA_Dal_Delivery_fetchAssoc($hour_query)) 
		{
			if($source_type!=0 && $source_type==1)
			{
				$bid_rate = $hour_bid['imp_bid_rate'];
			}
			else if($source_type==2)
			{
				$bid_rate = $hour_bid['clk_bid_rate'];
			}
			else if($source_type==3)
			{
				$bid_rate = $hour_bid['conv_bid_rate'];
			}
			else
			{
				$bid_rate = $hour_bid['imp_bid_rate'];
			}
			if($bid_rate!=0)
			{
				$update_query = "update djax_campaign_traffic_source set bid_rate='".$bid_rate."' where traffic_id=".$traffic_id;
				OA_Dal_Delivery_query($update_query);
			}
		}
	}
}   

/*************************Traffic source Hourly bid rate update-END*****************************************************************************************/

/*************************Country Bidding Hourly bid rate update-START*****************************************************************************************/

$country_query = "select campaign_id,country_value,status,bidding_value,account_id,revenue_type from djax_country_bidding";

$count_query = OA_Dal_Delivery_query($country_query);

if(OA_Dal_Delivery_numRows($count_query)>0)
{
	while ($djax_country = OA_Dal_Delivery_fetchAssoc($count_query)) 
	{
		$country_data[] = $djax_country;
	}	
}
//print_r($campaign_data); die();

	
foreach($country_data as $con_data)
{
	$c_campaign_id = $con_data['campaign_id'];
	$country_value  = $con_data['country_value'];
	$c_accout_id   = $con_data['account_id'];
	$bidding_value    = $con_data['bidding_value'];
	$revenue_type =  $con_data['revenue_type'];
	
	$cbid_query = "select 
					IFNULL(ROUND(AVG(h.impressions),2),0) as imp_bid_rate,
					IFNULL(ROUND(AVG(h.clicks),2),0) as clk_bid_rate,
					IFNULL(ROUND(AVG(h.conversions),2),0) as conv_bid_rate
				  from rv_data_summary_ad_hourly as h 
					JOIN rv_campaigns as c 
					JOIN rv_banners as b ON b.bannerid=h.ad_id AND b.campaignid=c.campaignid
				  where 1 AND h.country_code='".$country_value."' AND date_time >= DATE_FORMAT(NOW()- INTERVAL 1 HOUR,'%Y-%m-%d %H:00:00')";
	if($revenue_type!=0)
	{
		$cbid_query .= " AND c.revenue_type=".$revenue_type;
	}
	
	//print_r($cbid_query );
	$chour_query = OA_Dal_Delivery_query($cbid_query);
	if(OA_Dal_Delivery_numRows($chour_query)>0)
	{
		while ($chour_bid = OA_Dal_Delivery_fetchAssoc($chour_query)) 
		{
			if($revenue_type!=0 && $revenue_type==1)
			{
				$cbid_rate = $chour_bid['imp_bid_rate'];
			}
			else if($revenue_type==2)
			{
				$cbid_rate = $chour_bid['clk_bid_rate'];
			}
			else if($revenue_type==3)
			{
				$cbid_rate = $chour_bid['conv_bid_rate'];
			}
			else
			{
				$cbid_rate = $chour_bid['imp_bid_rate'];
			}
			if($cbid_rate!=0)
			{
				$update_query = "update djax_country_bidding set bidding_value='".$cbid_rate."' where country_value='".$country_value."' ";
				OA_Dal_Delivery_query($update_query);
			}
		}
	}
}   

/*************************Country bidding Hourly bid rate update-END*****************************************************************************************/

/*************************Zone Bidding Hourly bid rate update-START*****************************************************************************************/

$zone_query = "select campaign_id,zone_id,status,bid_rate,account_id,campaign_type from djax_campaign_zone_bidding";

$z_query = OA_Dal_Delivery_query($zone_query);

if(OA_Dal_Delivery_numRows($z_query)>0)
{
	while ($djax_zone = OA_Dal_Delivery_fetchAssoc($z_query)) 
	{
		$zone_data[] = $djax_zone;
	}	
}
//print_r($zone_data); die();

	
foreach($zone_data as $z_data)
{
	$z_campaign_id = $z_data['campaign_id'];
	$zone_id  = $z_data['zone_id'];
	$z_accout_id   = $z_data['account_id'];
	$z_bid_rate    = $z_data['bid_rate'];
	$campaign_type =  $z_data['campaign_type'];
	
	$zbid_query = "select 
					IFNULL(ROUND(AVG(h.impressions),2),0) as imp_bid_rate,
					IFNULL(ROUND(AVG(h.clicks),2),0) as clk_bid_rate,
					IFNULL(ROUND(AVG(h.conversions),2),0) as conv_bid_rate
				  from rv_data_summary_ad_hourly as h 
					JOIN rv_campaigns as c 
					JOIN rv_banners as b ON b.bannerid=h.ad_id AND b.campaignid=c.campaignid
					JOIN rv_zones as z ON z.zoneid=h.zone_id
				  where 1 AND h.zone_id='".$zone_id."' AND date_time >= DATE_FORMAT(NOW()- INTERVAL 1 HOUR,'%Y-%m-%d %H:00:00') ";
		
	$zhour_query = OA_Dal_Delivery_query($zbid_query);
	
	if(OA_Dal_Delivery_numRows($zhour_query)>0)
	{
		while ($zhour_bid = OA_Dal_Delivery_fetchAssoc($zhour_query)) 
		{
			
			$zbid_rate = $zhour_bid['imp_bid_rate'];
			
			if($zbid_rate!=0)
			{
				$update_query = "update djax_campaign_zone_bidding set bid_rate='".$zbid_rate."' where zone_id='".$zone_id."' ";
				OA_Dal_Delivery_query($update_query);
			}
		}
	}
}   

/*************************Zone bidding Hourly bid rate update-END*****************************************************************************************/
echo "Cron file runned successfully";
?>
