<?php
// Require the initialisation file
$path = dirname(__FILE__);
require_once $path . '/../../init.php';
date_default_timezone_set('Europe/Amsterdam');
function OX_Delivery_logMessage($message, $priority = 6) 
{
    $conf = $GLOBALS['_MAX']['CONF'];
    if (empty($conf['deliveryLog']['enabled'])) return true;
    $priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
	if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) {
        return true;
    }
    error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
    OX_Delivery_Common_hook('logMessage', array(
        $message,
        $priority
    ));
    return true;
}

function OX_Delivery_Common_hook($hookName, $aParams = array(), $functionName = '')
{
    $return = null;
	if (!empty($functionName)) {
        $aParts = explode(':', $functionName);
		if (count($aParts) === 3) {
            $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
        }
		if (function_exists($functionName)) {
            $return = call_user_func_array($functionName, $aParams);
        }
	} else {
		if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) {
            $return = array();
            $hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
			foreach ($hooks as $identifier) {
                $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
				if (function_exists($functionName)) {
                    OX_Delivery_logMessage('calling on ' . $functionName, 7);
                    $return[$identifier] = call_user_func_array($functionName, $aParams);
                }
            }
        }
    }
    return $return;
}

function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null)
{
    $aInfo = explode(':', $identifier);
    $functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
	if (!function_exists($functionName)) {
        if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
		if (!function_exists($functionName)) {
            _includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
			if (!function_exists($functionName)) {
                _includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
                $functionName = 'Plugin_' . $aInfo[0] . '_delivery';
				if (!empty($hook) && function_exists($functionName . '_' . $hook)) {
					$functionName .= '_' . $hook;
                }
            }
        }
    }
    return $functionName;
}

function _includeDeliveryPluginFile($fileName)
{
	if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) {
        $GLOBALS['_MAX']['FILES'][$fileName] = true;
		if (file_exists(MAX_PATH . $fileName)) {
            include MAX_PATH . $fileName;
        }
    }
}

function MAX_Dal_Delivery_Include()
{
    static $included;
	if (isset($included)) {
        return;
    }
    $included = true;
    $conf = $GLOBALS['_MAX']['CONF'];
	if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
	} else {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
	}
}
MAX_Dal_Delivery_Include();
if (!empty($conf['debug']['production'])) {
	error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
} else {
	error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
}
//Setting up for unlimited time.
set_time_limit(0);

$current_date = date("Y-m-d");   

$campaigns = OA_Dal_Delivery_query("select campaignid,even_distribute_end_date,even_distribute_impressions,dj_campaign_budget,dj_daily_budget,daily_budget_unlimit,updated,date(activate_time) as start_date,date(expire_time) as end_date,revenue,revenue_type,dj_weekly_distribute from rv_campaigns where evenly_distribution='1'");

if(OA_Dal_Delivery_numRows($campaigns)>0)
{
	while ($djax_cams = OA_Dal_Delivery_fetchAssoc($campaigns)) 
	{
		$campaign_data[] = $djax_cams;
	}	
}
$evenly_distribute = OA_Dal_Delivery_query("select campaign_id from rv_djax_evenly_distribution group by campaign_id");
$exist_campaign_data='';

if(OA_Dal_Delivery_numRows($evenly_distribute)>0)
{
	while ($even_cams = OA_Dal_Delivery_fetchAssoc($evenly_distribute)) 
	{		
		$exist_campaign_data[] = $even_cams['campaign_id'];
	}	
}
	
foreach($campaign_data as $cam_data)
{	
	$daily_budget=$cam_data['dj_daily_budget'];
	$daily_budget_unlimit=$cam_data['daily_budget_unlimit'];
	$bid_rate=$cam_data['revenue'];
	$even_distribute_end_date=$cam_data['even_distribute_end_date'];
	$even_distribute_impressions=$cam_data['even_distribute_impressions'];
	$expire_time=$cam_data['end_date'];
	$start_date=$cam_data['start_date'];
	$campaign_id=$cam_data['campaignid']; 
	$campaign_budget=$cam_data['dj_campaign_budget'];
	$weekly_distribute=$cam_data['dj_weekly_distribute'];
	
	$start_time_val=array("00:00:00","01:00:00","02:00:00","03:00:00","04:00:00","05:00:00","06:00:00","07:00:00","08:00:00","09:00:00","10:00:00","11:00:00","12:00:00","13:00:00","14:00:00","15:00:00","16:00:00","17:00:00","18:00:00","19:00:00","20:00:00","21:00:00","22:00:00","23:00:00");
	$end_time_val=array("00:59:59","01:59:59","02:59:59","03:59:59","04:59:59","05:59:59","06:59:59","07:59:59","08:59:59","09:59:59","10:59:59","11:59:59","12:59:59","13:59:59","14:59:59","15:59:59","16:59:59","17:59:59","18:59:59","19:59:59","20:59:59","21:59:59","22:59:59","23:59:59");
	
	
	if($weekly_distribute=='')
	{	
		if($daily_budget_unlimit!='1')
		{  
			$estimated_imp=$daily_budget/$bid_rate;
			//$budget=$campaign_budget/$daily_budget;		
			$final_imp_per_hour=$estimated_imp/24;		
		}
		else if($even_distribute_end_date!='0000-00-00' || $expire_time!=NULL )
		{		
			$end_date_query=OA_Dal_Delivery_query("select sum(impressions) as imp from rv_data_summary_ad_hourly as h JOIN rv_campaigns as c JOIN rv_banners as b ON b.bannerid=h.ad_id AND b.campaignid=c.campaignid where b.campaignid=".$campaign_id);
			if(OA_Dal_Delivery_numRows($end_date_query)>0)
			{
				$impressions=OA_Dal_Delivery_fetchAssoc($end_date_query);
				$sum_imp=$impressions['imp'];
			}
			$estimated_imp=$campaign_budget/$bid_rate;
			$remaining_imp=$estimated_imp-$sum_imp;				
			$datetime1 = date_create($current_date);
			if($even_distribute_end_date!='0000-00-00')
			{
			  $datetime2 = date_create($even_distribute_end_date);
			}
			else
			{
			  $datetime2 = date_create($expire_time);
			}
			$interval = date_diff($datetime1, $datetime2);  
			$diff=($interval->format('%R%a')+1)*24;  
			if($diff>0)
			{
			    $final_imp_per_hour=$remaining_imp/$diff;
			}
			else
			{
				$final_imp_per_hour=0;
			}			
		}
		else if($even_distribute_impressions!='0')
		{
			$final_imp_per_hour=$even_distribute_impressions/24;			
		}
		if(in_array($cam_data['campaignid'],$exist_campaign_data))
		{
			//echo "if-->".$cam_data['campaignid'];  echo "<br/>";
			for($i=0;$i<=23;$i++)
			{
				$even_query = OA_Dal_Delivery_query("select campaign_id from rv_djax_evenly_distribution where campaign_id='".$cam_data['campaignid']."' AND start_time='".$start_time_val[$i]."' AND end_time='".$end_time_val[$i]."'");
				if(OA_Dal_Delivery_numRows($even_query)>0)
				{
				$update_query = "update rv_djax_evenly_distribution set impressions='".$final_imp_per_hour."',today_date='".$current_date."' where campaign_id='".$cam_data['campaignid']."' AND start_time='".$start_time_val[$i]."' AND end_time='".$end_time_val[$i]."'";
				OA_Dal_Delivery_query($update_query);
				}
				else
				{
				$insert_query = "insert into rv_djax_evenly_distribution(campaign_id,start_time,end_time,impressions,today_date) values('".$cam_data['campaignid']."','".$start_time_val[$i]."','".$end_time_val[$i]."','".$final_imp_per_hour."','".$current_date."')";
				OA_Dal_Delivery_query($insert_query);  
				}
			}
		}
		else
		{
			//echo "else-->".$cam_data['campaignid']; echo "<br/>";
			for($i=0;$i<=23;$i++)
			{
				$insert_query = "insert into rv_djax_evenly_distribution(campaign_id,start_time,end_time,impressions,today_date) values('".$cam_data['campaignid']."','".$start_time_val[$i]."','".$end_time_val[$i]."','".$final_imp_per_hour."','".$current_date."')";
				OA_Dal_Delivery_query($insert_query);
			}
		}
	}
	else
	{
	$delete_query = "delete rv_djax_evenly_distribution where campaign_id='".$cam_data['campaignid']."'";
	OA_Dal_Delivery_query($delete_query);		
	$distribute=explode(",",$weekly_distribute);	
	$count=count($distribute);
	
	if($daily_budget_unlimit!='1')
	{
			$estimated_imp=$daily_budget/$bid_rate;			
			$final_imp_per_hour=$estimated_imp/$count;
			
	}
	else if($even_distribute_end_date!='0000-00-00' || $expire_time!=NULL )
	{		
		$end_date_query=OA_Dal_Delivery_query("select sum(impressions) as imp from rv_data_summary_ad_hourly as h JOIN rv_campaigns as c JOIN rv_banners as b ON b.bannerid=h.ad_id AND b.campaignid=c.campaignid where b.campaignid=".$campaign_id);
		if(OA_Dal_Delivery_numRows($end_date_query)>0)
		{
			$impressions=OA_Dal_Delivery_fetchAssoc($end_date_query);
			$sum_imp=$impressions['imp'];
		}
		$estimated_imp=$campaign_budget/$bid_rate;
		$remaining_imp=$estimated_imp-$sum_imp;				
		$datetime1 = date_create($current_date);
		if($even_distribute_end_date!='0000-00-00')
		{
		  $datetime2 = date_create($even_distribute_end_date);
		}
		else
		{
		  $datetime2 = date_create($expire_time);
		}
		$interval = date_diff($datetime1, $datetime2);
		$diff=($interval->format('%R%a')+1)*$count;  		
		if($diff>0)
		{
			$final_imp_per_hour=$remaining_imp/$diff;
		}
		else
		{
			$final_imp_per_hour=0;
		}
	}
	else if($even_distribute_impressions!='0')
	{
		$final_imp_per_hour=$even_distribute_impressions/$count;		
	}
	$day_values='';
	$time_values='';
		for($i=0;$i<$count;$i++)
		{	
			$day_distribute=explode("_",$distribute[$i]);		
			if($day_distribute[0]==date('w'))
			{				
				$time_value=$day_distribute[1];  
				$even_query = OA_Dal_Delivery_query("select campaign_id from rv_djax_evenly_distribution where campaign_id='".$cam_data['campaignid']."' AND start_time='".$start_time_val[$time_value]."' AND end_time='".$end_time_val[$time_value]."'");
				if(OA_Dal_Delivery_numRows($even_query)>0)
				{
				$update_query = "update rv_djax_evenly_distribution set impressions='".$final_imp_per_hour."',today_date='".$current_date."' where campaign_id='".$cam_data['campaignid']."' AND start_time='".$start_time_val[$time_value]."' AND end_time='".$end_time_val[$time_value]."'";
				OA_Dal_Delivery_query($update_query);
				}
				else
				{
				$insert_query = "insert into rv_djax_evenly_distribution(campaign_id,start_time,end_time,impressions,today_date) values('".$cam_data['campaignid']."','".$start_time_val[$time_value]."','".$end_time_val[$time_value]."','".$final_imp_per_hour."','".$current_date."')";
				OA_Dal_Delivery_query($insert_query);
				}			
			}						
		}		
	}
}   
echo "Cron file runned successfully";
?>
