<?php
// Require the initialisation file
$path = dirname(__FILE__);
require_once $path . '/../../init.php';
date_default_timezone_set('Europe/Amsterdam');
function OX_Delivery_logMessage($message, $priority = 6) 
{
    $conf = $GLOBALS['_MAX']['CONF'];
    if (empty($conf['deliveryLog']['enabled'])) return true;
    $priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
	if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) {
        return true;
    }
    error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
    OX_Delivery_Common_hook('logMessage', array(
        $message,
        $priority
    ));
    return true;
}

function OX_Delivery_Common_hook($hookName, $aParams = array(), $functionName = '')
{
    $return = null;
	if (!empty($functionName)) {
        $aParts = explode(':', $functionName);
		if (count($aParts) === 3) {
            $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
        }
		if (function_exists($functionName)) {
            $return = call_user_func_array($functionName, $aParams);
        }
	} else {
		if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) {
            $return = array();
            $hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
			foreach ($hooks as $identifier) {
                $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
				if (function_exists($functionName)) {
                    OX_Delivery_logMessage('calling on ' . $functionName, 7);
                    $return[$identifier] = call_user_func_array($functionName, $aParams);
                }
            }
        }
    }
    return $return;
}

function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null)
{
    $aInfo = explode(':', $identifier);
    $functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
	if (!function_exists($functionName)) {
        if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
		if (!function_exists($functionName)) {
            _includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
			if (!function_exists($functionName)) {
                _includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
                $functionName = 'Plugin_' . $aInfo[0] . '_delivery';
				if (!empty($hook) && function_exists($functionName . '_' . $hook)) {
					$functionName .= '_' . $hook;
                }
            }
        }
    }
    return $functionName;
}

function _includeDeliveryPluginFile($fileName)
{
	if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) {
        $GLOBALS['_MAX']['FILES'][$fileName] = true;
		if (file_exists(MAX_PATH . $fileName)) {
            include MAX_PATH . $fileName;
        }
    }
}

function MAX_Dal_Delivery_Include()
{
    static $included;
	if (isset($included)) {
        return;
    }
    $included = true;
    $conf = $GLOBALS['_MAX']['CONF'];
	if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
	} else {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
	}
}
MAX_Dal_Delivery_Include();
if (!empty($conf['debug']['production'])) {
	error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
} else {
	error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
}
//Setting up for unlimited time.
set_time_limit(0);

fetch_campaigns();

/*Update Daily remaining budget value set to Zero*/
$daily_budget = "update rv_campaigns set dj_campaign_remain_budget = '0'";
OA_Dal_Delivery_query($daily_budget);
/*End*/			


$mail_update = "UPDATE djax_adv_pub_notification_settings SET mail_send = '0'";
OA_Dal_Delivery_query($mail_update);


function fetch_campaigns()
{
	$current_time = date("Y-m-d h:i:s");

	$campaigns = OA_Dal_Delivery_query("select * from rv_campaigns where status='8' AND dj_budget_status='1'");
	
	while ($djax_cams = OA_Dal_Delivery_fetchAssoc($campaigns)) {
		$campaign_data[] = $djax_cams;
	}	
		
	foreach($campaign_data as $val)
	{
			$run_campaign = "update rv_campaigns set status = '0' AND dj_budget_status='0' where campaignid = ".$val['campaignid']." ";
			$update_campaign_run = OA_Dal_Delivery_query($run_campaign);
	}
	echo "Cron file runned successfully";
}
?>
