<?php 

// Require the initialisation file
$path = dirname(__FILE__);
require_once $path . '/../../init.php';
function OX_Delivery_logMessage($message, $priority = 6) 
{
    $conf = $GLOBALS['_MAX']['CONF'];
    if (empty($conf['deliveryLog']['enabled'])) return true;
    $priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
    if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) 
    {
        return true;
    }
    error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
    OX_Delivery_Common_hook('logMessage', array(
        $message,
        $priority
    ));
    return true;
}
function OX_Delivery_Common_hook($hookName, $aParams = array() , $functionName = '') 
{
    $return = null;
    if (!empty($functionName)) 
    {
        $aParts = explode(':', $functionName);
        if (count($aParts) === 3) 
        {
            $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
        }
        if (function_exists($functionName)) 
        {
            $return = call_user_func_array($functionName, $aParams);
        }
    }
    else
    {
        if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) 
        {
            $return = array();
            $hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
            foreach ($hooks as $identifier) 
            {
                $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
                if (function_exists($functionName)) 
                {
                    OX_Delivery_logMessage('calling on ' . $functionName, 7);
                    $return[$identifier] = call_user_func_array($functionName, $aParams);
                }
            }
        }
    }
    return $return;
}
function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null) 
{
    $aInfo = explode(':', $identifier);
    $functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
    if (!function_exists($functionName)) 
    {
        if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
        if (!function_exists($functionName)) 
        {
            _includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
            if (!function_exists($functionName)) 
            {
                _includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
                $functionName = 'Plugin_' . $aInfo[0] . '_delivery';
                if (!empty($hook) && function_exists($functionName . '_' . $hook)) 
                {
                    $functionName.= '_' . $hook;
                }
            }
        }
    }
    return $functionName;
}
function _includeDeliveryPluginFile($fileName) 
{
    if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) 
    {
        $GLOBALS['_MAX']['FILES'][$fileName] = true;
        if (file_exists(MAX_PATH . $fileName)) 
        {
            include MAX_PATH . $fileName;
        }
    }
}
function MAX_Dal_Delivery_Include() 
{
    static $included;
    if (isset($included)) 
    {
        return;
    }
    $included = true;
    $conf = $GLOBALS['_MAX']['CONF'];
    if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) 
    {
        require (MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
    }
    else
    {
        require (MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
    }
}
MAX_Dal_Delivery_Include();
if (!empty($conf['debug']['production']))
{
	error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
}
else
{
	error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
}
//Setting up for unlimited time.
set_time_limit (0);

/********************************************** Function to migrate the browser data *********************************************/
function djax_browser_statistics($start='', $end='')
{
    if ($start != '' && $end != '')
    {
        $query	= OA_Dal_Delivery_query("INSERT INTO `djax_browsers_stats`(`date_time`, `ad_id`, `zone_id`, `user_agent`, `browser_version`,browser_name, `requests`, `impressions`, `clicks`, `conversions`, `uniq_impressions`, `uniq_clicks`, `delivery_media_type`) SELECT 
					vir.date_time,
					vir.ad_id,
					vir.zone_id,
					vir.user_agent,
					vir.browser_version,
					vir.browser_name,
					IFNULL(sum(vir.requests), 0) AS requests,
					IFNULL(sum(vir.impressions), 0) AS impressions,
					IFNULL(sum(vir.clicks), 0) AS clicks,
					IFNULL(sum(vir.conversions), 0) AS conversions,
					IFNULL(sum(vir.uniq_impressions), 0) AS uniq_impressions,
					IFNULL(sum(vir.uniq_clicks), 0) AS uniq_clicks,					
					vir.delivery_media_type 
				FROM
					(SELECT 
						m.interval_start AS date_time,
						m.creative_id AS ad_id,
						m.zone_id AS zone_id,
						r.user_agent AS user_agent,
						r.browser_version AS browser_version,
						r.browser_name AS browser_name,
						count(request_id) AS requests,
						IFNULL(sum(m.count), 0) AS impressions,
						IFNULL(sum(c.count), 0) AS clicks,
						0 AS uniq_impressions,
						0 AS uniq_clicks,
						0 AS conversions,
						v.device_type AS delivery_media_type 
					FROM 
						rv_data_bkt_m AS m
					JOIN
						rv_djax_track_ad_requests AS r ON r.request_id=m.dj_request_id
					JOIN
						rv_djax_track_viewers AS v ON v.viewer_id=r.viewer_id
					LEFT JOIN
						rv_data_bkt_c AS c ON r.request_id=c.dj_request_id AND c.interval_start BETWEEN '$start' AND '$end' 
					WHERE 
						m.interval_start BETWEEN '$start' AND '$end' 
					GROUP BY 
						date_time, ad_id, zone_id, user_agent, browser_version, browser_name, delivery_media_type
					UNION
					SELECT 
						m.interval_start AS date_time,
						m.creative_id AS ad_id,
						m.zone_id AS zone_id,
						r.user_agent AS user_agent,
						r.browser_version AS browser_version,
						r.browser_name AS browser_name,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						count(distinct(v.viewer_id)) AS unique_impression,
						0 AS uniq_clicks,
						0 AS conversions,
						v.device_type AS delivery_media_type
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_m AS m ON m.dj_request_id = r.request_id
					WHERE 
						m.interval_start BETWEEN '" .$start. "' AND '" .$end. "'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, r.user_agent, r.browser_version,r.browser_name
					UNION
					SELECT 
						c.interval_start AS date_time,
						c.creative_id AS ad_id,
						c.zone_id AS zone_id,
						r.user_agent AS user_agent,
						r.browser_version AS browser_version,
						r.browser_name AS browser_name,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS unique_impression,
						count(distinct(v.viewer_id)) AS uniq_clicks,
						0 AS conversions,
						v.device_type AS delivery_media_type
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_c AS c ON c.dj_request_id = r.request_id
					WHERE 
						c.interval_start BETWEEN '" .$start. "' AND '" .$end. "'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, r.user_agent, r.browser_version,r.browser_name
					UNION
					SELECT 
						a.date_time AS date_time,
						a.creative_id AS ad_id,
						a.zone_id AS zone_id,
						r.user_agent AS user_agent,
						r.browser_version AS browser_version,
						r.browser_name AS browser_name,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS unique_impression,
						0 AS uniq_clicks,
						COUNT(*) AS conversions,
						v.device_type AS delivery_media_type
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_a AS a ON a.dj_request_id = r.request_id
					WHERE 
						a.date_time BETWEEN '" .$start. "' AND '" .$end. "'
					GROUP BY 
						ad_id, zone_id, r.user_agent,r.browser_name, r.browser_version) AS vir
				GROUP BY
					vir.date_time, vir.ad_id, vir.zone_id, vir.user_agent, vir.browser_version, vir.browser_name, vir.delivery_media_type");
    }
}
/********************************************** Function to migrate the client statistics data *********************************************/
function djax_client_statistics($start = '', $end = '')
{
	if ($start != '' && $end != '')
    {
		$query	= OA_Dal_Delivery_query("INSERT INTO `djax_clients_stats`(`date_time`, `ad_id`, `zone_id`, `os`, `flash_version`, `screen_resolution`, `requests`, `impressions`, `clicks`, `conversions`, `uniq_impressions`, `uniq_clicks`, `delivery_media_type`) SELECT 
					vir.date_time,
					vir.ad_id,
					vir.zone_id,
					vir.os,
					vir.flash_version,
					vir.screen_resolution,
					IFNULL(sum(vir.requests), 0) AS requests,
					IFNULL(sum(vir.impressions), 0) AS impressions,
					IFNULL(sum(vir.clicks), 0) AS clicks,
					IFNULL(sum(vir.conversions), 0) AS conversions,
					IFNULL(sum(vir.uniq_impressions), 0) AS uniq_impressions,
					IFNULL(sum(vir.uniq_clicks), 0) AS uniq_clicks,					
					vir.delivery_media_type 
				FROM
					(SELECT 
						m.interval_start AS date_time,
						m.creative_id AS ad_id,
						m.zone_id AS zone_id,
						v.os AS os,
						r.flash_version AS flash_version,
						v.screen_resolution AS screen_resolution,
						count(request_id) AS requests,
						IFNULL(sum(m.count), 0) AS impressions,
						IFNULL(sum(c.count), 0) AS clicks,
						0 AS uniq_impressions,
						0 AS uniq_clicks,
						0 AS conversions,
						v.device_type AS delivery_media_type 
					FROM 
						rv_data_bkt_m AS m
					JOIN
						rv_djax_track_ad_requests AS r ON r.request_id=m.dj_request_id
					JOIN
						rv_djax_track_viewers AS v ON v.viewer_id=r.viewer_id
					LEFT JOIN
						rv_data_bkt_c AS c ON r.request_id=c.dj_request_id AND c.interval_start BETWEEN '$start' AND '$end' 
					WHERE 
						m.interval_start BETWEEN '$start' AND '$end' 
					GROUP BY 
						date_time, ad_id, zone_id, v.os, r.flash_version, v.screen_resolution, v.device_type
					UNION
					SELECT 
						m.interval_start AS date_time,
						m.creative_id AS ad_id,
						m.zone_id AS zone_id,
						v.os AS os,
						r.flash_version AS flash_version,
						v.screen_resolution AS screen_resolution,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						count(distinct(v.viewer_id)) AS unique_impression,
						0 AS uniq_clicks,
						0 AS conversions,
						v.device_type AS delivery_media_type
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_m AS m ON m.dj_request_id = r.request_id
					WHERE 
						m.interval_start BETWEEN '" .$start. "' AND '" .$end. "'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, v.os, r.flash_version, v.screen_resolution, v.device_type
					UNION
					SELECT 
						c.interval_start AS date_time,
						c.creative_id AS ad_id,
						c.zone_id AS zone_id,
						v.os AS os,
						r.flash_version AS flash_version,
						v.screen_resolution AS screen_resolution,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS unique_impression,
						count(distinct(v.viewer_id)) AS uniq_clicks,
						0 AS conversions,
						v.device_type AS delivery_media_type
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_c AS c ON c.dj_request_id = r.request_id
					WHERE 
						c.interval_start BETWEEN '" .$start. "' AND '" .$end. "'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, v.os, r.flash_version, v.screen_resolution, v.device_type
					UNION
					SELECT 
						a.date_time AS date_time,
						a.creative_id AS ad_id,
						a.zone_id AS zone_id,
						v.os AS os,
						r.flash_version AS flash_version,
						v.screen_resolution AS screen_resolution,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS unique_impression,
						0 AS uniq_clicks,
						COUNT(*) AS conversions,
						v.device_type AS delivery_media_type
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_a AS a ON a.dj_request_id = r.request_id
					WHERE 
						a.date_time BETWEEN '" .$start. "' AND '" .$end. "'
					GROUP BY 
						ad_id, zone_id, v.os, r.flash_version, v.screen_resolution, v.device_type) AS vir
				GROUP BY
					vir.date_time, vir.ad_id, vir.zone_id, vir.os, vir.flash_version, vir.screen_resolution, vir.delivery_media_type");
    }
}
/********************************************** Function to migrate the Djax Site Statistics data *********************************************/
function djax_site_statistics($start = '', $end = '')
{
	if ($start != '' && $end != '')
    {
		$query	= OA_Dal_Delivery_query("INSERT INTO `djax_sites_stats`(`date_time`, `ad_id`, `zone_id`, `domain`, `site_url`, `site_referrer_url`, `requests`, `impressions`, `clicks`, `conversions`, `uniq_impressions`, `uniq_clicks`, `delivery_media_type`,`country`) SELECT 
					vir.date_time,
					vir.ad_id,
					vir.zone_id,
					vir.domain,
					vir.site_url,
					vir.site_referrer_url,
					IFNULL(sum(vir.requests), 0) AS requests,
					IFNULL(sum(vir.impressions), 0) AS impressions,
					IFNULL(sum(vir.clicks), 0) AS clicks,
					IFNULL(sum(vir.conversions), 0) AS conversions,
					IFNULL(sum(vir.uniq_impressions), 0) AS uniq_impressions,
					IFNULL(sum(vir.uniq_clicks), 0) AS uniq_clicks,
					vir.delivery_media_type,
					vir.country 
				FROM
					
					(SELECT 
						bk.interval_start AS date_time,
						bk.creative_id AS ad_id,
						bk.zone_id AS zone_id,
						bk.domain as domain,
						bk.site_url as site_url,
						bk.site_referrer_url as site_referrer_url,
						bk.country_name as country_name,
						bk.country_code as country,						
						bk.device_type AS delivery_media_type,
						IFNULL(sum(bk.requests), 0) AS requests,
						IFNULL(sum(bk.impressions), 0) AS impressions,
						IFNULL(sum(bk.clicks), 0) AS clicks,
						IFNULL(sum(bk.conversions), 0) AS conversions,
						IFNULL(sum(bk.dj_total_revenue), 0) AS dj_total_revenue, 
						IFNULL(sum(bk.dj_publisher_revenue), 0) AS dj_publisher_revenue,
						0 AS uniq_impressions,
						0 AS uniq_clicks						 
					FROM 
						
						(SELECT 
							br.interval_start,
							br.creative_id,
							br.zone_id,
							SUM(br.count) AS requests, 
							0 AS impressions,
							0 AS clicks,
							0 AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.site_url as site_url,
							r.site_referrer_url as site_referrer_url,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
						FROM
							rv_data_bkt_r as br 
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=br.dj_request_id
						WHERE
							br.interval_start BETWEEN '$start' AND '$end' 
						GROUP BY
							br.interval_start, br.creative_id, br.zone_id, r.domain, r.site_url, r.site_referrer_url, r.device_type
						
						UNION
						
						SELECT 
							c.interval_start,
							c.creative_id, 
							c.zone_id, 
							0 AS requests,
							0 AS impressions,
							SUM(c.count) AS clicks,
							0 AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.site_url as site_url,
							r.site_referrer_url as site_referrer_url,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
							
						FROM 
							`rv_data_bkt_c` as c
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=c.dj_request_id
						WHERE
							c.interval_start BETWEEN '$start' AND '$end' 
						GROUP BY 
							c.interval_start, c.creative_id, c.zone_id, r.domain, r.site_url, r.site_referrer_url, r.device_type
							
						UNION
						
						SELECT 
							a.date_time,
							a.creative_id, 
							a.zone_id, 
							0 AS requests, 
							0 AS impressions,
							0 AS clicks,
							COUNT(server_conv_id) AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.site_url as site_url,
							r.site_referrer_url as site_referrer_url,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
							
						FROM 
							`rv_data_bkt_a` as a
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=a.dj_request_id
						WHERE
							a.date_time BETWEEN '$start' AND '$end' 
						GROUP BY 
							a.date_time, creative_id, a.zone_id, r.domain, r.site_url, r.site_referrer_url, r.device_type
							
						UNION
						
						SELECT 
							m.interval_start,
							m.creative_id, 
							m.zone_id, 
							0 AS requests,
							SUM( m.count ) AS impressions,
							0 AS clicks,
							0 AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.site_url as site_url,
							r.site_referrer_url as site_referrer_url,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
							
						FROM 
							`rv_data_bkt_m` as m
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=m.dj_request_id
						WHERE
							m.interval_start BETWEEN '$start' AND '$end' 
						GROUP BY 
							m.interval_start, m.creative_id, m.zone_id, r.domain, r.site_url, r.site_referrer_url, r.device_type							
							) as bk
					WHERE 
						bk.interval_start BETWEEN '$start' AND '$end' 
					GROUP BY 
						date_time, ad_id, zone_id, bk.domain, bk.site_url, bk.site_referrer_url, bk.device_type
					
					UNION
					
					SELECT 
						m.interval_start AS date_time,
						m.creative_id AS ad_id,
						m.zone_id AS zone_id,
						r.domain as domain,
						r.site_url as site_url,
						r.site_referrer_url as site_referrer_url,
						r.country_name as country_name,
						r.country_code as country,
						CASE
							WHEN r.`device_type` = 'web' THEN 'Display'
							WHEN r.`device_type` = 'mobile' THEN 'Mobile'
							WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
						END AS delivery_media_type,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS conversions,
						0 AS dj_total_revenue, 
						0 AS dj_publisher_revenue, 
						count(distinct(v.viewer_id)) AS unique_impression,
						0 AS uniq_clicks
						
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_m AS m ON m.dj_request_id = r.request_id
					WHERE 
						m.interval_start BETWEEN '$start' AND '$end'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, r.domain, r.site_url, r.site_referrer_url, v.device_type
					UNION
					SELECT 
						c.interval_start AS date_time,
						c.creative_id AS ad_id,
						c.zone_id AS zone_id,
						r.domain as domain,
						r.site_url as site_url,
						r.site_referrer_url as site_referrer_url,
						r.country_name as country_name,
						r.country_code as country,
						CASE
							WHEN r.`device_type` = 'web' THEN 'Display'
							WHEN r.`device_type` = 'mobile' THEN 'Mobile'
							WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
						END AS delivery_media_type,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS conversions,
						0 AS dj_total_revenue, 
						0 AS dj_publisher_revenue,
						0 AS unique_impression,
						count(distinct(v.viewer_id)) AS uniq_clicks
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_c AS c ON c.dj_request_id = r.request_id
					WHERE 
						c.interval_start BETWEEN '$start' AND '$end'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, r.domain, r.site_url, r.site_referrer_url, v.device_type
					) AS vir
				GROUP BY
					vir.date_time, vir.ad_id, vir.zone_id, vir.domain, vir.site_url, vir.site_referrer_url, vir.country, vir.delivery_media_type");
    }
}
/********************************************** Function to migrate the VAST data *********************************************/
function djax_vast_statistics($start = '', $end = '')
{
	if ($start != '' && $end != '')
    {
		//,`dj_win_bid`, `dj_publisher_revenue`, `dj_admin_revenue`
		//,dj_win_bid,dj_publisher_revenue,dj_admin_revenue 
		$query	= OA_Dal_Delivery_query("INSERT INTO `rv_stats_vast`(`interval_start`, `creative_id`, `zone_id`, `vast_event_id`,`count`) SELECT 
					interval_start,creative_id,zone_id,vast_event_id,count
					FROM 
						rv_data_bkt_vast_e
					WHERE 
						interval_start BETWEEN '$start' AND '$end' 
					GROUP BY 
						interval_start, creative_id, zone_id,vast_event_id");
						
						
    }
}
/********************************************** Function to migrate the Djax Mobile device data *********************************************/
function djax_device_statistics($start = '', $end = '')
{
}
/********************************************** Function to migrate the Anti fraud Statistics data *********************************************/
function updateantifraud($start = '', $end = '')
{
    //Djax_penalty	
    $query_penalty = OA_Dal_Delivery_query("SELECT * FROM djax_penalty");
    if (OA_Dal_Delivery_numRows($query_penalty) > 0)
    {
        while ($fetch_penalty = OA_Dal_Delivery_fetchAssoc($query_penalty))
        {
            $insert_penalty = OA_Dal_Delivery_query("INSERT INTO djax_penalties(date_time,pubname,penaltypoint,pubid,zone_id,country)VALUES('" . $fetch_penalty['interval_start'] . "','" . $fetch_penalty['pubname'] . "','" . $fetch_penalty['penaltypoint'] . "','" . $fetch_penalty['pubid'] . "','" . $fetch_penalty['zone_id'] . "','" . $fetch_penalty['country'] . "')");
        }
        $delete = OA_Dal_Delivery_query("delete from djax_penalty");
    }
    //Djax penalty
    $query_geo = "INSERT INTO djax_anti_fraud_stats(datetime,pubid,zone_id,fclicks,aclicks,country,ipaddress,url)
			SELECT 
				DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00') as datetime,
				pubid,
				zone_id,
				fclicks,
				aclicks,
				country,
				ipaddress,
				url 
			FROM
				(SELECT
				    DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00') as date_time,
				    pub_id as pubid,
				    zone_id as zone_id,
				    0 as fclicks,
				    count(viewer_id) as aclicks,
				    country as country,
				    ipaddress as ipaddress,
				    url as url
				FROM
					djax_ad_zone_click
				WHERE
					date_time BETWEEN '$start' AND '$end'
				GROUP BY
		            DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00'), pubid, zone_id, country, ipaddress, url
				) AS virtual_table;";
    OA_Dal_Delivery_query($query_geo);
    $djax_fraud_click = "SELECT
				    DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00') as datetime,
				    pub_id as pubid,
				    zone_id as zone_id,
				    count(viewer_id) as fclicks,
				    0 as aclicks,
				    country as country,
				    ipaddress as ipaddress,
				    url as url
				FROM
					djax_ad_fraud_click
				WHERE
					date_time BETWEEN '$start' AND '$end'
				GROUP BY
		            DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00'), pubid, zone_id, country, ipaddress, url";
    $djax_query_exe   = OA_Dal_Delivery_query($djax_fraud_click);
    $djax_rows        = OA_Dal_Delivery_numRows($djax_query_exe);
    if ($djax_rows > 0)
    {
        while ($djax_fraud_res = OA_Dal_Delivery_fetchAssoc($djax_query_exe))
        {
            $djax_fraud_update = "update djax_anti_fraud_stats set fclicks='" . $djax_fraud_res['fclicks'] . "' where datetime='" . $djax_fraud_res['datetime'] . "' and 
					pubid='" . $djax_fraud_res['pubid'] . "' and zone_id='" . $djax_fraud_res['zone_id'] . "' and country='" . $djax_fraud_res['country'] . "' and url='" . $djax_fraud_res['url'] . "' and 
					ipaddress='" . $djax_fraud_res['ipaddress'] . "'";
            $djax_query_exe    = OA_Dal_Delivery_query($djax_fraud_update);
        }
    }
    $delete_valid = "delete from djax_ad_fraud_click where date_time BETWEEN '$start' AND '$end'";
    OA_Dal_Delivery_query($delete_valid);
    $delete_fraud = "delete from djax_ad_zone_click where date_time BETWEEN '$start' AND '$end'";
    OA_Dal_Delivery_query($delete_fraud);
}
/********************************************** Function to migrate the Djax geo statistics data *********************************************/
function djax_geo_statistics($start = '', $end = '')
{
	if ($start != '' && $end != '')
    {
		$query	= OA_Dal_Delivery_query("INSERT INTO `djax_geographical_stats`(`date_time`, `ad_id`, `zone_id`, `ip_address`, `country`, `country_code`, `state`, `city`, `latitude`, `longitude`, `requests`, `impressions`, `clicks`, `conversions`,`total_revenue`,`publisher_earnings`, `uniq_impressions`, `uniq_clicks`, `delivery_media_type`, `browser_name`, `browser_version`, `browser_language`, `operating_system`) SELECT 
					vir.date_time,
					vir.ad_id,
					vir.zone_id,
					vir.ip_address as ip_address,
					vir.country_name as country_name,
					vir.country_code as country_code,
					vir.state as state,
					vir.city as city,
					vir.latitude as latitude,
					vir.longitude as longitude,
					IFNULL(sum(vir.requests), 0) AS requests,
					IFNULL(sum(vir.impressions), 0) AS impressions,
					IFNULL(sum(vir.clicks), 0) AS clicks,
					IFNULL(sum(vir.conversions), 0) AS conversions,
					IFNULL(sum(vir.dj_total_revenue), 0) AS dj_total_revenue,
					IFNULL(sum(vir.dj_publisher_revenue), 0) AS dj_publisher_revenue,
					IFNULL(sum(vir.uniq_impressions), 0) AS uniq_impressions,
					IFNULL(sum(vir.uniq_clicks), 0) AS uniq_clicks,
					vir.delivery_media_type,
					vir.browser_name,
					vir.browser_version,
					vir.browser_language,
					vir.operating_system 
				FROM
					(SELECT 
						bk.interval_start AS date_time,
						bk.creative_id AS ad_id,
						bk.zone_id AS zone_id,
						bk.domain as ip_address,
						bk.country_name as country_name,
						bk.country_code as country_code,
						bk.region as state,
						bk.city as city,
						bk.user_latitude as latitude,
						bk.user_longitude as longitude,
						bk.browser_name,
						bk.browser_version,
						bk.browser_language,
						bk.operating_system,
						bk.device_type AS delivery_media_type,
						IFNULL(sum(bk.requests), 0) AS requests,
						IFNULL(sum(bk.impressions), 0) AS impressions,
						IFNULL(sum(bk.clicks), 0) AS clicks,
						IFNULL(sum(bk.conversions), 0) AS conversions,
						IFNULL(sum(bk.dj_total_revenue), 0) AS dj_total_revenue, 
						IFNULL(sum(bk.dj_publisher_revenue), 0) AS dj_publisher_revenue,
						0 AS uniq_impressions,
						0 AS uniq_clicks						 
					FROM 
						
						(SELECT 
							br.interval_start,
							br.creative_id,
							br.zone_id,
							SUM(br.count) AS requests, 
							0 AS impressions,
							0 AS clicks,
							0 AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.region,
							r.city,
							r.user_latitude,
							r.user_longitude,
							r.browser_name,
							r.browser_version,
							r.browser_language,
							r.operating_system,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
						FROM
							rv_data_bkt_r as br 
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=br.dj_request_id
						WHERE
							br.interval_start BETWEEN '$start' AND '$end' 
						GROUP BY
							br.interval_start, creative_id, br.zone_id, domain, country_code, region, city, user_latitude, user_longitude, browser_name, browser_version, browser_language, operating_system, r.device_type
						
						UNION
						
						SELECT 
							m.interval_start,
							m.creative_id, 
							m.zone_id, 
							0 AS requests,
							SUM( m.count ) AS impressions,
							0 AS clicks,
							0 AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.region,
							r.city,
							r.user_latitude,
							r.user_longitude,
							r.browser_name,
							r.browser_version,
							r.browser_language,
							r.operating_system,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
							
						FROM 
							`rv_data_bkt_m` as m
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=m.dj_request_id
						WHERE
							m.interval_start BETWEEN '$start' AND '$end' 
						GROUP BY 
							m.interval_start, creative_id, m.zone_id, domain, country_code, region, city, user_latitude, user_longitude, browser_name, browser_version, browser_language, operating_system, r.device_type
						
						UNION
						
						SELECT 
							c.interval_start,
							c.creative_id, 
							c.zone_id, 
							0 AS requests,
							0 AS impressions,
							SUM(c.count) AS clicks,
							0 AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.region,
							r.city,
							r.user_latitude,
							r.user_longitude,
							r.browser_name,
							r.browser_version,
							r.browser_language,
							r.operating_system,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
							
						FROM 
							`rv_data_bkt_c` as c
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=c.dj_request_id
						WHERE
							c.interval_start BETWEEN '$start' AND '$end' 
						GROUP BY 
							c.interval_start, creative_id, c.zone_id, domain, country_code, region, city, user_latitude, user_longitude, browser_name, browser_version, browser_language, operating_system, r.device_type
							
						UNION
						
						SELECT 
							a.date_time,
							a.creative_id, 
							a.zone_id, 
							0 AS requests, 
							0 AS impressions,
							0 AS clicks,
							COUNT(server_conv_id) AS conversions,
							SUM(dj_win_bid) AS dj_total_revenue, 
							SUM(dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(dj_admin_revenue) AS dj_admin_revenue,
							r.domain,
							r.country_name,
							r.country_code,
							r.region,
							r.city,
							r.user_latitude,
							r.user_longitude,
							r.browser_name,
							r.browser_version,
							r.browser_language,
							r.operating_system,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
							
						FROM 
							`rv_data_bkt_a` as a
						JOIN
							rv_djax_track_ad_requests AS r ON r.request_id=a.dj_request_id
						WHERE
							a.date_time BETWEEN '$start' AND '$end' 
						GROUP BY 
							a.date_time, creative_id, a.zone_id, domain, country_code, region, city, user_latitude, user_longitude, browser_name, browser_version, browser_language, operating_system, r.device_type
							) as bk
					WHERE 
						bk.interval_start BETWEEN '$start' AND '$end' 
					GROUP BY 
						date_time, ad_id, zone_id, ip_address, country_code, state, city, latitude, longitude, browser_name, browser_version, browser_language, operating_system, bk.device_type
					
					UNION
					
					SELECT 
						m.interval_start AS date_time,
						m.creative_id AS ad_id,
						m.zone_id AS zone_id,
						r.domain as ip_address,
						r.country_name as country_name,
						r.country_code as country_code,
						r.region as state,
						r.city as city,
						r.user_latitude as latitude,
						r.user_longitude as longitude,
						r.browser_name,
						r.browser_version,
						r.browser_language,
						r.operating_system,
						CASE
							WHEN r.`device_type` = 'web' THEN 'Display'
							WHEN r.`device_type` = 'mobile' THEN 'Mobile'
							WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
						END AS delivery_media_type,
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS conversions,
						0 AS dj_total_revenue, 
						0 AS dj_publisher_revenue, 
						count(distinct(v.viewer_id)) AS unique_impression,
						0 AS uniq_clicks					
						
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_m AS m ON m.dj_request_id = r.request_id
					WHERE 
						m.interval_start BETWEEN '$start' AND '$end'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, ip_address, country_code, state, city, latitude, longitude, browser_name, browser_version, browser_language, operating_system, r.device_type
					UNION
					SELECT 
						c.interval_start AS date_time,
						c.creative_id AS ad_id,
						c.zone_id AS zone_id,
						r.domain as ip_address,
						r.country_name as country_name,
						r.country_code as country_code,
						r.region as state,
						r.city as city,
						r.user_latitude as latitude,
						r.user_longitude as longitude,
						r.browser_name,
						r.browser_version,
						r.browser_language,
						r.operating_system,
						CASE
							WHEN r.`device_type` = 'web' THEN 'Display'
							WHEN r.`device_type` = 'mobile' THEN 'Mobile'
							WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
						END AS delivery_media_type,						
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						0 AS conversions,
						0 AS dj_total_revenue, 
						0 AS dj_publisher_revenue, 
						0 AS unique_impression,
						count(distinct(v.viewer_id)) AS uniq_clicks
						
					FROM 
						rv_djax_track_viewers AS v
					JOIN 
						rv_djax_track_ad_requests AS r ON r.viewer_id = v.viewer_id
					JOIN 
						rv_data_bkt_c AS c ON c.dj_request_id = r.request_id
					WHERE 
						c.interval_start BETWEEN '$start' AND '$end'
					GROUP BY 
						v.viewer_id, ad_id, zone_id, ip_address, country_code, state, city, latitude, longitude, browser_name, browser_version, browser_language, operating_system, r.device_type
					) AS vir
				GROUP BY
					vir.date_time, vir.ad_id, vir.zone_id, vir.ip_address, vir.country_code, vir.state, vir.city, vir.latitude, vir.longitude, vir.browser_name, vir.browser_version, vir.browser_language, vir.operating_system, vir.delivery_media_type");
    }
}
/********************************************** Function to  migrate the Djax VIEWER statistics data *********************************************/
function djax_viewer_statistics($start = '', $end = '')
{

    if ($start != '' && $end != '')
    {
		$query	= OA_Dal_Delivery_query("INSERT INTO `djax_viewer_stats`(`date_time`, `viewer_id`, `ad_id`, `zone_id`, `requests`, `impressions`, `clicks`, `conversions`, `delivery_media_type`) SELECT 
					vir.date_time,
					vir.viewer_id as viewer_id,
					vir.ad_id,
					vir.zone_id,					
					IFNULL(sum(vir.requests), 0) AS requests,
					IFNULL(sum(vir.impressions), 0) AS impressions,
					IFNULL(sum(vir.clicks), 0) AS clicks,
					IFNULL(sum(vir.conversions), 0) AS conversions,
					'' AS device_type
				FROM
					(SELECT 
						m.interval_start AS date_time,
						m.creative_id AS ad_id,
						m.zone_id AS zone_id,
						r.viewer_id as viewer_id,
						count(request_id) AS requests,
						IFNULL(sum(m.count), 0) AS impressions,
						IFNULL(sum(c.count), 0) AS clicks,
						0 AS conversions
					FROM 
						rv_data_bkt_m AS m
					JOIN
						rv_djax_track_ad_requests AS r ON r.request_id=m.dj_request_id
					LEFT JOIN
						rv_data_bkt_c AS c ON r.request_id=c.dj_request_id AND c.interval_start BETWEEN '$start' AND '$end' 
					WHERE 
						m.interval_start BETWEEN '$start' AND '$end' 
					GROUP BY 
						date_time, ad_id, zone_id, viewer_id
					UNION
					SELECT 
						a.date_time AS date_time,
						a.creative_id AS ad_id,
						a.zone_id AS zone_id,
						r.viewer_id as viewer_id,						
						0 AS requests,
						0 AS impressions,
						0 AS clicks,
						COUNT(*) AS conversions
					FROM 
						rv_data_bkt_a AS a						
					JOIN 
						rv_djax_track_ad_requests AS r ON a.dj_request_id = r.request_id
					WHERE 
						a.date_time BETWEEN '" .$start. "' AND '" .$end. "'
					GROUP BY 
						date_time, ad_id, zone_id, viewer_id) AS vir
				GROUP BY
					vir.date_time, vir.ad_id, vir.zone_id, vir.viewer_id");
    }
}
function _uniquedataupdate($start = '', $end = '')
{
	if ($start != '' && $end != '')
    {
		$rsResult = OA_Dal_Delivery_query("SELECT 
						SUM(vir.unique_impression) AS unique_impression, 
						SUM(vir.unique_clicks) AS unique_clicks, 
						vir.ad_id as ad_id,
						vir.zone_id as zone_id,
						vir.date_time
					FROM (
										SELECT 
											COUNT( viewer_id ) AS unique_impression,
											0 AS unique_clicks,
											ad_id as ad_id,
											zone_id as zone_id,
											date_time
										FROM 
											djax_viewer_stats
										WHERE 
											date_time BETWEEN '$start' AND '$end'
											AND impressions !=0
										GROUP BY 
											ad_id, zone_id, date_time
										UNION
										SELECT 
											0 AS unique_impression,
											COUNT( viewer_id ) AS unique_clicks,
											ad_id as ad_id,
											zone_id as zone_id,
											date_time
										FROM 
											djax_viewer_stats
										WHERE 
											date_time BETWEEN '$start' AND '$end'
											AND clicks !=0
										GROUP BY 
											ad_id, zone_id, date_time) AS vir
					GROUP BY 
						vir.ad_id, vir.zone_id, vir.date_time");
						
		while ($fetch_record = OA_Dal_Delivery_fetchAssoc($rsResult))
		{
			$update_unique_imp = "UPDATE 
									rv_data_summary_ad_hourly 
								SET 
									dj_unique_impressions = '" . $fetch_record['unique_impression'] . "',
									dj_unique_clicks = '" . $fetch_record['unique_clicks'] . "'
								WHERE
								ad_id='" . $fetch_record['ad_id'] . "' AND
								zone_id='" . $fetch_record['zone_id'] . "' AND
								date_time='" . $fetch_record['date_time'] . "'";
			$rsUpdateResult    = OA_Dal_Delivery_query($update_unique_imp);
		}
	}
}
//Query to get the publisher percentage set by admin
function djax_publisher_share($zoneid) 
{
    $aConf = $GLOBALS['_MAX']['CONF'];
    $chk_pub_share = "SELECT a.dj_share_per AS dj_share_per FROM 
		rv_affiliates AS a,
		rv_zones AS z
		WHERE z.affiliateid=a.affiliateid AND z.zoneid='$zoneid'";
    $rsResult = OA_Dal_Delivery_query($chk_pub_share);
    $fetch_record = OA_Dal_Delivery_fetchAssoc($rsResult);
    if (!empty($fetch_record['dj_share_per'])) 
    {
        return $fetch_record['dj_share_per'];
    }
    else
    {
        $chk_pub_share = "SELECT pub_min_share FROM djax_app_configurations";
        $rsResult = OA_Dal_Delivery_query($chk_pub_share);
        $fetch_record = OA_Dal_Delivery_fetchAssoc($rsResult);
        return $fetch_record['pub_min_share'];
    }
}
//End of share percentage query


/*$query = OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_m 
							WHERE 
								interval_start <= '" . date('Y-m-d H:59:59', strtotime('-1 hour')) . "'
							UNION
							SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_c 
							WHERE 
								interval_start <= '" . date('Y-m-d H:59:59', strtotime('-1 hour')) . "') AS a
						ORDER BY 
							a.start_date ASC");		*/


/*Single Impression storage*/
$query =OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_m 
							WHERE 
								interval_start <='" . date('Y-m-d H:59:59') . "') AS a
						ORDER BY 
							a.start_date ASC");
while ($aRow = OA_Dal_Delivery_fetchAssoc($query)) 
{
	$djax_singleimpression=OA_Dal_Delivery_query("SELECT r.request_id,m.interval_start as datetime,m.zone_id as zoneid,r.domain as domain,r.country_name as countryname,r.region as region,r.city as city,r.zipcode as zipcode,r.user_latitude as user_latitude,r.user_longitude  as user_longitude,r.device_type as devicetype,r.carrier_name as carrier_name,r.user_agent as user_agent,v.os_version as osversion,r.operating_system as os ,r.site_url as site_url,r.browser_name as browser_name,v.ip_address as ip,r.site_referrer_url  as refererurl,v.device_model_name as device_model,m.creative_id as adid FROM `rv_djax_track_ad_requests` as r,rv_data_bkt_m as m,rv_djax_track_viewers as v where r.viewer_id=v.viewer_id and  m.dj_request_id=r.request_id and v.viewer_id=r.viewer_id and m.interval_start BETWEEN '".$aRow['start_date']."' AND  '".$aRow['end_date']."' group by request_id");

	while($results=OA_Dal_Delivery_fetchAssoc($djax_singleimpression))
	{
		$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_impression_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");

	}

}
/*Single Impression storage*/

/* Delete Detailed Impression - Before 30 days */
$imp_query=OA_Dal_Delivery_query("SELECT * FROM `rv_djax_impression_reports` WHERE date(interval_start) <= CURRENT_DATE() - INTERVAL 30 DAY");
if(OA_Dal_Delivery_numRows($imp_query)>0)
{
		OA_Dal_Delivery_query("DELETE FROM `rv_djax_impression_reports` WHERE date(interval_start) <= CURRENT_DATE() - INTERVAL 30 DAY");
}
/* Delete Detailed Impression - Before 30 days */

/*Single Click storage*/
$clickquery =OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date,count
							FROM 
								rv_data_bkt_c 
							WHERE 
								interval_start <= '" . date('Y-m-d H:59:59') . "') AS a
						ORDER BY 
							a.start_date ASC");
while ($aRow = OA_Dal_Delivery_fetchAssoc($clickquery)) 
{
	//$djax_singleclick=OA_Dal_Delivery_query("SELECT r.request_id,m.interval_start as datetime,m.zone_id as zoneid,r.domain as domain,r.country_name as countryname,r.region as region,r.city as city,r.zipcode as zipcode,r.user_latitude as user_latitude,r.user_longitude  as user_longitude,r.device_type as devicetype,r.carrier_name as carrier_name,r.user_agent as user_agent,v.os_version as osversion,r.operating_system as os ,r.site_url as site_url,r.browser_name as browser_name,v.ip_address as ip,r.site_referrer_url  as refererurl,v.device_model_name as device_model,m.creative_id as adid,m.count as count FROM `rv_djax_track_ad_requests` as r,rv_data_bkt_c as m,rv_djax_track_viewers as v where r.viewer_id=v.viewer_id and  m.dj_request_id=r.request_id and v.viewer_id=r.viewer_id and m.interval_start BETWEEN '".$aRow['start_date']."' AND  '".$aRow['end_date']."' group by request_id");
	
	$djax_singleclick=OA_Dal_Delivery_query("SELECT r.request_id,m.interval_start as datetime,m.zone_id as zoneid,r.domain as domain,r.country_name as countryname,r.region as region,r.city as city,r.zipcode as zipcode,r.user_latitude as user_latitude,r.user_longitude  as user_longitude,r.device_type as devicetype,r.carrier_name as carrier_name,r.user_agent as user_agent,v.os_version as osversion,r.operating_system as os ,r.site_url as site_url,r.browser_name as browser_name,v.ip_address as ip,r.site_referrer_url  as refererurl,v.device_model_name as device_model,m.creative_id as adid,m.count as count FROM `rv_djax_track_ad_requests` as r,rv_data_bkt_c as m,rv_djax_track_viewers as v where r.viewer_id=v.viewer_id and  m.dj_request_id=r.request_id and v.viewer_id=r.viewer_id and m.interval_start BETWEEN '".$aRow['start_date']."' AND  '".$aRow['end_date']."'");

	while($results=OA_Dal_Delivery_fetchAssoc($djax_singleclick))
	{
		if($results['count']>1)
		{
			$repeatcount=$results['count']-1;
			for($i=0;$i<=$repeatcount;$i++)
			{	
			$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_click_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");
			}
		}
		else
		{
		$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_click_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");
		}
	}

}

/*Single Click storage*/

/* Delete Detailed click - Before 30 days */
$clk_query=OA_Dal_Delivery_query("SELECT * FROM `rv_djax_click_reports` WHERE date(interval_start) <= CURRENT_DATE() - INTERVAL 30 DAY");
if(OA_Dal_Delivery_numRows($clk_query)>0)
{
		OA_Dal_Delivery_query("DELETE FROM `rv_djax_click_reports` WHERE date(interval_start) <= CURRENT_DATE() - INTERVAL 30 DAY");
}
/* Delete Detailed click - Before 30 days */

/*Single Conversion storage*/
$clickquery =OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT(DATE(date_time), ' ', HOUR( date_time  ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( date_time  ), ' ', HOUR( date_time  ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_a
							WHERE 
								date_time <= '" . date('Y-m-d H:59:59') . "') AS a
						ORDER BY 
							a.start_date ASC");
while ($aRow = OA_Dal_Delivery_fetchAssoc($clickquery)) 
{
	$djax_singleconversion=OA_Dal_Delivery_query("SELECT r.request_id, DATE_FORMAT(m.date_time, '%Y-%m-%d %H:00:00')  as datetime,m.zone_id as zoneid,r.domain as domain,r.country_name as countryname,r.region as region,r.city as city,r.zipcode as zipcode,r.user_latitude as user_latitude,r.user_longitude  as user_longitude,r.device_type as devicetype,r.carrier_name as carrier_name,r.user_agent as user_agent,v.os_version as osversion,v.operating_system as os ,r.site_url as site_url,r.browser_name as browser_name,v.ip_address as ip,r.site_referrer_url  as refererurl,v.device_model_name as device_model,m.creative_id  as adid FROM `rv_djax_track_ad_requests` as r,rv_data_bkt_a as m,rv_djax_track_viewers as v where r.viewer_id=v.viewer_id and  m.dj_request_id=r.request_id and v.viewer_id=r.viewer_id and m.date_time  BETWEEN '".$aRow['start_date']."' AND  '".$aRow['end_date']."' group by request_id");

	while($results=OA_Dal_Delivery_fetchAssoc($djax_singleconversion))
	{
		$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_conversion_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");

	}
} 
/*Single Conversion storage*/

/* Delete Detailed conversion - Before 30 days */
$conversion_query=OA_Dal_Delivery_query("SELECT * FROM `rv_djax_conversion_reports` WHERE date(interval_start) <= CURRENT_DATE() - INTERVAL 30 DAY");
if(OA_Dal_Delivery_numRows($conversion_query)>0)
{
		OA_Dal_Delivery_query("DELETE FROM `rv_djax_conversion_reports` WHERE date(interval_start) <= CURRENT_DATE() - INTERVAL 30 DAY");
}
/* Delete Detailed conversion - Before 30 days */

/*echo "SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_m 
							WHERE 
								interval_start <= '" . date('Y-m-d H:59:59') . "'
							UNION
							SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_c 
							WHERE 
								interval_start <= '" . date('Y-m-d H:59:59') . "') AS a
						ORDER BY 
							a.start_date ASC";  die();*/					
$query = OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_m 
							WHERE 
								interval_start <= '" . date('Y-m-d H:59:59') . "'
							UNION
							SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_c 
							WHERE 
								interval_start <= '" . date('Y-m-d H:59:59') . "') AS a
						ORDER BY 
							a.start_date ASC");		

$djax_admin_config = OA_Dal_Delivery_query("SELECT default_manager_share FROM djax_app_configurations");
$djax_admin_configdata = OA_Dal_Delivery_fetchAssoc($djax_admin_config);
$hour_data = array();
while ($aRow = OA_Dal_Delivery_fetchAssoc($query)) 
{	
	$sql = OA_Dal_Delivery_query("SELECT
						v.date_time,
						v.ad_id,
						v.zone_id,
						SUM(v.requests) AS requests, 
						SUM(v.dj_total_revenue) AS dj_total_revenue, 
						SUM(v.dj_publisher_revenue) AS dj_publisher_revenue, 
						SUM(v.dj_admin_revenue) AS dj_admin_revenue, 
						SUM(v.impressions) AS impressions,
						SUM(v.clicks) AS clicks,
						SUM(v.conversions) AS conversions,
						c.revenue,
						c.revenue_type,
						z.dj_floor_price,
						nm.manager_share,
						nm.default_manager,
						nm.role,
						nm.agency_id,
						v.device_type  
					FROM
						(SELECT 
							DATE_FORMAT(CONCAT(DATE(m.interval_start), ' ', HOUR(m.interval_start), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS date_time, 
							m.creative_id AS ad_id, 
							m.zone_id, 
							0 AS requests, 
							SUM(m.dj_win_bid) AS dj_total_revenue, 
							SUM(m.dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(m.dj_admin_revenue) AS dj_admin_revenue,
							SUM(m.count) AS impressions,
							0 AS clicks,
							0 AS conversions,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
							
						FROM 
							`rv_data_bkt_m` as m
						JOIN 						
							rv_djax_track_ad_requests AS r ON r.request_id = m.dj_request_id 
						
						WHERE
							m.interval_start BETWEEN '" . $aRow['start_date'] . "' AND '" . $aRow['end_date'] . "'
						GROUP BY 
							date(m.interval_start), HOUR(m.interval_start), creative_id, m.zone_id, r.device_type 
							
						UNION
						SELECT 
							DATE_FORMAT(CONCAT(DATE(c.interval_start), ' ', HOUR(c.interval_start), ':00:00'), '%Y-%m-%d %H:%i:%S') AS date_time, 
							c.creative_id AS ad_id,
							c.zone_id, 
							0 AS requests, 
							SUM(c.dj_win_bid) AS dj_total_revenue, 
							SUM(c.dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(c.dj_admin_revenue) AS dj_admin_revenue,
							0 AS impressions,
							SUM(c.count) AS clicks,
							0 AS conversions,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
						FROM 
							`rv_data_bkt_c` as c
						JOIN 						
							rv_djax_track_ad_requests AS r ON r.request_id = c.dj_request_id
						WHERE
							c.interval_start BETWEEN '" . $aRow['start_date'] . "' AND '" . $aRow['end_date'] . "'
						GROUP BY 
							date(c.interval_start) , HOUR(c.interval_start), creative_id, c.zone_id, r.device_type 
							
						UNION
						
						SELECT 
							DATE_FORMAT(CONCAT( DATE(rq.interval_start) , ' ', HOUR(rq.interval_start) , ':00:00' ), '%Y-%m-%d %H:%i:%S') AS date_time, 
							rq.creative_id AS ad_id,
							rq.zone_id, 
							SUM(rq.count) AS requests, 
							SUM(rq.dj_win_bid) AS dj_total_revenue, 
							SUM(rq.dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(rq.dj_admin_revenue) AS dj_admin_revenue,
							0 AS impressions,
							0 AS clicks,
							0 AS conversions,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
						FROM 
							`rv_data_bkt_r` as rq 
						JOIN 						
							rv_djax_track_ad_requests AS r ON r.request_id = rq.dj_request_id
						
						WHERE
							rq.interval_start BETWEEN '" . $aRow['start_date'] . "' AND '" . $aRow['end_date'] . "'
						GROUP BY
							date(rq.interval_start), HOUR(rq.interval_start), creative_id, rq.zone_id, r.device_type 
							
						UNION 
						
						SELECT 
							DATE_FORMAT(CONCAT(DATE(a.date_time), ' ', HOUR(a.date_time), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS date_time, 
							a.creative_id AS ad_id, 
							a.zone_id, 
							0 AS requests, 
							SUM(a.dj_win_bid) AS dj_total_revenue, 
							SUM(a.dj_publisher_revenue ) AS dj_publisher_revenue, 
							SUM(a.dj_admin_revenue) AS dj_admin_revenue,
							0 AS impressions,
							0 AS clicks,
							COUNT(server_conv_id) AS conversions,
							CASE
								WHEN r.`device_type` = 'web' THEN 'Display'
								WHEN r.`device_type` = 'mobile' THEN 'Mobile'
								WHEN r.`device_type` = 'tablet' THEN 'Tablet'								
							END as device_type
						FROM 
							`rv_data_bkt_a` as a 
						JOIN 						
							rv_djax_track_ad_requests AS r ON r.request_id = a.dj_request_id
						
						WHERE
							a.date_time BETWEEN '" . $aRow['start_date'] . "' AND '" . $aRow['end_date'] . "'
						GROUP BY 
							date(a.date_time), HOUR(a.date_time), creative_id, a.zone_id, r.device_type	
						) AS v 
					JOIN
						rv_banners AS b ON b.bannerid = v.ad_id
					JOIN 
						rv_campaigns AS c ON c.campaignid = b.campaignid
					JOIN
						rv_clients AS cl ON cl.clientid = c.clientid
					JOIN
						djax_network_managers AS nm ON nm.agency_id = cl.agencyid
					JOIN 
						rv_zones AS z ON z.zoneid = v.zone_id
					GROUP BY 
						v.date_time, v.ad_id, v.zone_id, v.device_type 
					ORDER BY 
						v.date_time ASC");	
				
																	
	$imp = 0;
	while ($bRow = OA_Dal_Delivery_fetchAssoc($sql)) 
    {
		$hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']] = $bRow;		
        /*if ($bRow['revenue_type'] == 1) 
        {
			$revenue = $bRow['revenue'] / 1000 * $bRow['impressions'];			
        }
        elseif ($bRow['revenue_type'] == 2) 
        {
			$revenue = $bRow['revenue'] * $bRow['clicks'];
        }
        else
        {
			$revenue = $bRow['revenue'] * $bRow['conversions'];
        }*/
        //$hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['dj_total_revenue'] = $revenue;
         
		$revenue = $hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['dj_total_revenue']; 
		
		//Publisher Share calculations.
        //$share_percentage = djax_publisher_share($bRow['zone_id']);
        //$hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['dj_publisher_earnings'] = $revenue * ($share_percentage / 100);
        
        $publisher_revenue = $hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['dj_publisher_revenue'];
        
        $admin_revenue = $hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['dj_admin_revenue'];
        
        //Network Share calculations(Admin,Manager).
        if(!empty($revenue))
        {
			$djax_spend = $revenue - $publisher_revenue;  //$revenue - $hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['dj_publisher_earnings'];        
		}
		else
		{
			$djax_spend = 0;
		}
        if ($bRow['default_manager'] == 1 && $bRow['role'] == 'ADMIN') 
        {
            $djax_manager_profit = 0;
            $adminprofit = $djax_spend;
        }
        else
        {
            $managershare = !empty($bRow['manager_share']) ? $bRow['manager_share'] : $djax_admin_configdata['default_manager_share'];
            /*Admin Share*/
            $djax_manager_profit = $djax_spend * ($managershare / 100);
            $adminprofit = $djax_spend - $djax_manager_profit;
        }
        $hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['djax_manager_profit'] = $djax_manager_profit;
        $hour_data[$bRow['date_time']][$bRow['ad_id']][$bRow['zone_id']]['adminprofit'] = $adminprofit;
    }
    
    foreach($hour_data as $hour => $ad) 
	{
		foreach($ad as $ad_id => $zone) 
		{
			foreach($zone as $zone_id => $data)
			{
				//Hourly table update
				OA_Dal_Delivery_query("INSERT INTO `rv_data_summary_ad_hourly`(`data_summary_ad_hourly_id`,`date_time`, `ad_id`, `creative_id`, `zone_id`, `requests`, `impressions`, `clicks`, `conversions`, `total_basket_value`, `total_num_items`, `total_revenue`, `total_cost`, `total_techcost`, `updated`, `dj_unique_impressions`, `dj_unique_clicks`, `dj_publisher_earnings`, `dj_delivery_media_type`, `dj_total_revenue`,`dj_admin_revenue`) VALUES (NULL,'" . $hour . "','" . $ad_id ."','" . $ad_id . "','" . $zone_id . "','" . $data['requests'] ."','" . $data['impressions'] . "','" . $data['clicks'] ."','" . $data['conversions'] . "','0','0','0','0','0',now(),0,0,'" . $data['dj_publisher_revenue'] . "','".$data['device_type']."','" . $data['dj_total_revenue'] . "','".$data['dj_admin_revenue']."')");
				
				//Network statistics update
				OA_Dal_Delivery_query("INSERT INTO djax_network_stats (`date_time`, `agency_id`, `ad_id`, `zone_id`, `requests`, `impressions`, `clicks`, `conversions`, `advertiser_spend`, `publisher_share`,network_revenue, admin_revenue) 
					 VALUES ('" . $hour . "', '" . $data['agency_id'] . "', 
					 '" . $data['ad_id'] . "', '" . $data['zone_id'] . "', '" . $data['requests'] . "', 
					'" . $data['impressions'] . "', '" . $data['clicks'] . "', '" . $data['conversions'] . "',
					'" . $data['dj_total_revenue'] . "', 
					'" . $data['dj_publisher_revenue'] . "', '" . $data['djax_manager_profit'] . "','" . $data['adminprofit'] . "')");
			}
		}
	
	$hour_data = array();
	
    //Browser statistics
    djax_browser_statistics($aRow['start_date'], $aRow['end_date']);
    //Client statistics
    djax_client_statistics($aRow['start_date'], $aRow['end_date']);
    //Site statistics
    djax_site_statistics($aRow['start_date'], $aRow['end_date']);
    //Device statistics
	djax_vast_statistics($aRow['start_date'], $aRow['end_date']);
  
    djax_device_statistics($aRow['start_date'], $aRow['end_date']);
    //Anti-fraud Statistics
    updateantifraud($aRow['start_date'], $aRow['end_date']);
    //Geo Statistics   
    djax_geo_statistics($aRow['start_date'], $aRow['end_date']);
    //Viewer Statistics
    djax_viewer_statistics($aRow['start_date'], $aRow['end_date']);
    //Updating Unique impressions
    _uniquedataupdate($aRow['start_date'], $aRow['end_date']);
    OA_Dal_Delivery_query("DELETE FROM `rv_data_bkt_m` WHERE interval_start ='" . $aRow['start_date'] . "'");
	OA_Dal_Delivery_query("DELETE FROM `rv_data_bkt_c` WHERE interval_start ='" . $aRow['start_date'] . "'");
	OA_Dal_Delivery_query("DELETE FROM `rv_data_bkt_a` WHERE date_time BETWEEN '" . $aRow['start_date'] . "' AND '" . $aRow['end_date'] . "'");
	OA_Dal_Delivery_query("DELETE FROM `rv_data_bkt_r` WHERE interval_start ='" . $aRow['start_date'] . "'");
	OA_Dal_Delivery_query("DELETE FROM `rv_data_bkt_vast_e` WHERE interval_start ='" . $aRow['start_date'] . "'");
	}
}

 
/////campaign completed mail///////

 $type_query = "select message_type,network_account_id from djax_app_configurations";
 $type_result = OA_Dal_Delivery_query($type_query);
 $type_results_ads = OA_Dal_Delivery_fetchAssoc($type_result);
$camapign_query = "SELECT camp.clientid,camp.campaignname,client.account_id,client.email ,camp.revenue, camp.expire_time, camp.campaignid, camp.dj_campaign_budget, camp.dj_daily_budget, camp.dj_campaign_remain_budget, camp.dj_campaign_remain_total_budget,client.account_id,client.clientname,client.dj_added_date,camp.mail_status,camp.camp_mail_status 
FROM `rv_campaigns` AS camp
JOIN `rv_clients` AS client
WHERE STATUS =0
AND camp.clientid = client.clientid
AND camp.dj_is_deleted =0
AND camp.clientid !=1
AND DATE_ADD(expire_time, INTERVAL -1 DAY) = CURDATE() 
ORDER BY camp.campaignid";

$res=OA_Dal_Delivery_query($camapign_query); 
$eod = date('Y-m-d 23:59:59');

while($results=OA_Dal_Delivery_fetchAssoc($res))
{
	
	//$res=OA_Dal_Delivery_query($camapign_query); 
	$admin_set = 1;	
	$db = 'select * from djax_adv_pub_notification_settings where account_id='.$results['account_id'];
	$jb = OA_Dal_Delivery_query($db);
	$djax_adv_pub  = OA_Dal_Delivery_fetchAssoc($jb);
	$enable_disable = $djax_adv_pub['msg_adv_pub_enable'];
	$app_config = 'select * from djax_app_configurations';
	$config_query = OA_Dal_Delivery_query($app_config);
	$data_config  = OA_Dal_Delivery_fetchAssoc($config_query);
	if($data_config['adv_pub_msg'] == 'enable')
	{
	if($enable_disable)
	{
	$string = 'camp_comp';
				
	if(strpos($djax_adv_pub['campaigns'],$string)!== false)
	{
	$msg_type = $djax_adv_pub['msg_type'];
	}
	else{
	$msg_type = null;
		}
			   
	}
	else{
		$msg_type = null;
	}
			
	}
	else{
		$msg_type = $data_config['message_type'];
	}
	
		//echo $msg_type;exit;
	
$eod = date('Y-m-d'); 
$newdate=strtotime('-1 day', strtotime($results['expire_time']));

$gddate = date('Y-m-d',$newdate);

if($results['expire_time'] != '' && $results['expire_time'] !=NULL ) {
if((strtotime($eod)==strtotime(date('Y-m-d',strtotime($gddate))) )&& $results['camp_mail_status']!=1)
{
	
	if($type_results_ads['message_type']=='email' || $type_results_ads['message_type']=='both')
	{
	$mail='';
	$from_add = "admin@adgate.com"; 
	$to_add = $results['email']; 
	$subject = "Warning: campaign will be expired tomorrow";
	$message = "Hi,\nYour campaign is going to get expired,\nCampaign Expire date:".$results['expire_time']."\nExtend your campaign date else your ad will not get deliver";
	$headers = "From: $from_add \r\n";
	$headers .= "Reply-To: $from_add \r\n";
	$headers .= "Return-Path: $from_add\r\n";
	$headers .= "X-Mailer: PHP \r\n";
	if(mail($to_add,$subject,$message,$headers)) 
	{
		$mail='sent';
	} 
	else{
		
	}
	}
	
	
	/*else 
	{
 	   //$update_camp = "update rv_campaigns set camp_mail_status=1 where campaignid=".$results['campaignid'];
		//OA_Dal_Delivery_query($update_camp); 
	}*/
	
	if($type_results_ads['message_type']=='both' || $type_results_ads['message_type']=='msg')
	{
		 
		
		$msg_query1 = "insert into djax_messages (sender_id,receiver_id,subject,content,image_name,file_name,account_type,status,network_id,date) values('2','" . $results['account_id'] . "','Warning campaign is going to get completed','Your campaign campaign is goin to get expired,Extend your campaign date else ad will not get delivered<br><br> Client Name = " . $results['clientname'] . "<br><br> Campaign Name =" . $results['campaignname'] . "<br><br> Created Date =" . date('Y-m-d',strtotime($results['dj_added_date'])) . "',NULL,NULL,'ADVERTISER','1','" . $type_results_ads['network_account_id'] . "','" . date('Y-m-d H:i:s') . "')";
		
		$msg_query=OA_Dal_Delivery_query($msg_query1); 
		//print_r($msg_query1);exit;
		if($msg_query)
		{
		$mail='sent';
		
		}
		else{
		}
	}
	
	if($mail=='sent')
	{
	$update_camp = "update rv_campaigns set camp_mail_status=1 where campaignid=".$results['campaignid'];
		OA_Dal_Delivery_query($update_camp); 
	}
	
}  	

}				
			
}
	
echo 'Cron has been run successfully.';


	



