<?php
// Require the initialisation file
$path = dirname(__FILE__);
require_once $path . '/../../init.php';
function OX_Delivery_logMessage($message, $priority = 6) 
{
    $conf = $GLOBALS['_MAX']['CONF'];
    if (empty($conf['deliveryLog']['enabled'])) return true;
    $priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
    if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) 
    {
        return true;
    }
    error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
    OX_Delivery_Common_hook('logMessage', array(
        $message,
        $priority
    ));
    return true;
}
function OX_Delivery_Common_hook($hookName, $aParams = array() , $functionName = '') 
{
    $return = null;
    if (!empty($functionName)) 
    {
        $aParts = explode(':', $functionName);
        if (count($aParts) === 3) 
        {
            $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
        }
        if (function_exists($functionName)) 
        {
            $return = call_user_func_array($functionName, $aParams);
        }
    }
    else
    {
        if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) 
        {
            $return = array();
            $hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
            foreach ($hooks as $identifier) 
            {
                $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
                if (function_exists($functionName)) 
                {
                    OX_Delivery_logMessage('calling on ' . $functionName, 7);
                    $return[$identifier] = call_user_func_array($functionName, $aParams);
                }
            }
        }
    }
    return $return;
}
function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null) 
{
    $aInfo = explode(':', $identifier);
    $functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
    if (!function_exists($functionName)) 
    {
        if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
        if (!function_exists($functionName)) 
        {
            _includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
            if (!function_exists($functionName)) 
            {
                _includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
                $functionName = 'Plugin_' . $aInfo[0] . '_delivery';
                if (!empty($hook) && function_exists($functionName . '_' . $hook)) 
                {
                    $functionName.= '_' . $hook;
                }
            }
        }
    }
    return $functionName;
}
function _includeDeliveryPluginFile($fileName) 
{
    if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) 
    {
        $GLOBALS['_MAX']['FILES'][$fileName] = true;
        if (file_exists(MAX_PATH . $fileName)) 
        {
            include MAX_PATH . $fileName;
        }
    }
}
function MAX_Dal_Delivery_Include() 
{
    static $included;
    if (isset($included)) 
    {
        return;
    }
    $included = true;
    $conf = $GLOBALS['_MAX']['CONF'];
    if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) 
    {
        require (MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
    }
    else
    {
        require (MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
    }
}
MAX_Dal_Delivery_Include();
if (!empty($conf['debug']['production']))
{
	error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
}
else
{
	error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
}
//Setting up for unlimited time.
set_time_limit (0);
/*Single Impression storage*/
/*
$query =OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_m 
							WHERE 
								interval_start <= '2016-10-21 09:00:00') AS a
						ORDER BY 
							a.start_date ASC");
while ($aRow = OA_Dal_Delivery_fetchAssoc($query)) 
{
	$djax_singleimpression=OA_Dal_Delivery_query("SELECT r.request_id,m.interval_start as datetime,m.zone_id as zoneid,r.domain as domain,r.country_name as countryname,r.region as region,r.city as city,r.zipcode as zipcode,r.user_latitude as user_latitude,r.user_longitude  as user_longitude,r.device_type as devicetype,r.carrier_name as carrier_name,r.user_agent as user_agent,v.os_version as osversion,v.os  as os ,r.site_url as site_url,r.browser_name as browser_name,v.ip_address as ip,r.site_referrer_url  as refererurl,v.device_model_name as device_model,m.creative_id as adid FROM `rv_djax_track_ad_requests` as r,rv_data_bkt_m as m,rv_djax_track_viewers as v where r.viewer_id=v.viewer_id and  m.dj_request_id=r.request_id and v.viewer_id=r.viewer_id and m.interval_start BETWEEN '".$aRow['start_date']."' AND  '".$aRow['end_date']."' group by request_id");

	while($results=OA_Dal_Delivery_fetchAssoc($djax_singleimpression))
	{
		$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_impression_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");

	}

}
/*Single Impression storage*/

/*Single Click storage*//*
$clickquery =OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( interval_start ), ' ', HOUR( interval_start ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date,count
							FROM 
								rv_data_bkt_c 
							WHERE 
								interval_start <= '2016-10-21 09:00:00') AS a
						ORDER BY 
							a.start_date ASC");
while ($aRow = OA_Dal_Delivery_fetchAssoc($clickquery)) 
{
	$djax_singleclick=OA_Dal_Delivery_query("SELECT r.request_id,m.interval_start as datetime,m.zone_id as zoneid,r.domain as domain,r.country_name as countryname,r.region as region,r.city as city,r.zipcode as zipcode,r.user_latitude as user_latitude,r.user_longitude  as user_longitude,r.device_type as devicetype,r.carrier_name as carrier_name,r.user_agent as user_agent,v.os_version as osversion,v.os  as os ,r.site_url as site_url,r.browser_name as browser_name,v.ip_address as ip,r.site_referrer_url  as refererurl,v.device_model_name as device_model,m.creative_id as adid,m.count as count FROM `rv_djax_track_ad_requests` as r,rv_data_bkt_c as m,rv_djax_track_viewers as v where r.viewer_id=v.viewer_id and  m.dj_request_id=r.request_id and v.viewer_id=r.viewer_id and m.interval_start BETWEEN '".$aRow['start_date']."' AND  '".$aRow['end_date']."' group by request_id");

	while($results=OA_Dal_Delivery_fetchAssoc($djax_singleclick))
	{
		if($results['count']>1)
		{
			$repeatcount=$results['count']-1;
			for($i=0;$i<=$repeatcount;$i++)
			{	
			$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_click_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");
			}
		}
		else
		{
		$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_click_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");
		}
	}

}
*/
/*Single Click storage*/

/*Single Conversion storage*/
$clickquery =OA_Dal_Delivery_query("SELECT 
							DISTINCT a.start_date, a.end_date 
						FROM
							(SELECT 
								DISTINCT DATE_FORMAT(CONCAT(DATE(date_time), ' ', HOUR( date_time  ), ':00:00' ), '%Y-%m-%d %H:%i:%S') AS start_date, 
								DATE_FORMAT(CONCAT( DATE( date_time  ), ' ', HOUR( date_time  ), ':59:59' ), '%Y-%m-%d %H:%i:%S') AS end_date 
							FROM 
								rv_data_bkt_a
							WHERE 
								date_time <= '2016-10-22 09:00:00') AS a
						ORDER BY 
							a.start_date ASC");
while ($aRow = OA_Dal_Delivery_fetchAssoc($clickquery)) 
{
	$djax_singleconversion=OA_Dal_Delivery_query("SELECT r.request_id, DATE_FORMAT(m.date_time, '%Y-%m-%d %H:00:00')  as datetime,m.zone_id as zoneid,r.domain as domain,r.country_name as countryname,r.region as region,r.city as city,r.zipcode as zipcode,r.user_latitude as user_latitude,r.user_longitude  as user_longitude,r.device_type as devicetype,r.carrier_name as carrier_name,r.user_agent as user_agent,v.os_version as osversion,v.os  as os ,r.site_url as site_url,r.browser_name as browser_name,v.ip_address as ip,r.site_referrer_url  as refererurl,v.device_model_name as device_model,m.creative_id  as adid FROM `rv_djax_track_ad_requests` as r,rv_data_bkt_a as m,rv_djax_track_viewers as v where r.viewer_id=v.viewer_id and  m.dj_request_id=r.request_id and v.viewer_id=r.viewer_id and m.date_time  BETWEEN '".$aRow['start_date']."' AND  '".$aRow['end_date']."' group by request_id");

	while($results=OA_Dal_Delivery_fetchAssoc($djax_singleconversion))
	{
		$singleimpression=OA_Dal_Delivery_query("INSERT INTO `rv_djax_conversion_reports` (`interval_start`, `zoneid`, `domain`, `ip`, `country_name`, `region`, `city`, `zipcode`, `user_latitude`, `user_longitude`, `device_type`, `carrier_name`, `user_agent`, `os_version`, `os`, `site_url`, `sitereferurl`,adid,browsername,device_model) VALUES ('".$results['datetime']."','".$results['zoneid']."','".$results['domain']."','".$results['ip']."','".$results['countryname']."','".$results['region']."','".$results['city']."','".$results['zipcode']."', '".$results['user_latitude']."', '".$results['user_longitude']."', '".$results['devicetype']."', '".$results['carrier_name']."','".$results['user_agent']."','".$results['osversion']."','".$results['os']."','".$results['site_url']."','".$results['refererurl']."','".$results['adid']."','".$results['browser_name']."','".$results['device_model']."');");

	}
} 
/*Single Conversion storage*/

?>


































