<?php  
     $path = dirname(__FILE__);
     require_once $path . '/../../init.php';
	 date_default_timezone_set('Europe/Amsterdam');

		function OX_Delivery_logMessage($message, $priority = 6) 
		{
			$conf = $GLOBALS['_MAX']['CONF'];
			if (empty($conf['deliveryLog']['enabled'])) return true;
			$priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
			if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) {
				return true;
			}
			error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
			OX_Delivery_Common_hook('logMessage', array(
				$message,
				$priority
			));
			return true;
		}

		function OX_Delivery_Common_hook($hookName, $aParams = array(), $functionName = '')
		{
			$return = null;
			if (!empty($functionName)) {
				$aParts = explode(':', $functionName);
				if (count($aParts) === 3) {
					$functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
				}
				if (function_exists($functionName)) {
					$return = call_user_func_array($functionName, $aParams);
				}
			} else {
				if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) {
					$return = array();
					$hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
					foreach ($hooks as $identifier) {
						$functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
						if (function_exists($functionName)) {
							OX_Delivery_logMessage('calling on ' . $functionName, 7);
							$return[$identifier] = call_user_func_array($functionName, $aParams);
						}
					}
				}
			}
			return $return;
		}

		function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null)
		{
			$aInfo = explode(':', $identifier);
			$functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
			if (!function_exists($functionName)) {
				if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
				if (!function_exists($functionName)) {
					_includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
					if (!function_exists($functionName)) {
						_includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
						$functionName = 'Plugin_' . $aInfo[0] . '_delivery';
						if (!empty($hook) && function_exists($functionName . '_' . $hook)) {
							$functionName .= '_' . $hook;
						}
					}
				}
			}
			return $functionName;
		}

		function _includeDeliveryPluginFile($fileName)
		{
			if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) {
				$GLOBALS['_MAX']['FILES'][$fileName] = true;
				if (file_exists(MAX_PATH . $fileName)) {
					include MAX_PATH . $fileName;
				}
			}
		}

		function MAX_Dal_Delivery_Include()
		{
			static $included;
			if (isset($included)) {
				return;
			}
			$included = true;
			$conf = $GLOBALS['_MAX']['CONF'];
			if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) {
				require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
			} else {
				require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
			}
		}
		MAX_Dal_Delivery_Include();
		if (!empty($conf['debug']['production'])) {
			error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
		} else {
			error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
		}
		//Setting up for unlimited time.
		set_time_limit(0);
 
	/* Rename Filenames Every one hours Once */
	//$i="24187891483843471";		
	$i="24187891483843498";
	$files=array();
	$current_time = (date("d-m-Y H:i:s",time()));
	foreach (glob("/data4/ads/www/delivery/*.php") as $file)
	{
		$file_val=rtrim($file,".php");
		$last_digit=substr($file_val, -3);
		if(is_numeric($last_digit))
		{	
			$files[$last_digit]=$file;
		}		
	}	
	/*$lastdigit=array('471'=>'W_BAN','472'=>'W_TEXT','473'=>'V_A_IN','474'=>'V_A_OL','475'=>'V_A_RD','476'=>'V_A_SM','477'=>'V_A_BOX','478'=>'V_A_HEAD','479'=>'W_A_PUN','480'=>'W_A_LAY','481'=>'W_A_GB','482'=>'W_A_BB','483'=>'W_A_SL','484'=>'W_A_CF','485'=>'W_A_SS','486'=>'W_TB','487'=>'W_A_INTT','488'=>'W_A_NAT','489'=>'M_A_INT','490'=>'M_A_EXD','491'=>'M_A_RVL','492'=>'M_A_DLG','493'=>'M_A_NF','494'=>'M_A_FX','495'=>'M_A_AD','496'=>'M_A_FS','497'=>'M_A_PULL','498'=>'LOG','499'=>'CLK','500'=>'CONV');	$random_array=array('W_BAN'=>$i,'W_TEXT'=>$i+1,'V_A_IN'=>$i+2,'V_A_OL'=>$i+3,'V_A_RD'=>$i+4,'V_A_SM'=>$i+5,'V_A_BOX'=>$i+6,'V_A_HEAD'=>$i+7,'W_A_PUN'=>$i+8,'W_A_LAY'=>$i+9,'W_A_GB'=>$i+10,'W_A_BB'=>$i+11,'W_A_SL'=>$i+12,'W_A_CF'=>$i+13,'W_A_SS'=>$i+14,'W_TB'=>$i+15,'W_A_INTT'=>$i+16,'W_A_NAT'=>$i+17,'M_A_INT'=>$i+18,'M_A_EXD'=>$i+19,'M_A_RVL'=>$i+20,'M_A_DLG'=>$i+21,'M_A_NF'=>$i+22,'M_A_FX'=>$i+23,'M_A_AD'=>$i+24,'M_A_FS'=>$i+25,'M_A_PULL'=>$i+26,'LOG'=>$i+27,'CLK'=>$i+28,'CONV'=>$i+29);	$content=array('W_BAN'=>'banners','W_TEXT'=>'text','V_A_IN'=>'inlinevideo','V_A_OL'=>'overlayvideo','V_A_RD'=>'readvideo','V_A_SM'=>'smallvideo','V_A_BOX'=>'boxvideo','V_A_HEAD'=>'headvideo','W_A_PUN'=>'popup','W_A_LAY'=>'layer','W_A_GB'=>'gamebox','W_A_BB'=>'bannerbox','W_A_SL'=>'slider','W_A_CF'=>'catfish','W_A_SS'=>'siteskin','W_TB'=>'topbar','W_A_INTT'=>'webinter','W_A_NAT'=>'native','M_A_INT'=>'intertial','M_A_EXD'=>'expand','M_A_RVL'=>'reveal','M_A_DLG'=>'dialog','M_A_NF'=>'notification','M_A_FX'=>'fullpageflex','M_A_AD'=>'adhension','M_A_FS'=>'flimstrip','M_A_PULL'=>'mobilepull','LOG'=>'logger','CLK'=>'click','CONV'=>'conversion');
	*/
	
	$lastdigit=array('498'=>'LOG','499'=>'CLK','500'=>'CONV');
	$random_array=array('LOG'=>$i,'CLK'=>$i+1,'CONV'=>$i+2);
	$content=array('LOG'=>'logger','CLK'=>'click','CONV'=>'conversion');	
	
		foreach ($files as $key=>$val)
		{ 
			if(array_key_exists($key,$lastdigit))
			{  
				$suffle = str_shuffle($content[$lastdigit[$key]]); 
				$file_name=md5(base64_encode($suffle)).$random_array[$lastdigit[$key]].".php"; 
				$filename="/data4/ads/www/delivery/".$file_name;					
				rename($files[$key],$filename);  
			}
		$update_query=OA_Dal_Delivery_query("UPDATE djax_filenames SET crypted_filename='".$file_name."',updated_time='".$current_time."' WHERE zone_type='$lastdigit[$key]'");
		/* update config file one hour once*/
			if($lastdigit[$key]=="LOG")
			{ 
			$config_name = "/data4/ads/var/www.adgate.com.conf.php";
			$fhandle = fopen($config_name,"r") or die("error");
			$content = fread($fhandle,filesize($config_name));
			$data   = file_get_contents($config_name); 	
			$lines = explode("\n", $data);
			$line_no=explode("=",$lines[81]);
			$exist_log_name=$line_no[1];
			$new_log_name='"'.$file_name.'"';  
			$content = str_replace($exist_log_name,$new_log_name,$content);
			$fhandle = fopen($config_name,"w"); 
			fwrite($fhandle,$content);
			fclose($fhandle);
			}
			if($lastdigit[$key]=="CLK")
			{  
			$config_name = "/data4/ads/var/www.adgate.com.conf.php";
			$fhandle = fopen($config_name,"r") or die("error");
			$content = fread($fhandle,filesize($config_name));
			$data   = file_get_contents($config_name); 	
			$lines = explode("\n", $data);
			$line_no=explode("=",$lines[70]);		
			$exist_log_name=$line_no[1];
			$new_log_name='"'.$file_name.'"';  
			$content = str_replace($exist_log_name,$new_log_name,$content);
			$fhandle = fopen($config_name,"w"); 
			fwrite($fhandle,$content);
			fclose($fhandle);	  		  
			}
			if($lastdigit[$key]=="CONV")
			{ 
			$config_name = "/data4/ads/var/www.adgate.com.conf.php";
			$fhandle = fopen($config_name,"r") or die("error");
			$content = fread($fhandle,filesize($config_name));
			$data   = file_get_contents($config_name); 	
			$lines = explode("\n", $data);
			$line_no=explode("=",$lines[73]);		
			$exist_log_name=$line_no[1];
			$new_log_name='"'.$file_name.'"';  
			$content = str_replace($exist_log_name,$new_log_name,$content);
			$fhandle = fopen($config_name,"w"); 
			fwrite($fhandle,$content);
			fclose($fhandle);			
			}
		}		
	
?>
