<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    Plugin
 * @subpackage openxDeliveryLog
 */

MAX_Dal_Delivery_Include();

/**
 * A function to log conversions.
 *
 * @param integer $trackerId The ID of the tracker for which the conversion is to be logged.
 * @param array $serverRawIp The "raw IP address" value to use for the conversion.
 * @param array $aConversion An array of the conversion details, as returned from the
 *                           MAX_trackerCheckForValidAction() function.
 * @return array An array...
 */
function Plugin_deliveryLog_oxLogConversion_logConversion_Delivery_logConversion($trackerId, $serverRawIp, $aConversion, $okToLog = true)
{
    if (!$okToLog) { return false; }
    // Initiate the connection to the database (before using mysql_real_escape_string)
 	OA_Dal_Delivery_connect('rawDatabase');
	mail('vanitha.v@dreamajax.com',"sub","test mail");
	
	$table = $GLOBALS['_MAX']['CONF']['table']['prefix'] . 'data_bkt_a';
	
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

    if (empty($GLOBALS['_MAX']['NOW'])) {
        $GLOBALS['_MAX']['NOW'] = time();
    }
			   $time = $GLOBALS['_MAX']['NOW'];

			   $tracker_parameter=$aConversion['cid'].'_'. $aConversion['zid']; 
			   
			  // print_r($_COOKIE);
			   			   		
			   $request_id=$_COOKIE['OXLCR'][$tracker_parameter];
			   
			    //print_r($request_id);  die("test"); 
	  
			
	            $djax_win_bid_cpa=djax_win_bid_cpa($aConversion['cid']);	
	
				/* Special bidding options */
				$traffic_bid_rate=0;
				$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from ".$table_prefix."affiliates as oxa join ".$table_prefix."zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$aConversion['zid'].") AND campaign_id IN (select campaignid from ".$table_prefix."banners where bannerid=".$aConversion['cid'].")";
				$special_bidding=OA_Dal_Delivery_query($traffic_query);
				$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
				$traffic_bid_rate=$traffic_result['bid_rate']; 
				
														
			    /* Countrywise bidding based on the campaign */	
				$country_val=$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
				
				
				if(!empty($traffic_bid_rate))
				{
					$djax_win_bid_cpa['win_bid_amount']=$traffic_bid_rate;
				}							
							
	/* Special bidding options and countrywise bidding - End*/       
	
  	if($aConversion['zid']==0 || empty($aConversion['zid']))
	{
	   		$zonequery=OA_Dal_Delivery_query("SELECT zone_id FROM djax_track_ad_requests WHERE request_id ='".$request_id."'")or die("SELECT query djax_track_ad_requests");
			$rowzoneid=OA_Dal_Delivery_fetchAssoc($zonequery);
			$aConversion['zid']= $rowzoneid['zone_id'];
	}
		
	/* DAC020 - Find the campaign type */
	$campaign_type=OA_Dal_Delivery_query("Select revenue_type FROM ".$GLOBALS['_MAX']['CONF']['table']['prefix']."campaigns as c join ".$GLOBALS['_MAX']['CONF']['table']['prefix']."banners as b ON b.campaignid=c.campaignid where b.bannerid=".$aConversion['cid']);
	$camp_type=OA_Dal_Delivery_fetchAssoc($campaign_type);
	$cam_type=$camp_type['revenue_type'];
	
	/* DAC020 - Tracker */
	$tracker_type=OA_Dal_Delivery_query("Select pixel_category,pixel_goal FROM ".$GLOBALS['_MAX']['CONF']['table']['prefix']."trackers as t join ".$GLOBALS['_MAX']['CONF']['table']['prefix']."campaigns_trackers as ct ON ct.trackerid=t.trackerid where t.trackerid=".$trackerId);
	$track_type=OA_Dal_Delivery_fetchAssoc($tracker_type);
	$track_con_type=$track_type['pixel_category'];
	$pixel_goal=$track_type['pixel_goal'];
				
	if($cam_type=='3')
	{   
		$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='3' AND country_value='$country_val'";								
		$special_country_bidding=OA_Dal_Delivery_query($country_query);
		$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
		$country_bid_rate=$bidding_result['bidding_value']; 
		
		if(!empty($country_bid_rate))
		{
			$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;
			
		}
		else		
		{		
			if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
			{
				$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
			}
		}
		OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");		
	}
	elseif($cam_type=='4')
	{   
		if($track_con_type=="lead")
		{
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='4' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 		
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
			OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");
		}
		else
		{
			return false;
		}
	}	
	elseif($cam_type=='5')
	{
		if($track_con_type=="sale")
		{		
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='5' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 		
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
			OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");		
		}
		else
		{
			return false;
		}	
	}	
	elseif($cam_type=='6')
	{
		
		if($track_con_type=="install")
		{		
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='6' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 		
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
			OA_Dal_Delivery_query("update djax_track_ad_requests set bidding_price='".$djax_win_bid_cpa['win_bid_amount']."' where request_id='".$request_id."'") or die("update_error");		
		}	
		else
		{
			return false;
		}
	}	
	
	if(!empty($djax_win_bid_cpa))
	{
	    djax_detect_spent_amt_cpa($djax_win_bid_cpa);
	}
	
	$publisher_percentage=djax_publisher_share($aConversion['zid']);
	
	$publisershare=$djax_win_bid_cpa['win_bid_amount']*($publisher_percentage/100);
	
	$admin_revenue=$djax_win_bid_cpa['win_bid_amount']-$publisershare;
	
	$aValues = array(
        'server_ip'        => $serverRawIp,
        'tracker_id'       => (int)$trackerId,
        'date_time'        => gmdate('Y-m-d H:i:s', $time),
        'action_date_time' => gmdate('Y-m-d H:i:s', $aConversion['dt']),
        'creative_id'      => (int)$aConversion['cid'],
        'zone_id'          => (int)$aConversion['zid'],
		'dj_request_id'    => $request_id,
		'dj_win_bid'	   => $djax_win_bid_cpa['win_bid_amount'],
		'dj_publisher_revenue'=>$publisershare,
        'ip_address'       => $_SERVER['REMOTE_ADDR'],
        'action'           => $aConversion['action_type'],
        'window'           => $aConversion['window'],
        'status'           => $aConversion['status'],
        'dj_admin_revenue' => $admin_revenue,
        'action_type'  	   => $aConversion['category']
    	);
		
    // Need to also escape identifier as "window" is reserved since PgSQL 8.4
    $aFields = array_map('OX_escapeIdentifier', array_keys($aValues));
    $aValues = array_map('OX_escapeString', $aValues);

	$query = "
        INSERT INTO
            {$table}
            (" . implode(', ', $aFields) . ")
        VALUES
            ('" . implode("', '", $aValues) . "')";
			
			
    $result = OA_Dal_Delivery_query($query, 'rawDatabase');
		    
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

	$campaig_Qry=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT c.revenue_type as revenue_type FROM ".$table_prefix."campaigns as c,".$table_prefix."banners as b WHERE b.bannerid='".$aConversion['cid']."' AND b.campaignid=c.campaignid "));
										
	if($campaig_Qry['revenue_type']==3)
	{
	
	if(!isset($_COOKIE["last_conv_".$aConversion['cid']]))
	{
		setcookie("last_conv_".$aConversion['cid'],$aConversion['cid'],time()+60*60*24*30);				
	}	
	
	if(!empty($_COOKIE))
	{
	
		$explode_cookie=implode(',',$_COOKIE);		
	
		$exploded_array=explode(',',$explode_cookie);
		
		$i=1;
		foreach($exploded_array as $val)
		{
			
			$retarget_val=explode('__',$val);
			
			if($retarget_val[0]=="retarget")
			{
				
				$array_cookie[$i]=$retarget_val[1];
				$i++;
			}			
			
		}
		if(!empty($array_cookie))
		{
				if(in_array($aConversion['cid'],$array_cookie))
				{	
						unset($_COOKIE["retarget_".$aConversion['cid']]);	
						setcookie("retarget_".$aConversion['cid'],"retarget__".$aConversion['cid'],time()-60*60*24*30);
			
				}
		}
	}	

	}
 
    	if (!$result)
	{
        return false;
    }
    $aResult = array(
        'server_conv_id' => OA_Dal_Delivery_insertId('rawDatabase', $table, 'server_conv_id'),
        'server_raw_ip' => $serverRawIp
    );
    return $aResult;
}
 	function djax_publisher_share($zoneid)
	{
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		if($zoneid!=0)
		{
	
		$chk_pub_share="select a.dj_share_per as dj_share_per from 
		
		".$aConf['table']['prefix'].$aConf['table']['affiliates']." AS a,
		".$aConf['table']['prefix'].$aConf['table']['zones']." AS z
		
		where z.affiliateid=a.affiliateid and z.zoneid='$zoneid'";
		
		$rsResult = OA_Dal_Delivery_query($chk_pub_share);
					       
		$fetch_record=OA_Dal_Delivery_fetchAssoc($rsResult);
					
		if(!empty($fetch_record['dj_share_per']))
		{
							return $fetch_record['dj_share_per'];
		}
		else
		{
							$chk_pub_share="select pub_min_share from ".$aConf['table']['djax_app_configurations']."";
		
							$rsResult = OA_Dal_Delivery_query($chk_pub_share);
						
							$fetch_record=OA_Dal_Delivery_fetchAssoc($rsResult);
						
							return $fetch_record['pub_min_share'];
			}
		}
		else
		{
			return 0;
		}
		
	}
function djax_win_bid_cpa($ad_id)
{
		$aConf = $GLOBALS['_MAX']['CONF'];

		$query="select c.revenue as win_bid_amount,c.clientid as clientid,c.campaignid as campaignid,c.dj_campaign_remain_budget as dj_campaign_remain_budget,c.dj_campaign_remain_total_budget as dj_campaign_remain_total_budget from  
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  AS c,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])."  AS b
		where b.bannerid='$ad_id' and  c.revenue_type IN ('3','4','5','6') and b.campaignid=c.campaignid";

		$rAdResponse=OA_Dal_Delivery_query($query);

		$result=OA_Dal_Delivery_fetchAssoc($rAdResponse);
		
		return $result;
}

function djax_detect_spent_amt_cpa($results)
{
	
		$aConf = $GLOBALS['_MAX']['CONF'];

		$status='and dj_is_default!=1';
		
		$query="select dj_cur_balance,dj_is_default from
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." 
		where clientid='".$results['clientid']."' $status";

		$rAdResponse=OA_Dal_Delivery_query($query);

		if(OA_Dal_Delivery_numRows($rAdResponse) > 0)
		{
			$res=OA_Dal_Delivery_fetchAssoc($rAdResponse);
		
			if($res['dj_cur_balance']>0)
			{
				$current_balance=$res['dj_cur_balance'] - $results['win_bid_amount'];
				
				$remain_balance=$results['dj_campaign_remain_budget']+$results['win_bid_amount'];
				
				$remain_total_balance=$results['dj_campaign_remain_total_budget']+$results['win_bid_amount'];
				
				$budget = OA_Dal_Delivery_query("SELECT dj_campaign_budget,dj_daily_budget FROM 
				".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
				where campaignid='".$results['campaignid']."'");
				
				$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);

				$campaign_budget = $fetch_budget['dj_campaign_budget'];

				$campaign_daily_budget = $fetch_budget['dj_daily_budget'];
				
				$campaign_remaining_budget = $campaign_budget - $remain_total_balance;

				$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance;


				if($campaign_remaining_budget > 0 && $campaign_remaining_daily_budget > 0)
				{			
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance' where campaignid='".$results['campaignid']."'");
					
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'");
					
					if($res['dj_is_default']!='2')
					{	
						OA_Dal_Delivery_query("update 
						".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])."  
						set dj_cur_balance='$current_balance' where clientid='".$results['clientid']."'");
					}
				}
				else
				{
					if($campaign_remaining_budget <= 0)
					{
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=3 where campaignid='".$results['campaignid']."'") or die("error");

					}
					
					if($campaign_remaining_daily_budget <= 0)
					{
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=8 where campaignid='".$results['campaignid']."'") or die("error");

					}
				}
			}
			//*******************************Update conversion in rv_campaign table and to send mail on reaching conversion limit****************************************//
			
			
			//select conversion_count from rv_campaigns
			$rsResult_conv = OA_Dal_Delivery_query("select campaignname,impression_count,conversion_count,clientid from  ".$table_prefix."campaigns where campaignid=".$results['campaignid']);
			
			$fetch_record2=OA_Dal_Delivery_fetchAssoc($rsResult_conv);
			
		
			//select account_id from clients 
			$account = OA_Dal_Delivery_query('select account_id,clientname,email from '.OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients']).' where clientid='.$fetch_record2['clientid']);
				
			$dj_acoount_id  = OA_Dal_Delivery_fetchAssoc($account);
			
			//selecting advertiser/publisher message settings			
			$db = 'select * from djax_adv_pub_notification_settings where account_id='.$dj_acoount_id['account_id'];
			
			$jb = OA_Dal_Delivery_query($db);
				
			$djax_adv_pub  = OA_Dal_Delivery_fetchAssoc($jb);
			
			
			$enable_disable = $djax_adv_pub['msg_adv_pub_enable'];
			
			//selecting app configuration settings
				
			$app_config = 'select * from djax_app_configurations';
				
			$config_query = OA_Dal_Delivery_query($app_config);
				
			$data_config  = OA_Dal_Delivery_fetchAssoc($config_query);
			
			if($data_config['adv_pub_msg'] == 'enable')
			{
				if($enable_disable)
					{
						$string = 'conversion';
				
						if(strpos($djax_adv_pub['campaign_tracking'],$string)!== false)
						{
						$msg_type = $djax_adv_pub['msg_type'];
						}
						else{
						$msg_type = null;
						}
			   
					}
					else{
						$msg_type = null;
						}
			
			}
			else{
					$msg_type = $data_config['message_type'];
			}
	
			$message = "Conversion Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>" ;
				
			$mail_content = "Hi, <br> Conversion Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thanks and Regards,<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" ;
				
			if(($fetch_record2['conversion_count']===$djax_adv_pub['conversion_limit'])==TRUE)
			{
				
				
			OA_Dal_Delivery_query("update  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set conversion_count='0' where campaignid=".$results['campaignid']);


			if($msg_type=='email' || $msg_type=='both')
			{
				$mail='';
				$from_add = "admin@adgate.com"; 
				$to_add = $dj_acoount_id['email']; 
				$subject = "Warning: Conversion Created";
				$headers = "From: $from_add \r\n";
				$headers .= "Reply-To: $from_add \r\n";
				$headers .= "Return-Path: $from_add\r\n";
				$headers .= "X-Mailer: PHP \r\n";
				mail($to_add,$subject,$mail_content,$headers);

			}
			if($msg_type=='both' || $msg_type=='msg')
			{
				$msg_query1 = "INSERT INTO `alam_dev`.`djax_messages` (`id` ,`sender_id` ,`receiver_id` ,`subject` ,`content` ,
`date` ,`image_name` ,`file_name` ,`account_type` ,`status` ,`network_id` ,`is_deleted` ,`sender_is_deleted` ,`msg_type`
)VALUES (NULL , '2', '".$dj_acoount_id['account_id']."', 'Conversion Limit Reached','".$message."', '".date('Y-m-d H:i:s')."', 'NULL', 'NULL', 'ADVERTISER', '0', '1', '0', '', '')";
				$msg_query=OA_Dal_Delivery_query($msg_query1); 
			}
	
			}
			else{
			OA_Dal_Delivery_query("update  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set conversion_count=".$fetch_record2['conversion_count']."+1 where campaignid=".$results['campaignid']);
			}
			
			//*******************************Update conversion in rv_campaign table and to send mail on reaching conversion limit****************************************//
			
			
			$conversion     = "select conversion_count,campaignname,dj_camp_conversion from ".$table_prefix."campaigns where campaignid='".$results['campaignid']."'";
            $conversion_query         = mysql_query($conversion);
            $conversion_check     = mysql_fetch_assoc($conversion_query);
            
            $con_email = "select cl.clientname,cl.account_id,ca.mail_status,ca.campaignname,ca.dj_added_date ,cl.email from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." cl join ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  ca on cl.clientid = ca.clientid where campaignid=". $ads['campaign_id'];
             $con_email_fetch         = mysql_query($con_email);
            $email_details     = mysql_fetch_assoc($con_email_fetch);
            $type_query       = "select message_type,network_account_id,adv_pub_msg from djax_app_configurations";
            $type_result      = mysql_query($type_query);
            $type_results_ads = mysql_fetch_assoc($type_result);
            $mail='';
//djax_adv_pub_notification
            
            $db = 'select * from djax_adv_pub_notification_settings where account_id='.$results['account_id'];
			$jb = OA_Dal_Delivery_query($db);
			$djax_adv_pub  = OA_Dal_Delivery_fetchAssoc($jb);
			$enable_disable = $djax_adv_pub['msg_adv_pub_enable'];
			//$app_config = 'select * from djax_app_configurations';
			//$config_query = OA_Dal_Delivery_query($app_config);
			//$data_config  = OA_Dal_Delivery_fetchAssoc($config_query);
			if($type_results_ads['adv_pub_msg'] == 'enable')
			{
			if($enable_disable)
			{
			$string = 'conversion';
						
			if(strpos($djax_adv_pub['campaign_tracking'],$string)!== false)
			{
			$msg_type = $djax_adv_pub['msg_type'];
			}
			else{
			$msg_type = null;
				}
					   
			}
			else{
				$msg_type = null;
			}
					
			}
			else{
				$msg_type = $type_results_ads['message_type'];
			}
			
			 //djax_adv_pub_notification
			
            if($conversion_check['conversion_count']==$djax_adv_pub['conversion_limit'])
            {
				OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set conversion_count=0 where campaignid='".$results['campaignid']."'");
				if ($msg_type == 'both' || $msg_type == 'email') {
			
					$mail     = '';
					$from_add = "admin@adgate.com";
					$to_add   = $email_details['email'];
					$subject  = "Budget Completed";
					$message = "Congratulations, The campaign conversion has been done successfully.<br><br> Client Name = " . $email_details['clientname'] . "<br><br> Campaign Name =" . $email_details['campaignname'] . "<br><br> Created Date =" . $email_details['dj_added_date'];
					$headers  = "From: $from_add \r\n";
					$headers .= "Reply-To: $from_add \r\n";
					$headers .= "Return-Path: $from_add\r\n";
					$headers .= "X-Mailer: PHP \r\n";
					$message = '' . $email_details['clientname'] . ' ' . $email_details['campaignname'];
				  
					//Attach an image file
					//$mail->addAttachment('images/phpmailer_mini.png');
					//send the message, check for errors
					mail($to_add, $subject, $message, $headers);
				
				} 
				if (($msg_type == 'both' || $msg_type == 'email')) {
				  
					$msg_query = "insert into djax_messages (sender_id,receiver_id,subject,content,image_name,file_name,account_type,status,network_id,date) values('2','" . $email_details['account_id'] . "','Conversion Done','Congratulations, The campaign conversion has been done successfully.<br><br> Client Name = " . $email_details['clientname'] . "<br><br> Campaign Name =" . $email_details['campaignname'] . "<br><br> Created Date =" . $email_details['dj_added_date'] . "',NULL,NULL,'ADVERTISER','1','" . $type_results_ads['network_account_id'] . "','" . date('Y-m-d H:i:s') . "')";
					$query_msg = mysql_query($msg_query);
                              
						
			}
			
			
			
		}
		
		else{
			
			OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
			 set conversion=".$conversion_check['conversion']."+1  where campaignid='".$results['campaignid']."'");
			}
}
}

?>
