<?php

/*
+---------------------------------------------------------------------------+
| OpenX  v${RELEASE_MAJOR_MINOR}                                                              |
| =======${RELEASE_MAJOR_MINOR_DOUBLE_UNDERLINE}                                                                |
|                                                                           |
| Copyright (c) 2003-2009 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: Channel.class.php 44411 2009-10-07 14:59:11Z david.keen $
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';

/**
 * A Site delivery limitation plugin, for filtering delivery of ads on the
 * basis of the pre-defined channels.
 *
 * Works with:
 * A comma separated list of channel IDs.
 *
 * Valid comparison operators:
 * ==, =~, !=, !~
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 * @author     Andrew Hill <andrew@m3.net>
 * @author     Chris Nutting <chris@m3.net>
 *
 * @TODO overlap() methods now checks only if there is an overlap of channel ids.
 * Id does not check if contents of different channels overlap.
 */
class Plugins_DeliveryLimitations_Retarget_Retarget extends Plugins_DeliveryLimitations_CommaSeparatedData
{
    var $bannerid;
    var $agencyid;
    var $defaultComparison = '=~';

    function Plugins_DeliveryLimitations_Retarget_Retarget()
    {
        $this->Plugins_DeliveryLimitations_ArrayData();
        $this->nameEnglish = 'Retarget - Context';
    }

    

    /**
     * Return if this plugin is available in the current context
     *
     * @return boolean
     */
    function isAllowed($page = false)
    {
        return ($page != 'channel-acl.php');
    }

    /**
     * Outputs the HTML to display the data for this limitation
     *
     * @return void
     */
    function displayArrayData()
    {
        $conf = $GLOBALS['_MAX']['CONF'];
        $this->bannerid = (isset($GLOBALS['bannerid'])) ? $GLOBALS['bannerid'] : 0;
        $tabindex =& $GLOBALS['tabindex'];

     
		$doBanners = OA_Dal::factoryDO('banners');
		$doBanners->bannerid = $this->bannerid;
		$doBanners->find();
		$doBanners->fetch();
		$aBanner = $doBanners->toArray();
		
		$bid=$aBanner['bannerid'];
        
        
        $doAcls = OA_Dal::factoryDO('acls');
		$doAcls->executionorder=$this->executionorder;
		$doAcls->bannerid = $this->bannerid;
		$doAcls->find();
		$doAcls->fetch();	
		$acls = $doAcls->toArray();
		
		
		$selected_key=$acls['data'];
		
		$sep=explode(',',$selected_key);
       
        
        
       // $array_acl=explode(',',$acls)
        
		$doContext = OA_Dal::factoryDO('context');
		$doContext->find();
		while ($doContext->fetch()){
		
			$aContext[] = $doContext->toArray();
        }


         
        echo "<div class='box'>";
       /* foreach($aContext as $context){
			
			$con=$context['context'].'_*_'.$bid;
           
            echo "
                <div class='boxrow'>
                    <input
                        tabindex='".($tabindex++)."'
                        type='checkbox'
                        id='c_{$this->executionorder}_{$context['context']}'
                        name='acl[{$this->executionorder}][data][]'
                        value='{$context['context']}'".(in_array($context['context'],$sep) ? ' checked="checked"' : '')."
                    />
                     ".$context['context']."
                </div>";
       }*/
        foreach($aContext as $context){
			
			$con=$context['context'].'_*_'.$bid;
           
            echo "
                <div class='boxrow'>
                    <input
                        tabindex='".($tabindex++)."'
                        type='checkbox'
                        id='c_{$this->executionorder}_{$con}'
                        name='acl[{$this->executionorder}][data][]'
                        value='{$con}'".(in_array($con,$sep) ? ' checked="checked"' : '')."
                    />
                     ".$context['context']."
                </div>";
       }
       
        echo "</div>";
	}
}
?>
