<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */

require_once MAX_PATH . '/lib/max/Delivery/limitations.delivery.php';

/**
 * Check to see if this impression contains the valid browser.
 *
 * @param string $limitation The browser (or comma list of browsers) limitation
 * @param string $op The operator ('==', '!=', '=~', '!~')
 * @param array $aParams An array of additional parameters to be checked
 * @return boolean Whether this impression's browser passes this limitation's test.
 */
function MAX_checkClient_Browser($limitation, $op, $aParams = array())
{
	$limitation = explode(",",$limitation);
    if (empty($aParams)) {
        $aParams = $GLOBALS['_MAX']['CLIENT'];

        if (!isset($aParams['browser'])) {
            $aParams['browser'] = $aParams['wrapper']->getLegacyBrowser();
        }
    }
    if($op == '==')
    {
		if (in_array($aParams['browser'], $limitation))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	else if($op == '!=')
	{
		if (in_array($aParams['browser'], $limitation))
		{
			return false;
		}
		else
		{
			return true;
		}
	}
    //return MAX_limitationsMatchArray('browser', $limitation, $op, $aParams);
}
