<?php

/*
 *    Copyright (c) 2009 Bouncing Minds - Option 3 Ventures Limited
 *
 *    This file is part of the Regions plug-in for Flowplayer.
 *
 *    The Regions plug-in is free software: you can redistribute it
 *    and/or modify it under the terms of the GNU General Public License
 *    as published by the Free Software Foundation, either version 3 of
 *    the License, or (at your option) any later version.
 *
 *    The Regions plug-in is distributed in the hope that it will be
 *    useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with the plug-in.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
 
require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/common.php';

require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/vastinline.php';

require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/vastoverlay.php';

require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/vastwrapper_inline.php';

require_once MAX_PATH . '/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/vastwrapper_overlay.php';


function deliverVastAd($pluginType, &$aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $richMedia=true, $loc, $referer)
{
	
    global $format;

    extractVastParameters( $aBanner );
		
    $aOutputParams = array();
    $aOutputParams['format'] = $format;
    $aOutputParams['videoPlayerSwfUrl'] = getVideoPlayerUrl('flowplayerSwfUrl');
    $aOutputParams['videoPlayerJsUrl'] = getVideoPlayerUrl('flowplayerJsUrl');
    $aOutputParams['videoPlayerRtmpPluginUrl'] = getVideoPlayerUrl('flowplayerRtmpPluginUrl');
    $aOutputParams['videoPlayerControlsPluginUrl'] = getVideoPlayerUrl('flowplayerControlsPluginUrl');

    if ( getVideoPlayerSetting('isAutoPlayOfVideoInOpenXAdminToolEnabled' )){
        $aOutputParams['isAutoPlayOfVideoInOpenXAdminToolEnabled'] = "true";
    } else {
        $aOutputParams['isAutoPlayOfVideoInOpenXAdminToolEnabled'] = "false";
    }			
    if(!empty($aBanner['thirdPartyImpressionUrl'])) {
        $aOutputParams['thirdPartyImpressionUrl'] = $aBanner['thirdPartyImpressionUrl'];
    }

	if(!empty($aBanner['vast_thirdparty_clicktracking'])) 
	{
        $aOutputParams['vast_thirdparty_clicktracking'] = $aBanner['vast_thirdparty_clicktracking'];
    	}
	if(!empty($aBanner['vast_thirdparty_clickcustom'])) 
	{
        $aOutputParams['vast_thirdparty_clickcustom'] = $aBanner['vast_thirdparty_clickcustom'];
    }
	
	if($aBanner['revenue_type']==1)
	{
		$pricingtype='CPM';
	}
	if($aBanner['revenue_type']==2)
	{
		$pricingtype='CPC';
	}
	if($aBanner['revenue_type']==3)
	{
		$pricingtype='CPA';
	}
	if($aBanner['revenue_type']==4)
	{
		$pricingtype='CPL';
	}
	if($aBanner['revenue_type']==5)
	{
		$pricingtype='CPS';
	}
	if($aBanner['revenue_type']==6)
	{
		$pricingtype='CPI';
	}
	if($aBanner['revenue_type']==7)
	{
		$pricingtype='CPV';
	}
	$aOutputParams['pricingtype']=$pricingtype;	
			
    prepareCompanionBanner($aOutputParams, $aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, $useAlt, $loc, $referer);
	prepareVideoParams( $aOutputParams, $aBanner );	
	prepareOverlayParams( $aOutputParams, $aBanner );
    $player = "";	
	
	$request_id= $_SESSION['request_id'];//$_REQUEST['request_id'];
    prepareTrackingParams( $aOutputParams, $aBanner, $zoneId, $source, $loc, $ct0, $logClick, $referer,$request_id);	

	$aOutputParams['bannerid']=$aBanner['ad_id'];   

    if ( $format == 'vast1'  || $format == 'vast2' ||  $format == 'vast3' || $format =='vast1_wrapper' || $format =='vast2_wrapper' || $format =='vast3_wrapper' || $format=='vast_pod_wrapper')
    { 
        if ( $pluginType == 'vastInline' )
		{

		   if($format == 'vast1')
		   {
		   $player .= renderOutput_inlineVast1( $aOutputParams, $pluginType, "Inline Video Ad",$format);
		   }	
		   else if($format == 'vast2')
		   { 
		   $player .= renderOutput_inlineVast2( $aOutputParams, $pluginType, "Inline Video Ad",$format);
		   }
		   else if($format == 'vast3')
		   { 				
		   $player .= renderOutput_inlineVast3( $aOutputParams, $pluginType, "Inline Video Ad",$format);
		   }
		   else if($format =='vast1_wrapper')
		   {
			$player .= renderOutput_inlinewrapperVast1( $aOutputParams, $pluginType, "Inline Video Ad",$format);
		   }
		   else if($format =='vast2_wrapper')
		   {
			$player .= renderOutput_inlinewrapperVast2( $aOutputParams, $pluginType, "Inline Video Ad",$format);
		   }
		   else if($format =='vast3_wrapper')
		   {
			$player .= renderOutput_inlinewrapperVast3( $aOutputParams, $pluginType, "Inline Video Ad",$format);
		   }
        }
	else if ( $pluginType == 'vastOverlay' ) 
	{		  
       	   if($format == 'vast1')
		   { 
		   $player .= renderOutput_inlineVast1( $aOutputParams, $pluginType, "Overlay Video Ad",$format);
		   }	
		   else if($format == 'vast2')
		   { 
		   $player .= renderOutput_nonlinearVast2( $aOutputParams, $pluginType, "Overlay Video Ad",$format);
		   }
		   else if($format == 'vast3')
		   { 
		   $player .= renderOutput_nonlinearVast3( $aOutputParams, $pluginType, "Overlay Video Ad",$format);
		   }
		   else if($format =='vast1_wrapper')
		   {  
			$player .= renderOutput_nonlinearwrapperVast1( $aOutputParams, $pluginType, "Overlay Video Ad",$format);
		   }
		   else if($format =='vast2_wrapper')
		   {  
			$player .= renderOutput_nonlinearwrapperVast2( $aOutputParams, $pluginType, "Overlay Video Ad",$format);
		   }
		   else if($format =='vast3_wrapper')
		   { 
			$player .= renderOutput_nonlinearwrapperVast3( $aOutputParams, $pluginType, "Overlay Video Ad",$format);
		   }
        }
	else 
	{
            throw new Exception("Uncatered for vast plugintype|$pluginType|");
        }
    } else {
        if ( $pluginType == 'vastInline' ){
            $player .= renderPlayerInPage($aOutputParams);
            $player .= renderCompanionInAdminTool($aOutputParams);
        } else if ( $pluginType == 'vastOverlay' ) {
            $player .= renderOverlayInAdminTool($aOutputParams, $aBanner);
            $player .= renderCompanionInAdminTool($aOutputParams);
            $player .= renderPlayerInPage($aOutputParams);
        } else {
            throw new Exception("Uncatered for vast plugintype|$pluginType|");
        }
    }	
    return $player;
}

function getVastXMLHeader($charset,$version,$format)
{
    $header   = "<?xml version=\"1.0\" encoding=\"".xmlspecialchars($charset)."\"?>\n";

    	if($format=='vast1' || $format=='vast1_wrapper')
	{
    	$header  .= "<VideoAdServingTemplate xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"vast.xsd\">\n";
	}
	else
	{
	    $header  .= "<VAST version=\"$version\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"vast.xsd\">\n";
	}
    return $header;
}

function getVastXMLFooter($format)
{
	if($format=='vast1' || $format=='vast1_wrapper')
	{
	$footer = "</VideoAdServingTemplate>\n";
	}
	else
	{
	$footer = "</VAST>\n";
	}
	return $footer;
}

function getVideoPlayerUrl($parameterId)
{
    static $aDefaultPlayerFiles = array(
        'flowplayerSwfUrl'=> "flowplayer/3.1.1/flowplayer-3.1.1.swf",
        'flowplayerJsUrl'=> "flowplayer/3.1.1/flowplayer-3.1.1.min.js",
        'flowplayerControlsPluginUrl' =>  "flowplayer/3.1.1/flowplayer.controls-3.1.1.swf",
        'flowplayerRtmpPluginUrl'=> "flowplayer/3.1.1/flowplayer.rtmp-3.1.0.swf",
    );

    $conf = $GLOBALS['_MAX']['CONF'];

    // you can set this by adding a setting under [vastServeVideoPlayer] in the hostname.conf.php config file
    //$fullFileLocationUrl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' . $conf['webpath']['deliverySSL'] : 'http://' .  $conf['webpath']['delivery'];
    
    
    $fullFileLocationUrl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' . $conf['webpath']['adblockerSSL'] : 'http://' .  $conf['webpath']['adblockerSSL'];

    $fullFileLocationUrl .= "/fc.php?script=deliveryLog:vastServeVideoPlayer:player&file_to_serve=";

    if(isset( $conf['vastServeVideoPlayer'][$parameterId])) {
        $configFileLocation = $conf['vastServeVideoPlayer'][$parameterId];
        $fullFileLocationUrl .= $configFileLocation;
    } else {
        if(!isset($aDefaultPlayerFiles[$parameterId])) {
            throw new Exception("Uncatered for setting type in getVideoPlayerUrl() |$parameterId| in <pre>" . print_r( $aDefaultPlayerFiles, true) . '</pre>' );
        } else {
            $fullFileLocationUrl .= $aDefaultPlayerFiles[$parameterId];
        }
    }
    return $fullFileLocationUrl;
}

function extractVastParameters( &$aBanner )
{
    if ( isset($aBanner['parameters']) ){
        $vastVariables = unserialize($aBanner['parameters']);
        $aBanner = array_merge($aBanner, $vastVariables);
    }
}

function prepareVideoParams(&$aOutputParams, $aBanner)
{
	$vastdata=unserialize($aBanner['parameters']);

	/*DAC015*/
	if($vastdata['vast_video_delivery']=='vast')
	{
 	$aOutputParams['vast_wrapper']=$vastdata['vast_wrapper_url'];
	$aOutputParams['vastversion']=$vastdata['vast_version'];
	}
	else if($vastdata['vast_overlay_format']=='wrapper_overlay')
	{
	$aOutputParams['vast_wrapper']=$vastdata['vast_overlay_wrapper'];
	$aOutputParams['vastversion']=$vastdata['vast_overlay_version'];
	}
	$aOutputParams['vast_video_skip_duration']=$vastdata['vast_video_skip_duration'];
	$aOutputParams['vast_video_skip_progress_duration']=$vastdata['vast_video_skip_progress_duration'];

	//$aOutputParams['vpaid_enable']=$aBanner['vpaid_enable'];
	/*DAC015*/

    $aOutputParams['name'] = $aBanner['name'];
    if(isset($aBanner['vast_video_outgoing_filename'] )
        && $aBanner['vast_video_outgoing_filename']) {
       $aAdminParamsNotUsed = array();
       parseVideoUrl($aBanner, $aOutputParams, $aAdminParamsNotUsed );
       $aOutputParams['vastVideoDuration'] = secondsToVASTDuration( $aBanner['vast_video_duration'] );
       $aOutputParams['vastVideoBitrate'] = $aBanner['vast_video_bitrate'];
       $aOutputParams['vastVideoWidth']= $aBanner['vast_video_width'];
       $aOutputParams['vastVideoHeight'] = $aBanner['vast_video_height'];
       $aOutputParams['vastVideoId'] =  $aBanner['bannerid'];
       $aOutputParams['vastVideoType'] = $aBanner['vast_video_type'];
       $aOutputParams['vastVideoDelivery'] = $aBanner['vast_video_delivery'];
    }
}

function prepareOverlayParams(&$aOutputParams, $aBanner)
{
    $aOutputParams['overlayHeight'] = $aBanner['vast_overlay_height'];
    $aOutputParams['overlayWidth'] = $aBanner['vast_overlay_width'];
    $aOutputParams['overlayDestinationUrl'] = $aBanner['url'];
    if (isset($aBanner['htmltemplate'])) {
        $aOutputParams['overlayMarkupTemplate'] = $aBanner['htmltemplate'];
    }
    if(!empty($aBanner['filename'])) {
        $aOutputParams['overlayFilename'] = $aBanner['filename'];
    }
    if(!empty($aBanner['contenttype'])) {
        $aOutputParams['overlayContentType'] = $aBanner['vast_creative_type'];
    }
    $aOutputParams['overlayFormat'] = $aBanner['vast_overlay_format'];
    switch($aOutputParams['overlayFormat']) {
        case VAST_OVERLAY_FORMAT_TEXT:
            $aOutputParams['overlayTextTitle'] = $aBanner['vast_overlay_text_title'];
            $aOutputParams['overlayTextDescription'] = $aBanner['vast_overlay_text_description'];
            $aOutputParams['overlayTextCall'] = $aBanner['vast_overlay_text_call'];
            $aOutputParams['overlayHeight'] = VAST_OVERLAY_DEFAULT_HEIGHT;
            $aOutputParams['overlayWidth'] = VAST_OVERLAY_DEFAULT_WIDTH;
        break;

        case VAST_OVERLAY_FORMAT_HTML:
            $aOutputParams['overlayHeight'] = VAST_OVERLAY_DEFAULT_HEIGHT;
            $aOutputParams['overlayWidth'] = VAST_OVERLAY_DEFAULT_WIDTH;
        break;
    }
//    var_dump($aBanner);
//    var_dump($aOutputParams);exit;
}

function prepareCompanionBanner(&$aOutputParams, $aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $loc, $referer)
{	
	
    // If we have a companion banner to serve
    if ( isset( $aBanner['vast_companion_banner_id']  )&& ($aBanner['vast_companion_banner_id'] != 0) )
    { 
          $companionBannerId = $aBanner['vast_companion_banner_id'];  

        // VAST supports the concept of an ad having multlple  companions returned(each with different formats and sizes
        // its then the role of the player to choose the appropriate companion ad to display based on users screen size etc
        // However for now we just focus on serving a single companion banner. Also in vast - I think - the player should be adding the click tracking
        // for now we are doing this server side.
        global $context;

        if (isset($context) && !is_array($context)) {
            $context = MAX_commonUnpackContext($context);
        }
        if (!is_array($context)) {
            $context = array();
        }
        $companionOutput = MAX_adSelect("bannerid:$companionBannerId", '', "", $source, $withText, '', $context, true, $ct0, $loc, $referer);
		
        //$aBanner = _adSelectDirect("bannerid:$companionBannerId", '', $context, $source);
        //$companionOutput = MAX_adRender($aBanner, 0, '', '', '', true, '', false, false);
        //$aOutputParams['companionId'] = $companionBannerId;
        if ( !empty($companionOutput['html'] )){
            // We only regard  a companion existing, if we have some markup to output
            $html = $companionOutput['html'];

            // deal with the case where the companion code itself contains a CDATA
            $html = str_replace(']]>', ']]]]><![CDATA[>', $html);
            $aOutputParams['companionMarkup'] = $html;
			$aOutputParams['companionbannerid'] = $companionBannerId;
            $aOutputParams['companionWidth'] = $companionOutput['width'];
            $aOutputParams['companionHeight'] = $companionOutput['height'];
            $aOutputParams['companionClickUrl'] = $companionOutput['url'];
		if(!empty($aBanner['vast_thirdparty_companion_clicktracking'])) 
		{
			$aOutputParams['vast_thirdparty_companion_clicktracking'] = $aBanner['vast_thirdparty_companion_clicktracking'];
	    }
		if(!empty($aBanner['vast_thirdparty_companion_expandedwidth'])) 
		{
			$aOutputParams['vast_thirdparty_companion_expandedwidth'] = $aBanner['vast_thirdparty_companion_expandedwidth'];
	    }
		if(!empty($aBanner['vast_thirdparty_companion_expandedheight'])) 
		{
			$aOutputParams['vast_thirdparty_companion_expandedheight'] = $aBanner['vast_thirdparty_companion_expandedheight'];
	    }
        }
    }
}

function prepareTrackingParams(&$aOutputParams, $aBanner, $zoneId, $source, $loc, $ct0, $logClick, $referer, $request_id)
{
    $conf = $GLOBALS['_MAX']['CONF'];
	$aOutputParams['impressionUrl'] =  _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer,'&');	
	if ( $aOutputParams['format'] == 'vast1' || $aOutputParams['format'] == 'vast2' || $aOutputParams['format'] == 'vast3' || $aOutputParams['format'] =='vast1_wrapper' || $aOutputParams['format'] == 'vast2_wrapper' || $aOutputParams['format'] == 'vast3_wrapper' || $aOutputParams['format'] == 'vast_pod' || $aOutputParams['format'] == 'vast_pod_wrapper'){
        $trackingUrl = MAX_commonGetDeliveryUrl($conf['file']['frontcontroller']).
            "?script=videoAds:vastEvent&bannerid={$aBanner['bannerid']}&zoneid={$zoneId}&request_id={$request_id}";
        if (!empty($source)) {
            $trackingUrl .= "&source=".urlencode($source);
        }
        $aOutputParams['trackUrlStart'] = $trackingUrl . '&event=start';
        $aOutputParams['trackUrlMidPoint'] = $trackingUrl . '&event=midpoint';
        $aOutputParams['trackUrlFirstQuartile'] = $trackingUrl . '&event=firstquartile';
        $aOutputParams['trackUrlThirdQuartile'] = $trackingUrl . '&event=thirdquartile';
        $aOutputParams['trackUrlComplete'] = $trackingUrl . '&event=complete';
        $aOutputParams['trackUrlMute'] = $trackingUrl . '&event=mute';
        $aOutputParams['trackUrlPause'] = $trackingUrl . '&event=pause';
        $aOutputParams['trackReplay'] = $trackingUrl . '&event=replay';
        $aOutputParams['trackUrlFullscreen'] = $trackingUrl . '&event=fullscreen';
        $aOutputParams['trackUrlStop'] = $trackingUrl . '&event=stop';
        $aOutputParams['trackUrlUnmute'] = $trackingUrl . '&event=unmute';
        $aOutputParams['trackUrlResume'] = $trackingUrl . '&event=resume';
	/*DAC015-Nonliner tracking*/
		$aOutputParams['trackUrlrewind'] = $trackingUrl . '&event=rewind';
		$aOutputParams['trackUrlcreativeView'] = $trackingUrl . '&event=creativeView';
        $aOutputParams['trackUrlexpand'] = $trackingUrl . '&event=expand';
        $aOutputParams['trackUrlcollapse'] = $trackingUrl . '&event=collapse';
        $aOutputParams['trackUrlacceptInvitation'] = $trackingUrl . '&event=acceptInvitation';
        $aOutputParams['trackUrlclose'] = $trackingUrl . '&event=close';
		$aOutputParams['trackUrlprogress'] = $trackingUrl . '&event=progress';
        $aOutputParams['trackUrlskip'] = $trackingUrl . '&event=skip';
		$aOutputParams['trackUrlacceptInvitationLinear'] = $trackingUrl . '&event=acceptInvitationLinear';
		$aOutputParams['trackUrlcloseLinear'] = $trackingUrl . '&event=closeLinear';
		$aOutputParams['trackUrlexitFullscreen'] = $trackingUrl . '&event=exitfullscreen';
	/*DAC015-Nonliner tracking*/
        $aOutputParams['vastVideoClickThroughUrl'] = _adRenderBuildVideoClickThroughUrl($aBanner, $zoneId, $source, $ct0 );
    }
    $aOutputParams['clickUrl'] = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick);
}

/**
 * This function builds the Click through URL for this ad
 *
 * @param array   $aBanner      The ad-array for the ad to render code for
 * @param int     $zoneId       The zone ID of the zone used to select this ad (if zone-selected)
 * @param string  $source       The "source" parameter passed into the adcall
 * @param string  $ct0          The 3rd party click tracking URL to redirect to after logging
 * @param bookean $logClick     Should this click be logged (clicks in admin should not be logged)
 *
 * @return string The click URL
 */
function _adRenderBuildVideoClickThroughUrl($aBanner, $zoneId=0, $source='', $ct0='', $logClick=true){

    // We dont pass $aBanner by reference - so the changes to this $aBanner are lost - which is a good thing
    // we need the url attribute of aBanner to contain the url we want created
    $clickUrl = '';
    if(!empty($aBanner['vast_video_clickthrough_url'])) {
        $aBanner['url'] = $aBanner['vast_video_clickthrough_url'];
        $clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick);
    }


    return $clickUrl;
}

function getImageUrlFromFilename($filename,$bannerid=false)
{  

			$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
			
			$djax_results=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("Select * from {$table_prefix}banners where bannerid='".$bannerid."'"));

			$image_path=$djax_results['dj_image_path'];

			$img_path=explode("/",$image_path);
			
			foreach($img_path as $key=>$value)
							{
								if($value=="images")
								{					
									$key_val=$key+1;
								}									  
							}		
						
			$image=$img_path[$key_val]; 
			
			return _adRenderBuildImageUrlPrefix()."/".$image."/".$filename;
}

function renderPlayerInPage($aOut)
{
	$player = "";
	if ( isset($aOut['fullPathToVideo'] ) ){
		$player = <<<PLAYER
			<h3>Video ad preview</h3>
			<script type="text/javascript" src="{$aOut['videoPlayerJsUrl']}"></script>
			<style>
			a.player {
			    display:block;
			    width:640px;
			    height:360px;
			    margin:25px 0;
			    text-align:center;
			}
			</style>

			<a class="player" id="player"></a>
PLAYER;

		// encode data before echoing to the browser to prevent xss
		$aOut['videoFileName'] = encodeUserSuppliedData( $aOut['videoFileName'] );
        $aOut['videoNetConnectionUrl'] = encodeUserSuppliedData( $aOut['videoNetConnectionUrl'] );

		$httpPlayer = <<<HTTP_PLAYER

		    <!-- http flowplayer setup -->
            <script language="JavaScript">
            flowplayer("a.player", "${aOut['videoPlayerSwfUrl']}", {
               playlist: [ '${aOut['videoFileName']}' ],
                clip: {
                       autoPlay: ${aOut['isAutoPlayOfVideoInOpenXAdminToolEnabled']}
               },
               plugins: {

                   controls: {
                        url: escape('${aOut['videoPlayerControlsPluginUrl']}')
                   }
               }

            });
            </script>
HTTP_PLAYER;

        $rtmpPlayer = <<<RTMP_PLAYER

            <!-- rmtp flowplayer setup -->
            <script language="JavaScript">
            flowplayer("a.player", "${aOut['videoPlayerSwfUrl']}", {
               clip: {
                       url: '${aOut['videoFileName']}',
                       provider: 'streamer',
                       autoPlay: ${aOut['isAutoPlayOfVideoInOpenXAdminToolEnabled']}
               },

               plugins: {
                   streamer: {
                        // see http://flowplayer.org/forum/8/15861 for reason I use encode() function
                        url: escape('${aOut['videoPlayerRtmpPluginUrl']}'),
                        netConnectionUrl: '${aOut['videoNetConnectionUrl']}'
                   },
                   controls: {
                        url: escape('${aOut['videoPlayerControlsPluginUrl']}')
                   }
               }

            });
            </script>
RTMP_PLAYER;

        $webmPlayer = <<<WEBM_PLAYER

            <!-- HTML5 Webm setup -->
            <script type="text/javascript">
                (function (p) {
                    p.html('<video width="640" height="360" controls><source src="{$aOut['fullPathToVideo']}" type="{$aOut['vastVideoType']}"/>You need an HTML5 compatible player, sorry</video>');
                })($("#player"));
            </script>

WEBM_PLAYER;

        if ( $aOut['videoDelivery'] == 'player_in_http_mode' ){
            if ($aOut['vastVideoType'] == 'video/webm') {
                $player .= $webmPlayer;
            } else {
                $player .= $httpPlayer;
            }
        }
        else if ( $aOut['videoDelivery'] == 'player_in_rtmp_mode' ) {
            $player .= $rtmpPlayer;
        }
        else {
            // default to rtmp play format
            $player .= $rtmpPlayer;
        }
    }
    return $player;
}

function renderCompanionInAdminTool($aOut)
{
    $player = "";
    if(isset($aOut['companionMarkup'])) {
        $player .=  "<h3>Companion Preview (" .$aOut['companionWidth'] . "x" . $aOut['companionHeight'] . ")</h3>";
        $player .= $aOut['companionMarkup'];
        /*$aBanner = Admin_DA::getAd($aOut['companionId']);
        $aBanner['bannerid'] = $aOut['companionId'];
        $bannerCode = MAX_adRender($aBanner, 0, '', '', '', true, '', false, false);
        $player .=  "<h3>Companion Preview</h3>";
        $player .= "This companion banner will appear during the duration of the Video Ad in the DIV specified in the video player plugin configuration. ";
        if(!empty($aOut['companionWidth'])) {
            $player .= " It has the following dimensions: width = ". $aOut['companionWidth'] .", height = ".$aOut['companionHeight'] .". ";
        }
        $player .= "<a href='".VideoAdsHelper::getHelpLinkVideoPlayerConfig()."' target='_blank'>Learn more</a><br/><br/>";
        $player .= $bannerCode;*/
        $player .= "<br>";
    }
    return $player;
}

function renderOverlayInAdminTool($aOut, $aBanner)
{

    $title =  "Overlay Preview";
    $borderStart = "<div style='color:black;text-decoration:none;border:1px solid black;padding:15px;'>";
    $borderEnd = "</div>";
    $htmlOverlay = '';
    switch($aOut['overlayFormat']) {
        case VAST_OVERLAY_FORMAT_HTML:
            $htmlOverlay = $borderStart . $aOut['overlayMarkupTemplate'] . $borderEnd;
        break;

        case VAST_OVERLAY_FORMAT_IMAGE:
            $title = "Image Overlay Preview";
            $imagePath = getImageUrlFromFilename($aOut['overlayFilename']);
            $htmlOverlay = "<img border='0' src='$imagePath' />";
        break;

        case VAST_OVERLAY_FORMAT_SWF:
            $title = "SWF Overlay Preview";
            // we need to set a special state for adRenderFlash to work (which tie us to this implementation...)
            $aBanner['type'] = 'web';
            $aBanner['width'] = $aOut['overlayWidth'];
            $aBanner['height'] = $aOut['overlayHeight'];
            $htmlOverlay = _adRenderFlash($aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=false, $logView=false);
        break;

        case VAST_OVERLAY_FORMAT_TEXT:
            $title = "Text Overlay Preview";
            $overlayTitle = $aOut['overlayTextTitle'];
            $overlayDescription = str_replace("\n","<br/>",$aOut['overlayTextDescription']);
            $overlayCall = $aOut['overlayTextCall'];
            $htmlOverlay = "
            	$borderStart
                    <div style='font-family:arial;font-size:18pt;font-weight:bold;'>$overlayTitle </div>
                    <div style='font-family:arial;font-size:15pt;'>$overlayDescription</div>
                    <div style='font-family:arial;font-size:15pt;font-weight:bold;color:orange;'>$overlayCall</div>
                $borderEnd
            ";
        break;
    }


    $htmlOverlayPrepend = 'The overlay will appear on top of video content during video play.';

    switch($aOut['overlayFormat']) {
        case VAST_OVERLAY_FORMAT_IMAGE:
        case VAST_OVERLAY_FORMAT_SWF:
            $htmlOverlayPrepend .= " This overlay has the following dimensions: width = " . $aOut['overlayWidth'] . ", height = " . $aOut['overlayHeight'] . ".";
        break;
    }
    if ($aOut['overlayDestinationUrl']) {
        $htmlOverlayPrepend .= ' In the video player, this overlay will be clickable.';
        $htmlOverlay =  "<a target=\"_blank\" href=\"${aOut['overlayDestinationUrl']}\"> {$htmlOverlay}</a>";
    }

    $htmlOverlay = $htmlOverlayPrepend . '<br/><br/>' . $htmlOverlay;

    $player = "<h3>$title</h3>";
    $player .= $htmlOverlay;
    $player .= "<br>";
    return $player;
}

// if bcmath php extension not installed
if ( !(function_exists('bcmod'))) {
    /**
     * for extremely large numbers of seconds this will break
     * but for video we will never have extremely large numbers of seconds
     *
     * see http://www.php.net/manual/en/language.operators.arithmetic.php
     **/
    function bcmod( $x, $y )
    {
        $mod= $x % $y;

        return (int)$mod;
    }

}// end of if bcmath php extension not installed

function secondsToVASTDuration($seconds)
{
    $hours = intval(intval($seconds) / 3600);
    $minutes = bcmod((intval($seconds) / 60),60);
    $seconds = bcmod(intval($seconds),60);
    $ret = sprintf( "%02d:%02d:%02d", $hours, $minutes, $seconds );
    return $ret;
}
