<?php

/**
 * apDeliveryLogRedis for Revive Adserver and OpenX Source
 *
 * @author Matteo Beccati
 * @copyright 2013-2015 AdserverPlugins.com - All rights reserved
 *
 */


if (empty($argv[1])) {
    $argc = 2;
    $argv[1] = 'default';
}

if (!@include(dirname(__FILE__) . '/../../../init.php')) {
    // Development path
    require dirname(__FILE__) . '/../../../../../init.php';
}

// Required files
require_once MAX_PATH . '/lib/Max.php';
require_once MAX_PATH . '/lib/OA/DB.php';
require_once MAX_PATH . '/lib/OA/Dal/Delivery.php';
require_once dirname(__FILE__) . '/../DAL/Distributed.php';
require_once dirname(__FILE__) . '/../DAL/Delivery.php';

if (empty($conf['apDeliveryLogRedisDistributed'])) {
    throw new Exception('The apDeliveryLogRedisDistributed section is missing from the conf file');
}

try {
    $oDal = new AP_DeliveryLogRedis_DAL_Distributed(
        null,
        new AP_DeliveryLogRedis_DAL_Delivery(null, 'apDeliveryLogRedisDistributed')
    );

    $oDal->migrate(new AP_DeliveryLogRedis_DAL_Delivery());
} catch (Exception $e) {
    echo "ERROR: ".$e->getMessage().PHP_EOL;
    exit(1);
}
