<?php 
/**
 * apDeliveryLogRedis for Revive Adserver and OpenX Source
 *
 * @author Matteo Beccati
 * @copyright 2013-2015 AdserverPlugins.com - All rights reserved
 *
 */
 
require_once MAX_PATH.'/plugins/apDeliveryLogRedis/DAL/Delivery.php';
require_once MAX_PATH.'/www/admin/do_notify.php';

function Plugin_postInit_apDeliveryLogRedis_override_Delivery_postInit()
{
    $conf = &$GLOBALS['_MAX']['CONF'];

    if (empty($conf['apDeliveryLogRedis']['disableDbLogging'])) {
        return;
    }

    $aDisable = array(
		'logViewer'				=> 'oxLogViewer',
		'logDjaxRequest'		=> 'oxLogDjaxRequest',
		'logDjaxResponse'		=> 'oxLogDjaxResponse',
		'logDjaxMessage'		=> 'oxLogDjaxMessage',
		'logRequest'            => 'oxLogRequest',
        'logImpression'         => 'oxLogImpression',
		'logImpressionCompanion'=> 'oxLogImpressionCompanion',
		'logClickCompanion'     => 'oxLogClickCompanion',
		'logClick'              => 'oxLogClick',
        'logConversion'         => 'oxLogConversion',
        'logConversionVariable' => 'oxLogConversion',
        'logImpressionVast'     => 'oxLogVast'
    );

	
    foreach ($aDisable as $hook => $plugin) {
        $final = array();
        foreach (explode('|', $conf['deliveryHooks'][$hook]) as $current) {
            if ($current != "deliveryLog:{$plugin}:{$hook}") {
                $final[] = $current;
            }
        }
        $conf['deliveryHooks'][$hook] = join('|', $final);
    }
}

/*djax_track_viewers*/
function Plugin_deliveryLog_apLogViewerRedis_logViewer_Delivery_logViewer($viewer_id,$device_type,$ip,$language,$os,$os_version,$screen_resolution,$device_model,$device_brand,$app_id,$display_width,$display_height,$didmd5,$didsha1,$username,$useremail,$userphone,$udid,$isp,$country_code,$country_name,$region,$city,$postal_code,$lattitude,$longitude)
{		
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $time = $GLOBALS['_MAX']['NOW'];
    $oi = $GLOBALS['_MAX']['CONF']['maintenance']['operationInterval'];
    $interval_start= gmdate('Y-m-d H:i:s', $time - $time % ($oi * 60));
	$aData['interval_start']= $interval_start;
    $aQuery = array(
       	'viewer_id'    		=> $viewer_id,
		'device_type'  		=> $device_type,
		'ip_address'   		=> $ip,
		'language'     		=> $language,
		'os'           		=> $os,
		'os_version'   		=> $os_version,
		'screen_resolution' => $screen_resolution,
		'device_model_name' => $device_model,
		'device_brand'      => $device_brand,
		'app_device_id'		=> $app_id,
		'display_width'		=> $display_width,
		'display_height'    => $display_height,
		'didmd5'			=> $didmd5,
		'didsha1'			=> $didsha1,
		'user_name'			=> $username,
		'useremail'			=> $useremail,
		'userphone'			=> $userphone,
		'isp'				=> $isp,
		'country'			=> $country_code,
		'country_name'		=> $country_name,
		'state'				=> $region,
		'city'              => $city,
		'zipcode'			=> $postal_code,
		'dma'				=> $udid,
		'latitude'			=> $lattitude,
		'longitude'			=> $longitude		
		);
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryLogRedisViewer', array($oDal, $adId, $zoneId));		
		
        return $oDal->logCount('viewer', $aData['interval_start'], $aQuery);
    } catch (Exception $e) {

    }
	
}
/*djax_track_ad_requests*/
function Plugin_deliveryLog_apLogDjaxRequestRedis_logDjaxRequest_Delivery_logDjaxRequest($requestid,$viewer_id=0,$zoneId=0,$device_type=0,$bidding_price=0,$user_agent=0,$browser_name=0,$browser_version=0,$browser_language=0,$flash_version=0,$domain=0,$os=0,$rand_no=0,$site_url=0,$site_referrer_url=0,$is_home_page=0,$external_ip=0,$carrier_name=0,$dataspeed=0,$timezone=0,$video_position=0,$country_code=0,$country_name=0,$region=0, $city=0, $zipcode=0,$isp=0,$user_latitude=0,$user_longitude=0,$app_id=0,$connectiontype=0)
{	 
	if($requestid==0){$requestid=1;}
    $time = $GLOBALS['_MAX']['NOW'];
    $oi = $GLOBALS['_MAX']['CONF']['maintenance']['operationInterval'];
    $interval_start= gmdate('Y-m-d H:i:s', $time - $time % ($oi * 60));
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aData['interval_start']= $interval_start;
	$devicetype=explode('=',$device_type);
	$device=$devicetype[0];
      $aQuery = array(
		'request_id'		=> $requestid,
       	'viewer_id'    		=> $viewer_id,
		'zone_id'   		=> $zoneId,
		'device_type'   	=> $device,
		'bidding_price' 	=> $bidding_price,
		'user_agent'   		=> $user_agent,
		'browser_name'		=> $browser_name,
		'browser_version'	=> $browser_version,
		'browser_language'	=> $browser_language,
		'flash_version'		=> $flash_version,
		'domain'			=> $domain,
		'operating_system'	=> $os,
		'random_no'			=> $rand_no,
		'site_url'			=> $site_url,
		'site_referrer_url'	=> $site_referrer_url,
		'is_home_page'		=> $is_home_page,
		'external_ip'		=> $external_ip,
		'carrier_name'		=> $carrier_name,
		'dataspeed'			=> $dataspeed,
		'timezone'			=> $timezone,
		'video_position'	=> $video_position,
		'country_code'		=> $country_code,
		'country_name'		=> $country_name,
		'region'			=> $region,
		'city'				=> $city,
		'zipcode'			=> $zipcode,
		'isp'				=> $isp,
		'user_latitude'		=> $user_latitude,
		'user_longitude'	=> $user_longitude,	 		
		'app_id'			=> $app_id,	
		'connectiontype'	=> $connectiontype		
    );
   
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();
        OX_Delivery_Common_hook('apDeliveryLogRedisDjaxRequest', array($oDal, $adId, $zoneId));
        return $oDal->logCount('djaxrequest', $aData['interval_start'], $aQuery);
    } catch (Exception $e) {

    }	 
}
function Plugin_deliveryLog_apLogDjaxResponseRedis_logDjaxResponse_Delivery_logDjaxResponse($requestid,$viewer_id=0,$zoneId=0,$ads_id=0,$daily_budget=0,$retarget=0,$device_type=0,$device_name=0,$bidding_price=0,$user_agent=0,$browser_name=0,$browser_version=0,$browser_language=0,$os=0,$os_version=0,$carrier_name=0,$country_code=0,$region=0,$city=0,$zipcode=0,$isp=0,$connectiontype=0,$mobile_manufacturer=0,$mobile_capability=0,$ad_size=0,$pub_id=0,$target_age=0,$target_gender=0,$target_color=0,$target_height=0,$target_weight=0)
{	
	if($requestid==0){$requestid=1;}
    $time = $GLOBALS['_MAX']['NOW'];
    $oi = $GLOBALS['_MAX']['CONF']['maintenance']['operationInterval'];
    $interval_start= gmdate('Y-m-d H:i:s', $time - $time % ($oi * 60));
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aData['interval_start']= $interval_start;
	$devicetype=explode('=',$device_type);
	$device=$devicetype[0];
      $aQuery = array(
		'request_id'		=> $requestid,
       	'viewer_id'    		=> $viewer_id,
		'zone_id'   		=> $zoneId,
		'ads_id'   			=> $ads_id,
		'daily_budget'      => $daily_budget,
		'retarget'			=> $retarget,
		'device_type'   	=> $device,
		'device_name'       => $device_name,
		'bidding_price' 	=> $bidding_price,
		'user_agent'   		=> $user_agent,
		'browser_name'		=> $browser_name,
		'browser_version'	=> $browser_version,
		'browser_language'	=> $browser_language,
		'operating_system'	=> $os,
		'os_version'		=> $os_version,
		'carrier_name'		=> $carrier_name,
		'country_code'		=> $country_code,
		'region'			=> $region,
		'city'				=> $city,
		'zipcode'			=> $zipcode,
		'isp'				=> $isp,
		'connectiontype'	=> $connectiontype,
		'mobile_manufacturer'=>$mobile_manufacturer,
		'mobile_capability' => $mobile_capability,
		'creative_size'		=> $ad_size,
		'traffice_source'	=> $pub_id,
		'target_age'		=> $target_age,
		'target_gender'		=> $target_gender,
		'target_color'		=> $target_color,
		'target_height'		=> $target_height,
		'target_weight'		=> $target_weight	
    );
  
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryLogRedisDjaxResponse', array($oDal, $adId, $zoneId));
       
        return $oDal->logCount('djaxresponse', $aData['interval_start'], $aQuery);
    } catch (Exception $e) {

    }	
}


/*djax_message*/
function Plugin_deliveryLog_apLogDjaxMessageRedis_logDjaxMessage_Delivery_logDjaxMessage($okToLog = true,$senderid,$receiverid,$subject,$content,$image_name,$file_name,$account_type,$status,$network_id,$is_deleted,$sender_is_deleted,$msg_type)
{	

    if (!$okToLog) { return false; }
    $time = $GLOBALS['_MAX']['NOW'];
    $oi = $GLOBALS['_MAX']['CONF']['maintenance']['operationInterval'];
    $interval_start= gmdate('Y-m-d H:i:s', $time - $time % ($oi * 60));
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aData['interval_start']= $interval_start;
    $aQuery = array(
        'id'    	=> '',
		'sender_id'  	=> $senderid,
		'receiver_id'   => $receiverid,
		'subject '   	=> $subject,
		'content ' 		=> $content,
		'date'   		=> date($interval_start),
	    'image_name'	=> $image_name,
		'file_name'		=> $file_name,
		'account_type'  => $account_type,
		'status'		=> $status,
		'network_id'	=> $network_id,
 		'is_deleted'	=> $is_deleted,
 		'sender_is_deleted'=>$sender_is_deleted,
		'msg_type'		=>  $msg_type 
    );
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryLogRedisDjaxMessage', array($oDal, $adId, $zoneId));

        return $oDal->logCount('djaxmessage', $aData['interval_start'], $aQuery);
    } catch (Exception $e) {

    }
	
}

function Plugin_deliveryLog_apLogRequestRedis_logRequest_Delivery_logRequest($adId = 0, $zoneId = 0, $aAd = array(), $okToLog = true)
{
    if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aQuery = array(
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
		'dj_request_id'	 => $aAd['request_id']
    );
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryLogRedisRequest', array($oDal, $adId, $zoneId));

        return $oDal->logCount('requests', $aData['interval_start'], $aQuery);
    } catch (Exception $e) {

    }
}

function Plugin_deliveryLog_apLogImpressionRedis_logImpression_Delivery_logImpression($adId = 0, $zoneId = 0, $okToLog = true,$device_type='')
{  
    if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aConf = $GLOBALS['_MAX']['CONF']; 
	
	/* Customization - Start */
	$encrypted_val=$_REQUEST; 				
	reset($encrypted_val);
	$first_key 		= 	str_replace(base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key']),'',str_rot13(key($encrypted_val)));
	$keyvalues		=	base64_decode($first_key);
	$final_value=array();
	$firstset=explode("&",$keyvalues);											
	foreach($firstset as $secondset)
	{
		$thirdset=explode("=",$secondset);
		$final_value[$thirdset[0]]=$thirdset[1];
	}
			
	if(!empty($final_value['request_id']))
	{	
		$request_id = $final_value['request_id']; 
		$adId = $final_value[$GLOBALS['_MAX']['CONF']['var']['adId']];
		$zoneId = $final_value[$GLOBALS['_MAX']['CONF']['var']['zoneId']];					
	}		
	else if(!empty($_GET['request_id']))
	{  
		$request_id=$_GET['request_id'];
	}
		
	/* Customization - End */
	
		
	/* Fetch Fixed CPM / System CPM from ox_zones table */
				
	/* Special bidding options */
	$traffic_bid_rate=0;
	$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['affiliates'])." as oxa join ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])." as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$aData['zone_id'].") AND (campaign_id='0' OR campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].")) AND source_type='1'";
	$special_bidding=OA_Dal_Delivery_query($traffic_query);
	$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);  
	$traffic_bid_rate=$traffic_result['bid_rate']; 
				
	/* Countrywise bidding based on the campaign */	
	$country_val=$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
	$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND country_value='$country_val' AND revenue_type='1'";
	$special_country_bidding=OA_Dal_Delivery_query($country_query);
	$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
	$country_bid_rate=$bidding_result['bidding_value']; 

	$zone_query="select bid_rate from djax_campaign_zone_bidding where (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$aData['creative_id'].")) AND zone_id=".$aData['zone_id']." AND status = '1' AND campaign_type='1'";
	$zone_query_bidding=OA_Dal_Delivery_query($zone_query);
	$zone_result=OA_Dal_Delivery_fetchAssoc($zone_query_bidding);


	$hourly_query="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND revenue_type='1' ";
	$hourly_query_bidding=OA_Dal_Delivery_query($hourly_query);
	$hourly_result=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding);
					
	$win_bid=djax_win_bid_calc($adId);
	
			
	if($zoneId!=0)
	{ 
			
			$djax_fraud_impression=djax_fraud_impression($aData['creative_id'],$aData['zone_id']); 
																					
			//~ if($djax_fraud_click!=1)
			//~ {    
				//~ return false;
			//~ }
			
	   
		
		
		
			/* Special bidding options and countrywise bidding - Start*/
			if(!empty($country_bid_rate))
			{
					//$win_bid['win_bid_amount']=$country_bid_rate/1000;
					$win_bid['win_bid_amount']=$country_bid_rate;
			}
			else if(!empty($traffic_bid_rate))
			{
		    	    //$win_bid['win_bid_amount']=$traffic_bid_rate/1000;
					$win_bid['win_bid_amount']=$traffic_bid_rate;
			}						
			else if(!empty($zone_result))
			{
					$win_bid['win_bid_amount']=$zone_result['bid_rate'];
			}
			else if(!empty($hourly_result['hourly_bid_rate']) && !empty($hourly_result['hourly_bid_timing']))
			{
				$times = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
				if($hourly_result['hourly_bid_timing'] == $times)	
				{				
					$win_bid['win_bid_amount']=$hourly_result['hourly_bid_rate'];
				}
			}			
			else
			{
				if($win_bid['revenuetype']==1)
				{							
					//$win_bid['win_bid_amount'] = ($win_bid['win_bid_amount']/1000);
					$win_bid['win_bid_amount'] = $win_bid['win_bid_amount'];
				}
				else
				{
					$win_bid['win_bid_amount'] =0;
				}
			}												
					
					
				/* Special bidding options and countrywise bidding - End*/
																				
				if(!empty($win_bid))
				{	
					$detect_spent_amt=djax_detect_spent_amt($win_bid);
				}
				
				$publisher_percentage=djax_publisher_share($aData['zone_id']);
				$publisershare=$win_bid['win_bid_amount']*($publisher_percentage/100);
				$winning_bid=$win_bid['win_bid_amount'];
				$admin_revenue=$winning_bid-$publisershare;						
			}
			else
			{ 								
				/* Special Bidding Options and countrywise bidding - Start*/
				if(!empty($country_bid_rate))
				{
					//$win_bid['win_bid_amount']=$country_bid_rate/1000;
					$win_bid['win_bid_amount']=$country_bid_rate;
				}
				else if(!empty($traffic_bid_rate))
				{
				     //$win_bid['win_bid_amount']= $traffic_bid_rate/1000;
					 $win_bid['win_bid_amount']= $traffic_bid_rate;
				}
				else if(!empty($zone_result))
				{
					$win_bid['win_bid_amount']=$zone_result['bid_rate'];
				}			
				else if(!empty($hourly_result['hourly_bid_rate']) && !empty($hourly_result['hourly_bid_timing']))
				{
					$times = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
					if($hourly_result['hourly_bid_timing'] == $times)	
					{				
						$win_bid['win_bid_amount']=$hourly_result['hourly_bid_rate'];
					}
				}				
				else
				{
					if($win_bid['revenuetype']==1)
					{						
						//$win_bid['win_bid_amount'] = ($win_bid['win_bid_amount']/1000);
						$win_bid['win_bid_amount'] = $win_bid['win_bid_amount'];						
					}
					else
					{
						$win_bid['win_bid_amount'] =0;
					}
				}

				/* Special bidding options and countrywise bidding - End*/					
															
				if(!empty($win_bid))
				{ 
						$detect_spent_amt=djax_detect_spent_amt($win_bid);
				}	
				$admin_revenue=$win_bid['win_bid_amount'];
				$winning_bid=$win_bid['win_bid_amount'];
			}		
			
			/*Evenly Distribution - Start */			
			$campaign_id=$win_bid['campaignid'];
			$evenly_query="select impressions from rv_djax_evenly_distribution where campaign_id='".$campaign_id."' AND start_time>='".date("H:00:00")."' AND end_time<='".date("H:59:59")."' AND impressions>0 ";						
			$evenly_qry=OA_Dal_Delivery_query($evenly_query); 
			if(OA_Dal_Delivery_numRows($evenly_qry)>0)
			{
			$even_result=OA_Dal_Delivery_fetchAssoc($evenly_qry);
			$imp=$even_result['impressions'];
			$update_imp=$imp-1;						
			$update_imp_query = "update rv_djax_evenly_distribution set impressions='".$update_imp."' where campaign_id='".$campaign_id."' AND start_time>='".date("H:00:00")."' AND end_time<='".date("H:59:59")."'";
			OA_Dal_Delivery_query($update_imp_query);						
			}			
			/* Evenly distribution - End */
				
			$time = strtotime('now'); 
			
			$creative_id=(!empty($aData['creative_id']))?$aData['creative_id']:$adId;
			
			if($win_bid['dj_is_default']!='1')
			{
				$winning_bid=$winning_bid;
				$publisershare=$publisershare;
				$admin_revenue=$admin_revenue;				
			}
			else
			{
				$zone_id =(!empty($aData['zone_id']))?$aData['zone_id']:$zoneId;
				$res=djax_fixed_cpm($zone_id);
				$fixed_cpm=(!$res['fixed_cpm'])?$res['fixed_cpm']:$res['floor_price'];
				$winning_bid=0;
				$publisershare=$fixed_cpm;
				$admin_revenue=0;	
			}
			
			if(!empty($request_id))
			{
				$request_id		=	str_replace('d07484bhd3','',$request_id);
			}
						
			$aQuery = array(
				'creative_id'    	  => (!empty($aData['creative_id']))?$aData['creative_id']:$adId,
				'zone_id'        	  => (!empty($aData['zone_id']))?$aData['zone_id']:$zoneId,
				'dj_request_id'  	  => $request_id,
				'dj_win_bid'	 	  => $winning_bid,
				'dj_publisher_revenue'=> $publisershare,
				'dj_admin_revenue'	  => $admin_revenue,
				'timenow'			  => $time
				);	
				//smart cpa test
				$cur_time=gmdate('Y-m-d H:i:s', $time);
				if($win_bid['revenuetype']==3)
				{	
				OA_Dal_Delivery_query("insert into djax_ad_smart_cpa(creative_id,zone_id,dj_request_id,dj_win_bid,dj_publisher_revenue,dj_admin_revenue,impression,device_type,timenow) values('".$adId."','".$zoneId."','".$request_id."','".$winning_bid."','".$publisershare."','".$admin_revenue."','1','".$device_type."','".$cur_time."')") or die(mysql_error());
				}
				//print_r($aQuery);  die();
								    		
				/*DAC020 - Update table for popunder ad */	
				/*$zone_type = $result['dj_zone_type'];  
				$current_viewerid=$_COOKIE['viewer_id'];  
				$datetime=strtotime('now');//date("Y-m-d H:i:s");	
				$ipaddress=$_SERVER['REMOTE_ADDR'];  

				if($zone_type=="W_A_PUN")
				{			
					//OA_Dal_Delivery_query("insert into djax_ad_zone_imp_count(viewer_id,date_time,ad_id,zone_id,ipaddress) values('".$current_viewerid."','".$datetime."','".$adId."','".$zoneId."','".$_SERVER['REMOTE_ADDR']."')") or die(mysql_error());
					Plugin_deliveryLog_apLogDjaxImpRedis_logDjaxImp_Delivery_logDjaxImp($okToLog = true,$current_viewerid,$datetime,$adId,$zoneId,$ipaddress);
				}*/	
			
		 
			
			//Note: Mail wont work in local server. 
			
			//***************Update impresson_count in rv_campaign table and to send mail on reaching impression limit*********************************//
			
			$fetch_record1=$win_bid;
			$fetch_record2=$win_bid;	
			$dj_acoount_id  = $win_bid;
			
			$ad_id = (!empty($aData['creative_id']))?$aData['creative_id']:$adId;
			$user_details      = djax_admin_detail();
			$admin_name        = $user_details['first_name'] . ' ' . $user_details['last_name'];
			$admin_email       = $user_details['email_address'];
						
			//selecting advertiser/publisher message settings			
			$db = 'select * from djax_adv_pub_notification_settings where account_id='.$dj_acoount_id['account_id'];			
			$jb = OA_Dal_Delivery_query($db);				
			$djax_adv_pub  = OA_Dal_Delivery_fetchAssoc($jb);
						
			$enable_disable = $djax_adv_pub['msg_adv_pub_enable'];
			
			//selecting app configuration settings
						
			$data_config  = app_config();
								
			if($data_config['adv_pub_msg'] == 'enable')
			{
				if($enable_disable)
					{
						$string = 'impression';				
						if(strpos($djax_adv_pub['campaign_tracking'],$string)!== false)
						{
						$msg_type = $djax_adv_pub['msg_type'];
						}
						else{
						$msg_type = null;
						}
			   
					}
					else
					{
						$msg_type = null;
					}			
			}
			else{
					$msg_type = $data_config['message_type'];
			}
	
			
			$message = "Impression Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>" ;
			$mails = '<table border="0" width="600" cellpadding="0" cellspacing="0">
								<tr>
								<td style="color:#333333 !important; padding-left:20px;" height="40">
								
								 Impression Limit  has been reached for the campaign <b>'.$fetch_record2['campaignname'].'</b><br>
								</td>
								</tr>
								</table>
								
								';
			$mail_content = '<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td>
											<table border="0" width="600" cellpadding="0" cellspacing="0">
											<tr>
											<td font-size:24px; font-family: Arial, Verdana, sans-serif;  height="40">
												<p style="line-height:12px;">Hi ' . $dj_acoount_id['clientname'] . ',</p></td>
											</tr>
											</table>
											</td>
											</tr>
											</table>'.$mails.'
											<table border="0" width="600" cellpadding="0" cellspacing="0">
											<tr>
											<td style="color:#333333 !important; padding-right:45px; font-size:20px; font-family: Arial, Verdana, sans-serif;  height="40">
											<p line-height:12px;">With Regards,</p>
											<p  line-height:12px;">' . $admin_name . '</p>
											</td>
											</tr>
											</table>';	
			//$mail_content = "Hi, <br> Impression Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thanks and Regards,<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" ;
			
			if(($fetch_record2['impression_count']===$djax_adv_pub['impression_limit'])==TRUE)
			{			
				
			//OA_Dal_Delivery_query("update  rv_campaigns set impression_count='0',status=8 where campaignid=".$fetch_record1['campaignid']);

			if($msg_type=='email' || $msg_type=='both')
			{
				$mail='';
				$from_add = $admin_email; 
				$to_add = $dj_acoount_id['email']; 
				$subject = "Warning: Impression Limit Reached";
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				$headers .= "From: $from_add \r\n";
				$headers .= "Reply-To: $from_add \r\n";
				$headers .= "Return-Path: $from_add\r\n";
				$headers .= "X-Mailer: PHP \r\n";
				//mail($to_add,$subject,$mail_content,$headers);

			}
			if($msg_type=='both' || $msg_type=='msg')
			{
				$msg_query1 = "INSERT INTO `rv_djax_messages` (`id` ,`sender_id` ,`receiver_id` ,`subject` ,`content` ,
`date` ,`image_name` ,`file_name` ,`account_type` ,`status` ,`network_id` ,`is_deleted` ,`sender_is_deleted` ,`msg_type`
)VALUES (NULL , '2', '".$dj_acoount_id['account_id']."', 'Impression Limit Reached','".$message."', '".date('Y-m-d H:i:s')."', 'NULL', 'NULL', 'ADVERTISER', '0', '1', '0', '', '')";
				$msg_query=OA_Dal_Delivery_query($msg_query1); 				
			}	
			}
			else{
			OA_Dal_Delivery_query("update  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set impression_count=".$fetch_record2['impression_count']."+1 where campaignid=".$fetch_record1['campaignid']);
			//main_fn($dj_acoount_id['account_id']);
			
			}	
	
    try {		
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();
		
		$zid=(!empty($aData['zone_id']))?$aData['zone_id']:$zoneId;			
								
		if($zid!=0)
		{			
        OX_Delivery_Common_hook('apDeliveryLogRedisImpression', array($oDal, $adId, $zoneId));	
		return $oDal->logCount('impressions', $aData['interval_start'], $aQuery);
		
		}
		else
		{			
		OX_Delivery_Common_hook('apDeliveryLogRedisImpressionCompanion', array($oDal, $adId, $zoneId));		
        return $oDal->logCount('impressionscompanion', $aData['interval_start'], $aQuery);			
		}
		
    } catch (Exception $e) {

    }
}

function Plugin_deliveryLog_apLogClickRedis_logClick_Delivery_logClick($adId = 0, $zoneId = 0, $okToLog = true)
{	

		/*if (!$okToLog) {return false; }  */
		$aData = $GLOBALS['_MAX']['deliveryData'];
		   
		$encrypted_val	=	$_REQUEST;
		reset($encrypted_val);
		$first_key 		= 	str_replace(base64_encode($GLOBALS['_MAX']['CONF']['encryption']['enc_key']),'',str_rot13(key($encrypted_val)));
		$keyvalues		=	base64_decode($first_key);
		$keyvalues		=	str_replace('d07484bhd3','',$keyvalues );
		$final_value	=	array();
		$firstset		=	explode("_",$keyvalues);
		
		foreach($firstset as $secondset)
		{
			$thirdset=explode("=",$secondset);
			$final_value[$thirdset[0]]=$thirdset[1];
		}	
	
					
		// Decrypt - End
	   
		if(!empty($_GET['djax_requestid']))
		{	
			$request_id =base64_decode($_GET['djax_requestid']);			
		}
		else if(!empty($_GET['request_id']))
		{	 
			$request_id =$_GET['request_id'];
			$age_val=$_GET['age'];
			$gender_val=$_GET['sex'];
			$temp_variable=explode('__',$_GET['oadest']); 
			$loc=$temp_variable[0]; 
		}
		else if(!empty($_GET['oadest']))
		{   
			$temp_variable=explode('__',$_GET['oadest']); 
			
			$temp=explode('=',$temp_variable['1']);
			
			$age=explode('=',$temp_variable['2']);

			$age_val=$age['1'];

			$gender=explode('=',$temp_variable['3']);

			$gender_val=$gender['1'];

			$request_id=$temp[1];			
			
			$loc=$temp_variable[0]; 
		}	
		else 
		{	
			$request_id=$final_value['id'];  	
			$loc=$final_value['loc'];			
		}			
		
		$time = strtotime('now'); 
				
	    $ad_id=$aData['creative_id'];	
   
	    $aConf = $GLOBALS['_MAX']['CONF'];
	  
	    $query="select cl.clientid from
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])."  AS cl,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  AS c,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])."  AS b
		where b.bannerid='".$ad_id."' and cl.clientid=c.clientid and b.campaignid=c.campaignid and cl.dj_is_default='0'";
		
		$default_query=OA_Dal_Delivery_query($query);
		
		if(OA_Dal_Delivery_numRows($default_query)>0) 
		{            
		if($aData['zone_id']!=0)
		{
			$djax_fraud_click=djax_fraud_click($aData['creative_id'],$aData['zone_id'],$loc); 
																						
			if($djax_fraud_click!=1)
			{    
				return false;
			}
			
	     } 		 
				
			   $djax_win_bid_cpc=djax_win_bid_calc($aData['creative_id']);	
			  /*Special bidding options */
				$traffic_bid_rate=0;
				$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from rv_zones as z JOIN rv_affiliates as a ON z.affiliateid=a.affiliateid where zoneid=".$aData['zone_id'].") AND (campaign_id='0' OR campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].")) AND source_type='2'";
				$special_bidding=OA_Dal_Delivery_query($traffic_query);
				$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
				$traffic_bid_rate=$traffic_result['bid_rate']; 
								
								
			    /* Countrywise bidding based on the campaign */	
				$country_val=$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
				$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].") AND country_value='$country_val' AND revenue_type='2' ";				
				$special_country_bidding=OA_Dal_Delivery_query($country_query);
				$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
				$country_bid_rate=$bidding_result['bidding_value']; 

				$zone_query="select bid_rate from djax_campaign_zone_bidding where (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$aData['creative_id'].")) AND zone_id=".$aData['zone_id']." AND status = '1' AND campaign_type='2'";  
				$zone_query_bidding=OA_Dal_Delivery_query($zone_query);
				$zone_result=OA_Dal_Delivery_fetchAssoc($zone_query_bidding);
	
				$hourly_query="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].")  AND revenue_type='2'";
				$hourly_query_bidding=OA_Dal_Delivery_query($hourly_query);
				$hourly_result=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding);
				/* Special bidding options and countrywise bidding - Start*/
			
				  
				
				if(!empty($country_bid_rate))
				{  
					$djax_win_bid_cpc['win_bid_amount']	=	$country_bid_rate;
				}
				else if(!empty($traffic_bid_rate))
				{ 
					$djax_win_bid_cpc['win_bid_amount']	=	$traffic_bid_rate;
				}				
				else if(!empty($zone_result))
				{					
					$djax_win_bid_cpc['win_bid_amount']	=	$zone_result['bid_rate'];
				}		
				else if(!empty($hourly_result['hourly_bid_rate']) && !empty($hourly_result['hourly_bid_timing']))
				{
					$times = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
					if($hourly_result['hourly_bid_timing'] == $times)	
					{				
						$djax_win_bid_cpc['win_bid_amount']	=	$hourly_result['hourly_bid_rate'];
					}
				}				
				else
				{
					if($djax_win_bid_cpc['revenuetype']==2)
					{									
						$djax_win_bid_cpc['win_bid_amount'] =	$djax_win_bid_cpc['win_bid_amount'];
					}
					else
					{
						$djax_win_bid_cpc['win_bid_amount'] = 0;
					}
				}										
				/* Special bidding options and countrywise bidding - End*/
					
			if(!empty($djax_win_bid_cpc))
			{  		
			   	$campaigns_budget = djax_detect_spent_amt($djax_win_bid_cpc);			
															      			
				/*if($campaigns_budget!='0') 
				{		
					return false;					
				}*/
				
										
			}			
	    	} 

			
			if($aData['zone_id']!=0)
			{
			$publisher_percentage=djax_publisher_share($aData['zone_id']);
			$publisershare=$djax_win_bid_cpc['win_bid_amount']*($publisher_percentage/100);
			$admin_revenue=$djax_win_bid_cpc['win_bid_amount']-$publisershare;
			}
			else
			{
			$publisershare=$djax_win_bid_cpc['win_bid_amount'];
			$admin_revenue=$djax_win_bid_cpc['win_bid_amount'];
			}
		
			 $aQuery = array(			
			'creative_id'    => (int)$aData['creative_id'],
			'zone_id'        => (int)$aData['zone_id'],
			'dj_request_id'  => $request_id,
			'dj_win_bid'	 => $djax_win_bid_cpc['win_bid_amount'],
			'dj_publisher_revenue'=>$publisershare,
			'dj_admin_revenue'=> $admin_revenue,
			'timenow'	 	 => $time
			);	
							
    try {  
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();
		
		$zid=(!empty($aData['zone_id']))?$aData['zone_id']:$zoneId;	
		
		if($zid!=0)
		{				
        OX_Delivery_Common_hook('apDeliveryLogRedisClick', array($oDal, $adId, $zoneId));	
		return $oDal->logCount('clicks', $aData['interval_start'], $aQuery);
		}
		else
		{			
		OX_Delivery_Common_hook('apDeliveryLogRedisClickCompanion', array($oDal, $adId, $zoneId));		
        return $oDal->logCount('clickscompanion', $aData['interval_start'], $aQuery);  			
		}       
    } catch (Exception $e) { 

    }
}

function Plugin_deliveryLog_apLogConversionRedis_logConversion_Delivery_logConversion($trackerId, $serverRawIp, $aConversion, $okToLog = true,$device_type='')
{	
	
	if(empty($trackerId))
	{
		$trackerId = $_REQUEST['trackerid'];
	}
	$udid=$_REQUEST['udid'];
	$variables=$_REQUEST['variable'];
    if (!$okToLog) { return false; }

    if (empty($GLOBALS['_MAX']['NOW'])) {
        $GLOBALS['_MAX']['NOW'] = time();
    }
    $time = $GLOBALS['_MAX']['NOW'];
    $lcr_cookie = $GLOBALS['_MAX']['CONF']['var']['oxlcr'];
	
	$tracker_parameter=$aConversion['cid'].'_'. $aConversion['zid']; 
	$adId = $aConversion['cid'];
	$zoneId = $aConversion['zid'];
	$request_id=$_COOKIE[$lcr_cookie][$tracker_parameter];
	
	$djax_win_bid_cpa=djax_win_bid_calc($aConversion['cid']);	
	
	/* Special bidding options */
	/*$traffic_bid_rate=0;
	$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from ".$table_prefix."affiliates as oxa join ".$table_prefix."zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$aConversion['zid'].") AND (campaign_id='0' OR campaign_id IN (select campaignid from ".$table_prefix."banners where bannerid=".$aConversion['cid'].")) AND source_type='3'";
	$special_bidding=OA_Dal_Delivery_query($traffic_query);
	$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
	$traffic_bid_rate=$traffic_result['bid_rate']; 
				
	$hourly_query="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." where bannerid=".$aData['creative_id'].")  AND revenue_type='3'";
	$hourly_query_bidding=OA_Dal_Delivery_query($hourly_query);
	$hourly_result=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding);
															
	
	$country_val=$GLOBALS['_MAX']['CLIENT_GEO']['country_code'];
				
				
	if(!empty($traffic_bid_rate))
	{
		$djax_win_bid_cpa['win_bid_amount']=$traffic_bid_rate;
	}	
	else
	{
	    if($djax_win_bid_cpa['revenue_type']==3 || $djax_win_bid_cpa['revenue_type']==4 || $djax_win_bid_cpa['revenue_type']==5 || $djax_win_bid_cpa['revenue_type']==6 )
		{
			if(!empty($hourly_result['hourly_bid_rate']) && !empty($hourly_result['hourly_bid_timing']))
			{
				$times = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
				if($hourly_result['hourly_bid_timing'] == $times)	
				{				
					$djax_win_bid_cpa['win_bid_amount']=$hourly_result['hourly_bid_rate'];
				}
			}
			else
			{			
	     		$djax_win_bid_cpa['win_bid_amount'] = $djax_win_bid_cpa['win_bid_amount'];
			}
		}
		else
		{
				$djax_win_bid_cpa['win_bid_amount'] =0;
		}
	}*/
							
	if($aConversion['zid']==0 || empty($aConversion['zid']))
	{
	   		$zonequery=OA_Dal_Delivery_query("SELECT zone_id FROM djax_track_ad_requests WHERE request_id ='".$request_id."'")or die("SELECT query djax_track_ad_requests");
			$rowzoneid=OA_Dal_Delivery_fetchAssoc($zonequery);
			$aConversion['zid']= $rowzoneid['zone_id'];
	}
		
	/* DAC020 - Find the campaign type */
	$campaign_type=OA_Dal_Delivery_query("Select revenue_type,reset_pixel FROM ".$GLOBALS['_MAX']['CONF']['table']['prefix']."campaigns as c join ".$GLOBALS['_MAX']['CONF']['table']['prefix']."banners as b ON b.campaignid=c.campaignid where b.bannerid=".$aConversion['cid']);
	$camp_type=OA_Dal_Delivery_fetchAssoc($campaign_type);
	$cam_type=$camp_type['revenue_type'];
	$reset_pixel=$camp_type['reset_pixel'];
	
	/* DAC020 - Tracker */
	$tracker_type=OA_Dal_Delivery_query("Select pixel_category,pixel_goal FROM ".$GLOBALS['_MAX']['CONF']['table']['prefix']."trackers as t join ".$GLOBALS['_MAX']['CONF']['table']['prefix']."campaigns_trackers as ct ON ct.trackerid=t.trackerid where t.trackerid=".$trackerId);
	$track_type=OA_Dal_Delivery_fetchAssoc($tracker_type);
	$track_con_type=$track_type['pixel_category'];
	$pixel_goal=$track_type['pixel_goal'];
				
	if($cam_type=='1' || $cam_type=='2')
	{   
		$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.") AND revenue_type='3' AND country_value='$country_val'";								
		$special_country_bidding=OA_Dal_Delivery_query($country_query);
		$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
		$country_bid_rate=$bidding_result['bidding_value']; 

		$traffic_bid_rate=0;
		$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from rv_affiliates as oxa join rv_zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$zoneId.") AND (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND source_type='3'";				
		$special_bidding=OA_Dal_Delivery_query($traffic_query);
		$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
		$traffic_bid_rate=$traffic_result['bid_rate']; 
				
		$zone_query="select bid_rate from djax_campaign_zone_bidding where (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND zone_id=".$zoneId." AND status = '1' AND campaign_type='3'";
		$zone_query_bidding=OA_Dal_Delivery_query($zone_query);
		$zone_result=OA_Dal_Delivery_fetchAssoc($zone_query_bidding);

		$hourly_query3="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from rv_banners where bannerid=".$adId.")  AND revenue_type='3'";
		$hourly_query_bidding3=OA_Dal_Delivery_query($hourly_query3);
		$hourly_result3=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding3);
			
		if(!empty($country_bid_rate))
		{
			$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
		}
		else if(!empty($traffic_bid_rate))
		{
			$djax_win_bid_cpa['win_bid_amount']	=	$traffic_bid_rate;
		}	
		else if(!empty($zone_result))
		{
			$djax_win_bid_cpa['win_bid_amount']	=	$zone_result['bid_rate'];
		}					
		else if(!empty($hourly_result3['hourly_bid_rate']) && !empty($hourly_result3['hourly_bid_timing']))
		{
			$times3 = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
			if($hourly_result3['hourly_bid_timing'] == $times3)	
			{			
				$djax_win_bid_cpa['win_bid_amount']=$hourly_result3['hourly_bid_rate'];
			}
		}		
		else		
		{		
			if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
			{
				$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
			}
		}		
	}
	else if($cam_type=='3')
	{   
		$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.") AND revenue_type='3' AND country_value='$country_val'";								
		$special_country_bidding=OA_Dal_Delivery_query($country_query);
		$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
		$country_bid_rate=$bidding_result['bidding_value']; 

		$traffic_bid_rate=0;
		$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from rv_affiliates as oxa join rv_zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$zoneId.") AND (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND source_type='3'";
		$special_bidding=OA_Dal_Delivery_query($traffic_query);
		$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
		$traffic_bid_rate=$traffic_result['bid_rate']; 
				
		$zone_query="select bid_rate from djax_campaign_zone_bidding where (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND zone_id=".$zoneId." AND status = '1' AND campaign_type='3'";
		$zone_query_bidding=OA_Dal_Delivery_query($zone_query);
		$zone_result=OA_Dal_Delivery_fetchAssoc($zone_query_bidding);

		$hourly_query3="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from rv_banners where bannerid=".$adId.")  AND revenue_type='3'";
		$hourly_query_bidding3=OA_Dal_Delivery_query($hourly_query3);
		$hourly_result3=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding3);
			
		if(!empty($country_bid_rate))
		{
			$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
		}
		else if(!empty($traffic_bid_rate))
		{
			$djax_win_bid_cpa['win_bid_amount']	=	$traffic_bid_rate;
		}	
		else if(!empty($zone_result))
		{
			$djax_win_bid_cpa['win_bid_amount']	=	$zone_result['bid_rate'];
		}					
		else if(!empty($hourly_result3['hourly_bid_rate']) && !empty($hourly_result3['hourly_bid_timing']))
		{
			$times3 = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
			if($hourly_result3['hourly_bid_timing'] == $times3)	
			{			
				$djax_win_bid_cpa['win_bid_amount']=$hourly_result3['hourly_bid_rate'];
			}
		}		
		else		
		{		
			if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
			{
				$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
			}
		}
	
	}
	elseif($cam_type=='4')
	{   
		if($track_con_type=="lead")
		{
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.") AND revenue_type='4' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 		

			$traffic_bid_rate=0;
			$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from rv_affiliates as oxa join rv_zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$zoneId.") AND (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND source_type='4'";
			$special_bidding=OA_Dal_Delivery_query($traffic_query);
			$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
			$traffic_bid_rate=$traffic_result['bid_rate']; 
					
			$zone_query="select bid_rate from djax_campaign_zone_bidding where (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND zone_id=".$zoneId." AND status = '1' AND campaign_type='4' ";
			$zone_query_bidding=OA_Dal_Delivery_query($zone_query);
			$zone_result=OA_Dal_Delivery_fetchAssoc($zone_query_bidding);
		
			$hourly_query4="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from rv_banners where bannerid=".$adId.")  AND revenue_type='4'";
			$hourly_query_bidding4=OA_Dal_Delivery_query($hourly_query4);
			$hourly_result4=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding4);	
					
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else if(!empty($traffic_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']	=	$traffic_bid_rate;
			}								
			else if(!empty($zone_result))
			{
				$djax_win_bid_cpa['win_bid_amount']	=	$zone_result['bid_rate'];
			}			
			else if(!empty($hourly_result4['hourly_bid_rate']) && !empty($hourly_result4['hourly_bid_timing']))
			{
				$times4 = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
				if($hourly_result4['hourly_bid_timing'] == $times4)	
				{				
					$djax_win_bid_cpa['win_bid_amount']=$hourly_result4['hourly_bid_rate'];
				}
			}			
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}

		}
		else
		{
			return false;
		}
	}	
	elseif($cam_type=='5')
	{
		if($track_con_type=="sale")
		{		
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.") AND revenue_type='5' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 	

			$traffic_bid_rate=0;
			$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from rv_affiliates as oxa join rv_zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$zoneId.") AND (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND source_type='5'";			
			$special_bidding=OA_Dal_Delivery_query($traffic_query);
			$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
			$traffic_bid_rate=$traffic_result['bid_rate']; 
					
			$zone_query="select bid_rate from djax_campaign_zone_bidding where (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND zone_id=".$zoneId." AND status = '1' AND campaign_type='5'";
			$zone_query_bidding=OA_Dal_Delivery_query($zone_query);
			$zone_result=OA_Dal_Delivery_fetchAssoc($zone_query_bidding);
			
			$hourly_query5="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from rv_banners where bannerid=".$adId.")  AND revenue_type='5'";
			$hourly_query_bidding5=OA_Dal_Delivery_query($hourly_query5);
			$hourly_result5=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding5);
							
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else if(!empty($traffic_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']	=	$traffic_bid_rate;
			}						
			else if(!empty($zone_result))
			{
				$djax_win_bid_cpa['win_bid_amount']	=	$zone_result['bid_rate'];
			}			
			else if(!empty($hourly_result5['hourly_bid_rate']) && !empty($hourly_result5['hourly_bid_timing']))
			{
				$times5 = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
				if($hourly_result5['hourly_bid_timing'] == $times5)	
				{				
					$djax_win_bid_cpa['win_bid_amount']=$hourly_result5['hourly_bid_rate'];
				}
			}			
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
	
		}
		else
		{
			return false;
		}	
	}	
	elseif($cam_type=='6')
	{
		
		if($track_con_type=="install")
		{		
			$country_query="select bidding_value from djax_country_bidding AS b where campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.") AND revenue_type='6' AND country_value='$country_val'";								
			$special_country_bidding=OA_Dal_Delivery_query($country_query);
			$bidding_result=OA_Dal_Delivery_fetchAssoc($special_country_bidding);
			$country_bid_rate=$bidding_result['bidding_value']; 	

			$traffic_bid_rate=0;
			$traffic_query="select bid_rate from djax_campaign_traffic_source AS t where traffic_id IN (select account_id from rv_affiliates as oxa join rv_zones as oxz on oxa.affiliateid=oxz.affiliateid where oxz.zoneid=".$zoneId.") AND (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND source_type='6'";	
			$special_bidding=OA_Dal_Delivery_query($traffic_query);
			$traffic_result=OA_Dal_Delivery_fetchAssoc($special_bidding);
			$traffic_bid_rate=$traffic_result['bid_rate']; 
					
			$zone_query="select bid_rate from djax_campaign_zone_bidding where (campaign_id='0' OR campaign_id IN (select campaignid from rv_banners where bannerid=".$adId.")) AND zone_id=".$zoneId." AND status = '1' AND campaign_type='6'";
			$zone_query_bidding=OA_Dal_Delivery_query($zone_query);
			$zone_result=OA_Dal_Delivery_fetchAssoc($zone_query_bidding);
			
			$hourly_query6="select hourly_bid_rate,hourly_bid_timing from rv_campaigns where campaignid IN (select campaignid from rv_banners where bannerid=".$adId.")  AND revenue_type='6'";
			$hourly_query_bidding6=OA_Dal_Delivery_query($hourly_query6);
			$hourly_result6=OA_Dal_Delivery_fetchAssoc($hourly_query_bidding6);
							
			if(!empty($country_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']=$country_bid_rate;			
			}
			else if(!empty($traffic_bid_rate))
			{
				$djax_win_bid_cpa['win_bid_amount']	=	$traffic_bid_rate;
			}						
			else if(!empty($zone_result))
			{
				$djax_win_bid_cpa['win_bid_amount']	=	$zone_result['bid_rate'];
			}			
			else if(!empty($hourly_result6['hourly_bid_rate']) && !empty($hourly_result6['hourly_bid_timing']))
			{
				$times6 = date("H:00:00")." - ".date("H:00:00",strtotime('+1 hour'));
				if($hourly_result6['hourly_bid_timing'] == $times6)	
				{				
					$djax_win_bid_cpa['win_bid_amount']=$hourly_result6['hourly_bid_rate'];
				}
			}			
			else
			{		
				if($pixel_goal>$djax_win_bid_cpa['win_bid_amount'])
				{
					$djax_win_bid_cpa['win_bid_amount']=$pixel_goal;
				}
			}
	
		}	
		else
		{
			return false;
		}
	}	
	
	if(!empty($djax_win_bid_cpa))
	{
	    $detect_spent_amt=djax_detect_spent_amt_cpa($djax_win_bid_cpa);
	   // $detect_spent_amt=1;
	
	}
	
	$publisher_percentage=djax_publisher_share($aConversion['zid']);
	
	$publisershare=$djax_win_bid_cpa['win_bid_amount']*($publisher_percentage/100);
	
	$admin_revenue=$djax_win_bid_cpa['win_bid_amount']-$publisershare;
		//houseads conversion 
		$house_ads="select user_id from rv_users where user_id='1'";
		$house_ads_delivery=OA_Dal_Delivery_query($house_ads);
		$house_ads_result=OA_Dal_Delivery_fetchAssoc($house_ads_delivery);
		$house_ads_id=$house_ads_result['user_id']; 
		if(!$detect_spent_amt){
			if($house_ads_id==1)
			{
				$detect_spent_amt=1;
			}else
			{
			return false;
			}
		}			
	
    try { 
		if($reset_pixel==1)
		{
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();
        $aIds = $oDal->getUniqueIds('conversion');
				
        $aValues = $aIds + array(
			'server_ip'        => $serverRawIp,
            'tracker_id'       => $trackerId,
            'date_time'        => gmdate('Y-m-d H:i:s', $time),
            'action_date_time' => gmdate('Y-m-d H:i:s', $aConversion['dt']),
            'creative_id'      => $aConversion['cid'],
            'zone_id'          => $aConversion['zid'],
            'ip_address'       => $_SERVER['REMOTE_ADDR'],
            'action'           => $aConversion['action_type'],
            'window'           => $aConversion['window'],
            'status'           => $aConversion['status'],
			'dj_request_id'    => $request_id,
			'dj_win_bid'	   => $djax_win_bid_cpa['win_bid_amount'],
			'dj_publisher_revenue'=>$publisershare,
			'dj_admin_revenue' => $admin_revenue,
			'action_type'  	   => $aConversion['category'],
			'udid'             => $udid,
			'variables'        => $variables
        
        );
        //smart cpa test
        $cur_time=gmdate('Y-m-d H:i:s', $time);
		OA_Dal_Delivery_query("insert into djax_ad_smart_cpa(creative_id,zone_id,dj_request_id,dj_win_bid,dj_publisher_revenue,dj_admin_revenue,conversion,device_type,timenow) values('".$aConversion['cid']."','".$aConversion['zid']."','".$request_id."','". $djax_win_bid_cpa['win_bid_amount']."','".$publisershare."','".$admin_revenue."','1','".$device_type."','".$cur_time."')") or die(mysql_error());
		
		$oDal->logRaw('conversions', $aValues);    		
		
		OX_Delivery_Common_hook('apDeliveryLogRedisConversions', array($oDal, $adId, $zoneId));        
		
		return array(
            'server_conv_id' => $aIds['server_conv_id'],
            'server_raw_ip' => $aIds['server_ip'],
        );
	 }
	 elseif($house_ads_id==1)
	 {
		$oDal = new AP_DeliveryLogRedis_DAL_Delivery();
        $aIds = $oDal->getUniqueIds('conversion');
				
        $aValues = $aIds + array(
			'server_ip'        => $serverRawIp,
            'tracker_id'       => $trackerId,
            'date_time'        => gmdate('Y-m-d H:i:s', $time),
            'action_date_time' => gmdate('Y-m-d H:i:s', $aConversion['dt']),
            'creative_id'      => $aConversion['cid'],
            'zone_id'          => $aConversion['zid'],
            'ip_address'       => $_SERVER['REMOTE_ADDR'],
            'action'           => $aConversion['action_type'],
            'window'           => $aConversion['window'],
            'status'           => $aConversion['status'],
			'dj_request_id'    => $request_id,
			'dj_win_bid'	   => $djax_win_bid_cpa['win_bid_amount'],
			'dj_publisher_revenue'=>$publisershare,
			'dj_admin_revenue' => $admin_revenue,
			'action_type'  	   => $aConversion['category'],
			'udid'             => $udid,
			'variables'        => $variables
        
        );
		$chk_trac_count="INSERT INTO rv_pixeltext_conversion( date_time, ad_id, zone_id, requests, tracker_id) VALUES ('".$aValues['date_time']."','".$aValues['creative_id']."','".$aValues['zone_id']."','".$aValues['dj_request_id']."','".$aValues['tracker_id']."')";
		
		$trResult = OA_Dal_Delivery_query($chk_trac_count);
		
		$oDal->logRaw('conversions', $aValues);    		
		
		OX_Delivery_Common_hook('apDeliveryLogRedisConversions', array($oDal, $adId, $zoneId));        
		
		return array(
            'server_conv_id' => $aIds['server_conv_id'],
            'server_raw_ip' => $aIds['server_ip'],
        );
	 }
    } catch (Exception $e) {
        return false;
    }
}

function Plugin_deliveryLog_apLogConversionRedis_logConversionVariable_Delivery_logConversionVariable($aVariables, $trackerId, $serverConvId, $serverRawIp, $okToLog=true)
{
    if (!$okToLog) { return false; }

    if (empty($aVariables)) {
        return;
    }

    if (empty($GLOBALS['_MAX']['NOW'])) {
        $GLOBALS['_MAX']['NOW'] = time();
    }
    $time = $GLOBALS['_MAX']['NOW'];

    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        $date_time = gmdate('Y-m-d H:i:s', $time);

        $aData = array(
            'server_conv_id'    => (int)$serverConvId,
            'server_ip'         => $serverRawIp,
            'date_time'         => $date_time,
        );

        $res = 0;
        foreach ($aVariables as $aVariable) {
            $res |= (bool)$oDal->logRaw('conversion_vars', $aData + array(
                'tracker_variable_id' => (int)$aVariable['variable_id'],
                'value' => $aVariable['value'],
            ));
        }

        return $res;
    } catch (Exception $e) {

    }
}

function Plugin_deliveryLog_apLogVastRedis_logImpressionVast_Delivery_logImpressionVast($adId = 0, $zoneId = 0, $okToLog = true)
{	
    if (!$okToLog) { return false; }
    $aData = $GLOBALS['_MAX']['deliveryData'];
    $aQuery = array(
        'creative_id'    => $aData['creative_id'],
        'zone_id'        => $aData['zone_id'],
        'vast_event_id'  => $aData['vast_event_id'],
    );
    try {
        $oDal = new AP_DeliveryLogRedis_DAL_Delivery();

        OX_Delivery_Common_hook('apDeliveryRedisVastEvent', array($oDal, $adId, $zoneId, $eventId));

        return $oDal->logCount('vast_events', $aData['interval_start'], $aQuery);
    } catch (Exception $e) {

    }
}

/* Additional functions For Impressions - Start */
function djax_publisher_share($zoneid)
	{
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		$chk_pub_share="select a.dj_share_per as dj_share_per from 
		
		".$aConf['table']['prefix'].$aConf['table']['affiliates']." AS a,
		".$aConf['table']['prefix'].$aConf['table']['zones']." AS z
		
		where z.affiliateid=a.affiliateid and z.zoneid='$zoneid'";
		
		$rsResult = OA_Dal_Delivery_query($chk_pub_share);
					       
		$fetch_record=OA_Dal_Delivery_fetchAssoc($rsResult);
					
		if(!empty($fetch_record['dj_share_per']))
		{
							return $fetch_record['dj_share_per'];
		}
		else
		{
							
							$fetch_record=app_config();
						
							return $fetch_record['pub_min_share'];
		}
		
	}

function djax_win_count($request_id)
{
		$aConf = $GLOBALS['_MAX']['CONF'];

		$query="select r.win_bid_amount as win_bid_amount from 
		".OX_escapeIdentifier($aConf['table']['djax_track_ad_responses'])." AS r,  
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  AS c,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])."  AS b
		where r.request_id='$request_id' and  b.bannerid=r.ad_id and r.win_status='1' and c.revenue_type='1' and b.campaignid=c.campaignid";
		
		$rAdResponse=OA_Dal_Delivery_query($query);

		$result=OA_Dal_Delivery_numRows($rAdResponse);
		
		
		return $result;
}

function djax_win_bid_calc($bannerid)
{	
		
		$aConf = $GLOBALS['_MAX']['CONF'];

		$query="select c.campaignname,c.impression_count,c.conversion_count,c.clientid,c.revenue as win_bid_amount,c.revenue_type as revenuetype,c.clientid as clientid,c.campaignid as campaignid,c.dj_campaign_remain_budget as dj_campaign_remain_budget,c.dj_campaign_remain_total_budget as dj_campaign_remain_total_budget,c.dj_campaign_budget as dj_campaign_budget,c.daily_budget_unlimit as dj_budget_unlimit,c.dj_daily_budget as dj_daily_budget,c.test_budget as test_budget,c.smart_desktop_imp as smart_desktop_imp,c.smart_mobile_imp as smart_mobile_imp,c.smart_conversion as smart_conversion,c.smart_cpa as smart_cpa,cl.dj_cur_balance as dj_cur_balance,cl.dj_is_default as dj_is_default,cl.account_id as account_id,cl.clientname as clientname,cl.email as email from 
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." AS cl,  
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  AS c,
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])."  AS b
		where b.bannerid='$bannerid' and  c.clientid=cl.clientid and b.campaignid=c.campaignid";		
				
		$rAdResponse=OA_Dal_Delivery_query($query);

		$result=OA_Dal_Delivery_fetchAssoc($rAdResponse);
								
		return $result;
}
function djax_detect_spent_amt($results)
{  		
	
		$aConf = $GLOBALS['_MAX']['CONF'];

		$status='and dj_is_default!=1';
		
		$query="select dj_cur_balance,dj_is_default from ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." where clientid='".$results['clientid']."' $status ";	
				
		$rAdResponse=OA_Dal_Delivery_query($query);
						
		if(OA_Dal_Delivery_numRows($rAdResponse) > 0)
		{
			$res=OA_Dal_Delivery_fetchAssoc($rAdResponse);
									
			if($res['dj_cur_balance']>0)
			{
												
				$remain_balance=$results['dj_campaign_remain_budget'] + $results['win_bid_amount']; 
				
				$current_balance=$res['dj_cur_balance'] - $results['win_bid_amount']; 
	
				$remain_total_balance=$results['dj_campaign_remain_total_budget'] + $results['win_bid_amount'];   
											
				//////Update Remain budget
				$budget = OA_Dal_Delivery_query("SELECT dj_campaign_budget,dj_daily_budget,test_budget FROM 				
				".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
				where campaignid='".$results['campaignid']."'");
				
				$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);
				
				$campaign_budget = $fetch_budget['dj_campaign_budget'];

				$campaign_daily_budget = $fetch_budget['dj_daily_budget'];
				
				$campaign_test_budget = $fetch_budget['test_budget'];
				
				$campaign_test_remaining_budget = $campaign_test_budget - $remain_total_balance; 
				
					
				if($campaign_test_remaining_budget>0 && $results['smart_cpa']=='1')
				{
				$campaign_remaining_budget = $campaign_test_budget - $remain_total_balance; 
				}
				else
				{
					
				$campaign_remaining_budget = $campaign_budget - $remain_total_balance; 
				}
				//$campaign_remaining_budget = $campaign_budget - $remain_total_balance;    
				//checking for test smart cpa 
				if($campaign_test_remaining_budget<=0 && $results['smart_cpa']=='1')
				{
					//desktop limit
				$query= OA_Dal_Delivery_query("SELECT zone_id,sum(a.impression) as imp,sum(a.conversion) as conv   FROM ".OX_escapeIdentifier('djax_ad_smart_cpa')." AS a  WHERE a.device_type='web' AND a.zone_id in (SELECT azc.zone_id from ".OX_escapeIdentifier('rv_ad_zone_assoc')." AS azc  WHERE azc.ad_id IN (SELECT b.bannerid from ".OX_escapeIdentifier('rv_banners')." AS b where b.campaignid = '".$results['campaignid']."' ))" ) or die("Here:");
				$djax_res1[] = OA_Dal_Delivery_fetchAssoc($query);	
				//mobile limit
				$query_mobile= OA_Dal_Delivery_query("SELECT zone_id,sum(a.impression) as imp,sum(a.conversion) as conv   FROM ".OX_escapeIdentifier('djax_ad_smart_cpa')." AS a  WHERE a.device_type='mobile' AND a.zone_id in (SELECT azc.zone_id from ".OX_escapeIdentifier('rv_ad_zone_assoc')." AS azc  WHERE azc.ad_id IN (SELECT b.bannerid from ".OX_escapeIdentifier('rv_banners')." AS b where b.campaignid = '".$results['campaignid']."' ))" ) or die("Here:");
				$djax_mob[] = OA_Dal_Delivery_fetchAssoc($query_mobile);
				//conversion limit
				$query_conv= OA_Dal_Delivery_query("SELECT zone_id,sum(a.impression) as imp,sum(a.conversion) as conv   FROM ".OX_escapeIdentifier('djax_ad_smart_cpa')." AS a  WHERE a.device_type='mobile' AND a.zone_id in (SELECT azc.zone_id from ".OX_escapeIdentifier('rv_ad_zone_assoc')." AS azc  WHERE azc.ad_id IN (SELECT b.bannerid from ".OX_escapeIdentifier('rv_banners')." AS b where b.campaignid = '".$results['campaignid']."' ))" ) or die("Here:");
				$djax_conv[] = OA_Dal_Delivery_fetchAssoc($query_conv);
				$j=0;
				for($i=0;$i<count($djax_res1);$i++)
				{
					if($djax_res1[$i]['imp']>=$results['smart_desktop_imp']  && $djax_mob[$i]['imp']>=$results['smart_mobile_imp']&& $djax_conv[$i]['conv']>=$results['smart_conversion'])
					{
					$j=1;
					}
				}
				if($j==0)
				{
				OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=2 where campaignid='".$results['campaignid']."'") or die("error");
				}
			}	
				$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance;  
					
				if($campaign_remaining_budget > 0 && $campaign_remaining_daily_budget > 0)
				{	
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance',wcamp_remain='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");
							
					if($res['dj_is_default']!='2')
					{
							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])."  
							set dj_cur_balance='$current_balance' where clientid='".$results['clientid']."'");
					}
					return true;					
				}
				else
				{    

					/* Code for issue fixing - 172681 - start*/
					
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance',wcamp_remain='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");
							
					/* Code for issue fixing - 172681 - end*/
										
					if($campaign_remaining_budget <= 0)
					{
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=3 where campaignid='".$results['campaignid']."'") or die("error");
					}
					if($results['dj_budget_unlimit']!='1')
					{						
					if($campaign_remaining_daily_budget <= 0)
					{						
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=8,dj_budget_status=1 where campaignid='".$results['campaignid']."'") or die("error");
					}
					}
					
					return true;					
				}
				/*if($campaign_test_remaining_budget<=0 && $smart_cpa=='1')
				{ 
				$query= OA_Dal_Delivery_query("SELECT zone_id,sum(a.impression) FROM ".OX_escapeIdentifier('djax_ad_smart_cpa')." AS a  WHERE a.zone_id in (SELECT azc.zone_id from ".OX_escapeIdentifier('rv_ad_zone_assoc')." AS azc  WHERE azc.ad_id IN (SELECT b.bannerid from ".OX_escapeIdentifier('rv_banners')." AS b where b.campaignid = '".$results['campaignid']."' ))" ) or die("Here:");
				$djax_res = OA_Dal_Delivery_fetchAssoc($query);	
				print_r($djax_res);exit;
				}*/
			}
		}
}
/* Additional Functions for Impressions - End */

/* Clicks - Start */

function djax_fraud_click($adId,$zoneId,$loc)
{		
		$aConf = $GLOBALS['_MAX']['CONF'];
		$clk_reset = 0;
		$clk_cap = 0;
		
		$djax_affiliate=OA_Dal_Delivery_query("SELECT affiliateid FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])."  where zoneid='$zoneId'");
			
		$djax_res = OA_Dal_Delivery_fetchAssoc($djax_affiliate);
		
		$pub_id=$djax_res['affiliateid'];  
		
		$getbanrow=app_config();
				
		if($getbanrow>0)
		{
			$clicknum  = $getbanrow['antifraud_clicknum']; 
			$resettime = $getbanrow['antifraud_reset_time']; 
			$threshold = $getbanrow['antifraud_threshold']; 
		}
						
		$djax_resettime = time() - $resettime;
		
		$djax_imp_resettime = date("Y-m-d H:i:s",$djax_resettime);
		
		$datetime=date("Y-m-d H:i:s");

		$country_name = $GLOBALS['_MAX']['CLIENT_GEO'];

		$countryname = $country_name['country_code'];
		
		$viewrid = $GLOBALS['_MAX']['CONF']['var']['viewrid'];
		
		$current_viewerid=$_COOKIE[$viewrid];

		$logclicks=1;	
		
		$budget = OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." as c join ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." as b ON b.campaignid=c.campaignid
		where bannerid='$adId'");
						
		$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);	
			
		$daily_budget_unlimit=$fetch_budget['daily_budget_unlimit'];
		
		$campaign_budget = $fetch_budget['dj_campaign_budget'];
							
		$campaign_revenue_type = $fetch_budget['revenue_type']; 		
			
		if($campaign_revenue_type=="1")
		{
			//$campaign_revenue = $fetch_budget['revenue']/1000;
			$campaign_revenue = $fetch_budget['revenue'];
		}
		else
		{
			$campaign_revenue = $fetch_budget['revenue'];
		}
			
		$remain_balance=$fetch_budget['dj_campaign_remain_budget'];	 
		
		$remain_total_balance=$fetch_budget['dj_campaign_remain_total_budget'];
			
		$campaign_remaining_budget = $campaign_budget - $remain_total_balance;  

		if($daily_budget_unlimit!='1')
		{
			$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance; 
			$campaign_daily_budget = $fetch_budget['dj_daily_budget']; 
		}		
										
		if($campaign_budget > $campaign_revenue)
		{    		
			if($campaign_remaining_budget > 0)
			{
				if($daily_budget_unlimit!='1')
				{
					if($campaign_daily_budget > $campaign_revenue && $campaign_remaining_daily_budget > 0)
					{
						//return true; 
					}
				}
				
				
				if($clicknum!=0 && $resettime!=0)
				{	
					
					$getimpres = OA_Dal_Delivery_query("Select * from ".OX_escapeIdentifier('djax_ad_zone_click')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC") or die("Here:");
																					
					if(OA_Dal_Delivery_numRows($getimpres)>=$clicknum)
					{  
						$logclicks = 0;
					}
					
				}
				
				
				if($logclicks!=0)
				{		
					$host=$_SERVER['REMOTE_ADDR'];
					OA_Dal_Delivery_query("insert into ".OX_escapeIdentifier('djax_ad_zone_click')."(viewer_id,date_time,ad_id,zone_id,pub_id,country,ipaddress,url) values('".$current_viewerid."','".$datetime."','".$adId."','".$zoneId."','$pub_id','$countryname','".$_SERVER['REMOTE_ADDR']."','".$loc."')") or die(mysql_error());			
					return 1;  
					
				}
				else
				{						
			
					////////Djax Adexchange Valid click//////

					$penalty=OA_Dal_Delivery_query("Select count(viewer_id) as count from ".OX_escapeIdentifier('djax_ad_zone_click')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC") or die(mysql_error());
					$putpenalty=OA_Dal_Delivery_fetchAssoc($penalty);
				
					///////fraud click///////////////////

					$fraud=OA_Dal_Delivery_query("Select count(viewer_id) as count from ".OX_escapeIdentifier('djax_ad_fraud_click')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC")or die(mysql_error());
					$frudpoint=OA_Dal_Delivery_fetchAssoc($fraud);

					   
					$totalpenalty=$putpenalty['count']+$frudpoint['count'];
			  
			   
					if($frudpoint['count']>=$threshold)
					{
			
						$getpubdetails=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])." AS z, ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['affiliates'])." AS a where z.zoneid='$zoneId' and z.affiliateid=a.affiliateid"));

						$penaltyval=OA_Dal_Delivery_query("select pubid,zone_id,penaltypoint from ".OX_escapeIdentifier($aConf['table']['djax_penalty'])." where zone_id='".$zoneId."' and pubid='".$getpubdetails['affiliateid']."'");

						$penaltyres=OA_Dal_Delivery_fetchAssoc($penaltyval);
						
						
						$date_time=date("Y-m-d H");

						if(OA_Dal_Delivery_numRows($penaltyval)>0)
						{

							$point=$penaltyres['penaltypoint']+1;

							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['djax_penalty'])." set penaltypoint='$point' where zone_id='".$penaltyres['zone_id']."' and pubid='".$penaltyres['pubid']."'");
						}
						else
						{
						
							OA_Dal_Delivery_query("INSERT INTO ".OX_escapeIdentifier($aConf['table']['djax_penalty'])."(id,interval_start,pubname,penaltypoint,pubid,zone_id,country) VALUES ('','$date_time','".$getpubdetails['name']."', '1','".$getpubdetails['affiliateid']."','".$zoneId."','".$countryname."')");
						}

						$current_date=date('Y-m-d',mktime(0,0,0,date('m'),date('d'),date('Y')));

						///////////////////////////Sent - Fraud Click Mail Once a Day//////////////////////

						$check_mail_sent=mysql_query("select * from ".OX_escapeIdentifier($aConf['table']['djax_anti_fraud_mail'])."  where  publisher_id='".$getpubdetails['affiliateid']."' and date='$current_date' and viewer_id='$current_viewerid'");


						if(mysql_num_rows($check_mail_sent)>0)
						{

							$adminquery=mysql_query("SELECT * FROM  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['users'])." WHERE default_account_id=1")or die("sre");

							$fetchemail=mysql_fetch_array($adminquery);


							if($zoneId!=0)
							{
								$to      =$getpubdetails['email_address'];
								$subject = 'Regarding Ad delivery';
								$message = 'Your website getting more traffic from this IP for example '.$_SERVER['REMOTE_ADDR'].',Can you block  this IP for particular period or block this ip permanently? ';
								$headers = 'From: '.$fetchemail['email_address'].'' . "\r\n";


								mail($to, $subject, $message, $headers);

							}
							
						}
						else
						{
							OA_Dal_Delivery_query("INSERT INTO ".OX_escapeIdentifier('djax_anti_fraud_mail')."(date,publisher_id,status,viewer_id) VALUES ('$current_date', '".$getpubdetails['affiliateid']."','1','$current_viewerid')") or die("error1");

							OA_Dal_Delivery_query("delete from ".OX_escapeIdentifier('djax_anti_fraud_mail')." where publisher_id='".$getpubdetails['affiliateid']."' and date<='".$current_date."' and viewer_id='".$current_viewerid."'" ) or die("error2");

						}
				///////////////////////////Sent - Fraud Click Mail Once a Day//////////////////////			
				}
			
						OA_Dal_Delivery_query("insert into ".OX_escapeIdentifier('djax_ad_fraud_click')."(viewer_id,date_time,ad_id,zone_id,pub_id,country,ipaddress,url) values('".$current_viewerid."','".$datetime."','".$adId."','".$zoneId."','$pub_id','$countryname','".$_SERVER['REMOTE_ADDR']."','".$loc."')") or die(mysql_error());

					return 0;
			
				}
			
			}

		}

}
/*Impression -start*/

function djax_fraud_impression($adId,$zoneId)
{		
		$aConf = $GLOBALS['_MAX']['CONF'];
		$imp_reset = 0;
		$imp_cap = 0;
		
		$djax_affiliate=OA_Dal_Delivery_query("SELECT affiliateid FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])."  where zoneid='$zoneId'");
			
		$djax_res = OA_Dal_Delivery_fetchAssoc($djax_affiliate);
		
		$pub_id=$djax_res['affiliateid'];  
		
		$getbanrow=app_config();
			
		if($getbanrow>0)
		{
			$impressionnum   = $getbanrow['antifraud_impnum']; 
			$resettime 		 = $getbanrow['antifraud_imp_reset_time']; 
			$threshold		 = $getbanrow['antifraud_imp_threshold']; 
		}
						
		$djax_resettime = time() - $resettime;
		
		$djax_imp_resettime = date("Y-m-d H:i:s",$djax_resettime);
		
		$datetime=date("Y-m-d H:i:s");

		$country_name = $GLOBALS['_MAX']['CLIENT_GEO'];

		$countryname = $country_name['country_code'];
		
		$viewrid = $GLOBALS['_MAX']['CONF']['var']['viewrid'];
		
		$current_viewerid=$_COOKIE[$viewrid];

		$logimpression=1;	
		
		$budget = OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." as c join ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['banners'])." as b ON b.campaignid=c.campaignid
		where bannerid='$adId'");
						
		$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);	
			
		$daily_budget_unlimit=$fetch_budget['daily_budget_unlimit'];
		
		$campaign_budget = $fetch_budget['dj_campaign_budget'];
							
		$campaign_revenue_type = $fetch_budget['revenue_type']; 		
			
		if($campaign_revenue_type=="1")
		{
			//$campaign_revenue = $fetch_budget['revenue']/1000;
			$campaign_revenue = $fetch_budget['revenue'];
		}
		else
		{
			$campaign_revenue = $fetch_budget['revenue'];
		}
			
		$remain_balance=$fetch_budget['dj_campaign_remain_budget'];	 
		
		$remain_total_balance=$fetch_budget['dj_campaign_remain_total_budget'];
			
		$campaign_remaining_budget = $campaign_budget - $remain_total_balance;  

		if($daily_budget_unlimit!='1')
		{
			$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance; 
			$campaign_daily_budget = $fetch_budget['dj_daily_budget']; 
		}		
										
		if($campaign_budget > $campaign_revenue)
		{    		
			if($campaign_remaining_budget > 0)
			{
				if($daily_budget_unlimit!='1')
				{
					if($campaign_daily_budget > $campaign_revenue && $campaign_remaining_daily_budget > 0)
					{
						//return true; 
					}
				}
				
				
				if($impressionnum!=0 && $resettime!=0)
				{	
					
					$getimpres = OA_Dal_Delivery_query("Select * from ".OX_escapeIdentifier('djax_ad_zone_impression')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC") or die("Here:");
						//print_r(OA_Dal_Delivery_numRows($getimpres));echo '<br>'.$impressionnum;															
					if(OA_Dal_Delivery_numRows($getimpres)>=$impressionnum)
					{  
						$logimpression = 0;
					}
					
				}
				
				
				if($logimpression!=0)
				{		
					$host=$_SERVER['REMOTE_ADDR'];
					OA_Dal_Delivery_query("insert into ".OX_escapeIdentifier('djax_ad_zone_impression')."(viewer_id,date_time,ad_id,zone_id,pub_id,country,ipaddress,url) values('".$current_viewerid."','".$datetime."','".$adId."','".$zoneId."','$pub_id','$countryname','".$_SERVER['REMOTE_ADDR']."','".$loc."')") or die(mysql_error());			
					return 1;  
					
				}
				else
				{						
			
					////////Djax Adexchange Valid impression//////

					$penalty=OA_Dal_Delivery_query("Select count(viewer_id) as count from ".OX_escapeIdentifier('djax_ad_zone_impression')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC") or die(mysql_error());
					$putpenalty=OA_Dal_Delivery_fetchAssoc($penalty);
				
					///////fraud impression///////////////////

					$fraud=OA_Dal_Delivery_query("Select count(viewer_id) as count from ".OX_escapeIdentifier('djax_ad_fraud_impression')." WHERE viewer_id='".$current_viewerid."' AND ad_id=".$adId." AND zone_id='".$zoneId."' AND date_time >= '".$djax_imp_resettime."' ORDER By date_time DESC")or die(mysql_error());
					$frudpoint=OA_Dal_Delivery_fetchAssoc($fraud);

					   
					$totalpenalty=$putpenalty['count']+$frudpoint['count'];
			  
			
					if($frudpoint['count']>=$threshold)
					{
			 
						$getpubdetails=OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT * FROM ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])." AS z, ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['affiliates'])." AS a where z.zoneid='$zoneId' and z.affiliateid=a.affiliateid"));

						$penaltyval=OA_Dal_Delivery_query("select pubid,zone_id,penaltypoint from ".OX_escapeIdentifier($aConf['table']['djax_imp_penalty'])." where zone_id='".$zoneId."' and pubid='".$getpubdetails['affiliateid']."'");

						$penaltyres=OA_Dal_Delivery_fetchAssoc($penaltyval);
						
						
						$date_time=date("Y-m-d H");

						if(OA_Dal_Delivery_numRows($penaltyval)>0)
						{ 

							$point=$penaltyres['penaltypoint']+1;

							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['djax_imp_penalty'])." set penaltypoint='$point' where zone_id='".$penaltyres['zone_id']."' and pubid='".$penaltyres['pubid']."'");
						}
						else
						{
						
							$val_id = OA_Dal_Delivery_query("INSERT INTO ".OX_escapeIdentifier($aConf['table']['djax_imp_penalty'])."(id,interval_start,pubname,penaltypoint,pubid,zone_id,country) VALUES ('','$date_time','".$getpubdetails['name']."', '1','".$getpubdetails['affiliateid']."','".$zoneId."','".$countryname."')");
							
						}

						$current_date=date('Y-m-d',mktime(0,0,0,date('m'),date('d'),date('Y')));

						///////////////////////////Sent - Fraud impression Mail Once a Day//////////////////////

						$check_mail_sent=mysql_query("select * from ".OX_escapeIdentifier($aConf['table']['djax_anti_fraud_mail'])."  where  publisher_id='".$getpubdetails['affiliateid']."' and date='$current_date' and viewer_id='$current_viewerid'");


						if(mysql_num_rows($check_mail_sent)>0)
						{

							$adminquery=mysql_query("SELECT * FROM  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['users'])." WHERE default_account_id=1")or die("sre");

							$fetchemail=mysql_fetch_array($adminquery);


							if($zoneId!=0)
							{
								$to      =$getpubdetails['email_address'];
								$subject = 'Regarding Ad delivery';
								$message = 'Your website getting more traffic from this IP for example '.$_SERVER['REMOTE_ADDR'].',Can you block  this IP for particular period or block this ip permanently? ';
								$headers = 'From: '.$fetchemail['email_address'].'' . "\r\n";


								mail($to, $subject, $message, $headers);

							}
							
						}
						else
						{
							OA_Dal_Delivery_query("INSERT INTO ".OX_escapeIdentifier('djax_anti_fraud_mail')."(date,publisher_id,status,viewer_id) VALUES ('$current_date', '".$getpubdetails['affiliateid']."','1','$current_viewerid')") or die("error1");

							OA_Dal_Delivery_query("delete from ".OX_escapeIdentifier('djax_anti_fraud_mail')." where publisher_id='".$getpubdetails['affiliateid']."' and date<='".$current_date."' and viewer_id='".$current_viewerid."'" ) or die("error2");

						}
				///////////////////////////Sent - Fraud impression Mail Once a Day//////////////////////			
				}
			
						OA_Dal_Delivery_query("insert into ".OX_escapeIdentifier('djax_ad_fraud_impression')."(viewer_id,date_time,ad_id,zone_id,pub_id,country,ipaddress,url) values('".$current_viewerid."','".$datetime."','".$adId."','".$zoneId."','$pub_id','$countryname','".$_SERVER['REMOTE_ADDR']."','".$loc."')") or die(mysql_error());

					return 0;
			
				}
			
			}

		}

}


/*Impression -End*/

function app_config()
{
	$app_config = 'select * from djax_app_configurations';
				
	$config_query = OA_Dal_Delivery_query($app_config);
				
	$data_config  = OA_Dal_Delivery_fetchAssoc($config_query);		

	return $data_config;
	
}
/*Clicks - End*/



function djax_detect_spent_amt_cpa($results)
{
	
		$aConf = $GLOBALS['_MAX']['CONF'];

		$status='and dj_is_default!=1';
		
		$query="select dj_cur_balance,dj_is_default from
		".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])." 
		where clientid='".$results['clientid']."' $status ";	
				
		$rAdResponse=OA_Dal_Delivery_query($query);
		//print_r($rAdResponse);die("khlkhl");				
		if(OA_Dal_Delivery_numRows($rAdResponse) > 0)
		{
			$res=OA_Dal_Delivery_fetchAssoc($rAdResponse);
									
			if($res['dj_cur_balance']>0)
			{
				$remain_balance=$results['dj_campaign_remain_budget'] + $results['win_bid_amount'];
				
				$current_balance=$res['dj_cur_balance'] - $results['win_bid_amount'];
							
				$remain_total_balance=$results['dj_campaign_remain_total_budget'] + $results['win_bid_amount'];
								
				//////Update Remain budget
				$budget = OA_Dal_Delivery_query("SELECT dj_campaign_budget,dj_daily_budget FROM 				
				".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
				where campaignid='".$results['campaignid']."'");
				
				$fetch_budget = OA_Dal_Delivery_fetchAssoc($budget);

				$campaign_budget = $fetch_budget['dj_campaign_budget'];

				$campaign_daily_budget = $fetch_budget['dj_daily_budget'];
				
				$campaign_remaining_budget = $campaign_budget - $remain_total_balance;    

				$campaign_remaining_daily_budget = $campaign_daily_budget - $remain_balance;  

				if($campaign_remaining_budget >= 0 && $campaign_remaining_daily_budget >= 0)
				{						
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");

					if($res['dj_is_default']!='2')
					{
							OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients'])."  
							set dj_cur_balance='$current_balance' where clientid='".$results['clientid']."'");
					}
					//return true;					
				}
				else
				{      
					/* Code for issue fixing - 172681 - start*/
					
					OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
					set dj_campaign_remain_budget='$remain_balance',dj_campaign_remain_total_budget='$remain_total_balance' where campaignid='".$results['campaignid']."'") or die("error");
					
					/* Code for issue fixing - 172681 - end*/
					
					if($results['dj_budget_status']!='1')
					{
					if($campaign_remaining_budget <= 0)
					{
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=3 where campaignid='".$results['campaignid']."'") or die("error");
					}					
					if($campaign_remaining_daily_budget <= 0)
					{						
						OA_Dal_Delivery_query("update ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."  
						set status=8,dj_budget_status=1 where campaignid='".$results['campaignid']."'") or die("error");
					}
					}
					
					//return true;					
				}
				
				//*******************************Update conversion in rv_campaign table and to send mail on reaching conversion limit****************************************//
			
			
			//select conversion_count from rv_campaigns
			$rsResult_conv = OA_Dal_Delivery_query("select campaignname,impression_count,conversion_count,clientid from  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])."   where campaignid=".$results['campaignid']);
			
			$fetch_record2=OA_Dal_Delivery_fetchAssoc($rsResult_conv);
			
		
			//select account_id from clients 
			$account = OA_Dal_Delivery_query('select account_id,clientname,email from '.OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['clients']).' where clientid='.$fetch_record2['clientid']);
				
			$dj_acoount_id  = OA_Dal_Delivery_fetchAssoc($account);
			
			//selecting advertiser/publisher message settings			
			$db = 'select * from djax_adv_pub_notification_settings where account_id='.$dj_acoount_id['account_id'];
			
			$jb = OA_Dal_Delivery_query($db);
				
			$djax_adv_pub  = OA_Dal_Delivery_fetchAssoc($jb);
			
			
			$enable_disable = $djax_adv_pub['msg_adv_pub_enable'];
			
			//selecting app configuration settings
				
			$app_config = 'select * from djax_app_configurations';
				
			$config_query = OA_Dal_Delivery_query($app_config);
				
			$data_config  = OA_Dal_Delivery_fetchAssoc($config_query);
			$user_details      = djax_admin_detail();
			$admin_name        = $user_details['first_name'] . ' ' . $user_details['last_name'];
			$admin_email       = $user_details['email_address'];
			if($data_config['adv_pub_msg'] == 'enable')
			{
				if($enable_disable)
					{
						$string = 'conversion';
				
						if(strpos($djax_adv_pub['campaign_tracking'],$string)!== false)
						{
						$msg_type = $djax_adv_pub['msg_type'];
						}
						else{
						$msg_type = null;
						}
			   
					}
					else{
						$msg_type = null;
						}
			
			}
			else{
					$msg_type = $data_config['message_type'];
			}
	
			
			//Hi, Conversion Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thanks and Regards,<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" ;
						
				
			if(($fetch_record2['conversion_count']===$djax_adv_pub['conversion_limit'])==TRUE)
			{			
				
				OA_Dal_Delivery_query("update  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set conversion_count='0',status=8 where campaignid=".$results['campaignid']);

				$message = "Conversion Limit  has been reached for the campaign <b>".$fetch_record2['campaignname']."</b><br>" ;
				$mails = '<table border="0" width="600" cellpadding="0" cellspacing="0">
								<tr>
								<td style="color:#333333 !important; padding-left:20px;" height="40">
								
								 Conversion Limit  has been reached for the campaign <b>'.$fetch_record2['campaignname'].'</b><br>
								</td>
								</tr>
								</table>
								
								';
			$mail_content = '<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td>
											<table border="0" width="600" cellpadding="0" cellspacing="0">
											<tr>
											<td font-size:24px; font-family: Arial, Verdana, sans-serif;  height="40">
												<p style="line-height:12px;">Hi ' . $dj_acoount_id['clientname'] . ',</p></td>
											</tr>
											</table>
											</td>
											</tr>
											</table>'.$mails.'
											<table border="0" width="600" cellpadding="0" cellspacing="0">
											<tr>
											<td style="color:#333333 !important; padding-right:45px; font-size:20px; font-family: Arial, Verdana, sans-serif;  height="40">
											<p line-height:12px;">With Regards,</p>
											<p  line-height:12px;">' . $admin_name . '</p>
											</td>
											</tr>
											</table>';
				if($msg_type=='email' || $msg_type=='both')
				{
					$mail='';
					$from_add = $admin_email; 
					$to_add = $dj_acoount_id['email']; 
					$subject = "Warning: Conversion Limit Reached";
					$headers = "MIME-Version: 1.0" . "\r\n";
					$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
					$headers .= "From: $from_add \r\n";
					$headers .= "Reply-To: $from_add \r\n";
					$headers .= "Return-Path: $from_add\r\n";
					$headers .= "X-Mailer: PHP \r\n";
					//mail($to_add,$subject,$mail_content,$headers);

				}
				if($msg_type=='both' || $msg_type=='msg')
				{
					$msg_query1 = "INSERT INTO `rv_djax_messages` (`id` ,`sender_id` ,`receiver_id` ,`subject` ,`content` ,
	`date` ,`image_name` ,`file_name` ,`account_type` ,`status` ,`network_id` ,`is_deleted` ,`sender_is_deleted` ,`msg_type`
	)VALUES (NULL , '2', '".$dj_acoount_id['account_id']."', 'Conversion Limit Reached','".$message."', '".date('Y-m-d H:i:s')."', 'NULL', 'NULL', 'ADVERTISER', '0', '1', '0', '', '')";
					$msg_query=OA_Dal_Delivery_query($msg_query1); 
				}
				return false;
			}
			else{
				//$con_count = $fetch_record2['conversion_count']+1;
			OA_Dal_Delivery_query("update  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'])." set conversion_count=".$fetch_record2['conversion_count']."+1 where campaignid=".$results['campaignid']);
			//main_fn();
				return true;
			}
			
			//*******************************Update conversion in rv_campaign table and to send mail on reaching conversion limit****************************************//
			
			}
		}
}
function djax_admin_detail()
{
    $conf = $GLOBALS['_MAX']['CONF'];
    
    $query = "select first_name,last_name,email_address from  djax_networks";
    
    $rsresult = OA_Dal_Delivery_query($query);
    
    $rs_admin = OA_Dal_Delivery_fetchAssoc($rsresult);
    
    return $rs_admin;
    
}

function djax_fixed_cpm($zoneid)
{
	 $aConf = $GLOBALS['_MAX']['CONF'];
	 $fixed_val = OA_Dal_Delivery_query("select fixed_cpm from  ".OX_escapeIdentifier($aConf['table']['prefix'].$aConf['table']['zones'])." where zoneid=".$zoneid);
	 $result = OA_Dal_Delivery_fetchAssoc($fixed_val);
	 return $result;
}
