<?php

/**
 * apDeliveryLogRedis for Revive Adserver and OpenX Source
 *
 * @author Matteo Beccati
 * @copyright 2013-2015 AdserverPlugins.com - All rights reserved
 *
 */


require_once dirname(__FILE__).'/../Admin.php';


class AP_DeliveryLogRedis_DAL_Admin_Pgsql extends AP_DeliveryLogRedis_DAL_Admin
{
    protected function prepareUpdateQuery($tableName, $aQuery, $count)
    {
        $args = implode(',', $this->quoteArgs($aQuery));
        $count = (int)$count;
        $query = "SELECT bucket_update_{$tableName}({$args}, {$count})";
        return $query;
    }

    protected function quoteArgs($aArgs)
    {
        $array = $aArgs;
        foreach ($array as &$value) {
            if (!is_integer($value)) {
                $value = "'".$this->oDbh->escape($value)."'";
            }
        }
        return $array;
    }
}
