<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    MaxDelivery
 * @subpackage adSelect
 *
 * This library contains the functions to select an ad either by zone or direct selection
 * and generate the HTML for an ad
 *
 * The code below makes several references to an "ad-array", this is /almost/ an ad-object, and implements
 * the following interface.
 *
 * Array
 *   (
 *       [ad_id] => 123
 *       [placement_id] => 4
 *       [active] => t
 *       [name] => Web Flash (With backup)
 *       [type] => web
 *       [contenttype] => swf
 *       [pluginversion] => 6
 *       [filename] => banner_468x60.swf
 *       [imageurl] =>
 *       [htmltemplate] =>
 *       [htmlcache] =>
 *       [width] => 468
 *       [height] => 60
 *       [weight] => 1
 *       [seq] => 0
 *       [target] => _blank
 *       [url] => http://www.example.net/landing_page/
 *       [alt] =>
 *       [status] =>
 *       [bannertext] =>
 *       [adserver] =>
 *       [block] => 0
 *       [capping] => 0
 *       [session_capping] => 0
 *       [compiledlimitation] =>
 *       [acl_plugins] =>
 *       [append] =>
 *       [appendtype] => 0
 *       [bannertype] => 0
 *       [alt_filename] => backup_banner_468x60.gif
 *       [alt_imageurl] =>
 *       [alt_contenttype] => gif
 *       [campaign_priority] => 5
 *       [campaign_weight] => 0
 *       [campaign_companion] => 0
 *       [priority] => 0.10989010989
 *       [zoneid] => 567
 *       [bannerid] => 123
 *       [storagetype] => web
 *       [campaignid] => 4
 *       [zone_companion] =>
 *       [prepend] =>
 *   )
 *
 */

require_once MAX_PATH . '/lib/max/Delivery/limitations.php';
require_once MAX_PATH . '/lib/max/Delivery/adRender.php';
require_once MAX_PATH . '/lib/max/Delivery/cache.php';
require_once MAX_PATH . '/www/delivery/djax_tracking.php';


define ("PRI_ECPM_FROM", 6);
define ("PRI_ECPM_TO", 9);

/**
 * A "constant" that is used by _adSelect() to inform the caller _adSelectCommon()
 * that any other remaining campaign priority levels need to be skipped.
 *
 * @var int
 */
$GLOBALS['OX_adSelect_SkipOtherPriorityLevels'] = -1;


/**
 * This is the main ad selection and rendering function
 *
 * @param string  $what         The ad-selection string, colon seperated name=value
 *                              e.g. bannerid=X, campaignid=Y, zone:Z or search:criteria
 * @param string  $campaignid   The campaign ID to fecth banners from, added in 2.3.32 to allow BC with 2.0
 * @param string  $target       The target attribute for generated <a href> links
 * @param string  $source       The "source" parameter passed into the adcall
 * @param int     $withtext     Should "text below banner" be appended to the generated code
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param boolean $richmedia    Does this invocation method allow for serving 3rd party/html ads
 * @param string  $ct0          The 3rd party click tracking URL to redirect to after logging
 * @param string  $loc          The "current page" URL
 * @param string  $referer      The "referring page" URL
 *
 * @return array                An array containing selected banner information, including generated HTML
 *                      example:
 *                      Array
 *                      (
 *                          [html] =>
 *                              <div id='m3_7e8d56ca8e5231613e0c41ab149b8cab' style='display: inline;'><a href='http://d.dev.m3.net/ck.php?maxparams=2__bannerid=123__zoneid=567__cb=7ff857d85a' target='_blank'><img src='http://max.images.example.net/backup_banner_468x60.gif' width='468' height='60' alt='' title='' border='0'></a></div>
 *                              <script type='text/javascript'>
 *                                  var fo = new FlashObject('http://max.images.example.net/banner_468x60.swf?clickTARGET=_blank&clickTAG=http://delivery.max.example.com/ck.php?maxparams=2__bannerid=123__zoneid=567__cb=7ff857d85a', 'mymovie', '468', '60', '6');
 *                                  //fo.addParam('wmode','transparent');
 *                                  fo.write('m3_7e8d56ca8e5231613e0c41ab149b8cab');
 *                              </script><div id='beacon_123' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='http://delivery.max.example.com/lg.php?bannerid=123&amp;campaignid=4&amp;zoneid=567&amp;source=&amp;block=0&amp;capping=0&amp;session_capping=0&amp;loc=http%3A%2F%2Flocalhost%2Ftest%2Finvocationh.html&amp;referer=http%3A%2F%2Flocalhost%2Ftest%2F&amp;cb=7ff857d85a' width='0' height='0' alt='' style='width: 0px; height: 0px;'></div>
 *                          [bannerid] => 123
 *                          [contenttype] => swf
 *                          [alt] =>
 *                          [width] => 468
 *                          [height] => 60
 *                          [url] => http://www.example.net/landing_page/
 *                          [campaignid] => 4
 *                          [context] => Array
 *                              (
 *                              )
 *                      )
 */
function MAX_adSelect($what, $campaignid = '', $target = '', $source = '', $withtext = 0, $charset = '', $context = array(), $richmedia = true, $ct0 = '', $loc = '', $referer = '')
{
    $conf = $GLOBALS['_MAX']['CONF'];

    // For local mode and XML-RPC calls the some parameters are not set in the global scope
    // So we need to override the empty globals with the values passed into this function.
    if (empty($GLOBALS['source'])) {
        $GLOBALS['source'] = $source;
    }
    if (empty($GLOBALS['loc'])) {
        $GLOBALS['loc'] = $loc;
    }
    // Store the original zone, campaign or banner IDs for later use
    $originalZoneId = null;
    if (strpos($what,'zone:') === 0) {
        $originalZoneId = intval(substr($what,5));
    } elseif (strpos($what,'campaignid:') === 0) {
        $originalCampaignId = intval(substr($what,11));
    } elseif (strpos($what, 'bannerid:') === 0) {
        $originalBannerId = intval(substr($what,9));
    }
    $userid = MAX_cookieGetUniqueViewerId();
    MAX_cookieAdd($conf['var']['viewerId'], $userid, _getTimeYearFromNow());
    $outputbuffer = '';
    // Set flag
    $found = false;
    // Reset followed zone chain
    $GLOBALS['_MAX']['followedChain'] = array();
    $GLOBALS['_MAX']['adChain'] = array();

    // Reset considered ads set
    $GLOBALS['_MAX']['considered_ads'] = array();
		
    $first = true;
    global $g_append, $g_prepend;
    $g_append = '';
    $g_prepend = '';
	
	
	if(!empty($what)) {
	    while ($first || ($what != '' && $found == false))  {  
	        $first = false;
	        // Get first part, store second part
	        $ix = strpos($what, '|');
	        if ($ix === false) {
	            $remaining = '';
	        } else {
	            $remaining = substr($what, $ix+1);
	            $what = substr($what, 0, $ix);
	        }
	        if (strpos($what, 'zone:') === 0) {    
	            $zoneId  = intval(substr($what,5));
	            $row = _adSelectZone($zoneId, $context, $source, $richmedia);
				//print_r($row);  echo "<br/>"; echo "<br/>";
				
	        } else {   
	            // Expand paths to regular statements
	            if (strpos($what, '/') > 0) {
	                if (strpos($what, '@') > 0) {
	                    list ($what, $append) = explode ('@', $what);
	                } else {
	                    $append = '';
	                }

	                $separate  = explode ('/', $what);
	                $expanded  = '';
	                $collected = array();

	                reset($separate);
	                while (list(,$v) = each($separate)) {
	                    $expanded .= ($expanded != '' ? ',+' : '') . $v;
	                    $collected[] = $expanded . ($append != '' ? ',+'.$append : '');
	                }

	                $what = strtok(implode('|', array_reverse ($collected)), '|');
	                $remaining = strtok('').($remaining != '' ? '|'.$remaining : '');
	            }
				$row = _adSelectDirect($what, $campaignid, $context, $source, $richmedia, $remaining == ''); 
				//print_r($row);  echo "<br/>"; echo "<br/>";
				
	        }
	        if (is_array($row) && empty($row['default'])) { 
	            // Log the ad request
	            MAX_Delivery_log_logAdRequest($row['bannerid'], $row['zoneid'], $row);
	            if (($row['adserver'] == 'max' || $row['adserver'] == '3rdPartyServers:ox3rdPartyServers:max')
	                && preg_match("#{$conf['webpath']['delivery']}.*zoneid=([0-9]+)#", $row['htmltemplate'], $matches) && !stristr($row['htmltemplate'], $conf['file']['popup'])) {
	                // The ad selected was an OpenX HTML ad on the same server... do internal redirecty stuff
	                $GLOBALS['_MAX']['adChain'][] = $row;
	                $found = false;
	                $what = "zone:{$matches[1]}";
	            } else {
	                $found = true;
	            }
	        } else {
                    // Log the ad request
                    MAX_Delivery_log_logAdRequest(null, $originalZoneId, null);
                    $what  = $remaining;
	        }
	    }
    }

	
		
    // Return the banner information
    if ($found) {
        $zoneId = empty($row['zoneid']) ? 0 : $row['zoneid'];
        // For internal redirected creatives, make sure that any appended code in the adChain is appended
        if (!empty($GLOBALS['_MAX']['adChain'])) {
            foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad) {
                if (($ad['ad_id'] != $row['ad_id']) && !empty($ad['append'])) {
                    $row['append'] .= $ad['append'];
                }
            }
        }
		$outputbuffer = MAX_adRender($row, $zoneId, $source, $target, $ct0, $withtext, $charset, true, true, $richmedia, $loc, $referer, $context);
		
			
						
        $output = array(
            'html'          => $outputbuffer,
            'bannerid'      => $row['bannerid'],
            'contenttype'   => $row['contenttype'],
            'alt'           => $row['alt'],
            'width'         => $row['width'],
            'height'        => $row['height'],
            'url'           => $row['url'],
            'campaignid'    => $row['campaignid'],
            'clickUrl'      => $row['clickUrl'],
            'logUrl'        => $row['logUrl'],
            'aSearch'       => $row['aSearch'],
            'aReplace'      => $row['aReplace'],
            'bannerContent' => $row['bannerContent'],
            'clickwindow'   => $row['clickwindow'],
            'aRow'          => $row,
            'context'       => _adSelectBuildContext($row, $context),
            'iframeFriendly' => (bool)$row['iframe_friendly'],
        );
        // Init block/capping fields to avoid notices below
        $row += array(
            'block_ad'             => 0,
            'cap_ad'               => 0,
            'session_cap_ad'       => 0,
            'block_campaign'       => 0,
            'cap_campaign'         => 0,
            'session_cap_campaign' => 0,
            'block_zone'           => 0,
            'cap_zone'             => 0,
            'session_cap_zone'     => 0,
        );
        // If ad-logging is disabled, the log beacon won't be sent, so set the capping at request
        if (MAX_Delivery_cookie_cappingOnRequest()) {
            if ($row['block_ad'] > 0 || $row['cap_ad'] > 0 || $row['session_cap_ad'] > 0) {
                MAX_Delivery_cookie_setCapping('Ad', $row['bannerid'], $row['block_ad'], $row['cap_ad'], $row['session_cap_ad']);
            }
            if ($row['block_campaign'] > 0 || $row['cap_campaign'] > 0 || $row['session_cap_campaign'] > 0) {
                MAX_Delivery_cookie_setCapping('Campaign', $row['campaign_id'], $row['block_campaign'], $row['cap_campaign'], $row['session_cap_campaign']);
            }
            if ($row['block_zone'] > 0 || $row['cap_zone'] > 0 || $row['session_cap_zone'] > 0) {
                MAX_Delivery_cookie_setCapping('Zone', $row['zoneid'], $row['block_zone'], $row['cap_zone'], $row['session_cap_zone']);
            }
            // Store the last view action event om the cookie as well (if required)
            MAX_Delivery_log_setLastAction(0, array($row['bannerid']), array($zoneId), array($row['viewwindow']));
        }
    } else { 

        if (!empty($zoneId)) {
            // Blank impression beacon as global append
            $g_append = MAX_adRenderBlankBeacon($zoneId, $source, $loc, $referer).$g_append;

            // Try to fill the impression with a fallback from plugins
            $outputbuffer = join("\n", OX_Delivery_Common_hook('blankAdSelect', array($zoneId, $context, $source, $richmedia)) ?: []);
        }

        if (!empty($outputbuffer)) {
            // A fallback was provided by some plugin(s)
            $outputbuffer = $g_prepend . $outputbuffer . $g_append;
            $output = array('html' => $outputbuffer, 'bannerid' => '' );
        } elseif (!empty($row['default'])) {
            // Return the default banner
            if (empty($target)) {
                $target = '_blank';  // Default
            }
            $outputbuffer = $g_prepend . '<a href=\'' . $row['default_banner_destination_url'] . '\' target=\'' .
                            $target . '\'><img src=\'' . $row['default_banner_image_url'] .
                            '\' border=\'0\' alt=\'\'></a>' . $g_append;
            $output = array('html' => $outputbuffer, 'bannerid' => '', 'default_banner_image_url' => $row['default_banner_image_url'] );
        } elseif (!empty($conf['defaultBanner']['imageUrl'])) {
            // Return the default banner
            if (empty($target)) {
                $target = '_blank';  // Default
            }
            $outputbuffer = "{$g_prepend}<img src='{$conf['defaultBanner']['imageUrl']}' border='0' alt=''>{$g_append}";
            $output = array('html' => $outputbuffer, 'bannerid' => '', 'default_banner_image_url' => $conf['defaultBanner']['imageUrl']);
        } else {
            // No default banner was returned, return no banner
            $outputbuffer = $g_prepend . $g_append;
            $output = array('html' => $outputbuffer, 'bannerid' => '' );
        }
    }

	// post adSelect hook
    OX_Delivery_Common_hook('postAdSelect', array(&$output));

    return $output;
}

/**
 * This function selects an ad selected by direct selection
 *
 * @param string  $what         The search term being used to select the ad
 * @param string  $campaignid   The campaign ID to fecth banners from, added in 2.3.32 to allow BC with 2.0
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 * @param boolean $lastpart     Are there any other search strings left
 *
 * @return array|false          Returns an ad-array (see page DocBlock) or false if no ad found
 */
function _adSelectDirect($what, $campaignid = '', $context = array(), $source = '', $richMedia = true, $lastpart = true)
{

    $aDirectLinkedAdInfos = MAX_cacheGetLinkedAdInfos($what, $campaignid, $lastpart);
		
    // Set a flag to let the selection algorithm know that this is a direct request
    $GLOBALS['_MAX']['DIRECT_SELECTION'] = true;
	
	$aLinkedAd = _adSelectCommon($aDirectLinkedAdInfos, $context, $source, $richMedia);
	
	
    if (is_array($aLinkedAd)) {
        $aLinkedAd['zoneid'] = 0;
        $aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
        $aLinkedAd['storagetype'] = $aLinkedAd['type'];
        $aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];

        return $aLinkedAd;
    }
    // this looks broken...
    if (!empty($aDirectLinkedAdInfos['default_banner_image_url'])) {
        return array(
           'default'                        => true,
           'default_banner_image_url'       => $aDirectLinkedAdInfos['default_banner_image_url'],
           'default_banner_destination_url' => $aDirectLinkedAdInfos['default_banner_destination_url']
        );
    }

    return false;
}


/**
 * Returns an id of the next's zone in the chain specified in $arrZone
 * or $zoneId if there is no chained zone.
 *
 * @param int $zoneId Zone id to be returned if the chain was not found.
 * @param array $arrZone An associative array with an attribute 'chain' which
 *              contains zone's chain specification.
 * @return int Id of the next zone in the chain or $zoneId if there is no chain.
 */
function _getNextZone($zoneId, $arrZone)
{
    if (!empty($arrZone['chain']) && (substr($arrZone['chain'],0,5) == 'zone:')) {
        return intval(substr($arrZone['chain'],5));
    }
    else {
        return $zoneId;
    }
}



/**
 * This function selects an ad selected from a specific zone
 *
 * @param int     $zoneId       The ID of the zone to select an ad from
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 *
 * @return array|false          Returns an ad-array (see page DocBlock) or false if no ad found
 */
function _adSelectZone($zoneId, $context = array(), $source = '', $richMedia = true)
{  
	
	 // ZoneID zero is used for direct selected adRequests only
    if ($zoneId === 0) { return false; }

    global $g_append, $g_prepend;
    while (!in_array($zoneId, $GLOBALS['_MAX']['followedChain'])) {
        $GLOBALS['_MAX']['followedChain'][] = $zoneId;
        $appendedThisZone = false;  	

				
        // first get zone info
        $aZoneInfo = MAX_cacheGetZoneInfo($zoneId);	
						
		if (empty($aZoneInfo)) {
            // the zone does not exist, sorry!
            return false;
        }
							
        //check zone level limitations
        if ($zoneId != 0 && MAX_limitationsIsZoneForbidden($zoneId, $aZoneInfo)) {
            $zoneId = _getNextZone($zoneId, $aZoneInfo);
            continue;
        }		
						
        // Get all ads which are linked to the zone
        $aZoneLinkedAdInfos = MAX_cacheGetZoneLinkedAdInfos ($zoneId);	

		//print_r($aZoneLinkedAdInfos);
					
        if (is_array($aZoneInfo)) {
            if (isset($aZoneInfo['forceappend']) && $aZoneInfo['forceappend'] == 't') {
                $g_prepend .= $aZoneInfo['prepend'];
                $g_append = $aZoneInfo['append'] . $g_append;
                $appendedThisZone = true;
            }

            // merge zone info and banner info
            $aZoneLinkedAdInfos += $aZoneInfo;
			
														
             $aLinkedAd = _adSelectCommon($aZoneLinkedAdInfos, $context, $source, $richMedia);
             
             /*DAC020 - Start*/
			 $zone_type=$aZoneLinkedAdInfos['dj_zone_type'];//Inline/overlay					
			 $row = data_from_memcache($zoneId);			 
			 $zone_video_type=($row['video_type']=='1')?'progressive':'streaming'; //1 =>progressive 2=>streaming
			 $player = $row['player'];	//1 => jwplayer,2=>flowplayer,3=>htmlplayer 4=>vasttag			 
			 $parameter=$aLinkedAd['parameters'];
			 $video_type=unserialize($parameter);
			 $ad_video_type=$video_type['vast_video_delivery'];  // progressive /streaming from ad		
			/*DAC020 - ends*/		
					 
			 $FORMAT=get_value('format'); 
			 
			
            if (is_array($aLinkedAd)) {
				
              	if($FORMAT!='vast_pod' && $FORMAT!='vast_pod_wrapper')
				{				
		        if($player=='1' || $player=='2')
				{
							if($zone_video_type==$ad_video_type)
							{  
								
							$aLinkedAd['zoneid'] = $zoneId;
							$aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
							$aLinkedAd['storagetype'] = $aLinkedAd['type'];
							$aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
							$aLinkedAd['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
							$aLinkedAd['block_zone'] = @$aZoneInfo['block_zone'];
							$aLinkedAd['cap_zone'] = @$aZoneInfo['cap_zone'];
							$aLinkedAd['session_cap_zone'] = @$aZoneInfo['session_cap_zone'];
							$aLinkedAd['affiliate_id'] = @$aZoneInfo['publisher_id'];

							if (!$appendedThisZone) {
								$aLinkedAd['append'] .= @$aZoneInfo['append'] . $g_append;
								$aLinkedAd['prepend'] = $g_prepend . @$aZoneInfo['prepend'] . $aLinkedAd['prepend'];
							} else {
								$aLinkedAd['append'] .= $g_append;
								$aLinkedAd['prepend'] = $g_prepend . $aLinkedAd['prepend'];
							}
						
							return ($aLinkedAd);
							}
							else if($ad_video_type=="vast")
							{
								
								$aLinkedAd['zoneid'] = $zoneId;
								$aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
								$aLinkedAd['storagetype'] = $aLinkedAd['type'];
								$aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
								$aLinkedAd['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
								$aLinkedAd['block_zone'] = @$aZoneInfo['block_zone'];
								$aLinkedAd['cap_zone'] = @$aZoneInfo['cap_zone'];
								$aLinkedAd['session_cap_zone'] = @$aZoneInfo['session_cap_zone'];
								$aLinkedAd['affiliate_id'] = @$aZoneInfo['publisher_id'];

								if (!$appendedThisZone) {
									$aLinkedAd['append'] .= @$aZoneInfo['append'] . $g_append;
									$aLinkedAd['prepend'] = $g_prepend . @$aZoneInfo['prepend'] . $aLinkedAd['prepend'];
								} else {
									$aLinkedAd['append'] .= $g_append;
									$aLinkedAd['prepend'] = $g_prepend . $aLinkedAd['prepend'];
								}								
								return ($aLinkedAd);
							}
							else if($ad_video_type == "") // for overlay video  type
							{
								
								$is_overlay = $video_type['vast_overlay_format'];
								
								if($is_overlay)
								{
									 $aLinkedAd['zoneid'] = $zoneId;
									$aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
									$aLinkedAd['storagetype'] = $aLinkedAd['type'];
									$aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
									$aLinkedAd['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
									$aLinkedAd['block_zone'] = @$aZoneInfo['block_zone'];
									$aLinkedAd['cap_zone'] = @$aZoneInfo['cap_zone'];
									$aLinkedAd['session_cap_zone'] = @$aZoneInfo['session_cap_zone'];
									$aLinkedAd['affiliate_id'] = @$aZoneInfo['publisher_id'];

									if (!$appendedThisZone) {
										$aLinkedAd['append'] .= @$aZoneInfo['append'] . $g_append;
										$aLinkedAd['prepend'] = $g_prepend . @$aZoneInfo['prepend'] . $aLinkedAd['prepend'];
									} else {
										$aLinkedAd['append'] .= $g_append;
										$aLinkedAd['prepend'] = $g_prepend . $aLinkedAd['prepend'];
									}
									
									
									return ($aLinkedAd);
									
								}
								
							}
						}
						else 
						{
							$aLinkedAd['zoneid'] = $zoneId;
							$aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
							$aLinkedAd['storagetype'] = $aLinkedAd['type'];
							$aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
							$aLinkedAd['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
							$aLinkedAd['block_zone'] = @$aZoneInfo['block_zone'];
							$aLinkedAd['cap_zone'] = @$aZoneInfo['cap_zone'];
							$aLinkedAd['session_cap_zone'] = @$aZoneInfo['session_cap_zone'];
							$aLinkedAd['affiliate_id'] = @$aZoneInfo['publisher_id'];

							if (!$appendedThisZone) {
								$aLinkedAd['append'] .= @$aZoneInfo['append'] . $g_append;
								$aLinkedAd['prepend'] = $g_prepend . @$aZoneInfo['prepend'] . $aLinkedAd['prepend'];
							} else {
								$aLinkedAd['append'] .= $g_append;
								$aLinkedAd['prepend'] = $g_prepend . $aLinkedAd['prepend'];
							}
							
							return ($aLinkedAd);
						}
		        
		        
			}
			else
			{
					$djax_vastpod=array();
										
					foreach($aLinkedAd as $key => $djaxads)
					{ 
					$djaxads['zoneid'] = $zoneId;  
					$djaxads['bannerid'] = $djaxads['ad_id'];
					$djaxads['storagetype'] =$djaxads['type'];
					$djaxads['campaignid'] = $djaxads['placement_id'];
					$djaxads['zone_companion'] = $aZoneLinkedAdInfos['zone_companion'];
					$djaxads['block_zone'] = @$aZoneInfo['block_zone'];
					$djaxads['cap_zone'] = @$aZoneInfo['cap_zone'];
					$djaxads['session_cap_zone'] = @$aZoneInfo['session_cap_zone'];
					$djaxads['affiliate_id'] = @$aZoneInfo['publisher_id'];					

					if (!$appendedThisZone) {
					   $djaxads['append'] .= @$aZoneInfo['append'] . $g_append;
						$djaxads['prepend'] = $g_prepend . @$aZoneInfo['prepend'] . $djaxads['prepend'];
					} else {
					   $djaxads['append'] .= $g_append;
					   $djaxads['prepend'] = $g_prepend . $djaxads['prepend'];
					}										
					
					$djax_vastpod[$key]=$djaxads;
					}											
					return ($djax_vastpod);

				}
            }

            $zoneId = _getNextZone($zoneId, $aZoneInfo);
        }
    }
    if (!empty($aZoneInfo['default_banner_image_url'])) {
        return array(
           'default'                        => true,
           'default_banner_image_url'       => $aZoneInfo['default_banner_image_url'],
           'default_banner_destination_url' => $aZoneInfo['default_banner_destination_url']
        );
    }

    return false;
    
}


/**
 * This function selects an ad cyclying through override, contract, renmant, etc.
 *
 * @param string  $aAds         The array of ads to pick from
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 *
 * @return array|false          Returns an ad-array (see page DocBlock) or false if no ad found
 */
function _adSelectCommon($aAds, $context, $source, $richMedia)
{ 

	// pre adSelect hook
    OX_Delivery_Common_hook('preAdSelect', array(&$aAds, &$context, &$source, &$richMedia)); 

    if (!empty($aAds['ext_adselection'])) { 
        $adSelectFunction = OX_Delivery_Common_getFunctionFromComponentIdentifier($aAds['ext_adselection'], 'adSelect');
    }
    if (empty($adSelectFunction) || !function_exists($adSelectFunction)) {
        $adSelectFunction = '_adSelect';
    }
	
	
    // Are there any ads linked?
    if (!empty($aAds['count_active'])) {  
        // Is this a companion request and can it be fullfilled?
        if (isset($aAds['zone_companion']) && isset($context)) {  
            foreach ($context as $contextEntry) { 
                if (isset($contextEntry['==']) && preg_match('/^companionid:/', $contextEntry['=='])) { 
                    if ($aLinkedAd = _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia, true)) {	
                        return $aLinkedAd;
                    }
                }
            }
        }		
		$aLinkedAd = _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia);
		
		//print_r($aLinkedAd); echo "<br/>";
		
		if (is_array($aLinkedAd)) {
            return $aLinkedAd;
        }
    }
    return false;
}

/**
 * This internal function selects an ad cyclying through override, contract, remnant, etc.
 * taking into account companion positioning as requested
 *
 * @param callback $adSelectFunction The plugin callback function
 * @param string  $aAds         The array of ads to pick from
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 * @param boolean $companion    Should ad selection only return companion ads?
 *
 * @return array|false          Returns an ad-array (see page DocBlock) or false if no ad found
 */
function _adSelectInnerLoop($adSelectFunction, $aAds, $context, $source, $richMedia, $companion = false)
{	
	
	// Array of campaign types sorted by priority
    $aCampaignTypes = array(
      //  'xAds' => false,     // No priority levels
      //  'ads'  => array(10, 9, 8, 7, 6, 5, 4, 3, 2, 1),
      //  'lAds' => false,     // No priority levels
        'eAds' => false, // Priority level is fixed to -2
    );	

    $GLOBALS['_MAX']['considered_ads'][] = &$aAds;
	
	

    foreach ($aCampaignTypes as $type => $aPriorities) { 
        if ($aPriorities) {
            $ad_picked = false;
            foreach ($aPriorities as $pri) {
                // Even though we've selected an ad, we need to continue
                // applying filtering rules in order to construct a valid
                // qualified ad set, which MPE 2.x needs to know.
                if (!$ad_picked) {  
                    $aLinkedAd = OX_Delivery_Common_hook('adSelect',
                            array(&$aAds, &$context, &$source, &$richMedia, $companion, $type, $pri), $adSelectFunction);
                    // Did we pick an ad from this campaign-priority level?
                    if (is_array($aLinkedAd)) {
                        $ad_picked = true;
                    }
                    // Should we skip the next campaign-priority level?
                    if ($aLinkedAd == $GLOBALS['OX_adSelect_SkipOtherPriorityLevels']) {
                        $ad_picked = true;
                    }
                }
                else
                {  
                    if (!empty($aAds[$type][$pri])) {
                        // Build preconditions
                        $aContext = _adSelectBuildContextArray($aAds[$type][$pri], $type, $context);

                        // New delivery algorithm: discard all invalid ads before iterating over them
                        // $aAds passed by ref here
                        _adSelectDiscardNonMatchingAds($aAds[$type][$pri], $aContext, $source, $richMedia);
                    }
                }
            }
            if ($ad_picked && is_array ($aLinkedAd)) {  
                return $aLinkedAd;
            }
        } else { 
            $aLinkedAd = OX_Delivery_Common_hook('adSelect', array(&$aAds, &$context, &$source, &$richMedia, $companion, $type), $adSelectFunction);		
											
            // Did we pick an ad from this campaign type?
    		if (is_array($aLinkedAd)) {
      			return $aLinkedAd;
    		}
    	}
    }
    return false;
}


/**
 * This function takes a group of ads, and selects the ad to show
 *
 * @param array   $aLinkedAds   The array of possible ads for this search criteria
 * @param array   $context      The context of this ad selection
 *                              - used for companion positioning
 *                              - and excluding banner/campaigns from this ad-call
 * @param string  $source       The "source" parameter passed into the adcall
 * @param boolean $richMedia    Does this invocation method allow for serving 3rd party/html ads
 * @param boolean $companion    Should ad selection only return companion ads?
 * @param string  $adArrayVar   The collection of ads in $aLinkedAds to select the ad from
 * @param integer $cp
 *
 * @return array|void           The ad-array for the selected ad or void if no ad selected
 */

		
/*DAC020-Calculate priority based on countrybidding*/

function _setPriorityFromcountry(&$aAds,$client_bidding)
{
	if (!count($aAds)) {
	return 0;
	}
	$aCampaignWeights = array();
	$aCampaignAdWeight = array();
	foreach ($aAds as $v) 
	{
		if (!isset($aCampaignWeights[$v['client_id']])) 
		{

			$revenue=$client_bidding[$v['client_id']];
			$aCampaignWeights[$v['client_id']] = $revenue;
			$aCampaignAdWeight[$v['client_id']] = 0;
		}
		$aCampaignAdWeight[$v['client_id']] += $v['weight'];
	}

	foreach ($aCampaignWeights as $k => $v) 
	{
		if ($aCampaignAdWeight[$k]) 
		{
		$aCampaignWeights[$k] /= $aCampaignAdWeight[$k];
		}
	}
	$totalPri = 0;
	foreach ($aAds as $k => $v) 
	{

		$aAds[$k]['priority'] = $aCampaignWeights[$v['client_id']] * 1;
		$totalPri += $aAds[$k]['priority'];
	}
	if ($totalPri) 
	{
		foreach ($aAds as $k => $v) 
		{
		$aAds[$k]['priority'] /= $totalPri;
		}			
		//return 1;		
		return $aAds; 
	}

	return 0;
}
/*DAC020-Calculate priority based on country bidding*/

		function djax_ecpmpriority($aAds,$results)
		{
				
			  			$max_ecpm = 0;
						$top_ecpms = array();
				
						foreach ($aAds as $key => $ad) 
						{
							
							
							if($results[$ad['placement_id']]==1)
							{
									$weights[$ad['placement_id']]=$ad['campaign_weight'];		
					
									$revneue=($ad['revenue_type']==1)?$ad['revenue']/1000:$ad['revenue'];

									$max_ecpm =($ad['ecpm']!='0.0000')?$ad['ecpm']:$revneue;							
									$total_ecpm +=$max_ecpm;
			
									$total_weight+= $ad['campaign_weight'];

									$top_ecpms[$key] = 1;
								
							}
							else
							{
							unset($aAds[$key]);
							}
						}
																		
						$chk_camp_weight=array_values($weights);
						
						
						
				
						if(count($aAds)>0)
						{
										if(count(array_unique($chk_camp_weight)) === 1)
										{

													$weight_based=0;
										}
										else
										{
													$weight_based=1;
										}
																									
										
										if($total_ecpm <= 0)
										{
											$GLOBALS['_MAX']['ECPM_CONTROL'] = 1;
			$total_priority = _setPriorityFromWeights($aAds,$results);						
									return $aAds;
		
										}
										else
										{
			
											$GLOBALS['_MAX']['ECPM_SELECTION'] = 1;

											$total_priority = 1;
											
											
											if($weight_based==1)
											{												
												foreach ($aAds as $key => $ad)
												{												
																							
													if(!empty($top_ecpms[$key]))
													{
																																								
													$revneue=($ad['revenue_type']==1)?$ad['revenue']/1000:$ad['revenue'];
																									
													$ecpm =($ad['ecpm']!='0.0000')?$ad['ecpm']:$revneue; 													
																																				
													$temp[$key] = ($ecpm/ $total_ecpm) +($aAd[$key]['campaign_weigh']/$total_weight);																						
													
													$aAds[$key]['priority'] =$temp[$key]/2;													
													
													}
													else
													{																												 
													$aAds[$key]['priority'] = 0;
													}
												} 
																	
											}
											else
											{ 	

												foreach ($aAds as $key => $ad)
												{
													$revneue=($ad['revenue_type']==1)?$ad['revenue']/1000:$ad['revenue'];
													$ecpm =($ad['ecpm']!='0.0000')?$ad['ecpm']:$revneue;

													if(!empty($top_ecpms[$key]))
													{
														$aAds[$key]['priority'] =$ecpm/ $total_ecpm;
													}
													else
													{ 
														$aAds[$key]['priority'] = 0;
													}
												}
											}
											
																											 

											return $aAds;
										}
						}
						else
						{

									return array();
						}

			}



		/*Djax Custom methods*/
function _adSelect(&$aLinkedAdInfos, $context, $source, $richMedia, $companion, $adArrayVar = 'ads', $cp = null)
{    
			
			//print_r($companion);  echo "<br/>"; echo "<br/>";  
			
			$country_bidenable=array_values($aLinkedAdInfos['bidding_val']);
			
			$aAds = array();

			$results = array();	

			$temp_camp = array();

			///House ads concept implementation
										
			foreach($aLinkedAdInfos['campaignid'] as $key => $value)
			{    
      			$results[$key]=_adSelectCheckCriteria($value);				
																							 
				if($results[$key]!=1)
				{										 
				     $temp_camp[] = $key;								     
				}			
							
			}		
										
			foreach($aLinkedAdInfos['eAds'] as $key => $value)
			{
				if(in_array($value['placement_id'],$temp_camp))
				{					
					unset($aLinkedAdInfos['eAds'][$key]);
				}
		
			}	
			 
			$djax_superads=$aLinkedAdInfos['dj_is_default'];	
			
			$djax_original_filtered_ads=$aLinkedAdInfos['eAds'];
						
			if(count($djax_original_filtered_ads)>0)
			{
				$is_house_ad=0;			
				$aAds=$djax_original_filtered_ads;
				
			}
			else if(count($djax_superads)>0)
			{	 
				$is_house_ad=1;						
				$aAds=$djax_superads;
			}
			else
			{  
				$is_house_ad=0;			
				$aAds = array();			
			}	
								
			if (count($aAds) == 0)
			{			
			return;
			}
					
			////house ads concept implementation
			global $n;
			mt_srand
			(floor
			((isset ($n) && strlen ($n) > 5
			? hexdec ($n[0].$n[2].$n[3].$n[4].$n[5])
			: 1000000) * (double) microtime ()));
			$conf = $GLOBALS['_MAX']['CONF'];
			$random_num =
			mt_rand (0, $GLOBALS['_MAX']['MAX_RAND'])
			/ $GLOBALS['_MAX']['MAX_RAND'];
		
				/* DAC020 -Start */
				
								
				
								if($is_house_ad!=1)
								{	
										if(count(array_filter($country_bidenable))==0)
										{						   						        
											$aAds=djax_ecpmpriority($aAds,$results);	  	
											
										 }
										else
										{ 	
											$aAds=_setPriorityFromcountry($aAds,$aLinkedAdInfos['bidding_val']);	
										}									
								
								}
								else
								{
									foreach ($aAds as $key => $ad) 
									{
										$aAds[$key]['priority'] =1;													
									}
								}
									
									
																
		         /* DAC020 - End*/	 
				 
				 	
  
    // Perform selection of an ad, based on the random number
    $low = 0;
    $high = 0;	
    if($_REQUEST['format']=='vast_pod' || $_REQUEST['format']=='vast_pod_wrapper')
	{
		$pod_aAds=array();
		
		foreach($aAds as $aLinkedAd) 
		{

			if(count($aAds)==1 && empty($aLinkedAd['ext_bannertype']))
			{ 	
			$pod_aAds = MAX_cacheGetAd($aLinkedAd['ad_id']);
			}
			else
			{
			$pod_aAds[$aLinkedAd['ad_id']] = MAX_cacheGetAd($aLinkedAd['ad_id']);
			}
		}
					
 		return $pod_aAds;
	}
	else
	{
 	    
	    foreach($aAds as $aLinkedAd) { 
		if (!empty($aLinkedAd['priority'])) {
		    $low = $high;
		    $high += $aLinkedAd['priority'];
		    if ($high > $random_num && $low <= $random_num) {
	###START_STRIP_DELIVERY
		        // testing support
		        if (function_exists ('test_MAX_cacheGetAd'))
		        {
		            return test_MAX_cacheGetAd($aLinkedAd['ad_id']);
		        }
	###END_STRIP_DELIVERY
		       /*==================================retargeting start==========================*/
									
						
						$zoneid=get_value('zoneid');
               
						$_query = OA_Dal_Delivery_query("
							SELECT
														  
								distinct(d.campaignid) AS placement_id,behavior
								
							FROM
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['banners'])." AS d JOIN
							".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." AS az ON (d.bannerid = az.ad_id) JOIN
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." AS z ON (az.zone_id = z.zoneid) JOIN	
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['campaigns'])." AS c ON (c.campaignid = d.campaignid) 	LEFT JOIN
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['clients'])." AS m ON (m.clientid = c.clientid) LEFT JOIN
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['agency'])." AS a ON (a.agencyid = m.agencyid)
							WHERE		
						
							 z.zoneid = ".$zoneid."
							  AND
								d.status <= 0
							
							  AND
								c.status <= 0
							  AND
							   z.dj_is_deleted=0
							   
							  AND
							   c.dj_is_deleted=0
							   
							   AND
							   m.dj_is_deleted=0 
							   
							    AND
							   d.dj_is_deleted=0 	
						") or die(mysql_error());
						
						while($_rAdset = OA_Dal_Delivery_fetchAssoc($_query)) {
					$_resultSet[] = $_rAdset;
						}
            
					foreach($_resultSet as $value){
					$Camp_ids[$value['placement_id']] =array(
									"placement_id"=>$value['placement_id'],"behavior"=>$value['behavior']
									
									
									);


					}
			

					foreach($Camp_ids as $value) {						
						
					$retarg = $GLOBALS['_MAX']['CONF']['var']['djaxretarget'];	
					
					$cookie_ID = $_COOKIE[$retarg.'_'.$value['placement_id']];
                     
                        
					if(!empty($cookie_ID)) {
						
					$campaignID[]=explode('_',$cookie_ID);
					
					}
					
					}


					foreach($campaignID as $key=>$value) {
						
						$_campIDs[$value[$key]] = $value[$key];
						
					}
	

                  
	          
                       
					$Camp_id = array_rand($_campIDs);
					
					 foreach($djax_original_filtered_ads as $key=>$value) {
						//print_r($value['placement_id']);
						$ori_campIDs[] = $value['placement_id'];
						
					}
                 
					  if(!empty($Camp_id) && in_array($Camp_id, $ori_campIDs)) {
						
						$behavior=$Camp_ids[$Camp_id]['behavior'];
						$zoneid=get_value('zoneid');
	                    
					$Selection_query = "
							SELECT
								distinct(d.bannerid) AS ad_id,
							c.compiledlimitation AS compiledlimitation,
								c.acl_plugins AS acl_plugins,		
								d.campaignid AS placement_id
								
							FROM
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['banners'])." AS d JOIN
							".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['ad_zone_assoc'])." AS az ON (d.bannerid = az.ad_id) JOIN
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['zones'])." AS z ON (az.zone_id = z.zoneid) JOIN	
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['campaigns'])." AS c ON (c.campaignid = d.campaignid) 	LEFT JOIN
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['clients'])." AS m ON (m.clientid = c.clientid) LEFT JOIN
								".OX_escapeIdentifier($conf['table']['prefix'].$conf['table']['agency'])." AS a ON (a.agencyid = m.agencyid)
							";
						if($behavior==1)
						{	
						$Selection_query.=" WHERE c.campaignid=".$Camp_id."";
					    }
					    else
					    {
						 $Selection_query.=" WHERE c.campaignid!=".$Camp_id."";	
					    }	
						
						 $Selection_query.=" AND
							 z.zoneid = ".$zoneid."
							  AND
								d.status <= 0
							
							  AND
								c.status <= 0
							   AND
							   z.dj_is_deleted=0
							   
							  AND
							   c.dj_is_deleted=0
							   
							   AND
							   m.dj_is_deleted=0 
							   
							    AND
							   d.dj_is_deleted=0 	
						";

                    

					$r_Ads = OA_Dal_Delivery_query($Selection_query)or die(mysql_error());
					
					
					if (!is_resource($r_Ads)) {
					return (defined('OA_DELIVERY_CACHE_FUNCTION_ERROR')) ? OA_DELIVERY_CACHE_FUNCTION_ERROR : null;
					}
					
                     
					while($r_Adset = OA_Dal_Delivery_fetchAssoc($r_Ads)) {
						
						
					$retarget[] = $r_Adset;
						}
					

					foreach($retarget as $retarget_value){
					
					$Ad__ids[$retarget_value['ad_id']] =array("ad_id"=>$retarget_value['ad_id'],
									"placement_id"=>$retarget_value['placement_id'],
									"compiledlimitation"=>$retarget_value['compiledlimitation'],
									"acl_plugins"=>$retarget_value['acl_plugins']);
									
                        
					_adSelectCheckCriteria($Ad__ids, $aContext, $source, $richMedia);
					}



                  
					//Check for delivery limitations


          //   print_r($Ad__ids);die("dddddd");


					if (count($Ad__ids) == 0) {
					return;
					}
					else  {
						

						
						foreach($Ad__ids as $bannerId => $value) {
							
							
								$bannerIds[$bannerId] = $bannerId;$i++;

							
						  
							
						}


						if(!empty($bannerIds)) {
							
							$ad = MAX_cacheGetAd(array_rand($bannerIds));
						}

						else {
							
							$ad = MAX_cacheGetAd($aLinkedAd['ad_id']);
						}

					}

					}

					else 

					$ad = MAX_cacheGetAd($aLinkedAd['ad_id']);
											
									
						/*==================================retargeting end==========================*/; 

							
		        // Carry over for conversion tracking
		        $ad['tracker_status'] = (!empty($aLinkedAd['tracker_status'])) ? $aLinkedAd['tracker_status'] : null;
		        // Carry over for ad dimensions for market ads
		        if($ad['width'] == $ad['height'] && $ad['width'] == -1) {
		           $ad['width'] = $aLinkedAd['width'];
		           $ad['height'] = $aLinkedAd['height'];
		        }    
				
								
		        return $ad;
		    }
		}
	    }
	}
    return;
}

/**
 * Return boolean indicating if this request is eligible for selection into a
 * control group for ecpm optimization.  Having only CPM ads as being eligible
 * may be a disqualifying criteria, given a configuration setting.
 *
 * @param unknown_type $aAds
 */
function _controlTrafficEnabled (&$aAds)
{
    $control_enabled = true;

    // if enableControlOnPureCPM is not enabled, we will check to see if
    // the ads are all only CPM, and disable control selection if they are
    if (empty ($GLOBALS['_MAX']['CONF']['delivery']['enableControlOnPureCPM']))
    {
        // check for any non-CPM campaign in eligible set
        $control_enabled = false;
        foreach ($aAds as $ad) {
            if ($ad['revenue_type'] != MAX_FINANCE_CPM)
            {
                $control_enabled = true;
                break;
            }
        }

    }

    return $control_enabled;
}


/**
 * Enter description here...
 *
 * @param unknown_type $aAd
 * @param unknown_type $context
 * @param unknown_type $source
 * @param unknown_type $richMedia
 */

function get_value($value) 
{
	$final_value	=	$_REQUEST;  
	if(isset($final_value[$value]))
	{
	return $final_value[$value];
	}
}

function _adSelectCheckCriteria($aAd, $aContext, $source, $richMedia)
{   
	$conf = $GLOBALS['_MAX']['CONF'];
	
	/* Below line for companion ad */
	if (empty($GLOBALS['_MAX']['CONF']['delivery']['aclsDirectSelection']) && !empty($GLOBALS['_MAX']['DIRECT_SELECTION'])) {  
	return true;	
	}
	
	
    		
	$check_video=unserialize($aAd['parameters']);
		
	$vast_version=array('vast1','vast2','vast3');

	$vast_wrapper_version=array('vast1_wrapper','vast2_wrapper','vast3_wrapper');
			 $FORMAT=get_value('format');
				if($FORMAT=='vast1_wrapper')
				{
						$versionno=1;
				}
				else if($FORMAT=='vast2_wrapper')
				{
						$versionno=2;
				}
				else if($FORMAT=='vast3_wrapper')
				{
						$versionno=3;
				}
		if(in_array( $FORMAT,$vast_version))
		{
			if($check_video['vast_video_delivery']=='vast' || $check_video['vast_overlay_format']=='wrapper_overlay')
			{ 
				return false;
			}
		}

		if(in_array($FORMAT,$vast_wrapper_version))
		{
			if($check_video['vast_video_delivery']!='vast' && $aAd['ext_bannertype']=='bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml')
			{
				return false;
			}
			else if($check_video['vast_overlay_format']!='wrapper_overlay' && $aAd['ext_bannertype']=='bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml')
			{
				return false;
			}
			else
			{
				if($check_video['vast_video_delivery']=='vast')
				{
						if($check_video['vast_version']!=$versionno)
						{
						return false;
						}
				}
				else if($check_video['vast_overlay_format']=='wrapper_overlay')
				{
					if($check_video['vast_overlay_version']!=$versionno)
					{
					return false;
					}
				}
			}
		}
	
		if($FORMAT=='vast_pod')
		{
			if($check_video['vast_video_delivery']=='vast')
			{
				return false;
			}
		}	
		else if($FORMAT=='vast_pod_wrapper')
		{
			if($check_video['vast_video_delivery']!='vast')
			{
				return false;
			}
			if($check_video['vast_version']!=3)
			{
				return false;
			}
		}
		
		

		MAX_Dal_Delivery_Include();
		
		$cl=OA_Dal_Delivery_query("SELECT dj_is_denied AS block FROM rv_clients WHERE clientid = '".$aAd['client_id']."'") or die("DB Error");
		
		$cl_val=OA_Dal_Delivery_fetchAssoc($cl);
						
		if($cl_val['block']==1)
		{
		return false;
		}		
  		
		/*DAC015*/
		$request_id=$_SESSION['request_id'];//get_value('request_id');
						
		
		if (!empty ($aAd['expire_time']))
			{  
				$expire = strtotime ($aAd['expire_time']);
				$now = MAX_commonGetTimeNow ();
				if ($expire > 0 && $now > $expire)
				{
			      
					OX_Delivery_logMessage('Campaign has expired for bannerid '.$aAd['ad_id'], 7);
					return false;
				}
			}

			if (MAX_limitationsIsAdForbidden($aAd))
			{
				OX_Delivery_logMessage('MAX_limitationsIsAdForbidden = true for bannerid '.$aAd['placement_id'], 7);
		
				return false;
			}

			if ($conf['delivery']['acls'] && !MAX_limitationsCheckAcl($aAd, $source))
			{
				OX_Delivery_logMessage('MAX_limitationsCheckAcl = false for bannerid '.$aAd['placement_id'], 7);
				return false;
			}		
					
			$zoneid=get_value('zoneid');		
			
			if($aAd['dj_is_default']==1)
			{ 							
				$result=djax_check_category($zoneid,$aAd); 
										       
				if($result!=1)
				{
						
						return false;
			
				} 
				
			
			
		
			}
			else
			{									
				$result=djax_filter_ads($zoneid,$aAd,$request_id);	
														
				
                  if ($result != 1 ) {	
						return false;
			
				}

			}			
		

			return true;
	
}

function _adSelectBuildContextArray(&$aLinkedAds, $adArrayVar, $context, $companion = false)
{
    $aContext = array(
        'campaign' => array('exclude' => array(), 'include' => array()),
        'banner'   => array('exclude' => array(), 'include' => array()),
        'client'   => array('exclude' => array(), 'include' => array()),
    );

    if (is_array($context) && !empty($context)) {
        $cContext = count($context);
        for ($i=0; $i < $cContext; $i++) {
            reset($context[$i]);
            list ($key, $value) = each($context[$i]);

            $valueArray = explode(':', $value);

            if (count($valueArray) == 1) {
                list($value) = $valueArray;
                $type = "";
            } else {
                list($type, $value) = $valueArray;
            }

            // Skip if value is empty
            if (empty($value)) {
                continue;
            }

            switch($type) {
                case 'campaignid':
                    switch ($key) {
                        case '!=': $aContext['campaign']['exclude'][$value] = true; break;
                        case '==': $aContext['campaign']['include'][$value] = true; break;
                    }
                break;
                case 'clientid':
                    switch ($key) {
                        case '!=': $aContext['client']['exclude'][$value] = true; break;
                        case '==': $aContext['client']['include'][$value] = true; break;
                    }
                break;
                case 'companionid':
                    switch ($key) {
                        case '!=':
                            // Exclusion list prevents competing companion ads from being displayed
                            // even when a previous try to fatch a companion failed
                            $aContext['campaign']['exclude'][$value] = true;
                            break;
                        case '==':
                            // Inclusion list should be ignored if a previous try already failed
                            // to return an ad
                            if ($companion) {
                                $aContext['campaign']['include'][$value] = true;
                            }
                       break;
                    }
                break;
                default:
                    switch ($key) {
                        case '!=': $aContext['banner']['exclude'][$value] = true; break;
                        case '==': $aContext['banner']['include'][$value] = true; break;
                    }
            }
        }
    }

    return $aContext;
}

/**
 * This function builds the context array to track which ads/campaigns have been shown on the current page
 *
 * @param array $aBanner      The ad-array for the ad to render code for
 * @param array $context      The context of this ad selection
 *                            - used for companion positioning
 *                            - and excluding banner/campaigns from this ad-call
 * @return array              The updated context array
 */
function _adSelectBuildContext($aBanner, $context = array()) {
    if (!empty($aBanner['zone_companion'])) {
        // This zone call has companion banners linked to it.
        // So pass into the next call that we would like a banner from this campaign
        // and not from the other companion linked campaigns
        foreach ($aBanner['zone_companion'] AS $companionCampaign) {
            $value = 'companionid:'.$companionCampaign;
            if ($aBanner['placement_id'] == $companionCampaign) {
                $context[] = array('==' => $value);
            } else {
                // Did we previously deliver an ad from this campaign?
                $key = array_search(array('==', $value), $context);
                if ($key === false) {
                    // Nope, we must exclude the campaign then!
                    $context[] = array('!=' => $value);
                }
            }
        }
    }
    if (isset($aBanner['advertiser_limitation']) && $aBanner['advertiser_limitation'] == '1') {
        $context[] = array('!=' => 'clientid:' . $aBanner['client_id']);
    }
    return $context;
}

/**
 * This function removes any ads which cannot be shown for the current impression
 *
 * @param array $aAds - The array of ads to be evaluated
 * @param  $aContext
 * @param unknown_type $source
 * @param unknown_type $richMedia
 * @return none
 */
function _adSelectDiscardNonMatchingAds(&$aAds, $aContext, $source, $richMedia)
{
    // Don't filter ads on direct selection requests (if that setting is disabled)
    if (empty($GLOBALS['_MAX']['CONF']['delivery']['aclsDirectSelection']) && !empty($GLOBALS['_MAX']['DIRECT_SELECTION'])) {
        return;
    }
    foreach ($aAds as $adId => $aAd) {
        OX_Delivery_logMessage('_adSelectDiscardNonMatchingAds: checking bannerid '.$aAd['ad_id'], 7);
        if (!_adSelectCheckCriteria($aAd, $aContext, $source, $richMedia)) {
            OX_Delivery_logMessage('failed _adSelectCheckCriteria: bannerid '.$aAd['ad_id'], 7);
            unset($aAds[$adId]);
        } else {
            OX_Delivery_logMessage('passed _adSelectCheckCriteria: bannerid '.$aAd['ad_id'], 7);
        }
    }
    return;
}

?>
