<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once MAX_PATH . '/lib/max/Dal/Common.php';
require_once MAX_PATH . '/lib/OA/Email.php';
require_once MAX_PATH . '/lib/OA/ServiceLocator.php';

require_once LIB_PATH . '/OperationInterval.php';
require_once OX_PATH . '/lib/pear/Date.php';

/**
 * Definitions of class constants.
 */
define('OX_DAL_MAINTENANCE_STATISTICS_UPDATE_OI',   0);
define('OX_DAL_MAINTENANCE_STATISTICS_UPDATE_HOUR', 1);
define('OX_DAL_MAINTENANCE_STATISTICS_UPDATE_BOTH', 2);

/**
 * The base Data Abstraction Layer (DAL) class for the Maintenance
 * Statistics Engine (MSE), containing all non-database specific
 * code. Database specific code for this DAL needs to be implemented
 * in a final class that extends this class, specific to the
 * appropriate database. As a result, always instantiate this class
 * via the factory class.
 *
 * @package    OpenXDal
 * @subpackage MaintenanceStatistics
 */
abstract class OX_Dal_Maintenance_Statistics extends MAX_Dal_Common
{

    /**
     * A sting that can be used in SQL to cast a value into a timestamp.
     *
     * For example, when using string timestamp literals to create a
     * temporary table, the datatype would be otherwise unknown.
     *
     *  INSERT INTO some_table
     *      timestamp_column
     *  VALUES
     *      (
     *          '2007-04-11 13:49:18'{$this->timestampCastString}
     *      );
     *
     * @var string
     */
    var $timestampCastString;


    /**
     * A method to perform the migration of logged bucket-based aggregate statistics
     * data from the bucket table(s) into a final statistics table.
     *
     * @param string $statisticsTableName The name of the statistics table the
     *                                    data is to be migrated to.
     * @param array $aMigrationMaps An array of arrays containing the details of the
     *                              bucket data to migrate into the statistics table.
     *                              See the Plugins_DeliveryLog::getStatisticsMigration()
     *                              method for details. May contain just one migration
     *                              set, or multiple sets.
     * @param array $aDates An array containing the PEAR Date objects representing the
     *                      start and end dates for the operation interval being migrated,
     *                      indexed by "start" and "end", respectively.
     * @param array $aExtras An array of extra values to insert into the statistics table,
     *                       indexed by column name.
     * @return mixed A PEAR_Error or MDB2_Error object on failure, otherwise, the number
     *               of rows of aggregate data that were migrated from the bucket table(s)
     *               to the statistics table.
     */


    
/////////////////////////////////////////////////// Start - Djax GEO  Statistics////////////////////////////////////////////////////

function djax_geo_statistics($start,$end)
{
$query="select * from djax_geographical_stats where date_time>='$start' and date_time<='$end'";

$query_exe=mysql_query($query);

if(mysql_num_rows($query_exe)>0)
{

}
else
{

			$query_geo="INSERT INTO djax_geographical_stats(date_time,ad_id,zone_id,ip_address,country,country_code,state,city,latitude,longitude,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type)
	SELECT
		date_time,ad_id,zone_id,ip_address,country,country_code,state,city,latitude,longitude,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type
	FROM
	(
				   SELECT
				    m.interval_start AS date_time,m.creative_id as ad_id,m.zone_id as zone_id,v.ip_address as ip_address,v.country_name as country,v.country as country_code,v.state as state,v.city as city,v.latitude as latitude,v.longitude as longitude,sum(m.count) AS impressions,0 as clicks,count(r.viewer_id) as  uniq_impressions,0 as uniq_clicks,v.device_type as delivery_media_type
				FROM
				    ox_data_bkt_m m,djax_track_ad_requests r,djax_track_viewers v
				WHERE
				    r.request_id=m.dj_request_id
				    AND
				    v.viewer_id=r.viewer_id
				    AND
				    m.interval_start >='$start'
				    AND
				    m.interval_start <='$end'

				    GROUP BY
		                    date_time, ad_id, zone_id,ip_address,country,country_code,state,city,latitude,longitude,delivery_media_type) AS virtual_table;";


				mysql_query($query_geo);

				
		
				$select_query="SELECT
				    c.interval_start AS date_time,c.creative_id as ad_id,c.zone_id as zone_id,v.ip_address as ip_address,v.country_name as country,v.country as country_code,v.state as state,v.city as city,v.latitude as latitude,v.longitude as longitude,0 as requests,0 AS impressions,sum(c.count)  as clicks,0 as  uniq_impressions,count(r.viewer_id) as uniq_clicks,v.device_type as delivery_media_type
				FROM
				    ox_data_bkt_c c,djax_track_ad_requests r,djax_track_viewers v
				WHERE
				    r.request_id=c.dj_request_id
				    AND
				    v.viewer_id=r.viewer_id
				    AND
				    c.interval_start >='$start'
				    AND
				    c.interval_start <='$end' GROUP BY
		                    date_time, ad_id, zone_id,ip_address,country,country_code,state,city,latitude,longitude,delivery_media_type";
	 
				$fetch_rows=mysql_query($select_query);

				while($fetch_rec=mysql_fetch_array($fetch_rows))
				{
				mysql_query("update djax_geographical_stats set clicks=".$fetch_rec['clicks']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and ip_address='".$fetch_rec['ip_address']."' and country='".$fetch_rec['country']."' and country_code='".$fetch_rec['country_code']."' and state='".$fetch_rec['state']."'  and  city='".$fetch_rec['city']."'  and  latitude='".$fetch_rec['latitude']."'  and  longitude='".$fetch_rec['longitude']."' and delivery_media_type='".$fetch_rec['delivery_media_type']."'");
				}

				$select_geo_request="SELECT count(r.request_id) as request,r.date_time as date_time,r.zone_id as zone_id,v.ip_address as ip_address,v.country_name as country,v.country as country_code,v.state as state,v.city as city,v.latitude as latitude,v.longitude as longitude FROM djax_track_ad_requests r,djax_track_viewers v where   v.viewer_id=r.viewer_id and date_time >='$start' AND  date_time <='$end' group by date_time,zone_id,ip_address,country,country_code,state,city,latitude,longitude";

				$select_geo_query=mysql_query($select_geo_request);

				while($fetch_geo=mysql_fetch_array($select_geo_query))
				{
					mysql_query("update djax_geographical_stats set requests=".$fetch_geo['request']." where zone_id='".$fetch_geo['zone_id']."' and date_time='".$fetch_geo['date_time']."' and ip_address='".$fetch_geo['ip_address']."' and country='".$fetch_geo['country']."' and country_code='".$fetch_geo['country_code']."' and state='".$fetch_geo['state']."'  and  city='".$fetch_geo['city']."'  and  latitude='".$fetch_geo['latitude']."'  and  longitude='".$fetch_geo['longitude']."'");
	
				}
				
						
				//$this->djax_geo_uniqueimp($start,$end);

	 			//$this->djax_geo_uniqueclick($start,$end);
				
				//$this->djax_geo_conversions($start,$end);
				$this->updateantifraud($start,$end);
				
}

}

//Anti fraud stats 

function updateantifraud($start,$end)
	{
//Djax_penalty	
		$query_penalty=mysql_query("SELECT * FROM djax_penalty");
		
		if(mysql_num_rows($query_penalty)>0)
		{

		while($fetch_penalty=mysql_fetch_array($query_penalty))
		{
          
	/*	$select_penalties=mysql_query("SELECT * FROM djax_penalties WHERE pubid='".$fetch_penalty['pubid']."'");
		
		if(mysql_num_rows($select_penalties)>0)
		{
		$update_penalty=mysql_query("UPDATE djax_penalties SET penaltypoint='".$fetch_penalty['penaltypoint']."' WHERE pubid='".$fetch_penalty['pubid']."'");	
		}
		else
		{*/
		$insert_penalty=mysql_query("INSERT INTO djax_penalties(date_time,pubname,penaltypoint,pubid)VALUES('".$fetch_penalty['interval_start']."','".$fetch_penalty['pubname']."','".$fetch_penalty['penaltypoint']."','".$fetch_penalty['pubid']."')");
		// }

		}
		$delete=mysql_query("delete from djax_penalty");	
		}

//Djax penalty
	
	$query_geo="INSERT INTO djax_anti_fraud_stats(datetime,pubid,fclicks,aclicks,country,ipaddress,url)
			
			SELECT DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00') as datetime,pubid,fclicks,aclicks,country,ipaddress,url from
			(
				   SELECT
				    DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00') as date_time,pub_id as pubid,0 as fclicks,count(viewer_id) as aclicks,country as country,ipaddress as ipaddress,url as url
				FROM
					djax_ad_zone_click
				WHERE
				  date_time >='$start'
				    AND
				  date_time <='$end'
				GROUP BY
		                   DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00'),pubid,country,ipaddress,url
		      ) AS virtual_table;";
		      
		      mysql_query($query_geo);
		      
		      $djax_fraud_click="SELECT
				    DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00') as datetime,pub_id as pubid,count(viewer_id) as fclicks,0 as aclicks,country as country,ipaddress as ipaddress,url as url
				FROM
					djax_ad_fraud_click
				WHERE
				  date_time >='$start'
				    AND
				  date_time <='$end'
				GROUP BY
		                   DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00'),pubid,country,ipaddress,url";
		                   
		      
			$djax_query_exe=mysql_query($djax_fraud_click);

			$djax_rows=mysql_num_rows($djax_query_exe);
			
			if($djax_rows>0)
			{
				while($djax_fraud_res=mysql_fetch_array($djax_query_exe))
				{
					
					$djax_fraud_update="update djax_anti_fraud_stats set  fclicks='".$djax_fraud_res['fclicks']."' where datetime='".$djax_fraud_res['datetime']."' and 
					pubid='".$djax_fraud_res['pubid']."' and country='".$djax_fraud_res['country']."' and url='".$djax_fraud_res['url']."' and 
					ipaddress='".$djax_fraud_res['ipaddress']."'";
					
					$djax_query_exe=mysql_query($djax_fraud_update);
				}
			}

			$delete_valid="delete from djax_ad_fraud_click where   date_time >='$start'
				    AND
				  date_time <='$end'";

			mysql_query($delete_valid);

			$delete_fraud="delete from djax_ad_zone_click where   date_time >='$start'
				    AND
				  date_time <='$end'";

			mysql_query($delete_fraud);
		

	}
//Anti Fraud stats

/////////////////////////////////////////////////// End - Djax GEO  Statistics////////////////////////////////////////////////////
/////////////////////////////////////////////////// Start - Djax Browsers Statistics////////////////////////////////////////////////////
function djax_browser_statistics($start,$end)
{
$query="select * from djax_browsers_stats where date_time>='$start' and date_time<='$end'";

$query_exe=mysql_query($query);

	if(mysql_num_rows($query_exe)>0)
	{

	}
	else
	{
			
				 $query_browsers="INSERT INTO djax_browsers_stats
				(date_time,ad_id,zone_id,user_agent,browser_version,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type)
				SELECT date_time,ad_id,zone_id,user_agent,browser_version,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type FROM ( SELECT m.interval_start AS date_time,m.creative_id as ad_id,m.zone_id as zone_id,r.user_agent as user_agent,r.browser_version as browser_version,0 as requests,sum(m.count) AS impressions,0 as clicks,0 as uniq_impressions,0 as uniq_clicks,v.device_type as delivery_media_type FROM ox_data_bkt_m m,djax_track_ad_requests r,djax_track_viewers v WHERE r.request_id=m.dj_request_id AND v.viewer_id=r.viewer_id AND m.interval_start >='$start' AND m.interval_start <='$end' GROUP BY date_time, ad_id, zone_id,user_agent,browser_version,delivery_media_type) AS virtual_table";


				mysql_query($query_browsers);

				$select_query="SELECT c.interval_start AS date_time, c.creative_id AS ad_id, c.zone_id AS zone_id, r.user_agent AS user_agent, r.browser_version AS browser_version,sum( c.count ) AS clicks, count( r.viewer_id ) AS uniq_clicks, v.device_type AS delivery_media_type
				FROM ox_data_bkt_c c, djax_track_ad_requests r, djax_track_viewers v
				WHERE r.request_id = c.dj_request_id
				AND v.viewer_id = r.viewer_id
				AND c.interval_start >= '$start'
				AND c.interval_start <= '$end'
				GROUP BY date_time, ad_id, zone_id, user_agent, browser_version, delivery_media_type";
	 
				$fetch_rows=mysql_query($select_query);

				while($fetch_rec=mysql_fetch_array($fetch_rows))
				{
			
				mysql_query("update djax_browsers_stats set clicks=".$fetch_rec['clicks']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and user_agent='".$fetch_rec['user_agent']."' and browser_version='".$fetch_rec['browser_version']."'  and delivery_media_type='".$fetch_rec['delivery_media_type']."'");


				}

			
				$select_browser_request="SELECT count(request_id) as request,date_time,zone_id,user_agent,browser_version FROM djax_track_ad_requests where date_time >='$start' AND  date_time <='$end' group by date_time, zone_id, user_agent, browser_version";

				$select_browser_query=mysql_query($select_browser_request);

				while($fetch_browser=mysql_fetch_array($select_browser_query))
				{
					mysql_query("update djax_browsers_stats set requests=".$fetch_browser['request']." where zone_id='".$fetch_browser['zone_id']."' and date_time='".$fetch_browser['date_time']."' and user_agent='".$fetch_browser['user_agent']."' and browser_version='".$fetch_browser['browser_version']."' ");

				}
			
			    	 $this->djax_browser_uniqueimp($start,$end);

			         $this->djax_browser_uniqueclick($start,$end);

				     $this->djax_browser_conversions($start,$end);
	}
}

/////////////////////////////////////////////////// End  - Djax Browsers Statistics////////////////////////////////////////////////////
/////////////////////////////////////////////////// Start  - Djax Client Statistics////////////////////////////////////////////////////

function djax_client_statistics($start,$end)
{

			$query="select * from djax_clients_stats where date_time>='$start' and date_time<='$end'";

			$query_exe=mysql_query($query);

			if(mysql_num_rows($query_exe)>0)
			{

			}
			else
			{

			$query_client="INSERT INTO djax_clients_stats
			(date_time,ad_id,zone_id,os,flash_version,screen_resolution,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type)
			SELECT date_time,ad_id,zone_id,os,flash_version,screen_resolution,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type FROM ( SELECT m.interval_start AS date_time,m.creative_id as ad_id,m.zone_id as zone_id,v.os as os,r.flash_version as flash_version,v.screen_resolution as screen_resolution,0 as requests,sum(m.count) AS impressions,0 as clicks,0 as uniq_impressions,0 as uniq_clicks,v.device_type as delivery_media_type FROM ox_data_bkt_m m,djax_track_ad_requests r,djax_track_viewers v WHERE r.request_id=m.dj_request_id AND v.viewer_id=r.viewer_id AND m.interval_start >='$start' AND m.interval_start <='$end' GROUP BY date_time, ad_id, zone_id,os,flash_version,screen_resolution,delivery_media_type ) AS virtual_table";


			mysql_query($query_client);

			$select_query="SELECT c.interval_start AS date_time, c.creative_id AS ad_id, c.zone_id AS zone_id, v.os AS os, r.flash_version AS flash_version,v.screen_resolution as screen_resolution,sum( c.count ) AS clicks, count( r.viewer_id ) AS uniq_clicks, v.device_type AS delivery_media_type
			FROM ox_data_bkt_c c, djax_track_ad_requests r, djax_track_viewers v
			WHERE r.request_id = c.dj_request_id
			AND v.viewer_id = r.viewer_id
			AND c.interval_start >= '$start'
			AND c.interval_start <= '$end'
			GROUP BY date_time, ad_id, zone_id,os,flash_version,screen_resolution,delivery_media_type";
 
			$fetch_rows=mysql_query($select_query);

			while($fetch_rec=mysql_fetch_array($fetch_rows))
			{
			
			mysql_query("update djax_clients_stats set clicks=".$fetch_rec['clicks']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and os='".$fetch_rec['os']."' and flash_version='".$fetch_rec['flash_version']."'  and screen_resolution='".$fetch_rec['screen_resolution']."' and delivery_media_type='".$fetch_rec['delivery_media_type']."'");

			} 

			$select_client_request="SELECT count( request_id ) AS request, r.date_time AS date_time, r.zone_id AS zone_id, v.os AS os, r.flash_version AS flash_version, v.screen_resolution AS screen_resoultion
			FROM djax_track_ad_requests r, djax_track_viewers v
			WHERE r.date_time >= '$start'
			AND r.date_time <= '$end'
			AND  r.viewer_id=v.viewer_id
			GROUP BY date_time, zone_id, os, flash_version, screen_resolution";

			$select_client_query=mysql_query($select_client_request);

			while($fetch_client=mysql_fetch_array($select_client_query))
			{

				mysql_query("update djax_clients_stats set requests=".$fetch_client['request']." where zone_id='".$fetch_client['zone_id']."' and os='".$fetch_client['os']."' and date_time='".$fetch_client['date_time']."' and flash_version='".$fetch_client['flash_version']."'  and screen_resolution='".$fetch_client['screen_resoultion']."'");

			}
				 $this->djax_client_uniqueimp($start,$end);

				 $this->djax_client_uniqueclick($start,$end);

				 $this->djax_client_conversions($start,$end);
			}	
}
/////////////////////////////////////////////////// End  - Djax Client Statistics////////////////////////////////////////////////////
/////////////////////////////////////////////////// Start  - Djax Site Statistics////////////////////////////////////////////////////
function djax_site_statistics($start,$end)
{

			$query="select * from djax_sites_stats where date_time>='$start' and date_time<='$end'";

			$query_exe=mysql_query($query);

			if(mysql_num_rows($query_exe)>0)
			{

			}
			else
			{
				$query_site_stats="INSERT INTO djax_sites_stats (date_time,ad_id,zone_id,domain,site_url,site_referrer_url,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type) Select date_time,ad_id,zone_id,domain,site_url,site_referrer_url,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type FROM ( SELECT m.interval_start AS date_time,m.creative_id as ad_id,m.zone_id as zone_id,r.domain as domain,r.site_url as site_url,r.site_referrer_url as site_referrer_url,0 as requests,sum(m.count) AS impressions,0 as clicks,0 as uniq_impressions,0 as uniq_clicks,v.device_type as delivery_media_type FROM ox_data_bkt_m m,djax_track_ad_requests r,djax_track_viewers v WHERE r.request_id=m.dj_request_id AND v.viewer_id=r.viewer_id AND m.interval_start >='$start' AND m.interval_start <='$end' GROUP BY date_time, ad_id, zone_id,domain,site_url,site_referrer_url,delivery_media_type ) AS virtual_table";


				mysql_query($query_site_stats);

				$select_query="SELECT c.interval_start AS date_time, c.creative_id AS ad_id, c.zone_id AS zone_id,r.domain as domain,r.site_url as site_url,r.site_referrer_url as site_referrer_url,sum( c.count ) AS clicks, count( r.viewer_id ) AS uniq_clicks, v.device_type AS delivery_media_type
				FROM ox_data_bkt_c c, djax_track_ad_requests r, djax_track_viewers v
				WHERE r.request_id = c.dj_request_id
				AND v.viewer_id = r.viewer_id
				AND c.interval_start >= '$start'
				AND c.interval_start <= '$end'
				GROUP BY date_time, ad_id,zone_id,domain,site_url,site_referrer_url,delivery_media_type";
	 
				$fetch_rows=mysql_query($select_query);

				while($fetch_rec=mysql_fetch_array($fetch_rows))
				{
			
				mysql_query("update djax_sites_stats
	 set clicks=".$fetch_rec['clicks']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and domain='".$fetch_rec['domain']."' and site_url='".$fetch_rec['site_url']."'  and site_referrer_url='".$fetch_rec['site_referrer_url']."' and delivery_media_type='".$fetch_rec['delivery_media_type']."'");


				}

				$select_client_request="SELECT count(request_id) as request,date_time,zone_id,domain,site_url,site_referrer_url FROM djax_track_ad_requests where date_time >='$start' AND  date_time <='$end' group by date_time, zone_id,domain,site_url,site_referrer_url";

				$select_client_query=mysql_query($select_client_request);

				while($fetch_client=mysql_fetch_array($select_client_query))
				{

				mysql_query("update  djax_sites_stats set requests=".$fetch_client['request']." where zone_id='".$fetch_client['zone_id']."'  and date_time='".$fetch_client['date_time']."' and domain='".$fetch_client['domain']."'  and site_url='".$fetch_client['site_url']."'  and site_referrer_url='".$fetch_client['site_referrer_url']."'");

				}
				$this->djax_site_uniqueimp($start,$end);

				$this->djax_site_uniqueclick($start,$end);

				$this->djax_site_conversions($start,$end);
	 
			}


}
/////////////////////////////////////////////////// End  - Djax Site Statistics ///////////////////////////////////////////////////////////////
/////////////////////////////////////////////////// Start  - Djax Mobile device Statistics ////////////////////////////////////////////////////

function djax_device_statistics($start,$end)
{

			$query="select * from djax_mobile_devices_stats where date_time>='$start' and date_time<='$end'";

			$query_exe=mysql_query($query);

			if(mysql_num_rows($query_exe)>0)
			{

			}
			else
			{
				$query_site_stats="INSERT INTO djax_mobile_devices_stats (date_time,ad_id,zone_id, model_name,os,os_version,network_operator,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type) Select date_time,ad_id,zone_id, model_name,os,os_version,network_operator,requests,impressions,clicks,uniq_impressions,uniq_clicks,delivery_media_type FROM ( SELECT m.interval_start AS date_time,m.creative_id as ad_id,m.zone_id as zone_id,v.device_model_name as model_name,v.os as os,v.os_version as os_version,v.isp as network_operator,0 as requests,sum(m.count) AS impressions,0 as clicks,0 as uniq_impressions,0 as uniq_clicks,v.device_type as delivery_media_type FROM ox_data_bkt_m m,djax_track_ad_requests r,djax_track_viewers v WHERE r.request_id=m.dj_request_id AND v.viewer_id=r.viewer_id AND m.interval_start >='$start' AND m.interval_start <='$end' and v.device_type='Mobile' GROUP BY date_time, ad_id, zone_id,os,os_version,model_name,network_operator,delivery_media_type ) AS virtual_table";


				mysql_query($query_site_stats);

				$select_query="SELECT c.interval_start AS date_time, c.creative_id AS ad_id, c.zone_id AS zone_id,v.device_model_name as model_name,v.os as os,v.os_version as os_version,v.isp as network_operator,sum( c.count ) AS clicks, count( r.viewer_id ) AS uniq_clicks, v.device_type AS delivery_media_type
				FROM ox_data_bkt_c c, djax_track_ad_requests r, djax_track_viewers v
				WHERE r.request_id = c.dj_request_id
				AND v.viewer_id = r.viewer_id
				AND c.interval_start >= '$start'
				AND c.interval_start <= '$end' and v.device_type='Mobile'
				GROUP BY date_time, ad_id,zone_id,os,os_version,model_name,network_operator,delivery_media_type";

				$fetch_rows=mysql_query($select_query);

				while($fetch_rec=mysql_fetch_array($fetch_rows))
				{
				mysql_query("update djax_mobile_devices_stats
	 set clicks=".$fetch_rec['clicks']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and os='".$fetch_rec['os']."' and os_version='".$fetch_rec['os_version']."'  and network_operator='".$fetch_rec['network_operator']."' and delivery_media_type='".$fetch_rec['delivery_media_type']."'");

				}

				$select_client_request="SELECT count(r.request_id) as request,r.date_time,r.zone_id,v.device_model_name as model_name,v.os as os,v.os_version as os_version,v.isp as network_operator FROM djax_track_ad_requests r,djax_track_viewers v where date_time >='$start' AND  date_time <='$end' AND v.viewer_id = r.viewer_id group by date_time,zone_id,os,os_version,network_operator,model_name";

				$select_client_query=mysql_query($select_client_request);

				while($fetch_client=mysql_fetch_array($select_client_query))
				{
				mysql_query("update  djax_mobile_devices_stats set requests=".$fetch_client['request']." where zone_id='".$fetch_client['zone_id']."'  and date_time='".$fetch_client['date_time']."' and os='".$fetch_client['os']."' and model_name='".$fetch_client['model_name']."'  and os_version='".$fetch_client['os_version']."' and  network_operator='".$fetch_client['network_operator']."'");

				}

				
					 $this->djax_mobiledevice_uniqueimp($start,$end);

					 $this->djax_mobiledevice_uniqueclick($start,$end);

					 $this->djax_mobile_conversions($start,$end);
			}

}
/////////////////////////////////////////////////// Start  - Djax Mobile device Statistics////////////////////////////////////////////////////


///////	Start	-	All Migration table Unique data Updation starts////////////////////////////

function djax_geo_uniqueimp($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,interval_start  from ox_data_bkt_m where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{
			$select_sub_query="SELECT viewer_id FROM djax_track_ad_requests WHERE `request_id` IN (SELECT `dj_request_id` FROM `ox_data_bkt_m` WHERE `creative_id`=".$fetch_rec['creative_id']." and `zone_id`=".$fetch_rec['zone_id']." and date_time='".$fetch_rec['interval_start']."') GROUP By `viewer_id`";

			$select_exe_sub_query=mysql_query($select_sub_query);

			$rows=mysql_num_rows($select_exe_sub_query);

			mysql_query("update djax_geographical_stats set uniq_impressions='$rows' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."'");
		
			}

}
function djax_geo_uniqueclick($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,interval_start  from ox_data_bkt_c where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

			$select_sub_query="SELECT viewer_id FROM djax_track_ad_requests WHERE request_id IN (SELECT dj_request_id FROM ox_data_bkt_c WHERE creative_id=".$fetch_rec['creative_id']." and zone_id=".$fetch_rec['zone_id']." and date_time='".$fetch_rec['interval_start']."') GROUP By viewer_id";

			$select_exe_sub_query=mysql_query($select_sub_query);

			$rows=mysql_num_rows($select_exe_sub_query);

			mysql_query("update djax_geographical_stats set uniq_clicks='$rows' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."'");

			}

}
function djax_geo_conversions($start,$end)
{

		$query_geo_conversion="SELECT
				
				    r.date_time AS date_time,a.ad_id as ad_id,a.zone_id as zone_id,v.ip_address as ip_address,v.country_name as country,v.country as country_code,v.state as state,v.city as city,v.latitude as latitude,v.longitude as longitude,0 as requests,0 AS impressions,count(a.data_intermediate_ad_connection_id)  as conversions,0 as  uniq_impressions,0 as uniq_clicks,v.device_type as delivery_media_type
				FROM
				    ox_data_intermediate_ad_connection a,djax_track_ad_requests r,djax_track_viewers v
				WHERE
				    r.request_id=a.dj_request_id
				    AND
				    v.viewer_id=r.viewer_id
				    AND
				    a.tracker_date_time >='$start'
				    AND
				    a.tracker_date_time <='$end' GROUP BY
				    
		                    date_time, ad_id, zone_id,ip_address,country,country_code,state,city,latitude,longitude,delivery_media_type";
	 
				$query_exe_geo_conversion=mysql_query($query_geo_conversion);

				while($fetch_geo_rec=mysql_fetch_array($query_exe_geo_conversion))
				{
				mysql_query("update djax_geographical_stats set conversions=".$fetch_geo_rec['conversions']."  where  date_time='".$fetch_geo_rec['date_time']."' and ad_id='".$fetch_geo_rec['ad_id']."' and zone_id='".$fetch_geo_rec['zone_id']."' and ip_address='".$fetch_geo_rec['ip_address']."' and country='".$fetch_geo_rec['country']."' and country_code='".$fetch_geo_rec['country_code']."' and state='".$fetch_geo_rec['state']."'  and  city='".$fetch_geo_rec['city']."'  and  latitude='".$fetch_geo_rec['latitude']."'  and  longitude='".$fetch_geo_rec['longitude']."' and delivery_media_type='".$fetch_geo_rec['delivery_media_type']."'");

				}
}

function djax_browser_uniqueimp($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,interval_start  from ox_data_bkt_m where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

			$select_sub_query="select count(viewer_id) as count,user_agent,browser_version from  (SELECT viewer_id,user_agent,browser_version FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT `dj_request_id` FROM `ox_data_bkt_m` WHERE creative_id='".$fetch_rec['creative_id']."' and zone_id='".$fetch_rec['zone_id']."' and interval_start='".$fetch_rec['interval_start']."') GROUP By viewer_id,user_agent,browser_version)  as virtual_table  group by user_agent,browser_version";

			$select_exe_sub_query=mysql_query($select_sub_query);

			while($fetch_results=mysql_fetch_array($select_exe_sub_query))
			{
			mysql_query("update djax_browsers_stats set uniq_impressions='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and browser_version='".$fetch_results['browser_version']."' and user_agent='".$fetch_results['user_agent']."'");
			}


			}
}
function djax_browser_uniqueclick($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,interval_start  from ox_data_bkt_c where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

				$select_sub_query="select count(viewer_id) as count,user_agent,browser_version from  (SELECT viewer_id,user_agent,browser_version FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT `dj_request_id` FROM ox_data_bkt_c WHERE creative_id='".$fetch_rec['creative_id']."' and zone_id='".$fetch_rec['zone_id']."' and interval_start='".$fetch_rec['interval_start']."') GROUP By viewer_id,user_agent,browser_version)  as virtual_table  group by user_agent,browser_version";

				$select_exe_sub_query=mysql_query($select_sub_query);

				while($fetch_results=mysql_fetch_array($select_exe_sub_query))
				{
				mysql_query("update djax_browsers_stats set uniq_clicks='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and browser_version='".$fetch_results['browser_version']."' and user_agent='".$fetch_results['user_agent']."'");
				}

			}
}
function djax_browser_conversions($start,$end)
{
				$query_browser_conversion="SELECT r.date_time AS date_time, a.ad_id AS ad_id, a.zone_id AS zone_id, r.user_agent AS user_agent, r.browser_version AS browser_version,COUNT( a.data_intermediate_ad_connection_id ) AS conversions,v.device_type AS delivery_media_type
				FROM ox_data_intermediate_ad_connection a, djax_track_ad_requests r, djax_track_viewers v
				WHERE r.request_id = a.dj_request_id
				AND v.viewer_id = r.viewer_id
				AND a.tracker_date_time >= '$start'
				AND a.tracker_date_time <= '$end'
				GROUP BY date_time, ad_id, zone_id, user_agent, browser_version, delivery_media_type";
	 
				$query_exe_browser_conversion=mysql_query($query_browser_conversion);

				while($fetch_rec=mysql_fetch_array($query_exe_browser_conversion))
				{
					
				mysql_query("update djax_browsers_stats set conversions=".$fetch_rec['conversions']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and user_agent='".$fetch_rec['user_agent']."' and browser_version='".$fetch_rec['browser_version']."'  and delivery_media_type='".$fetch_rec['delivery_media_type']."'");

				}
}

function djax_site_uniqueimp($start,$end)
{

			$query=mysql_query("select creative_id,zone_id,interval_start  from ox_data_bkt_m where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

				$select_sub_query="select count(viewer_id) as count,domain,site_url,site_referrer_url from  (SELECT viewer_id,domain,site_url,site_referrer_url FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT `dj_request_id` FROM `ox_data_bkt_m` WHERE creative_id='".$fetch_rec['creative_id']."' and zone_id='".$fetch_rec['zone_id']."' and interval_start='".$fetch_rec['interval_start']."') GROUP By viewer_id,domain,site_url,site_referrer_url)  as virtual_table  group by domain,site_url,site_referrer_url";

				$select_exe_sub_query=mysql_query($select_sub_query);

				while($fetch_results=mysql_fetch_array($select_exe_sub_query))
				{
				mysql_query("update djax_sites_stats set uniq_impressions='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and domain='".$fetch_results['domain']."' and site_url='".$fetch_results['site_url']."' and site_referrer_url='".$fetch_results['site_referrer_url']."'");
				}

			}

}
function djax_site_uniqueclick($start,$end)
{

			$query=mysql_query("select creative_id,zone_id,interval_start  from ox_data_bkt_c where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

				$select_sub_query="select count(viewer_id) as count,domain,site_url,site_referrer_url from  (SELECT viewer_id,domain,site_url,site_referrer_url FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT `dj_request_id` FROM `ox_data_bkt_c` WHERE creative_id='".$fetch_rec['creative_id']."' and zone_id='".$fetch_rec['zone_id']."' and interval_start='".$fetch_rec['interval_start']."') GROUP By viewer_id,domain,site_url,site_referrer_url)  as virtual_table  group by domain,site_url,site_referrer_url";

				$select_exe_sub_query=mysql_query($select_sub_query);

				while($fetch_results=mysql_fetch_array($select_exe_sub_query))
				{
				mysql_query("update djax_sites_stats set uniq_clicks='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and domain='".$fetch_results['domain']."' and site_url='".$fetch_results['site_url']."' and site_referrer_url='".$fetch_results['site_referrer_url']."'");
				}

			}

}
function djax_site_conversions($start,$end)
{

			$query_site_conversion="SELECT r.date_time AS date_time, a.ad_id AS ad_id, a.zone_id AS zone_id,r.domain as domain,r.site_url as site_url,r.site_referrer_url as site_referrer_url,count(a.data_intermediate_ad_connection_id) AS conversions, 0 AS uniq_clicks, v.device_type AS delivery_media_type
			FROM ox_data_intermediate_ad_connection a, djax_track_ad_requests r, djax_track_viewers v
			WHERE r.request_id = a.dj_request_id
			AND v.viewer_id = r.viewer_id
			AND  a.tracker_date_time >= '$start'
			AND  a.tracker_date_time <= '$end'
			GROUP BY date_time, ad_id,zone_id,domain,site_url,site_referrer_url,delivery_media_type";
 
			$query_exe_site_conversion=mysql_query($query_site_conversion);

			while($fetch_rec=mysql_fetch_array($query_exe_site_conversion))
			{
			
			mysql_query("update djax_sites_stats set conversions=".$fetch_rec['conversions']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and domain='".$fetch_rec['domain']."' and site_url='".$fetch_rec['site_url']."'  and site_referrer_url='".$fetch_rec['site_referrer_url']."' and delivery_media_type='".$fetch_rec['delivery_media_type']."'");


			}
}

function djax_client_uniqueimp($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,dj_request_id,interval_start  from ox_data_bkt_m where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

				$select_sub_query="select count(viewer_id) as count,viewer_id,flash_version from (SELECT distinct(viewer_id) AS viewer_id,flash_version as flash_version FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT `dj_request_id` FROM `ox_data_bkt_m` WHERE  creative_id ='".$fetch_rec['creative_id']."' AND zone_id ='".$fetch_rec['zone_id']."' AND interval_start='".$fetch_rec['interval_start']."')) as virtual_table GROUP By viewer_id";

				$select_exe_sub_query=mysql_query($select_sub_query);

				$noofrows=mysql_num_rows($select_exe_sub_query);

				while($fetch_results=mysql_fetch_array($select_exe_sub_query))
				{
				$djax_view_details=$this->djax_getviewer_details($fetch_results['viewer_id']);

				mysql_query("update djax_clients_stats set uniq_impressions='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and os='".$djax_view_details['os']."' and flash_version='".$fetch_results['flash_version']."' and screen_resolution='".$djax_view_details['screen_resolution']."'");

				}

			}
}


function djax_client_uniqueclick($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,dj_request_id,interval_start  from ox_data_bkt_c where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

				$select_sub_query="select count(viewer_id) as count,viewer_id,flash_version from (SELECT distinct(viewer_id) AS viewer_id,flash_version as flash_version FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT `dj_request_id` FROM `ox_data_bkt_c` WHERE  creative_id ='".$fetch_rec['creative_id']."' AND zone_id ='".$fetch_rec['zone_id']."' AND interval_start='".$fetch_rec['interval_start']."')) as virtual_table GROUP By viewer_id";

				$select_exe_sub_query=mysql_query($select_sub_query);

				$noofrows=mysql_num_rows($select_exe_sub_query);

				while($fetch_results=mysql_fetch_array($select_exe_sub_query))
				{
				$djax_view_details=$this->djax_getviewer_details($fetch_results['viewer_id']);

				mysql_query("update djax_clients_stats set uniq_clicks='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and os='".$djax_view_details['os']."' and flash_version='".$fetch_results['flash_version']."' and screen_resolution='".$djax_view_details['screen_resolution']."'");

				}

			}
}

function djax_client_conversions($start,$end)
{

			$query_client_conversion="SELECT r.date_time AS date_time, a.ad_id AS ad_id, a.zone_id AS zone_id, v.os AS os, r.flash_version AS flash_version,v.screen_resolution as screen_resolution,count(a.data_intermediate_ad_connection_id) AS conversions, 0 AS uniq_clicks, v.device_type AS delivery_media_type
			FROM ox_data_intermediate_ad_connection a, djax_track_ad_requests r, djax_track_viewers v
			WHERE r.request_id = a.dj_request_id
			AND v.viewer_id = r.viewer_id
			AND  a.tracker_date_time >= '$start'
			AND  a.tracker_date_time <= '$end'
			GROUP BY date_time, ad_id, zone_id,os,flash_version,screen_resolution,delivery_media_type";
 
			$query_exe_client_conversion=mysql_query($query_client_conversion);

			while($fetch_rec=mysql_fetch_array($query_exe_client_conversion))
			{
		
			mysql_query("update djax_clients_stats set conversions=".$fetch_rec['conversions']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and os='".$fetch_rec['os']."' and flash_version='".$fetch_rec['flash_version']."'  and screen_resolution='".$fetch_rec['screen_resolution']."' and delivery_media_type='".$fetch_rec['delivery_media_type']."'");

			} 

}

function djax_mobiledevice_uniqueimp($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,dj_request_id,interval_start  from ox_data_bkt_m where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

				$select_sub_query="select count(viewer_id) as count,viewer_id,flash_version from (SELECT distinct(viewer_id) AS viewer_id,flash_version as flash_version FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT `dj_request_id` FROM `ox_data_bkt_m` WHERE  creative_id ='".$fetch_rec['creative_id']."' AND zone_id ='".$fetch_rec['zone_id']."' AND interval_start='".$fetch_rec['interval_start']."')) as virtual_table GROUP By viewer_id";

				$select_exe_sub_query=mysql_query($select_sub_query);

				$noofrows=mysql_num_rows($select_exe_sub_query);

				while($fetch_results=mysql_fetch_array($select_exe_sub_query))
				{
				$djax_view_details=$this->djax_getviewer_details($fetch_results['viewer_id']);

				mysql_query("update djax_mobile_devices_stats set uniq_impressions='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and os='".$djax_view_details['os']."' and os_version='".$fetch_results['os_version']."' and network_operator='".$djax_view_details['network_operator']."' and model_name='".$djax_view_details['device_model_name']."'");

				}

			}
}
function djax_mobiledevice_uniqueclick($start,$end)
{
			$query=mysql_query("select creative_id,zone_id,dj_request_id,interval_start  from ox_data_bkt_c where interval_start>='$start' and interval_start<='$end' group by zone_id,creative_id,interval_start");

			while($fetch_rec=mysql_fetch_array($query))
			{

				$select_sub_query="select count(viewer_id) as count,viewer_id,flash_version from (SELECT distinct(viewer_id) AS viewer_id,flash_version as flash_version FROM `djax_track_ad_requests` WHERE `request_id` IN (SELECT dj_request_id FROM ox_data_bkt_c WHERE  creative_id ='".$fetch_rec['creative_id']."' AND zone_id ='".$fetch_rec['zone_id']."' AND interval_start='".$fetch_rec['interval_start']."')) as virtual_table GROUP By viewer_id";

				$select_exe_sub_query=mysql_query($select_sub_query);

				$noofrows=mysql_num_rows($select_exe_sub_query);

				while($fetch_results=mysql_fetch_array($select_exe_sub_query))
				{
				$djax_view_details=$this->djax_getviewer_details($fetch_results['viewer_id']);

				mysql_query("update djax_mobile_devices_stats set uniq_clicks='".$fetch_results['count']."' where ad_id=".$fetch_rec['creative_id']." and zone_id='".$fetch_rec['zone_id']."' and date_time='".$fetch_rec['interval_start']."' and os='".$djax_view_details['os']."' and os_version='".$fetch_results['os_version']."' and network_operator='".$djax_view_details['network_operator']."' and model_name='".$djax_view_details['device_model_name']."'");

				}

			}
}

function djax_mobile_conversions($start,$end)
{

			$query_device_conversion="SELECT r.date_time AS date_time, a.ad_id AS ad_id, a.zone_id AS zone_id,v.device_model_name as model_name,v.os as os,v.os_version as os_version,v.isp as network_operator,count(a.data_intermediate_ad_connection_id) AS conversions, 0 AS uniq_clicks, v.device_type AS delivery_media_type
			FROM ox_data_intermediate_ad_connection a, djax_track_ad_requests r, djax_track_viewers v
			WHERE r.request_id = a.dj_request_id
			AND v.viewer_id = r.viewer_id
			AND a.tracker_date_time >= '$start'
			AND a.tracker_date_time <= '$end' and v.device_type='Mobile'
			GROUP BY date_time, ad_id,zone_id,os,os_version,model_name,network_operator,delivery_media_type";

			$query_exe_device_conversion=mysql_query($query_device_conversion);

			while($fetch_rec=mysql_fetch_array($query_exe_device_conversion))
			{
			mysql_query("update djax_mobile_devices_stats set conversions=".$fetch_rec['conversions']."  where  date_time='".$fetch_rec['date_time']."' and ad_id='".$fetch_rec['ad_id']."' and zone_id='".$fetch_rec['zone_id']."' and os='".$fetch_rec['os']."' and os_version='".$fetch_rec['os_version']."'  and network_operator='".$fetch_rec['network_operator']."' and delivery_media_type='".$fetch_rec['delivery_media_type']."'");

			}
}

///////	End	-	All Migration table Unique data Updation starts////////////////////////////

function djax_getviewer_details($viewerid)
{

			 $djax_viewer="Select * from djax_track_viewers where viewer_id='$viewerid'";

			 $djax_get_viewer=mysql_query($djax_viewer);

			 $djax_viewer_details=mysql_fetch_array($djax_get_viewer);
		
			 return  $djax_viewer_details;
}



    function summariseBucketsAggregate($statisticsTableName, $aMigrationMaps, $aDates, $aExtras = array())
    {

	$Start_date= $aDates['start']->format('%Y-%m-%d %H:%M:%S');

	$End_date= $aDates['end']->format('%Y-%m-%d %H:%M:%S');

	 $this->djax_viewer_statistics($Start_date,$End_date);

	 $this->djax_geo_statistics($Start_date,$End_date);
	
	 $this->djax_browser_statistics($Start_date,$End_date);

	 $this->djax_client_statistics($Start_date,$End_date);

	 $this->djax_site_statistics($Start_date,$End_date);

	 $this->djax_device_statistics($Start_date,$End_date);


        // Perform basic checking of the parameters; assumes that $aMigrationDetails
        // has already been checked by the Plugins_DeliveryLog::testStatisticsMigration()
        // method
        foreach ($aMigrationMaps as $key => $aMigrationDetails) {
            if ($aMigrationDetails['method'] != 'aggregate') {
                $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with migration map index '$key' having method '{$aMigrationDetails['method']}' != 'aggregate'.";
                $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
                return $oError;
            }
            if (count($aMigrationDetails['groupSource']) != count($aMigrationDetails['groupDestination'])) {
                $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with migration map index '$key' having different number of 'groupSource' and 'groupDestination' columns.";
                $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
                return $oError;
            }
            if (count($aMigrationDetails['sumSource']) != count($aMigrationDetails['sumDestination'])) {
                $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with migration map index '$key' having different number of 'sumSource' and 'sumDestination' columns.";
                $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
                return $oError;
            }
            if (count($aMigrationDetails['sumSource']) != count($aMigrationDetails['sumDefault'])) {
                $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with migration map index '$key' having different number of 'sumSource' and 'sumDefault' columns.";
                $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
                return $oError;
            }
        }
        $aMigrationMapKeys = array_keys($aMigrationMaps);
        $masterMigrationMapKey = $aMigrationMapKeys[0];
        unset($aMigrationMapKeys[0]);
        foreach ($aMigrationMapKeys as $key) {
            if ($aMigrationMaps[$masterMigrationMapKey]['groupDestination'] != $aMigrationMaps[$key]['groupDestination']) {
                $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with migration map indexes '$masterMigrationMapKey' and '$key' having different 'groupDestination' arrays.";
                $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
                return $oError;
            }
        }
        if (!is_a($aDates['start'], 'Date') || !is_a($aDates['end'], 'Date')) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with invalid start/end date parameters -- not Date objects.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (!OX_OperationInterval::checkIntervalDates($aDates['start'], $aDates['end'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with invalid start/end date parameters -- not operation interval bounds.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }

        // Ensure that tables exist before trying to run commands based on
        // plugin components
        $oTable = new OA_DB_Table();
        if (!$oTable->extistsTable($statisticsTableName)) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with invalid statistics table '$statisticsTableName'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDREQUEST);
            return $oError;
        }
        foreach ($aMigrationMaps as $key => $aMigrationDetails) {
            if (!$oTable->extistsTable($aMigrationDetails['bucketTable'])) {
                $message = "OX_Dal_Maintenance_Statistics::summariseBucketsAggregate() called with migration map index '$key' having invalid bucket table '{$aMigrationDetails['bucketTable']}'.";
                $oError = new PEAR_Error($message, MAX_ERROR_INVALIDREQUEST);
                return $oError;
            }
        }

        // Ensure that the groupSource, groupDestination, sumSource,
        // sumDestination and sumDefault arrays are all sorted by key
        foreach ($aMigrationMaps as $key => $aMigrationDetails) {
            ksort($aMigrationMaps[$key]['groupSource']);
            ksort($aMigrationMaps[$key]['groupDestination']);
            ksort($aMigrationMaps[$key]['sumSource']);
            ksort($aMigrationMaps[$key]['sumDestination']);
            ksort($aMigrationMaps[$key]['sumDefault']);
        }

        // Prepare the destination columns array, the select columns array,
        // the grouped columns array, the array of the order the summed
        // columns should be selected in and the array of the summed column
        // defaults
        $aDestinationColumns   = array();
        $aSelectColumns        = array();
        $aGroupedColumns       = array();
        $aSummedColumns        = array();
        $aSummedColumnDefaults = array();
        foreach ($aMigrationMaps[$masterMigrationMapKey]['groupDestination'] as $value) {
            $aDestinationColumns[] = $value;
            $aSelectColumns[]      = $value;
            $aGroupedColumns[]     = $this->oDbh->quoteIdentifier($value, true);
        }
        foreach ($aMigrationMaps as $aMigrationDetails) {
            foreach ($aMigrationDetails['sumDestination'] as $key => $value) {
                $aDestinationColumns[] = $value;
                $aSelectColumns[]      = 'SUM(' . $this->oDbh->quoteIdentifier($value, true) . ') AS ' . $this->oDbh->quoteIdentifier($value, true);
                $aSummedColumns[]      = $value;
                $aSummedColumnDefaults = $aMigrationDetails['sumDefault'][$key];
            }
        }

        // Prepare the array of select statements for each bucket source,
        // and test each one (if required) to ensure that there is at least
        // some raw data to migrate (otherwise, any "extra" columns/values
        // that are included will cause the migration SQL to fail)
        $dataExists    = false;
        $aUnionSelects = array();
        foreach ($aMigrationMaps as $aMigrationDetails) {
            // Prepare the array of select statements for the bucket source
            $aSelectColumnStatements = array();
            foreach ($aMigrationDetails['groupDestination'] as $key => $value) {
                $aSelectColumnStatements[] = $this->oDbh->quoteIdentifier($aMigrationDetails['groupSource'][$key], true) . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
            }
            foreach ($aSummedColumns as $value) {
                $key = array_search($value, $aMigrationDetails['sumDestination']);
                if ($key === false) {
                    $aSelectColumnStatements[] = $this->oDbh->quoteIdentifier($aMigrationDetails['sumDefault'][$key], true) . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
                } else {
                    $aSelectColumnStatements[] = $this->oDbh->quoteIdentifier($aMigrationDetails['sumSource'][$key], true) . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
                }
            }
            // Prepare the query to select the data from the bucket source
            $query = "
                SELECT
                    " . implode(', ', $aSelectColumnStatements) . "
                FROM
                    " . $this->oDbh->quoteIdentifier($aMigrationDetails['bucketTable'], true) . "
                WHERE
                    " . $this->oDbh->quoteIdentifier($aMigrationDetails['dateTimeColumn'], true) . " >= " . $this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . "
                    AND
                    " . $this->oDbh->quoteIdentifier($aMigrationDetails['dateTimeColumn'], true) . " <= " . $this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp');
            $aUnionSelects[] = $query;
            // Is a test for data required?
            if ($dataExists == false) {
                // Prevent any strange database error from causing execution to halt
                // by overriding the error handler, run the query, and return the
                // MDB2_Error object, if required
                PEAR::pushErrorHandling(null);
                $rsResult = $this->oDbh->query($query);
                PEAR::popErrorHandling();
                if (PEAR::isError($rsResult)) {
                    return $rsResult;
                }
                // Was any data found?
                if ($rsResult->numRows() > 0) {
                    $dataExists = true;
                }
            }
        }

        if ($dataExists == false) {
            return 0;
        }

        // Add any extra columns/values to the destaination columns array, if required
        if (!empty($aExtras) && is_array($aExtras)) {
            foreach ($aExtras as $key => $value) {
                $aDestinationColumns[] = $this->oDbh->quoteIdentifier($key, true);
                if (is_numeric($value) || preg_match("/^['|\"]\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}['|\"]" . $this->timestampCastString . "/", $value)) {
                    $aSelectColumns[]  = $value . ' AS ' . $this->oDbh->quoteIdentifier($key, true);
                } else {
                    $aSelectColumns[]  = $this->oDbh->quoteIdentifier($value, true) . ' AS ' . $this->oDbh->quoteIdentifier($key, true);
                }
            }
        }

        // Prepare the query to migrate the raw data
       /* $query = "
            INSERT INTO
                " . $this->oDbh->quoteIdentifier($statisticsTableName, true) . "
                (" . implode(', ', $aDestinationColumns) . ")
            SELECT
                " . implode(', ', $aSelectColumns) . "
            FROM
                (" . implode(' UNION ALL ', $aUnionSelects) . "
                ) AS virtual_table
            GROUP BY
                " . implode(', ', $aGroupedColumns) . "
        ";*/


	$aConf = $GLOBALS['_MAX']['CONF'];

	
	$aDestinationColumns[]='device_type';
	$aDestinationColumns[]='dj_total_revenue';

	$aSelectColumns[]='device_type as device_type';
	$aSelectColumns[]='sum(dj_total_revenue) as  dj_total_revenue';
	

            $query = "
            INSERT INTO
                " . $this->oDbh->quoteIdentifier($statisticsTableName, true) . "
                (" . implode(', ', $aDestinationColumns) . ")
            SELECT
                " . implode(', ', $aSelectColumns) . "
            FROM
           (
		    	SELECT
		    	c.interval_start AS date_time,c.creative_id AS ad_id, c.zone_id AS zone_id,v.device_type as device_type,
		    	count AS clicks, 0 AS impressions, 0 AS requests,
		    	(count*dj_win_bid) as dj_total_revenue
		    	FROM 
		    	".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].'data_bkt_c',true)." AS c,
		    	".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_ad_requests'],true)." AS r,
		    	".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_viewers'],true)." AS v
		    	WHERE
		    	c.interval_start >=" . $this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . "
		    	AND
		    	c.interval_start <= ".$this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
		    	AND
		    	r.request_id = c.dj_request_id  AND v.viewer_id = r.viewer_id 

	UNION ALL

	SELECT
		        m.interval_start AS date_time,m.creative_id AS ad_id,m.zone_id AS zone_id,v.device_type as device_type,
		        0 AS clicks,count  AS impressions, 0 AS requests,
		        (count*dj_win_bid) as dj_total_revenue 
		        FROM 
		        ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].'data_bkt_m',true)." AS m,
		    	".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_ad_requests'],true)." AS r,
		    	".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_viewers'],true)." AS v
		        WHERE
		        m.interval_start >=" . $this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . "
		        AND
		        m.interval_start <=  ".$this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
			AND
			r.request_id = m.dj_request_id  AND v.viewer_id = r.viewer_id

	UNION ALL

	SELECT
			rz.interval_start AS date_time,rz.creative_id AS ad_id,rz.zone_id AS zone_id,v.device_type as device_type,
			0 AS clicks,0  AS impressions,0 AS requests,
			dj_win_bid as dj_total_revenue
			
			FROM 
			 ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].'data_bkt_r',true)." AS rz, 
			 ".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_ad_requests'],true)." AS r,
		     ".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_viewers'],true)." AS v
		        WHERE
		        rz.interval_start >=".$this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
		        AND
		        
		        rz.interval_start <=".$this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
			AND
		        r.request_id = rz.dj_request_id  AND v.viewer_id = r.viewer_id

		            
	) AS virtual_table group by date_time,ad_id,zone_id,device_type";





//DAC024 vast start
		$bkt_vast=OA_Dal_Delivery_query("SELECT * FROM ox_data_bkt_vast_e WHERE interval_start >=".$this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')." AND interval_start <=".$this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."") or die("error");
		if(OA_Dal_Delivery_numRows($bkt_vast)>0){
			while($vast_rows=OA_Dal_Delivery_fetchAssoc($bkt_vast)){
				$execute_vast="INSERT INTO ox_stats_vast(interval_start,creative_id,zone_id,dj_request_id,vast_event_id,count)VALUES('".$vast_rows['interval_start']."','".$vast_rows['creative_id']."','".$vast_rows['zone_id']."','".$vast_rows['dj_request_id']."','".$vast_rows['vast_event_id']."','".$vast_rows['count']."')";
				$this->oDbh->exec($execute_vast);
								
			}
			$delete_vast="DELETE FROM ox_data_bkt_vast_e WHERE interval_start >=".$this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')." AND interval_start <=".$this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."";
			$this->oDbh->exec($delete_vast);
		}
//DAC024 vast end


        // Prevent any strange database error from causing execution to halt
        // by overriding the error handler, run the query, and return the
        // result (either the number or rows affected, or an MDB2_Error
        // object on query/database error)
        PEAR::pushErrorHandling(null);
        $result = $this->oDbh->exec($query);
        PEAR::popErrorHandling();
        return $result;
    }

    /**
     * A method to perform the migration of logged bucket-based raw statistics
     * data from the bucket table(s) into a final statistics table.
     *
     * @param string $statisticsTableName The name of the statistics table the
     *                                    data is to be migrated to.
     * @param array $aMigrationDetails An array containing the details of the
     *                                 bucket data to migrate into the statistics
     *                                 table. See the
     *                                 Plugins_DeliveryLog::getStatisticsMigration()
     *                                 method for details.
     * @param array $aDates An array containing the PEAR Date objects representing the
     *                      start and end dates for the operation interval being migrated,
     *                      indexed by "start" and "end", respectively.
     * @return mixed A PEAR_Error or MDB2_Error object on failure, otherwise, the number
     *               of rows of raw data that were migrated from the bucket table to the
     *               statistics table.
     */

	function djax_viewer_statistics($start,$end)
	{
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		$query="select * from ".$this->oDbh->quoteIdentifier($aConf['table']['djax_viewer_stats'],true)."  where date_time>='$start' and date_time<='$end'";

		$query_exe=mysql_query($query);

		if(mysql_num_rows($query_exe)>0)
		{

		}
		else
		{
	
			/*	Migrate clicks and Impressions	*/
			
			$query_viewer="INSERT INTO ".$this->oDbh->quoteIdentifier($aConf['table']['djax_viewer_stats'],true)."(date_time,ad_id, zone_id,viewer_id,clicks,impressions) SELECT date_time, ad_id, zone_id,viewer_id,SUM(clicks) AS clicks, SUM(impressions) AS impressions FROM ( SELECT c.interval_start AS date_time, c.creative_id AS ad_id, c.zone_id AS zone_id,r.viewer_id as viewer_id,c.count AS clicks, 0 AS impressions FROM ox_data_bkt_c c,djax_track_ad_requests r WHERE r.request_id=c.dj_request_id AND c.interval_start >= '$start' AND c.interval_start <= '$end' UNION ALL SELECT m.interval_start AS date_time, m.creative_id AS ad_id, m.zone_id AS zone_id,r.viewer_id as viewer_id,0 AS clicks,m.count AS impressions FROM ox_data_bkt_m m,djax_track_ad_requests r WHERE r.request_id=m.dj_request_id AND m.interval_start >= '$start' AND m.interval_start <='$end' ) AS virtual_table GROUP BY date_time, ad_id, zone_id,viewer_id";

			mysql_query($query_viewer);

			/*	Update requests  from  djax ad request table	*/
			
			$select_viewer="SELECT count(`request_id`) as request,date_time,viewer_id,zone_id  FROM ".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_ad_requests'],true)."  
			where date_time >='$start' AND  date_time <='$end'
			group by date_time,viewer_id,zone_id";

			$select_viewer_query=mysql_query($select_viewer);

			while($fetch_viewer=mysql_fetch_array($select_viewer_query))
			{
				mysql_query("update ".$this->oDbh->quoteIdentifier($aConf['table']['djax_viewer_stats'],true)." set requests=".$fetch_viewer['request']." where zone_id='".$fetch_viewer['zone_id']."' and viewer_id='".$fetch_viewer['viewer_id']."' and date_time='".$fetch_viewer['date_time']."'");

			}
			
			/*	Update conversion from 	ox_data_intermediate_ad_connection and djax ad request table	*/
			
			$query="SELECT r.date_time AS date_time, a.ad_id AS ad_id, a.zone_id AS zone_id,r.viewer_id as viewer_id,COUNT( a.data_intermediate_ad_connection_id ) AS conversions  
			
			FROM 
			
			 ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['data_intermediate_ad_connection'],true)." AS a,".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_ad_requests'],true)." AS r
			
			WHERE a.dj_request_id=r.request_id AND a.tracker_date_time >='$start' AND a.tracker_date_time <='$end' GROUP BY date_time, ad_id, zone_id,viewer_id";

			$djax_query_exe_conversion=mysql_query($query);

			$djax_rows=mysql_num_rows($djax_query_exe_conversion);

			while($djax_fetch_conversion=mysql_fetch_array($djax_query_exe_conversion))
			{
				mysql_query("update ".$this->oDbh->quoteIdentifier($aConf['table']['djax_viewer_stats'],true)." set conversions=".$djax_fetch_conversion['conversions']." where ad_id='".$djax_fetch_conversion['ad_id']."' and zone_id='".$djax_fetch_conversion['zone_id']."' and viewer_id='".$djax_fetch_conversion['viewer_id']."' and date_time='".$djax_fetch_conversion['date_time']."'");
			}
	   }
	
	}


    function summariseBucketsRaw($statisticsTableName, $aMigrationDetails, $aDates)
    {
        // Perform basic checking of the parameters; assumes that $aMigrationDetails
        // has already been checked by the Plugins_DeliveryLog::testStatisticsMigration()
        // method
        if ($aMigrationDetails['method'] != 'raw') {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRaw() called with migration map method '{$aMigrationDetails['method']}' != 'raw'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (count($aMigrationDetails['source']) != count($aMigrationDetails['destination'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRaw() called with different number of 'source' and 'destination' columns.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (count($aMigrationDetails['extrasDestination']) != count($aMigrationDetails['extrasValue'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRaw() called with different number of 'extrasDestination' and 'extrasValue' columns.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (!is_a($aDates['start'], 'Date') || !is_a($aDates['end'], 'Date')) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRaw() called with invalid start/end date parameters -- not Date objects.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (!OX_OperationInterval::checkIntervalDates($aDates['start'], $aDates['end'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRaw() called with invalid start/end date parameters -- not operation interval bounds.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }

        // Ensure that tables exist before trying to run commands based on
        // plugin components
        $oTable = new OA_DB_Table();
        if (!$oTable->extistsTable($statisticsTableName)) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRaw() called with invalid statistics table '$statisticsTableName'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDREQUEST);
            return $oError;
        }
        if (!$oTable->extistsTable($aMigrationDetails['bucketTable'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRaw() called with invalid bucket table '{$aMigrationDetails['bucketTable']}'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDREQUEST);
            return $oError;
        }

        // Ensure that the source, destination, extrasDestination and extrasValue
        // arrays are all sorted by key
        ksort($aMigrationDetails['source']);
        ksort($aMigrationDetails['destination']);
        ksort($aMigrationDetails['extrasDestination']);
        ksort($aMigrationDetails['extrasValue']);

        // Prepare the destination columns array
        $aDestinationColumns = array();
        foreach ($aMigrationDetails['destination'] as $value) {
            $aDestinationColumns[] = $this->oDbh->quoteIdentifier($value, true);
        }
        foreach ($aMigrationDetails['extrasDestination'] as $value) {
            $aDestinationColumns[] = $this->oDbh->quoteIdentifier($value, true);
        }

        // Prepare the select column statements array
        $aSelectColumnStatements = array();
        foreach ($aMigrationDetails['destination'] as $key => $value) {
            $aSelectColumnStatements[] = $this->oDbh->quoteIdentifier($aMigrationDetails['source'][$key], true) . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
        }
        foreach ($aMigrationDetails['extrasDestination'] as $key => $value) {
            if (is_numeric($aMigrationDetails['extrasValue'][$key])) {
                $aSelectColumnStatements[] = $aMigrationDetails['extrasValue'][$key] . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
            } else {
                $aSelectColumnStatements[] = $this->oDbh->quoteIdentifier($aMigrationDetails['extrasValue'][$key], true) . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
            }
        }

        // Prepare the query to migrate the raw data
        $query = "
            INSERT INTO
                " . $this->oDbh->quoteIdentifier($statisticsTableName, true) . "
                (" . implode(', ', $aDestinationColumns) . ")
            SELECT
                " . implode(', ', $aSelectColumnStatements) . "
            FROM
                " . $this->oDbh->quoteIdentifier($aMigrationDetails['bucketTable'], true) . "
            WHERE
                " . $this->oDbh->quoteIdentifier($aMigrationDetails['dateTimeColumn'], true) . " >= " . $this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . "
                AND
                " . $this->oDbh->quoteIdentifier($aMigrationDetails['dateTimeColumn'], true) . " <= " . $this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp');

        // Prevent any strange database error from causing execution to halt
        // by overriding the error handler, run the query, and return the
        // result (either the number or rows affected, or an MDB2_Error
        // object on query/database error)
        PEAR::pushErrorHandling(null);
        $result = $this->oDbh->exec($query);
        PEAR::popErrorHandling();
        return $result;
    }

    /**
     * A method to perform the migration of logged bucket-based supplementary
     * raw statistics data from the bucket table(s) into a final statistics table.
     *
     * @param string $statisticsTableName The name of the statistics table the
     *                                    data is to be migrated to.
     * @param array $aMigrationDetails An array containing the details of the
     *                                 bucket data to migrate into the statistics
     *                                 table. See the
     *                                 Plugins_DeliveryLog::getStatisticsMigration()
     *                                 method for details.
     * @param array $aDates An array containing the PEAR Date objects representing the
     *                      start and end dates for the operation interval being migrated,
     *                      indexed by "start" and "end", respectively.
     * @return mixed A PEAR_Error or MDB2_Error object on failure, otherwise, the number
     *               of rows of raw data that were migrated from the bucket table to the
     *               statistics table.
     */
    function summariseBucketsRawSupplementary($statisticsTableName, $aMigrationDetails, $aDates)
    {
        // Perform basic checking of the parameters; assumes that $aMigrationDetails
        // has already been checked by the Plugins_DeliveryLog::testStatisticsMigration()
        // method
        if ($aMigrationDetails['method'] != 'rawSupplementary') {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with migration map method '{$aMigrationDetails['method']}' != 'rawSupplementary'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (count($aMigrationDetails['masterTablePrimaryKeys']) != count($aMigrationDetails['bucketTablePrimaryKeys'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with different number of 'masterTablePrimaryKeys' and 'bucketTablePrimaryKeys' columns.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (count($aMigrationDetails['masterTableKeys']) != count($aMigrationDetails['bucketTableKeys'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with different number of 'masterTableKeys' and 'bucketTableKeys' columns.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (count($aMigrationDetails['source']) != count($aMigrationDetails['destination'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with different number of 'source' and 'destination' columns.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (!is_a($aDates['start'], 'Date') || !is_a($aDates['end'], 'Date')) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with invalid start/end date parameters -- not Date objects.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }
        if (!OX_OperationInterval::checkIntervalDates($aDates['start'], $aDates['end'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with invalid start/end date parameters -- not operation interval bounds.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDARGS);
            return $oError;
        }

        // Ensure that tables exist before trying to run commands based on
        // plugin components
        $oTable = new OA_DB_Table();
        if (!$oTable->extistsTable($statisticsTableName)) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with invalid statistics table '$statisticsTableName'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDREQUEST);
            return $oError;
        }
        if (!$oTable->extistsTable($aMigrationDetails['masterTable'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with invalid master table '{$aMigrationDetails['masterTable']}'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDREQUEST);
            return $oError;
        }
        if (!$oTable->extistsTable($aMigrationDetails['bucketTable'])) {
            $message = "OX_Dal_Maintenance_Statistics::summariseBucketsRawSupplementary() called with invalid bucket table '{$aMigrationDetails['bucketTable']}'.";
            $oError = new PEAR_Error($message, MAX_ERROR_INVALIDREQUEST);
            return $oError;
        }

        // Prepare the previously migrated raw data statistics table columns array
        $aMasterColumns = array();
        foreach ($aMigrationDetails['masterTablePrimaryKeys'] as $value) {
            $aMasterColumns[] = $this->oDbh->quoteIdentifier($value, true);
        }
        foreach ($aMigrationDetails['masterTableKeys'] as $value) {
            $aMasterColumns[] = $this->oDbh->quoteIdentifier($value, true);
        }

        // Prepare the query to locate the data in columns in the statistics
        // table which contains the previously migrated raw bucket data,
        // which will then be used to locate the supplementary raw data and
        // also to ensure that when this supplementary raw data is migrated
        // to its statistics table, the supplementary raw data can be
        // connected with the previously migrated raw data
        $query = "
            SELECT
                " . implode(', ', $aMasterColumns) . "
            FROM
                " . $this->oDbh->quoteIdentifier($aMigrationDetails['masterTable'], true) . "
            WHERE
                " . $this->oDbh->quoteIdentifier($aMigrationDetails['masterDateTimeColumn'], true) . " >= " . $this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . "
                AND
                " . $this->oDbh->quoteIdentifier($aMigrationDetails['masterDateTimeColumn'], true) . " <= " . $this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp');

        // Prevent any strange database error from causing execution to halt
        // by overriding the error handler, run the query, and return the
        // MDB2_Error object, if required
        PEAR::pushErrorHandling(null);
        $rsResult = $this->oDbh->query($query);
        PEAR::popErrorHandling();
        if (PEAR::isError($rsResult)) {
            return $rsResult;
        }

        // Were any rows found for previously migrated summarised raw data?
        if ($rsResult->numRows() == 0) {
            return 0;
        }

        // Ensure that the required arrays are sorted by key
        ksort($aMigrationDetails['masterTableKeys']);
        ksort($aMigrationDetails['bucketTableKeys']);
        ksort($aMigrationDetails['source']);
        ksort($aMigrationDetails['destination']);

        // Prepare the destination columns array
        $aDestinationColumns = array();
        foreach ($aMigrationDetails['bucketTablePrimaryKeys'] as $value) {
            $aDestinationColumns[] = $this->oDbh->quoteIdentifier($value, true);
        }
        foreach ($aMigrationDetails['destination'] as $value) {
            $aDestinationColumns[] = $this->oDbh->quoteIdentifier($value, true);
        }

        $counter = 0;
        while ($aRow = $rsResult->fetchRow()) {
            // Prepare the select column statements array
            $aSelectColumnStatements = array();
            foreach ($aMigrationDetails['bucketTablePrimaryKeys'] as $value) {
                $aSelectColumnStatements[] = $this->oDbh->quote($aRow[$value], 'text') . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
            }
            foreach ($aMigrationDetails['destination'] as $key => $value) {
                $aSelectColumnStatements[] = $this->oDbh->quoteIdentifier($aMigrationDetails['source'][$key], true) . ' AS ' . $this->oDbh->quoteIdentifier($value, true);
            }

            // Prepare the where statementes array
            $aWhereStatements = array();
            foreach ($aMigrationDetails['masterTableKeys'] as $key => $value) {
                $aWhereStatements[] = $this->oDbh->quoteIdentifier($aMigrationDetails['bucketTableKeys'][$key], true) . ' = ' . $this->oDbh->quote($aRow[$value], 'text');
            }

            // Prepare the query to migrate the supplementary raw data from bucket
            // table to the statistics table
            $query = "
                INSERT INTO
                    " . $this->oDbh->quoteIdentifier($statisticsTableName, true) . "
                    (" . implode(', ', $aDestinationColumns) . ")
                SELECT
                    " . implode(', ', $aSelectColumnStatements) . "
                FROM
                    " . $this->oDbh->quoteIdentifier($aMigrationDetails['bucketTable'], true) . "
                WHERE
                    " . implode(' AND ', $aWhereStatements);

            // Prevent any strange database error from causing execution to halt
            // by overriding the error handler, run the query, and return the
            // result (either the number or rows affected, or an MDB2_Error
            // object on query/database error)
            PEAR::pushErrorHandling(null);
            $result = $this->oDbh->exec($query);
            PEAR::popErrorHandling();
            if (PEAR::isError($result)) {
                return $result;
            }
            $counter += $result;
        }
        return $counter;
    }

    /**
     * A method to migrate any old style raw requests into new style, bucket-based
     * requests, in the event of the requirement to process any such data on upgrade
     * to (or beyond) OpenX 2.8.
     *
     * @param PEAR::Date $oStart The start date of the operation interval to migrate.
     * @param PEAR::Date $oEnd The end date of the operation interval to migrate.
     */
    function migrateRawRequests($oStart, $oEnd)
    {
        // Perform the default action for migration of raw requests...
        return $this->_migrateRawData($oStart, $oEnd, 'request');
    }

    /**
     * A method to migrate any old style raw impressions into new style, bucket-based
     * impressions, in the event of the requirement to process any such data on upgrade
     * to (or beyond) OpenX 2.8.
     *
     * @param PEAR::Date $oStart The start date of the operation interval to migrate.
     * @param PEAR::Date $oEnd The end date of the operation interval to migrate.
     */
    function migrateRawImpressions($oStart, $oEnd)
    {
        // Perform the default action for migration of raw impressions...
        return $this->_migrateRawData($oStart, $oEnd, 'impression');
    }

    /**
     * A method to migrate any old style raw clicks into new style, bucket-based
     * clicks, in the event of the requirement to process any such data on upgrade
     * to (or beyond) OpenX 2.8.
     *
     * @param PEAR::Date $oStart The start date of the operation interval to migrate.
     * @param PEAR::Date $oEnd The end date of the operation interval to migrate.
     */
    function migrateRawClicks($oStart, $oEnd)
    {
        // Perform the default action for migration of raw clicks...
        return $this->_migrateRawData($oStart, $oEnd, 'click');
    }

    /**
     * A private method to migrate any old style raw data into new style, bucket-based
     * data, in the event of the requirement to process any such data on upgrade
     * to (or beyond) OpenX 2.8.
     *
     * @param PEAR::Date $oStart The start date of the operation interval to migrate.
     * @param PEAR::Date $oEnd The end date of the operation interval to migrate.
     * @param string $type The type of raw data to migration; one of "request",
     *                     "impression" or "click".
     */
    private function _migrateRawData($oStart, $oEnd, $type)
    {
        $aConf = $GLOBALS['_MAX']['CONF'];
        // Prepare the raw data table name
        $rawTable = $aConf['table']['prefix'] . $aConf['table']['data_raw_ad_' . $type];
        // Prepare the bucket table name
        $bucketTable = $aConf['table']['prefix'] . 'data_bkt_';
        if ($type == 'request') {
            $bucketTable .= 'r';
        } else if ($type == 'impression') {
            $bucketTable .= 'm';
        } else if ($type == 'click') {
            $bucketTable .= 'c';
        } else {
            // Invalid call!
            MAX::raiseError('   - Invalid call to raw to bucket data migration! Aborting', MAX_ERROR_INVALIDCALL, PEAR_ERROR_DIE);
        }
        // Select the summarised raw data from the table, and insert it
        // into the data bucket table
        $query = $this->_getMigrateRawDataSQL($bucketTable, $rawTable, $oStart, $oEnd);
        $rsResult = $this->oDbh->query($query);
        if (PEAR::isError($rsResult)) {
            return MAX::raiseError($rsResult, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
        }
    }

    /**
     * A private, abstract method that must be implemented by each database-specific
     * child class to return the SQL code required to migrate any old style raw data
     * into new style, bucket-based data, in the event of the requirement to process
     * any such data on upgrade to (or beyond) OpenX 2.8.
     *
     * @abstract
     * @param string $bucketTable The bucket table to migrate the data into.
     * @param string $rawTable The raw table to migrate the data from.
     * @param PEAR::Date $oStart The start date of the operation interval to migrate.
     * @param PEAR::Date $oEnd The end date of the operation interval to migrate.
     */
    abstract function _getMigrateRawDataSQL($bucketTable, $rawTable, $oStart, $oEnd);

    /**
     * A method to manage the migration of conversions from the final conversion
     * tables to the old-style intermediate table.
     *
     * @TODO Deprecate, when conversion data is no longer required in the
     *       old format intermediate and summary tables.
     *
     * @param PEAR::Date $oStart The start date/time to migrate from.
     * @param PEAR::Date $oEnd   The end date/time to migrate to.
     */
    function manageConversions($oStart, $oEnd)
    {
        $aConf = $GLOBALS['_MAX']['CONF'];
        // The custom IF function in PgSQL is not suitable for this query, we need explicit use of CASE
        if ($this->oDbh->dbsyntax == 'pgsql') {
            $sqlBasketValue = "CASE WHEN v.purpose = 'basket_value' AND diac.connection_status = ". MAX_CONNECTION_STATUS_APPROVED ." THEN diavv.value::numeric ELSE 0 END";
            $sqlNumItems = "CASE WHEN v.purpose = 'num_items' AND diac.connection_status = ". MAX_CONNECTION_STATUS_APPROVED ." THEN diavv.value::integer ELSE 0 END";
        } else {
            $sqlBasketValue = "IF(v.purpose = 'basket_value' AND diac.connection_status = ". MAX_CONNECTION_STATUS_APPROVED .", diavv.value, 0)";
            $sqlNumItems = "IF(v.purpose = 'num_items' AND diac.connection_status = ". MAX_CONNECTION_STATUS_APPROVED .", diavv.value, 0)";
        }
        // Prepare the query to obtain all of the conversions, and their associated total number
        // of items and total basket values (where they exist), ready for update/insertion into
        // the data_intermediate_ad table
        $query = "
            SELECT
                DATE_FORMAT(diac.tracker_date_time, '%Y-%m-%d %H:00:00'){$this->timestampCastString} AS date_f,
                diac.ad_id AS ad_id,
                diac.zone_id AS zone_id,
                sum(diac.dj_win_bid) as dj_total_revenue,
				a.device_type as device_type,
                COUNT(DISTINCT(diac.data_intermediate_ad_connection_id)) AS conversions,
                SUM({$sqlBasketValue}) AS total_basket_value,
                SUM({$sqlNumItems}) AS total_num_items
            FROM
                " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_intermediate_ad_connection', true) . " AS diac
                join ".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_ad_requests'],true)." AS r on (r.request_id=diac.dj_request_id) 
                join ".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_viewers'],true)." AS a on (r.viewer_id=a.viewer_id)
            LEFT JOIN
                " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_intermediate_ad_variable_value', true) . " AS diavv
            USING
                (
                    data_intermediate_ad_connection_id
                )
            LEFT JOIN
                " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'variables', true) . " AS v
            ON
                (
                    diavv.tracker_variable_id = v.variableid
                    AND v.purpose IN ('basket_value', 'num_items')
                )
            WHERE
                diac.connection_status = " . MAX_CONNECTION_STATUS_APPROVED . "
                AND diac.inside_window = 1
                AND diac.tracker_date_time >= ". $this->oDbh->quote($oStart->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . "
                AND diac.tracker_date_time <= ". $this->oDbh->quote($oEnd->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . "
            GROUP BY
                diac.data_intermediate_ad_connection_id,
                date_f,
                diac.ad_id,
                diac.zone_id,a.device_type";
                
               
                 
        OA::debug('- Selecting conversion data for migration to the "old style" intermediate table for ', PEAR_LOG_DEBUG);
        OA::debug('  conversion in the range ' . $oStart->format('%Y-%m-%d %H:%M:%S') . ' ' . $oStart->tz->getShortName() . ' to ' . $oEnd->format('%Y-%m-%d %H:%M:%S') . ' ' . $oEnd->tz->getShortName(), PEAR_LOG_DEBUG);
        $rsResult = $this->oDbh->query($query);
        if (PEAR::isError($rsResult)) {
            return MAX::raiseError($rsResult, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
        }
        while ($aRow = $rsResult->fetchRow()) {
            // Prepare the update query
            $query = "
                UPDATE
                    " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_intermediate_ad', true) . "
                SET
                    conversions = conversions + " . $this->oDbh->quote($aRow['conversions'], 'integer') . ",
                    dj_total_revenue=dj_total_revenue + " . $this->oDbh->quote($aRow['dj_total_revenue']) . ",
                    total_basket_value = total_basket_value + " . $this->oDbh->quote($aRow['total_basket_value'], 'float') . ",
                    total_num_items = total_num_items + " . $this->oDbh->quote($aRow['total_num_items'], 'integer') . "
                WHERE
                    date_time = " . $this->oDbh->quote($aRow['date_f'], 'timestamp') . "
                    AND device_type=" . $this->oDbh->quote($aRow['device_type']) . "
                    AND ad_id = " . $this->oDbh->quote($aRow['ad_id'], 'integer') . "
                    AND zone_id = " . $this->oDbh->quote($aRow['zone_id'], 'integer');
            $rsUpdateResult = $this->oDbh->exec($query);
            if (PEAR::isError($rsUpdateResult)) {
                return MAX::raiseError($rsUpdateResult, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
            }
            if ($rsUpdateResult == 0) {
                // Could not perform the update - try an insert instead
                $oDate = new Date($aRow['date_f']);
                $operationIntervalId = OX_OperationInterval::convertDateToOperationIntervalID($oDate);
                $aDates = OX_OperationInterval::convertDateToOperationIntervalStartAndEndDates($oDate);
                $query = "
                    INSERT INTO
                        " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_intermediate_ad', true) . "
                        (
                            date_time,
                            operation_interval,
                            operation_interval_id,
                            interval_start,
                            interval_end,
                            ad_id,
                            creative_id,
                            zone_id,
                            conversions,
                            total_basket_value,
                            total_num_items
                        )
                    VALUES
                        (
                            " . $this->oDbh->quote($aRow['date_f'], 'timestamp') . ",
                            " . $this->oDbh->quote($aConf['maintenance']['operationInterval'], 'integer') . ",
                            " . $this->oDbh->quote($operationIntervalId, 'integer') . ",
                            " . $this->oDbh->quote($aDates['start']->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . ",
                            " . $this->oDbh->quote($aDates['end']->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . ",
                            " . $this->oDbh->quote($aRow['ad_id'], 'integer') . ",
                            0,
                            " . $this->oDbh->quote($aRow['zone_id'], 'integer') . ",
                            " . $this->oDbh->quote($aRow['conversions'], 'integer') . ",
                            " . $this->oDbh->quote($aRow['total_basket_value'], 'float') . ",
                            " . $this->oDbh->quote($aRow['total_num_items'], 'integer') . "
                        )";
                $rsInsertResult = $this->oDbh->exec($query);
            }
        }
    }

    /**
     * A method to update the summary table from the intermediate tables.
     *
     * @param PEAR::Date $oStartDate The start date/time to update from.
     * @param PEAR::Date $oEndDate   The end date/time to update to.
     * @param array $aActions        An array of data types to summarise. Contains
     *                               two array, the first containing the data types,
     *                               and the second containing the connection type
     *                               values associated with those data types, if
     *                               appropriate. For example:
     *          array(
     *              'types'       => array(
     *                                  0 => 'request',
     *                                  1 => 'impression',
     *                                  2 => 'click'
     *                               ),
     *              'connections' => array(
     *                                  1 => MAX_CONNECTION_AD_IMPRESSION,
     *                                  2 => MAX_CONNECTION_AD_CLICK
     *                               )
     *          )
     *                               Note that the order of the items must match
     *                               the order of the items in the database tables
     *                               (e.g. in data_intermediate_ad and
     *                               data_summary_ad_hourly for the above example).
     * @param string $fromTable      The name of the intermediate table to summarise
     *                               from (e.g. 'data_intermediate_ad').
     * @param string $toTable        The name of the summary table to summarise to
     *                               (e.g. 'data_summary_ad_hourly').
     */
    function saveSummary($oStartDate, $oEndDate, $aActions, $fromTable, $toTable)
    {
        $aConf = $GLOBALS['_MAX']['CONF'];
        // Check that there are types to summarise
        if (empty($aActions['types']) || empty($aActions['connections'])) {
            return;
        }
        // How many days does the start/end period span?
        $days = Date_Calc::dateDiff($oStartDate->getDay(),
                                    $oStartDate->getMonth(),
                                    $oStartDate->getYear(),
                                    $oEndDate->getDay(),
                                    $oEndDate->getMonth(),
                                    $oEndDate->getYear());
        if ($days == 0) {
            // Save the data
            $this->_saveSummary($oStartDate, $oEndDate, $aActions, $fromTable, $toTable);
        } else {
            // Save each day's data separately
            for ($counter = 0; $counter <= $days; $counter++) {
                if ($counter == 0) {
                    // This is the first day
                    $oInternalStartDate = new Date();
                    $oInternalStartDate->copy($oStartDate);
                    $oInternalEndDate = new Date($oStartDate->format('%Y-%m-%d') . ' 23:59:59');
                } elseif ($counter == $days) {
                    // This is the last day
                    $oInternalStartDate = new Date($oEndDate->format('%Y-%m-%d') . ' 00:00:00');
                    $oInternalEndDate = new Date();
                    $oInternalEndDate->copy($oEndDate);
                } else {
                    // This is a day in the middle
                    $oDayDate = new Date();
                    $oDayDate->copy($oStartDate);
                    $oDayDate->addSeconds(SECONDS_PER_DAY * $counter);
                    $oInternalStartDate = new Date($oDayDate->format('%Y-%m-%d') . ' 00:00:00');
                    $oInternalEndDate = new Date($oDayDate->format('%Y-%m-%d') . ' 23:59:59');
                }
                $this->_saveSummary($oInternalStartDate, $oInternalEndDate, $aActions, $fromTable, $toTable);
            }
        }
    }

    /**
     * A private method to update the summary table from the intermediate tables.
     * Can only be used for start and end dates that are in the same day.
     *
     * @access private
     * @param PEAR::Date $oStartDate The start date/time to update from.
     * @param PEAR::Date $oEndDate   The end date/time to update to.
     * @param array $aActions        An array of action types to summarise. Contains
     *                               two array, the first containing the data types,
     *                               and the second containing the connection type
     *                               values associated with those data types, if
     *                               appropriate. For example:
     *          array(
     *              'types'       => array(
     *                                  0 => 'request',
     *                                  1 => 'impression',
     *                                  2 => 'click'
     *                               ),
     *              'connections' => array(
     *                                  1 => MAX_CONNECTION_AD_IMPRESSION,
     *                                  2 => MAX_CONNECTION_AD_CLICK
     *                               )
     *          )
     *                             Note that the order of the items must match
     *                             the order of the items in the database tables
     *                             (e.g. in data_intermediate_ad and
     *                             data_summary_ad_hourly for the above example).
     * @param string $fromTable    The name of the intermediate table to summarise
     *                             from (e.g. 'data_intermediate_ad').
     * @param string $toTable      The name of the summary table to summarise to
     *                             (e.g. 'data_summary_ad_hourly').
     */
    function _saveSummary($oStartDate, $oEndDate, $aActions, $fromTable, $toTable)
    {
        $aConf = $GLOBALS['_MAX']['CONF'];
        if ($oStartDate->format('%Y-%m-%d') != $oEndDate->format('%Y-%m-%d')) {
            MAX::raiseError('_saveSummary called with dates not on the same day.', null, PEAR_ERROR_DIE);
        }
        $finalFromTable = $aConf['table']['prefix'] . $aConf['table'][$fromTable];
        $finalToTable   = $aConf['table']['prefix'] . $aConf['table'][$toTable];
        $query = "
            INSERT INTO
                ".$this->oDbh->quoteIdentifier($finalToTable,true)."
                (
                    date_time,
                    ad_id,
                    creative_id,
                    zone_id,dj_delivery_media_type,dj_total_revenue,";
        foreach ($aActions['types'] as $type) {
            $query .= "
                    {$type}s,";
        }
        $query .= "
                    conversions,
                    total_basket_value,
                    total_num_items,
                    updated
                )
            SELECT
                DATE_FORMAT(date_time, '%Y-%m-%d %H:00:00'){$this->timestampCastString} AS hour_date_time,
                ad_id AS ad_id,
                creative_id AS creative_id,
                zone_id AS zone_id,device_type as device_type,dj_total_revenue as dj_total_revenue,";
        foreach ($aActions['types'] as $type) {
            $query .= "
                SUM({$type}s) AS {$type}s,";
        }
        $query .= "
                SUM(conversions) AS conversions,
                SUM(total_basket_value) AS total_basket_value,
                SUM(total_num_items) AS total_num_items,
                '".date('Y-m-d H:i:s')."'
            FROM
                ".$this->oDbh->quoteIdentifier($finalFromTable,true)."
            WHERE
                date_time >= ". $this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
                AND date_time <= ". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
            GROUP BY
                hour_date_time, ad_id, creative_id, zone_id,device_type";
        // Prepare the message about what's about to happen
        $message = '- Summarising the ad ' . implode('s, ', $aActions['types']) . 's and conversions';
        $message .= " from the $finalFromTable table";
        OA::debug($message, PEAR_LOG_DEBUG);
        $message = "  into the $finalToTable table, for data" .
                    ' between ' . $oStartDate->format('%Y-%m-%d') . ' ' . $oStartDate->format('%H') . ':00:00 ' . $oStartDate->tz->getShortName() .
                    ' and ' . $oStartDate->format('%Y-%m-%d') . ' ' . $oEndDate->format('%H') . ':59:59 ' . $oStartDate->tz->getShortName() . '.';
        OA::debug($message, PEAR_LOG_DEBUG);
        $rows = $this->oDbh->exec($query);
        if (PEAR::isError($rows)) {
            return MAX::raiseError($rows, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
        }
        $message = '- Summarised ' . $rows . ' rows of ' . implode('s, ', $aActions['types']) . 's and conversions';
        $message .= '.';
        OA::debug($message, PEAR_LOG_DEBUG);
        // Update the recently summarised data with basic financial information
        $this->_saveSummaryUpdateWithFinanceInfo($oStartDate, $oEndDate, $toTable);
        
	//////Djax Adexchange ad hourly	------ Migrattion files //////////////
		
	$this->_uniquedataupdate($oStartDate, $oEndDate);
	$this->_updaterequest($oStartDate, $oEndDate);
	$this->_updatepayment($oStartDate, $oEndDate);
	$this->_updatenetworkstats($oStartDate,$oEndDate);
		
    }

    

	function _updatenetworkstats($oStartDate,$oEndDate)
	{

		$aConf = $GLOBALS['_MAX']['CONF'];
	
		$query="SELECT date_time AS date_time, ad_id AS ad_id, zone_id AS zone_id, dj_delivery_media_type AS device_type, requests AS requests, impressions AS impressions, clicks AS clicks, conversions AS conversions, dj_total_revenue AS dj_total_revenue, dj_publisher_earnings AS dj_publisher_earnings FROM  " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_summary_ad_hourly', true) . "
			WHERE date_time >=".$this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp'). "
			AND date_time <=".$this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."";

		$rsResult =$this->oDbh->query($query);

		$djax_admin_config=$this->oDbh->query("SELECT * FROM djax_app_configurations");

		$djax_admin_configdata=$djax_admin_config->fetchRow();

		while($aRow = $rsResult->fetchRow())
		{

				$getagency=$this->oDbh->query("SELECT
					d.bannerid AS ad_id,
					m.agencyid AS agency_id
    				FROM
	       				{$aConf['table']['prefix']}banners AS d,
	       				{$aConf['table']['prefix']}campaigns AS c,
	       				{$aConf['table']['prefix']}clients AS m
    				WHERE
					d.bannerid={$aRow['ad_id']}
					AND
					d.campaignid = c.campaignid
					AND
					m.clientid = c.clientid");

				$getagencyResult=$getagency->fetchRow();

				/*Manager share - revenue after share given to publishers*/
				$djax_spend=0;

				$djax_spend=$aRow['dj_total_revenue']-$aRow['dj_publisher_earnings'];

				$dj_query=$this->oDbh->query("SELECT manager_share,default_manager,role FROM `djax_network_managers` WHERE agency_id = '".$getagencyResult['agency_id']."'");

				$djax_results=$dj_query->fetchRow();


				if($djax_results['default_manager']==1 && $djax_results['role']=='ADMIN')
				{

					$djax_manager_profit=0;

					$adminprofit=$djax_spend;
				}
				else
				{
					$managershare=!empty($djax_results['manager_share'])?$djax_results['manager_share']:$djax_admin_configdata['default_manager_share'];

					/*Admin Share*/

					$djax_manager_profit=$djax_spend*($managershare/100);

					$adminprofit=$djax_spend-$djax_manager_profit;

				}

				$this->oDbh->exec("INSERT INTO djax_network_stats (`date_time`, `agency_id`, `ad_id`, `zone_id`, `requests`, `impressions`, `clicks`, `conversions`, `advertiser_spend`, `publisher_share`,network_revenue,admin_revenue) VALUES ('".$aRow['date_time']."', '".$getagencyResult['agency_id']."', '".$aRow['ad_id']."', '".$aRow['zone_id']."', '".$aRow['requests']."', '".$aRow['impressions']."','".$aRow['clicks']."', '".$aRow['conversions']."','".$aRow['dj_total_revenue']."', '".$aRow['dj_publisher_earnings']."','$djax_manager_profit','$adminprofit');");




		}
	}


    function _updatepayment($oStartDate,$oEndDate)
	{
		
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		$query="SELECT dj_total_revenue AS dj_total_revenue,date_time AS date_time,ad_id AS ad_id,zone_id AS zone_id,dj_delivery_media_type  AS device_type
			FROM 
			" . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_summary_ad_hourly', true) . "
			WHERE date_time >=".$this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp'). "
			AND date_time <=".$this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."";

		$rsResult = $this->oDbh->query($query);
		 
		
		
		while($aRow = $rsResult->fetchRow())
		{

							$djax_publisher_share=$this->djax_publisher_share($aRow['zone_id']);
		
							$publisher_share_amount=$aRow['dj_total_revenue']*($djax_publisher_share/100);
		
							$query_update = "UPDATE
		
										" . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_summary_ad_hourly', true) . "
										SET
										dj_publisher_earnings = '".$publisher_share_amount."'
										WHERE
										date_time ='".$aRow['date_time']."'
										AND dj_delivery_media_type='".$aRow['device_type']."'
										AND ad_id ='".$aRow['ad_id']."'
										AND zone_id='".$aRow['zone_id']."'";

						$rsUpdateResult = $this->oDbh->exec($query_update);

					
						
		}

	}


    function djax_publisher_share($zoneid)
	{
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		$chk_pub_share="select a.dj_share_per as dj_share_per from 
		
		".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['affiliates'],true)." AS a,
		".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['zones'],true)." AS z
		
		where z.affiliateid=a.affiliateid and z.zoneid='$zoneid'";
		
		$rsResult = $this->oDbh->query($chk_pub_share);
					       
		$fetch_record=$rsResult->fetchRow();
					
		if(!empty($fetch_record['dj_share_per']))
		{
							return $fetch_record['dj_share_per'];
		}
		else
		{
							$chk_pub_share="select pub_min_share from 
						
							".$this->oDbh->quoteIdentifier($aConf['table']['djax_app_configurations'],true)."";
		
							$rsResult = $this->oDbh->query($chk_pub_share);
						
							$fetch_record=$rsResult->fetchRow();
						
							return $fetch_record['pub_min_share'];
		}
		
	}

	function _uniquedataupdate($oStartDate, $oEndDate)
	{

		$aConf = $GLOBALS['_MAX']['CONF'];
		
					$query="SELECT COUNT( viewer_id ) AS unique_impression,ad_id as ad_id,zone_id as zone_id,date_time
					   FROM ".$this->oDbh->quoteIdentifier($aConf['table']['djax_viewer_stats'],true)."
					   WHERE date_time >= ".$this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
					   AND date_time <=".$this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
					   AND impressions !=0
					   GROUP BY ad_id, zone_id, date_time";

					$rsResult = $this->oDbh->query($query);
					       
					while($fetch_record=$rsResult->fetchRow())
					{

							$update_unique_imp="update " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_summary_ad_hourly', true) . " 
							set 
							dj_unique_impressions='".$fetch_record['unique_impression']."' where
							ad_id='".$fetch_record['ad_id']."' and
							zone_id='".$fetch_record['zone_id']."' and
							date_time='".$fetch_record['date_time']."'";
						
							$rsUpdateResult = $this->oDbh->exec($update_unique_imp);
						
					}

					$query_unique_clicks="SELECT COUNT( viewer_id ) AS unique_clicks,ad_id as ad_id,zone_id as zone_id,date_time
					   FROM ".$this->oDbh->quoteIdentifier($aConf['table']['djax_viewer_stats'],true)."
					   WHERE date_time >= ".$this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
					   AND date_time <=".$this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp')."
					   AND clicks !=0
					   GROUP BY ad_id, zone_id, date_time";

					$rs_Result = $this->oDbh->query($query_unique_clicks);
					       
					while($fetch_record=$rs_Result->fetchRow())
					{

							$update_unique_click="update 
							" . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_summary_ad_hourly', true) . "
							set dj_unique_clicks='".$fetch_record['unique_clicks']."' where
							ad_id='".$fetch_record['ad_id']."' and
							zone_id='".$fetch_record['zone_id']."' and
							date_time='".$fetch_record['date_time']."'";

							$rsUpdateResult = $this->oDbh->exec($update_unique_click);
					}


	}
	function _updaterequest($oStartDate, $oEndDate)
	{
		$aConf = $GLOBALS['_MAX']['CONF'];
		
		
		
		$query="SELECT count(r.request_id) as request,r.date_time as date_time,r.viewer_id as viewer_id,r.zone_id as zone_id ,v.device_type as device_type
		FROM 
		".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_ad_requests'],true)." AS r,
		".$this->oDbh->quoteIdentifier($aConf['table']['djax_track_viewers'],true)." AS v
		where r.date_time >=".$this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp'). " AND 
		      r.date_time <=". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') . " AND
		      r.viewer_id=v.viewer_id
		group by date_time,zone_id,device_type";
		
		

		$rsResult = $this->oDbh->query($query);

		while($aRow = $rsResult->fetchRow())
		{

			$query_update="update " . $this->oDbh->quoteIdentifier($aConf['table']['prefix'] . 'data_summary_ad_hourly', true) . " set requests=".$aRow['request']." where zone_id='".$aRow['zone_id']."' and date_time='".$aRow['date_time']."' and dj_delivery_media_type='".$aRow['device_type']."'";
			
			 $rsUpdateResult = $this->oDbh->exec($query_update);
		}

	}

    /**
     * A method to set basic financial information in a summary table,
     * on the basis of campaign and zone financial information.
     *
     * @access private
     * @param PEAR::Date $oStartDate The start date of records that need updating.
     * @param PEAR::Date $oEndDate   The end date of records that need updating.
     * @param string $table          The name of the summary table to update with financial
     *                               information (e.g. 'data_summary_ad_hourly').
     */
    function _saveSummaryUpdateWithFinanceInfo($oStartDate, $oEndDate, $table)
    {
        OA::debug('- Selecting unique ad IDs during this OI', PEAR_LOG_DEBUG);
        $aConf = $GLOBALS['_MAX']['CONF'];
        if ($oStartDate->format('%Y-%m-%d') != $oEndDate->format('%Y-%m-%d')) {
            MAX::raiseError('_saveSummaryUpdateWithFinanceInfo called with dates not on the same day.', null, PEAR_ERROR_DIE);
        }

        $indexHint = '';
        if(($aConf['database']['type'] == 'mysql' || $aConf['database']['type'] == 'mysqli')
            && $table == 'data_summary_ad_hourly') {
            $indexHint = ' FORCE INDEX('.$aConf['table']['prefix'].'data_summary_ad_hourly_date_time) ';
        }
        // Obtain a list of unique ad IDs from the summary table
        $query = "
            SELECT DISTINCT
                ad_id AS ad_id
            FROM
                ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table'][$table],true)."
                $indexHint
            WHERE
                date_time >= ". $this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."
                AND date_time <= ". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp');
        $rsResult = $this->oDbh->query($query);
        if (PEAR::isError($rsResult)) {
            return MAX::raiseError($rsResult, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
        }
        $aAdIds = array();
        while ($aRow = $rsResult->fetchRow()) {
            $aAdIds[] = $aRow['ad_id'];
        }
        // Get the finance information for the ads found
        $aAdFinanceInfo = $this->_saveSummaryGetAdFinanceInfo($aAdIds);
        // Update the recently summarised data with basic financial information
        if ($aAdFinanceInfo !== false) {
            $this->_saveSummaryUpdateAdsWithFinanceInfo($aAdFinanceInfo, $oStartDate, $oEndDate, $table);
        }
    }

    /**
     * A method to obtain the finance information for a given set of ad IDs.
     *
     * @access private
     * @param array $aAdIds An array of ad IDs for which the finance information is needed.
     * @return mixed An array of arrays, each containing the ad_id, campaign_id, advertiser_id,
     *               revenue and revenue_type of those ads required, where the financial
     *               information exists. Advertiser and campaign ID are needed for monthly
     *               tenancy only, otherwise it would be impossible to split the revenue correctly.
     *               False is returned if none of the ads requested have finance information set.
     */
    function _saveSummaryGetAdFinanceInfo($aAdIds)
    {
        OA::debug('- Select ad finance information for '.count($aAdIds).' ads', PEAR_LOG_DEBUG);
        $aConf = $GLOBALS['_MAX']['CONF'];
        if (empty($aAdIds)) {
            return false;
        }
        $query = "
            SELECT
                a.bannerid AS ad_id,
                a.campaignid AS campaign_id,
                c.clientid AS advertiser_id,
                c.revenue AS revenue,
                c.revenue_type AS revenue_type
            FROM
                ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['campaigns'],true)." AS c,
                ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['banners'],true)." AS a
            WHERE
                a.bannerid IN (" . $this->oDbh->escape(implode(', ', $aAdIds)) . ")
                AND a.campaignid = c.campaignid
                AND c.revenue IS NOT NULL
                AND c.revenue_type IS NOT NULL";
        $rsResult = $this->oDbh->query($query);
        if (PEAR::isError($rsResult)) {
            MAX::raiseError($rsResult, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
            return false;
        }
        $aResult = array();
        while ($aRow = $rsResult->fetchRow()) {
            $aResult[] = $aRow;
        }
        if (!empty($aResult)) {
            return $aResult;
        }
        return false;
    }

    /**
     * A method to set the basic financial information in a summary table,
     * on the basis of given ad financial information.
     *
     * @access private
     * @param array $aAdFinanceInfo  An array of arrays, each with the ad_id, revenue and
     *                               revenue_type information for the ads that need updating.
     * @param PEAR::Date $oStartDate The start date of records that need updating.
     * @param PEAR::Date $oEndDate   The end date of records that need updating.
     * @param string $table          The name of the summary table to update with financial
     *                               information (e.g. 'data_summary_ad_hourly').
     *
     * Note: The method looks for a special variable in the service locator, called
     *       "aAdFinanceMappings". If found, and an array, the contents of the array
     *       are used to determine the column name that should be used when calculating
     *       the finance information in the SQL statement, for the appropriate revenue
     *       type. If not found, the default mapping is used:
     *       array(
     *           MAX_FINANCE_CPM => impressions,
     *           MAX_FINANCE_CPC => clicks,
     *           MAX_FINANCE_CPA => conversions
     *       )
     *
     * Note: The method looks for a special variable in the service locator, called
     *       "aAdFinanceLimitTypes". If found, and an array, the contents of the array
     *       are tested to see if the revenue type set for the ad ID to be updated is
     *       in the array. If it is not, then the finance information is not set for
     *       the ad.
     *
     * @TODO Update to deal with monthly tenancy.
     */
    function _saveSummaryUpdateAdsWithFinanceInfo($aAdFinanceInfo, $oStartDate, $oEndDate, $table)
    {
        OA::debug('- Starting update finance information for ads', PEAR_LOG_DEBUG);

        $aConf = $GLOBALS['_MAX']['CONF'];
        if ($oStartDate->format('%H') != 0 || $oEndDate->format('%H') != 23) {
            if ($oStartDate->format('%Y-%m-%d') != $oEndDate->format('%Y-%m-%d')) {
                MAX::raiseError('_saveSummaryUpdateAdsWithFinanceInfo called with dates not on the same day.', null, PEAR_ERROR_DIE);
            }
        }
        $oServiceLocator =& OA_ServiceLocator::instance();
        // Prepare the revenue type to column name mapping array
        $aAdFinanceMappings =& $oServiceLocator->get('aAdFinanceMappings');
        if (($aAdFinanceMappings === false) || (!array($aAdFinanceMappings)) || (empty($aAdFinanceMappings))) {
            $aAdFinanceMappings = array(
                MAX_FINANCE_CPM => 'impressions',
                MAX_FINANCE_CPC => 'clicks',
                MAX_FINANCE_CPA => 'conversions'
            );
        }
        $countQueries = 0;
        // Try to get the $aAdFinanceLimitTypes array
        $aAdFinanceLimitTypes =& $oServiceLocator->get('aAdFinanceLimitTypes');
        foreach ($aAdFinanceInfo as $aInfo) {
            $query = '';
            $setInfo = true;
            // Test to see if the finance information should NOT be set for this ad
            if ($aAdFinanceLimitTypes !== false) {
                if (is_array($aAdFinanceLimitTypes) && (!empty($aAdFinanceLimitTypes))) {
                    // Try to find the ad's revenue type in the array
                    if (!in_array($aInfo['revenue_type'], $aAdFinanceLimitTypes)) {
                        // It's not in the array, don't set the finance info
                        $setInfo = false;
                    }
                }
            }
            // Prepare the SQL query to set the revenue information, if required
            if ($setInfo) {
                switch ($aInfo['revenue_type']) {
                    case MAX_FINANCE_CPM:
                        $query = "
                            UPDATE
                                ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table'][$table],true)."
                            SET
                                total_revenue = {$aAdFinanceMappings[MAX_FINANCE_CPM]} * {$aInfo['revenue']} / 1000,
                                updated = '". OA::getNow() ."'
                            WHERE
                                ad_id = {$aInfo['ad_id']}
                                AND date_time >= ". $this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."
                                AND date_time <= ". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp');
                        break;
                    case MAX_FINANCE_CPC:
                        $query = "
                            UPDATE
                                ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table'][$table],true)."
                            SET
                                total_revenue = {$aAdFinanceMappings[MAX_FINANCE_CPC]} * {$aInfo['revenue']},
                                updated = '". OA::getNow() ."'
                            WHERE
                                ad_id = {$aInfo['ad_id']}
                                AND date_time >= ". $this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."
                                AND date_time <= ". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp');
                        break;
                    case MAX_FINANCE_CPA:
                        $query = "
                            UPDATE
                                ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table'][$table],true)."
                            SET
                                total_revenue = {$aAdFinanceMappings[MAX_FINANCE_CPA]} * {$aInfo['revenue']},
                                updated = '". OA::getNow() ."'
                            WHERE
                                ad_id = {$aInfo['ad_id']}
                                AND date_time >= ". $this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."
                                AND date_time <= ". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp');
                        break;
                    case MAX_FINANCE_MT:
                        $query = "
                            UPDATE
                                ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table'][$table],true)."
                            SET
                                total_revenue = ".$this->getMtRevenue($aInfo, $oStartDate, $oEndDate, $table).",
                                updated = '". OA::getNow() ."'
                            WHERE
                                ad_id = {$aInfo['ad_id']}
                                AND date_time >= ". $this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."
                                AND date_time <= ". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp');
                        break;
                }
            }
            if (!empty($query)) {
                $rows = $this->oDbh->exec($query);
                if (PEAR::isError($rows)) {
                    return MAX::raiseError($rows, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
                }
                $countQueries++;
            }
        }
        OA::debug('- Updated finance information for '. $countQueries .' ads', PEAR_LOG_DEBUG);
    }

    /**
     * A method to get the hourly revenuo of a monthly tenancy campaign
     *
     * Monthly tenancy calculation sponsored by www.admost.nl
     *
     * @param array $aInfo The finance information, as returned by _saveSummaryGetAdFinanceInfo
     * @param Date $oStartDate
     * @param Date $oEndDate
     * @param string $table
     * @return double
     */
    function getMtRevenue($aInfo, $oStartDate, $oEndDate, $table)
    {
        OA::debug(sprintf("  - Calculating MT revenue for banner [id%d] between %s and %s:",
            $aInfo['ad_id'],
            $oStartDate->format('%Y-%m-%d %H:%M:%S %Z'),
            $oEndDate->format('%Y-%m-%d %H:%M:%S %Z')
        ), PEAR_LOG_DEBUG);
        $aConf = $GLOBALS['_MAX']['CONF'];

        $oMonthStart = new Date($oStartDate);

        // Set timezone
        if (!empty($aInfo['advertiser_id'])) {
            $doClient = OA_Dal::staticGetDO('clients', $aInfo['advertiser_id']);
            $aAdvertiserPrefs = OA_Preferences::loadAccountPreferences($doClient->account_id, true);
            if (!empty($aAdvertiserPrefs['timezone'])) {
                $oMonthStart->convertTZbyID($aAdvertiserPrefs['timezone']);
            }
        }

        // Get ad/zone combinations for the campaign
        if (!isset($this->aMtRevenueCache[$aInfo['campaign_id']])) {
            $query = "
                SELECT
                    COUNT(*) as cnt
                FROM
                    ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table'][$table],true)." d JOIN
                    ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['banners'],true)." a ON (a.bannerid = d.ad_id)
                WHERE
                    a.campaignid = {$aInfo['campaign_id']}
                    AND d.date_time >= ". $this->oDbh->quote($oStartDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp') ."
                    AND d.date_time <= ". $this->oDbh->quote($oEndDate->format('%Y-%m-%d %H:%M:%S'), 'timestamp');

            $this->aMtRevenueCache[$aInfo['campaign_id']] = $this->oDbh->query($query)->fetchOne();
        }

        $oMonthStart->setDay(1);
        $oMonthStart->setHour(0);
        $oMonthStart->setMinute(0);
        $oMonthStart->setSecond(0);

        OA::debug(sprintf("    - Month start: %s",
            $oMonthStart->format('%Y-%m-%d %H:%M:%S %Z')
        ), PEAR_LOG_DEBUG);

        $daysInMonth = $oMonthStart->getDaysInMonth();

        OA::debug(sprintf("    - Days in month: %d",
            $daysInMonth
        ), PEAR_LOG_DEBUG);

        $oMonthEnd = new Date($oMonthStart);
        $oMonthEnd->setDay($daysInMonth);
        $oMonthEnd = $oMonthEnd->getNextDay();
        $oMonthEnd->setTZ($oMonthStart->tz);

        OA::debug(sprintf("    - Month end: %s",
            $oMonthEnd->format('%Y-%m-%d %H:%M:%S %Z')
        ), PEAR_LOG_DEBUG);

        $oDiff = new Date_Span();
        $oDiff->setFromDateDiff($oMonthEnd, $oMonthStart);
        $hoursPerMonth = ceil($oDiff->toHours());

        OA::debug(sprintf("    - Hours per month: %d",
            $hoursPerMonth
        ), PEAR_LOG_DEBUG);

        $oDiff = new Date_Span();
        $oDiff->setFromDateDiff($oEndDate, $oStartDate);
        $hoursPerInterval = ceil($oDiff->toHours());

        OA::debug(sprintf("    - Hours per interval: %d",
            $hoursPerInterval
        ), PEAR_LOG_DEBUG);

        $adZoneCombinations = $this->aMtRevenueCache[$aInfo['campaign_id']];

        OA::debug(sprintf("    - Ad/zone/OI combinations for campaign [id%d]: %d",
            $aInfo['campaign_id'],
            $this->aMtRevenueCache[$aInfo['campaign_id']]
        ), PEAR_LOG_DEBUG);

        $result = $aInfo['revenue'] / $hoursPerMonth * $hoursPerInterval / $adZoneCombinations;

        OA::debug(sprintf("    - Result: %0.4f",
            $result
        ), PEAR_LOG_DEBUG);

        return $result;
    }

    /**
     * A method to activate/deactivate campaigns, based on the date and/or the inventory
     * requirements (impressions, clicks and/or conversions). Also sends email reports
     * for any campaigns that are activated/deactivated, as well as sending email reports
     * for any campaigns that are likely to expire in the near future.
     *
     * @param Date $oDate The current date/time.
     * @return string Report on the campaigns activated/deactivated.
     */
    function manageCampaigns($oDate)
    {
        $aConf = $GLOBALS['_MAX']['CONF'];
        $oServiceLocator = &OA_ServiceLocator::instance();
        $oEmail = &$oServiceLocator->get('OA_Email');
        if ($oEmail === false) {
            $oEmail = new OA_Email();
            $oServiceLocator->register('OA_Email', $oEmail);
        }
        $report = "\n";
        // Select all campaigns in the system, where:
        //    The campaign is ACTIVE and:
        //    - The end date stored for the campaign is not null; or
        //    - The campaign has a lifetime impression, click or conversion
        //      target set.
        //
        //    That is:
        //    - It is possible for the active campaign to be automatically
        //      stopped, as it has a valid end date. (No limitations are
        //      applied to those campaigns tested, as the ME may not have
        //      run for a while, and if so, even campaigns with an end date
        //      of many, many weeks ago should be tested to ensure they are
        //      [belatedly] halted.)
        //    - It is possible for the active campaign to be automatically
        //      stopped, as it has at leaast one lifetime target that could
        //      have been reached.
        //
        //    The campaign is INACTIVE and:
        //    - The start date stored for the campaign is not null; and
        //    - The weight is greater than zero; and
        //    - The end date stored for the campaign is either null, or is
        //      greater than "today" less one day.
        //
        //    That is:
        //    - It is possible for the inactive campaign to be automatically
        //      started, as it has a valid start date. (No limitations are
        //      applied to those campaigns tested, as the ME may not have run
        //      for a while, and if so, even campaigns with an activation date
        //      of many, many weeks ago should be tested to ensure they are
        //      [belatedy] enabled.)
        //    - The campaign is not in a permanently inactive state, as a
        //      result of the weight being less then one, which means that
        //      it cannot be activated.
        //    - The test to start the campaign is unlikely to fail on account
        //      of the end date.
        $prefix = $this->getTablePrefix();
        $oNowDate = new Date($oDate);
        $oNowDate->toUTC();

        $query = "
            SELECT
                cl.clientid AS advertiser_id,
                cl.account_id AS advertiser_account_id,
                cl.agencyid AS agency_id,
                cl.contact AS contact,
                cl.email AS email,
                cl.reportdeactivate AS send_activate_deactivate_email,
                ca.campaignid AS campaign_id,
                ca.campaignname AS campaign_name,
                ca.views AS targetimpressions,
                ca.clicks AS targetclicks,
                ca.conversions AS targetconversions,
                ca.status AS status,
                ca.activate_time AS start,
                ca.expire_time AS end
            FROM
                {$prefix}campaigns AS ca,
                {$prefix}clients AS cl
            WHERE
                ca.clientid = cl.clientid
                AND
                ((
                    ca.status = ".$this->oDbh->quote(OA_ENTITY_STATUS_RUNNING, 'integer')." AND
                    (
                        ca.expire_time IS NOT NULL
                        OR
                        (
                            ca.views > 0
                            OR
                            ca.clicks > 0
                            OR
                            ca.conversions > 0
                        )
                    )
                ) OR (
                    ca.status = ".$this->oDbh->quote(OA_ENTITY_STATUS_AWAITING, 'integer')." AND
                    (
                        ca.activate_time <= " . $this->oDbh->quote($oNowDate->getDate(DATE_FORMAT_ISO), 'timestamp') . "
                        AND
                        (
                            ca.weight > 0
                            OR
                            ca.priority > 0
                        )
                        AND
                        (
                            ca.expire_time >= " . $this->oDbh->quote($oNowDate->getDate(DATE_FORMAT_ISO), 'timestamp') . "
                            OR
                            ca.expire_time IS NULL
                        )
                    )
                ))
            ORDER BY
                advertiser_id";
        OA::debug('- Requesting campaigns to test for activation/deactivation', PEAR_LOG_DEBUG);
        $rsResult = $this->oDbh->query($query);
        if (PEAR::isError($rsResult)) {
            return MAX::raiseError($rsResult, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
        }
        OA::debug('- Found ' . $rsResult->numRows() . ' campaigns to test for activation/deactivation', PEAR_LOG_DEBUG);
        while ($aCampaign = $rsResult->fetchRow()) {
            if ($aCampaign['status'] == OA_ENTITY_STATUS_RUNNING) {
                // The campaign is currently running, look at the campaign
                $disableReason = 0;
                $canExpireSoon = false;
                if (($aCampaign['targetimpressions'] > 0) ||
                    ($aCampaign['targetclicks'] > 0) ||
                    ($aCampaign['targetconversions'] > 0)) {
                    OA::debug('  - Selecting impressions, clicks and conversions for this running campaign ID = '.$aCampaign['campaign_id'], PEAR_LOG_DEBUG);
                    // The campaign has an impression, click and/or conversion target,
                    // so get the sum total statistics for the campaign
                    $query = "
                        SELECT
                            SUM(dia.impressions) AS impressions,
                            SUM(dia.clicks) AS clicks,
                            SUM(dia.conversions) AS conversions
                        FROM
                            ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['data_intermediate_ad'],true)." AS dia,
                            ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['banners'],true)." AS b
                        WHERE
                            dia.ad_id = b.bannerid
                            AND b.campaignid = {$aCampaign['campaign_id']}";
                    $rsResultInner = $this->oDbh->query($query);
                    $valuesRow = $rsResultInner->fetchRow();
                    if ((isset($valuesRow['impressions'])) || (!is_null($valuesRow['clicks'])) || (!is_null($valuesRow['conversions']))) {
                        // There were impressions, clicks and/or conversions for this
                        // campaign, so find out if campaign targets have been passed
                        if (!isset($valuesRow['impressions'])) {
                            // No impressions
                            $valuesRow['impressions'] = 0;
                        }
                        if (!isset($valuesRow['clicks'])) {
                            // No clicks
                            $valuesRow['clicks'] = 0;
                        }
                        if (!isset($valuesRow['conversions'])) {
                            // No conversions
                            $valuesRow['conversions'] = 0;
                        }
                        if ($aCampaign['targetimpressions'] > 0) {
                            if ($aCampaign['targetimpressions'] <= $valuesRow['impressions']) {
                                // The campaign has an impressions target, and this has been
                                // passed, so update and disable the campaign
                                $disableReason |= OX_CAMPAIGN_DISABLED_IMPRESSIONS;
                            }
                        }
                        if ($aCampaign['targetclicks'] > 0) {
                            if ($aCampaign['targetclicks'] <= $valuesRow['clicks']) {
                                // The campaign has a click target, and this has been
                                // passed, so update and disable the campaign
                                $disableReason |= OX_CAMPAIGN_DISABLED_CLICKS;
                            }
                        }
                        if ($aCampaign['targetconversions'] > 0) {
                            if ($aCampaign['targetconversions'] <= $valuesRow['conversions']) {
                                // The campaign has a target limitation, and this has been
                                // passed, so update and disable the campaign
                                $disableReason |= OX_CAMPAIGN_DISABLED_CONVERSIONS;
                            }
                        }
                        if ($disableReason) {
                            // One of the campaign targets was exceeded, so disable
                            $message = '  - Exceeded a campaign quota: Deactivating campaign ID ' .
                                       "{$aCampaign['campaign_id']}: {$aCampaign['campaign_name']}";
                            OA::debug($message, PEAR_LOG_INFO);
                            $report .= $message . "\n";
                            $doCampaigns = OA_Dal::factoryDO('campaigns');
                            $doCampaigns->campaignid = $aCampaign['campaign_id'];
                            $doCampaigns->find();
                            $doCampaigns->fetch();
                            $doCampaigns->status = OA_ENTITY_STATUS_EXPIRED;
                            $result = $doCampaigns->update();
                            if ($result == false) {
                                return MAX::raiseError($rows, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
                            }
                            phpAds_userlogSetUser(phpAds_userMaintenance);
                            phpAds_userlogAdd(phpAds_actionDeactiveCampaign, $aCampaign['campaign_id']);
                        } else {
                            // The campaign didn't have a diable reason,
                            // it *might* possibly be diabled "soon"...
                            $canExpireSoon = true;
                        }
                    }
                }
                // Does the campaign need to be disabled due to the date?
                if (!empty($aCampaign['end'])) {
                    // The campaign has a valid end date, stored in in UTC
                    $oEndDate = new Date($aCampaign['end']);
                    $oEndDate->setTZByID('UTC');
                    if ($oDate->after($oEndDate)) {
                        // The end date has been passed; disable the campaign
                        $disableReason |= OX_CAMPAIGN_DISABLED_DATE;
                        $message = "  - Passed campaign end time of '" . $oEndDate->getDate() . " UTC" .
                                   "': Deactivating campaign ID {$aCampaign['campaign_id']}: {$aCampaign['campaign_name']}";
                        OA::debug($message, PEAR_LOG_INFO);
                        $report .= $message . "\n";
                        $doCampaigns = OA_Dal::factoryDO('campaigns');
                        $doCampaigns->campaignid = $aCampaign['campaign_id'];
                        $doCampaigns->find();
                        $doCampaigns->fetch();
                        $doCampaigns->status = OA_ENTITY_STATUS_EXPIRED;
                        $result = $doCampaigns->update();
                        if ($result == false) {
                            return MAX::raiseError($rows, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
                        }
                        phpAds_userlogSetUser(phpAds_userMaintenance);
                        phpAds_userlogAdd(phpAds_actionDeactiveCampaign, $aCampaign['campaign_id']);
                    } else {
                        // The campaign wasn't disabled based on the end
                        // date, to it *might* possibly be disabled "soon"...
                        $canExpireSoon = true;
                    }
                }
                if ($disableReason) {
                    // The campaign was disabled, so send the appropriate
                    // message to the campaign's contact
                    $query = "
                        SELECT
                            bannerid AS advertisement_id,
                            description AS description,
                            alt AS alt,
                            url AS url
                        FROM
                            ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['banners'],true)."
                        WHERE
                            campaignid = {$aCampaign['campaign_id']}";
                    OA::debug("  - Getting the advertisements for campaign ID {$aCampaign['campaign_id']}", PEAR_LOG_DEBUG);
                    $rsResultAdvertisement = $this->oDbh->query($query);
                    if (PEAR::isError($rsResultAdvertisement)) {
                        return MAX::raiseError($rsResultAdvertisement, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
                    }
                    while ($advertisementRow = $rsResultAdvertisement->fetchRow()) {
                        $advertisements[$advertisementRow['advertisement_id']] = array(
                            $advertisementRow['description'],
                            $advertisementRow['alt'],
                            $advertisementRow['url']
                        );
                    }
                    if ($aCampaign['send_activate_deactivate_email'] == 't') {
                        OA::debug("  - Sending campaign deactivated email ", PEAR_LOG_DEBUG);
                        $oEmail->sendCampaignActivatedDeactivatedEmail($aCampaign['campaign_id'], $disableReason);

                        // Also send campaignDeliveryEmail for the campaign we just deactivated.
                        $doClients = OA_Dal::staticGetDO('clients', $aCampaign['advertiser_id']);
                        $aAdvertiser = $doClients->toArray();
                        OA::debug("  - Sending campaign delivery email ", PEAR_LOG_DEBUG);
                        $oStart = new Date($aAdvertiser['reportlastdate']);
                        $oEnd = new Date($oDate);
                        // Set end date to tomorrow so we get stats for today.
                        $oEnd->addSpan(new Date_Span('1-0-0-0'));
                        $oEmail->sendCampaignDeliveryEmail($aAdvertiser, $oStart, $oEnd, $aCampaign['campaign_id']);
                    }
                } else if ($canExpireSoon) {
                    // The campaign has NOT been deactivated - test to see if it will
                    // be deactivated "soon", and send email(s) warning of this as required
                    OA::debug("  - Sending campaign 'soon deactivated' email ", PEAR_LOG_DEBUG);
                    $oEmail->sendCampaignImpendingExpiryEmail($oDate, $aCampaign['campaign_id']);
                }
            } elseif (!empty($aCampaign['start'])) {
                // The campaign is awaiting activation and has a valid start date, stored in UTC
                $oStartDate = new Date($aCampaign['start']);
                $oStartDate->setTZByID('UTC');
                // Find out if there are any impression, click or conversion targets for
                // the campaign (i.e. if the target values are > 0)
                $remainingImpressions = 0;
                $remainingClicks      = 0;
                $remainingConversions = 0;
                if (($aCampaign['targetimpressions'] > 0) ||
                    ($aCampaign['targetclicks'] > 0) ||
                    ($aCampaign['targetconversions'] > 0)) {
                    OA::debug("  - The campaign ID ".$aCampaign['campaign_id']." has an impression, click and/or conversion target, requesting impressions so far", PEAR_LOG_DEBUG);
                    $query = "
                        SELECT
                            SUM(dia.impressions) AS impressions,
                            SUM(dia.clicks) AS clicks,
                            SUM(dia.conversions) AS conversions
                        FROM
                            ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['data_intermediate_ad'],true)." AS dia,
                            ".$this->oDbh->quoteIdentifier($aConf['table']['prefix'].$aConf['table']['banners'],true)." AS b
                        WHERE
                            dia.ad_id = b.bannerid
                            AND b.campaignid = {$aCampaign['campaign_id']}";
                    $rsResultInner = $this->oDbh->query($query);
                    $valuesRow = $rsResultInner->fetchRow();
                    // Set the remaining impressions, clicks and conversions for the campaign
                    $remainingImpressions = $aCampaign['targetimpressions'] - $valuesRow['impressions'];
                    $remainingClicks      = $aCampaign['targetclicks']      - $valuesRow['clicks'];
                    $remainingConversions = $aCampaign['targetconversions'] - $valuesRow['conversions'];
                }
                // In order for the campaign to be activated, need to test:
                // 1) That there is no impression target (<= 0), or, if there is an impression target (> 0),
                //    then there must be remaining impressions to deliver (> 0); and
                // 2) That there is no click target (<= 0), or, if there is a click target (> 0),
                //    then there must be remaining clicks to deliver (> 0); and
                // 3) That there is no conversion target (<= 0), or, if there is a conversion target (> 0),
                //    then there must be remaining conversions to deliver (> 0)
                if ((($aCampaign['targetimpressions'] <= 0) || (($aCampaign['targetimpressions'] > 0) && ($remainingImpressions > 0))) &&
                    (($aCampaign['targetclicks']      <= 0) || (($aCampaign['targetclicks']      > 0) && ($remainingClicks      > 0))) &&
                    (($aCampaign['targetconversions'] <= 0) || (($aCampaign['targetconversions'] > 0) && ($remainingConversions > 0)))) {
                    $message = "- Passed campaign start time of '" . $oStartDate->getDate() . " UTC" .
                               "': Activating campaign ID {$aCampaign['campaign_id']}: {$aCampaign['campaign_name']}";
                    OA::debug($message, PEAR_LOG_INFO);
                    $report .= $message . "\n";
                    $doCampaigns = OA_Dal::factoryDO('campaigns');
                    $doCampaigns->campaignid = $aCampaign['campaign_id'];
                    $doCampaigns->find();
                    $doCampaigns->fetch();
                    $doCampaigns->status = OA_ENTITY_STATUS_RUNNING;
                    $result = $doCampaigns->update();
                    if ($result == false) {
                        return MAX::raiseError($rows, MAX_ERROR_DBFAILURE, PEAR_ERROR_DIE);
                    }
                    phpAds_userlogSetUser(phpAds_userMaintenance);
                    phpAds_userlogAdd(phpAds_actionActiveCampaign, $aCampaign['campaign_id']);
                    if ($aCampaign['send_activate_deactivate_email'] == 't') {
                        OA::debug("  - Sending activation email for campaign ID ". $aCampaign['campaign_id'], PEAR_LOG_DEBUG);
                        $oEmail->sendCampaignActivatedDeactivatedEmail($aCampaign['campaign_id']);
                    }
                }
            }
        }
    }
}

?>
