/**
 * Advanced companion & overlay processing scripts - supports insertion of javascript based
 * companion ad types.
 *
 * These methods rely on the prior inclusion of JQuery into the page.
 *
 */

var ova = new function() {
  // Lower level content insertion and div manipulation functions

  var previousNonLinearContent = new Array();

  this.debug = function(content) {
     try {
     	if(true) {
 	        console.log(content);
 	    }
     }
     catch(error) {
     }
  }

  this.readHTML = function(elementID) {
    return jQuery('#' + elementID).html();
  }

  this.writeHTML = function(elementID, src) {
    jQuery('#' + elementID).html(src);
  }

  this.writeElement = function(elementID, src) {
    jQuery('#' + elementID).writeElement(src);
  }

  this.showElement = function(elementID) {
  	jQuery('#' + elementID).css("visibility", "visible");
  }

  this.hideElement = function(elementID) {
  	jQuery('#' + elementID).css("visibility", "hidden");
  }

  // High level API to support showing/hiding of non-linear ads

  /**
   *  Display a non-linear ad
   */
  this.displayNonLinearAd = function(ad) {
      console.log(ad);
      if(ad != null) {
          if(ad.region != null) {
          		if(ad.contentType != null) {
			          var elementID = this.verifyRegionID(ad.region.region[ad.contentType.toLowerCase()]);
			          if(elementID != null) {
				          previousNonLinearContent[elementID] = this.readHTML(elementID);
					      if(ad.contentType == 'IMAGE' || ad.contentType == 'TEXT' || ad.contentType == 'HTML') {
					          debug("Displaying a non-linear ad of type " + ad.contentType + " in a DIV region with ID '" + elementID + "'");
					          if(ad.clickThroughURL != null) {
                                  this.writeHTML(elementID, "<a href='" + ad.clickThroughURL + "' target='_blank'>" + ad.formedContent + "</a>");
					          }
					          else this.writeHTML(elementID, ad.formedContent);
							  if(ad.region.overlay) this.showElement(elementID);
					      }
					      else if(ad.contentType == 'SWF' || ad.contentType == 'IFRAME' || ad.contentType == 'SCRIPT') {
					          debug("Displaying a non-linear ad of type " + ad.contentType + " in a DIV region with ID '" + elementID + "'");
					          this.writeElement(elementID, ad.formedContent);
							  if(ad.region.overlay) this.showElement(elementID);
					      }
					      else if(ad.contentType == 'VPAID') {
					          debug("Cannot play non-linear VPAID ads via HTML5 - ignoring");
					      }
					      else debug("Display non-linear ad - unknown content type '" + ad.contentType + "'");
			          }
			          else debug("Cannot display the non-linear ad via HTML5 - the region (DIV) ID is null");
          		}
          }
          else debug("Cannot display non-linear ad via HTML5 - no region provided with the ad object");
      }
      else debug("Cannot display non-linear ad via HTML5 - no ad object provided");
  }

  /**
   *  Hire a non-linear ad
   */
  this.hideNonLinearAd = function(ad) {
      if(ad != null) {
          if(ad.region != null) {
          	  if(ad.contentType != null) {
		          var elementID = this.verifyRegionID(ad.region.region[ad.contentType.toLowerCase()]);
		          if(elementID != null) {
					  if(ad.region.overlay) {
					  	  debug("Non-linear ad is an overlay - setting region '" + elementID + "' visibility to false");
					  	  this.hideElement(elementID);
					  }
					  else {
					  	  debug("Non-linear ad is a non-overlay - restoring the original contents of region '" + elementID + "'");
					  	  if(previousNonLinearContent[elementID] != null) {
					  	      this.writeHTML(elementID, previousNonLinearContent[elementID]);
					  	      previousNonLinearContent[elementID] = null;
					  	  }
					  }
				  }
				  else debug("Cannot hide the non-linear ad - no element ID found to identify the region");
			  }
			  else debug("Cannot hide the non-linear ad - no content type specified to identify the region");
		  }
		  else debug("Cannot hide the non-linear ad - no region declared for the ad");
	  }
  }

  // Utility methods

  /**
   * Checks that the region name is not an "auto:" based ID - if so, strip out the "auto:" - the "auto" sizing
   * option is currently unsupported in HTML5 mode
   */
  this.verifyRegionID = function(regionID) {
  	if(regionID != null) {
  	   if(regionID.indexOf("auto:") > -1) {
			return regionID.replace("auto:", "");
  	   }
  	   return regionID;
  	}
  	return "bottom";
  }
}

// These jQuery functions are trigged from ova class
jQuery.fn.writeElement = function(src) {
  // Store jQuery(this) in a variable otherwise it will be out of scope in document.write
  var element = jQuery(this);
  var tmpDocWrite = document.write;
  var tmpDocWriteln = document.writeln;
  document.write = function(arg){ jQuery(element).append(arg); };
  document.writeln = function(arg){ jQuery(element).append(arg) + '\n'; };

  // Function to retrieve a new advert from the server.
  jQuery(element).html(jQuery(src));
};
