package djext

import (
	"djconstants"
	"djextrafunc"
	"djgetad"
	"djlogger"
	"encoding/json"
	"io/ioutil"
	"reflect"
	"strconv"
	"strings"
)

type Ext struct {
	SSP     string   `json : "ssp"`          //Supplier identification string
	At      string   `json: "at, omitempty"` //Passes additional auction types used by some Suppliers.
	Ads_txt *Ads_txt `json: "ads_txt,omitempty"`
	Google  *Google  `json: "google,omitempty"`
	WT      float64  `json: "wt,omitempty"`
}

type Ads_txt struct {
	Status  int    `json: "status"`            // 1 = direct, 2 = reseller, 3 = unauthorized
	Auth_id string `json: "auth_id,omitempty"` // Passes the TAG ID
	Pub_id  string `json: "pub_id"`            //unmodified publisher ID at that Supplier e.g., "123456789".
}

type Google struct {
	Detected_vertical []*Detected_vertical `json: "detected_vertical,omitempty"`
}

type Detected_vertical struct {
	Id     int     `json: "id,omitempty"`     //vertical ID as defined by AdX docs, for example, 1014
	Weight float64 `json: "weight,omitempty"` //Weight for this vertical, in the (0.0, 1.0) range.
}

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var reqext *Ext

func ReadAds_txtfile(adstxtfile string, reqStatus string, reqAuthid string, reqPubid string) bool {
	dat, err := ioutil.ReadFile(djconstants.AdsTxt_Path + "/" + adstxtfile)
	if err != nil {
		dat, _ = ioutil.ReadFile(djconstants.ReviveRoot + "/" + adstxtfile)
	}
	lines1 := strings.Split(string(dat), "\n")
	for _, lines := range lines1 {
		if lines[:0] == "#" {
			break
		}
		values := strings.Split(string(lines), ",")
		for i, v := range values {
			if i == 1 && v != reqPubid {
				break
			} else if i == 2 && v != reqStatus {
				break
			} else if i == 3 && v != reqAuthid {
				break
			}
		}
	}
	return true
}

/* func GetPublisherVerticalfile() []string {
	verticals, _ := ioutil.ReadFile(djconstants.Verticals_Path)
	vertical_id := strings.Split(string(verticals), " /")
	var dv_id []string
	for i, data := range vertical_id {
		dv_id[i] = data
	}
	return dv_id
} */

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

func CheckReqExtCriteria(extChannel chan []djgetad.GetAd, req json.RawMessage, ads []djgetad.GetAd) {
	json.Unmarshal(req, &reqext)
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			extChannel <- filterads
		}
	}()
	for _, ad := range ads {
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
			}
		} else {
			filterads = append(filterads, ad)
		}
	}
	extChannel <- filterads

}

func (c Commander) MAX_checkClient_SSP(cmd Command) bool {
	var argSSP []string
	var reqSSP string
	if reqext != nil {
		reqSSP = reqext.SSP
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argSSP = append(argSSP, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqSSP != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqSSP, argSSP)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqSSP, argSSP)
		} else {
			return false
		}
	}
	return false
}

func (c Commander) MAX_checkClient_Adstxt(cmd Command) bool {
	var (
		argAdsTxt, reqStatus string
		reqAuthid, reqPubid  string
	)
	if reqext != nil {
		reqStatus = strconv.Itoa(reqext.Ads_txt.Status)
		reqAuthid = reqext.Ads_txt.Auth_id
		reqPubid = reqext.Ads_txt.Pub_id
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	argAdsTxt = strings.Replace(cmd.Args[0], "'", "", -1)
	if argAdsTxt != "" {
		if op == "==" {
			if reqStatus != "" && reqAuthid != "" && reqPubid != "" {
				return ReadAds_txtfile(argAdsTxt, reqStatus, reqAuthid, reqPubid)
			} else if reqStatus != "" && reqAuthid == "" && reqPubid != "" {
				return ReadAds_txtfile(argAdsTxt, reqStatus, reqAuthid, reqPubid)
			} else {
				return false
			}
		} else if op == "!=" {
			if reqStatus != "" && reqAuthid != "" && reqPubid != "" {
				return ReadAds_txtfile(argAdsTxt, reqStatus, reqAuthid, reqPubid)
			} else if reqStatus != "" && reqAuthid == "" && reqPubid != "" {
				return ReadAds_txtfile(argAdsTxt, reqStatus, reqAuthid, reqPubid)
			} else {
				return false
			}
		} else {
			return false
		}
	}
	return false
}
