package djbannerad

import (
	"djgetad"
	"djgetad_models"
	"djlogger"
	"djmime"
	"djredis"
	"fmt"
	openrtb "openrtb/openrtb2.5"
	openrtb3 "openrtb/openrtb3"
	"strconv"
)

// Function to get banner ad
func GetBannerads(banChannel chan []djgetad.GetAd, mimes []string, displayfmt []*openrtb3.Displayfmt, req_details map[string]interface{}, pmp int8, deals []openrtb3.Deal, redisClient *djredis.RedisClient) {
	var (
		whQuery string
	)
	whQuery += `(`
	for k, v := range displayfmt {
		if k == 0 {
			whQuery += `(d.width = ` + strconv.Itoa(v.W) + ` and d.height = ` + strconv.Itoa(v.H) + `)`
		} else {
			if k != len(displayfmt) {
				whQuery += ` or `
			}
			whQuery += `(d.width = ` + strconv.Itoa(v.W) + ` and d.height = ` + strconv.Itoa(v.H) + `)`
		}
	}
	whQuery += `)`
	storagetype := djmime.Mime_type(mimes)
	bannerads, err := djgetad_models.BannerSearch(whQuery, req_details["dsp_id"].(int), storagetype, pmp, deals, nil, redisClient)
	
	fmt.Println(bannerads) 
	fmt.Println("ddddddddddddddd")
	if err != nil {
		djlogger.Log.Println("Error : ", err)
	}
	banChannel <- bannerads
}

// Function to get banner ad
func GetBannerads25(banChannel chan []djgetad.GetAd, imp *openrtb.Banner, req_details map[string]interface{}, pmp int8, deals []openrtb.Deal, redisClient *djredis.RedisClient) {
	width := imp.W
	height := imp.H
	storagetype := djmime.Mime_type(imp.Mimes)
	bannerads, err := djgetad_models.BannerSearch25(width, height, req_details["dsp_id"].(int), storagetype, pmp, nil, deals, redisClient)
	if err != nil {
		djlogger.Log.Println("Error : ", err)
	}
	banChannel <- bannerads
}
