<?php

// Require the initialisation file


require_once '../../../../init.php';

require_once MAX_PATH . '/www/admin/config.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once MAX_PATH . '/lib/OA/Dal.php';

OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);



$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

$isSsl = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' : 'http://';
$plugin_path = $isSsl.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/plugins/DSP/';


$calendar = $plugin_path.'assets/images/calendar.png';

$break = $plugin_path.'assets/images/break.gif';



$oDbh = &OA_DB::singleton();

$oPluginManager = new OX_PluginManager();
$oComponentGroupManager = new OX_Plugin_ComponentGroupManager();

$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel("Reports");
$oHeaderModel->setIconClass('iconTargetingChannelsLarge');
$oHeaderModel->setpageType('list');

phpAds_PageHeader('AdvDspReport-index', $oHeaderModel);


//~ GET PARAMETERS

$pPass = $_GET;
$_bidder = !empty($pPass['bidder'])? $pPass['bidder'] : 0;
$_report = !empty($pPass['report'])? $pPass['report'] : 0;      
$_period = !empty($pPass['period_preset']) ? $pPass['period_preset'] : '';




//~ CHECK DATES

if($pPass['period_preset']!='')
{

  if($pPass['period_preset']=='today')
  {
    $start=date('Y-m-d');
    $end=date('Y-m-d');
  }
  else if($pPass['period_preset']=='yesterday')
  {
    $start=date('Y-m-d', strtotime('Yesterday'));
    $end=date('Y-m-d', strtotime('Yesterday'));

  }
  else if($pPass['period_preset']=='this_week')
  {
    $start=date('Y-m-d', strtotime('this week Monday'));
    $end=date('Y-m-d');
  }
  else if($pPass['period_preset']=='last_week')
  {
    $start=date('Y-m-d', strtotime('previous Monday'));
    $end=date('Y-m-d', strtotime('previous Sunday'));
  }
  else if($pPass['period_preset']=='last_7_days')
  {
    $start=date('Y-m-d', strtotime('Today - 7 Day'));
    $end=date('Y-m-d', strtotime('Today - 1 Day'));
  }
  else if($pPass['period_preset']=='this_month')
  {
    $start=date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
    $end=date('Y-m-d');
  }
  else if($pPass['period_preset']=='last_month')
  {
    $start=date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
    $end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
  }
  else if($pPass['period_preset']=='all_stats')
  {
    $start='0000-00-00';
    $end=date('Y-m-d'); $period_preset='all_stats';
  }
  else if($pPass['period_preset']=='specific')
  {
    $start=$pPass['period_start'];
    $end=$pPass['period_end'];
  }

}
else
{
  $start=date('Y-m-d');
  $end=date('Y-m-d');
}

$start_date=$start;
$end_date=$end;


/*Convert start date and end date into timezone format*/

if($period_preset=='all_stats')
{
  $start_date="0000-00-00 00:00:00";
  $end_day=new Date(date('Y-m-d H:i:00'));
  $end_day->setHour(23);
  $end_day->setMinute(59);
  $end_day->setSecond(59);
  $end_day->toUTC();
  $end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
}
else if($start_date=='' && $end_date=='')
{ 
  $start_day=new Date(date('Y-m-d H:i:00'));
  $start_day->setHour(0);
  $start_day->setMinute(0);
  $start_day->setSecond(0);
  $start_day->toUTC();
  $start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
  $end_day=new Date(date('Y-m-d H:i:00'));
  $end_day->setHour(23);
  $end_day->setMinute(59);
  $end_day->setSecond(59);
  $end_day->toUTC();
  $end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
  
}
else
{
  $end_day=new Date($end_date);
  $end_day->setHour(23);
  $end_day->setMinute(59);
  $end_day->setSecond(59);
  $end_day->toUTC();
  $end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
  $start_day=new Date($start_date);
  $start_day->setHour(0);
  $start_day->setMinute(0);
  $start_day->setSecond(0);
  $start_day->toUTC();
  $start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
}



//~ BIDDER LIST

$bidder_query = "SELECT * from {$table_prefix}dj_dsp";
$bidderList = $oDbh->query($bidder_query)->fetchAll();

//~REPORT LIST
    
$report_list = array(

                '1' => array('fet' => 'country_name', 'tb'=> 'country' , 'adv'=> 'country_name', 'name' => 'Country', 'value' => 1),

                '2' => array('fet' => 'domain', 'tb'=> 'dj_dsp_adv_report_domain' , 'adv'=> 'domain', 'name' => 'Domain', 'value' => 2),

                '3' => array('fet' => 'os', 'tb'=> 'dj_dsp_adv_report_os' , 'adv'=> 'os', 'name' => 'OS', 'value' => 3),

                '4' => array('fet' => 'ip', 'tb'=> 'dj_dsp_adv_report_ip' , 'adv'=> 'ip', 'name' => 'IP', 'value' => 4),

                '5' => array('fet' => 'language', 'tb'=> 'dj_dsp_adv_report_language' , 'adv'=> 'language', 'name' => 'Language', 'value' => 5),

                '6' => array('fet' => 'user_agent', 'tb'=> 'dj_dsp_adv_report_user_agent' , 'adv'=> 'user_agent', 'name' => 'User-Agent', 'value' => 6),

                '7' => array('fet' => 'age', 'tb'=> 'dj_dsp_adv_report_age' , 'adv'=> 'age', 'name' => 'User Age', 'value' => 7),


                '8' => array('fet' => 'gender', 'tb'=> 'dj_dsp_adv_report_gender' , 'adv'=> 'gender', 'name' => 'User Gender', 'value' => 8),

                '9' => array('fet' => 'device_make', 'tb'=> 'dj_dsp_adv_report_device_make' , 'adv'=> 'device_make', 'name' => 'Device Make', 'value' => 9),

               '10' => array('fet' => 'device_type', 'tb'=> 'dj_dsp_adv_report_device_type' , 'adv'=> 'device_type', 'name' => 'Device Type', 'value' => 10),


               '11' => array('fet' => 'device_model', 'tb'=> 'dj_dsp_adv_report_device_model' , 'adv'=> 'device_model', 'name' => 'Device Model', 'value' => 11),

               '12' => array('fet' => 'page_url', 'tb'=> 'dj_dsp_adv_report_page_url' , 'adv'=> 'page_url', 'name' => 'Site URL', 'value' => 12),

               '13' => array('fet' => 'site_category', 'tb'=> 'dj_dsp_adv_report_site_category' , 'adv'=> 'site_category', 'name' => 'Site Category', 'value' => 13)

              );

//~ GRAPH PARAMS

$graph_values = array('dsp_portal_name','request_count','response_count','win_notice_count','impression','click');

 
//~ VARIABLE DECLARATION

$tb_select = "";
$tb_where = "";

$tb_group = "";
$title = "";


$table_heading = [];
$table_data = [];
$rsReport = [];
$allReport = [];

$query = "";


/**************************** BIDDERS BASED REPORT STARTS *********************************/

if($_bidder!= 0 && $_report == 0)
{

    $tb_select = "SELECT  d.dsp_portal_name, r.os, sum(r.request_count) as request_count, sum(r.response_count) as response_count,sum(r.test_win_notice_count) as test_win_notice ,  sum(r.win_notice_count) as win_notice_count, sum(r.impression_count) as impression, sum(r.click_count) as click  , sum(r.total_amount) as total_amount,sum(r.admin_share) as admin_share  from {$table_prefix}dj_dsp_advanced_reports r  inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";

    $tb_where = " WHERE r.date_created  between '{$start_date}' AND '{$end_date}' AND r.bidderid=".$_bidder;   

    $tb_group = " group by r.bidderid";


    $query = $tb_select.$tb_where.$tb_group;
    //~ die($query);


    //~TABLE VALUES STARTS

    $rsReport = $oDbh->query($query)->fetchAll();

    $title = $rsReport[0]['dsp_portal_name']." Report";

    $table_heading = array('Bidder Name', 'Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share', 'Test Win Notice');

    $table_data = array(

                   0 => 'dsp_portal_name',
                   1 => 'request_count',
                   2 => 'response_count',
                   3 => 'win_notice_count',
                   4 => 'impression',
                   5 => 'click',
                   6 => 'admin_share',
                   7 => 'test_win_notice'

                 );

    //~TABLE VALUES ENDS

}


/**************************** BIDDERS BASED REPORT ENDS *********************************/


/**************************** REPORT BASED REPORT STARTS *********************************/

else if($_bidder == 0 && $_report != 0)
{
    $graph_values="";

    $tb_select = "SELECT  d.dsp_portal_name, r.{$report_list[$_report]['fet']}, sum(r.request_count) as request_count, sum(r.response_count) as response_count, sum(r.test_win_notice_count) as test_win_notice ,  sum(r.win_notice_count) as win_notice_count, sum(r.impression_count) as impression, sum(r.click_count) as click  , sum(r.total_amount) as total_amount,sum(r.admin_share) as admin_share  from {$table_prefix}dj_dsp_advanced_reports r  inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";

    $tb_where = " WHERE r.date_created  between '{$start_date}' AND '{$end_date}' ";   

    $tb_group = " group by r.{$report_list[$_report]['fet']} ";

    $query = $tb_select.$tb_where.$tb_group;
// die($query);

    //~TABLE VALUES STARTS

    $title = $report_list[$_report]['name'];

    $table_heading = array( $report_list[$_report]['adv'], 'Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share', 'Test Win Notice');


    $rsReport = $oDbh->query($query)->fetchAll();

    $table_data = array(

                   0 =>  $report_list[$_report]['fet'],
                   1 => 'request_count',
                   2 => 'response_count',
                   3 => 'win_notice_count',
                   4 => 'impression',
                   5 => 'click',
                   6 => 'admin_share',
                   7 => 'test_win_notice'

                 );

    //~TABLE VALUES ENDS

    $count_query = $tb_select.$tb_where.$tb_group;
    
    $allReport =  $oDbh->query($count_query)->fetchAll();

    $graph_values = array($report_list[$_report]['fet'],'request_count','response_count','win_notice_count','impression','click');

}


/**************************** REPORT BASED REPORT ENDS *********************************/



/**************************** BIDDERS & REPORT BASED STARTS *********************************/

else if($_bidder != 0 && $_report != 0)
{

    $tb_select = "SELECT  d.dsp_portal_name, r.{$report_list[$_report]['fet']}, sum(r.request_count) as request_count, sum(r.response_count) as response_count,sum(r.test_win_notice_count) as test_win_notice ,  sum(r.win_notice_count) as win_notice_count, sum(r.impression_count) as impression, sum(r.click_count) as click  , sum(r.total_amount) as total_amount,sum(r.admin_share) as admin_share  from {$table_prefix}dj_dsp_advanced_reports r  inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";

    $tb_where = " WHERE r.date_created between '{$start_date}' AND '{$end_date}' AND r.bidderid=".$_bidder;   

    $tb_group = " group by r.bidderid, r.{$report_list[$_report]['fet']}  order by d.dsp_portal_name ASC";

    $query = $tb_select.$tb_where.$tb_group;


    //~TABLE VALUES STARTS

    $rsReport = $oDbh->query($query)->fetchAll();

    $title =  $rsReport[0]['dsp_portal_name']." - ".$report_list[$_report]['name'];

    $table_heading = array('Bidder Name', strtoupper($report_list[$_report]['adv']), 'Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share', 'Test Win Notice');



    $table_data = array(

                   0 => 'dsp_portal_name',
                   1 => $report_list[$_report]['fet'],
                   2 => 'request_count',
                   3 => 'response_count',
                   4 => 'win_notice_count',
                   5 => 'impression',
                   6 => 'click',
                   7 => 'admin_share',
                   8 => 'test_win_notice'

                 );

    $tb_group = " group by r.bidderid  order by d.dsp_portal_name ASC";

    $count_query = $tb_select.$tb_where.$tb_group;
    $allReport =  $oDbh->query($count_query)->fetchAll();

    //~TABLE VALUES ENDS
}

/**************************** BIDDERS & REPORT BASED ENDS *********************************/



/**************************** ALL BIDDERS REPORT STARTS *********************************/

else if($_report == 0 && $_bidder == 0)
{

   $title = "All Bidders Report";

   $tb_select = "SELECT  r.bidderid, d.dsp_portal_name, r.country_name, r.os ,r.domain, r.ip, r.user_agent, r.language, r.age, r.gender, r.device_type, r.device_make, r.device_model, r.page_url, sum(r.request_count) as request_count, sum(r.response_count) as response_count, sum(r.test_win_notice_count) as test_win_notice ,  sum(r.win_notice_count) as win_notice_count,   r.currency, sum(r.total_amount) as total_amount, sum(r.impression_count) as impression, sum(r.click_count) as click , sum(r.total_amount) as total_amount,sum(r.admin_share) as admin_share  from {$table_prefix}dj_dsp_advanced_reports r inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";


   $tb_group = "group by r.bidderid, r.country_name, r.os ,r.domain, r.ip, r.user_agent, r.language, r.age, r.gender, r.device_type, r.device_make, r.device_model,r.page_url order by d.dsp_portal_name ASC";

   $tb_where = " WHERE r.date_created  between '{$start_date}' AND '{$end_date}' ";

    $query = $tb_select.$tb_where.$tb_group;



   $table_heading = array('Bidder Name','Country Name','OS','Domain','IP','User Agent','Language','Age','Gender','Device Type','Device Model','Page URL','Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share', 'Test Win Notice');

    //~ TABLE VALUES STARTS

    $rsReport = $oDbh->query($query)->fetchAll();

    $table_data = array(

              0 => 'dsp_portal_name',
              1 => 'country_name',
              2 => 'os',
              3 => 'domain',
              4 => 'ip',
              5 => 'user_agent',
              6 => 'language',
              7 => 'age',
              8 => 'gender',
              9 => 'device_type',
              10 => 'device_model',
              11 => 'page_url',
              12 => 'request_count',
              13 => 'response_count',
              14 => 'win_notice_count',
              15 => 'impression',
              16 => 'click',
              17 => 'total_amount',
              18 => 'admin_share',
              19 => 'test_win_notice'

            );

    $count_query = "SELECT r.bidderid,d.dsp_portal_name, sum(r.impression_count) as impression, sum(r.click_count) as click,sum(r.response_count) as response_count, sum(r.request_count) as request_count, sum(r.test_win_notice_count) as test_win_notice , sum(r.win_notice_count) as win_notice_count  , sum(r.total_amount) as total_amount,sum(r.admin_share) as admin_share  from {$table_prefix}dj_dsp_advanced_reports r inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";

    $tb_where = " WHERE r.date_created  between '{$start_date}' AND '{$end_date}' ";
    $tb_group = " group by r.bidderid  order by d.dsp_portal_name ASC";

    $query2 = $count_query.$tb_where.$tb_group;


    $allReport = $oDbh->query($query2)->fetchAll();
    
    //~ TABLE VALUES ENDS

}

/**************************************************** ALL BIDDERS REPORT ENDS *********************************/

if($_GET['submit'] != 1)
{

?>

<!-- ************************************************ FORM STARTS**************************** -->

<form method='get' class="oxn_form_at">

    <select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>

        <option value='today' selected='selected'>Today</option>

        <option value='yesterday' <?php if($_period == "yesterday") : ?> selected ="selected" <?php endif; ?> >Yesterday</option>
        <option value='this_week' <?php if($_period == "this_week") : ?> selected ="selected" <?php endif; ?> >This week</option>
        <option value='last_week' <?php if($_period == "last_week") : ?> selected ="selected" <?php endif; ?> > Last week</option>
        <option value='last_7_days' <?php if($_period == "last_7_days") : ?> selected ="selected" <?php endif; ?> >Last 7 days</option>
        <option value='this_month' <?php if($_period == "this_month") : ?> selected ="selected" <?php endif; ?> >This month</option>
        <option value='last_month' <?php if($_period == "last_month") : ?> selected ="selected" <?php endif; ?> >Last month</option>

        <option value='all_stats' <?php if($_period == "all_stats") : ?> selected ="selected" <?php endif; ?> >All statistics</option>
        <option value='specific' <?php if($_period == "specific") : ?> selected ="selected" <?php endif; ?> >Specific dates</option>

    </select>

    <input class="date" name="period_start" id="period_start" type="text" value="<?php  if(!empty($start)){ echo $start;}else{ echo date('Y-m-d');}?>" tabindex="2"/>

    <input type='image' src='<?php echo $calendar;  ?>' class= 'calendar_icon' id='period_start_button' align='absmiddle' border='0' tabindex='3' />

    <input class="date" name="period_end" id="period_end" type="text" value="<?php if(!empty($end)){ echo $end;}else{ echo date('Y-m-d');} ?>" tabindex="4" /> 
    <input type='image' src='<?php echo $calendar; ?>' class= 'calendar_icon' id='period_end_button' align='absmiddle' border='0' tabindex='3' />
   
    <select name='bidder' id='bidder' onchange='periodFormChange(1)' tabindex='1'>

      <option value='0'>-- All Bidders --</option>

      <?php  foreach($bidderList as $list){ ?>

            <option value='<?=$list['id'];?>' <?php if( $_bidder == $list['id'] ) : ?> selected="selected" <?php endif; ?> > <?=$list['dsp_portal_name']?></option>

      <?php } ?>

    </select>

    <select name='report' id='report' onchange='periodFormChange(1)' tabindex='1'>

      <option value='0' <?php if($_report == "0") : ?> selected="selected" <?php endif; ?> >-- All Report --</option>

      <?php  for($i=1; $i<=sizeof($report_list); $i++){ ?>

        <option value="<?=$report_list[$i]['value']?>" <?php if( $_report == $report_list[$i]['value'] ) : ?> selected="selected" <?php endif; ?> ><?=$report_list[$i]['name']?></option>

      <?php } ?>

    </select>

  <a href='' onclick='return periodFormSubmit()'>
       &nbsp; <img src='<?php echo $isSsl.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/assets/images/arrow-r.gif'; ?>' border='0' tabindex='6' /></a>
  
  </br></br></br></br><img class="break" src='<?=$break;?>'>

  </br></br></br></br>

</form>

<!-- ************************************************ FORM ENDS ******************************************-->



<!--************************************ GRAPHICAL REPRESENTATION STARTS **********************************-->

<?php 

$chartInputs = (!empty($allReport))?$allReport: $rsReport;

$total_req = array();
$total_events = array();
$i = 0;

foreach($chartInputs  as $list)
{
  $i++;
  $total_req[] = array(

                    'category' => $list[$graph_values[0]], 
                    'value1'   => $list[$graph_values[1]],
                    'value2'   => $list[$graph_values[2]],
                    'value3'   => $list[$graph_values[3]]
                  );

  $total_events[] =  array(

                    'category' => $list[$graph_values[0]], 
                    'value1'   => $list[$graph_values[4]],
                    'value2'   => $list[$graph_values[5]]
                  );
}

$text_align1 = (sizeof($total_req) > 5)? "categoryAxis.renderer.labels.template.rotation = 270": "";
$text_align2 = (sizeof($total_events) > 5)? "categoryAxis.renderer.labels.template.rotation = 270": "";

$curve = (isset($_bidder) && $_bidder!=0)?1:0.2;


if(!empty($chartInputs) && isset($chartInputs))
{

   echo  $content = "
   

    <!-- Pagination Resources -->
  

    <!-- Styles -->

    <style>

      .chart_container
      {
        display: flex;
      }

      .chartdiv 
      {
        width: 50%;
        height: 470px;
        margin-right: 7px;
        box-shadow: 0px 0px 0.1px 0.2px grey;
      }

      h2{
         text-align: center; 
         width: 80%; 
         color: #3e4a75;
         text-decoration: underline;
      }

    </style>


    <!-- Chart Resources -->

    <script src= '".$plugin_path."/assets/graph/core.js'></script>
    <script src= '".$plugin_path."/assets/graph/charts.js'></script>
    <script src= '".$plugin_path."/assets/graph/anime.js'></script>
    <script src= '".$plugin_path."/assets/graph/themes_dataviz.js'></script>

    <!-- Chart code -->

    <script> 

    var chart = '';
    var slider = [];

    am4core.ready(function() 
    {
        var input = ".json_encode($total_req).";
        var array = ['Request','Response','Win Notice'];

        // Themes begin
        am4core.useTheme(am4themes_animated);
        // Themes end

        // AUTHOR: MAHALAKSHMI K 

        chart = am4core.create('chartdiv1', am4charts.RadarChart);
        chart.hiddenState.properties.opacity = 0; // this creates initial fade-in

        var label = chart.createChild(am4core.Label);
        // label.text = 'chart slider to change radius';
        label.exportable = false;

        chart.data = input;

        //CURVE RADIUS

        chart.radius = am4core.percent(95);
        chart.startAngle = 270 - 180;
        chart.endAngle = 270 + 180;
        chart.innerRadius = am4core.percent(50);


        //APPEND VALUES

        var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
        categoryAxis.dataFields.category = 'category';
        categoryAxis.renderer.labels.template.location = 0.5; // Text Position
        categoryAxis.renderer.grid.template.strokeOpacity = 0.1;
        categoryAxis.renderer.axisFills.template.disabled = true;
        categoryAxis.mouseEnabled = false;
        ".$text_align1."

        var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
        valueAxis.tooltip.disabled = true;
        valueAxis.renderer.grid.template.strokeOpacity = 0.05;
        valueAxis.renderer.axisFills.template.disabled = true;
        valueAxis.renderer.axisAngle = 260;
        valueAxis.renderer.labels.template.horizontalCenter = 'right';
        valueAxis.min = 0;

        var series1 = chart.series.push(new am4charts.RadarColumnSeries());
        series1.columns.template.radarColumn.strokeOpacity = 1;
        series1.name = array[0];
        series1.dataFields.categoryX = 'category';
        series1.columns.template.tooltipText = '{category} - {name}: {valueY.value}';
        series1.dataFields.valueY = 'value1';
        series1.stacked = true;

        var series2 = chart.series.push(new am4charts.RadarColumnSeries());
        series2.columns.template.radarColumn.strokeOpacity = 1;
        series2.columns.template.tooltipText = '{category} - {name}: {valueY.value}';
        series2.name = array[1];
        series2.dataFields.categoryX = 'category';
        series2.dataFields.valueY = 'value2';
        series2.stacked = true;

        var series3 = chart.series.push(new am4charts.RadarColumnSeries());
        series3.columns.template.radarColumn.strokeOpacity = 1;
        series3.columns.template.tooltipText = '{category} - {name}: {valueY.value}';
        series3.name = array[2];
        series3.dataFields.categoryX = 'category';
        series3.dataFields.valueY = 'value3';
        series3.stacked = true;


        //HIDE LOGO

        chart.logo.hoverable = false;
        chart.logo.interactionsEnabled = false;
        chart.logo.opacity = 0;
        chart.logo.clickable = false;
        chart.logo.isMeasured = false;
 

        chart.seriesContainer.zIndex = -1;

        //SLIDER

        slider = chart.createChild(am4core.Slider);
        slider.start = ".$curve.";
        slider.exportable = false;
        slider.events.on('rangechanged', function() 
        {
            var start = slider.start;

            chart.startAngle = 270 - start * 179 - 1;
            chart.endAngle = 270 + start * 179 + 1;

            valueAxis.renderer.axisAngle = chart.startAngle;
        });

    });

    //CHART 2


    am4core.ready(function() 
    {
          var input = ".json_encode($total_events).";
          var array = ['Total Impressions','Total Clicks'];

          // Themes begin    
          am4core.unuseAllThemes();
          am4core.useTheme(am4themes_dataviz);

          // Themes end

          var chart2 = am4core.create('chartdiv2', am4charts.RadarChart);
          chart2.hiddenState.properties.opacity = 0; // this creates initial fade-in

          var label = chart2.createChild(am4core.Label);
          // label.text = 'chart2 slider to change radius';
          label.exportable = false;

          chart2.data = input;

          //CURVE RADIUS

          chart2.radius = am4core.percent(95);
          chart2.startAngle = 270 - 180;
          chart2.endAngle = 270 + 180;
          chart2.innerRadius = am4core.percent(50);


          //APPEND VALUES

          var categoryAxis = chart2.xAxes.push(new am4charts.CategoryAxis());
          categoryAxis.dataFields.category = 'category';
          categoryAxis.renderer.labels.template.location = 0.5;
          categoryAxis.renderer.grid.template.strokeOpacity = 0.1;
          categoryAxis.renderer.axisFills.template.disabled = true;
          categoryAxis.mouseEnabled = false;
          ".$text_align2."

          var valueAxis = chart2.yAxes.push(new am4charts.ValueAxis());
          valueAxis.tooltip.disabled = true;
          valueAxis.renderer.grid.template.strokeOpacity = 0.05;
          valueAxis.renderer.axisFills.template.disabled = true;
          valueAxis.renderer.axisAngle = 260;
          valueAxis.renderer.labels.template.horizontalCenter = 'right';
          valueAxis.min = 0;

          var series1 = chart2.series.push(new am4charts.RadarColumnSeries());
          series1.columns.template.radarColumn.strokeOpacity = 1;
          series1.name = array[0];
          series1.dataFields.categoryX = 'category';
          series1.columns.template.tooltipText = '{category} - {name}: {valueY.value}';
          series1.dataFields.valueY = 'value1';
          series1.stacked = true;

          var series2 = chart2.series.push(new am4charts.RadarColumnSeries());
          series2.columns.template.radarColumn.strokeOpacity = 1;
          series2.columns.template.tooltipText = '{category} - {name}: {valueY.value}';
          series2.name = array[1];
          series2.dataFields.categoryX = 'category';
          series2.dataFields.valueY = 'value2';
          series2.stacked = true;

          var series3 = chart2.series.push(new am4charts.RadarColumnSeries());
          series3.columns.template.radarColumn.strokeOpacity = 1;
          series3.columns.template.tooltipText = '{category} - {name}: {valueY.value}';
          series3.name = array[2];
          series3.dataFields.categoryX = 'category';
          series3.dataFields.valueY = 'value3';
          series3.stacked = true;

          //HIDE LOGO

          chart2.logo.hoverable = false;
          chart2.logo.interactionsEnabled = false;
          chart2.logo.opacity = 0;
          chart2.logo.clickable = false;
          chart2.logo.isMeasured = false;

          chart2.seriesContainer.zIndex = -1;

          //SLIDER

          slider2 = chart2.createChild(am4core.Slider);
          slider2.start = ".$curve.";
          slider2.exportable = false;
          slider2.events.on('rangechanged', function() {
              var start2 = slider2.start;

              chart2.startAngle = 270 - start2 * 179 - 1;
              chart2.endAngle = 270 + start2 * 179 + 1;

              valueAxis.renderer.axisAngle = chart2.startAngle;
          });

      });

    </script>

    <!-- HTML CONTAINER -->

    <div class='chart_container'>

      <h2>Total Bid Rates</h2>
      <h2>Total Events</h2>

    </div>
    </br></br>
    <div class='chart_container'>

      <div id='chartdiv1' class='chartdiv'></div>
      <div id='chartdiv2' class='chartdiv'></div>

    </div>

    </br></br></br></br><img class='break' src='".$break."'></br></br></br></br>

    ";
  }
}

?>

<!--************************************ GRAPHICAL REPRESENTATION ENDS **********************************-->



<!--*********************************** TABLE STRUCTURE STARTS **************************************-->


<!-- TABLE STYLES -->
<style>

.container ul li:hover
{
  background: #808080;
  cursor: pointer;
  /*padding: 8px;*/
}

#customers 
{
  font-family: 'Trebuchet MS', Arial, Helvetica, sans-serif;
  font-weight: 2;
  color: black;
  border-collapse: collapse;
  width: 100%;
}

#customers td, #customers th 
{
  border: 1px solid #ddd;
  padding: 8px;
}

#customers tr:nth-child(even){background-color: #f2f2f2;}

#customers tr:hover {background-color: #ddd;}

#customers th {
  padding-top: 12px;
  padding-bottom: 12px;
  text-align: left;
  background-color: #283250;
  color: white!important;
}
   
h3 
{
  color: #3e4a75;
  text-decoration: underline;
}

.calendar_icon
{
  width: 15px;
  height: 15px;
}

.break
{
  height: 1px;
  color: black;
  width: -webkit-fill-available;
}

.empty_data
{
  background: #ddd;
  color: #c50000;
}

.empty_data td: hover
{
  background: rgba(255, 0, 0, 0.4);
}

.empty_data td
{
  text-align: center;
}

.hide
{
  display: none;
}

.flex
{
  color: green;
  margin-bottom: 10px: 
}

.float
{
  float: right;
  margin-top: -14px;
  margin-right: 10px;
  background: #283250;
  padding: 9px;
  /*border-radius: 15px;*/
  color: white;
  text-decoration: none;
}

.flex a:hover
{
  background: #808080;
  text-decoration: none;
  /*padding: 12px;*/
  /*margin-top: -18px;*/
}

.container 
{
  max-width: 100%;
}

.container ul
{
  display: flex;
  align-items: center!important;
  justify-content: center;
}

.pagination
{
  margin-top: 15px;
}

.container ul li
{
  padding: 5px;
  background: #283250;
  margin-right: 5px;
}

.container ul li a
{
  color: white;
  text-decoration: none!important;
}

.container ul li : hover
{
  background: #808080;
  text-decoration: none;
  padding: 12px;
}
.multiselect {
  /*width: 200px;*/
}

.selectBox {
  position: relative;
}

.selectBox select {
  width: 100%;
  font-weight: bold;
}

.overSelect {
  position: absolute;
  left: 0;
  right: 0;
  top: 0;
  bottom: 0;
}

#checkboxes {
  display: none;
  border: 1px #dadada solid;
}

#checkboxes label {
  /*display: block;*/
}



</style>


<?php 


    $limit = 50; // Number of entries to show in a page.
    $pn = '';
    $_page = $_GET['page'];

    if (isset($_page)) 
    { 
        $pn = $_page; 
    } 

    else 
    { 
        $pn = 1; 
    }; 

    $total_row = sizeof($rsReport);
    $total_tab = ceil($total_row / $limit);

    $start_from = ($pn-1) * $limit; 

    $query = $query." LIMIT $start_from, $limit";

    $tbReport = $oDbh->query($query)->fetchAll();

    // echo $query;exit;

    //~EXPORT ALL PARAMS

    if($_period == 'specific')
    {
        $_period = $_period.'&period_start='.$pPass['period_start'].'&period_end='.$pPass['period_end'];
    }

    $getparams = 'period_preset='.$_period.'&bidder='.$_bidder.'&report='.$_report;

    $url= $plugin_path.'export.php?'.$getparams; 
?>


<!-- TABLE TITLE -->

<div class="flex">

  <h3><?=$title?> Report :</h3>

  <?php $filename = str_replace(" ", "", $title); ?>

  <?php if(!empty($chartInputs) && isset($chartInputs)) { ?>

    <a class="float" onclick="return export_table_to_csv('report_table', '<?=$filename?>.csv');" href=""><b>Export</b></a>

  <?php if(sizeof($rsReport) > $limit) { ?>

    <a class="float" href="<?=$url?>" target="_blank"><b>Export All</b></a>

  <?php } } ?>
 
</div>

</br></br>

  <!-- TABLE DATA -->

  <table class="hide">

    <tbody>
      
      <tr>
        <td>Report: </td><td><?=$title?></td>
      </tr>

      <tr>
        <td>Date: </td><td><?=$start_date?> to <?=$end_date?></td>
      </tr>

      <tr></tr>
      <tr></tr>

    </tbody>

  </table>

  <!-- TABLE DATA -->
  <div class="multiselect">
    <div class="selectBox" onclick="showCheckboxes()">
      <select>
        <option>Show/Hide Columns</option>
      </select>
      <div class="overSelect"></div>
    </div>
    <div id="checkboxes">
      <label for="0">
        <input type="checkbox" class="chk" value="1"/>Bidder Name</label>
      <label for="1">
        <input type="checkbox" class="chk" value="2"/>Country Name</label>
      <label for="2">
        <input type="checkbox" class="chk" value="3" />OS</label>
      <label for="3">
        <input type="checkbox" class="chk" value="4"/>Domain</label>
      <label for="4">
        <input type="checkbox" class="chk" value="5"/>IP</label>
      <label for="5">
        <input type="checkbox" class="chk" value="6"/>User Agent</label>
      <label for="6">
        <input type="checkbox" class="chk" value="7"/>Language</label>
      <label for="7">
        <input type="checkbox" class="chk" value="8"/>Age</label>
      <label for="8">
        <input type="checkbox" class="chk" value="9"/>Gender</label>
      <label for="9">
        <input type="checkbox" class="chk" value="10"/>Device Type</label>
      <label for="10">
        <input type="checkbox" class="chk" value="11"/>Device Model</label>
      <label for="11">
        <input type="checkbox" class="chk" value="12"/>Page URL</label>
      <label for="12">
        <input type="checkbox" class="chk" value="13"/>Request Count</label>
      <label for="13">
        <input type="checkbox" class="chk" value="14"/>Response Count</label>
      <label for="14">
        <input type="checkbox" class="chk" value="15"/>Win Notice Count</label>
      <label for="15">
        <input type="checkbox" class="chk" value="16"/>Impressions</label>
      <label for="16">
        <input type="checkbox" class="chk" value="17"/>Clicks</label>
      <label for="17">
        <input type="checkbox" class="chk" value="18"/>Amount</label>
      <label for="18">
        <input type="checkbox" class="chk"" value="19"/>Admin Share</label>
      <label for="19">
        <input type="checkbox" class="chk"  value="20"/>Test Win Notice</label>
    </div>
  </div><br/>
  <table cellspacing="0" name="report_table" cellpadding="0" border="0" width="100%" id="customers" style="display: inline-block; overflow: auto;">
     
    <thead>
   
      <tr>

        <!-- <th>SNo.</th> -->

        <?php for($i=0;$i<sizeof($table_heading);$i++) { ?>

          <th><?=$table_heading[$i]?></th>

        <?php } ?>

      </tr>

    </thead>

     <?php  if(!empty($chartInputs) && isset($chartInputs)) { for( $i=0; $i < sizeof($tbReport); $i++ ) { ?>

        <tr> 

          <!-- <td><?=$start_from+($i+1)?></td> -->

          <?php for( $j=0; $j < sizeof($table_data); $j++ ) { ?>


            <td><?=$tbReport[$i][$table_data[$j]]?></td>

          <?php } ?>

        </tr>

      <?php } }  else { ?>

        <tr class="empty_data"><td colspan="<?=sizeof($table_heading)+1?>"><b>No Data Found !</b></td></tr>

      <?php } ?>

  </table>

    <!-- PAGINATION START -->

  <div  class="container">

    <ul class="pagination"> 

      <?php   

        $start = 0;
        $end = 0;
        $tab = 5;

        if(sizeof($tbReport)>0)
        {

          $_next = $_GET['next'];
          $_prev = $_GET['prev'];


          if(isset($_prev) || isset($_next))
          {
              if(isset($pn) && ( ($_next - 1) % $tab == 0 ) && isset($_next))
              {
                $start = $pn;
                $end = $pn + $tab;
              }

              else if( $pn % $tab != 0 )
              {
                $count = $pn / $tab;
                $start = $count * $tab;
                $end = $start + $tab;
              }
              else
              {
                $start = 1;
                $end = $tab + 1;
              }
          }

          else if(isset($_GET['page']) && (!isset($_prev) || !isset($_next)) )
          {
              $n = $pn;
              $x = $tab;

              //~ FIND NEAREST MULTIPLE

              $count = (round($n)%$x === 0) ? $n-$tab : (int)($n / $tab) * $tab;

              $start = ($count != 0)? $count + 1 : 1;
              $end = $start + $tab;
          }

          else
          {
              $count = $pn / $tab;
              $start = ceil($count); 
              $end = $start + $tab;
          }

          if($total_tab < 5)
          {
            $end = $total_tab + 1;
          }

          //~PREVIOUS BUTTON

          if($end >= 5 && $start > 5)
          {
            $prev = $start - $tab;
            $pagelink .= "<li class='active'><a href='os_report.php?period_preset=".$_period."&bidder=".$_bidder."&report=".$_report."&prev=".$prev."&page=".$prev."'>Previous</a></li>"; 
          }

          //~ PAGE NUMBER

          for ($i = $start; $i < $end; $i++) 
          { 
              if($pn == $i)
              {
                $pagelink .= "<li class='active' style='background: #808080;padding:10px;'><a href='os_report.php?period_preset=".$_period."&bidder=".$_bidder."&report=".$_report."&page=".$i."'>".$i."</a></li>"; 
              }
              else 
              { 
                $pagelink .= "<li><a href='os_report.php?period_preset=".$_period."&bidder=".$_bidder."&report=".$_report."&page=".$i."'>".$i."</a></li>"; 
              }   
          } 

          //~NEXT BUTTON

          if($end < $total_tab )
          {

            $pagelink .= "<li class='active'><a href='os_report.php?period_preset=".$_period."&bidder=".$_bidder."&report=".$_report."&page=".$i."&next=".$i."'>Next</a></li>"; 
          }
          echo $pagelink; 


        }

        else if( isset($pPass['page']) && $start == 0 )
        {
          echo '<div class="empty_data"> <b> No Data Found ! </b> </div>';
        }
         
      ?> 

    </ul>

  </div>

<!-- PAGINATION END -->


<!--*********************************************** DATE SCRIPT STARTS *************************************-->

<script type='text/javascript'>
$('.chk').change(function() {
  if($(this).is(":checked")) {
    $('#customers td:nth-child('+$(this).val()+'),th:nth-child('+$(this).val()+')').hide();
  } else {
    $('#customers td:nth-child('+$(this).val()+'),th:nth-child('+$(this).val()+')').show();
  }
});
var expanded = false;

function showCheckboxes() {
  var checkboxes = document.getElementById("checkboxes");
  if (!expanded) {
    checkboxes.style.display = "block";
    expanded = true;
  } else {
    checkboxes.style.display = "none";
    expanded = false;
  }
}
Calendar.setup({
    inputField : 'period_start',
    ifFormat   : '%Y-%m-%d',
    button     : 'period_start_button',
    align      : 'Bl',
    weekNumbers: false,
    firstDay   : 1,
    electric   : false
});
Calendar.setup({
    inputField : 'period_end',
    ifFormat   : '%Y-%m-%d',
    button     : 'period_end_button',
    align      : 'Bl',
    weekNumbers: false,
    firstDay   : 1,
    electric   : false
});

       
      
function periodFormChange(bAutoSubmit)
{
    var o = document.getElementById('period_preset');
    var periodSelectName = o.options[o.selectedIndex].value;
    var specific = periodSelectName == 'specific';
    var periodTabIndex = 2;

    document.getElementById('period_start').readOnly = !specific;
    document.getElementById('period_start_button').disabled = !specific;
    document.getElementById('period_end').readOnly = !specific;
    document.getElementById('period_end_button').disabled = !specific;
   
  if (!specific) 
  {
    if(bAutoSubmit)
    {
      document.getElementById('period_start').disabled = true;
      document.getElementById('period_end').disabled =  true; 
    }
    
    document.getElementById('period_start').classList.add("disapp");
    document.getElementById('period_end').classList.add("disapp");
    document.getElementById('period_start').tabIndex = null;
    document.getElementById('period_start_button').tabIndex = null;
    document.getElementById('period_end').tabIndex = null;
    document.getElementById('period_end_button').tabIndex = null;
    document.getElementById('period_start_button').src = '<?php echo $calendar;  ?>';
    document.getElementById('period_end_button').src = '<?php echo $calendar;  ?>' ;

  } 
  else 
  {
    document.getElementById('period_start').classList.remove("disapp");
    document.getElementById('period_end').classList.remove("disapp");
    document.getElementById('period_start').tabIndex = periodTabIndex;
    document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
    document.getElementById('period_end').tabIndex = periodTabIndex + 2;
    document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
    document.getElementById('period_start_button').src = '<?php echo $calendar;  ?>';
    document.getElementById('period_end_button').src = '<?php echo $calendar;  ?>' ;
  }

  document.getElementById('period_start_button').readOnly = !specific;
  document.getElementById('period_end_button').readOnly = !specific;

  document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
  document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

  if (!specific && bAutoSubmit) 
  {
      o.form.submit();
  }
}


periodFormChange(0);

function periodFormSubmit() 
{
    var form = document.getElementById('period_preset').form;
    if (checkDates(form)) {

      form.submit();
    }
    return false;
}

function checkDates(form)
{
  var startField = form.period_start;
  var endField = form.period_end;

  if (!startField.disabled && startField.value != '') {
    var start = Date.parseDate(startField.value, '%Y-%m-%d');
  }
  if (!startField.disabled && endField.value != '') {
    var end = Date.parseDate(endField.value, '%Y-%m-%d');
  }

  if ((start != undefined && end != undefined) && (start.getTime() > end.getTime())) {
    alert('\'From\' date must be earlier then \'To\' date');
    return false;
  }
  return true;
}

</script>

<!-- **************************************** DATE SCRIPT ENDS ********************************************* -->


<!-- *************************************** CSV EXPORT STARTS ********************************************* -->

<script type="text/javascript">

function download_csv(csv, filename) 
{
    var csvFile;
    var downloadLink;

    // CSV FILE
    csvFile = new Blob([csv], {type: "text/csv"});

    // Download link
    downloadLink = document.createElement("a");

    // File name
    downloadLink.download = filename;

    // We have to create a link to the file
    downloadLink.href = window.URL.createObjectURL(csvFile);

    // Make sure that the link is not displayed
    downloadLink.style.display = "none";

    // Add the link to your DOM
    document.body.appendChild(downloadLink);

    // Lanzamos
    downloadLink.click();
    
    return false;


}

function export_table_to_csv(html, filename) {
  var csv = [];
  var rows = document.querySelectorAll("table tr");
  
    for (var i = 0; i < rows.length; i++) {
    var row = [], cols = rows[i].querySelectorAll("td, th");
    
        for (var j = 0; j < cols.length; j++)
        {
			var str = cols[j].innerText;

			 str = str.replace(';', '');
			 str = str.replace(';', '');
			 str = str.replace(';', ''); 
			 str = str.replace(';', ''); 
			 str = str.replace(';', ''); 


            row.push(str);
        }
    csv.push(row.join(","));    
  }
 
   download_csv(csv.join("\n"), filename);
}
    
</script>

    
<!-- ******************************************** CSV EXPORT ENDS ***************************************** -->


<?php phpAds_PageFooter(); ?>
