<?php
require_once LIB_PATH.'/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH.'/plugins/bannerTypeHtml/vastInlineBannerTypeHtml/common.php';

class Plugins_BannerTypeHTML_oxHtml_native extends Plugins_BannerTypeHTML
{

    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */

    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }

    function getOptionDescription()
    {
        return $this->translate("Native");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {

        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyz';

        if ($_FILES["upload"]["size"] != 0)
        {
            if ($_FILES["upload"]["error"] > 0)
            {
                echo "Error: ".$_FILES["upload"]["error"]."<br />";
            }
            $enc = substr(str_shuffle($permitted_chars) , 0, 32);
            $ext = pathinfo($_FILES["upload"]["name"], PATHINFO_EXTENSION);
            $img = $enc.".".$ext;
            $dest_path = '../images/'.$img;
            move_uploaded_file($_FILES["upload"]["tmp_name"], $dest_path);

            $parametes['filename'] = $img;
        }
        else
        {

            $parametes['filename'] = $aFields['upload_val'];
        }

        if ($_FILES["icon_image"]["size"] != 0)
        {
            if ($_FILES["icon_image"]["error"] > 0)
            {
                echo "Error: ".$_FILES["icon_image"]["error"]."<br />";
            }
            $enc = substr(str_shuffle($permitted_chars) , 0, 32);
            $ext = pathinfo($_FILES["icon_image"]["name"], PATHINFO_EXTENSION);
            $img = $enc.".".$ext;
            $dest_path = '../images/'.$img;
            move_uploaded_file($_FILES["icon_image"]["tmp_name"], $dest_path);

            $parametes['icon_image'] = $img;
        }
        else
        {
            $parametes['icon_image'] = $aFields['icon_image_val'];
        }

        if (!empty($aFields['is_icon_image']) && $aFields['is_icon_image'] != 0)
        {

            $parametes['is_icon_image'] = $aFields['is_icon_image'];

        }
        else
        {

            $parametes['is_icon_image'] = $aFields['is_icon_image'];
            $parametes['icon_image'] = '';
        }

        if (!empty($aFields['title']))
        {
            $parametes['title'] = $aFields['title'];
        }

        $data_objects_values = $_POST['data_objects_value'];
        $data_objects = array();
        if ($data_objects_values && count($data_objects_values))
        {
            foreach ($data_objects_values as $key => $val)
            {
                $data_objects[$key] = $val;
            }
        }

        $data_objects = json_encode($data_objects);

        $parametes['data_objects'] = $data_objects;
        $parametes['native_width'] = $_POST['native_width'];
        $parametes['native_height'] = $_POST['native_height'];

        $aVariables['parameters'] = serialize($parametes);

        $aVariables['width'] = - 12;
        $aVariables['height'] = - 12;

    }
           
    function buildForm(&$form, &$bannerRow)
    { 				
		if ($form->isSubmitted()) {
			$form->addElement('html', 'video_form_error', VideoAdsHelper::getWarningMessage('Validation failed!'));
		}

		$parameters = unserialize($bannerRow['parameters']);

		foreach($parameters as $key=>$val)
		{
			$bannerRow[$key] = $val;
		}
		$bannerRow['upload_val'] = $bannerRow['filename'];
		$bannerRow['icon_image_val'] = $bannerRow['icon_image'];


		$header = $form->createElement('header', 'header_txt', "Native Banner Specifications");
		$header->setAttribute('icon', 'icon-banner-text.gif');
		$form->addElement($header);
		$form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());
		$form->addElement('hidden', 'upload_val', '');   
		$form->addElement('hidden', 'icon_image_val', ''); 	 
                         	              
        $imageName = _getContentTypeIconImageName($bannerRow['contenttype']);
        $size = _getBannerSizeText($type, $bannerRow['filename']);
        addUploadGroup($form, $bannerRow,
            array(
                'uploadName' => 'upload',
                'radioName' => 'replaceimage',
                'imageName'  => $imageName,
                'fileName'  => $bannerRow['filename'],
                'fileSize'  => $size,
                'newLabel'  => 'Select the Large Image you want <br/> to use for this banner',
                'updateLabel'  => 'Do you wish to keep your <br/> existing Large Image, or do you <br/> want to upload another?',
                'handleSWF' => true
              )
        );
		$form->addElement('checkbox', 'is_icon_image', "Icon Image");     
        addUploadGroup($form, $bannerRow,
            array(
                'uploadName' => 'icon_image',
                'radioName' => 'replaceicon_image',
                'imageName'  => $imageName,
                'fileName'  => $bannerRow['icon_image'],
                'fileSize'  => $size,
                'newLabel'  => 'Select the Icon Image you want <br/> to use for this banner',
                'updateLabel'  => 'Do you wish to keep your <br/> existing Icon Image, or do you <br/> want to upload another?',
                'handleSWF' => true
              )
        );	          
		$this->addFormRequiredElement($form, array('text', 'native_width', "Width"));       
		$this->addFormRequiredElement($form, array('text', 'native_height', "Height"));        
		$form->addElement('text', 'title', "Title");   
		$form->addElement('text', 'url', 'Destination URL  (incl. http://)');

		$dataobjects = array(
			'dj_data_sponsored'		=>	'Data Sponsored',
			'dj_data_desc'			=>	'Data Description',
			'dj_data_rating'		=>	'Data Rating',
			'dj_data_likes'			=>	'Data Likes',
			'dj_data_downloads'		=>	'Data Downloads',
			'dj_data_price'			=>	'Data Price',
			'dj_data_salesprice'	=>	'Data Salesprice',
			'dj_data_phoneno'		=>	'Data Phone No',
			'dj_data_address'		=>	'Data Address',
			'dj_data_desc2'			=>	'Data Description2',
			'dj_data_displayurl'	=>	'Data Display URL',
			'dj_data_ctatext'		=>	'Data CTA Text',
		);
		$data_objects_selector =  $dataobjects;
           
		if($bannerRow['data_objects'])
		{
			$val_data_objects = json_decode($bannerRow['data_objects'],true);
			foreach($val_data_objects as $k=>$v)
			{
				if(isset($data_objects_selector[$k])) {  unset($data_objects_selector[$k]);  }
			}
		}
		else
		{
			$val_data_objects = array();  
		}
		   
                    
			$styles ="
					<style>

					.open_esq .foot-em select {	width: 200px !important;	height: 20px;	}

					.open_esq .foot-em  button	{	line-height: 22px;	font-size: 22px;	font-weight: 700;	width: 40px;	height: 28px;	cursor: pointer;	margin-left: 10px;	position: relative;	top: 2px;	}

					#thirdLevelContent	{	min-height:0px !important;	}

					.open_esq .elements div	{	margin-bottom: 10px;	}

					.open_esq .elements label	{	font-size: 11px;	font-weight: 600;	display: block;	margin-top: 5px;	margin-bottom: -1px;	}

					.open_esq .elements .oxm_values	{	width: 200px;	padding: 2px;	}

					.open_esq .elements .oxm_close	{	   transition: 0.25s ease;   line-height: 21px;   font-size: 18px;   color: #ff2525;   font-weight: 600;    position: relative;    top: 2px;    left: 19px;    width: 20px;    height: 20px;    display: inline-block;    text-align: center;    padding: 2px;    border-radius: 50%;    cursor: pointer;	}
					
					.open_esq .elements .oxm_close:hover {       background: red;    color: white; }
					
					</style>";
            
		$scripts="<script>
					
					var dataobjects = JSON.parse('".json_encode($dataobjects)."');
	
					function rmv_oblk(t)
					{
						t.parentNode.remove(t);  tmp_dataobjects = JSON.parse('".json_encode($dataobjects)."');
				
						$('.oxm_values').each(function(){  delete tmp_dataobjects[$(this).attr('obj_name')];	 });
						
						$('#data_objects_selector').html('');
				 
						for(var i in tmp_dataobjects)	{ $('#data_objects_selector').append('<option value=\"'+i+'\">'+tmp_dataobjects[i]+'</option>');	}
						
						if(  Object.keys(tmp_dataobjects).length  != 0)	{	$('.open_esq .foot-em').show();		}
					}

					$('.obg_opt').click(function()
					{
	
						var value = $('#data_objects_selector').val();
			
						if(dataobjects[value])
						{
							var label = dataobjects[value];
							var input = '<div><label>'+label+'</label><input class=\"oxm_values\" obj_name=\"'+value+'\" name=\"data_objects_value['+value+']\" ><span class=\"oxm_close\"   onclick=\"rmv_oblk(this);\" >&times</span></div>';
						
							$('.open_esq .elements').append(input);		tmp_dataobjects = JSON.parse('".json_encode($dataobjects)."');
				
							$('.oxm_values').each(function()	{	 delete tmp_dataobjects[$(this).attr('obj_name')];	 });
							
							$('#data_objects_selector').html('');
				 
							for(var i in tmp_dataobjects) {	 $('#data_objects_selector').append('<option value=\"'+i+'\">'+tmp_dataobjects[i]+'</option>');		}
							
							if(  Object.keys(tmp_dataobjects).length  == 0)	{	$('.open_esq .foot-em').hide(); 		}
						}
					});
					
				</script>";
     
     	
           
         $data_object_html[] = $form->createElement('html', '', '<div class="open_esq"> <div class="elements">');
         
         if($val_data_objects && count($val_data_objects))
         {
			 foreach($val_data_objects as $k=>$v)
			{
				$data_object_html[] = $form->createElement('html', '', '<div><label>'.$dataobjects[$k].'</label><input class="oxm_values" obj_name="'.$k.'" name="data_objects_value['.$k.']" value="'.$v.'" ><span class="oxm_close"   onclick="rmv_oblk(this);" >&times</span></div>'); 	 
			}			 
		 }
         
         $data_object_html[] = $form->createElement('html', '', '</div><div class="foot-em" '.((count($data_objects_selector) == 0 ) ? 'style="display:none"' : '').'>');
         $data_object_html[] =  $form->createElement('select', 'data_objects_selector', '' ,$data_objects_selector);  
         $data_object_html[] = $form->createElement('html', '', '<button class="obg_opt" type="button">&#43;</button></div></div>');
         $data_object_html[] = $form->createElement('html', '',$styles);
         $data_object_html[] = $form->createElement('html', '',$scripts);
         
         $data_object_html_group[] = $form->createElement('group', 'data_object_html', null, $data_object_html, null, false);
         $form->addGroup($data_object_html_group, 'data_object_html_group', 'Data Object', "<br/>");
       
         $form->addElement('html', '','	<script>

										var is_icon_image 		= $("input[name=\"is_icon_image\"]").is(":checked");
										var icon_image 			= $("input[name=\"icon_image\"]");
										var upload_val 			= $("#upload_val");
										var icon_image_val 		= $("#icon_image_val");

										upload_val.parent().parent().prev().hide();
										upload_val.parent().parent().hide();
										upload_val.hide();
										icon_image_val.parent().parent().prev().hide();
										icon_image_val.parent().parent().hide();
										icon_image_val.hide();
										icon_image.parent().parent().prev().hide();
										icon_image.parent().parent().hide();
										icon_image.hide();
	
										toggleDeal(is_icon_image);
										$("input[name=\"is_icon_image\"]").click(function(){
											toggleDeal($(this).is(":checked"));
										});

										function toggleDeal(option){
											if(option == true){
												icon_image.parent().parent().prev().show();
												icon_image.parent().parent().show();
												icon_image.show();
											}else{
												icon_image.parent().parent().prev().hide();
												icon_image.parent().parent().hide();
												icon_image.hide();			
											}
										}
										</script>'); 	 	
        
        
        return $form;              
    }    

    
    function getLabelWithRequiredStar($label)
	{
		return $label.' <font color="red">*</font>';
	}
	function setElementIsRequired($fieldName, $fieldNameWhenRequired, $fieldValueWhenRequired)
	{
		$this->requiredElement[] = array(
			$fieldName,
			$fieldNameWhenRequired,
			$fieldValueWhenRequired
		);
	}
	function addFormRequiredElement(&$form, $element, $fieldNameWhenRequired = null, $fieldValueWhenRequired = null)
	{
		// add the red star in the name
		$element[2] = $this->getLabelWithRequiredStar($element[2]);

		// we do not add the element as "required" in the form, as we need to test which fields
		// are required depending on overlay types, video delivery types, etc.
		call_user_func_array(array(
			$form,
			'addElement'
		) , $element);

		$fieldName = $element[1];
		$this->setElementIsRequired($fieldName, $fieldNameWhenRequired, $fieldValueWhenRequired);
	}

	function checkForErrorFileUploaded($oFile)
	{
		if (PEAR::isError($oFile))
		{
			die('here');

			phpAds_PageHeader(1);
			phpAds_Die($GLOBALS['strErrorOccurred'], htmlspecialchars($oFile->getMessage())."<br>Please make sure you selected a valid file.");
		}
	}

	function _getContentTypeIconImageName($contentType)
	{
		$imageName = '';
		if (empty($contentType))
		{
			return $imageName;
		}

		switch ($contentType)
		{
			case 'swf':
			case 'dcr':
				$imageName = 'icon-filetype-swf.gif';
			break;
			case 'jpeg':
				$imageName = 'icon-filetype-jpg.gif';
			break;
			case 'gif':
				$imageName = 'icon-filetype-gif.gif';
			break;
			case 'png':
				$imageName = 'icon-filetype-png.gif';
			break;
			case 'rpm':
				$imageName = 'icon-filetype-rpm.gif';
			break;
			case 'mov':
				$imageName = 'icon-filetype-mov.gif';
			break;
			default:
				$imageName = 'icon-banner-stored.gif';
			break;
		}

		return $imageName;
	}

	function _getBannerSizeText($type, $filename)
	{
		$size = phpAds_ImageSize($type, $filename);
		if (round($size / 1024) == 0)
		{
			$size = $size." bytes";
		}
		else
		{
			$size = round($size / 1024)." Kb";
		}

	}


    
}
?>

