<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	require_once '../../../../init.php';

	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}

      
	// Required files
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	
	$draw = $_POST['draw'];
	$data = array();
	$limit = '';


	// echo "<pre>";print_r($_POST);exit;

	$rowperpage = $_POST['length']; // Rows display per page
	
	## RECORD COUNT
	if ($rowperpage == -1) {
		$limit = "";	## ALL RECORDS
	}else{
		$limit = "LIMIT ".$_POST['start'].",".$_POST['length'];	## LIMITTED RECORDS
	}
	

    $dates = explode(' - ', $_POST['dates']);
    $start_date = str_replace(' ', '-', $dates[0]);
    $end_date = str_replace(' ', '-', $dates[1]);

	$group_by = "Group BY bidderid";

	for($i=0;$i<sizeof($_POST['attributes']);$i++){

	    $group_by .= " , ".$_POST['attributes'][$i];
	}


	$total_query = OA_Dal_Delivery_Query("SELECT ex.exchange_name AS name, SUM(ssp.request_count) AS requests, SUM(ssp.response_count) AS response, SUM(ssp.win_notice_count) AS wins, SUM(ssp.click_count) AS clicks, SUM(ssp.impression_count) AS impressions, ssp.date_time AS date_time, SUM(ssp.conversion) AS conversion, SUM(ssp.total_amount) AS total_revenue, ssp.country_name as country, ssp.banner_type, ssp.pmp_deal, ssp.page_url, ssp.device_type, af.name as site, z.zonename as zone, dl.name as deal  FROM {$table_prefix}dj_ssp_advanced_reports AS ssp LEFT JOIN {$table_prefix}dj_ad_exchange ex ON ex.exchange_id = ssp.bidderid LEFT JOIN {$table_prefix}zones AS z ON z.zoneid = ssp.zone_id LEFT JOIN {$table_prefix}affiliates AS af ON af.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}dealid dl ON dl.dealid = ssp.pmp_deal ".$group_by);

	$total_record = OA_Dal_Delivery_numRows($total_query);


  	$getQuery = OA_Dal_Delivery_Query("SELECT ex.exchange_name AS name, SUM(ssp.request_count) AS requests, SUM(ssp.response_count) AS response, SUM(ssp.win_notice_count) AS wins, SUM(ssp.click_count) AS clicks, SUM(ssp.impression_count) AS impressions, ssp.date_time AS date_time, SUM(ssp.conversion) AS conversion, SUM(ssp.total_amount) AS total_revenue, ssp.country_name as country, ssp.banner_type, ssp.pmp_deal, ssp.page_url, ssp.device_type, af.name as site, z.zonename as zone, dl.name as deal  FROM {$table_prefix}dj_ssp_advanced_reports AS ssp LEFT JOIN {$table_prefix}dj_ad_exchange ex ON ex.exchange_id = ssp.bidderid LEFT JOIN {$table_prefix}zones AS z ON z.zoneid = ssp.zone_id LEFT JOIN {$table_prefix}affiliates AS af ON af.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}dealid dl ON dl.dealid = ssp.pmp_deal ".$group_by ."  ". $limit);


	while($row = OA_Dal_Delivery_fetchAssoc($getQuery)){


switch ($row['device_type']) {
	
	case "1" :
	$row['device_type'] = "Mobile/Tablet";
	break;
	
	case "2" :
	$row['device_type'] = "Personal Computer";
	break;
	
	case "3" :
	$row['device_type'] = "Connected TV";
	break;
	
	case "4" :
	$row['device_type'] = "Phone";
	break;
	
	case "5" :
	$row['device_type'] = "Tablet";
	break;
	
	case "6" :
	$row['device_type'] = "Connected Device";
	break;
	
	case "7" :
	$row['device_type'] = "Set Top Box";
	break;
	
	default :
	$row['device_type'] = "Desktop";
	
	
}

		$data[] = array ( 


			'name' => $row['name'],
			'requests' => $row['requests'],
			'country' => $row['country'],
			'banner_type' =>($row['banner_type'] == 1  ? "Image" : "Video" ),
			'deal' => $row['deal'],
			'bundle_url' => $row['page_url'],
			'device' => $row['device_type'],
			'exchange' => $row['name'],
			'site' => $row['site'],
			'zone' => $row['zone'],
			'response' => $row['response'],
			'wins' => $row['wins'],
			'impressions' => $row['impressions'],
			'win_rate' => ($row['requests'] > 0)? round($row['wins'] / $row['requests']* 100, 2) : 0.00 ,
			'win_amount' => ($row['total_revenue'] > 0)? $row['total_revenue'] : 0.00 ,
			'fill_rate' => ($row['requests'] > 0)? round($row['impressions'] / $row['requests']* 100, 2) : 0.00,
			'clicks' => $row['clicks'],
            "ctr" => ($row['impressions'] > 0)? round($row['clicks']/$row['impressions']*100, 2) : 0.00,
            "ecpm" => ($row['impressions'] > 0) ? round(($row['total_revenue'] / $row['impressions']) * 1000, 2) : 0.00,
            'total_revenue' => ($row['total_revenue'] > 0) ? round($row['total_revenue'], 2) : 0.00,
		);
	}


	## Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => $total_record,
	  "iTotalDisplayRecords" => $total_record,
	  "aaData" => $data
	);


	echo json_encode($response);
	exit();
?>
