<?php

  header("Access-Control-Allow-Origin: *");
  header("Content-Type: application/json; charset=UTF-8");
  header("Access-Control-Allow-Methods: POST");
  header("Access-Control-Max-Age: 3600");
  header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

  require_once '../../../../init.php';

  if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
  }else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
  }else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
  }
  
  $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
      
  // Required files
  require_once MAX_PATH . '/lib/OA/Dal.php';      
  require_once MAX_PATH . '/lib/OA/Admin/Option.php';
  require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
  require_once MAX_PATH . '/www/admin/config.php';
  require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

  $data['series'] = array(); 
  $labels = array();
  $requests = array();
  $response = array();
  $impressions = array();
  $clicks = array();
  $wins = array();
  
  $conversion = array();
  $total_revenue = array();
  $revenue = array();
  $back_fill = array();
  $win_rate = array();
  $ecpm = array();
  $fill_rate = array();
  $ctr = array();

  $dates = explode(' - ', $_POST['dates']);
  $start_date = str_replace(' ', '-', $dates[0]);
  $end_date = str_replace(' ', '-', $dates[1]);


  $group_by = "Group BY bidderid";
  $metrics = "bidderid";

  for($i=0;$i<sizeof($_POST['attributes']);$i++){

      $group_by .= " , ".$_POST['attributes'][$i];
  }

  $getQuery = "SELECT ex.exchange_name AS name, SUM(ssp.request_count) AS requests, SUM(ssp.response_count) AS response, SUM(ssp.win_notice_count) AS wins, SUM(ssp.click_count) AS clicks, SUM(ssp.impression_count) AS impressions, ssp.date_time AS date_time, SUM(ssp.conversion) AS conversion, SUM(ssp.total_amount) AS total_revenue, ssp.country_name as country, ssp.banner_type, ssp.pmp_deal, ssp.page_url, ssp.device_type, af.name as site, z.zonename as zone, dl.name as deal  FROM {$table_prefix}dj_ssp_advanced_reports AS ssp LEFT JOIN {$table_prefix}dj_ad_exchange ex ON ex.exchange_id = ssp.bidderid LEFT JOIN {$table_prefix}zones AS z ON z.zoneid = ssp.zone_id LEFT JOIN {$table_prefix}affiliates AS af ON af.affiliateid = z.affiliateid LEFT JOIN {$table_prefix}dealid dl ON dl.dealid = ssp.pmp_deal ".$group_by ."  ". $_POST['limit'];


  $getQuery = OA_Dal_Delivery_Query($getQuery);

  while ($aRow = OA_Dal_Delivery_fetchAssoc($getQuery)) 
  {
      $labels[] = (strlen($aRow['name']) > 5 ? substr($aRow['name'],0,10)."..." : $aRow['name']);
      $requests[] = (float)$aRow['requests'];
      $response[] = (float)$aRow['response'];
      $impressions[] = (float)$aRow['impressions'];
      $clicks[] = (float)$aRow['clicks'];
      $wins[] = (float)$aRow['wins'];
      
      $conversion[] = (float)$aRow['conversion'];
      $total_revenue[] = (float)$aRow['total_revenue'];
      $back_fill[] = 0.00;
      $win_rate[] = ($aRow['requests'] > 0) ? round($aRow['wins'] / $aRow['requests'] * 100, 2) :  0.00;
      $win_amount[] = ($aRow['total_revenue'] > 0) ? $aRow['total_revenue'] :  0.00;
      $fill_rate[] = ($aRow['requests'] > 0) ? round($aRow['impressions'] / $aRow['requests'] * 100, 2) :  0.00;
      $ctr[] = ($aRow['impressions'] > 0) ? round($aRow['clicks'] / $aRow['impressions'] * 100, 2) :  0.00;
      $ecpm[] = ($aRow['impressions'] > 0) ? round($aRow['total_revenue'] / $aRow['impressions'] * 1000, 2) :  0.00;
      $revenue = $aRow['total_revenue'];
  }

  for( $i=0; $i<sizeof($_POST['metrics']); $i++ ){

      if($_POST['metrics'][$i] == 'request_count'){

          $request_series = array(

                              "name" => "Requests",
                              "data" => $requests
                          );
          array_push($data['series'], $request_series);
      }

      if($_POST['metrics'][$i] == 'response_count'){

          $request_series = array(

                              "name" => "Response",
                              "data" => $response
                          );
          array_push($data['series'], $request_series);
      }
      if($_POST['metrics'][$i] == 'win_notice_count'){

          $request_series = array(

                              "name" => "Wins",
                              "data" => $wins
                          );
          array_push($data['series'], $request_series);
      }
      if($_POST['metrics'][$i] == 'win_rate'){

          $request_series = array(

                              "name" => "Win Rate",
                              "data" => $win_rate
                          );
          array_push($data['series'], $request_series);
      }
      if($_POST['metrics'][$i] == 'win_amount'){

          $request_series = array(

                              "name" => "Win Amount",
                              "data" => $win_amount
                          );
          array_push($data['series'], $request_series);
      }
      // if($_POST['metrics'][$i] == 'impression_count'){

      //     $request_series = array(

      //                         "name" => "Impressions",
      //                         "data" => $impressions
      //                     );
      //     array_push($data['series'], $request_series);
      // }
      // if($_POST['metrics'][$i] == 'click_count'){

      //     $request_series = array(

      //                         "name" => "Clicks",
      //                         "data" => $clicks
      //                     );
      //     array_push($data['series'], $request_series);
      // }
      // if($_POST['metrics'][$i] == 'back_fill'){

      //     $request_series = array(

      //                         "name" => "Back Fill",
      //                         "data" => $back_fill
      //                     );
      //     array_push($data['series'], $request_series);
      // }
      // if($_POST['metrics'][$i] == 'ctr'){

      //     $request_series = array(

      //                         "name" => "CTR",
      //                         "data" => $ctr
      //                     );
      //     array_push($data['series'], $request_series);
      // }
      // if($_POST['metrics'][$i] == 'ecpm'){

      //     $request_series = array(

      //                         "name" => "ECPM",
      //                         "data" => $ecpm
      //                     );
      //     array_push($data['series'], $request_series);
      // }
      // if($_POST['metrics'][$i] == 'revenue'){

      //     $request_series = array(

      //                         "name" => "Revenue",
      //                         "data" => $total_revenue
      //                     );
      //     array_push($data['series'], $request_series);
      // }
  }

  $data['categories'] = $labels;
  
  echo json_encode($data);

  exit();

?>
