<?php
// DIC configuration
use Respect\Validation\Validator as v;
$container = $app->getContainer();

// view renderer
$container['renderer'] = function ($c) {
    $settings = $c->get('settings')['renderer'];
    return new Slim\Views\PhpRenderer($settings['template_path']);
};

// monolog
$container['logger'] = function ($c) {
    $settings = $c->get('settings')['logger'];
    $logger = new Monolog\Logger($settings['name']);
    $logger->pushProcessor(new Monolog\Processor\UidProcessor());
    $logger->pushHandler(new Monolog\Handler\StreamHandler($settings['path'], $settings['level']));
    return $logger;
};

// Database connection
$container['db'] = function ($c) {
    $settings = $c->get('settings')['db'];
    $pdo = new PDO("mysql:host=" . $settings['host'] . ";dbname=" . $settings['dbname'],
        $settings['user'], $settings['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    return $pdo;
};


$container['agency_validate'] = function ($c) {
    //Create the validators
    $name =v::notEmpty();
	$contactname = v::notEmpty();
	$email = v::notEmpty();
	$username= v::notEmpty(); 
	$password= v::notEmpty();
    $validators = array(
		  'name' => $name,
          'contact' => $contactname,
		  'email' => $email,
		  'username'=>$username,
		  'password'=>$password 
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};


$container['agency_edit'] = function ($c) {
    //Create the validators
    $mode =v::notEmpty();
	 $validators = array(
		  'mode' => $mode
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};




$container['tracker_validate'] = function ($c) {
    //Create the validators

    $trackername = v::notEmpty();
    $description = v::notEmpty();
    $status = v::notEmpty();
    $type = v::numeric()->positive()->between(1,3);
    $appendcode = v::notEmpty();
    $clientid=v::numeric()->positive();
    $validators = array(
        'trackername' => $trackername,
        'description' => $description,
        'status' => $status,
        'type' => $type,
        'appendcode' => $appendcode,
        'clientid'	=> $clientid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['tracker_edit'] = function ($c) {
    //Create the validators
    
    $trackerid=v::numeric()->positive();
    $validators = array(
        'trackerid'	=> $trackerid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['tracker_editmode'] = function ($c) {
    //Create the validators
    
    $trackerid=v::numeric()->positive();
     $mode=v::notEmpty();
    $validators = array(
        'trackerid'	=> $trackerid,
        'mode' =>$mode       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
};
$container['advertiser_edit'] = function ($c) {
    //Create the validators
    
    //~ $trackerid=v::numeric()->positive();
     $mode=v::notEmpty();
    $validators = array(
        
        'mode' =>$mode       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
};


$container['client_val'] = function ($c) {
    //Create the validators
    
    $clientid=v::numeric()->positive();
    $validators = array(
        'clientid'	=> $clientid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['zone_val'] = function ($c) {
    //Create the validators
    
    $zonename=v::notEmpty();
    //$description=v::notEmpty();
    $publisherid=v::notEmpty();
    
    $validators = array(
        'zonename'		=> $zonename,       		
        //'description'	=> $description,       		 		   		
        'publisherid'		=> $publisherid,      		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};




$container['target_val'] = function ($c) {
    //Create the validators
    
    $affiliateid=v::notEmpty();
    $name=v::notEmpty();
    /* $description=v::notEmpty();
    $comments=v::notEmpty(); 
	'description'		=> $description,      		
     'comments'			=> $comments*/
    $logical=v::notEmpty();
    $comparison=v::notEmpty();
    $type=v::notEmpty();
    $data=v::notEmpty();
    
    $validators = array(
        'affiliateid'		=> $affiliateid,       		
        'name'				=> $name       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};




$container['get_zone_val'] = function ($c) {
    //Create the validators
    
    $zoneid=v::notEmpty();
    
    $validators = array(
        'zoneid'		=> $zoneid     		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};




$container['zoneid_val'] = function ($c) {
    //Create the validators
    
    $zoneid=v::numeric()->positive();
    $validators = array(
        'zoneid'	=> $zoneid       		
    );

return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['zoneid_edit'] = function ($c) {
    //Create the validators
    
    $zoneid=v::numeric()->positive();
     $mode = v::notEmpty();
    $validators = array(
        'zoneid'	=> $zoneid ,
        'mode' =>$mode		
    );

return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['pubid_val'] = function ($c) {
    //Create the validators
    
    $publisherid=v::numeric()->positive();
    $validators = array(
        'publisherid'	=> $publisherid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['pubid_edit'] = function ($c) {
    //Create the validators
    
    $publisherid=v::numeric()->positive();
    $mode = v::notEmpty();
    $validators = array(
        'publisherid'	=> $publisherid,
        'mode' =>$mode       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


$container['publisheradd_val'] = function ($c) {
    //Create the validators
   $contactname = v::notEmpty();
	$email = v::notEmpty();
	$website = v::notEmpty(); 
	$username = v::notEmpty();
	$password = v::notEmpty();
	$name = v::notEmpty();
	$agencyid = v::numeric()->positive();
    $validators = array(
          'contact' => $contactname,
		  'email' => $email,
		  'username'=>$username,
		  'password'=>$password,
		  'website'=>$website,
		  'name'=>$name,
		  'agencyid'=>$agencyid 
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banneradd_val'] = function ($c) {
    //Create the validators
    $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype
		 //'imageurl'=>$imageurl,
		  
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};


$container['banneradd_edit'] = function ($c) {
    //Create the validators
   $mode = v::notEmpty();
	
    $validators = array(
          'mode' => $mode 
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};



$container['userid_val'] = function ($c) {
    //Create the validators    
    $userid=v::numeric()->positive();
    $validators = array(
        'userid'	=> $userid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};



$container['userid_edit'] = function ($c) {
    //Create the validators    
    $userid=v::numeric()->positive();
    $mode = v::notEmpty();
    $validators = array(
        'userid'	=> $userid  ,
        'mode' =>$mode     		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};




$container['advertiser_val'] = function ($c) {
    //Create the validators    
    $advertiserid=v::numeric()->positive();
    $validators = array(
        'advertiserid'	=> $advertiserid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};


$container['accountid_val'] = function ($c) {
    //Create the validators    
    $accountid=v::numeric()->positive();
    $validators = array(
        'accountid'	=> $accountid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};

$container['affid_val'] = function ($c) {
    //Create the validators    
    $affiliateid=v::numeric()->positive();
    $validators = array(
        'affiliateid'	=> $affiliateid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};


$container['clientid_val'] = function ($c) {
    //Create the validators    
    $client_id=v::numeric()->positive();
    $validators = array(
        'client_id'	=> $client_id       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};

$container['agencyid_val'] = function ($c) {
    //Create the validators    
    $agencyid=v::numeric()->positive();
    $validators = array(
        'agencyid'	=> $agencyid       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};
 
 
$container['campaignid_val'] = function ($c) {
    //Create the validators    
    $campaign_id=v::numeric()->positive();
    // $mode = v::notEmpty();
    $validators = array(
        'campaign_id'	=> $campaign_id      		
              		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};



$container['campaignid_val1'] = function ($c) {
    //Create the validators    
    $campaign_id=v::numeric()->positive();
     $mode = v::notEmpty();
    $validators = array(
        'campaign_id'	=> $campaign_id ,      		
        'mode'	=> $mode       		
    );
    return new \DavidePastore\Slim\Validation\Validation($validators);    
};




$container['user_val'] = function ($c) {
    //Create the validators
    
    $email = v::notEmpty();
    $contactname = v::notEmpty();
    $username = v::notEmpty();
    $password = v::notEmpty();
    $accountid = v::notEmpty();
    $validators = array(
        'email'	=> $email,       		
        'contactname' => $contactname,       		
        'username'	=> $username,       		
        'password'	=> $password,       		
        'accountid'	=> $accountid       		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};





$container['advertiser_validate'] = function ($c) {
    //Create the validators
   $contactname = v::notEmpty();
	$email = v::notEmpty();
	$username= v::notEmpty(); 
	$password= v::notEmpty();
	$clientname= v::notEmpty();
	$report= v::notEmpty();
	$reportinterval= v::notEmpty();
	$reportdeactivate= v::notEmpty();
	$advertiser_limitation= v::numeric()->between(0,1);
    $validators = array(
          'contact' => $contactname,
		  'email' => $email,
		  'username'=>$username,
		  'password'=>$password,
		  'clientname'=>$clientname,
		  'report'=>$report,
		  'reportinterval'=>$reportinterval,
		  'reportdeactivate'=>$reportdeactivate,
		  'advertiser_limitation'=>$advertiser_limitation
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};



$container['campaign_validate'] = function ($c) {
    //Create the validators
    $campaignname =v::notEmpty(); 
	$start_date =v::date("Y-m-d H:i:s");
   // $end_date =v::date("Y-m-d H:i:s");
	//~ $status= v::notEmpty();    	
	$priority= v::notEmpty();    	
    $validators = array(
		  'campaignname' => $campaignname,
		 
		  'start_date'=>$start_date
		
    );    
    return new \DavidePastore\Slim\Validation\Validation($validators);
};


$container['datevalidation'] = function ($c) {
   
    $start_date =v::date("Y-m-d%20H:i:s");
    $end_date =v::date("Y-m-d%20H:i:s");
    $validators = array(
        'start_date' => $start_date,
        'end_date' => $end_date
        		
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};


//~ $this->Model->set($this->request->data);
//~ 
//~ if (!$this->Model->validates()) {
    //~ $this->response->statusCode(400);
    //~ $this->set('_serialize', array(
       //~ 'message' => 'Invalid Parameter',
       //~ 'url' => '/resource',
    //~ ));
//~ }


$container['limitValidation'] = function ($c) {
	
    //Create the validators
    $bannerid =v::numeric()->positive();
	
    $validators = array(
        'bannerid' => $bannerid
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['campaignlimitValidation'] = function ($c) {
	
    //Create the validators
    $campaignid =v::numeric()->positive();
	
    $validators = array(
        'campaignid' => $campaignid
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};



$container['az_link'] = function ($c) {
	
    //Create the validators
    $zoneid = v::notEmpty();
    $bannerid = v::notEmpty();
   
	
    $validators = array(
        'bannerid' => $bannerid,
        'zoneid' => $zoneid
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};




$container['cz_link'] = function ($c) {
	
    //Create the validators
    $zoneid = v::notEmpty();
    $campaignid = v::notEmpty();
	
    $validators = array(
        'zoneid' => $zoneid,
        'campaignid' => $campaignid
    );

    return new \DavidePastore\Slim\Validation\Validation($validators);
    
    
};

$container['add_bannerredirect'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype,
		  'url'=>$url
		 //'imageurl'=>$imageurl,
		  
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['edit_redirectbanner'] = function ($c) {
    //Create the validators
    $mode =v::notEmpty();
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
		'mode' => $mode ,
        'description' => $description ,
		'storagetype' => $storagetype,
		'url'=>$url
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banner_addurlintoIframe'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype
		 //'imageurl'=>$imageurl,
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banner_editurlintoIframe'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$imageurl = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype
		 //'imageurl'=>$imageurl,		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

//VAST 

$container['banneraddvastinline_val'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
	//$vast_wrapper_url = v::notEmpty(); 
	$vast_version = v::notEmpty(); 
	//$vast_video_delivery = v::notEmpty(); 
	//$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype,
		  //'vast_wrapper_url' => $vast_wrapper_url,
		  'vast_version' => $vast_version,
		  // 'vast_video_delivery' => $vast_video_delivery,
		 //~ 'imageurl'=>$imageurl,
		 // 'url'=>$url 
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};

$container['banneraddvastoverlay_val'] = function ($c) {
    //Create the validators
   $description = v::notEmpty();
	$storagetype = v::notEmpty();
//	$vast_wrapper_url = v::notEmpty(); 
	$vast_overlay_version = v::notEmpty(); 
	$vast_overlay_format = v::notEmpty(); 
	$url = v::notEmpty();
    $validators = array(
          'description' => $description ,
		  'storagetype' => $storagetype,
		//  'vast_wrapper_url' => $vast_wrapper_url,
		  'vast_overlay_version' => $vast_overlay_version,
		  'vast_overlay_format' => $vast_overlay_format,
		 //~ 'imageurl'=>$imageurl,
		  'url'=>$url 
		  
    );   
    return new \DavidePastore\Slim\Validation\Validation($validators);
};
