<?php
/*
 * 
 * File Created by DAC141
 * 
 */

/*--------------- Start of Advertiser Statistics ------------*/

// Get Advertiser campaign Statistics

$app->post('/get_advertiser_campaign_statistics/[{advertiser_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			//$sql .= " GROUP BY c.campaignid";


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();


			$todos = $sth->fetchAll();

			if ($todos) {
				if (!empty ($todos[0]['ad_id'])) {
					return $this->response->withJson($todos);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// All Advertiser Campaign Statistics

$app->get('/get_all_dashboard_advertiser_campaign_statistics/[{advertiser_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if ($client) {

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();


			$todos = $sth->fetchAll();

			if ($todos) {
				if (!empty ($todos[0]['ad_id'])) {
					return $this->response->withJson($todos);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Advertiser Graph Statistics

$app->post('/get_advertiser_campaign_graph_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');

		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND h.impressions != 0
			AND cl.clientid = :advertiserid";
			//AND h.clicks != 0 AND h.impressions != 0
			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			/*$impressionsarr = array(); //AND h.clicks > 0 AND h.impressions > 0
																																																													  $clicksarr = array(); 
																																																													  $conversionsarr = array(); 
																																																													  $revenuearr = array(); 
																																																													  $ctrarr = array(); 
																																																													  $ecpmarr = array(); 
																																																													  foreach($todos as $todorow => $imrow)
																																																													  {
																																																													  
																																																													  $impressionsarr[$todorow] = $imrow['impressions'];
																																																													  $clicksarr[$todorow] = $imrow['clicks'];
																																																													  $conversionsarr[$todorow] = $imrow['conversions'];
																																																													  $revenuearr[$todorow] = $imrow['revenue'];
																																																													  $ctrarr[$todorow] = $imrow['ctr'];
																																																													  $ecpmarr[$todorow] = $imrow['ecpm'];
																																																													  
																																																													  }
																																																													  $maximpressions = max($impressionsarr);
																																																													  $maxclicks = max($clicksarr);
																																																													  $maxconversions = max($conversionsarr);
																																																													  $maxrevenue = max($revenuearr);
																																																													  $maxctr = max($ctrarr);
																																																													  $maxecpm = max($ecpmarr);

																																																													  // find the key of the impression with the highest value
																																																													  $impression_key = array_search($maximpressions, $impressionsarr);
																																																													  $clicks_key = array_search($maxclicks, $clicksarr);
																																																													  $conversions_key = array_search($maxconversions, $conversionsarr);
																																																													  $revenue_key = array_search($maxrevenue, $revenuearr);
																																																													  $ctr_key = array_search($maxctr, $ctrarr);
																																																													  $ecpm_key = array_search($maxecpm, $ecpmarr);

																																																													  $impression_with_highest_value = $todos[$impression_key];
																																																													  $clicks_with_highest_value = $todos[$clicks_key];
																																																													  $conversions_with_highest_value = $todos[$conversions_key];
																																																													  $revenue_with_highest_value = $todos[$revenue_key];
																																																													  $ctr_with_highest_value = $todos[$ctr_key];
																																																													  $ecpm_with_highest_value = $todos[$ecpm_key];
																																																													  
																																																													  $impression = $impression_with_highest_value['impressions'];
																																																													  $clicks = $clicks_with_highest_value['clicks'];
																																																													  $conversions = $conversions_with_highest_value['conversions'];
																																																													  $revenue = $revenue_with_highest_value['revenue'];
																																																													  $ctr = $ctr_with_highest_value['ctr'];
																																																													  $ecpm = $ecpm_with_highest_value['ecpm'];
																																																													   
																																																													   $todos[] = array("maximpression" => ($impression),
																																																																  "maxclicks" => ($clicks),
																																																																  "maxconversions" => ($conversions),
																																																																  "maxrevenue" => ($revenue),
																																																																  "maxctr" => ($ctr),
																																																																  "maxecpm" => ($ecpm)); */
			//print_r($data);
			//exit;
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Advertiser All Graph Statistics

$app->get('/get_all_advertiser_campaign_graph_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

			$sql = "select 
		cl.clientid as clientid,
		cl.clientname as clientname,
		CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
		TIMESTAMP(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		round(sum(h.total_revenue),0) as revenue,
		
		round((sum(h.clicks)/sum(h.impressions)),0) * 100 as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
		from
		" . $table_prefix . "data_summary_ad_hourly as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			/* $impressionsarr = array(); 
																																																												   $clicksarr = array(); 
																																																												   $conversionsarr = array(); 
																																																												   $revenuearr = array(); 
																																																												   $ctrarr = array(); 
																																																												   $ecpmarr = array(); 
																																																												   foreach($todos as $todorow => $imrow)
																																																												   {
																																																												   
																																																												   $impressionsarr[$todorow] = $imrow['impressions'];
																																																												   $clicksarr[$todorow] = $imrow['clicks'];
																																																												   $conversionsarr[$todorow] = $imrow['conversions'];
																																																												   $revenuearr[$todorow] = $imrow['revenue'];
																																																												   $ctrarr[$todorow] = $imrow['ctr'];
																																																												   $ecpmarr[$todorow] = $imrow['ecpm'];
																																																												   
																																																												   }
																																																												   $maximpressions = max($impressionsarr);
																																																												   $maxclicks = max($clicksarr);
																																																												   $maxconversions = max($conversionsarr);
																																																												   $maxrevenue = max($revenuearr);
																																																												   $maxctr = max($ctrarr);
																																																												   $maxecpm = max($ecpmarr);

																																																												   // find the key of the impression with the highest value
																																																												   $impression_key = array_search($maximpressions, $impressionsarr);
																																																												   $clicks_key = array_search($maxclicks, $clicksarr);
																																																												   $conversions_key = array_search($maxconversions, $conversionsarr);
																																																												   $revenue_key = array_search($maxrevenue, $revenuearr);
																																																												   $ctr_key = array_search($maxctr, $ctrarr);
																																																												   $ecpm_key = array_search($maxecpm, $ecpmarr);

																																																												   $impression_with_highest_value = $todos[$impression_key];
																																																												   $clicks_with_highest_value = $todos[$clicks_key];
																																																												   $conversions_with_highest_value = $todos[$conversions_key];
																																																												   $revenue_with_highest_value = $todos[$revenue_key];
																																																												   $ctr_with_highest_value = $todos[$ctr_key];
																																																												   $ecpm_with_highest_value = $todos[$ecpm_key];
																																																												   
																																																												   $impression = $impression_with_highest_value['impressions'];
																																																												   $clicks = $clicks_with_highest_value['clicks'];
																																																												   $conversions = $conversions_with_highest_value['conversions'];
																																																												   $revenue = $revenue_with_highest_value['revenue'];
																																																												   $ctr = $ctr_with_highest_value['ctr'];
																																																												   $ecpm = $ecpm_with_highest_value['ecpm'];
																																																													
																																																												   $todos[] = array("maximpression" => ($impression),
																																																															   "maxclicks" => ($clicks),
																																																															   "maxconversions" => ($conversions),
																																																															   "maxrevenue" => ($revenue),
																																																															   "maxctr" => ($ctr),
																																																															   "maxecpm" => ($ecpm));
																																																															   //print_r($data);
																																																												   //exit; */
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Top Banner Statistics

$app->post('/get_top_banner_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY b.bannerid ORDER BY spend DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// top campaign statistics

$app->post('/get_top_campaign_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";
			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY c.campaignid ORDER BY spend DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//All Top Banner

$app->get('/get_all_top_banner_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

			$sql = "select 
		c.campaignname as campaignname,
		b.description as bannername,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as spend,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		" . $table_prefix . "data_summary_ad_hourly as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by b.bannerid ORDER BY spend DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//All Top Campaign 

$app->get('/get_all_top_campaign_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

			$sql = "select 
		c.campaignname as campaignname,
		b.description as bannername,
        DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as spend,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		" . $table_prefix . "data_summary_ad_hourly as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by c.campaignid ORDER BY spend DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Campaign Report Statistics

$app->post('/get_advertiser_campaign_report_statistics/[{advertiser_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// All Advertiser Campaign Statistics

$app->get('/get_all_advertiser_campaign_statistics/[{advertiser_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		if ($client) {

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by b.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();


			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Advertiser Banner Statistics

$app->post('/get_advertiser_banner_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//All Advertiser Banner Statistics

$app->get('/get_all_advertiser_banner_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {
			$sql = "select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		round(sum(h.total_revenue),2) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		b.description as bannername,
		cl.clientid as clientid,		
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
		from
		" . $table_prefix . "data_summary_ad_hourly as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Advertiser Campaignwise Banner Statistics

$app->post('/get_advertiser_campaignwise_banner_statistics/[{advertiser_id},{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];
		$campaign_id = $args['campaign_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';

		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);
			$sth->bindParam(":campaignid", $campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Advertiser All Campaignwise Banner Statistics

$app->get('/get_all_advertiser_campaignwise_banner_statistics/[{advertiser_id},{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$advertiser_id = $args['advertiser_id'];
		$campaign_id = $args['campaign_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';

		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date = date("Y-m-d H:i:s", $Ends);
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);
			$sth->bindParam(":campaignid", $campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Top Country

$app->post('/get_top_country_details/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "campaigns where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $advertiser_id);
		$std->execute();
		$campaign = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($campaign) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND adh.creative_id >= 0";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.country ORDER BY revenue DESC limit 5";

			/* print_r($sql); limit 5
																																																													  exit; */
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();

			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();

				$data[] = array (
					"countryname" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}

			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
			return $this->response->withJson($response);
		}
	}
});


//All Top Country

$app->get('/get_all_top_country_details/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "campaigns where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $advertiser_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if ($campaign) {
			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND adh.creative_id >= 0
			group by adh.country ORDER BY revenue DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();

			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();

				$data[] = array (
					"countryname" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}

			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
			return $this->response->withJson($response);
		}
	}
});


// Geo report api - Advertiser

$app->post('/get_georeport_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			AND adh.creative_id >= 0";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.country,c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// print_r($sql);exit;

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();

			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}


				$newArray = array ();
				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();


					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();


				$data[] = array (
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] : '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					//"conversions"=>$todos[$i]['conversions'],
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
					//"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}


			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//All Geo report api

$app->get('/get_all_georeport_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl, 
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid
			group by adh.country,c.campaignid ";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();

			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {


					$total_revenue = 0;
				}

				$newArray = array ();

				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();


					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();

				$data[] = array (
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] : '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions" => 0,
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($todos[$i]['revenue'] / $todos[$i]['impressions']) * 1000, 2) : 0.00,
					//"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}


			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Geo Report Map API 

$app->post('/get_georeport_map_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($client) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((adh.impressions*c.revenue/1000),2) as rev,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl, 
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiserid";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.country";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			//print_r($sql);exit;
			$country_array = [];

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = [];
			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array ();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					//$todos[$i]['country'] = "";
				}

				if ($icountry) {
					$data[] = array (
						"country" => ($icountry ? $icountry : ''),
						"countrycode" => ($icountrycode ? $icountrycode : ''),
						"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
						"clicks" => $todos[$i]['clicks'],
						"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					);
				}
			}


			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});


// All Geo Report Map API 

$app->get('/get_all_georeport_map_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if ($client) {

			$sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		" . $table_prefix . "stats_country as adh,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "clients as cl, 
		" . $table_prefix . "zones as z 
		where
		adh.creative_id=b.bannerid
		And z.zoneid = adh.zone_id
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// print_r($sql);exit;

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
			$data = array ();
			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array ();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					//$todos[$i]['country'] = "Others";
				}

				if ($icountry) {
					$data[] = array (
						"country" => ($icountry ? $icountry : ''),
						"countrycode" => ($icountrycode ? $icountrycode : ''),
						"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
						"clicks" => $todos[$i]['clicks'],
						"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					);
				}
			}

			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Advertiser Video Statistics

$app->post('/get_advertiser_video_statistics/[{advertiser_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');

		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			$sql1 = '';
			if ($action != "all") {
				$sql1 .= " AND h.interval_start between '" . $start_date . "' AND '" . $end_date . "'";
			}

			$sql = "SELECT IFNULL(SUM(vid.start),0) as start,IFNULL(SUM(vid.midpoint),0) as midpoint,IFNULL(SUM(vid.firstquartile),0) as firstquartile,IFNULL(SUM(vid.thirdquartile),0) as thirdquartile,IFNULL(SUM(vid.complete),0) as complete,IFNULL(SUM(vid.mute),0) as mute,IFNULL(SUM(vid.replay),0) as replay,IFNULL(SUM(vid.fullscreen),0) as fullscreen,IFNULL(SUM(vid.stop),0) as stop,IFNULL(SUM(vid.unmute),0) as unmute,IFNULL(SUM(vid.resume),0) as resume,IFNULL(SUM(vid.paused),0) as paused,vid.bannerid,vid.campaignid,vid.campaignname,vid.description
			FROM
			(
				SELECT
				DATE(vas.interval_start) AS date,vas.bannerid,vas.campaignid,vas.campaignname,vas.description,
				CASE WHEN vast_event_name = 'start' THEN vas.count END AS start,
				CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
				CASE WHEN vast_event_name = 'firstquartile' THEN vas.count END AS firstquartile,
				CASE WHEN vast_event_name = 'thirdquartile' THEN vas.count END AS thirdquartile,
				CASE WHEN vast_event_name = 'complete' THEN vas.count END AS complete,
				CASE WHEN vast_event_name = 'mute' THEN vas.count END AS mute,
				CASE WHEN vast_event_name = 'replay' THEN vas.count END AS replay,
				CASE WHEN vast_event_name = 'fullscreen' THEN vas.count END AS fullscreen,
				CASE WHEN vast_event_name = 'stop' THEN vas.count END AS stop,
				CASE WHEN vast_event_name = 'unmute' THEN vas.count END AS unmute,
				CASE WHEN vast_event_name = 'resume' THEN vas.count END AS resume,
				CASE WHEN vast_event_name = 'paused' THEN vas.count END AS paused
				FROM
				djax_conf_banner_vast_events
				JOIN
				(
				SELECT vast.interval_start,vast.vast_event_id, SUM(vast.count) as count,vast.bannerid,vast.campaignid,vast.campaignname,vast.description
					FROM
					(select 
					h.interval_start,
					h.creative_id,
					h.vast_event_id,
					h.count,
					ev.vast_event_name,
					b.bannerid,
					b.description,
					c.campaignname,
					c.campaignid
					from
					rv_stats_vast as h,
					djax_conf_banner_vast_events as ev,
					" . $table_prefix . "banners as b,
					" . $table_prefix . "campaigns as c,
					" . $table_prefix . "clients as cl 
					where
					h.vast_event_id=ev.vast_event_id
					AND h.creative_id = b.bannerid
					AND c.campaignid = b.campaignid
					AND c.clientid = cl.clientid
					AND cl.clientid = :advertiserid $sql1
					GROUP BY h.vast_event_id,h.creative_id,h.interval_start
					) AS vast
					GROUP BY vast_event_id, creative_id, interval_start
					ORDER BY interval_start, creative_id
				) AS vas ON vas.vast_event_id=djax_conf_banner_vast_events.vast_event_id
			) AS vid";

			//$sql .= " GROUP BY c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			//print_r($todos);

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

/*--------------- End of Advertiser Statistics ------------*/


/*--------------- Start of Publisher Statistics ------------*/


// Geo Report Map API  - publisher

$app->post('/get_georeport_map__publisher_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publisherid) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((adh.impressions*c.revenue/1000),2) as rev,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "affiliates as p
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND p.affiliateid = :publisherid
			AND p.affiliateid = z.affiliateid";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.country";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);

			$sth->execute();

			$todos = $sth->fetchAll();

			// print_r($sql);exit;

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();
			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array ();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					//$todos[$i]['country'] = "Others";
				}
				if ($icountry) {
					$data[] = array (
						"country" => ($icountry ? $icountry : ''),
						"countrycode" => ($icountrycode ? $icountrycode : ''),
						"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
						"clicks" => $todos[$i]['clicks'],
						"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					);
				}
			}


			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// All Geo Report Map API -publisher

$app->get('/get_all_georeport_map__publisher_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publisherid) {

			$sql = "select 
		c.campaignname as campaignname,
		c.revenue as revenues,
		c.revenue_type as revenue_type,
		c.weight,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
		sum(adh.impressions) as impressions,
		sum(adh.clicks) as clicks,
        round((adh.impressions*c.revenue/1000),2) as rev,
		round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
		round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
		from
		" . $table_prefix . "stats_country as adh,
        " . $table_prefix . "banners as b,
        " . $table_prefix . "campaigns as c,
        " . $table_prefix . "zones as z,
        " . $table_prefix . "affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
	    group by adh.country";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);

			$sth->execute();

			$todos = $sth->fetchAll();

			// print_r($sql);exit;

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();
			$newArray = array ();
			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();


					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}
				if ($icountry) {
					$data[] = array (
						"country" => ($icountry ? $icountry : 'Others'),
						"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
						"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
						"clicks" => $todos[$i]['clicks'],
						"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					);
				}
			}


			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Geo Report API - Publisher

$app->post('/get_georeport__publisher_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publisherid) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			z.zonename as zonename,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,	
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm        
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "affiliates as p
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND p.affiliateid = :publisherid
			AND p.affiliateid = z.affiliateid";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.zone_id,adh.country";

			$sth = $this->db->prepare($sql);
			// $sth->bindParam(":affiliateid", $publisherid);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();

			$todos = $sth->fetchAll();

			//print_r($sql);exit;

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");
			$data = array ();
			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}
				//echo $total_revenue; 
				$newArray = array ();

				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();


					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();


				$data[] = array (
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] : '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"zonename" => ($todos[$i]['zonename']) ? $todos[$i]['zonename'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions" => 0,
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
					//"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}

			// echo "data"; 
			// print_r($data);exit;

			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});


//All Geo report API - Publisher


$app->get('/get_all_georeport__publisher_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

			$sql = "select 
        z.zonename as zonename,
        c.revenue as revenues,
        c.revenue_type as revenue_type,
        b.description as bannername, 
        adh.country as country,
        adh.region as region, 
        adh.city as city,
        TIMESTAMP(adh.date_time) as date_time,
        sum(adh.impressions) as impressions,
        sum(adh.clicks) as clicks,
		round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
		when c.revenue_type = 2 then adh.clicks*c.revenue
		else adh.impressions*c.revenue
		end),2) as revenue,
        round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
        round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm        
        from
        " . $table_prefix . "stats_country as adh,
        " . $table_prefix . "banners as b,
        " . $table_prefix . "campaigns as c,
        " . $table_prefix . "zones as z,
        " . $table_prefix . "affiliates as p
        where
        adh.creative_id=b.bannerid
        And z.zoneid = adh.zone_id
        AND c.campaignid = b.campaignid
        AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
	    group by adh.zone_id,adh.country";
			/* print_r($sql);
																																																												   exit; */
			$sth = $this->db->prepare($sql);
			// $sth->bindParam(":affiliateid", $publisherid);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();

			$todos = $sth->fetchAll();

			//print_r($sql);exit;

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();

			$newArray = array ();

			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['conversions'] * $todos[$i]['revenues'];
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();


					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();

				$data[] = array (
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] : '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"zonename" => ($todos[$i]['zonename']) ? $todos[$i]['zonename'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"conversions" => 0,
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
					//"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}
			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Publisher Zone Statistics

$app->post('/get_publisher_zone_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY h.zone_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

// All Publisher Zone Statistics

$app->get('/get_all_publisher_zone_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by h.zone_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//Publisher Top Zone Statistics - Revenue

$app->post('/get_publisher_top_zone_revenue/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY h.zone_id ORDER BY spend DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});


// Publisher Top Zone Statistics - ctr

$app->post('/get_publisher_top_zone_ctr_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY h.zone_id ORDER BY ctr DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

// All top zone
$app->get('/get_all_publisher_top_zone_revenue/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by z.zoneid ORDER BY spend DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

// All publisher top zone - ctr

$app->get('/get_all_publisher_top_zone_ctr_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id  
		    group by z.zoneid ORDER BY ctr DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

// Publisher Top Country

$app->post('/get_publisher_top_country_details/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisher_id = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisher_id);
		$std->execute();
		$campaign = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($campaign) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			$sql = "select 		
			co.country_name as countryname,
			c.campaignname as campaignname,
			round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
				 when c.revenue_type = 2 then h.clicks*c.revenue
				 else h.impressions*c.revenue
				 end),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks
			from
			" . $table_prefix . "stats_country as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			da_country as co
			where
			h.creative_id=b.bannerid
			And z.zoneid = h.zone_id
			And c.campaignid = b.campaignid
			AND p.affiliateid = :publisherid
			AND co.counrty_code = h.country
			AND p.affiliateid = z.affiliateid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY co.country_name ORDER BY ctr DESC limit 5";

			/* print_r($sql); 
																																																													  exit; */

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisher_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//All Publisher Top Country

$app->get('/get_all_publisher_top_country_details/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisher_id = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisher_id);
		$std->execute();
		$campaign = $std->fetchAll();

		if ($campaign) {
			$sql = "select 		
		co.country_name as countryname,
		c.campaignname as campaignname,
		round((case when  c.revenue_type = 1 then h.impressions*c.revenue/1000 
             when c.revenue_type = 2 then h.clicks*c.revenue
             else h.impressions*c.revenue
             end),2) as revenue,
		round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks
		from
		" . $table_prefix . "stats_country as h,
		" . $table_prefix . "banners as b,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "affiliates as p,
		" . $table_prefix . "zones as z,
        da_country as co
		where
		h.creative_id=b.bannerid
		And z.zoneid = h.zone_id
		And c.campaignid = b.campaignid
		AND co.counrty_code = h.country
		AND p.affiliateid = :publisherid
		AND p.affiliateid = z.affiliateid
		group by co.country_name ORDER BY ctr DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisher_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Publisher Website Statistics

$app->post('/get_publisher_website_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY p.affiliateid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//All Publisher Website Statistics

$app->get('/get_all_publisher_website_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			group by p.affiliateid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//Publisher Zone Chart Statistics

$app->post('/get_publisher_zone_chart_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			CONCAT(SUBSTRING(z.zonename FROM 1 FOR 4),'-',z.zoneid) as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY h.zone_id";

			// echo "sql";
			// print_r($sql);exit;
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//All Publisher Zone Chart Statistics

$app->get('/get_all_publisher_zone_chart_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as revenue,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.pub_income)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			CONCAT(SUBSTRING(z.zonename FROM 1 FOR 4),'-',z.zoneid) as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			group by h.zone_id";

			/* echo "sql";
																																																												   print_r($sql);
																																																												   exit; */

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//publisher total counts 

$app->post('/get_publisher_widget_count_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.pub_income) as revenue,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY p.affiliateid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});


//All publisher widget counts statistics


$app->get('/get_all_publisher_widget_count_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {

			$sql = "select
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.requests) as requests,
		sum(h.pub_income) as revenue,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
		p.affiliateid as affiliateid,
		p.name as affiliatename
		from
		" . $table_prefix . "data_summary_ad_hourly as h,
		" . $table_prefix . "affiliates as p,
		" . $table_prefix . "zones as z
		where
		p.affiliateid = :publisherid
		and p.affiliateid=z.affiliateid
		AND z.zoneid = h.zone_id
		group by p.affiliateid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

// Publisher Widgets Statistics

$app->get('/get_publisher_widgets_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date = date("Y-m-d H:i:s", $Ends);

			$sql = "select 			
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.pub_income) as revenue,			
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND h.date_time between '" . $start_date . "'
			AND '" . $end_date . "' group by clientid";

			/* echo "query";
																																																													  print_r($sql);exit; */
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

// All Publisher Widgets Statistics

$app->get('/get_all_publisher_widgets_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 			
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			sum(h.pub_income) as revenue,			
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.pub_income)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			group by clientid";


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//Publisher Top Banner Statistics

$app->get('/get_top_publisher_banner_statistics/[{start_date},{end_date},{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$startdate = $args['start_date'];
		$enddate = $args['end_date'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			$Starts = strtotime($startdate);
			$Ends = strtotime($enddate);
			date_default_timezone_set("UTC");
			$start_date = date("Y-m-d H:i:s", $Starts);
			$end_date = date("Y-m-d H:i:s", $Ends);

			$sql = "select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,	
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.pub_income)/sum(h.impressions))*1000,2) as ecpm,
			b.description as bannername
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			And p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND h.date_time between '" . $start_date . "'
			AND '" . $end_date . "' group by h.ad_id ORDER BY spend DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('datevalidation'));

//All Publisher Top Banner Statistics

$app->get('/get_all_top_publisher_banner_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		if ($publishers) {
			$sql = "select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.pub_income),2) as spend,	
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.pub_income)/sum(h.impressions))*1000,2) as ecpm,
			b.description as bannername
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			group by h.ad_id ORDER BY spend DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

// Publisher Video Statistics

$app->post('/get_publisher_video_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql1 = '';
			if ($action != "all") {
				$sql1 .= " AND h.interval_start between '" . $start_date . "' AND '" . $end_date . "'";
			}

			$sql = "SELECT IFNULL(SUM(vid.start),0) as start,IFNULL(SUM(vid.midpoint),0) as midpoint,IFNULL(SUM(vid.firstquartile),0) as firstquartile,IFNULL(SUM(vid.thirdquartile),0) as thirdquartile,IFNULL(SUM(vid.complete),0) as complete,IFNULL(SUM(vid.mute),0) as mute,IFNULL(SUM(vid.replay),0) as replay,IFNULL(SUM(vid.fullscreen),0) as fullscreen,IFNULL(SUM(vid.stop),0) as stop,IFNULL(SUM(vid.unmute),0) as unmute,IFNULL(SUM(vid.resume),0) as resume,IFNULL(SUM(vid.paused),0) as paused,vid.zoneid,vid.zonename,vid.affiliateid,vid.name
			FROM
			(
				SELECT
				DATE(vas.interval_start) AS date,vas.zoneid,vas.zonename,vas.affiliateid,vas.name,
				CASE WHEN vast_event_name = 'start' THEN vas.count END AS start,
				CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
				CASE WHEN vast_event_name = 'firstquartile' THEN vas.count END AS firstquartile,
				CASE WHEN vast_event_name = 'thirdquartile' THEN vas.count END AS thirdquartile,
				CASE WHEN vast_event_name = 'complete' THEN vas.count END AS complete,
				CASE WHEN vast_event_name = 'mute' THEN vas.count END AS mute,
				CASE WHEN vast_event_name = 'replay' THEN vas.count END AS replay,
				CASE WHEN vast_event_name = 'fullscreen' THEN vas.count END AS fullscreen,
				CASE WHEN vast_event_name = 'stop' THEN vas.count END AS stop,
				CASE WHEN vast_event_name = 'unmute' THEN vas.count END AS unmute,
				CASE WHEN vast_event_name = 'resume' THEN vas.count END AS resume,
				CASE WHEN vast_event_name = 'paused' THEN vas.count END AS paused
				FROM
				djax_conf_banner_vast_events
				JOIN
				(
				SELECT vast.interval_start,vast.vast_event_id, SUM(vast.count) as count,vast.zoneid,vast.zonename,vast.affiliateid,vast.name
					FROM
					(select 
					h.interval_start,
					h.creative_id,
					h.vast_event_id,
					h.count,
					ev.vast_event_name,
					zo.zoneid,
					zo.zonename,
					af.name,
					af.affiliateid
					from
					" . $table_prefix . "stats_vast as h,
					djax_conf_banner_vast_events as ev,
					" . $table_prefix . "affiliates as af,
					" . $table_prefix . "zones as zo 
					where
					h.vast_event_id=ev.vast_event_id
					AND h.zone_id = zo.zoneid
					AND zo.affiliateid = af.affiliateid
					AND af.affiliateid = :publisherid $sql1
					GROUP BY h.vast_event_id,h.zone_id,h.interval_start
					) AS vast
					GROUP BY vast_event_id, zoneid, interval_start
					ORDER BY interval_start, zoneid
				) AS vas ON vas.vast_event_id=djax_conf_banner_vast_events.vast_event_id
			) AS vid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

/*--------------- End of Publisher Statistics ------------*/

/*--------------- Start of Agency Statistics ------------*/

//Agency Graph Statistics

$app->post('/get_agency_campaign_graph_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');

		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$agency = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($agency) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			CONCAT(SUBSTRING(c.campaignname FROM 1 FOR 4),'-',c.campaignid) as campaignname,
			TIMESTAMP(h.date_time) as date_time,
			DATE(h.date_time) as date,
			sum(h.impressions) as impressions,
			sum(h.views) as views,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),0) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,0) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,0) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND h.impressions != 0
			AND ag.agencyid = :agencyid";
			//AND h.clicks != 0 AND h.impressions != 0
			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY DATE(h.date_time)";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

// Get Agency campaign Statistics

$app->post('/get_agency_campaign_statistics/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientid as clientid,
			(SELECT count(clientid) FROM " . $table_prefix . "clients where agencyid=:agencyid) as advertisercount,
			(SELECT count(affiliateid) FROM " . $table_prefix . "affiliates where agencyid=:agencyid) as websitecount,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.views) as views,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag  
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			//$sql .= " GROUP BY c.campaignid";


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();


			$todos = $sth->fetchAll();

			if ($todos) {
				if (!empty ($todos[0]['ad_id'])) {
					return $this->response->withJson($todos);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

// Get Agency campaign Statistics

$app->post('/get_agency_advertiser_website_statistics/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			(SELECT count(clientid) FROM " . $table_prefix . "clients where agencyid=:agencyid) as advertisercount,
			(SELECT count(affiliateid) FROM " . $table_prefix . "affiliates where agencyid=:agencyid) as websitecount,
			(SELECT count(id) FROM " . $table_prefix . "publishers where agency_id=:agencyid) as publishercount,
			ag.agencyid
			from
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as af,
            " . $table_prefix . "agency as ag  
			where
			cl.agencyid = ag.agencyid
			And af.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";

			/* if($action !="all") 
																																																													  {			
																																																														  $sql .= " AND h.date_time between '".$start_date."' AND '".$end_date."'";
																																																													  } */
			$sql .= " GROUP BY ag.agencyid";


			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();


			$todos = $sth->fetchAll();

			if ($todos) {
				if (!empty ($todos[0]['agencyid'])) {
					return $this->response->withJson($todos);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency top campaign statistics

$app->post('/get_agency_top_advertiser_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "clients where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientname as clientname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm,	
			round((Sum(h.clicks)/sum(h.impressions))*100,2) as ctr	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";
			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY cl.clientid ORDER BY impressions DESC limit 5";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Top Banner Statistics

$app->post('/get_agency_top_website_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "clients where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			af.name as websitename,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as spend,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm,
			round((Sum(h.clicks)/sum(h.impressions))*100,2) as ctr
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as af,
			" . $table_prefix . "zones as zo,
            " . $table_prefix . "agency as ag 
			where
			h.zone_id = zo.zoneid
			And zo.affiliateid = af.affiliateid
			And af.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY af.affiliateid ORDER BY impressions DESC limit 5";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Top Country

$app->post('/get_agency_top_country_details/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agencyid";
		$std = $this->db->prepare($stc);
		$std->bindParam("agencyid", $agency_id);
		$std->execute();
		$agency = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($agency) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as af,
            " . $table_prefix . "agency as ag,
			" . $table_prefix . "zones as z 
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			And af.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid
			AND adh.creative_id >= 0";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.country ORDER BY revenue DESC limit 5";

			/* print_r($sql); limit 5
																																																													  exit; */
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();

			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();

				$data[] = array (
					"countryname" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					"revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}

			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
			return $this->response->withJson($response);
		}
	}
});

//Agency Avertiser Statistics
$app->get('/get_advertiser_statistics/[{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$agency_id = $args['agencyid'];

		$stc = "SELECT clientid,agencyid,clientname,contact,email FROM " . $table_prefix . "clients where agencyid =:agencyid";

		$std = $this->db->prepare($stc);
		$std->bindParam("agencyid", $agency_id);
		$std->execute();
		$users = $std->fetchAll();

		if ($users) {
			foreach ($users as $adv) { //$adv['clientid']
				$adv_list[] = $adv;
			}
			$response = array ('data' => $adv_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency id!');
			return $this->response->withJson($response);
		}
	}
});

//Agency Campaign Report Statistics

$app->post('/get_agency_campaign_report_statistics/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			c.Booked_impression as booked_imp,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Clientwise Campaign Report Statistics

$app->post('/get_agency_clientwise_campaign_report_statistics/[{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$client_id = $args['client_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $client_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			c.Booked_impression as booked_imp,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			format((sum(h.views)/sum(h.impressions) *100),2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND cl.clientid = :clientid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":clientid", $client_id);
			//print_r($sth);exit("ok");
			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Banner Statistics

$app->post('/get_agency_banner_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.views) as views,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as af,
            " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			And cl.agencyid = ag.agencyid
			And af.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Campaignwise Banner Statistics

$app->post('/get_agency_campaignwise_banner_statistics/[{advertiser_id},{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];
		$campaign_id = $args['campaign_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';

		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			And cl.agencyid = ag.agencyid";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);
			$sth->bindParam(":campaignid", $campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Geo report api - Advertiser

$app->post('/get_agency_georeport_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((case when  c.revenue_type = 1 then adh.impressions*c.revenue/1000 
			when c.revenue_type = 2 then adh.clicks*c.revenue
			else adh.impressions*c.revenue
			end),2) as revenue,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "affiliates as af,
            " . $table_prefix . "agency as ag
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			And af.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid
			AND adh.creative_id >= 0";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.country,c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// print_r($sql);exit;

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = array ();

			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}


				$newArray = array ();
				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();


					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					$todos[$i]['country'] = "Others";
				}

				//print_r($newArray);die();


				$data[] = array (
					"country" => ($icountry ? $icountry : 'Others'),
					"countrycode" => ($icountrycode ? $icountrycode : 'Others'),
					"region" => ($newArray) ? $newArray[$key2] : '-',
					"city" => ($todos[$i]['city']) ? $todos[$i]['city'] : '-',
					"campaignname" => ($todos[$i]['campaignname']) ? $todos[$i]['campaignname'] : '-',
					//"bannername" => ($todos[$i]['bannername']) ? $todos[$i]['bannername'] : '-',
					//"request"=>$row['requests'],
					"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					"clicks" => $todos[$i]['clicks'],
					//"conversions"=>$todos[$i]['conversions'],
					"ctr" => ($todos[$i]['impressions'] > 0) ? round($todos[$i]['clicks'] / $todos[$i]['impressions'] * 100, 2) : 0.00,
					"ecpm" => ($todos[$i]['impressions'] > 0) ? round(($total_revenue / $todos[$i]['impressions']) * 1000, 2) : 0.00,
					//"pub_income" => $pub_income,
					"total_revenue" => ($todos[$i]['revenue'] > 0) ? $todos[$i]['revenue'] : 0.00,
				);
			}


			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

// Geo Report Map API 

$app->post('/get_agency_georeport_map_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them AND c.clientid = cl.clientid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($client) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
			c.campaignname as campaignname,
			c.revenue as revenues,
			c.revenue_type as revenue_type,
			c.weight,
			b.description as bannername, 
			adh.country as country,
			adh.region as region, 
			adh.city as city,
			TIMESTAMP(adh.date_time) as date_time,
			sum(adh.impressions) as impressions,
			sum(adh.clicks) as clicks,
			round((adh.impressions*c.revenue/1000),2) as rev,
			round((sum(adh.clicks)/sum(adh.impressions)) * 100,2) as ctr,
			round((sum(adh.impressions*c.revenue/1000)/sum(adh.impressions))*1000,2) as ecpm		
			from
			" . $table_prefix . "stats_country as adh,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl, 
			" . $table_prefix . "zones as z,
			" . $table_prefix . "affiliates as af,
            " . $table_prefix . "agency as ag
			where
			adh.creative_id=b.bannerid
			And z.zoneid = adh.zone_id
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			And af.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";

			if ($action != "all") {
				$sql .= " AND adh.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY adh.country";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			//print_r($sql);exit;
			$country_array = [];

			$country_array = array ("AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "BQ" => "British Antarctic Territory", "IO" => "British Indian Ocean Territory", "VG" => "British Virgin Islands", "BN" => "Brunei", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "CT" => "Canton and Enderbury Islands", "CV" => "Cape Verde", "KY" => "Cayman Islands", "CF" => "Central African Republic", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos [Keeling] Islands", "CO" => "Colombia", "KM" => "Comoros", "CG" => "Congo - Brazzaville", "CD" => "Congo - Kinshasa", "CK" => "Cook Islands", "CR" => "Costa Rica", "HR" => "Croatia", "CU" => "Cuba", "CY" => "Cyprus", "CZ" => "Czech Republic", "CI" => "Côte d’Ivoire", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic", "NQ" => "Dronning Maud Land", "DD" => "East Germany", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "ET" => "Ethiopia", "FK" => "Falkland Islands", "FO" => "Faroe Islands", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories", "FQ" => "French Southern and Antarctic Territories", "GA" => "Gabon", "GM" => "Gambia", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "HN" => "Honduras", "HK" => "Hong Kong SAR China", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JT" => "Johnston Island", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Laos", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macau SAR China", "MK" => "Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "FX" => "Metropolitan France", "MX" => "Mexico", "FM" => "Micronesia", "MI" => "Midway Islands", "MD" => "Moldova", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar [Burma]", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands", "AN" => "Netherlands Antilles", "NT" => "Neutral Zone", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "KP" => "North Korea", "VD" => "North Vietnam", "MP" => "Northern Mariana Islands", "NO" => "Norway", "OM" => "Oman", "PC" => "Pacific Islands Trust Territory", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestinian Territories", "PA" => "Panama", "PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea", "PY" => "Paraguay", "YD" => "People's Democratic Republic of Yemen", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn Islands", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RO" => "Romania", "RU" => "Russia", "RW" => "Rwanda", "RE" => "Réunion", "BL" => "Saint Barthélemy", "SH" => "Saint Helena", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "CS" => "Serbia and Montenegro", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "KR" => "South Korea", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SZ" => "Swaziland", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syria", "ST" => "São Tomé and Príncipe", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TC" => "Turks and Caicos Islands", "TV" => "Tuvalu", "UM" => "U.S. Minor Outlying Islands", "PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands", "UG" => "Uganda", "UA" => "Ukraine", "SU" => "Union of Soviet Socialist Republics", "AE" => "United Arab Emirates", "GB" => "United Kingdom", "US" => "United States", "ZZ" => "Unknown or Invalid Region", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VA" => "Vatican City", "VE" => "Venezuela", "VN" => "Vietnam", "WK" => "Wake Island", "WF" => "Wallis and Futuna", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe", "AX" => "Åland Islands");

			$data = [];
			for ($i = 0; $i < count($todos); $i++) {

				if ($todos[$i]['revenue_type'] == 1) {

					//$pub_income = $todos[$i]['impressions'] * $todos[$i]['pub_cpm'] / 1000;
					$total_revenue = $todos[$i]['impressions'] * $todos[$i]['revenues'] / 1000;
				} else if ($todos[$i]['revenue_type'] == 2) {

					//$pub_income = $todos[$i]['clicks'] * $todos[$i]['pub_cpm'];
					$total_revenue = $todos[$i]['clicks'] * $todos[$i]['revenues'];
				} else if ($todos[$i]['revenue_type'] == 3) {

					//$pub_income = $todos[$i]['conversions'] * $todos[$i]['pub_cpm'];
					$total_revenue = 0;
				}



				if ($todos[$i]['region']) {
					$code = $todos[$i]['country'] . '-' . $todos[$i]['region'];

					$region_query = ("select subdivision_name as region from rv_region where country_code='" . $todos[$i]['country'] . "' AND code='" . $code . "'");

					$sth = $this->db->prepare($region_query);
					$sth->execute();

					$region_query = $sth->fetchAll();

					$newArray = array ();
					foreach ($region_query as $key => $value) {
						foreach ($value as $key2 => $value2) {
							$newArray[$key2] = $value2;
						}
					}
				}

				$icountry = '';
				$icountrycode = '';

				if ($todos[$i]['country'] != "-") {
					$icountrycode = $todos[$i]['country'] ? $todos[$i]['country'] : "";
					$icountry = $todos[$i]['country'] ? $country_array[$todos[$i]['country']] : "";
				} else {

					//$todos[$i]['country'] = "";
				}

				if ($icountry) {
					$data[] = array (
						"country" => ($icountry ? $icountry : ''),
						"countrycode" => ($icountrycode ? $icountrycode : ''),
						"impressions" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
						"clicks" => $todos[$i]['clicks'],
						"value" => ($todos[$i]['impressions']) ? $todos[$i]['impressions'] : 0,
					);
				}
			}


			if ($data) {
				return $this->response->withJson($data);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
			//}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Video Statistics

$app->post('/get_agency_video_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');

		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			$sql1 = '';
			if ($action != "all") {
				$sql1 .= " AND h.interval_start between '" . $start_date . "' AND '" . $end_date . "'";
			}

			$sql = "SELECT IFNULL(SUM(vid.start),0) as start,IFNULL(SUM(vid.midpoint),0) as midpoint,IFNULL(SUM(vid.firstquartile),0) as firstquartile,IFNULL(SUM(vid.thirdquartile),0) as thirdquartile,IFNULL(SUM(vid.complete),0) as complete,IFNULL(SUM(vid.mute),0) as mute,IFNULL(SUM(vid.replay),0) as replay,IFNULL(SUM(vid.fullscreen),0) as fullscreen,IFNULL(SUM(vid.stop),0) as stop,IFNULL(SUM(vid.unmute),0) as unmute,IFNULL(SUM(vid.resume),0) as resume,IFNULL(SUM(vid.paused),0) as paused,vid.bannerid,vid.campaignid,vid.campaignname,vid.description
			FROM
			(
				SELECT
				DATE(vas.interval_start) AS date,vas.bannerid,vas.campaignid,vas.campaignname,vas.description,
				CASE WHEN vast_event_name = 'start' THEN vas.count END AS start,
				CASE WHEN vast_event_name = 'midpoint' THEN vas.count END AS midpoint,
				CASE WHEN vast_event_name = 'firstquartile' THEN vas.count END AS firstquartile,
				CASE WHEN vast_event_name = 'thirdquartile' THEN vas.count END AS thirdquartile,
				CASE WHEN vast_event_name = 'complete' THEN vas.count END AS complete,
				CASE WHEN vast_event_name = 'mute' THEN vas.count END AS mute,
				CASE WHEN vast_event_name = 'replay' THEN vas.count END AS replay,
				CASE WHEN vast_event_name = 'fullscreen' THEN vas.count END AS fullscreen,
				CASE WHEN vast_event_name = 'stop' THEN vas.count END AS stop,
				CASE WHEN vast_event_name = 'unmute' THEN vas.count END AS unmute,
				CASE WHEN vast_event_name = 'resume' THEN vas.count END AS resume,
				CASE WHEN vast_event_name = 'paused' THEN vas.count END AS paused
				FROM
				djax_conf_banner_vast_events
				JOIN
				(
				SELECT vast.interval_start,vast.vast_event_id, SUM(vast.count) as count,vast.bannerid,vast.campaignid,vast.campaignname,vast.description
					FROM
					(select 
					h.interval_start,
					h.creative_id,
					h.vast_event_id,
					h.count,
					ev.vast_event_name,
					b.bannerid,
					b.description,
					c.campaignname,
					c.campaignid
					from
					rv_stats_vast as h,
					djax_conf_banner_vast_events as ev,
					" . $table_prefix . "banners as b,
					" . $table_prefix . "campaigns as c,
					" . $table_prefix . "clients as cl,
					" . $table_prefix . "affiliates as af,
                    " . $table_prefix . "agency as ag
					where
					h.vast_event_id=ev.vast_event_id
					AND h.creative_id = b.bannerid
					AND c.campaignid = b.campaignid
					AND c.clientid = cl.clientid
					And cl.agencyid = ag.agencyid
			        And af.agencyid = ag.agencyid
					AND ag.agencyid = :agencyid $sql1
					GROUP BY h.vast_event_id,h.creative_id,h.interval_start
					) AS vast
					GROUP BY vast_event_id, creative_id, interval_start
					ORDER BY interval_start, creative_id
				) AS vas ON vas.vast_event_id=djax_conf_banner_vast_events.vast_event_id
			) AS vid";

			//$sql .= " GROUP BY c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			//print_r($todos);

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

$app->get('/get_all_advertiser/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$agency_id = $args['agency_id'];
		$stc = "SELECT * FROM " . $table_prefix . "clients where agencyid =:agency_id Order by updated Desc";

		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$users = $std->fetchAll();

		if ($users) {
			foreach ($users as $adv) { //$adv['clientid']
				$adv_list[] = $adv;
			}
			$response = array ('data' => $adv_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency id!');
			return $this->response->withJson($response);
		}
	}
});

$app->get('/get_all_campaigns/[{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$clientid = $args['client_id'];

		$clients = "SELECT * FROM " . $table_prefix . "clients where clientid =:clientid";
		$stc = $this->db->prepare($clients);
		$stc->bindParam("clientid", $clientid);
		$stc->execute();
		$client_det = $stc->fetchAll();
		if ($client_det) {
			$stc = "SELECT campaignid,campaignname,clientid,views,clicks,conversions,priority,weight,anonymous,companion,revenue,revenue_type,DATE_FORMAT(updated,'%d-%m-%Y %h:%i:%s') as updated,status,activate_time,expire_time FROM " . $table_prefix . "campaigns where clientid=:clientid";
			$std = $this->db->prepare($stc);
			$std->bindParam("clientid", $clientid);
			$std->execute();
			$campaign_det = $std->fetchAll();
			$datetime = date('Y-m-d H:i:s');

			if (count($campaign_det) > 0) {
				if ($campaign_det) {
					$response = array ('data' => $campaign_det, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Data');
					return $this->response->withJson($response);
				}
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'No campaigns available for this clientid!'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Client Id!',
				'statuscode' => '200'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('clientid_val'));

//Campaign Website Distribution
$app->post('/get_website_distribution/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$campaign_id = $args['campaign_id'];

		$stc = "select * from " . $table_prefix . "campaigns where campaignid=:campaign_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaign_id", $campaign_id);
		$std->execute();
		$campaign = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($campaign) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = " select af.name as website,
            af.affiliateid as website_id,
            cl.clientname as client_name,
			cl.notification_emails as notification_emails,
            p.name as publisher_name,
			p.email as publisher_email,
            ag.name as agency_name,
			c.booked_impression,
			DATE_FORMAT(c.expire_time,'%d-%m-%Y') as expire_time,
			b.campaignid as campaignid,
			h.ad_id as ad_id,
            c.campaignname as campaign_name,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "affiliates as af,
            " . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag,
             " . $table_prefix . "publishers as p

			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
            AND c.clientid = cl.clientid
            AND cl.agencyid =ag.agencyid
			AND af.agencyid = ag.agencyid
            AND af.publisher_id = p.id
            AND p.agency_id= ag.agencyid
			AND h.zone_id = z.zoneid
			AND z.affiliateid = af.affiliateid
			AND c.campaignid=:campaign_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY af.affiliateid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaign_id", $campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();

			// print_r($todos); exit('ok');
			if ($todos) {
				$response = array ('response' => 'ok', 'data' => $todos, 'msg' => 'statistics fetched successfully!');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid campaign Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Website Distribution
$app->post('/get_agency_website_distribution/[{client_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$client_id = $args['client_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $client_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($action != "all") {
				$sql = "select af.name as website,
            af.affiliateid as website_id,
            cl.clientname as client_name,
			cl.notification_emails as notification_emails,
            p.name as publisher_name,
			p.email as publisher_email,
            ag.name as agency_name,
			c.booked_impression,
			DATE_FORMAT(c.expire_time,'%d-%m-%Y') as expire_time,
			b.campaignid as campaignid,
			h.ad_id as ad_id,
            c.campaignname as campaign_name,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "affiliates as af,
            " . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag,
            " . $table_prefix . "publishers as p

			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
            AND c.clientid = cl.clientid
            AND cl.agencyid =ag.agencyid
			AND af.agencyid = ag.agencyid
            AND af.publisher_id = p.id
            AND p.agency_id= ag.agencyid
			AND h.zone_id = z.zoneid
			AND z.affiliateid = af.affiliateid
			AND cl.clientid=:client_id";
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select af.name as website,
				af.affiliateid as website_id,
				cl.clientname as client_name,
				cl.notification_emails as notification_emails,
				p.name as publisher_name,
				p.email as publisher_email,
				ag.name as agency_name,
				c.booked_impression,
				DATE_FORMAT(c.expire_time,'%d-%m-%Y') as expire_time,
				b.campaignid as campaignid,
				h.ad_id as ad_id,
				c.campaignname as campaign_name,
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.views) as views,
				(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.device_type='Mobile') as mobile_impression,
            	(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.device_type='Desktop') as desktop_impression,
				sum(h.conversions) as conversions,
				sum(h.requests) as requests,
				round(sum(h.total_revenue),2) as revenue,
				round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
				round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
				from
				" . $table_prefix . "data_summary_ad_hourly as h,
				" . $table_prefix . "banners as b,
				" . $table_prefix . "campaigns as c,
				" . $table_prefix . "zones as z,
				" . $table_prefix . "affiliates as af,
				" . $table_prefix . "clients as cl,
				" . $table_prefix . "agency as ag,
				" . $table_prefix . "publishers as p
	
				where
				h.ad_id = b.bannerid
				AND c.campaignid = b.campaignid
				AND c.clientid = cl.clientid
				AND cl.agencyid =ag.agencyid
				AND af.agencyid = ag.agencyid
				AND af.publisher_id = p.id
				AND p.agency_id= ag.agencyid
				AND h.zone_id = z.zoneid
				AND z.affiliateid = af.affiliateid
				AND cl.clientid=:client_id";
			}
			$sql .= " GROUP BY c.campaignid, af.affiliateid, h.ad_id ORDER BY c.campaignid, p.id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":client_id", $client_id);
			$sth->execute();
			$todos = $sth->fetchAll();

			$newarray = array ();
			$publisher = $publisher_email = $website = '';
			$impr = $viewable = $clicks = $mobile_imp = $desktop_imp = 0;

			foreach ($todos as $key => $value) {
				if ($key == 0) {
					$camp1 = $value['campaignid'];
					$publisher1 = $value['publisher_name'];
					$publisher_email1 = $value['publisher_email'];
				}
				$camp = $value['campaignid'];
				if ($camp1 != $camp) {
					$camp1 = $camp;
					$publisher = $publisher_email = $website = '';
					$impr = $viewable = $clicks = $mobile_imp = $desktop_imp = 0;
					// $publisher = $value['publisher_name'];
					// $publisher_email = $value['publisher_email'];
					// $website = $value['website'];
					$impr = $impr + $value['impressions'];
					$viewable = $viewable + $value['views'];
					$clicks = $clicks + $value['clicks'];
					$mobile_imp = $mobile_imp + $value['mobile_impression'];
					$desktop_imp = $desktop_imp + $value['desktop_impression'];
					if ($publisher1 != $value['publisher_name']) {
						$publisher .= $value['publisher_name'] . ',';
						$publisher1 = $value['publisher_name'];
					} else {
						$publisher = $value['publisher_name'] . ',';
						$publisher1 = $value['publisher_name'];
					}
					if ($publisher_email1 != $value['publisher_email']) {
						$publisher_email .= $value['publisher_email'] . ',';
						$publisher_email1 = $value['publisher_email'];
					} else {
						$publisher_email = $value['publisher_email'] . ',';
						$publisher_email1 = $value['publisher_email'];
					}
					$website .= ($website == $value['website']) ? $value['website'] : $value['website'] . ',';
				} else {
					$impr = $impr + $value['impressions'];
					$viewable = $viewable + $value['views'];
					$clicks = $clicks + $value['clicks'];
					$mobile_imp = $mobile_imp + $value['mobile_impression'];
					$desktop_imp = $desktop_imp + $value['desktop_impression'];
					if ($publisher1 != $value['publisher_name']) {
						$publisher .= $value['publisher_name'] . ',';
						$publisher1 = $value['publisher_name'];
					} else {
						$publisher = $value['publisher_name'] . ',';
						$publisher1 = $value['publisher_name'];
					}
					if ($publisher_email1 != $value['publisher_email']) {
						$publisher_email .= $value['publisher_email'] . ',';
						$publisher_email1 = $value['publisher_email'];
					} else {
						$publisher_email = $value['publisher_email'] . ',';
						$publisher_email1 = $value['publisher_email'];
					}
					$website .= ($website == $value['website']) ? $value['website'] : $value['website'] . ',';
				}
				$newarray[$camp] = array ('website' => rtrim($website, ','), 'client_name' => $value['client_name'], 'notification_emails' => $value['notification_emails'], 'publisher_name' => rtrim($publisher, ','), 'publisher_email' => rtrim($publisher_email, ','), 'agency_name' => $value['agency_name'], 'booked_impression' => $value['booked_impression'], 'expire_time' => $value['expire_time'], 'campaignid' => $camp, 'campaign_name' => $value['campaign_name'], 'impressions' => $impr, 'clicks' => $clicks, 'views' => $viewable, 'mobileviews' => $mobile_imp, 'desktopviews' => $desktop_imp);
			}

			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}
			// print_r($result_array);
			// exit('ok');
			// print_r($result_array); exit('hello');
			if ($todos) {
				$response = array ('response' => 'ok', 'data' => $result_array, 'msg' => 'statistics fetched successfully!');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid client Id');
			return $this->response->withJson($response);
		}
	}
});


$app->post('/get_agency_statistics/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}


			$sql = "select 
            cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			c.Booked_impression as booked_imp,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
           " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND c.campaignid = b.campaignid
			AND c.clientid = cl.clientid
            AND cl.agencyid = ag.agencyid
            AND ag.agencyid = $agency_id";


			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			//$sql .= " GROUP BY clientid";
			$sql .= " GROUP BY clientid, c.campaignid";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();

			$newarray = array ();
			$booked = $impr = $views = $clicks = $conversions = $total_revenue = 0;
			foreach ($todos as $key => $value) {

				if ($key == 0) {
					$clientid1 = $value['clientid'];
				}

				$clientid = $value['clientid'];
				if ($clientid1 != $clientid) {
					$clientid1 = $clientid;
					$booked = $impr = $views = $clicks = $conversions = $total_revenue = 0;
				}
				//$booked += $value['booked_imp'];
				$impr += $value['impressions'];
				$views += $value['views'];
				$clicks += $value['clicks'];
				$conversions += $value['conversions'];
				$total_revenue += $value['revenue'];
				//$view_imp = $value['views']/$impr*1000;
				if ($views != '' || $impr != '' || $clicks != '' || $total_revenue != '') {
					$viewableimpressionrate = $views / $impr * 100;
					$ctr = $clicks / $impr * 100;
					$ecpm = $total_revenue / $impr * 1000;
					$newarray[$clientid] = array ('clientid' => $value['clientid'], 'clientname' => $value['clientname'], 'ad_id' => $value['ad_id'], 'impressions' => $impr, 'booked_imp' => $value['booked_imp'], 'clicks' => $clicks, 'views' => $views, 'conversions' => $conversions, 'revenue' => $total_revenue, 'viewable_imp_rate' => $viewableimpressionrate, 'ctr' => $ctr, 'ecpm' => $ecpm);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}

				$viewableimpressionrate = $views / $impr * 100;
				$ctr = $clicks / $impr * 100;
				$ecpm = $total_revenue / $impr * 1000;

				//print_r($viewableimpressionrate); exit('ok');

			}
			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}



			if ($todos) {

				if (!empty ($todos[0]['ad_id'])) {
					return $this->response->withJson($result_array);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Global Statistics

$app->post('/get_agency_global_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "clients where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			DATE(h.date_time) as date,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			ag.agencyid=:agencyid
			AND p.agencyid = ag.agencyid
			AND p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY date";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Publisher Statistics

$app->post('/get_agency_publisher_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "affiliates where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			DATE(h.date_time) as date,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			af.affiliateid as affiliateid,
			af.name as affiliatename,
			af.name as website,
			z.zonename as zonename,
			pu.name as publisher,
			pu.id as publisher_id
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as af,
			" . $table_prefix . "publishers as pu,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			ag.agencyid=:agencyid
			AND af.agencyid = ag.agencyid
			AND af.affiliateid=z.affiliateid
			AND pu.id=af.publisher_id 
			AND z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY af.publisher_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});


//Agency website Statistics

$app->post('/get_agency_website_statistics/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "publishers p," . $table_prefix . "affiliates a where p.id=a.publisher_id and p.id=$publisherid";
		$std = $this->db->prepare($stc);
		//$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$publishers = $std->fetchAll();

		$affiliateid = '';
		foreach ($publishers as $websites) {
			$affiliateid .= $websites['affiliateid'] . ',';
		}

		$affiliateids = trim($affiliateid, ',');

		$start_date = '';
		$end_date = '';
		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			p.affiliateid in ($affiliateids)
			AND p.agencyid = ag.agencyid
			AND p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY p.affiliateid";

			$sth = $this->db->prepare($sql);
			//$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			// echo "query";
			// print_r($todos);exit;

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});


$app->post('/get_agency_publisher_zone_statistics/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agencyid";
		$std = $this->db->prepare($stc);
		$std->bindParam("agencyid", $agency_id);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			// $sql="select 		  
			// 	DATE(h.date_time) as date_time,
			// 	sum(h.impressions) as impressions,
			// 	sum(h.clicks) as clicks,
			// 	sum(h.conversions) as conversions,
			// 	sum(h.total_revenue) as revenue,		
			// 	cl.clientid as clientid,
			// 	(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			// 	(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			// 	p.affiliateid as affiliateid,
			// 	p.name as affiliatename,
			// 	z.zonename as zonename
			// 	from
			// 	".$table_prefix."data_summary_ad_hourly as h,
			// 	".$table_prefix."banners as b,
			// 	".$table_prefix."campaigns as c,
			// 	".$table_prefix."clients as cl,
			// 	".$table_prefix."affiliates as p,
			// 	".$table_prefix."zones as z
			// 	where
			// 	h.ad_id = b.bannerid
			// 	AND cl.clientid = c.clientid
			// 	AND p.affiliateid = :publisherid
			// 	and p.affiliateid=z.affiliateid
			// 	AND z.zoneid = h.zone_id
			// 	AND b.campaignid = c.campaignid
			// 	AND h.date_time between '".$startdate."'
			// 	AND '".$enddate."' group by h.zone_id";

			$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			p.agencyid = :agencyid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id";

			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY h.zone_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//Advertising analysis report
$app->post('/get_advertising_analysis_report/[{agency_id}]', function ($request, $response, $args) {


	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$agency_id = $args['agency_id'];
		$action = $input['action'];
		$orders = $input['orders_id'];
		$website = $input['website_id'];
		$daily_bd = $input['daily_bd'];
		$campaign_bd = $input['campaign_bd'];
		$zone_bd = $input['zone_bd'];
		$report_name = $input['report_name'];

		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}


		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$agency = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($agency) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($daily_bd == true) {

				$sql = "select
				DATE_FORMAT(h.date_time,'%d-%m-%Y') as date, 		  
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.views) as views,
				sum(h.conversions) as conversions,
				round(sum(h.total_revenue),2) as revenue,	
				round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,	
				round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
				round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm
				from
				" . $table_prefix . "data_summary_ad_hourly as h,
            	" . $table_prefix . "banners as b,
            	" . $table_prefix . "campaigns as c,
            	" . $table_prefix . "clients as cl,
				" . $table_prefix . "affiliates as p,
				" . $table_prefix . "zones as z,
				" . $table_prefix . "agency as ag
				where
				ag.agencyid=:agencyid
            	AND h.ad_id =b.bannerid
            	and b.campaignid = c.campaignid
            	and c.clientid = cl.clientid
            	and cl.agencyid =ag.agencyid
				AND p.agencyid = ag.agencyid
				AND p.affiliateid=z.affiliateid
				AND z.zoneid = h.zone_id";

				if ($orders != 'all') {
					$sql .= " AND cl.clientid=" . $orders;
				}
				if ($website != 'all') {
					$sql .= " AND p.affiliateid=" . $website;
				}
				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				$sql .= " GROUP BY date Order by h.date_time Desc";

				$sth = $this->db->prepare($sql);
				$sth->bindParam(":agencyid", $agency_id);
				$sth->execute();
				$daily = $sth->fetchAll();
			}

			if ($campaign_bd == true) {
				$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
            " . $table_prefix . "banners as b,
            " . $table_prefix . "campaigns as c,
            " . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			ag.agencyid=:agencyid
            	AND h.ad_id =b.bannerid
            	and b.campaignid = c.campaignid
            	and c.clientid = cl.clientid
            	and cl.agencyid =ag.agencyid
				AND p.agencyid = ag.agencyid
				AND p.affiliateid=z.affiliateid
				AND z.zoneid = h.zone_id";

				if ($orders != 'all') {
					$sql .= " AND cl.clientid=" . $orders;
				}
				if ($website != 'all') {
					$sql .= " AND p.affiliateid=" . $website;
				}
				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				$sql .= " GROUP BY campaignid";

				$sth = $this->db->prepare($sql);
				$sth->bindParam(":agencyid", $agency_id);

				$sth->execute();

				$campaign = $sth->fetchAll();
			}
			if ($zone_bd == true) {
				$sql = "select 		  
			z.zoneid AS zoneid,
			z.zonename as zonename,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
            " . $table_prefix . "banners as b,
            " . $table_prefix . "campaigns as c,
            " . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			ag.agencyid=:agencyid
            AND h.ad_id =b.bannerid
            and b.campaignid = c.campaignid
            and c.clientid = cl.clientid
            and cl.agencyid =ag.agencyid
			AND p.agencyid = ag.agencyid
			AND p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";
				if ($orders != 'all') {
					$sql .= " AND cl.clientid=" . $orders;
				}
				if ($website != 'all') {
					$sql .= " AND p.affiliateid=" . $website;
				}

				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				$sql .= " GROUP BY z.zoneid";

				$sth = $this->db->prepare($sql);
				$sth->bindParam(":agencyid", $agency_id);
				$sth->execute();
				$zone = $sth->fetchAll();
			}

			$response = array ('daily' => $daily, 'campaign' => $campaign, 'zone' => $zone, 'report_name' => $report_name, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
			// if ($daily_bd) {
			// 	return $this->response->withJson($todos);
			// } else {
			// 	$response = array('response' => 'ok', 'msg' => 'No Stats Available');
			// 	return $this->response->withJson($response);
			// }
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});





$app->post('/get_campaign_analysis_report/[{agencyid}]', function ($request, $response, $args) {


	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$agency_id = $args['agencyid'];
		$action = $input['action'];
		$daily = $input['daily_bd'];
		$ad = $input['ad_val'];

		$zone = $input['zone_bd'];
		$campaign_id = $input['campaign_id'];

		$report_name = $input['report_name'];

		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
			$fname = $report_name . " from " . $startdate . " to " . $enddate;
		} else {
			$fname = $report_name . " All Statistics";
		}


		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$agency = $std->fetchAll();

		$camp = "select
               cl.clientid as clientid,	
				cl.clientname as clientname	  
				from
			
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl
			where
            c.campaignid=:campaignid
			AND c.clientid = cl.clientid";
		$std1 = $this->db->prepare($camp);
		$std1->bindParam(":campaignid", $campaign_id);
		$std1->execute();
		$order = $std1->fetchAll();


		$start_date = '';
		$end_date = '';
		if ($agency) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($daily == true) {

				$sql = "select
				DATE_FORMAT(h.date_time,'%d-%m-%Y') as date, 	
				cl.clientname as clientname,	  
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.views) as views,
				sum(h.conversions) as conversions,
				round(sum(h.total_revenue),2) as revenue,	
				round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,	
				round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
				round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm	
				from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
           " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND  b.campaignid =c.campaignid
            AND c.campaignid=:campaignid
			AND c.clientid = cl.clientid
            AND cl.agencyid = ag.agencyid
            AND ag.agencyid=:agencyid";


				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				$sql .= " GROUP BY date Order by h.date_time Desc";

				$sth = $this->db->prepare($sql);
				$sth->bindParam(":agencyid", $agency_id);
				$sth->bindParam(":campaignid", $campaign_id);
				$sth->execute();
				$camp_daily = $sth->fetchAll();
			}

			if ($ad == true) {

				$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND  b.campaignid =c.campaignid
            AND c.campaignid=:campaignid
			AND cl.clientid = c.clientid
			And cl.agencyid = ag.agencyid
           And ag.agencyid =:agencyid";


				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				$sql .= " GROUP BY ad_id";

				$sth = $this->db->prepare($sql);
				$sth->bindParam(":agencyid", $agency_id);
				$sth->bindParam(":campaignid", $campaign_id);

				$sth->execute();

				$camp_ad = $sth->fetchAll();
			}
			if ($zone == true) {

				$sql = "select 		  
			z.zoneid AS zoneid,
			DATE(h.date_time) as date_time,
			z.zonename as zonename,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
            " . $table_prefix . "banners as b,
            " . $table_prefix . "campaigns as c,
            " . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			ag.agencyid=:agencyid
            AND h.ad_id =b.bannerid
            and b.campaignid =c.campaignid
            and c.clientid = cl.clientid
            and cl.agencyid =ag.agencyid
			AND p.agencyid = ag.agencyid
			AND p.affiliateid=z.affiliateid
			AND c.campaignid=:campaignid
			AND z.zoneid = h.zone_id";


				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				$sql .= " GROUP BY z.zoneid";

				$sth = $this->db->prepare($sql);
				$sth->bindParam(":agencyid", $agency_id);
				$sth->bindParam(":campaignid", $campaign_id);
				$sth->execute();
				$camp_zone = $sth->fetchAll();
			}

			$response = array ('order' => $order, 'camp_daily' => $camp_daily, 'camp_ad' => $camp_ad, 'camp_zone' => $camp_zone, 'report_name' => $report_name, 'file_name' => $fname, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
			// if ($daily_bd) {
			// 	return $this->response->withJson($todos);
			// } else {
			// 	$response = array('response' => 'ok', 'msg' => 'No Stats Available');
			// 	return $this->response->withJson($response);
			// }
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

//delivery analysis report
$app->post('/get_delivery_analysis_report/[{agency_id}]', function ($request, $response, $args) {


	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$agency_id = $args['agency_id'];
		$action = $input['action'];
		$orders = $input['orders_id'];
		$website = $input['website_id'];
		$report_name = $input['report_name'];

		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}


		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$agency = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($agency) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			$sql = "select 
				cl.clientid as clientid,
				cl.clientname as clientname,
				b.compiledlimitation as target,
            	c.campaignid as campaignid,
				c.campaignname as campaignname,
            	c.status as status,
				c.priority as priority,
            	c.booked_impression as booked_imp, 
				DATE_FORMAT(c.activate_time,'%d-%m-%Y') as startdate,
            	DATE_FORMAT(c.expire_time,'%d-%m-%Y') as enddate,
				DATE(h.date_time) as date_time,
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.views) as views,
				round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,
				sum(h.conversions) as conversions,
				sum(h.requests) as requests,
				round(sum(h.total_revenue),2) as revenue,
				round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
				round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
				from
				" . $table_prefix . "data_summary_ad_hourly as h,
				" . $table_prefix . "banners as b,
				" . $table_prefix . "campaigns as c,
				" . $table_prefix . "clients as cl,
				" . $table_prefix . "agency as ag,
				" . $table_prefix . "affiliates as p,
				" . $table_prefix . "zones as z
				where
				ag.agencyid =:agencyid
				AND h.ad_id = b.bannerid
				AND c.campaignid = b.campaignid
				AND c.clientid = cl.clientid
				AND c.status = 0
				And cl.agencyid = ag.agencyid
				AND p.agencyid = ag.agencyid
				AND p.affiliateid=z.affiliateid
				AND z.zoneid = h.zone_id";

			if ($orders != 'all') {
				$sql .= " AND cl.clientid=" . $orders;
			}
			if ($website != 'all') {
				$sql .= " AND p.affiliateid=" . $website;
			}
			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			$sql .= " GROUP BY campaignid";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);
			$sth->execute();
			$delivery_camp = $sth->fetchAll();

			$response = array ('delivery_camp' => $delivery_camp, 'report_name' => $report_name, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
			// if ($daily_bd) {
			// 	return $this->response->withJson($todos);
			// } else {
			// 	$response = array('response' => 'ok', 'msg' => 'No Stats Available');
			// 	return $this->response->withJson($response);
			// }
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_convertion_analysis_report/[{agency_id}]', function ($request, $response, $args) {


	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$agency_id = $args['agency_id'];
		$action = $input['action'];
		$orders = $input['orders_id'];
		$website = $input['website_id'];
		$daily_bd = $input['performance_bd'];
		$report_name = $input['report_name'];

		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}


		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$agency = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($agency) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($daily_bd == true) {

				$sql = "select
				DATE_FORMAT(h.date_time,'%d-%m-%Y') as date, 		  
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.views) as views,
				sum(h.conversions) as conversions,
				round(sum(h.total_revenue),2) as revenue,	
				round((sum(h.views)/sum(h.impressions)) *1000) as viewableimpressionrate,	
				round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
				round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm
				from
				" . $table_prefix . "data_summary_ad_hourly as h,
            	" . $table_prefix . "banners as b,
            	" . $table_prefix . "campaigns as c,
            	" . $table_prefix . "clients as cl,
				" . $table_prefix . "affiliates as p,
				" . $table_prefix . "zones as z,
				" . $table_prefix . "agency as ag
				where
				ag.agencyid=:agencyid
            	AND h.ad_id =b.bannerid
            	and b.campaignid = c.campaignid
            	and c.clientid = cl.clientid
            	and cl.agencyid =ag.agencyid
				AND p.agencyid = ag.agencyid
				AND p.affiliateid=z.affiliateid
				AND z.zoneid = h.zone_id";

				if ($orders != 'all') {
					$sql .= " AND cl.clientid=" . $orders;
				}
				if ($website != 'all') {
					$sql .= " AND p.affiliateid=" . $website;
				}
				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				$sql .= " GROUP BY date Order by h.date_time Desc";

				$sth = $this->db->prepare($sql);
				$sth->bindParam(":agencyid", $agency_id);
				$sth->execute();
				$daily = $sth->fetchAll();
			}



			$response = array ('daily_track' => $daily, 'report_name' => $report_name, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
			// if ($daily_bd) {
			// 	return $this->response->withJson($todos);
			// } else {
			// 	$response = array('response' => 'ok', 'msg' => 'No Stats Available');
			// 	return $this->response->withJson($response);
			// }
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});


//device targeting statstics 

$app->post('/get_device_agency_statistics/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];
		$device_type = $args['device'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}


			$sql = "select 

				h.device_type as device_type,
				DATE(h.date_time) as date_time,
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.requests) as requests
				from
				" . $table_prefix . "Stats_Devicetype as h,
				" . $table_prefix . "banners as b,
				" . $table_prefix . "campaigns as c,
				" . $table_prefix . "clients as cl,
				" . $table_prefix . "agency as ag
				where
				h.creative_id = b.bannerid
				AND c.campaignid = b.campaignid
				AND c.clientid = cl.clientid
				AND cl.agencyid = ag.agencyid
				AND ag.agencyid =  $agency_id ";


			if ($action != "all") {
				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			}
			//$sql .= " GROUP BY clientid";
			$sql .= " GROUP BY h.device_type ORDER BY h.date_time";

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();


			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_device_agency_campaignwise_statistics/[{agency_id},{device}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];
		$device_type = $args['device'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($device_type == "all") {
				$sql = "select 
				cl.clientid as clientid,
				cl.clientname as clientname,
				b.campaignid as campaignid,
				b.description as bannername,
				c.campaignname as campaignname,
				h.creative_id as creative_id,
				h.device_type as device_type,
				DATE(h.date_time) as date_time,
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.requests) as requests
				from
				" . $table_prefix . "Stats_Devicetype as h,
				" . $table_prefix . "banners as b,
				" . $table_prefix . "campaigns as c,
				" . $table_prefix . "clients as cl,
				" . $table_prefix . "agency as ag
				where
				h.creative_id = b.bannerid
				AND c.campaignid = b.campaignid
				AND c.priority = 0
				AND c.clientid = cl.clientid
				AND cl.agencyid = ag.agencyid
				AND ag.agencyid =  $agency_id ";


				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				//$sql .= " GROUP BY clientid";
				$sql .= " GROUP BY c.campaignid Order by h.date_time desc";
			} else {
				$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
            b.description as bannername,
			c.campaignname as campaignname,
			h.creative_id as creative_id,
            h.device_type as device_type,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.requests) as requests
				from
				" . $table_prefix . "Stats_Devicetype as h,
				" . $table_prefix . "banners as b,
				" . $table_prefix . "campaigns as c,
				" . $table_prefix . "clients as cl,
				" . $table_prefix . "agency as ag
				where
				h.creative_id = b.bannerid
				AND h.device_type='$device_type'
				AND c.campaignid = b.campaignid
				AND c.clientid = cl.clientid
				AND cl.agencyid = ag.agencyid
				AND ag.agencyid =  $agency_id";


				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				//$sql .= " GROUP BY clientid";
				$sql .= " GROUP BY c.campaignid Order by h.date_time desc";
			}

			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();


			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_device_agency_bannerwise_statistics/[{agency_id},{device}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];
		$device_type = $args['device'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			if ($device_type == "all") {
				$sql = "select 
				cl.clientid as clientid,
				cl.clientname as clientname,
				b.campaignid as campaignid,
				b.description as bannername,
				c.campaignname as campaignname,
				h.creative_id as creative_id,
				h.device_type as device_type,
				DATE(h.date_time) as date_time,
				sum(h.impressions) as impressions,
				sum(h.clicks) as clicks,
				sum(h.requests) as requests
				from
				" . $table_prefix . "Stats_Devicetype as h,
				" . $table_prefix . "banners as b,
				" . $table_prefix . "campaigns as c,
				" . $table_prefix . "clients as cl,
				" . $table_prefix . "agency as ag
				where
				h.creative_id = b.bannerid
				AND c.campaignid = b.campaignid
				AND c.priority = 0
				AND c.clientid = cl.clientid
				AND cl.agencyid = ag.agencyid
				AND ag.agencyid =  $agency_id ";


				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				//$sql .= " GROUP BY clientid";
				$sql .= " GROUP BY h.creative_id Order by h.date_time desc";
			} else {

				$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
            b.description as bannername,
			c.campaignname as campaignname,
			h.creative_id as creative_id,
            h.device_type as device_type,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.requests) as requests
				from
				" . $table_prefix . "Stats_Devicetype as h,
				" . $table_prefix . "banners as b,
				" . $table_prefix . "campaigns as c,
				" . $table_prefix . "clients as cl,
				" . $table_prefix . "agency as ag
				where
				h.creative_id = b.bannerid
				AND h.device_type='$device_type'
				AND c.campaignid = b.campaignid
				AND c.clientid = cl.clientid
				AND cl.agencyid = ag.agencyid
				AND ag.agencyid =  $agency_id";


				if ($action != "all") {
					$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
				}
				//$sql .= " GROUP BY clientid";
				$sql .= " GROUP BY h.creative_id Order by h.date_time desc";
			}
			$sth = $this->db->prepare($sql);
			$sth->execute();
			$todos = $sth->fetchAll();


			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});


$app->post('/get_agency_statistics_new/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($action != "all") {
				$sql = "select 
            cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			c.Booked_impression as booked_imp,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
           " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions != 0
			AND c.campaignid = b.campaignid
			AND c.priority =0
			AND c.clientid = cl.clientid
            AND cl.agencyid = ag.agencyid
            AND ag.agencyid = $agency_id";

				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 
            cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			h.ad_id as ad_id,
			b.bannerid as bannerid,
			b.description as bannername,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			c.Booked_impression as booked_imp,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
           " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions != 0
			AND c.campaignid = b.campaignid
			AND c.priority =0
			AND c.clientid = cl.clientid
            AND cl.agencyid = ag.agencyid
            AND ag.agencyid = $agency_id";
			}
			// if ($action != "all") {
			// 	$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			// }
			//$sql .= " GROUP BY clientid";
			$sql .= " GROUP BY clientid, c.campaignid,h.ad_id";

			$sth = $this->db->prepare($sql);

			$sth->execute();
			$todos = $sth->fetchAll();

			$newarray = array ();
			$booked = $impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
			foreach ($todos as $key => $value) {

				if ($key == 0) {
					$clientid1 = $value['clientid'];
					$campaignid1 = $value['campaignid'];
					$booked = $value['booked_imp'];
				}

				$clientid = $value['clientid'];
				$campaignid = $value['campaignid'];
				if ($clientid1 != $clientid) {
					$clientid1 = $clientid;
					$booked = $impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
				}

				if ($campaignid1 == $campaignid) {
					$booked = $booked;
				} else {					
					$campaignid1 = $campaignid;
					$booked += $value['booked_imp'];				
				}
				
				//$booked = $value['booked_imp'];
				$impr += $value['impressions'];
				$views += $value['views'];
				$clicks += $value['clicks'];
				$conversions += $value['conversions'];
				$total_revenue += $value['revenue'];
				$mobileviews += $value['mobile_impression'];
				$mobileclicks += $value['mobile_clicks'];
				$desktopviews += $value['desktop_impression'];
				$desktopclicks += $value['desktop_clicks'];
				//$view_imp = $value['views']/$impr*1000;
				if ($views != '' || $impr != '' || $clicks != '' || $total_revenue != '') {
					// $viewableimpressionrate = $views / $impr * 100;
					// $ctr = $clicks / $impr * 100;
					// $ecpm = $total_revenue / $impr * 1000;
					$newarray[$clientid] = array ('clientid' => $value['clientid'], 'clientname' => $value['clientname'], 'ad_id' => $value['ad_id'], 'impressions' => $impr, 'booked_imp' => $booked, 'clicks' => $clicks, 'views' => $views, 'mobileviews' => $mobileviews, 'mobileclicks' => $mobileclicks, 'desktopviews' => $desktopviews, 'desktopclicks' => $desktopclicks, 'conversions' => $conversions, 'revenue' => $total_revenue);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}


				//print_r($viewableimpressionrate); exit('ok');

			}
			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}


			if ($todos) {

				if (!empty ($todos[0]['ad_id'])) {
					return $this->response->withJson($result_array);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_agency_campaign_report_statistics_new/[{agency_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			if ($action != "all") {
				$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			h.ad_id as ad_id,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			c.Booked_impression as booked_imp,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND h.impressions != 0
			AND c.campaignid = b.campaignid
			AND c.priority =0
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";


				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			h.ad_id as ad_id,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			c.Booked_impression as booked_imp,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND h.impressions != 0
			AND c.campaignid = b.campaignid
			AND c.priority =0
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND ag.agencyid = :agencyid";
			}
			$sql .= " GROUP BY campaignid,h.ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			$newarray = array ();
			$booked = $impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
			foreach ($todos as $key => $value) {

				if ($key == 0) {
					$campaignid1 = $value['campaignid'];
				}

				$campaignid = $value['campaignid'];
				if ($campaignid1 != $campaignid) {
					$campaignid1 = $campaignid;
					$booked = $impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
				}
				//$booked += $value['booked_imp'];
				$impr += $value['impressions'];
				$views += $value['views'];
				$clicks += $value['clicks'];
				$conversions += $value['conversions'];
				$total_revenue += $value['revenue'];
				$mobileviews += $value['mobile_impression'];
				$mobileclicks += $value['mobile_clicks'];
				$desktopviews += $value['desktop_impression'];
				$desktopclicks += $value['desktop_clicks'];
				//$view_imp = $value['views']/$impr*1000;
				if ($views != '' || $impr != '' || $clicks != '' || $total_revenue != '') {
					// $viewableimpressionrate = $views / $impr * 100;
					// $ctr = $clicks / $impr * 100;
					// $ecpm = $total_revenue / $impr * 1000;
					$newarray[$campaignid] = array ('clientid' => $value['clientid'], 'campaignid' => $value['campaignid'], 'campaignname' => $value['campaignname'], 'ad_id' => $value['ad_id'], 'impressions' => $impr, 'booked_imp' => $value['booked_imp'], 'clicks' => $clicks, 'views' => $views, 'mobileviews' => $mobileviews, 'mobileclicks' => $mobileclicks, 'desktopviews' => $desktopviews, 'desktopclicks' => $desktopclicks, 'conversions' => $conversions, 'revenue' => $total_revenue);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}

				// $viewableimpressionrate = $views / $impr * 100;
				// $ctr = $clicks / $impr * 100;
				// $ecpm = $total_revenue / $impr * 1000;

				//print_r($viewableimpressionrate); exit('ok');

			}
			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}


			if ($todos) {

				if (!empty ($todos[0]['ad_id'])) {
					return $this->response->withJson($result_array);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_agency_clientwise_campaign_report_statistics_new/[{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them group by campaignid h.ad_id as ad_id,b.bannerid as bannerid,b.description as bannername,
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$client_id = $args['client_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $client_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($action != "all") {
				$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			h.ad_id as ad_id,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			c.Booked_impression as booked_imp,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions) *100),2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority =0
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND cl.clientid = :clientid";

				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 
			cl.clientid as clientid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			h.ad_id as ad_id,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			c.Booked_impression as booked_imp,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
            sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions) *100),2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			sum(h.requests) as requests,
			round(sum(h.total_revenue),2) as revenue,
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag 
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority =0
			AND c.clientid = cl.clientid
			And cl.agencyid = ag.agencyid
			AND cl.clientid = :clientid";
			}
			$sql .= " GROUP BY campaignid,h.ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":clientid", $client_id);
			//print_r($sth);exit("ok");
			$sth->execute();

			$todos = $sth->fetchAll();

			$newarray = array ();
			$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
			foreach ($todos as $key => $value) {

				if ($key == 0) {
					$campaignid1 = $value['campaignid'];
				}

				$campaignid = $value['campaignid'];
				if ($campaignid1 != $campaignid) {
					$campaignid1 = $campaignid;
					$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
				}
				//$booked += $value['booked_imp'];
				$impr += $value['impressions'];
				$views += $value['views'];
				$clicks += $value['clicks'];
				$conversions += $value['conversions'];
				$total_revenue += $value['revenue'];
				$mobileviews += $value['mobile_impression'];
				$mobileclicks += $value['mobile_clicks'];
				$desktopviews += $value['desktop_impression'];
				$desktopclicks += $value['desktop_clicks'];
				//$view_imp = $value['views']/$impr*1000;
				if ($views != '' || $impr != '' || $clicks != '' || $total_revenue != '') {
					// $viewableimpressionrate = $views / $impr * 100;
					// $ctr = $clicks / $impr * 100;
					// $ecpm = $total_revenue / $impr * 1000;
					$newarray[$campaignid] = array ('clientid' => $value['clientid'], 'campaignid' => $value['campaignid'], 'campaignname' => $value['campaignname'], 'ad_id' => $value['ad_id'], 'impressions' => $impr, 'booked_imp' => $value['booked_imp'], 'clicks' => $clicks, 'views' => $views, 'mobileviews' => $mobileviews, 'mobileclicks' => $mobileclicks, 'desktopviews' => $desktopviews, 'desktopclicks' => $desktopclicks, 'conversions' => $conversions, 'revenue' => $total_revenue);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}

				// $viewableimpressionrate = $views / $impr * 100;
				// $ctr = $clicks / $impr * 100;
				// $ecpm = $total_revenue / $impr * 1000;

				//print_r($viewableimpressionrate); exit('ok');

			}
			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}


			if ($todos) {

				if (!empty ($todos[0]['ad_id'])) {
					return $this->response->withJson($result_array);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_agency_campaignwise_banner_statistics_new/[{advertiser_id},{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$advertiser_id = $args['advertiser_id'];
		$campaign_id = $args['campaign_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id", $advertiser_id);
		$std->execute();
		$client = $std->fetchAll();
		$start_date = '';
		$end_date = '';

		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($action != "all") {
				$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND c.priority =0
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			And cl.agencyid = ag.agencyid";

				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.creative_id=h.ad_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.campaignname as campaignname,
			c.priority as campaigntype,
			b.description as bannername,
			cl.clientid as clientid,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((Sum(h.total_revenue)/sum(h.impressions))*1000,2) as ecpm	
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.clientid = :advertiserid
			AND c.campaignid = :campaignid
			AND c.priority =0
			AND cl.clientid = c.clientid
			AND b.campaignid = c.campaignid
			And cl.agencyid = ag.agencyid";
			}
			$sql .= " GROUP BY ad_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiserid", $advertiser_id);
			$sth->bindParam(":campaignid", $campaign_id);

			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_agency_publisher_statistics_new/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "affiliates where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}
			if ($action != "all") {
				$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			DATE(h.date_time) as date,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			h.zone_id as zone_id,
			af.affiliateid as affiliateid,
			af.name as affiliatename,
			af.name as website,
			z.zonename as zonename,
			pu.name as publisher,
			pu.id as publisher_id
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as af,
			" . $table_prefix . "publishers as pu,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
            AND c.clientid = cl.clientid
            AND cl.agencyid =ag.agencyid
			AND h.zone_id=z.zoneid
            AND z.affiliateid=af.affiliateid
            AND af.publisher_id=pu.id
            AND pu.agency_id=ag.agencyid
            AND ag.agencyid=$agency_id";

				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			DATE(h.date_time) as date,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_clicks,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			h.zone_id as zone_id,
			af.affiliateid as affiliateid,
			af.name as affiliatename,
			af.name as website,
			z.zonename as zonename,
			pu.name as publisher,
			pu.id as publisher_id
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as af,
			" . $table_prefix . "publishers as pu,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
            AND c.clientid = cl.clientid
            AND cl.agencyid =ag.agencyid
			AND h.zone_id=z.zoneid
            AND z.affiliateid=af.affiliateid
            AND af.publisher_id=pu.id
            AND pu.agency_id=ag.agencyid
            AND ag.agencyid=$agency_id";
			}
			$sql .= " GROUP BY pu.id,af.affiliateid,h.zone_id";

			$sth = $this->db->prepare($sql);
			$sth->execute();

			$todos = $sth->fetchAll();

			$newarray = array ();
			$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
			foreach ($todos as $key => $value) {

				if ($key == 0) {
					$publisher_id1 = $value['publisher_id'];
				}

				$publisher_id = $value['publisher_id'];
				if ($publisher_id1 != $publisher_id) {
					$publisher_id1 = $publisher_id;
					$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
				}
				$impr += $value['impressions'];
				$views += $value['views'];
				$clicks += $value['clicks'];
				$conversions += $value['conversions'];
				$total_revenue += $value['revenue'];
				$mobileviews += $value['mobile_impression'];
				$mobileclicks += $value['mobile_clicks'];
				$desktopviews += $value['desktop_impression'];
				$desktopclicks += $value['desktop_clicks'];

				//$view_imp = $value['views']/$impr*1000;
				if ($views != '' || $impr != '' || $clicks != '' || $total_revenue != '') {
					// $viewableimpressionrate = $views / $impr * 100;
					// $ctr = $clicks / $impr * 100;
					// $ecpm = $total_revenue / $impr * 1000;
					$newarray[$publisher_id] = array ('publisher_id' => $value['publisher_id'], 'publisher' => $value['publisher'], 'Name' => $value['affiliatename'], 'zone_id' => $value['zone_id'], 'impressions' => $impr, 'clicks' => $clicks, 'views' => $views, 'mobileviews' => $mobileviews, 'mobileclicks' => $mobileclicks, 'desktopviews' => $desktopviews, 'desktopclicks' => $desktopclicks, 'conversions' => $conversions, 'revenue' => $total_revenue);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}

				// $viewableimpressionrate = $views / $impr * 100;
				// $ctr = $clicks / $impr * 100;
				// $ecpm = $total_revenue / $impr * 1000;

				//print_r($viewableimpressionrate); exit('ok');

			}
			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}

			if ($todos) {

				if (!empty ($todos[0]['zone_id'])) {
					return $this->response->withJson($result_array);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/get_agency_website_statistics_new/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "publishers p," . $table_prefix . "affiliates a where p.id=a.publisher_id and p.id=$publisherid";
		$std = $this->db->prepare($stc);
		//$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$publishers = $std->fetchAll();

		$affiliateid = '';
		foreach ($publishers as $websites) {
			$affiliateid .= $websites['affiliateid'] . ',';
		}

		$affiliateids = trim($affiliateid, ',');

		$start_date = '';
		$end_date = '';
		if ($publishers) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($action != "all") {
				$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			h.zone_id as zone_id,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
			AND c.clientid = cl.clientid
			AND cl.agencyid =ag.agencyid
			AND p.affiliateid in ($affiliateids)
			AND p.agencyid = ag.agencyid
			AND p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";

				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			h.zone_id as zone_id,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
			AND c.clientid = cl.clientid
			AND cl.agencyid =ag.agencyid
			AND p.affiliateid in ($affiliateids)
			AND p.agencyid = ag.agencyid
			AND p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";
			}
			$sql .= " GROUP BY p.affiliateid,h.zone_id ";

			$sth = $this->db->prepare($sql);
			//$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

			$newarray = array ();
			$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
			foreach ($todos as $key => $value) {

				if ($key == 0) {
					$affiliateid1 = $value['affiliateid'];
				}

				$affiliateid = $value['affiliateid'];
				if ($affiliateid1 != $affiliateid) {
					$affiliateid1 = $affiliateid;
					$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
				}
				$impr += $value['impressions'];
				$views += $value['views'];
				$clicks += $value['clicks'];
				$conversions += $value['conversions'];
				$total_revenue += $value['revenue'];
				$mobileviews += $value['mobile_impression'];
				$mobileclicks += $value['mobile_clicks'];
				$desktopviews += $value['desktop_impression'];
				$desktopclicks += $value['desktop_clicks'];
				//$view_imp = $value['views']/$impr*1000;
				if ($views != '' || $impr != '' || $clicks != '' || $total_revenue != '') {
					// $viewableimpressionrate = $views / $impr * 100;
					// $ctr = $clicks / $impr * 100;
					// $ecpm = $total_revenue / $impr * 1000;
					$newarray[$affiliateid] = array ('affiliateid' => $value['affiliateid'], 'affiliatename' => $value['affiliatename'], 'zone_id' => $value['zone_id'], 'impressions' => $impr, 'clicks' => $clicks, 'views' => $views, 'mobileviews' => $mobileviews, 'mobileclicks' => $mobileclicks, 'desktopviews' => $desktopviews, 'desktopclicks' => $desktopclicks, 'conversions' => $conversions, 'revenue' => $total_revenue);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}

				// $viewableimpressionrate = $views / $impr * 100;
				// $ctr = $clicks / $impr * 100;
				// $ecpm = $total_revenue / $impr * 1000;

				//print_r($viewableimpressionrate); exit('ok');

			}
			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}


			if ($todos) {

				if (!empty ($todos[0]['zone_id'])) {
					return $this->response->withJson($result_array);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});


$app->post('/get_publisher_zone_statistics_new/[{publisher_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$publisherid = $args['publisher_id'];

		$stc = "select * from " . $table_prefix . "affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid", $publisherid);
		$std->execute();
		$publishers = $std->fetchAll();

		$start_date = '';
		$end_date = '';

		if ($publishers) {

			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			//var_dump($TimeZoneRow);
			//echo $TimeZoneRow[0]['timezone'];
			//exit;

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($action != "all") {
				$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop'AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "agency as ag,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
			AND c.clientid = cl.clientid
			AND cl.agencyid =ag.agencyid
			AND p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id";

				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 		  
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop') as desktop_clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,		
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zoneid AS zoneid,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "agency as ag,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
			AND c.clientid = cl.clientid
			AND cl.agencyid =ag.agencyid
			AND p.affiliateid = :publisherid
			AND
			p.affiliateid = z.affiliateid
			AND
			z.zoneid = h.zone_id";
			}
			$sql .= " GROUP BY h.zone_id";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":publisherid", $publisherid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
	}
});

//Agency Global Statistics

$app->post('/get_agency_global_statistics_new/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$action = $input['action'];
		if ($action != "all") {
			$startdate = $input['start_date'];
			$enddate = $input['end_date'];
		}
		$agency_id = $args['agency_id'];

		$stc = "select * from " . $table_prefix . "clients where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id", $agency_id);
		$std->execute();
		$client = $std->fetchAll();

		$start_date = '';
		$end_date = '';
		if ($client) {
			$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();

			$timezone = $TimeZoneRow[0]['timezone'];

			$start_date = date('Y-m-d 00:00:00', strtotime($start_date));
			$end_date = date('Y-m-d 23:59:59', strtotime($end_date));

			date_default_timezone_set($timezone);
			if ($action != "all") {
				$Starts = strtotime($startdate);
				$Ends = strtotime($enddate);
				date_default_timezone_set("UTC");
				$start_date = date("Y-m-d H:i:s", $Starts);
				$end_date = date("Y-m-d H:i:s", $Ends);
			}

			if ($action != "all") {
				$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			DATE(h.date_time) as date,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND date(d.date_time)=date AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND date(d.date_time)=date AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND date(d.date_time)=date AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop'AND date(d.date_time)=date AND d.date_time between '" . $start_date . "' AND '" . $end_date . "') as desktop_clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			h.zone_id as zone_id,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "publishers as pu,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
			AND c.clientid = cl.clientid
			AND cl.agencyid =ag.agencyid
			AND ag.agencyid=:agencyid
			AND pu.agency_id = ag.agencyid
            AND pu.id=p.publisher_id
			AND p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";

				$sql .= " AND h.date_time between '" . $start_date . "' AND '" . $end_date . "'";
			} else {
				$sql = "select 		  
			DATE_FORMAT(h.date_time,'%d-%m-%Y') as date_time,
			DATE(h.date_time) as date,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.views) as views,
			(SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND date(d.date_time)=date) as mobile_impression,
            (SELECT SUM(d.impressions) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND date(d.date_time)=date) as desktop_impression,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Mobile' AND date(d.date_time)=date) as mobile_clicks,
            (SELECT SUM(d.clicks) FROM " . $table_prefix . "Stats_Devicetype as d WHERE d.zone_id=h.zone_id AND d.creative_id !=0 AND d.device_type='Desktop' AND date(d.date_time)=date) as desktop_clicks,
			sum(h.conversions) as conversions,
			round(sum(h.total_revenue),2) as revenue,	
			format((sum(h.views)/sum(h.impressions)) *100,2) as viewableimpressionrate,	
			round((sum(h.clicks)/sum(h.impressions)) * 100,2) as ctr,
			round((sum(h.total_revenue)/sum(h.impressions)) * 1000,2) as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			p.name as website,
			h.zone_id as zone_id,
			z.zonename as zonename
			from
			" . $table_prefix . "data_summary_ad_hourly as h,
			" . $table_prefix . "banners as b,
			" . $table_prefix . "campaigns as c,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "publishers as pu,
			" . $table_prefix . "affiliates as p,
			" . $table_prefix . "zones as z,
			" . $table_prefix . "agency as ag
			where
			h.ad_id = b.bannerid
			AND h.impressions !=0
			AND c.campaignid = b.campaignid
			AND c.priority = 0
			AND c.clientid = cl.clientid
			AND cl.agencyid =ag.agencyid
			AND ag.agencyid=:agencyid
			AND pu.agency_id = ag.agencyid
            AND pu.id=p.publisher_id
			AND p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id";
			}
			$sql .= " GROUP BY date,p.affiliateid,h.zone_id Order by h.date_time Desc";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid", $agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();
			$newarray = array ();
			$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
			foreach ($todos as $key => $value) {

				if ($key == 0) {
					$date_time1 = $value['date_time'];
				}

				$date_time = $value['date_time'];
				if ($date_time1 != $date_time) {
					$date_time1 = $date_time;
					$impr = $views = $clicks = $conversions = $total_revenue = $mobileviews = $mobileclicks = $desktopviews = $desktopclicks = 0;
				}
				$impr += $value['impressions'];
				$views += $value['views'];
				$clicks += $value['clicks'];
				$conversions += $value['conversions'];
				$total_revenue += $value['revenue'];
				$mobileviews += $value['mobile_impression'];
				$mobileclicks += $value['mobile_clicks'];
				$desktopviews += $value['desktop_impression'];
				$desktopclicks += $value['desktop_clicks'];

				//$view_imp = $value['views']/$impr*1000;
				if ($views != '' || $impr != '' || $clicks != '' || $total_revenue != '') {
					// $viewableimpressionrate = $views / $impr * 100;
					// $ctr = $clicks / $impr * 100;
					// $ecpm = $total_revenue / $impr * 1000;
					$newarray[$date_time] = array ('date_time' => $value['date_time'], 'affiliateid' => $value['affiliateid'], 'Name' => $value['affiliatename'], 'zone_id' => $value['zone_id'], 'impressions' => $impr, 'clicks' => $clicks, 'views' => $views, 'mobileviews' => $mobileviews, 'mobileclicks' => $mobileclicks, 'desktopviews' => $desktopviews, 'desktopclicks' => $desktopclicks, 'conversions' => $conversions, 'revenue' => $total_revenue);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}

				// $viewableimpressionrate = $views / $impr * 100;
				// $ctr = $clicks / $impr * 100;
				// $ecpm = $total_revenue / $impr * 1000;

				//print_r($viewableimpressionrate); exit('ok');

			}
			$result_array = array ();
			$i = 0;
			foreach ($newarray as $key => $table_data) {
				$result_array[$i] = $table_data;
				$i++;
			}

			if ($todos) {

				if (!empty ($todos[0]['zone_id'])) {
					return $this->response->withJson($result_array);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
		}
	}
});
