<?php

$app->post('/user_password/[{id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $args['id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$realpassword = $input['password'];
		//password encrypt
		$password = md5($realpassword);


		$user_details = "SELECT user_id from {$table_prefix}password_recovery where recovery_id=:id";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":id", $id);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetchAll();
		$userid = $stmtuser[0]['user_id'];
		if (count($stmtuser)) {

			$updateuser = "update {$table_prefix}users set `password`=:password ,date_created=:updated where `user_id`=:user_id";

			$upd_userdet = $this->db->prepare($updateuser);

			$upd_userdet->bindParam(":password", $password);
			$upd_userdet->bindParam(":updated", $datetime);
			$upd_userdet->bindParam(":user_id", $userid);
			$upd_userdet->execute();

			$responses = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'password updated successfully!'
			);
			$response = array (
				'data' => $responses
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid user Id!'
			);
		}
		return $this->response->withJson($response);
	}
});


$app->get('/get_user/[{id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$currentdate = date('Y-m-d');
		$results = array ();
		$id = $args['id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$userdet = "select usr.username,pr.user_id,pr.user_type,DATE_FORMAT(pr.updated,'%Y-%m-%d') as updated from {$table_prefix}users as usr JOIN {$table_prefix}password_recovery as pr ON usr.user_id=pr.user_id  where recovery_id=:id";
		$userdetail = $this->db->prepare($userdet);
		$userdetail->bindParam(":id", $id);
		$userdetail->execute();
		$stmtuser = $userdetail->fetchAll();

		$usrdetail = array ();
		$update = $stmtuser[0]['updated'];

		if ($currentdate > $update) {

			$response = array ('response' => 'error', 'msg' => 'url link is expired');
			return $this->response->withJson($response);
		} else {
			if (count($stmtuser) > 0) {
				//[$userid]		
				foreach ($stmtuser as $alluser) {

					$usrdetail = array (
						'recovery_id' => $id,
						'username' => $alluser['username'],
						'user_id' => $alluser['user_id'],
						'usertype' => $alluser['user_type'],
						'updated' => $alluser['updated']
					);
				}
				return $this->response->withJson($usrdetail);
			} else {
				$response = array ('response' => 'error', 'msg' => 'No data found');
				return $this->response->withJson($response);
			}
		}
	}
});

$app->post('/user_password_resend/[{id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array ('response' => 'error', 'msg' => 'Please check with input mandatory parameters and format of input');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$email = $input['email'];
		$datetime = date('Y-m-d H:i:s');
		$date = date('Y-m-d');
		$id = $args['id'];

		//validate for reqiured information  

		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}


		$check_user = "Select pr.user_id,usr.contact_name as contactname,usr.username as clientname from {$table_prefix}users as usr JOIN {$table_prefix}password_recovery as pr on usr.user_id=pr.user_id where recovery_id =:id";
		$user_det = $this->db->prepare($check_user);
		$user_det->bindParam(":id", $id);
		$user_det->execute();
		$user_data = $user_det->fetchAll();
		$contactname = $user_data[0]['contactname'];
		$clientname = $user_data[0]['clientname'];

		$recoveryId = strtoupper(bin2hex(random_bytes(12)));
		$recoveryId = substr(chunk_split($recoveryId, 8, "-"), 0, -1);

		if ($user_data) {
			$user_type = "user";
			$agency = "update " . $table_prefix . "password_recovery set recovery_id=:recoveryid,updated=:updated where recovery_id=:id";
			$edit_agency = $this->db->prepare($agency);
			$edit_agency->bindParam(":id", $id);
			$edit_agency->bindParam(":recoveryid", $recoveryId);
			$edit_agency->bindParam(":updated", $datetime);
			$edit_agency->execute();


			$mail = "Select email_address from {$table_prefix}users where user_id = 1;";
			$mail_det = $this->db->prepare($mail);
			$mail_det->execute();
			$mail_data = $mail_det->fetchAll();

			$from = $mail_data[0]['email_address'];
			include_once ('../../config.php');



			$email_sent = mail($to, $subject, $message, $headers);
			$recoveryUrl = $agencypath . "password_recovery.php?id={$recoveryId}";
			//print_r($from);exit("ok");
			$to = $email;

			$subject = 'Reset Your Adsphere Hub Password';

			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
			$headers .= 'From: ' . $from . "\r\n";
			$message = '<html><style type="text/css">strong {background: #eee;font-size: 10px;}</style><body>';

			//$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';

			$message .= "<p>Dear " . $contactname . ",</p>";
			$message .= "<p>You, or someone pretending to be you, recently requested that your Adsphere Hub password be reset.
			</p>";
			$message .= "<p>If this request was made by you, then you can reset the password for your username '" . $clientname . "' by
			clicking on the following link:</p>";
			$message .= "<p><a href='$recoveryUrl'>$recoveryUrl</a></p>";
			$message .= "<p>If you submitted the password reset request by mistake, or if you didn't make a request at all, simply
			ignore this email. No changes have been made to your password and the password reset link will expire
			automatically.</p>";
			$message .= "<p>If you continue to receive these password reset mails, then it may indicate that someone is attempting
			to gain access to your username. In that case, please contact the support team or system administrator
			for your Adsphere Hub system, and notify them of the situation.</p>";


			$message .= '<p>Sincerely,</p>';
			$message .= "<p><a href='$from' title='adminmail'>$from</a></p>";
			$message .= "</body></html>";
			//$message .= "</table>";

			mail($to, $subject, $message, $headers);

			$response = array ('response' => 'ok', 'msg' => 'Mail sent successfully');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'User not found');
			return $this->response->withJson($response);
		}
	}
});
