<?php
include ('session.php');
include ('../config.php');
include ('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['strReport_Zone_Report_Head'] ?>
    </title>

    <meta name="description" content="" />
    <style>
        h5 {
            position: relative;
            left: 250%;
        }

        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }

        @media screen and (min-width:700px) {
            .daySelection {
                width: 38%;
                display: flex;
                justify-content: end;
            }
        }

        @media screen and (min-width:420px) and (max-width:699px) {
            .daySelection {
                width: 40%;
                display: flex;
                justify-content: center;
            }

            .main-chart {
                /* width: 200px;
                height: 400px; */
                width: auto;
                height: auto;
                margin: auto;
            }
        }

        @media screen and(min-width:220px) and (max-width:419px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

            .main-chart {
                /* width: 90%; */
                /* height: 2100px; */
                width: auto;
                height: auto;
                margin: auto;
            }

            /* #myChart4{
                width: 227px;
                height: 300px;
            } */

            /* .country-chart{
                width: 100%;
                height: 600px;
            } */
        }

        @media screen and (max-width: 219px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

        }

        .left-col {
            float: left;
            width: 45%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .center-col {
            float: left;
            width: 20%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .right-col {
            float: left;
            width: 35%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        #getBanner {
            width: 40% !important;
        }

        @media only screen and (max-width: 767px) {
            .left-col {
                float: left;
                width: 45%;
                margin-top: 4rem;
                margin-bottom: 2rem;
            }

            .right-col {
                float: left;
                width: 35%;
                margin-top: 1rem;
                margin-bottom: 2rem;
                margin-right: 1px;
            }
        }

        .table #alltotal tr th {
            padding-right: 20px;
        }

        .table tfoot #total,
        #totalall th {
            padding-right: 20px;
            text-align: center;
        }
    </style>
    <?php include ('head.php'); ?>
</head>

<body onload="get_all_publisher()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class="row mb-2 mt-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h4">
                                            <?php echo $GLOBALS['zone_report']; ?>
                                        </p>
                                        <input type='hidden' name="campaignid" id="campaignid"
                                            value="<?php echo $_GET['campaignid']; ?>" />
                                        <input type='hidden' id="startDate"
                                            value="<?php echo $_GET['start_date']; ?>" />
                                        <input type='hidden' id="endDate" value="<?php echo $_GET['end_date']; ?>" />
                                    </div>
                                </div>
                                <div class="row mt-2 mb-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <select id="pub_list" name="pub_list" class="form-select text-dark"
                                            onchange="get_websites('changed');">
                                        </select>
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <select id="website" class="form-select text-dark"
                                            onchange="onChangeDetails('changed')"></select>
                                    </div>

                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" id="back_button" class="btn btn-warning"
                                            onclick="back_button()">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>&nbsp;&nbsp;
                                        <select id="getBanner" name="allfilter"
                                            class="form-select text-dark daySelection w-30"
                                            aria-label="Default select example" onchange="onChangeDetails(this.value)">
                                            <option value="Today" selected>
                                                <?php echo $GLOBALS['strToday']; ?>
                                            </option>
                                            <option value="Yesterday">
                                                <?php echo $GLOBALS['strYesterday']; ?>
                                            </option>
                                            <option value="Last 7 days">
                                                <?php echo $GLOBALS['strLast 7 days']; ?>
                                            </option>
                                            <option value="Last 30 days">
                                                <?php echo $GLOBALS['strLast 30 days']; ?>
                                            </option>
                                            <option value="Last Month">
                                                <?php echo $GLOBALS['strLast Month']; ?>
                                            </option>
                                            <option value="This Month">
                                                <?php echo $GLOBALS['strThis Month']; ?>
                                            </option>
                                            <option value='All Statistics'>
                                                <?php echo $GLOBALS['strAll Statistics']; ?>
                                            </option>
                                            <option value="Custom">
                                                <?php echo $GLOBALS['strCustom']; ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div
                                    class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <input style="display: none; margin-left:3%;width:20%" id="daterange"
                                        name="daterange" />
                                </div>
                                <hr class="solid">
                                <div class="table-responsive text-nowrap">
                                    <table id="bannerrep" class="table table-striped table-responsive">
                                        <thead>
                                            <tr class="text-dark">
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['strName']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['view_imp']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strImpressions']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['device_imp']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['mobile_imp']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strClicks']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strConversions']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['view_imp_rate']; ?>%
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strCTR']; ?> %
                                                </th>
                                                <th class="text-dark text-start">
                                                    <?php echo $GLOBALS['strEarnings']; ?>
                                                </th>
                                                <th class="text-dark text-start">
                                                    <?php echo $GLOBALS['strECPM']; ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <thead id="alltotal" style='display:none'>
                                            <tr>
                                                <th class="text-dark text-start">
                                                    <?php echo $GLOBALS['over_total']; ?>
                                                </th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                        <tfoot id="foot" style="display:none">
                                            <tr id="totalall" style="display:none">
                                                <th class="text-dark text-start">
                                                    <?php echo $GLOBALS['over_total']; ?>
                                                </th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                            <tr id="total">
                                                <th class="text-dark text-start">
                                                    <?php echo $GLOBALS['total']; ?>
                                                </th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include ('footer.php'); ?>
                    <!-- / Footer -->
                    <script>
                        const live_URL = '<?php echo $apistatpath; ?>';
                        var live_URL1 = '<?php echo $apiinvenpath; ?>';
                        const token = 'Bearer ' + document.getElementById('token').value;
                        let agency_id = document.getElementById('agencyid').value;
                        let getTodayDate;
                        let userid = '<?php echo $_SESSION['user_id']; ?>';
                        var permissions = [];
                        //API's
                        let domain_url = live_URL + '/get_publisher_zone_statistics_new/';
                        let zone_url = live_URL + '/get_agency_publisher_zone_statistics/';
                        let affiliate_Id = '<?php echo $_GET['affiliate_id'] ?>';
                        var pubname = '<?php echo $_REQUEST['pub_id']; ?>';
                        let getparams = '<?php echo $_REQUEST['params']; ?>'

                        if (pubname) {
                            $('#pub_list').attr("disabled", true);
                        }
                        if (affiliate_Id) {
                            $('#website').attr("disabled", true);
                        }

                        var pubValue = localStorage.getItem('pubValue');
                        var webValue = localStorage.getItem('webValue');

                        $('#back_button').hide();

                        function get_all_publisher() {
                            // var camplist_option = $('#camplist option:selected').val();
                            $.ajax({
                                type: "GET",
                                url: live_URL1 + '/get_all_publisher/' + agency_id,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                var pub_name = [];
                                if (!data.data) {
                                    $('#pub_list').hide();
                                    $('#website').hide();
                                    onChangeDetails();
                                    /* $('#website_add').attr("disabled", true);
                                    $('#warning').show();
                                    $('#warning_msg').html("There are currently no publisher defined. To create a website, add a new publisher first."); */

                                } else {
                                    data.data.map((data) => {
                                        getpubLength = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
                                        pub_name += `<option value=${data.id} title="${data.name}">${getpubLength}</option>`;
                                        document.getElementById('pub_list').innerHTML = pub_name;


                                    });
                                    if (pubname != "") {
                                        document.getElementById('pub_list').value = pubname;
                                    }
                                    else if (pubValue != '' && pubValue != null && pubValue != 'undefined') {
                                        $('#pub_list option').each(function () {
                                            if (this.value == pubValue) {
                                                $("#pub_list").val(pubValue);
                                            }
                                        });
                                        // document.getElementById('advlist').value = advValue;
                                    }
                                    get_websites();
                                }
                            });
                        }

                        function get_websites(changed) {
                            var webValue = localStorage.getItem("webValue");
                            if (pubname != "") {
                                var pubid = pubname;
                            } else {
                                var pubid = $("#pub_list option:selected").val();
                            }
                            $.ajax({
                                type: "GET",
                                url: live_URL1 + '/get_publisherwise_website/' + pubid,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                dataType: "json",
                                encode: true,
                            }).done(function (data) {
                                if (data.msg == "Enter valid publisher Id!") {
                                    $('#website').hide();
                                    document.getElementById('website').innerHTML = "";
                                } else {
                                    $('#website').show();
                                    let websites = [],
                                        getWebsiteName;
                                    if (data.data) {

                                        data.data.map((data) => {
                                            getWebsiteName = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
                                            websites += `<option value=${data.affiliateid} title="${data.name}">${getWebsiteName}</option>`;
                                            document.getElementById('website').innerHTML = websites;
                                        });
                                    }
                                    // $('#website').html(websites);
                                    if (affiliate_Id != '') {
                                        $('#website').val(affiliate_Id);
                                        $('#website').attr('disabled', true);
                                        $('#back_button').show();
                                    } else if (webValue != '' && webValue != null && webValue != 'undefined') {
                                        $('#website option').each(function () {
                                            if (this.value == webValue) {
                                                $("#website").val(webValue);
                                            }
                                        });
                                    }
                                }
                                onChangeDetails();
                            });

                        }

                        function onChangeDetails(changed) {
                            $(".loader").show();
                            let date = new Date();
                            let getSelectedDay = document.getElementById('getBanner').value;

                            document.getElementById('daterange').style.display = getSelectedDay == 'Custom' ? "block" : "none";

                            switch (getSelectedDay) {
                                case 'Today':
                                    let v3 = JSON.stringify(date).slice(1, 11);
                                    getTodayDate = v3;
                                    getBannerDate(v3, v3);
                                    break;
                                case 'Yesterday':
                                    let current_date = date.setDate(date.getDate() - 1);
                                    const get_date = new Date(date);
                                    let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                                    getBannerDate(yesterday_date, yesterday_date);
                                    break;
                                case 'Last 7 days':
                                    let calculate_7dyas = date.setDate(date.getDate() - 7);
                                    let start_7Days = new Date(calculate_7dyas);
                                    let first_day = JSON.stringify(start_7Days).slice(1, 11);

                                    let todayDate = new Date();
                                    let current_7Dyas = todayDate.setDate(todayDate.getDate() - 1);
                                    let last_7Days = new Date(todayDate);
                                    let date_end = JSON.stringify(last_7Days).slice(1, 11);
                                    getBannerDate(first_day, date_end);
                                    break;
                                case 'Last 30 days':
                                    let calculate_30dyas = date.setDate(date.getDate() - 30);
                                    let start_30Days = new Date(calculate_30dyas);
                                    var first_30Days = JSON.stringify(start_30Days).slice(1, 11);
                                    first_30Days = first_30Days

                                    let today_Date = new Date();
                                    let current_30Dyas = today_Date.setDate(today_Date.getDate() - 1);
                                    let last_30Days = new Date(today_Date);
                                    let final_30Days = JSON.stringify(last_30Days).slice(1, 11);
                                    getBannerDate(first_30Days, final_30Days);
                                    break;
                                case 'Last Month':
                                    var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                    var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                    var formatDateComponent = function (dateComponent) {
                                        return (dateComponent < 10 ? '0' : '') + dateComponent;
                                    }
                                    var formatDate = function (date) {
                                        return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                    };
                                    getBannerDate(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
                                    break;
                                case 'This Month':
                                    let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                    let cYear = firstDay.getFullYear(),
                                        cMonth = firstDay.getMonth() + 1,
                                        cDate = firstDay.getDate();
                                    let start_thisMonth = cYear + "-" + cMonth + "-" + cDate;

                                    let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                    let year = lastDay.getFullYear(),
                                        month = lastDay.getMonth() + 1,
                                        day = lastDay.getDate();
                                    let end_thisMonth = year + "-" + month + "-" + day;
                                    getBannerDate(start_thisMonth, end_thisMonth);
                                    break;
                                case 'All Statistics':
                                    getBannerDate(start_holeDate = 0, end_holeDate = 0);
                                    break;
                                case 'Custom':
                                    $(".loader").hide();
                                    let getCurrentDate = JSON.stringify(date).slice(1, 11);
                                    getBannerDate(getCurrentDate, getCurrentDate);
                                    $(function () {
                                        $('input[name="daterange"]').daterangepicker({
                                            opens: 'left',
                                            locale: {
                                                format: 'DD/MM/YYYY'
                                            },
                                        }, function (start, end, label) {
                                            getBannerDate(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                        })
                                    })
                                    break;
                            };
                            if (changed) {
                                localStorage.setItem("webValue", $("#website option:selected").val());
                                //location.reload();
                            }
                            localStorage.setItem('pubValue', $("#pub_list option:selected").val());

                        };

                        function getBannerDate(start_date, end_date) {

                            let affiliate_id = $('#website').val();

                            let payload = (start_date == 0 && end_date == 0) ? {
                                "action": 'all'
                            } : {
                                "action": '',
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,'
                            };

                            $.ajax({
                                url: domain_url + affiliate_id,
                                type: 'POST',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: payload,
                                success: function (data) {
                                    $(".loader").hide();

                                    if (data.msg == 'No Stats Available') {
                                        $('#alltotal').hide();
                                        $("#foot").hide();
                                        $('#bannerrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: false,
                                            bPaginate: false,
                                            bInfo: false,
                                            data: [],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable: "No Data Found"
                                            }
                                        });
                                    } else if (data.msg == 'Please enter valid Publisher Id') {
                                        //$('#website').hide();
                                        $('#alltotal').hide();
                                        $("#foot").hide();
                                        $('#bannerrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: false,
                                            bPaginate: false,
                                            bInfo: false,
                                            data: [],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable: "No Data Found"
                                            }
                                        });
                                    } else {
                                        $('#alltotal').show();
                                        $("#foot").show();
                                        $('#bannerrep').DataTable({
                                            ordering: true,
                                            destroy: true,
                                            "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                            buttons: [
                                                {
                                                    extend: 'collection',
                                                    text: 'Export',
                                                    autoClose: true,
                                                    className: 'btn btn-warning btn-sm export',
                                                    buttons: [
                                                        {
                                                            text: 'Excel',
                                                            extend: 'excel',
                                                            header: true,
                                                            footer: true,
                                                            visible: false,
                                                            "customize": function (xlsx) {
                                                                var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                                $('row c', sheet).attr('s', '51'); //for all rows                                                                                                                            
                                                            }
                                                        },
                                                        {
                                                            text: 'PDF',
                                                            extend: 'pdf',
                                                            header: true,
                                                            footer: true,
                                                            visible: false,
                                                            orientation: 'landscape',
                                                            pageSize: 'LEGAL',
                                                            customize: function (doc) {
                                                                doc.styles.tableBodyEven.alignment = 'center';
                                                                doc.styles.tableBodyOdd.alignment = 'center';
                                                                doc.styles.tableFooter.alignment = 'center';
                                                            },
                                                        }
                                                    ],
                                                    fade: true,
                                                }
                                            ],
                                            data: data,
                                            columns: [{
                                                data: 'zonename',
                                                className: 'tableName text-dark'
                                            },
                                            {
                                                data: 'views',
                                                className: "text-center"
                                            },
                                            {
                                                data: 'impressions',
                                                className: "text-center"
                                            },
                                            {
                                                data: 'desktop_impression',
                                                className: "text-center",
                                                render: function (data, type, row, meta) {
                                                    return row.desktop_impression == null ? "0" : row.desktop_impression;
                                                }
                                            },
                                            {
                                                data: 'mobile_impression',
                                                className: "text-center",
                                                render: function (data, type, row, meta) {
                                                    return row.mobile_impression == null ? "0" : row.mobile_impression;
                                                }
                                            },
                                            {
                                                data: 'clicks',
                                                className: "text-center"
                                            },
                                            {
                                                data: 'conversions',
                                                className: "text-center"
                                            },
                                            {
                                                data: 'viewableimpressionrate',
                                                className: "text-center"
                                            },
                                            {
                                                data: 'ctr',
                                                className: "text-center"
                                            },
                                            {
                                                data: 'revenue',
                                                className: "text-center",
                                                render: function (data, type, row, meta) {
                                                    return row.revenue == null ? "0.00" : row.revenue;
                                                }
                                            },
                                            {
                                                data: 'ecpm',
                                                className: "text-center",
                                                render: function (data, type, row, meta) {
                                                    return row.ecpm == null ? "0.00" : row.ecpm;
                                                }
                                            },
                                            ],
                                            "footerCallback": function (row, data, start, end, display) {
                                                var api = this.api(),
                                                    data;

                                                // converting to interger to find total
                                                var intVal = function (i) {
                                                    return typeof i === 'string' ?
                                                        i.replace(/[\$,]/g, '') * 1 :
                                                        typeof i === 'number' ? i : 0;
                                                };

                                                // computing column Total of the complete result 
                                                var view_imp = api
                                                    .column(1, { page: 'current' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var impressions = api
                                                    .column(2, { page: 'current' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var desktop_imp = api
                                                    .column(3, { page: 'current' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var mobile_imp = api
                                                    .column(4, { page: 'current' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var clicks = api
                                                    .column(5, { page: 'current' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var conversions = api
                                                    .column(6, { page: 'current' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var revenue = api
                                                    .column(9, { page: 'current' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var foot_view_imp = api
                                                    .column(1, { page: 'footer' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var foot_impressions = api
                                                    .column(2, { page: 'footer' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var foot_desktop_imp = api
                                                    .column(3, { page: 'footer' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var foot_mobile_imp = api
                                                    .column(4, { page: 'footer' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var foot_clicks = api
                                                    .column(5, { page: 'footer' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var foot_conversions = api
                                                    .column(6, { page: 'footer' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var foot_revenue = api
                                                    .column(9, { page: 'footer' })
                                                    .data()
                                                    .reduce(function (a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                // Update footer by showing the total with the reference of the column index 
                                                // Update footer by showing the total with the reference of the column index 
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(2)').html(view_imp);
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(3)').html(impressions);
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(4)').html(desktop_imp);
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(5)').html(mobile_imp);
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(6)').html(clicks);
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(7)').html(conversions);
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(8)').html((view_imp / impressions * 100).toFixed(2));
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(9)').html((clicks / impressions * 100).toFixed(2));
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(10)').html(revenue.toFixed(2));
                                                $('#bannerrep tfoot tr:nth-child(2) th:nth-child(11)').html((revenue / impressions * 1000).toFixed(2));

                                                $('#bannerrep #alltotal th:nth-child(2)').html(foot_view_imp);
                                                $('#bannerrep #alltotal th:nth-child(3)').html(foot_impressions);
                                                $('#bannerrep #alltotal th:nth-child(4)').html(foot_desktop_imp);
                                                $('#bannerrep #alltotal th:nth-child(5)').html(foot_mobile_imp);
                                                $('#bannerrep #alltotal th:nth-child(6)').html(foot_clicks);
                                                $('#bannerrep #alltotal th:nth-child(7)').html(foot_conversions);
                                                $('#bannerrep #alltotal th:nth-child(8)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                                $('#bannerrep #alltotal th:nth-child(9)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                                $('#bannerrep #alltotal th:nth-child(10)').html(foot_revenue.toFixed(2));
                                                $('#bannerrep #alltotal th:nth-child(11)').html((foot_revenue / foot_impressions * 1000).toFixed(2));

                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(2)').html(foot_view_imp);
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(3)').html(foot_impressions);
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(4)').html(foot_desktop_imp);
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(5)').html(foot_mobile_imp);
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(6)').html(foot_clicks);
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(7)').html(foot_conversions);
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(8)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(9)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(10)').html(foot_revenue.toFixed(2));
                                                $('#bannerrep tfoot tr:nth-child(1) th:nth-child(11)').html((foot_revenue / foot_impressions * 1000).toFixed(2));
                                            },
                                            initComplete: function (settings) {
                                                //settings.nTable.id --> Get table ID
                                                $('#' + settings.nTable.id + '_filter input').wrap(`
                                                    <div class="d-inline-flex position-relative"></div>
                                              `).after(`
                                                    <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                      <span aria-hidden="true">&times;</span>
                                                    </button>
                                               `).attr('required', 'required').attr('title', 'Search');

                                                // Click Event on Clear button
                                                $(document).on('click', '#' + settings.nTable.id + '_filter button', function () {
                                                    $('#' + settings.nTable.id).DataTable({
                                                        "retrieve": true,
                                                    }).search('').draw(); // reDraw table
                                                });
                                            }
                                        });
                                    }
                                    $.ajax({
                                        type: "GET",
                                        url: live_URL1 + '/get_permissions/' + userid,
                                        beforeSend: function (xhr) {
                                            xhr.setRequestHeader('Authorization', token);
                                        },
                                        dataType: "json",
                                        encode: true,
                                    }).done(function (data) {
                                        let get_data = data.data;
                                        if (get_data) {
                                            for (var i = 0; i < get_data.length; i++) {
                                                permissions[i] = get_data[i];
                                            }
                                        } else {
                                            permissions = '';
                                        }
                                        if (!permissions.includes('44')) {
                                            $('.export').hide();
                                        } else {
                                            $('.export').show();
                                        }
                                    });
                                },
                                error: function () { },
                            });
                        };
                        function back_button() {
                            window.location.href = (getparams != '') ? 'websitereport.php' :
                                'websitereport.php?pub_id=' + pubname;
                        }
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>