<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['websites']; ?>
    </title>
    <meta name="description" content="" />
    <?php include ('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        input[type="button"]:hover {
            color: #fff !important;

        }

        .cancel-style:hover {
            color: #fff !important
        }

        .swal-footer {
            text-align: center;
        }

        .alert {
            display: none;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
    </style>
</head>

<body onload="get_all_publisher();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper <i class="menu-icon tf-icons bx bx-plus"></i> -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="card my-4">
                            <div class="card-header">
                                <div class="row mb-1">
                                    <p
                                        class="h2 text-secondary d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <?php echo $GLOBALS['add_websites']; ?>
                                    </p>
                                </div>
                                <div class="row mb-1">
                                    <div class="col-12">
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['website_add']; ?>
                                        </p>
                                        <p class="alert bg-danger alert-dismissible fade show text-white"
                                            id="alertfailed"><i class="fa fa-times-circle"></i>
                                            <?php echo $GLOBALS['website_fail']; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="container">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label for="inputName" class="form-label">
                                                <?php echo $GLOBALS['']; ?>Select Publisher <span
                                                    class="required text-danger"> *</span>
                                            </label>
                                            <select id="publist" name="publist" class="form-select text-dark">


                                            </select>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['strName']; ?><span style="color: red;">*</span>
                                            </label>
                                            <input type="text" id="website_name" class="form-control text-dark"
                                                placeholder="<?php echo $GLOBALS['strName']; ?>"
                                                oninput="changeName(this.value)" onchange="changeName(this.value)"
                                                onkeyup="changeName(this.value)" />
                                            <p id="website_name_error" class="h6 mt-1 text-danger"></p>
                                        </div>
                                    </div>
                                    <div class="row ">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-1">
                                            <label class="form-label" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['web_url']; ?><span
                                                    style="color: red;">*</span>&nbsp;<span class="form-label"
                                                    style="font-size: 1ch;">(with https://)</span>
                                            </label>
                                            <input type="url" name="website_url" id="website_url"
                                                class="form-control text-dark"
                                                placeholder="<?php echo $GLOBALS['web_url']; ?>"
                                                oninput="changeWebsite()" onchange="changeWebsite()"
                                                onkeyup="changeWebsite()" />
                                            <p id="website_url_error" class="h6 mt-1 text-danger"></p>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-1">
                                            <label class="form-label" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['Email']; ?><span style="color: red;">*</span>
                                            </label>
                                            <input type="email" id="website_email" class="form-control text-dark"
                                                placeholder="<?php echo $GLOBALS['Email']; ?>" />
                                            <!--oninput="changeEmail()"
                                                onkeyup="changeEmail()" onchange="changeEmail()"-->
                                            <p id="website_email_error" class="h6 text-danger"></p>
                                        </div>
                                    </div>
                                    <div class="row ">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label" style="font-size: 1.4ch;">
                                                <?php echo $GLOBALS['contact']; ?><span style="color: red;">*</span>
                                            </label>
                                            <input type="text" id="website_contact" class="form-control text-dark"
                                                placeholder="<?php echo $GLOBALS['contact']; ?>"
                                                oninput="changeContact()" onkeyup="changeContact()"
                                                onchange="changeContact()" />
                                            <p id="website_contact_error" class="h6 text-danger"></p>
                                        </div>
                                    </div>

                                    <div class="row mb-2">

                                    </div>
                                    <div class="row mb-4">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6"></div>
                                        <div
                                            class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button class="btn btn-outline-danger cancel-style" type="button"
                                                style="margin-right: 2%;" id="cancel" onclick="cancelbtn()">
                                                <?php echo $GLOBALS['strCancel']; ?>
                                            </button>
                                            <button class="btn btn-warning" type="button" id="save_changes"
                                                onclick="onSubmitWebsite()">
                                                <?php echo $GLOBALS['strSubmit']; ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include ('footer.php'); ?>
            </div>
        </div>
    </div>
    <script>
        const live_URL = '<?php echo $apiinvenpath; ?>';
        const token = 'Bearer ' + document.getElementById('token').value;
        let userID = '<?php echo $_SESSION['user_id'] ?>';
        let addWebsite_api = live_URL + '/add_website_new/';
        let pubid = '<?php echo $_REQUEST['pubid']; ?>';
        let pub_id = '<?php echo $_REQUEST['pub_id']; ?>';
        if (pubid) {
            $('#publist').prop('disabled', true);
        }
        let getparams = '<?php echo $_REQUEST['params']; ?>';

        function get_all_publisher() {
            var agencyid = document.getElementById('agencyid').value;
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_publisher/' + agencyid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                console.log("success data", data);
                var pub_name = [];
                data.data.map((data) => {
                    getpubLength = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
                    pub_name += `<option value=${data.id} title="${data.name}">${getpubLength}</option>`;
                    document.getElementById('publist').innerHTML = pub_name;
                });
                if (pubid != '') {
                    if (pubid != 0) {
                        $('#publist').val(pubid);
                        $('#publist').prop('disabled', true);
                    }
                } else {
                    if (pub_id != 0) {
                        $('#publist').val(pub_id);
                    }
                }
            });
        }

        let pattern = new RegExp(
            '^(https?:\\/\\/)?' + // protocol
            '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' + // domain name
            '((\\d{1,3}\\.){3}\\d{1,3}))' + // OR ip (v4) address
            '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + // port and path
            '(\\?[;&a-z\\d%_.~+=-]*)?' + // query string
            '(\\#[-a-z\\d_]*)?$', // fragment locator
            'i'
        );
        //let emailPattern = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;


        let validName, nameValidMsg, validWebsite, test1, test2;

        changeWebsite = () => {
            let website_value = document.getElementById('website_url').value;
            let validURL = website_value.split('//');

            document.getElementById('website_url_error').innerHTML = website_value == "" ? (validWebsite = true, nameValidMsg = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`) :
                pattern.test(website_value) == false ? (validWebsite = true, `<?php echo $GLOBALS['enter_valid_url']; ?>`) :
                    (validURL[0] === 'http:' || validURL[0] === 'https:') ? (test1 = true, "") : (test1 = false, test2 = `<?php echo $GLOBALS['add_http']; ?>`);
        };

        changeName = (data) => {
            let name = document.getElementById('website_name').value;
            document.getElementById('website_name_error').innerHTML = name == "" ? (validName = true, `<?php echo $GLOBALS['enter_name']; ?>`) :
                (validName = false, "");
        };

        /*changeEmail = () => {
            let emailId = document.getElementById('website_email').value;
            document.getElementById('website_email_error').innerHTML = emailId == "" ? `<?php echo $GLOBALS['enter_emailid']; ?>` :
                emailId.match(emailPattern) ? "" : `<?php echo $GLOBALS['enter_right_emailid']; ?>`;
        };*/

        changeContact = () => {
            let contact = document.getElementById('website_contact').value;
            document.getElementById('website_contact_error').innerHTML = contact == "" ? `<?php echo $GLOBALS['enter_contact']; ?>` : "";
        };

        //on paste validation
        $("#website_url,#website_name,#website_email, #website_contact").bind("paste", function (e) {
            let attr_id = e.target.id;
            let pasted_data = e.originalEvent.clipboardData.getData('text');
            if (attr_id == 'website_url') {
                document.getElementById("website_url_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['strBanner_URL_validation']; ?>` :
                    pattern.test(pasted_data) == false ? `<?php echo $GLOBALS['enter_valid_url']; ?>` : "";
            }
            if (attr_id == 'website_name') {
                document.getElementById("website_name_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['enter_name']; ?>` : "";
            }
            if (attr_id == 'website_email') {
                document.getElementById("website_email_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['website_email']; ?>` : "";
            }
            if (attr_id == 'website_contact') {
                document.getElementById("website_contact_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['enter_contact']; ?>` : "";
            }
        });

        onSubmitWebsite = () => {
            var pubid = $("#publist option:selected").val();
            let website_value = document.getElementById('website_url').value;
            let validURL = website_value.split('//');
            let name = document.getElementById('website_name').value;
            let emailId = document.getElementById('website_email').value;
            let contact = document.getElementById('website_contact').value;

            let payload = {
                "website": website_value,
                "name": name,
                "contact": contact,
                "email": emailId
            };

            changeWebsite();
            changeName();
            //changeEmail();
            changeContact();
            
            /*else if (emailId.match(emailPattern) == false) {
                document.getElementById('website_email_error').innerHTML = `<?php echo $GLOBALS['email_validation']; ?>`;
            }*/

            if (website_value == "") {
                document.getElementById('website_url_error').innerHTML = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`;
            } else if (test1 == false) {
                document.getElementById('website_url_error').innerHTML = `<?php echo $GLOBALS['add_http']; ?>`;
            } else if (pattern.test(website_value) == false) {
                document.getElementById('website_url_error').innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
            } else if (name == "") {
                document.getElementById('website_name_error').innerHTML = `<?php echo $GLOBALS['enter_name']; ?>`;
            } else if (emailId == "") {
                document.getElementById('website_email_error').innerHTML = `<?php echo $GLOBALS['website_email']; ?>`;
            }  else if (contact == "") {
                document.getElementById('website_contact_error').innerHTML = `<?php echo $GLOBALS['enter_contact']; ?>`;
            } else {
                document.getElementById('website_url_error').innerHTML = "";
                document.getElementById('website_name_error').innerHTML = "";
                document.getElementById('website_email_error').innerHTML = "";
                document.getElementById('website_contact_error').innerHTML = "";
                $('#save_changes').prop('disabled', true);
                $.ajax({
                    type: "POST",
                    url: addWebsite_api + pubid,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: payload,
                    dataType: "json",
                    encode: true,
                }).done(function (data) {
                    if (data.msg == 'Website added successfully!' && data.statuscode == 200) {
                        $("#alertsuccess").show('medium');
                        setTimeout(function () {
                            $("#alertsuccess").hide('medium');
                            $('#save_changes').prop('disabled', false);
                        }, 2000);
                        setTimeout(function () {
                            window.location.href =
                (pub_id == '' && getparams == '') ? ("websites_list.php?pubid=" + pubid + "") : (pubid != "" && getparams == 1) ? 'publishers_list.php' : "websites_list.php";
                        }, 1700);
                    } else if (data.msg == "Please check with input parameters" && data.response == "error") {
                        alert("Fill the all fields in the form");
                    } else {
                        // location.reload();
                        $("#alertfailed").show('medium');
                        setTimeout(function () {
                            $("#alertfailed").hide('medium');
                            $('#save_changes').prop('disabled', false);
                        }, 2000);
                    }
                });
            }
        };

        cancelbtn = () => {
            window.location.href =
                (pub_id == '' && getparams == '') ? ("websites_list.php?pubid=" + pubid + "") : (pubid != "" && getparams == 1) ? 'publishers_list.php' : "websites_list.php";
        }
    </script>

</body>

</html>