<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['user_audit']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        .alert {
            display: none;
        }

        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .dataTables_scrollBody {
            height: auto !important;
        }

        #camplist {
            width: 30%;
            border-color: #696cff;
            display: inline;
        }

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }
    </style>
</head>

<body onload="get_useraudit()">
    <!-- Layout wrapper  -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card my-4">
                            <div class="card-body">
                                <div class="row">
                                <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3">
                                            <?php echo $GLOBALS['user_audit']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    </div>
                                </div>

                                <hr class="solid">
                                
                                <div class="row">
                                    <div class="table-responsive text-nowrap">
                                        <table id="adv_table"
                                            class="table table-striped table-responsive table-hover mt-3">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['module']; ?>
                                                    </th>
                                                    <th class="th-color">
                                                        <?php echo $GLOBALS['created_user']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['created_date']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['updated_user']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['updated_date']; ?>
                                                    </th>
													<th class="th-color text-center">
                                                        <?php echo $GLOBALS['deleted_user']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['deleted_date']; ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody id="fbody" class="fbody">

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var agencyid = document.getElementById('agencyid').value;
        let userid = '<?php echo $_SESSION['user_id']; ?>';
        var permissions = [];
        $("#deleteadvertiser").prop("disabled", true);

        function get_useraudit() {
            $.ajax({
                url: live_URL + '/get_all_user_audit/' + agencyid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    $(".loader").hide();
                    showdata(data);
                },
                error: function () { },
            });

        }

        function showdata(data) {
            $(".loader").show();

            if (data.msg == 'Please enter valid Agency id!') {
                $('#warning').show();
                $('#warning_msg').html("<?php echo $GLOBALS['']; ?>There are currently no Orders/Jobs defined. To create a campaign, add a new Order/Job first.");
                $(".loader").hide();
                $('#adv_table').DataTable({
                    ordering: false,
                    destroy: true,
                    responsive: true,
                    bPaginate: false,
                    bAutoWidth: false,
                    bInfo: false,
                    data: [],
                    searching: false,
                    oLanguage: {
                        sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                    }
                });
            } else {
                //$(".loader").hide();
                $(document).ready(function () {
                    var rows_selected = [];
                    var table = $('#adv_table').DataTable({
                        destroy: true,
                        targets: 0,
                        searchable: false,
                        orderable: false,
                        stateSave: false,
                        //fixedColumns: true,
                        //className: 'dt-body-center',
                        responsive: false,
                        data: data.data,

                        columns: [{
                            data: 'module',
                            className: "text-center",
                            render: function (data, type, row, meta) {
                                return row.module;;
                            }
                        },
                        {
                            data: 'create_user',
                            className: "text-left tableName",
                            render: function (data, type, row, meta) {
							if(row.created_date=='0000-00-00 00:00:00')
							{
                                return '<font color="red">No Data</font>';
                            }else{
							    return row.create_user;
							}
							}
                        },
                        {
                            data: 'created_date',
                            className: "text-center",
                            render: function (data, type, row, meta) {
                            if(row.created_date=='0000-00-00 00:00:00')
							{
                                return '<font color="red">No Data</font>';
                            }else{ 
                                return row.created_date;
							}
                            }
                        },
                        {
                            data: 'update_user',
                            className: "text-center",
                            render: function (data, type, row, meta) {
							
							if(row.updated_date=='0000-00-00 00:00:00')
							{
                                return '<font color="red">No Data</font>';
                            }else{
                             
                                return row.update_user;
								
							}
                            }
                        },
                        {
                            data: 'updated_date',
                            className: "text-center",
                            render: function (data, type, row, meta) {
							
							if(row.updated_date=='0000-00-00 00:00:00')
							{
                                return '<font color="red">No Data</font>';
                            }else{
							
                                return row.updated_date;
								
							}
                            }
                        },
						{
                            data: 'delete_user',
                            className: "text-center",
                            render: function (data, type, row, meta) {
                            if(row.deleted_date=='0000-00-00 00:00:00')
							{
                                return '<font color="red">No Data</font>';
                            }else{  
                                return row.delete_user;
							}
                            }
                        },
						{
                            data: 'deleted_date',
                            className: "text-center",
                            render: function (data, type, row, meta) {
                            if(row.deleted_date=='0000-00-00 00:00:00')
							{
                                return '<font color="red">No Data</font>';
                            }else{  
                                return row.deleted_date;
							}
                            }
                        },
                        ],
                    })

                    // Handle click on checkbox
                    $('#adv_table tbody').on('click', 'input[type="checkbox"]', function (e) {
                        var $row = $(this).closest('tr');
                        var data = table.row($row).data();
                        var rowId = table.row(this).data[0];
                        var index = $.inArray(rowId, rows_selected);

                        if (this.checked && index === -1) {
                            rows_selected.push(rowId);
                        } else if (!this.checked && index !== -1) {
                            rows_selected.splice(index, 1);
                        }

                        if (this.checked) {
                            $row.addClass('selected');
                            document.getElementById('deleteadvertiser').disabled = $('.data-checked:checked').length > 0 ? false : true;
                        } else {
                            $row.removeClass('selected');
                            document.getElementById('deleteadvertiser').disabled = $('.data-checked:checked').length > 0 ? false : true;
                        }

                        updateDataTableSelectAllCtrl(table);
                        e.stopPropagation();
                    });
                    // Handle click on "Select all" control
                    $('thead input[name="select_all"]', table.table().container()).on('click', function (e) {
                        if (this.checked) {
                            $('#adv_table tbody input[type="checkbox"]:not(:checked)').trigger('click');
                            document.getElementById('deleteadvertiser').disabled = $('.data-checked:checked').length > 0 ? false : true;
                        } else {
                            $('#adv_table tbody input[type="checkbox"]:checked').trigger('click');
                            document.getElementById('deleteadvertiser').disabled = $('.data-checked:checked').length > 0 ? false : true;
                        }
                        e.stopPropagation();
                    });
                    // Handle table draw event
                    table.on('draw', function () {
                        updateDataTableSelectAllCtrl(table);
                    });
                })
            }
            $.ajax({
                type: "GET",
                url: live_URL + '/get_permissions/' + userid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: "json",
                encode: true,
            }).done(function (data) {
                let get_data = data.data;
                if (get_data) {
                    for (var i = 0; i < get_data.length; i++) {
                        permissions[i] = get_data[i];
                    }
                } else {
                    permissions = '';
                }
                if (!permissions.includes('31')) {
                    $('#addBannerButton').hide();
                } else {
                    $('#addBannerButton').show();
                }
                if (!permissions.includes('32')) {
                    $('#adv_table').DataTable().column(0).visible(false);
                    $('#deleteadvertiser').hide();
                } else {
                    $('#adv_table').DataTable().column(0).visible(true);
                    $('#deleteadvertiser').show();
                }
                if (!permissions.includes('33')) {
                    $('#adv_table').DataTable().column(3).visible(false);
                }
                else {
                    $('#adv_table').DataTable().column(3).visible(true);
                }
            });
        }

        function delete_advertiser() {
            var advData = [];
            var selected = $('#checkrow:checked');
            selected.each(function () {
                advData.push($(this).attr('data-clientid'));
            });
            if (advData.length <= 0) {
                alert("Please select advertiser.");
            }

            swal({
                title: `<?php echo $GLOBALS['want_delete_advertiser']; ?>`,
                buttons: true,
                dangerMode: true,
                type: "success"
            }).then(function (isConfirm) {

                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: live_URL + '/advertiser_delete/' + advData,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        if (data.msg = "Advertiser has been deleted successfully!") {
                            window.scrollTo(0, 0);
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 2000);
                            setTimeout(function () {
                                location.reload();
                            }, 1200);
                        } else {
                            window.scrollTo(0, 0);
                            $("#alertfailed").show('medium');
                            setTimeout(function () {
                                $("#alertfailed").hide('medium');
                            }, 2000);
                        }

                    });
                }
            });
        }
    </script>
</body>

</html>