<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['publisher_report']; ?>
    </title>
    <meta name="description" content="" />
    <?php include ('head.php'); ?>

    <style>
        body {
            font-family: "Open Sans", "-apple-system, BlinkMacSystemFont", "Segoe UI", "Roboto", "Oxygen-Sans", "Ubuntu", "Cantarell", "Helvetica Neue", Helvetica, Arial, sans-serif;
        }

        .alert {
            display: none;
        }

        .tbodyDiv {
            max-height: 50vh;
            overflow: auto;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        /* #camplist {
            width: 30%;
            display: inline;
        } */

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        .dataTables_wrapper .dt-buttons {
            float: none;
            text-align: center;
            margin-bottom: 10px;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }

        @media screen and (min-width:700px) {
            .daySelection {
                width: 30%;
                display: flex;
                justify-content: end;
            }
        }

        @media screen and (min-width:420px) and (max-width:699px) {
            .daySelection {
                width: 40%;
                display: flex;
                justify-content: center;
            }

            .main-chart {
                /* width: 200px;
                height: 400px; */
                width: auto;
                height: auto;
                margin: auto;
            }
        }

        @media screen and(min-width:220px) and (max-width:419px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

            .main-chart {
                /* width: 90%; */
                /* height: 2100px; */
                width: auto;
                height: auto;
                margin: auto;
            }

            /* #myChart4{
                width: 227px;
                height: 300px;
            } */

            /* .country-chart{
                width: 100%;
                height: 600px;
            } */
        }

        @media screen and (max-width: 219px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

        }

        .left-col {
            float: left;
            width: 45%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .center-col {
            float: left;
            width: 20%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .right-col {
            float: left;
            width: 35%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        @media only screen and (max-width: 767px) {
            .left-col {
                float: left;
                width: 45%;
                margin-top: 4rem;
                margin-bottom: 2rem;
            }

            .right-col {
                float: left;
                width: 35%;
                margin-top: 1rem;
                margin-bottom: 2rem;
                margin-right: 1px;
            }
        }

        .table #alltotal tr th {
            padding-right: 20px;
        }

        .table tfoot #total,
        #totalall th {
            padding-right: 20px;
            text-align: center;
        }
    </style>
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class="row mt-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h4">
                                            <?php echo $GLOBALS['publisher_report']; ?>
                                        </p>
                                    </div>
                                    <!--<div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-6 h-75 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="camplist" name="camplist" class="form-select text-dark w-75" onchange=>
                                            <option selected value="1">
                                                <?php echo $GLOBALS['alladevrtisers']; ?>
                                            </option>
                                            <option value="0">
                                                <?php echo $GLOBALS['activeadevrtisers']; ?>
                                            </option>
                                        </select>
                                    </div>-->
                                </div>
                                <div class="row mb-2 mt-2">
                                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">

                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="getCampaign" class="form-select text-dark daySelection w-30"
                                            aria-label="Default select example" onchange="onChangeDetails()">
                                            <option value="Today" selected>
                                                <?php echo $GLOBALS['strToday']; ?>
                                            </option>
                                            <option value="Yesterday">
                                                <?php echo $GLOBALS['strYesterday']; ?>
                                            </option>
                                            <option value="Last 7 days">
                                                <?php echo $GLOBALS['strLast 7 days']; ?>
                                            </option>
                                            <option value="Last 30 days">
                                                <?php echo $GLOBALS['strLast 30 days']; ?>
                                            </option>
                                            <option value="Last Month">
                                                <?php echo $GLOBALS['strLast Month']; ?>
                                            </option>
                                            <option value="This Month">
                                                <?php echo $GLOBALS['strThis Month']; ?>
                                            </option>
                                            <option value='all statistics'>
                                                <?php echo $GLOBALS['strAll Statistics']; ?>
                                            </option>
                                            <option value="custom">
                                                <?php echo $GLOBALS['strCustom']; ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <!--<div class="row mb-2 mt-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">

                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">

                                    </div>

                                    
                                </div>-->
                                <div
                                    class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <input style="display: none; margin-left:3%;width:20%" id="daterange"
                                        name="daterange" />
                                </div>
                                <hr class="solid">
                                <div class="table-responsive text-nowrap">
                                    <table id="adv_table" class="table table-striped table-responsive">
                                        <thead>
                                            <tr class="text-nowrap">
                                                <th class="th-color">
                                                    <?php echo $GLOBALS['strName']; ?>
                                                </th>
                                                <th class="th-color">
                                                    <?php echo $GLOBALS['view_imp']; ?>
                                                </th>

                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strImpressions']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                <?php echo $GLOBALS['device_imp']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                <?php echo $GLOBALS['mobile_imp']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strClicks']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strConversion']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['view_imp_rate']; ?> %
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strCTR']; ?> %
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strSpend']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strECPM']; ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <thead id="alltotal" style='display:none'>
                                            <tr>
                                                <th class="text-dark text-start"><?php echo $GLOBALS['over_total']; ?></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="fbody" class="fbody">
                                            <td colspan="5" id="advempty" class="text-center">
                                                <!-- <?php echo $GLOBALS['']; ?>There are currently no advertisers
                                                        defined. To create a campaign, add a new advertiser first. -->
                                            </td>
                                        </tbody>
                                        <tfoot id="foot" style="display:none">
                                            <tr id="totalall" style="display:none">
                                                <th class="text-dark text-start"><?php echo $GLOBALS['over_total']; ?></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                            <tr id="total">
                                                <th class="text-dark text-start"><?php echo $GLOBALS['total']; ?></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include ('footer.php'); ?>
                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apistatpath; ?>';
        var live_URL1 = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var agency_id = document.getElementById('agencyid').value;
        let userid = '<?php echo $_SESSION['user_id']; ?>';
        let getTodayDate;
        var permissions = [];

        function onChangeDetails() {
            $(".loader").show();
            const date = new Date();
            let getSelectedDay = document.getElementById('getCampaign').value;
            console.log("getSelectedDay", getSelectedDay);

            document.getElementById('daterange').style.display = getSelectedDay == 'custom' ? "block" : "none";

            if (getSelectedDay == 'Today') {
                let v3 = JSON.stringify(date).slice(1, 11);
                getTodayDate = v3;
                // document.getElementById('getCampaign').value ='Today';
                getCampaignDate(v3, v3);
            } else if (getSelectedDay == 'Yesterday') {
                let current_date = date.setDate(date.getDate() - 1);
                const get_date = new Date(date);
                let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                getCampaignDate(yesterday_date, yesterday_date);
            } else if (getSelectedDay == 'Last 7 days') {
                let date_start = date.setDate(date.getDate() - 7);
                let get_date = new Date(date_start);
                let first_day = JSON.stringify(get_date).slice(1, 11);

                let todayDate = new Date();
                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                const last_7Days = new Date(todayDate);
                let date_end = JSON.stringify(last_7Days).slice(1, 11);
                getCampaignDate(first_day, date_end);
            } else if (getSelectedDay == 'Last 30 days') {
                let date_start = date.setDate(date.getDate() - 30);
                let get_date = new Date(date_start);
                var first_day = JSON.stringify(get_date).slice(1, 11);

                let todayDate = new Date();
                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                const last_30Days = new Date(todayDate);
                let date_end = JSON.stringify(last_30Days).slice(1, 11);
                getCampaignDate(first_day, date_end);
            } else if (getSelectedDay == 'This Month') {
                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                let cYear = firstDay.getFullYear(),
                    cMonth = firstDay.getMonth() + 1,
                    cDate = firstDay.getDate();
                let first_day = cYear + "-" + cMonth + "-" + cDate;

                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                let year = lastDay.getFullYear(),
                    month = lastDay.getMonth() + 1,
                    day = lastDay.getDate();
                let date_end = year + "-" + month + "-" + day;
                getCampaignDate(first_day, date_end);
            } else if (getSelectedDay == 'Last Month') {
                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                var formatDateComponent = function (dateComponent) {
                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                }
                var formatDate = function (date) {
                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                };
                var start_date = formatDate(prevMonthFirstDate),
                    end_date = formatDate(prevMonthLastDate);
                getCampaignDate(start_date, end_date);
            } else if (getSelectedDay == 'all statistics') {
                getCampaignDate(start_date = 0, end_date = 0);
            } else if (getSelectedDay == 'custom') {
                $(".loader").hide();
                getCampaignDate(getTodayDate, getTodayDate);
                $(function () {
                    $('input[name="daterange"]').daterangepicker({
                        opens: 'left',
                        locale: {
                            format: 'DD/MM/YYYY'
                        },
                    }, function (start, end, label) {
                        var start_date = start.format('YYYY-MM-DD'),
                            end_date = end.format('YYYY-MM-DD');
                        getCampaignDate(start_date, end_date);
                    })
                })
            }
        };

        function getCampaignDate(start_date, end_date) {
            console.log("start_date", start_date, "end_date", end_date);
            let payload = (start_date == 0 && end_date == 0) ? {
                "action": 'all'
            } : {
                "action": '',
                "start_date": start_date + ' 00:00:00,',
                "end_date": end_date + ' 23:59:59,'
            };

            $.ajax({
                url: live_URL + '/get_agency_publisher_statistics_new/' + agency_id,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: payload,
                success: function (data) {
                    // console.log("data", data);
                    $(".loader").hide();
                    if (data.msg == 'No Stats Available' || data.msg == 'Please enter valid Advertiser Id') {
                        $("#foot").hide();
                        $('#alltotal').hide();
                        $('#adv_table').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: false,
                            bPaginate: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } else {
                        $("#foot").show();
                        $('#alltotal').show();
                        $('#adv_table').DataTable({

                            ordering: true,
                            destroy: true,
                            "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                            buttons: [{
                                extend: 'collection',
                                text: 'Export',
                                autoClose: true,
                                className: 'btn btn-warning btn-sm export',
                                buttons: [{
                                    text: 'Excel',
                                    extend: 'excel',
                                    header: true,
                                    footer: true,
                                    visible: false,
                                    "customize": function (xlsx) {
                                        var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                        $('row c', sheet).attr('s', '51'); //for all rows
                                        //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                        //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                    }
                                },
                                {
                                    text: 'PDF',
                                    extend: 'pdf',
                                    header: true,
                                    footer: true,
                                    visible: false,
                                    orientation: 'landscape',
                                    pageSize: 'LEGAL',
                                    customize: function (doc) {
                                        doc.styles.tableBodyEven.alignment = 'center';
                                        doc.styles.tableBodyOdd.alignment = 'center';
                                        doc.styles.tableFooter.alignment = 'center';
                                    },
                                }
                                ],
                                fade: true,
                            }],
                            data: data,
                            columns: [
                                // { data: 'date_time', className: "text-center" },
                                {
                                    'data': null,
                                    title: 'Name',
                                    wrap: true,
                                    className: 'tableName',
                                    "render": function (publisher) {
                                        return '<!--<i class="fa fa-user" aria-hidden="true" style="padding-left:10px;"></i>&nbsp;&nbsp;--><a href="websitereport.php?pub_id=' + publisher.publisher_id + '">' + publisher.publisher + '</a>'
                                    }
                                },
                                {
                                    data: 'views',
                                    className: "text-center"
                                },
                                {
                                    data: 'impressions',
                                    className: "text-center"
                                },
                                {
                                    data: 'desktopviews',
                                    className: "text-center"
                                },
                                {
                                    data: 'mobileviews',
                                    className: "text-center"
                                },
                                {
                                    data: 'clicks',
                                    className: "text-center"
                                },
                                {
                                    data: 'conversions',
                                    className: "text-center"
                                },
                                {
                                    data: 'viewableimpressionrate',
                                    className: "text-center",
                                    render: function (data, type, row, meta) {
                                        row.viewableimpressionrate = (row.views / row.impressions * 100).toFixed(2);
                                        return row.viewableimpressionrate == null ? "0.0000" : parseFloat(row.viewableimpressionrate).toFixed(2);
                                    }
                                },
                                {
                                    data: 'ctr',
                                    className: "text-center",
                                    render: function (data, type, row, meta) {
                                        row.ctr = (row.clicks / row.impressions * 100).toFixed(2);
                                        return row.ctr == null ? "0.0000" : parseFloat(row.ctr).toFixed(2);
                                    }
                                },
                                {
                                    data: 'revenue',
                                    className: "text-center",
                                    render: function (data, type, row, meta) {
                                        return row.revenue == null ? "0.0000" : parseFloat(row.revenue).toFixed(2);
                                    }
                                },
                                {
                                    data: 'ecpm',
                                    className: "text-center",
                                    render: function (data, type, row, meta) {
                                        row.ecpm = (row.revenue / row.impressions * 1000).toFixed(2);
                                        return row.ecpm == null ? "0.0000" : parseFloat(row.ecpm).toFixed(2);
                                    }
                                },
                            ],
                            footerCallback: function (row, data, start, end, display) {
                                var api = this.api(),
                                    data;

                                // converting to interger to find total
                                var intVal = function (i) {
                                    return typeof i === 'string' ?
                                        i.replace(/[\$,]/g, '') * 1 :
                                        typeof i === 'number' ?
                                            i : 0;
                                };

                                // computing column Total of the complete result 
                                var view_imp = api
                                    .column(1, { page: 'current' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var impressions = api
                                    .column(2, { page: 'current' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var desktop_imp = api
                                    .column(3, { page: 'current' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var mobile_imp = api
                                    .column(4, { page: 'current' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var clicks = api
                                    .column(5, { page: 'current' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var conversions = api
                                    .column(6, { page: 'current' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var revenue = api
                                    .column(9, { page: 'current' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var foot_view_imp = api
                                    .column(1, { page: 'footer' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var foot_impressions = api
                                    .column(2, { page: 'footer' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var foot_desktop_imp = api
                                    .column(3, { page: 'footer' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var foot_mobile_imp = api
                                    .column(4, { page: 'footer' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var foot_clicks = api
                                    .column(5, { page: 'footer' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var foot_conversions = api
                                    .column(6, { page: 'footer' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                var foot_revenue = api
                                    .column(9, { page: 'footer' })
                                    .data()
                                    .reduce(function (a, b) {
                                        return intVal(a) + intVal(b);
                                    }, 0);

                                // Update footer by showing the total with the reference of the column index 

                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(2)').html(view_imp);
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(3)').html(impressions);
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(4)').html(desktop_imp);
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(5)').html(mobile_imp);
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(6)').html(clicks);
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(7)').html(conversions);
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(8)').html((view_imp / impressions * 100).toFixed(2));
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(9)').html((clicks / impressions * 100).toFixed(2));
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(10)').html(revenue.toFixed(2));
                                $('#adv_table tfoot tr:nth-child(2) th:nth-child(11)').html((revenue / impressions * 1000).toFixed(2));

                                $('#adv_table #alltotal th:nth-child(2)').html(foot_view_imp);
                                $('#adv_table #alltotal th:nth-child(3)').html(foot_impressions);
                                $('#adv_table #alltotal th:nth-child(4)').html(foot_desktop_imp);
                                $('#adv_table #alltotal th:nth-child(5)').html(foot_mobile_imp);
                                $('#adv_table #alltotal th:nth-child(6)').html(foot_clicks);
                                $('#adv_table #alltotal th:nth-child(7)').html(foot_conversions);
                                $('#adv_table #alltotal th:nth-child(8)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                $('#adv_table #alltotal th:nth-child(9)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                $('#adv_table #alltotal th:nth-child(10)').html(foot_revenue.toFixed(2));
                                $('#adv_table #alltotal th:nth-child(11)').html((foot_revenue / foot_impressions * 1000).toFixed(2));

                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(2)').html(foot_view_imp);
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(3)').html(foot_impressions);
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(4)').html(foot_desktop_imp);
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(5)').html(foot_mobile_imp);
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(6)').html(foot_clicks);
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(7)').html(foot_conversions);
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(8)').html((foot_view_imp / foot_impressions * 100).toFixed(2));
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(9)').html((foot_clicks / foot_impressions * 100).toFixed(2));
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(10)').html(foot_revenue.toFixed(2));
                                $('#adv_table tfoot tr:nth-child(1) th:nth-child(11)').html((foot_revenue / foot_impressions * 1000).toFixed(2));

                            },
                            initComplete: function (settings) {
                                //settings.nTable.id --> Get table ID
                                $('#' + settings.nTable.id + '_filter input').wrap(`
                                                    <div class="d-inline-flex position-relative"></div>
                                              `).after(`
                                                    <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                      <span aria-hidden="true">&times;</span>
                                                    </button>
                                               `).attr('required', 'required').attr('title', 'Search');

                                // Click Event on Clear button
                                $(document).on('click', '#' + settings.nTable.id + '_filter button', function () {
                                    $('#' + settings.nTable.id).DataTable({
                                        "retrieve": true,
                                    }).search('').draw(); // reDraw table
                                });
                            }
                        });
                    }
                    $.ajax({
                        type: "GET",
                        url: live_URL1 + '/get_permissions/' + userid,
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function (data) {
                        console.log(data);
                        let get_data = data.data;
                        if (get_data) {
                            for (var i = 0; i < get_data.length; i++) {
                                permissions[i] = get_data[i];
                            }
                        } else {
                            permissions = '';
                        }
                        if (!permissions.includes('44')) {
                            $('.export').hide();
                        } else {
                            $('.export').show();
                        }
                    });
                },
                error: function () { },
            });
        };
    </script>
</body>

</html>