<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['adv_access']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>

    <style>
        #username,
        #password1,
        #password2 {
            width: 50%;
            display: inline;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload="getuser();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-5">
                            <div class="card-header">
                                <div class="row">
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['']; ?>Password updated successfully
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed1">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['']; ?>Password updated failed
                                    </p>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="div" id="setpassword">
                                    <div class="row">
                                        <p><b>Welcome to Revive Adserver.</b></p>
                                        <p><b>As a new user,start by setting your first password.Please make sure to
                                                select
                                                a safe and unique password.</b></p>
                                        <hr class="solid">
                                        <p><b>Enter your new password below</b></p>
                                        <hr class="solid">
                                        <div class="mb-3 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 2rem;">
                                                <?php echo $GLOBALS['']; ?>Username :
                                            </label>
                                        </div>
                                        <div class="mb-3 col-md-9">
                                            <input type="text" class="form-control" id="username" name="username"
                                                readonly>
                                        </div>

                                        <div class="mb-3 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 2rem;">
                                                <?php echo $GLOBALS['']; ?>Choose a new password :
                                            </label>
                                        </div>
                                        <div class="mb-3 col-md-9">
                                            <input type="text" class="form-control" id="password1" name="password1"
                                                placeholder="Min length 12 characters"><br>
                                            <span id="message" style="color:red"> </span>
                                        </div>

                                        <div class="mb-4 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 2rem;">
                                                <?php echo $GLOBALS['']; ?>Re-enter new password :
                                            </label>
                                        </div>
                                        <div class="mb-4 col-md-9">
                                            <input type="text" class="form-control" id="password2" name="password2"><br>
                                            <span id="message2" style="color:red"> </span>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-4">
                                            <button type="button" id="submitbtn" class="btn btn-primary submitbtn"
                                                onclick="savepassword()">
                                                <?php echo $GLOBALS['']; ?>Proceed
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div id="sentemail">
                                    <div class="row">
                                        <p class="alert alert-warning" id="alertwarning"><i class="fa-solid fa-circle-xmark"></i>
                                            <?php echo $GLOBALS['']; ?>Wrong or expired password reset link, please
                                            request a new one
                                        </p>
                                        <p><b>Enter your email address below</b></p>
                                        <hr class="solid">
                                        <div class="mb-4 col-md-2">
                                            <label for="inputName" class="col-form-label" style="margin-left: 2rem;">
                                                <?php echo $GLOBALS['']; ?>Email:
                                            </label>
                                        </div>
                                        <div class="mb-4 col-md-4">
                                            <input type="text" class="form-control" id="email" name="email"><br>
                                            <span id="message3" style="color:red"> </span>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-4">
                                            <button type="button" id="sentbtn" class="btn btn-primary submitbtn"
                                                onclick="resentmail()">
                                                <?php echo $GLOBALS['']; ?>Proceed
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- / Content -->

                <!-- Footer -->

                <?php include('footer.php'); ?>

                <!-- / Footer -->

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper , className: "text-hide" -->

    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
        var userid = '<?php echo $_REQUEST['userid']; ?>';
        $("#setpassword").hide();
        $("#sentemail").hide();

        function getuser() {

            //alert(today);
            $.ajax({
                url: live_URL + '/get_user/' + userid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    console.log(data);
                    if (data.msg == 'url link is expired') {
                        $("#setpassword").hide();
                        $("#sentemail").show();
                        $("#alertwarning").show();
                    } else {
                        $("#setpassword").show();
                        $("#sentemail").hide();
                        $("#username").val(data.username);
                    }
                },
                error: function () { },
            });
        }

        function savepassword() {
            var pw1 = document.getElementById("password1").value;
            var pw2 = document.getElementById("password2").value;
            //check empty password field
            if (pw1 == "") {
                document.getElementById("message").innerHTML = "*Fill the password please!";
                return false;
            } else {
                document.getElementById("message").innerHTML = "";
            }
            //check empty confirm password field  
            if (pw2 == "") {
                document.getElementById("message2").innerHTML = "*Fill the password please!";
                return false;
            } else {
                document.getElementById("message2").innerHTML = "";
            }
            //minimum password length validation
            if (pw1.length < 8) {
                document.getElementById("message").innerHTML = "*Password length must be atleast 8 characters";
                return false;
            } else {
                document.getElementById("message").innerHTML = "";
            }

            //maximum length of password validation
            if (pw1.length > 15) {
                document.getElementById("message").innerHTML = "*Password length must not exceed 15 characters";
                return false;
            } else {
                document.getElementById("message").innerHTML = "";
            }
            if (pw1 != pw2) {
                document.getElementById("message2").innerHTML = "*Passwords are not same";
                return false;
            }

            var username = $("#username").val();
            var password = $("#password1").val();
            var password2 = $("#password2").val();

            var formData = {
                "password": password
            };
            console.log(formData);
            $.ajax({
                url: live_URL + '/user_password/' + userid,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: formData,
            }).done(function (data) {
                console.log("aaa", data);
                if (data.msg == 'password updated successfully!') {
                    window.scrollTo(0, 0);
                    $("#alertsuccess").show('medium');
                    setTimeout(function () {
                        $("#alertsuccess").hide('medium');
                    }, 1700);
                    setTimeout(function () {
                        //window.location.href = "advertiser_access.php?clientid=<?php echo $_GET['clientid']; ?>";
                        location.reload();
                    }, 1700);
                } else {
                    window.scrollTo(0, 0);
                    $("#alertfailed").show('medium');
                    setTimeout(function () {
                        $("#alertfailed").hide('medium');
                    }, 2000);
                }
            });
        }

        function resentmail(){
            var email=document.getElementById("email").value;
        }

    </script>
</body>

</html>