<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="../assets/" data-template="vertical-menu-template-free">
  <head>
  <title><?php echo $projecttitle; ?> - Dashboard</title>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <meta name="description" content="" />
  <script src="https://code.highcharts.com/highcharts.js"></script>
  <script src="https://code.highcharts.com/modules/exporting.js"></script>
  <script src="https://code.highcharts.com/modules/export-data.js"></script>
  <script src="https://code.highcharts.com/modules/accessibility.js"></script>
  <script src="https://code.highcharts.com/modules/no-data-to-display.js"></script>
  <style>

    .tableName {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .tableName:hover {
        text-overflow: clip;
        white-space: normal;
        /* word-break: break-all; */
    }
    
    .card-title{
    color: #242626;
    }

    /* .text-hide{
    display: block;
    width: 125px;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    } */

    .tooltip {
      position: relative;
      display: inline-block;
    }

    .tooltip .tooltiptext {
      visibility: hidden;
      width: 120px;
      background-color: gray;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
    
      /* Position the tooltip */
      position: absolute;
      z-index: 1;
    }
    
    .tooltip:hover .tooltiptext {
      visibility: visible;
    }

    /* .text-hide:hover{
    overflow: inherit;
    width: auto;
    } */

    .wrapper 
    {
        width: 100%;
        display: block;
        overflow: hidden;
        margin: 0 auto;
        padding: 60px 50px;
        background: #fff;
        border-radius: 4px;
    }

    .bar_canvas {
        background: #fff;
        height: 300px;
    }
    
    
    .widgetwidth
    {
        width: 14.2% important;
    }
         
        
    @media screen and (min-width:600px) 
    {
       .widgetwidth
        {
            width: 100%;
        }
    }

    .loader
    {
        display: none;
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: 999;
        background: rgba(255,255,255,0.8) url("../assets/img/loader.gif") center no-repeat;
    }

    /* colse button */
    .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus){
       box-shadow: 0 0 5px #fff!important;
        }
        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
          -webkit-appearance: none!important;
        }
        .dataTables_wrapper .dataTables_filter button{
          visibility: hidden;
          outline: none;
        }
        .dataTables_wrapper .dataTables_filter input:valid ~ button{
          visibility: visible;
        }

        @media screen and (min-width:700px) {
            .daySelection {
                width: 38%;
                display: flex;
                justify-content: end;
            }            
        }

        @media screen and (min-width:420px) and  (max-width:699px) {
            .daySelection {
                width: 40%;
                display: flex;
                justify-content: center;
            }
            
            .main-chart {
                /* width: 200px;
                height: 400px; */
                width: auto;
                height: auto;
                margin: auto;
            }
        }

        @media screen and(min-width:220px) and (max-width:419px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }
            
            .main-chart {
                /* width: 90%; */
                /* height: 2100px; */
                width: auto;
                height: auto;
                margin: auto;
            }

            /* #myChart4{
                width: 227px;
                height: 300px;
            } */

            /* .country-chart{
                width: 100%;
                height: 600px;
            } */
        }

        @media screen and (max-width: 219px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }
            
        }

        #container1 {
            /* height: 500px;
            width: 800px; */
            height: auto;
            width: 100%;
            margin: 0 auto;
        }

        .highcharts-figure,
        .highcharts-data-table table {
            min-width: 310px;
            max-width: 800px;
            margin: 1em auto;
        }

        #container {
            height: 400px;
        }

        .highcharts-data-table table {
            font-family: Verdana, sans-serif;
            border-collapse: collapse;
            border: 1px solid #ebebeb;
            margin: 10px auto;
            text-align: center;
            width: 100%;
            max-width: 500px;
        }

        .highcharts-data-table caption {
            padding: 1em 0;
            font-size: 1.2em;
            color: #555;
        }

        .highcharts-data-table th {
            font-weight: 600;
            padding: 0.5em;
        }

        .highcharts-data-table td,
        .highcharts-data-table th,
        .highcharts-data-table caption {
            padding: 0.5em;
        }

        .highcharts-data-table thead tr,
        .highcharts-data-table tr:nth-child(even) {
            background: #f8f8f8;
        }

        .highcharts-data-table tr:hover {
            background: #f1f7ff;
        }

        .highcharts-credits {
            display: none;
        }
        /* .highcharts-title {
            display: none;
        } */
    </style>

    <?php include('head.php'); ?>
    <!--<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js"></script>-->
  </head>

  <body onload="dash_filter()">
  <div id="snip-overlay" class="snip-overlay"></div>
  <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('sidebar.php'); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('navbar.php'); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <div id="permission_page" style="display: none;"></div>
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                        <p class="h3"><?php echo $GLOBALS['strDashboard_Title']; ?></p>
                        <input type="hidden" name="clientid" id="clientid" value="<?php echo $_SESSION['clientid']; ?>">
                    </div>
                    <div class="col col-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                        <div class="mb-2 daySelection">
                            <select id="getDuration" class="form-select text-dark w-75" 
                            onchange="dash_filter()">
                                <option value="Today" selected><?php echo $GLOBALS['strToday']; ?></option>
                                <option value="Yesterday"><?php echo $GLOBALS['strYesterday']; ?></option>
                                <option value="Last 7 days"><?php echo $GLOBALS['strLast_7_days']; ?></option>
                                <option value="Last 30 days"><?php echo $GLOBALS['strLast 30 days']; ?></option>
                                <option value="Last Month"><?php echo $GLOBALS['strLast Month']; ?></option>
                                <option value="This Month"><?php echo $GLOBALS['strThis Month']; ?></option>
                                <option value='all statistics'><?php echo $GLOBALS['strAll Statistics']; ?></option>
                                <option value="custom"><?php echo $GLOBALS['strCustom']; ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                    <input  style="display: none; margin-left:3%" id="daterange" name="daterange"/>
                </div>

                <!-- weights-->
                <div class="row mt-3">
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2 ">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="fa  fa-podcast  fa-2x text-warning"  aria-hidden="true"></i>
                                <span class="fw-semibold d-block card-title  h6 mt-2 mb-2"><?php echo $GLOBALS['strRequests']; ?></span>
                                <h3 class="card-title mb-1" id="req">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="fa fa-arrows-to-eye  fa-2x text-warning" aria-hidden="true"></i>
                                <span class="fw-semibold d-block card-title h6 mt-2 mb-2"><?php echo $GLOBALS['view_impr']; ?></span>
                                <h3 class="card-title  mb-1" id="view_imp">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="fa fa-external-link  fa-2x text-warning" aria-hidden="true"></i>
                                <span class="fw-semibold d-block card-title h6 mt-2 mb-2"><?php echo $GLOBALS['impr']; ?></span>
                                <h3 class="card-title  mb-1" id="imp">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="fa fa-hand-pointer-o  fa-2x text-warning" aria-hidden="true"></i>
                                <span class="fw-semibold d-block  card-title h6 mt-2 mb-2"><?php echo $GLOBALS['strClicks']; ?></span>
                                <h3 class="card-title text-nowrap mb-1" id="cli">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="fa fa-credit-card-alt fa-2x text-warning" aria-hidden="true"></i>
                                <span class="fw-semibold d-block card-title h6 mt-2 mb-2"><?php echo $GLOBALS['strConversion']; ?></span>
                                <h3 class="card-title mb-1" id="con">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="menu-icon tf-icons bx bx-user fa-2x text-warning" aria-hidden="true"></i>
                                <span class="fw-semibold d-block card-title h6 mt-2 mb-2"><?php echo $GLOBALS['agency_advertiser']; ?></span>
                                <h3 class="card-title mb-1" id="advertiser">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="menu-icon tf-icons bx bx-user fa-2x text-warning" aria-hidden="true"></i>
                                <span class="fw-semibold d-block card-title h6 mt-2 mb-2"><?php echo $GLOBALS['publishers']; ?></span>
                                <h3 class="card-title mb-1" id="publisher">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col col-12 col-sm-6 col-md-6 col-lg-4 col-xl-2 col-xxl-2">
                        <div class="card mb-2">
                            <div class="card-body text-center">
                                <i class="menu-icon tf-icons bx bx-globe fa-2x text-warning" aria-hidden="true"></i>
                                <span class="fw-semibold d-block card-title h6 mt-2 mb-2"><?php echo $GLOBALS['websites']; ?></span>
                                <h3 class="card-title mb-1" id="website">0</h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Campaign Chart -->
                <div class="card mt-2 mb-3">
                    <div class='card-body'>
                        <div class="d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                            <h5 class= "mt-2 mt-sm-2 mt-md-4 mt-lg-4 mt-xl-4 mt-xxl-4 me-2 pb-3"><?php echo $GLOBALS['performance_overview']; ?></h5>
                        </div>
                        <div class='container main-chart' style="overflow:scroll;">
                            <figure class="highcharts-figure">
                                <div id="container"></div>
                            </figure>
                        </div>
                    </div>
                </div>

                <!-- <div> -->
                    <div class="row d-flex justify-content-center" >
                        <!-- Top Campaigns style="margin-top: -10px;" -->
                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3 mb-sm-3 mb-md-2 mb-lg-2 mb-xl-2 mb-xxl-2">
                            <div class="card" style='height: 94%'>
                                <div class="card-body table-responsive">
                                    <p class="h4 d-flex justify-content-center justify-content-sm-start justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start"><?php echo $GLOBALS['strTopAdvertiser']; ?></p>
                                    <table id="top_campaign" class="table table-hover table-striped table-responsive mt-3">
                                        <thead>
                                            <tr>
                                                <th class="th-color text-center"><?php echo $GLOBALS['strName']; ?></th>
                                                 <th class="text-center"><?php echo $GLOBALS['view_impr']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['impr']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strClicks']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strCTR']; ?>&nbsp;%</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="campaign_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Top Banner -->
                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3 mb-sm-3 mb-md-2 mb-lg-2 mb-xl-2 mb-xxl-2">
                            <div class="card mb-4" style='height: 94%'>
                                <div class="card-body table-responsive">
                                    <p class="h4 d-flex justify-content-center justify-content-sm-start justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start"><?php echo $GLOBALS['strTopWebsite']; ?></p>
                                    <table id="top_banner" class="table table-hover table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th><?php echo $GLOBALS['strName']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['view_impr']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['impr']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strClicks']; ?></th>
                                                <th class="text-center"><?php echo $GLOBALS['strCTR']; ?>&nbsp;%</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-center" id="banner_table"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Top Country -->
                    <!-- <div class="card mb-4">
                        <div class="card-body table-responsive">
                            <div class="row">
                                <div class="col col-12 col-sm-12 col-md-5 col-lg-6 col-xl-6 col-xxl-6">
                                   
                                        <div class='table-responsive'>
                                            <p class="h4 d-flex justify-content-center justify-content-sm-start justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start"><?php echo $GLOBALS['strTopCountry']; ?></p>
                                            <table id="top_country" class="table table-hover table-striped mt-3">
                                                <thead>
                                                    <tr>
                                                        <th><?php echo $GLOBALS['strName']; ?></th>
                                                        <th class="text-center"><?php echo $GLOBALS['strImpression']; ?></th>
                                                        <th class="text-center"><?php echo $GLOBALS['strClicks']; ?></th>
                                                        <th class="text-center"><?php echo $GLOBALS['strSpend']; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody class="text-center" id='country_table'></tbody>
                                            </table>
                                        </div>
                                    
                                </div>
                                <div class="col col-12 col-sm-12 col-md-7 col-lg-6 col-xl-6 col-xxl-6">
                                    
                                            <div class="wrapper">
                                                <canvas id="myChart4" class="bar_canvas" style="width: 100%; height:50dvh;"></canvas>
                                                    <script>
                                                        function biChangeChart(country_name, imp, click_value) {
                                                            $(".loader").hide();
                                                            var ctx = document.getElementById("myChart4").getContext('2d');
                                                            if (window.bar != undefined)
                                                    window.bar.destroy();

                                                window.bar = new Chart(ctx, {
                                                    type: 'bar',
                                                    data: {
                                                        labels: country_name,
                                                        datasets: [{
                                                            label: `<?php echo $GLOBALS['strImpression']; ?>`,
                                                            backgroundColor: "#03c3ec",
                                                            data: imp
                                                        }, {
                                                            label: `<?php echo $GLOBALS['strClicks']; ?>`,
                                                            backgroundColor: "#007bff",
                                                            data: click_value
                                                        }],
                                                    },
                                                    options: {
                                                        tooltips: {
                                                            displayColors: true,
                                                            callbacks: {
                                                                mode: 'x',
                                                            },
                                                        },
                                                        scales: {
                                                            xAxes: [{
                                                                stacked: true,
                                                                gridLines: {
                                                                    display: false,
                                                                },
                                                                ticks: {
                                                                    callback: function (label) {
                                                                        if (/\s/.test(label)) {
                                                                            return label.split(" ");
                                                                        }
                                                                        else {
                                                                            return label;
                                                                        }
                                                                    },
                                                                    maxRotation: 90,
                                                                    minRotation: 90
                                                                }
                                                            }],
                                                            yAxes: [{
                                                                stacked: true,
                                                                // ticks: {
                                                                //     beginAtZero: true,
                                                                //     min: 0,
                                                                //     max: 1000,
                                                                //     stepSize: 100
                                                                // },
                                                                type: 'linear',
                                                            }]
                                                        },
                                                        responsive: true,
                                                        maintainAspectRatio: false,
                                                        legend: { position: 'top' },
                                                    }
                                                });
                                            };
                                        </script>
                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> -->
                <!-- </div> -->
            </div>
            <!-- / Content -->
        <?php include('footer.php'); ?>
        
        <!-- <script src="../assets/js/config.js"></script> -->
        <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>
      <script>
        const live_URL = '<?php echo $apistatpath; ?>';
        const token = 'Bearer ' + document.getElementById('token').value;
        let agency_id = document.getElementById('agencyid').value, get_todayDate;
        //API's
        let campaign_url = live_URL + '/get_agency_campaign_graph_statistics/';
        let widgets_url = live_URL + '/get_agency_campaign_statistics/';
        // let topCampaign_url = live_URL + '/get_agency_top_campaign_statistics/';
        let topAdvertiser = live_URL + '/get_agency_top_advertiser_statistics/';
        // let topBanner_url = live_URL + '/get_agency_top_banner_statistics/';
        let topWebsite_url = live_URL + '/get_agency_top_website_statistics/';
        let topCountry_url = live_URL + '/get_agency_top_country_details/';
        let advertiser_website_url = live_URL + '/get_agency_advertiser_website_statistics/';

        function dash_filter() {
            $(".loader").show();
            const date = new Date();
            let filtervalue = document.getElementById('getDuration').value;

            document.getElementById("daterange").style.display = filtervalue == 'custom' ? "block" : "none";

            if (filtervalue == 'Today') {
                let v3 = JSON.stringify(date).slice(1, 11);
                get_todayDate = v3;
                getDashboardDay(v3, v3);
            }
            else if (filtervalue == 'Yesterday') {
                let current_date = date.setDate(date.getDate() - 1);
                const get_date = new Date(date);
                let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                getDashboardDay(yesterday_date, yesterday_date);
            }
            else if (filtervalue == 'Last 7 days') {
                let date_start = date.setDate(date.getDate() - 7);
                let get_date = new Date(date_start);
                let first_day = JSON.stringify(get_date).slice(1, 11);
                first_day = first_day

                let todayDate = new Date();
                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                let last_7Days = new Date(todayDate);
                let date_end = JSON.stringify(last_7Days).slice(1, 11);
                getDashboardDay(first_day, date_end);
            }
            else if (filtervalue == 'Last 30 days') {
                let date_start = date.setDate(date.getDate() - 30);
                let get_date = new Date(date_start);
                var first_day = JSON.stringify(get_date).slice(1, 11);

                let todayDate = new Date();
                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                let last_30Days = new Date(todayDate);
                let date_end = JSON.stringify(last_30Days).slice(1, 11);
                getDashboardDay(first_day, date_end);
            }
            else if (filtervalue == 'This Month') {
                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                let cDate = firstDay.getDate(), cMonth = firstDay.getMonth() + 1, cYear = firstDay.getFullYear();
                let first_day = cYear + "-" + cMonth + "-" + cDate;

                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                let year = lastDay.getFullYear(), month = lastDay.getMonth() + 1, day = lastDay.getDate();
                let date_end = year + "-" + month + "-" + day;
                getDashboardDay(first_day, date_end);
            }
            else if (filtervalue == 'Last Month') {
                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                var formatDateComponent = function (dateComponent) {
                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                }
                var formatDate = function (date) {
                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                };
                var start_date = formatDate(prevMonthFirstDate), end_date = formatDate(prevMonthLastDate);
                getDashboardDay(start_date, end_date);
            }
            else if (filtervalue == 'all statistics') {
                getDashboardDay(start_date = 0, end_date = 0);
            }
            else if (filtervalue == 'custom') {
                $(".loader").hide();
                let getCurrentDate = JSON.stringify(date).slice(1, 11);
                console.log("getCurrentDate", getCurrentDate);
                getDashboardDay(getCurrentDate, getCurrentDate);
                var start_date, end_date;
                $(function () {
                    $('input[name="daterange"]').daterangepicker({
                        opens: 'left',
                        locale: {
                            format: 'DD/MM/YYYY'
                        }
                    }, function (start, end, label) {
                        start_date = start.format('YYYY-MM-DD'), end_date = end.format('YYYY-MM-DD');
                        localStorage.setItem("custom_startDate", start_date);
                        localStorage.setItem("custom_endDate", end_date);
                        getDashboardDay(start_date, end_date);
                    })
                });
                start_date != 'undefined' ? testChart(campaignName = [], campaignDate = [], ImpressionValue = [], clickValue = [],
                    conversionsValue = [], revenueValue = [], ctrValue = [],
                    ecpmValue = []) : "0";
                // document.getElementById("zoomButton").disabled = true;
            }
        };

        function getDashboardDay(startDate, endDate) {
            let getDay = document.getElementById('getDuration').value;
            let getCustom_startDate = localStorage.getItem("custom_startDate");
            let getCustom_endDate = localStorage.getItem("custom_endDate");
            let payload;

            if (getDay == "custom") {
                // startDate = getCustom_startDate; endDate = getCustom_endDate;
                startDate = startDate; endDate = endDate;
            }
            else {
                startDate = startDate; endDate = endDate;
                localStorage.setItem("custom_startDate", get_todayDate);
                localStorage.setItem("custom_endDate", get_todayDate);
            }

            payload = (startDate == 0 && endDate == 0) ? { "action": 'all' } :
                { "action": '', "start_date": startDate + ' 00:00:00,', "end_date": endDate + ' 23:59:59,' };

            // Campaign Chart Start
            $.ajax({
                url: campaign_url + agency_id,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: payload,
                success: function (data) {
                    if (data.msg == 'No Stats Available') {
                        testChart(campaignName = [], campaignDate = [], ImpressionValue = [], clickValue = [],
                            conversionsValue = [], revenueValue = [], ctrValue = [],
                            ecpmValue = []);
                    }
                    else {
                        $(".loader").show();

                        let campaignName = data.map((data) => {
                            return data.campaignname;
                        });

                        let campaignDate = data.map((data) => {
                            return data.date;
                        })

                        let ImpressionValue = data.map((data, index) => {
                            if (data.impressions == null) {
                                return data.impressions = 0;
                            }
                            else {
                                return parseInt(data.impressions);
                            }
                        });

                        let clickValue = data.map((data) => {
                            if (data.clicks == null) {
                                return data.clicks = 0;
                            }
                            else {
                                return parseInt(data.clicks);
                            }
                        });

                        var conversionsValue = data.map((data) => {
                            if (data.conversions == null) {
                                return data.conversions = 0;
                            }
                            else {
                                return parseInt(data.conversions);
                            }
                        });

                        var viewsValue = data.map((data) => {
                            if (data.views == null) {
                                return data.views = 0;
                            }
                            else {
                                return parseInt(data.views);
                            }
                        });

                        var revenueValue = data.map((value, index) => {
                            // let convert = parseInt(value.revenue, 10);
                            if (value.revenue == null) {
                                return value.revenue = 0;
                            }
                            else {
                                return value.revenue;
                            }
                        });

                        var ctrValue = data.map((data, index) => {
                            if (data.ctr == null) {
                                return data.ctr = 0;
                            }
                            else {
                                return data.ctr;
                            }
                        });

                        var ecpmValue = data.map((data, index) => {
                            if (data.ecpm == null) {
                                return data.ecpm = 0;
                            }
                            else {
                                return data.ecpm;
                            }
                        });

                        testChart(campaignName, campaignDate, ImpressionValue, clickValue, conversionsValue, viewsValue, revenueValue, ctrValue, ecpmValue);
                    }
                },
                error: function () { },
            });
            // Campaign Chart End

            // Start impression, click, request and conversion
            $.ajax({
                url: widgets_url + agency_id,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: payload,
                success: function (data) {
                    //$('#hmm').html(data);
                    // console.log("data", data);
                    $(".loader").hide();
                    if (data.msg == 'No Stats Available') {
                        document.getElementById('req').innerHTML = 0;
                        document.getElementById('imp').innerHTML = 0;
                        document.getElementById('cli').innerHTML = 0;
                        document.getElementById('con').innerHTML = 0;
                        document.getElementById('view_imp').innerHTML = 0;
                        // document.getElementById('advertiser').innerHTML =0;
                        // document.getElementById('website').innerHTML = 0;
                    }
                    else {
                        const entries = Object.values(data);
                        document.getElementById('req').innerHTML = (entries[0]['requests'] == null) ? 0 : Number(data[0].requests).toLocaleString("en-US");
                        document.getElementById('imp').innerHTML = (entries[0]['impressions'] == null) ? 0 : Number(data[0].impressions).toLocaleString("en-US");
                        document.getElementById('view_imp').innerHTML = (entries[0]['views'] == null) ? 0 : Number(data[0].views).toLocaleString("en-US");
                        document.getElementById('cli').innerHTML = (entries[0]['clicks'] == null) ? 0 : Number(data[0].clicks).toLocaleString("en-US");
                        document.getElementById('con').innerHTML = (entries[0]['conversions'] == null) ? 0 : Number(data[0].conversions).toLocaleString("en-US");
                        // document.getElementById('advertiser').innerHTML = (entries[0]['advertisercount'] == 0)?0:Number(data[0].advertisercount).toLocaleString("en-IN");
                        // document.getElementById('website').innerHTML = (entries[0]['websitecount'] == 0)?0:Number(data[0].websitecount).toLocaleString("en-IN");
                    }
                },
                error: function () { },
            });
            // End impression, click, request and conversion

            //advertiser and website
            $.ajax({
                url: advertiser_website_url + agency_id,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: [],
                success: function (data) {
                    //$('#hmm').html(data);
                    // console.log("data", data);
                    $(".loader").hide();
                    if (data.msg == 'No Stats Available') {
                        document.getElementById('advertiser').innerHTML = 0;
                        document.getElementById('website').innerHTML = 0;
                        document.getElementById('publisher').innerHTML = 0;
                    }
                    else {
                        const entries = Object.values(data);
                        document.getElementById('advertiser').innerHTML = (entries[0]['advertisercount'] == 0) ? 0 : Number(data[0].advertisercount).toLocaleString("en-US");
                        document.getElementById('publisher').innerHTML = (entries[0]['publishercount'] == 0) ? 0 : Number(data[0].publishercount).toLocaleString("en-US");
                        document.getElementById('website').innerHTML = (entries[0]['websitecount'] == 0) ? 0 : Number(data[0].websitecount).toLocaleString("en-US");
                    }
                },
                error: function () { },
            });

            // Top Campaign Start
            $.ajax({
                url: topAdvertiser + agency_id,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: payload,
                success: function (data) {
                    console.log("advertiser", data);
                    $(".loader").hide();
                    if (data.msg == 'No Stats Available' || data.msg == 'Please enter valid Agency Id') {
                        document.getElementById('campaign_table').innerHTML = `<tr><td colspan="5"><?php echo $GLOBALS['strNo_Data_Meassages']; ?></td></tr>`;
                    }
                    else {
                        var getCamData = "";
                        data.map((data, index) => {
                            if (data.spend == null) { var spend = 0.00; }
                            else { var spend = data.spend; }
                            getCamData += `<tr key=${index}>
                                                 <td class="text-start tableName">${data.clientname}</td>
                                                 <td>${Number(data.views).toLocaleString("en-US")}</td>
                                                 <td>${Number(data.impressions).toLocaleString("en-US")}</td>
                                                 <td>${Number(data.clicks).toLocaleString("en-US")}</td>
                                                 <td>${Number(data.ctr).toLocaleString("en-US")}</td>
                                             </tr>`
                        });
                        document.getElementById('campaign_table').innerHTML = getCamData;
                    }
                },
                error: function () { },
            });
            // End Top Campaign

            // Start Top Banner
            $.ajax({
                url: topWebsite_url + agency_id,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: payload,
                success: function (data) {
                    $(".loader").hide();
                    let getBanData = "";

                    if (data.msg == 'No Stats Available' || data.msg == 'Please enter valid Advertiser Id') {
                        document.getElementById('banner_table').innerHTML = `<tr><td colspan="5"><?php echo $GLOBALS['strNo_Data_Meassages']; ?></td></tr>`;
                    }
                    else {
                        data.map((data, index) => {
                            let spend = data.spend == null ? 0.00 : data.spend;
                            getBanData += `<tr key=${index}>
                                                    <td class='text-start tableName'>${data.websitename}</td>
                                                    <td>${Number(data.views).toLocaleString("en-US")}</td>
                                                    <td>${Number(data.impressions).toLocaleString("en-US")}</td>
                                                    <td>${Number(data.clicks).toLocaleString("en-US")}</td>
                                                    <td>${Number(data.ctr).toLocaleString("en-US")}</td>
                                                </tr>`;
                        });
                        document.getElementById('banner_table').innerHTML = getBanData;
                    }
                },
                error: function () { },
            });
                // End Top Banner

                // Start Top Country
                /*$.ajax({
                    url: topCountry_url + agency_id,
                    type: 'POST',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: payload,
                    success: function (data) {
                        if (data.msg == 'No Stats Available') {
                            document.getElementById('country_table').innerHTML = `<tr><td colspan="5"><?php echo $GLOBALS['strNo_Data_Meassages']; ?></td ></tr > `;
                            biChangeChart(v1 = [], imp = [], click_value = []);
                        }
                        else {
                            $(".loader").show();
                            let countryData = "";
                            data.map((data, index) => {
                                let spend = data.revenue == null?0.00:data.revenue;
                                countryData += `< tr key = 'index' >
                                    <td class='text-start'>${data.countryname}</td>
                                                <td>${Number(data.impressions).toLocaleString("en-IN")}</td>
                                                <td>${Number(data.clicks).toLocaleString("en-IN")}</td>
                                                <td>`+spend+`</td>
                                                    </ >`
                            });
                            document.getElementById('country_table').innerHTML = countryData;
                              
                            let countryName = data.map((data) => {
                                return data.countryname;
                            });

                            let impressionValue = data.map((data) => {
                                return data.impressions;
                            });

                            let clickValue = data.map((data) => {
                                return data.clicks;
                            });

                            biChangeChart(countryName, impressionValue, clickValue);
                        }
                    },
                    error: function () { },
                });*/
                // End Top Country
            };

            //Campaign chart function
            function testChart(campaignName,campaignDate, ImpressionValue, clickValue, conversionsValue, viewsValue, revenueValue, ctrValue, ecpmValue) {
                $(".loader").hide();
                                                    
                Highcharts.chart('container', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: '',
                        align: 'center'
                    },
                    xAxis: {
                        categories: campaignDate,
                        labels: {
                            rotation: 90
                        }
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: 'Count'
                        },
                        stackLabels: {
                            enabled: false
                        }
                    },
                    legend: {
                        align: 'left',
                        x: 60,
                        verticalAlign: 'top',
                        y: -10,
                        floating: true,
                        backgroundColor: Highcharts.defaultOptions.legend.backgroundColor || 'white',
                        borderColor: '#CCC',
                        borderWidth: 1,
                        shadow: false
                    },
                    tooltip: {
                        headerFormat: '<b>{point.x}</b><br/>',
                        pointFormat: '{series.name}: {point.y}<br/>Total: {point.stackTotal}'
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            dataLabels: {
                                enabled: true
                            }
                        }
                    },
                    series: [{
                        name: '<?php echo $GLOBALS['strImpressions']; ?>',
                        data: ImpressionValue.length == 0?[]:ImpressionValue
                    }, {
                        name: '<?php echo $GLOBALS['strClicks']; ?>',
                        data:clickValue.length == 0?[]:clickValue
                    }, {
                        name: '<?php echo $GLOBALS['strConversions']; ?>',
                        data: conversionsValue.length == 0?[]:conversionsValue
                    }, {
                        name: '<?php echo $GLOBALS['view_imp']; ?>',
                        data: viewsValue.length == 0?[]:viewsValue
                    }],
                    lang: {
                        noData: '<?php echo $GLOBALS['strNo_Data_Meassages']; ?>'
                    },
                    noData: {
                        style: {
                            fontWeight: 'bold',
                            fontSize: '15px',
                            color: '#303030'
                        }
                    },
                    responsive: {
                      rules: [{
                        condition: {
                          maxWidth: 500
                        },
                        chartOptions: {
                          legend: {
                            enabled: false
                          }
                        }
                      }]
                    }
                });
            };
    </script>
  </body>
</html>